/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.storage.loot;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.server.ServerWorld;
import net.minecraft.world.storage.loot.LootParameter;
import net.minecraft.world.storage.loot.LootParameterSet;
import net.minecraft.world.storage.loot.LootParameters;
import net.minecraft.world.storage.loot.LootTable;
import net.minecraft.world.storage.loot.LootTableManager;

public class LootContext {
    private final Random field_216035_a;
    private final float field_186498_a;
    private final ServerWorld field_186499_b;
    private final LootTableManager field_186500_c;
    private final Set<LootTable> field_186504_g = Sets.newLinkedHashSet();
    private final Map<LootParameter<?>, Object> field_216036_f;
    private final Map<ResourceLocation, IDynamicDropProvider> field_216037_g;

    private LootContext(Random random, float f, ServerWorld serverWorld, LootTableManager lootTableManager, Map<LootParameter<?>, Object> map, Map<ResourceLocation, IDynamicDropProvider> map2) {
        this.field_216035_a = random;
        this.field_186498_a = f;
        this.field_186499_b = serverWorld;
        this.field_186500_c = lootTableManager;
        this.field_216036_f = ImmutableMap.copyOf(map);
        this.field_216037_g = ImmutableMap.copyOf(map2);
    }

    public boolean func_216033_a(LootParameter<?> lootParameter) {
        return this.field_216036_f.containsKey(lootParameter);
    }

    public void func_216034_a(ResourceLocation resourceLocation, Consumer<ItemStack> consumer) {
        IDynamicDropProvider iDynamicDropProvider = this.field_216037_g.get(resourceLocation);
        if (iDynamicDropProvider != null) {
            iDynamicDropProvider.add(this, consumer);
        }
    }

    @Nullable
    public <T> T func_216031_c(LootParameter<T> lootParameter) {
        return (T)this.field_216036_f.get(lootParameter);
    }

    public boolean func_186496_a(LootTable lootTable) {
        return this.field_186504_g.add(lootTable);
    }

    public void func_186490_b(LootTable lootTable) {
        this.field_186504_g.remove(lootTable);
    }

    public LootTableManager func_186497_e() {
        return this.field_186500_c;
    }

    public Random func_216032_b() {
        return this.field_216035_a;
    }

    public float func_186491_f() {
        return this.field_186498_a;
    }

    public ServerWorld func_202879_g() {
        return this.field_186499_b;
    }

    public static enum EntityTarget {
        THIS("this", LootParameters.field_216281_a),
        KILLER("killer", LootParameters.field_216284_d),
        DIRECT_KILLER("direct_killer", LootParameters.field_216285_e),
        KILLER_PLAYER("killer_player", LootParameters.field_216282_b);

        private final String field_186488_d;
        private final LootParameter<? extends Entity> field_216030_f;

        private EntityTarget(String string2, LootParameter<? extends Entity> lootParameter) {
            this.field_186488_d = string2;
            this.field_216030_f = lootParameter;
        }

        public LootParameter<? extends Entity> func_216029_a() {
            return this.field_216030_f;
        }

        public static EntityTarget func_186482_a(String string2) {
            String string2;
            for (EntityTarget entityTarget : EntityTarget.values()) {
                if (!entityTarget.field_186488_d.equals(string2)) continue;
                return entityTarget;
            }
            throw new IllegalArgumentException("Invalid entity target " + string2);
        }

        public static class Serializer
        extends TypeAdapter<EntityTarget> {
            public void write(JsonWriter jsonWriter, EntityTarget entityTarget) throws IOException {
                jsonWriter.value(entityTarget.field_186488_d);
            }

            public EntityTarget read(JsonReader jsonReader) throws IOException {
                return EntityTarget.func_186482_a(jsonReader.nextString());
            }

            public /* synthetic */ Object read(JsonReader jsonReader) throws IOException {
                return this.read(jsonReader);
            }

            public /* synthetic */ void write(JsonWriter jsonWriter, Object object) throws IOException {
                this.write(jsonWriter, (EntityTarget)((Object)object));
            }
        }
    }

    public static class Builder {
        private final ServerWorld field_186474_a;
        private final Map<LootParameter<?>, Object> field_216025_b = Maps.newIdentityHashMap();
        private final Map<ResourceLocation, IDynamicDropProvider> field_216026_c = Maps.newHashMap();
        private Random field_216027_d;
        private float field_186475_b;

        public Builder(ServerWorld serverWorld) {
            this.field_186474_a = serverWorld;
        }

        public Builder func_216023_a(Random random) {
            this.field_216027_d = random;
            return this;
        }

        public Builder func_216016_a(long l) {
            if (l != 0L) {
                this.field_216027_d = new Random(l);
            }
            return this;
        }

        public Builder func_216020_a(long l, Random random) {
            this.field_216027_d = l == 0L ? random : new Random(l);
            return this;
        }

        public Builder func_186469_a(float f) {
            this.field_186475_b = f;
            return this;
        }

        public <T> Builder func_216015_a(LootParameter<T> lootParameter, T t) {
            this.field_216025_b.put(lootParameter, t);
            return this;
        }

        public <T> Builder func_216021_b(LootParameter<T> lootParameter, @Nullable T t) {
            if (t == null) {
                this.field_216025_b.remove(lootParameter);
            } else {
                this.field_216025_b.put(lootParameter, t);
            }
            return this;
        }

        public Builder func_216017_a(ResourceLocation resourceLocation, IDynamicDropProvider iDynamicDropProvider) {
            \u2603 = this.field_216026_c.put(resourceLocation, iDynamicDropProvider);
            if (\u2603 != null) {
                throw new IllegalStateException("Duplicated dynamic drop '" + this.field_216026_c + "'");
            }
            return this;
        }

        public ServerWorld func_216018_a() {
            return this.field_186474_a;
        }

        public <T> T func_216024_a(LootParameter<T> lootParameter) {
            Object object = this.field_216025_b.get(lootParameter);
            if (object == null) {
                throw new IllegalArgumentException("No parameter " + lootParameter);
            }
            return (T)object;
        }

        @Nullable
        public <T> T func_216019_b(LootParameter<T> lootParameter) {
            return (T)this.field_216025_b.get(lootParameter);
        }

        public LootContext func_216022_a(LootParameterSet lootParameterSet) {
            Sets.SetView setView = Sets.difference(this.field_216025_b.keySet(), lootParameterSet.func_216276_b());
            if (!setView.isEmpty()) {
                throw new IllegalArgumentException("Parameters not allowed in this parameter set: " + setView);
            }
            \u2603 = Sets.difference(lootParameterSet.func_216277_a(), this.field_216025_b.keySet());
            if (!\u2603.isEmpty()) {
                throw new IllegalArgumentException("Missing required parameters: " + \u2603);
            }
            Random \u26032 = this.field_216027_d;
            if (\u26032 == null) {
                \u26032 = new Random();
            }
            return new LootContext(\u26032, this.field_186475_b, this.field_186474_a, this.field_186474_a.func_73046_m().func_200249_aQ(), this.field_216025_b, this.field_216026_c);
        }
    }

    @FunctionalInterface
    public static interface IDynamicDropProvider {
        public void add(LootContext var1, Consumer<ItemStack> var2);
    }
}

