/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.storage;

import com.google.common.collect.Lists;
import com.mojang.datafixers.DataFixer;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.format.SignStyle;
import java.time.temporal.ChronoField;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.annotation.Nullable;
import net.minecraft.client.AnvilConverterException;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.FileUtil;
import net.minecraft.util.IProgressUpdate;
import net.minecraft.util.datafix.DefaultTypeReferences;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.storage.AnvilSaveConverter;
import net.minecraft.world.storage.SaveHandler;
import net.minecraft.world.storage.WorldInfo;
import net.minecraft.world.storage.WorldSummary;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SaveFormat {
    private static final Logger field_215785_a = LogManager.getLogger();
    private static final DateTimeFormatter field_197716_d = new DateTimeFormatterBuilder().appendValue(ChronoField.YEAR, 4, 10, SignStyle.EXCEEDS_PAD).appendLiteral('-').appendValue(ChronoField.MONTH_OF_YEAR, 2).appendLiteral('-').appendValue(ChronoField.DAY_OF_MONTH, 2).appendLiteral('_').appendValue(ChronoField.HOUR_OF_DAY, 2).appendLiteral('-').appendValue(ChronoField.MINUTE_OF_HOUR, 2).appendLiteral('-').appendValue(ChronoField.SECOND_OF_MINUTE, 2).toFormatter();
    private final Path field_215786_c;
    private final Path field_215787_d;
    private final DataFixer field_215788_e;

    public SaveFormat(Path path, Path path2, DataFixer dataFixer) {
        this.field_215788_e = dataFixer;
        try {
            Files.createDirectories(Files.exists(path, new LinkOption[0]) ? path.toRealPath(new LinkOption[0]) : path, new FileAttribute[0]);
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
        this.field_215786_c = path;
        this.field_215787_d = path2;
    }

    public String func_207741_a() {
        return "Anvil";
    }

    public List<WorldSummary> func_75799_b() throws AnvilConverterException {
        if (!Files.isDirectory(this.field_215786_c, new LinkOption[0])) {
            throw new AnvilConverterException(new TranslationTextComponent("selectWorld.load_folder_access", new Object[0]).getString());
        }
        ArrayList arrayList = Lists.newArrayList();
        for (File file : \u2603 = this.field_215786_c.toFile().listFiles()) {
            if (!file.isDirectory() || (\u2603 = this.func_75803_c(\u2603 = file.getName())) == null || \u2603.func_76088_k() != 19132 && \u2603.func_76088_k() != 19133) continue;
            boolean bl = \u2603.func_76088_k() != this.func_215782_e();
            String \u26032 = \u2603.func_76065_j();
            if (StringUtils.isEmpty((CharSequence)\u26032)) {
                \u26032 = \u2603;
            }
            long \u26033 = 0L;
            arrayList.add(new WorldSummary(\u2603, \u2603, \u26032, 0L, bl));
        }
        return arrayList;
    }

    private int func_215782_e() {
        return 19133;
    }

    public SaveHandler func_197715_a(String string, @Nullable MinecraftServer minecraftServer) {
        return SaveFormat.func_215783_a(this.field_215786_c, this.field_215788_e, string, minecraftServer);
    }

    protected static SaveHandler func_215783_a(Path path, DataFixer dataFixer, String string, @Nullable MinecraftServer minecraftServer) {
        return new SaveHandler(path.toFile(), string, minecraftServer, dataFixer);
    }

    public boolean func_75801_b(String string) {
        WorldInfo worldInfo = this.func_75803_c(string);
        return worldInfo != null && worldInfo.func_76088_k() != this.func_215782_e();
    }

    public boolean func_75805_a(String string, IProgressUpdate iProgressUpdate) {
        return AnvilSaveConverter.func_215792_a(this.field_215786_c, this.field_215788_e, string, iProgressUpdate);
    }

    @Nullable
    public WorldInfo func_75803_c(String string) {
        return SaveFormat.func_215779_a(this.field_215786_c, this.field_215788_e, string);
    }

    @Nullable
    protected static WorldInfo func_215779_a(Path path, DataFixer dataFixer, String string) {
        File file = new File(path.toFile(), string);
        if (!file.exists()) {
            return null;
        }
        \u2603 = new File(file, "level.dat");
        if (\u2603.exists() && (\u2603 = SaveFormat.func_215780_a(\u2603, dataFixer)) != null) {
            return \u2603;
        }
        \u2603 = new File(file, "level.dat_old");
        if (\u2603.exists()) {
            return SaveFormat.func_215780_a(\u2603, dataFixer);
        }
        return null;
    }

    @Nullable
    public static WorldInfo func_215780_a(File file, DataFixer dataFixer) {
        try {
            CompoundNBT compoundNBT = CompressedStreamTools.func_74796_a(new FileInputStream(file));
            \u2603 = compoundNBT.func_74775_l("Data");
            \u2603 = \u2603.func_150297_b("Player", 10) ? \u2603.func_74775_l("Player") : null;
            \u2603.func_82580_o("Player");
            int \u26032 = \u2603.func_150297_b("DataVersion", 99) ? \u2603.func_74762_e("DataVersion") : -1;
            return new WorldInfo(NBTUtil.func_210822_a(dataFixer, DefaultTypeReferences.LEVEL, \u2603, \u26032), dataFixer, \u26032, \u2603);
        }
        catch (Exception exception) {
            field_215785_a.error("Exception reading {}", (Object)file, (Object)exception);
            return null;
        }
    }

    public void func_75806_a(String string, String string2) {
        File file = new File(this.field_215786_c.toFile(), string);
        if (!file.exists()) {
            return;
        }
        \u2603 = new File(file, "level.dat");
        if (\u2603.exists()) {
            try {
                CompoundNBT compoundNBT = CompressedStreamTools.func_74796_a(new FileInputStream(\u2603));
                \u2603 = compoundNBT.func_74775_l("Data");
                \u2603.func_74778_a("LevelName", string2);
                CompressedStreamTools.func_74799_a(compoundNBT, new FileOutputStream(\u2603));
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    public boolean func_207742_d(String string) {
        try {
            Path path = this.field_215786_c.resolve(string);
            Files.createDirectory(path, new FileAttribute[0]);
            Files.deleteIfExists(path);
            return true;
        }
        catch (IOException iOException) {
            return false;
        }
    }

    public boolean func_75802_e(String string) {
        File file = new File(this.field_215786_c.toFile(), string);
        if (!file.exists()) {
            return true;
        }
        field_215785_a.info("Deleting level {}", (Object)string);
        for (int i = 1; i <= 5; ++i) {
            field_215785_a.info("Attempt {}...", (Object)i);
            if (SaveFormat.func_215784_a(file.listFiles())) break;
            field_215785_a.warn("Unsuccessful in deleting contents.");
            if (i >= 5) continue;
            try {
                Thread.sleep(500L);
                continue;
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        return file.delete();
    }

    private static boolean func_215784_a(File[] fileArray) {
        for (File file : fileArray) {
            field_215785_a.debug("Deleting {}", (Object)file);
            if (file.isDirectory() && !SaveFormat.func_215784_a(file.listFiles())) {
                field_215785_a.warn("Couldn't delete directory {}", (Object)file);
                return false;
            }
            if (file.delete()) continue;
            field_215785_a.warn("Couldn't delete file {}", (Object)file);
            return false;
        }
        return true;
    }

    public boolean func_90033_f(String string) {
        return Files.isDirectory(this.field_215786_c.resolve(string), new LinkOption[0]);
    }

    public Path func_215781_c() {
        return this.field_215786_c;
    }

    public File func_186352_b(String string, String string2) {
        return this.field_215786_c.resolve(string).resolve(string2).toFile();
    }

    private Path func_197714_g(String string) {
        return this.field_215786_c.resolve(string);
    }

    public Path func_197712_e() {
        return this.field_215787_d;
    }

    public long func_197713_h(String string) throws IOException {
        final Path path = this.func_197714_g(string);
        String \u26032 = LocalDateTime.now().format(field_197716_d) + "_" + string;
        \u2603 = this.func_197712_e();
        try {
            Files.createDirectories(Files.exists(\u2603, new LinkOption[0]) ? \u2603.toRealPath(new LinkOption[0]) : \u2603, new FileAttribute[0]);
        }
        catch (IOException \u26033) {
            throw new RuntimeException(\u26033);
        }
        \u2603 = \u2603.resolve(FileUtil.func_214992_a(\u2603, \u26032, ".zip"));
        try (final ZipOutputStream \u26034 = new ZipOutputStream(new BufferedOutputStream(Files.newOutputStream(\u2603, new OpenOption[0])));){
            \u2603 = Paths.get(string, new String[0]);
            Files.walkFileTree(path, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult visitFile(Path path2, BasicFileAttributes basicFileAttributes) throws IOException {
                    String string = \u2603.resolve(path.relativize(path2)).toString().replace('\\', '/');
                    ZipEntry \u26032 = new ZipEntry(string);
                    \u26034.putNextEntry(\u26032);
                    com.google.common.io.Files.asByteSource((File)path2.toFile()).copyTo((OutputStream)\u26034);
                    \u26034.closeEntry();
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public /* synthetic */ FileVisitResult visitFile(Object object, BasicFileAttributes basicFileAttributes) throws IOException {
                    return this.visitFile((Path)object, basicFileAttributes);
                }
            });
        }
        return Files.size(\u2603);
    }
}

