/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.biome;

import com.google.common.collect.Lists;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.fluid.Fluids;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.GenerationStage;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.gen.carver.WorldCarver;
import net.minecraft.world.gen.feature.BigMushroomFeatureConfig;
import net.minecraft.world.gen.feature.BlockBlobConfig;
import net.minecraft.world.gen.feature.BlockWithContextConfig;
import net.minecraft.world.gen.feature.BushConfig;
import net.minecraft.world.gen.feature.DoublePlantConfig;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.GrassFeatureConfig;
import net.minecraft.world.gen.feature.IFeatureConfig;
import net.minecraft.world.gen.feature.IcebergConfig;
import net.minecraft.world.gen.feature.LakesConfig;
import net.minecraft.world.gen.feature.LiquidsConfig;
import net.minecraft.world.gen.feature.MultipleRandomFeatureConfig;
import net.minecraft.world.gen.feature.MultipleWithChanceRandomFeatureConfig;
import net.minecraft.world.gen.feature.OreFeatureConfig;
import net.minecraft.world.gen.feature.ProbabilityConfig;
import net.minecraft.world.gen.feature.ReplaceBlockConfig;
import net.minecraft.world.gen.feature.SeaGrassConfig;
import net.minecraft.world.gen.feature.SphereReplaceConfig;
import net.minecraft.world.gen.feature.TwoFeatureChoiceConfig;
import net.minecraft.world.gen.feature.structure.BuriedTreasureConfig;
import net.minecraft.world.gen.feature.structure.MineshaftConfig;
import net.minecraft.world.gen.feature.structure.MineshaftStructure;
import net.minecraft.world.gen.feature.structure.OceanRuinConfig;
import net.minecraft.world.gen.feature.structure.OceanRuinStructure;
import net.minecraft.world.gen.feature.structure.PillagerOutpostConfig;
import net.minecraft.world.gen.feature.structure.ShipwreckConfig;
import net.minecraft.world.gen.feature.structure.VillageConfig;
import net.minecraft.world.gen.placement.AtSurfaceWithExtraConfig;
import net.minecraft.world.gen.placement.CaveEdgeConfig;
import net.minecraft.world.gen.placement.ChanceConfig;
import net.minecraft.world.gen.placement.CountRangeConfig;
import net.minecraft.world.gen.placement.DepthAverageConfig;
import net.minecraft.world.gen.placement.DungeonRoomConfig;
import net.minecraft.world.gen.placement.FrequencyConfig;
import net.minecraft.world.gen.placement.HeightWithChanceConfig;
import net.minecraft.world.gen.placement.IPlacementConfig;
import net.minecraft.world.gen.placement.LakeChanceConfig;
import net.minecraft.world.gen.placement.NoiseDependant;
import net.minecraft.world.gen.placement.Placement;
import net.minecraft.world.gen.placement.TopSolidWithNoiseConfig;

public class DefaultBiomeFeatures {
    public static void func_222300_a(Biome biome) {
        biome.func_203609_a(GenerationStage.Carving.AIR, Biome.func_203606_a(WorldCarver.field_222709_a, new ProbabilityConfig(0.14285715f)));
        biome.func_203609_a(GenerationStage.Carving.AIR, Biome.func_203606_a(WorldCarver.field_222711_c, new ProbabilityConfig(0.02f)));
    }

    public static void func_222346_b(Biome biome) {
        biome.func_203609_a(GenerationStage.Carving.AIR, Biome.func_203606_a(WorldCarver.field_222709_a, new ProbabilityConfig(0.06666667f)));
        biome.func_203609_a(GenerationStage.Carving.AIR, Biome.func_203606_a(WorldCarver.field_222711_c, new ProbabilityConfig(0.02f)));
        biome.func_203609_a(GenerationStage.Carving.LIQUID, Biome.func_203606_a(WorldCarver.field_222712_d, new ProbabilityConfig(0.02f)));
        biome.func_203609_a(GenerationStage.Carving.LIQUID, Biome.func_203606_a(WorldCarver.field_222713_e, new ProbabilityConfig(0.06666667f)));
    }

    public static void func_222295_c(Biome biome) {
        biome.func_203611_a(GenerationStage.Decoration.UNDERGROUND_STRUCTURES, Biome.func_222280_a(Feature.field_202329_g, new MineshaftConfig(0.004f, MineshaftStructure.Type.NORMAL), Placement.field_215022_h, IPlacementConfig.field_202468_e));
        biome.func_203611_a(GenerationStage.Decoration.SURFACE_STRUCTURES, Biome.func_222280_a(Feature.field_214536_b, new PillagerOutpostConfig(0.004), Placement.field_215022_h, IPlacementConfig.field_202468_e));
        biome.func_203611_a(GenerationStage.Decoration.UNDERGROUND_STRUCTURES, Biome.func_222280_a(Feature.field_202335_m, IFeatureConfig.field_202429_e, Placement.field_215022_h, IPlacementConfig.field_202468_e));
        biome.func_203611_a(GenerationStage.Decoration.SURFACE_STRUCTURES, Biome.func_222280_a(Feature.field_202334_l, IFeatureConfig.field_202429_e, Placement.field_215022_h, IPlacementConfig.field_202468_e));
        biome.func_203611_a(GenerationStage.Decoration.SURFACE_STRUCTURES, Biome.func_222280_a(Feature.field_202332_j, IFeatureConfig.field_202429_e, Placement.field_215022_h, IPlacementConfig.field_202468_e));
        biome.func_203611_a(GenerationStage.Decoration.SURFACE_STRUCTURES, Biome.func_222280_a(Feature.field_202331_i, IFeatureConfig.field_202429_e, Placement.field_215022_h, IPlacementConfig.field_202468_e));
        biome.func_203611_a(GenerationStage.Decoration.SURFACE_STRUCTURES, Biome.func_222280_a(Feature.field_202333_k, IFeatureConfig.field_202429_e, Placement.field_215022_h, IPlacementConfig.field_202468_e));
        biome.func_203611_a(GenerationStage.Decoration.SURFACE_STRUCTURES, Biome.func_222280_a(Feature.field_204751_l, new ShipwreckConfig(false), Placement.field_215022_h, IPlacementConfig.field_202468_e));
        biome.func_203611_a(GenerationStage.Decoration.SURFACE_STRUCTURES, Biome.func_222280_a(Feature.field_202336_n, IFeatureConfig.field_202429_e, Placement.field_215022_h, IPlacementConfig.field_202468_e));
        biome.func_203611_a(GenerationStage.Decoration.SURFACE_STRUCTURES, Biome.func_222280_a(Feature.field_202330_h, IFeatureConfig.field_202429_e, Placement.field_215022_h, IPlacementConfig.field_202468_e));
        biome.func_203611_a(GenerationStage.Decoration.SURFACE_STRUCTURES, Biome.func_222280_a(Feature.field_204029_o, new OceanRuinConfig(OceanRuinStructure.Type.COLD, 0.3f, 0.9f), Placement.field_215022_h, IPlacementConfig.field_202468_e));
        biome.func_203611_a(GenerationStage.Decoration.UNDERGROUND_STRUCTURES, Biome.func_222280_a(Feature.field_214549_o, new BuriedTreasureConfig(0.01f), Placement.field_215022_h, IPlacementConfig.field_202468_e));
        biome.func_203611_a(GenerationStage.Decoration.SURFACE_STRUCTURES, Biome.func_222280_a(Feature.field_214550_p, new VillageConfig("village/plains/town_centers", 6), Placement.field_215022_h, IPlacementConfig.field_202468_e));
    }

    public static void func_222333_d(Biome biome) {
        biome.func_203611_a(GenerationStage.Decoration.LOCAL_MODIFICATIONS, Biome.func_222280_a(Feature.field_202289_ai, new LakesConfig(Blocks.field_150355_j.func_176223_P()), Placement.field_215006_E, new LakeChanceConfig(4)));
        biome.func_203611_a(GenerationStage.Decoration.LOCAL_MODIFICATIONS, Biome.func_222280_a(Feature.field_202289_ai, new LakesConfig(Blocks.field_150353_l.func_176223_P()), Placement.field_215005_D, new LakeChanceConfig(80)));
    }

    public static void func_222301_e(Biome biome) {
        biome.func_203611_a(GenerationStage.Decoration.LOCAL_MODIFICATIONS, Biome.func_222280_a(Feature.field_202289_ai, new LakesConfig(Blocks.field_150353_l.func_176223_P()), Placement.field_215005_D, new LakeChanceConfig(80)));
    }

    public static void func_222335_f(Biome biome) {
        biome.func_203611_a(GenerationStage.Decoration.UNDERGROUND_STRUCTURES, Biome.func_222280_a(Feature.field_202282_ab, IFeatureConfig.field_202429_e, Placement.field_215007_F, new DungeonRoomConfig(8)));
    }

    public static void func_222326_g(Biome biome) {
        biome.func_203611_a(GenerationStage.Decoration.UNDERGROUND_ORES, Biome.func_222280_a(Feature.field_202290_aj, new OreFeatureConfig(OreFeatureConfig.FillerBlockType.NATURAL_STONE, Blocks.field_150346_d.func_176223_P(), 33), Placement.field_215028_n, new CountRangeConfig(10, 0, 0, 256)));
        biome.func_203611_a(GenerationStage.Decoration.UNDERGROUND_ORES, Biome.func_222280_a(Feature.field_202290_aj, new OreFeatureConfig(OreFeatureConfig.FillerBlockType.NATURAL_STONE, Blocks.field_150351_n.func_176223_P(), 33), Placement.field_215028_n, new CountRangeConfig(8, 0, 0, 256)));
        biome.func_203611_a(GenerationStage.Decoration.UNDERGROUND_ORES, Biome.func_222280_a(Feature.field_202290_aj, new OreFeatureConfig(OreFeatureConfig.FillerBlockType.NATURAL_STONE, Blocks.field_196650_c.func_176223_P(), 33), Placement.field_215028_n, new CountRangeConfig(10, 0, 0, 80)));
        biome.func_203611_a(GenerationStage.Decoration.UNDERGROUND_ORES, Biome.func_222280_a(Feature.field_202290_aj, new OreFeatureConfig(OreFeatureConfig.FillerBlockType.NATURAL_STONE, Blocks.field_196654_e.func_176223_P(), 33), Placement.field_215028_n, new CountRangeConfig(10, 0, 0, 80)));
        biome.func_203611_a(GenerationStage.Decoration.UNDERGROUND_ORES, Biome.func_222280_a(Feature.field_202290_aj, new OreFeatureConfig(OreFeatureConfig.FillerBlockType.NATURAL_STONE, Blocks.field_196656_g.func_176223_P(), 33), Placement.field_215028_n, new CountRangeConfig(10, 0, 0, 80)));
    }

    public static void func_222288_h(Biome biome) {
        biome.func_203611_a(GenerationStage.Decoration.UNDERGROUND_ORES, Biome.func_222280_a(Feature.field_202290_aj, new OreFeatureConfig(OreFeatureConfig.FillerBlockType.NATURAL_STONE, Blocks.field_150365_q.func_176223_P(), 17), Placement.field_215028_n, new CountRangeConfig(20, 0, 0, 128)));
        biome.func_203611_a(GenerationStage.Decoration.UNDERGROUND_ORES, Biome.func_222280_a(Feature.field_202290_aj, new OreFeatureConfig(OreFeatureConfig.FillerBlockType.NATURAL_STONE, Blocks.field_150366_p.func_176223_P(), 9), Placement.field_215028_n, new CountRangeConfig(20, 0, 0, 64)));
        biome.func_203611_a(GenerationStage.Decoration.UNDERGROUND_ORES, Biome.func_222280_a(Feature.field_202290_aj, new OreFeatureConfig(OreFeatureConfig.FillerBlockType.NATURAL_STONE, Blocks.field_150352_o.func_176223_P(), 9), Placement.field_215028_n, new CountRangeConfig(2, 0, 0, 32)));
        biome.func_203611_a(GenerationStage.Decoration.UNDERGROUND_ORES, Biome.func_222280_a(Feature.field_202290_aj, new OreFeatureConfig(OreFeatureConfig.FillerBlockType.NATURAL_STONE, Blocks.field_150450_ax.func_176223_P(), 8), Placement.field_215028_n, new CountRangeConfig(8, 0, 0, 16)));
        biome.func_203611_a(GenerationStage.Decoration.UNDERGROUND_ORES, Biome.func_222280_a(Feature.field_202290_aj, new OreFeatureConfig(OreFeatureConfig.FillerBlockType.NATURAL_STONE, Blocks.field_150482_ag.func_176223_P(), 8), Placement.field_215028_n, new CountRangeConfig(1, 0, 0, 16)));
        biome.func_203611_a(GenerationStage.Decoration.UNDERGROUND_ORES, Biome.func_222280_a(Feature.field_202290_aj, new OreFeatureConfig(OreFeatureConfig.FillerBlockType.NATURAL_STONE, Blocks.field_150369_x.func_176223_P(), 7), Placement.field_215035_u, new DepthAverageConfig(1, 16, 16)));
    }

    public static void func_222328_i(Biome biome) {
        biome.func_203611_a(GenerationStage.Decoration.UNDERGROUND_ORES, Biome.func_222280_a(Feature.field_202290_aj, new OreFeatureConfig(OreFeatureConfig.FillerBlockType.NATURAL_STONE, Blocks.field_150352_o.func_176223_P(), 9), Placement.field_215028_n, new CountRangeConfig(20, 32, 32, 80)));
    }

    public static void func_222291_j(Biome biome) {
        biome.func_203611_a(GenerationStage.Decoration.UNDERGROUND_ORES, Biome.func_222280_a(Feature.field_202294_an, new ReplaceBlockConfig(Blocks.field_150348_b.func_176223_P(), Blocks.field_150412_bA.func_176223_P()), Placement.field_215004_C, IPlacementConfig.field_202468_e));
    }

    public static void func_222322_k(Biome biome) {
        biome.func_203611_a(GenerationStage.Decoration.UNDERGROUND_DECORATION, Biome.func_222280_a(Feature.field_202290_aj, new OreFeatureConfig(OreFeatureConfig.FillerBlockType.NATURAL_STONE, Blocks.field_196686_dc.func_176223_P(), 9), Placement.field_215028_n, new CountRangeConfig(7, 0, 0, 64)));
    }

    public static void func_222282_l(Biome biome) {
        biome.func_203611_a(GenerationStage.Decoration.UNDERGROUND_ORES, Biome.func_222280_a(Feature.field_202285_ae, new SphereReplaceConfig(Blocks.field_150354_m.func_176223_P(), 7, 2, Lists.newArrayList((Object[])new BlockState[]{Blocks.field_150346_d.func_176223_P(), Blocks.field_196658_i.func_176223_P()})), Placement.field_215016_b, new FrequencyConfig(3)));
        biome.func_203611_a(GenerationStage.Decoration.UNDERGROUND_ORES, Biome.func_222280_a(Feature.field_202285_ae, new SphereReplaceConfig(Blocks.field_150435_aG.func_176223_P(), 4, 1, Lists.newArrayList((Object[])new BlockState[]{Blocks.field_150346_d.func_176223_P(), Blocks.field_150435_aG.func_176223_P()})), Placement.field_215016_b, new FrequencyConfig(1)));
        biome.func_203611_a(GenerationStage.Decoration.UNDERGROUND_ORES, Biome.func_222280_a(Feature.field_202285_ae, new SphereReplaceConfig(Blocks.field_150351_n.func_176223_P(), 6, 2, Lists.newArrayList((Object[])new BlockState[]{Blocks.field_150346_d.func_176223_P(), Blocks.field_196658_i.func_176223_P()})), Placement.field_215016_b, new FrequencyConfig(1)));
    }

    public static void func_222318_m(Biome biome) {
        biome.func_203611_a(GenerationStage.Decoration.UNDERGROUND_ORES, Biome.func_222280_a(Feature.field_202285_ae, new SphereReplaceConfig(Blocks.field_150435_aG.func_176223_P(), 4, 1, Lists.newArrayList((Object[])new BlockState[]{Blocks.field_150346_d.func_176223_P(), Blocks.field_150435_aG.func_176223_P()})), Placement.field_215016_b, new FrequencyConfig(1)));
    }

    public static void func_222313_n(Biome biome) {
        biome.func_203611_a(GenerationStage.Decoration.LOCAL_MODIFICATIONS, Biome.func_222280_a(Feature.field_202283_ac, new BlockBlobConfig(Blocks.field_150341_Y.func_176223_P(), 0), Placement.field_215040_z, new FrequencyConfig(3)));
    }

    public static void func_222345_o(Biome biome) {
        biome.func_203611_a(GenerationStage.Decoration.VEGETAL_DECORATION, Biome.func_222280_a(Feature.field_202286_af, new DoublePlantConfig(Blocks.field_196805_gi.func_176223_P()), Placement.field_215017_c, new FrequencyConfig(7)));
    }

    public static void func_222307_p(Biome biome) {
        biome.func_203611_a(GenerationStage.Decoration.VEGETAL_DECORATION, Biome.func_222280_a(Feature.field_214485_aM, IFeatureConfig.field_202429_e, Placement.field_215024_j, new ChanceConfig(12)));
    }

    public static void func_222341_q(Biome biome) {
        biome.func_203611_a(GenerationStage.Decoration.VEGETAL_DECORATION, Biome.func_222280_a(Feature.field_214485_aM, IFeatureConfig.field_202429_e, Placement.field_215018_d, new FrequencyConfig(1)));
    }

    public static void func_222289_r(Biome biome) {
        biome.func_203611_a(GenerationStage.Decoration.VEGETAL_DECORATION, Biome.func_222280_a(Feature.field_214482_aJ, new ProbabilityConfig(0.0f), Placement.field_215018_d, new FrequencyConfig(16)));
    }

    public static void func_222325_s(Biome biome) {
        biome.func_203611_a(GenerationStage.Decoration.VEGETAL_DECORATION, Biome.func_222280_a(Feature.field_214482_aJ, new ProbabilityConfig(0.2f), Placement.field_215038_x, new TopSolidWithNoiseConfig(160, 80.0, 0.3, Heightmap.Type.WORLD_SURFACE_WG)));
        biome.func_203611_a(GenerationStage.Decoration.VEGETAL_DECORATION, Biome.func_222280_a(Feature.field_202292_al, new MultipleRandomFeatureConfig(new Feature[]{Feature.field_202339_q, Feature.field_202342_t, Feature.field_202302_B}, new IFeatureConfig[]{IFeatureConfig.field_202429_e, IFeatureConfig.field_202429_e, IFeatureConfig.field_202429_e}, new float[]{0.05f, 0.15f, 0.7f}, Feature.field_202309_I, IFeatureConfig.field_202429_e), Placement.field_215027_m, new AtSurfaceWithExtraConfig(30, 0.1f, 1)));
    }

    public static void func_222293_t(Biome biome) {
        biome.func_203611_a(GenerationStage.Decoration.VEGETAL_DECORATION, Biome.func_222280_a(Feature.field_202292_al, new MultipleRandomFeatureConfig(new Feature[]{Feature.field_202344_v}, new IFeatureConfig[]{IFeatureConfig.field_202429_e}, new float[]{0.33333334f}, Feature.field_202347_y, IFeatureConfig.field_202429_e), Placement.field_215027_m, new AtSurfaceWithExtraConfig(10, 0.1f, 1)));
    }

    public static void func_222296_u(Biome biome) {
        biome.func_203611_a(GenerationStage.Decoration.VEGETAL_DECORATION, Biome.func_222280_a(Feature.field_202292_al, new MultipleRandomFeatureConfig(new Feature[]{Feature.field_202339_q}, new IFeatureConfig[]{IFeatureConfig.field_202429_e}, new float[]{0.1f}, Feature.field_202301_A, IFeatureConfig.field_202429_e), Placement.field_215027_m, new AtSurfaceWithExtraConfig(0, 0.1f, 1)));
    }

    public static void func_222330_v(Biome biome) {
        biome.func_203611_a(GenerationStage.Decoration.VEGETAL_DECORATION, Biome.func_222280_a(Feature.field_202340_r, IFeatureConfig.field_202429_e, Placement.field_215027_m, new AtSurfaceWithExtraConfig(10, 0.1f, 1)));
    }

    public static void func_222302_w(Biome biome) {
        biome.func_203611_a(GenerationStage.Decoration.VEGETAL_DECORATION, Biome.func_222280_a(Feature.field_202292_al, new MultipleRandomFeatureConfig(new Feature[]{Feature.field_202340_r, Feature.field_202339_q}, new IFeatureConfig[]{IFeatureConfig.field_202429_e, IFeatureConfig.field_202429_e}, new float[]{0.2f, 0.1f}, Feature.field_202301_A, IFeatureConfig.field_202429_e), Placement.field_215027_m, new AtSurfaceWithExtraConfig(10, 0.1f, 1)));
    }

    public static void func_222336_x(Biome biome) {
        biome.func_203611_a(GenerationStage.Decoration.VEGETAL_DECORATION, Biome.func_222280_a(Feature.field_202292_al, new MultipleRandomFeatureConfig(new Feature[]{Feature.field_202341_s}, new IFeatureConfig[]{IFeatureConfig.field_202429_e}, new float[]{0.5f}, Feature.field_202340_r, IFeatureConfig.field_202429_e), Placement.field_215027_m, new AtSurfaceWithExtraConfig(10, 0.1f, 1)));
    }

    public static void func_222310_y(Biome biome) {
        biome.func_203611_a(GenerationStage.Decoration.VEGETAL_DECORATION, Biome.func_222280_a(Feature.field_202292_al, new MultipleRandomFeatureConfig(new Feature[]{Feature.field_202346_x}, new IFeatureConfig[]{IFeatureConfig.field_202429_e}, new float[]{0.8f}, Feature.field_202301_A, IFeatureConfig.field_202429_e), Placement.field_215027_m, new AtSurfaceWithExtraConfig(1, 0.1f, 1)));
    }

    public static void func_222347_z(Biome biome) {
        biome.func_203611_a(GenerationStage.Decoration.VEGETAL_DECORATION, Biome.func_222280_a(Feature.field_202292_al, new MultipleRandomFeatureConfig(new Feature[]{Feature.field_202346_x}, new IFeatureConfig[]{IFeatureConfig.field_202429_e}, new float[]{0.8f}, Feature.field_202301_A, IFeatureConfig.field_202429_e), Placement.field_215027_m, new AtSurfaceWithExtraConfig(2, 0.1f, 1)));
    }

    public static void func_222343_A(Biome biome) {
        biome.func_203611_a(GenerationStage.Decoration.VEGETAL_DECORATION, Biome.func_222280_a(Feature.field_202292_al, new MultipleRandomFeatureConfig(new Feature[]{Feature.field_202347_y, Feature.field_202339_q}, new IFeatureConfig[]{IFeatureConfig.field_202429_e, IFeatureConfig.field_202429_e}, new float[]{0.666f, 0.1f}, Feature.field_202301_A, IFeatureConfig.field_202429_e), Placement.field_215027_m, new AtSurfaceWithExtraConfig(0, 0.1f, 1)));
    }

    public static void func_222304_B(Biome biome) {
        biome.func_203611_a(GenerationStage.Decoration.VEGETAL_DECORATION, Biome.func_222280_a(Feature.field_202292_al, new MultipleRandomFeatureConfig(new Feature[]{Feature.field_202347_y, Feature.field_202339_q}, new IFeatureConfig[]{IFeatureConfig.field_202429_e, IFeatureConfig.field_202429_e}, new float[]{0.666f, 0.1f}, Feature.field_202301_A, IFeatureConfig.field_202429_e), Placement.field_215027_m, new AtSurfaceWithExtraConfig(3, 0.1f, 1)));
    }

    public static void func_222323_C(Biome biome) {
        biome.func_203611_a(GenerationStage.Decoration.VEGETAL_DECORATION, Biome.func_222280_a(Feature.field_202292_al, new MultipleRandomFeatureConfig(new Feature[]{Feature.field_202339_q, Feature.field_202342_t, Feature.field_202302_B}, new IFeatureConfig[]{IFeatureConfig.field_202429_e, IFeatureConfig.field_202429_e, IFeatureConfig.field_202429_e}, new float[]{0.1f, 0.5f, 0.33333334f}, Feature.field_202343_u, IFeatureConfig.field_202429_e), Placement.field_215027_m, new AtSurfaceWithExtraConfig(50, 0.1f, 1)));
    }

    public static void func_222290_D(Biome biome) {
        biome.func_203611_a(GenerationStage.Decoration.VEGETAL_DECORATION, Biome.func_222280_a(Feature.field_202292_al, new MultipleRandomFeatureConfig(new Feature[]{Feature.field_202339_q, Feature.field_202342_t}, new IFeatureConfig[]{IFeatureConfig.field_202429_e, IFeatureConfig.field_202429_e}, new float[]{0.1f, 0.5f}, Feature.field_202343_u, IFeatureConfig.field_202429_e), Placement.field_215027_m, new AtSurfaceWithExtraConfig(2, 0.1f, 1)));
    }

    public static void func_222327_E(Biome biome) {
        biome.func_203611_a(GenerationStage.Decoration.VEGETAL_DECORATION, Biome.func_222280_a(Feature.field_202301_A, IFeatureConfig.field_202429_e, Placement.field_215027_m, new AtSurfaceWithExtraConfig(5, 0.1f, 1)));
    }

    public static void func_222284_F(Biome biome) {
        biome.func_203611_a(GenerationStage.Decoration.VEGETAL_DECORATION, Biome.func_222280_a(Feature.field_202347_y, IFeatureConfig.field_202429_e, Placement.field_215027_m, new AtSurfaceWithExtraConfig(0, 0.1f, 1)));
    }

    public static void func_222316_G(Biome biome) {
        biome.func_203611_a(GenerationStage.Decoration.VEGETAL_DECORATION, Biome.func_222280_a(Feature.field_202292_al, new MultipleRandomFeatureConfig(new Feature[]{Feature.field_202304_D, Feature.field_202344_v}, new IFeatureConfig[]{IFeatureConfig.field_202429_e, IFeatureConfig.field_202429_e}, new float[]{0.33333334f, 0.33333334f}, Feature.field_202347_y, IFeatureConfig.field_202429_e), Placement.field_215027_m, new AtSurfaceWithExtraConfig(10, 0.1f, 1)));
    }

    public static void func_222285_H(Biome biome) {
        biome.func_203611_a(GenerationStage.Decoration.VEGETAL_DECORATION, Biome.func_222280_a(Feature.field_202292_al, new MultipleRandomFeatureConfig(new Feature[]{Feature.field_202304_D, Feature.field_202303_C, Feature.field_202344_v}, new IFeatureConfig[]{IFeatureConfig.field_202429_e, IFeatureConfig.field_202429_e, IFeatureConfig.field_202429_e}, new float[]{0.025641026f, 0.30769232f, 0.33333334f}, Feature.field_202347_y, IFeatureConfig.field_202429_e), Placement.field_215027_m, new AtSurfaceWithExtraConfig(10, 0.1f, 1)));
    }

    public static void func_222321_I(Biome biome) {
        biome.func_203611_a(GenerationStage.Decoration.VEGETAL_DECORATION, Biome.func_222280_a(Feature.field_202309_I, IFeatureConfig.field_202429_e, Placement.field_215018_d, new FrequencyConfig(25)));
    }

    public static void func_222344_J(Biome biome) {
        biome.func_203611_a(GenerationStage.Decoration.VEGETAL_DECORATION, Biome.func_222280_a(Feature.field_202286_af, new DoublePlantConfig(Blocks.field_196804_gh.func_176223_P()), Placement.field_215017_c, new FrequencyConfig(7)));
    }

    public static void func_222314_K(Biome biome) {
        biome.func_203611_a(GenerationStage.Decoration.VEGETAL_DECORATION, Biome.func_222280_a(Feature.field_214520_L, new GrassFeatureConfig(Blocks.field_150349_c.func_176223_P()), Placement.field_215018_d, new FrequencyConfig(5)));
    }

    public static void func_222339_L(Biome biome) {
        biome.func_203611_a(GenerationStage.Decoration.VEGETAL_DECORATION, Biome.func_222280_a(Feature.field_214520_L, new GrassFeatureConfig(Blocks.field_150349_c.func_176223_P()), Placement.field_215018_d, new FrequencyConfig(20)));
    }

    public static void func_222308_M(Biome biome) {
        biome.func_203611_a(GenerationStage.Decoration.VEGETAL_DECORATION, Biome.func_222280_a(Feature.field_214520_L, new GrassFeatureConfig(Blocks.field_150349_c.func_176223_P()), Placement.field_215018_d, new FrequencyConfig(1)));
        biome.func_203611_a(GenerationStage.Decoration.VEGETAL_DECORATION, Biome.func_222280_a(Feature.field_202314_N, IFeatureConfig.field_202429_e, Placement.field_215018_d, new FrequencyConfig(20)));
    }

    public static void func_222338_N(Biome biome) {
        biome.func_203611_a(GenerationStage.Decoration.VEGETAL_DECORATION, Biome.func_222280_a(Feature.field_202291_ak, new MultipleWithChanceRandomFeatureConfig(new Feature[]{Feature.field_202286_af, Feature.field_202286_af, Feature.field_202286_af, Feature.field_214519_I}, new IFeatureConfig[]{new DoublePlantConfig(Blocks.field_196801_ge.func_176223_P()), new DoublePlantConfig(Blocks.field_196802_gf.func_176223_P()), new DoublePlantConfig(Blocks.field_196803_gg.func_176223_P()), IFeatureConfig.field_202429_e}, 0), Placement.field_215017_c, new FrequencyConfig(5)));
    }

    public static void func_222298_O(Biome biome) {
        biome.func_203611_a(GenerationStage.Decoration.VEGETAL_DECORATION, Biome.func_222280_a(Feature.field_214520_L, new GrassFeatureConfig(Blocks.field_150349_c.func_176223_P()), Placement.field_215018_d, new FrequencyConfig(2)));
    }

    public static void func_222331_P(Biome biome) {
        biome.func_203611_a(GenerationStage.Decoration.VEGETAL_DECORATION, Biome.func_222280_a(Feature.field_202348_z, IFeatureConfig.field_202429_e, Placement.field_215027_m, new AtSurfaceWithExtraConfig(2, 0.1f, 1)));
        biome.func_203611_a(GenerationStage.Decoration.VEGETAL_DECORATION, Biome.func_222280_a(Feature.field_202308_H, IFeatureConfig.field_202429_e, Placement.field_215017_c, new FrequencyConfig(1)));
        biome.func_203611_a(GenerationStage.Decoration.VEGETAL_DECORATION, Biome.func_222280_a(Feature.field_214520_L, new GrassFeatureConfig(Blocks.field_150349_c.func_176223_P()), Placement.field_215018_d, new FrequencyConfig(5)));
        biome.func_203611_a(GenerationStage.Decoration.VEGETAL_DECORATION, Biome.func_222280_a(Feature.field_202314_N, IFeatureConfig.field_202429_e, Placement.field_215018_d, new FrequencyConfig(1)));
        biome.func_203611_a(GenerationStage.Decoration.VEGETAL_DECORATION, Biome.func_222280_a(Feature.field_202281_aa, IFeatureConfig.field_202429_e, Placement.field_215018_d, new FrequencyConfig(4)));
        biome.func_203611_a(GenerationStage.Decoration.VEGETAL_DECORATION, Biome.func_222280_a(Feature.field_202284_ad, new BushConfig(Blocks.field_150338_P.func_176223_P()), Placement.field_215033_s, new HeightWithChanceConfig(8, 0.25f)));
        biome.func_203611_a(GenerationStage.Decoration.VEGETAL_DECORATION, Biome.func_222280_a(Feature.field_202284_ad, new BushConfig(Blocks.field_150337_Q.func_176223_P()), Placement.field_215034_t, new HeightWithChanceConfig(8, 0.125f)));
    }

    public static void func_222294_Q(Biome biome) {
        biome.func_203611_a(GenerationStage.Decoration.VEGETAL_DECORATION, Biome.func_222280_a(Feature.field_202293_am, new TwoFeatureChoiceConfig(Feature.field_202318_R, new BigMushroomFeatureConfig(false), Feature.field_202319_S, new BigMushroomFeatureConfig(false)), Placement.field_215015_a, new FrequencyConfig(1)));
        biome.func_203611_a(GenerationStage.Decoration.VEGETAL_DECORATION, Biome.func_222280_a(Feature.field_202284_ad, new BushConfig(Blocks.field_150338_P.func_176223_P()), Placement.field_215033_s, new HeightWithChanceConfig(1, 0.25f)));
        biome.func_203611_a(GenerationStage.Decoration.VEGETAL_DECORATION, Biome.func_222280_a(Feature.field_202284_ad, new BushConfig(Blocks.field_150337_Q.func_176223_P()), Placement.field_215034_t, new HeightWithChanceConfig(1, 0.125f)));
    }

    public static void func_222299_R(Biome biome) {
        biome.func_203611_a(GenerationStage.Decoration.VEGETAL_DECORATION, Biome.func_222280_a(Feature.field_202292_al, new MultipleRandomFeatureConfig(new Feature[]{Feature.field_202339_q}, new IFeatureConfig[]{IFeatureConfig.field_202429_e}, new float[]{0.33333334f}, Feature.field_202301_A, IFeatureConfig.field_202429_e), Placement.field_215027_m, new AtSurfaceWithExtraConfig(0, 0.05f, 1)));
        biome.func_203611_a(GenerationStage.Decoration.VEGETAL_DECORATION, Biome.func_222280_a(Feature.field_202307_G, IFeatureConfig.field_202429_e, Placement.field_215020_f, new NoiseDependant(-0.8, 15, 4)));
        biome.func_203611_a(GenerationStage.Decoration.VEGETAL_DECORATION, Biome.func_222280_a(Feature.field_214520_L, new GrassFeatureConfig(Blocks.field_150349_c.func_176223_P()), Placement.field_215021_g, new NoiseDependant(-0.8, 5, 10)));
    }

    public static void func_222334_S(Biome biome) {
        biome.func_203611_a(GenerationStage.Decoration.VEGETAL_DECORATION, Biome.func_222280_a(Feature.field_202314_N, IFeatureConfig.field_202429_e, Placement.field_215018_d, new FrequencyConfig(2)));
    }

    public static void func_222303_T(Biome biome) {
        biome.func_203611_a(GenerationStage.Decoration.VEGETAL_DECORATION, Biome.func_222280_a(Feature.field_202310_J, IFeatureConfig.field_202429_e, Placement.field_215018_d, new FrequencyConfig(7)));
        biome.func_203611_a(GenerationStage.Decoration.VEGETAL_DECORATION, Biome.func_222280_a(Feature.field_202314_N, IFeatureConfig.field_202429_e, Placement.field_215018_d, new FrequencyConfig(1)));
        biome.func_203611_a(GenerationStage.Decoration.VEGETAL_DECORATION, Biome.func_222280_a(Feature.field_202284_ad, new BushConfig(Blocks.field_150338_P.func_176223_P()), Placement.field_215033_s, new HeightWithChanceConfig(3, 0.25f)));
        biome.func_203611_a(GenerationStage.Decoration.VEGETAL_DECORATION, Biome.func_222280_a(Feature.field_202284_ad, new BushConfig(Blocks.field_150337_Q.func_176223_P()), Placement.field_215034_t, new HeightWithChanceConfig(3, 0.125f)));
    }

    public static void func_222342_U(Biome biome) {
        biome.func_203611_a(GenerationStage.Decoration.VEGETAL_DECORATION, Biome.func_222280_a(Feature.field_202305_E, IFeatureConfig.field_202429_e, Placement.field_215017_c, new FrequencyConfig(2)));
    }

    public static void func_222306_V(Biome biome) {
        biome.func_203611_a(GenerationStage.Decoration.VEGETAL_DECORATION, Biome.func_222280_a(Feature.field_202305_E, IFeatureConfig.field_202429_e, Placement.field_215017_c, new FrequencyConfig(4)));
    }

    public static void func_222348_W(Biome biome) {
        biome.func_203611_a(GenerationStage.Decoration.VEGETAL_DECORATION, Biome.func_222280_a(Feature.field_214520_L, new GrassFeatureConfig(Blocks.field_150349_c.func_176223_P()), Placement.field_215018_d, new FrequencyConfig(1)));
    }

    public static void func_222319_X(Biome biome) {
        biome.func_203611_a(GenerationStage.Decoration.VEGETAL_DECORATION, Biome.func_222280_a(Feature.field_202310_J, IFeatureConfig.field_202429_e, Placement.field_215018_d, new FrequencyConfig(1)));
        biome.func_203611_a(GenerationStage.Decoration.VEGETAL_DECORATION, Biome.func_222280_a(Feature.field_202284_ad, new BushConfig(Blocks.field_150338_P.func_176223_P()), Placement.field_215033_s, new HeightWithChanceConfig(1, 0.25f)));
        biome.func_203611_a(GenerationStage.Decoration.VEGETAL_DECORATION, Biome.func_222280_a(Feature.field_202284_ad, new BushConfig(Blocks.field_150337_Q.func_176223_P()), Placement.field_215034_t, new HeightWithChanceConfig(1, 0.125f)));
    }

    public static void func_222283_Y(Biome biome) {
        biome.func_203611_a(GenerationStage.Decoration.VEGETAL_DECORATION, Biome.func_222280_a(Feature.field_202286_af, new DoublePlantConfig(Blocks.field_196804_gh.func_176223_P()), Placement.field_215020_f, new NoiseDependant(-0.8, 0, 7)));
    }

    public static void func_222315_Z(Biome biome) {
        biome.func_203611_a(GenerationStage.Decoration.VEGETAL_DECORATION, Biome.func_222280_a(Feature.field_202284_ad, new BushConfig(Blocks.field_150338_P.func_176223_P()), Placement.field_215024_j, new ChanceConfig(4)));
        biome.func_203611_a(GenerationStage.Decoration.VEGETAL_DECORATION, Biome.func_222280_a(Feature.field_202284_ad, new BushConfig(Blocks.field_150337_Q.func_176223_P()), Placement.field_215024_j, new ChanceConfig(8)));
    }

    public static void func_222311_aa(Biome biome) {
        biome.func_203611_a(GenerationStage.Decoration.VEGETAL_DECORATION, Biome.func_222280_a(Feature.field_202324_X, IFeatureConfig.field_202429_e, Placement.field_215018_d, new FrequencyConfig(10)));
        biome.func_203611_a(GenerationStage.Decoration.VEGETAL_DECORATION, Biome.func_222280_a(Feature.field_202323_W, IFeatureConfig.field_202429_e, Placement.field_215024_j, new ChanceConfig(32)));
    }

    public static void func_222286_ab(Biome biome) {
        biome.func_203611_a(GenerationStage.Decoration.VEGETAL_DECORATION, Biome.func_222280_a(Feature.field_202324_X, IFeatureConfig.field_202429_e, Placement.field_215018_d, new FrequencyConfig(13)));
        biome.func_203611_a(GenerationStage.Decoration.VEGETAL_DECORATION, Biome.func_222280_a(Feature.field_202323_W, IFeatureConfig.field_202429_e, Placement.field_215024_j, new ChanceConfig(32)));
        biome.func_203611_a(GenerationStage.Decoration.VEGETAL_DECORATION, Biome.func_222280_a(Feature.field_202313_M, IFeatureConfig.field_202429_e, Placement.field_215018_d, new FrequencyConfig(5)));
    }

    public static void func_222324_ac(Biome biome) {
        biome.func_203611_a(GenerationStage.Decoration.VEGETAL_DECORATION, Biome.func_222280_a(Feature.field_202322_V, IFeatureConfig.field_202429_e, Placement.field_215018_d, new FrequencyConfig(1)));
        biome.func_203611_a(GenerationStage.Decoration.VEGETAL_DECORATION, Biome.func_222280_a(Feature.field_202326_Z, IFeatureConfig.field_202429_e, Placement.field_215019_e, new FrequencyConfig(50)));
    }

    public static void func_222292_ad(Biome biome) {
        biome.func_203611_a(GenerationStage.Decoration.VEGETAL_DECORATION, Biome.func_222280_a(Feature.field_202324_X, IFeatureConfig.field_202429_e, Placement.field_215018_d, new FrequencyConfig(60)));
        biome.func_203611_a(GenerationStage.Decoration.VEGETAL_DECORATION, Biome.func_222280_a(Feature.field_202323_W, IFeatureConfig.field_202429_e, Placement.field_215024_j, new ChanceConfig(32)));
        biome.func_203611_a(GenerationStage.Decoration.VEGETAL_DECORATION, Biome.func_222280_a(Feature.field_202313_M, IFeatureConfig.field_202429_e, Placement.field_215018_d, new FrequencyConfig(10)));
    }

    public static void func_222329_ae(Biome biome) {
        biome.func_203611_a(GenerationStage.Decoration.VEGETAL_DECORATION, Biome.func_222280_a(Feature.field_202324_X, IFeatureConfig.field_202429_e, Placement.field_215018_d, new FrequencyConfig(20)));
        biome.func_203611_a(GenerationStage.Decoration.VEGETAL_DECORATION, Biome.func_222280_a(Feature.field_202323_W, IFeatureConfig.field_202429_e, Placement.field_215024_j, new ChanceConfig(32)));
    }

    public static void func_222281_af(Biome biome) {
        biome.func_203611_a(GenerationStage.Decoration.SURFACE_STRUCTURES, Biome.func_222280_a(Feature.field_202315_O, IFeatureConfig.field_202429_e, Placement.field_215023_i, new ChanceConfig(1000)));
        biome.func_203611_a(GenerationStage.Decoration.UNDERGROUND_DECORATION, Biome.func_222280_a(Feature.field_202316_P, IFeatureConfig.field_202429_e, Placement.field_215025_k, new ChanceConfig(64)));
    }

    public static void func_222317_ag(Biome biome) {
        biome.func_203611_a(GenerationStage.Decoration.UNDERGROUND_DECORATION, Biome.func_222280_a(Feature.field_202316_P, IFeatureConfig.field_202429_e, Placement.field_215025_k, new ChanceConfig(64)));
    }

    public static void func_222287_ah(Biome biome) {
        biome.func_203611_a(GenerationStage.Decoration.VEGETAL_DECORATION, Biome.func_222280_a(Feature.field_203235_au, IFeatureConfig.field_202429_e, Placement.field_215038_x, new TopSolidWithNoiseConfig(120, 80.0, 0.0, Heightmap.Type.OCEAN_FLOOR_WG)));
    }

    public static void func_222320_ai(Biome biome) {
        biome.func_203611_a(GenerationStage.Decoration.VEGETAL_DECORATION, Biome.func_222280_a(Feature.field_206922_aF, new BlockWithContextConfig(Blocks.field_203198_aQ.func_176223_P(), new BlockState[]{Blocks.field_150348_b.func_176223_P()}, new BlockState[]{Blocks.field_150355_j.func_176223_P()}, new BlockState[]{Blocks.field_150355_j.func_176223_P()}), Placement.field_215039_y, new CaveEdgeConfig(GenerationStage.Carving.LIQUID, 0.1f)));
    }

    public static void func_222309_aj(Biome biome) {
        biome.func_203611_a(GenerationStage.Decoration.VEGETAL_DECORATION, Biome.func_222280_a(Feature.field_203234_at, new SeaGrassConfig(80, 0.3), Placement.field_215036_v, IPlacementConfig.field_202468_e));
    }

    public static void func_222340_ak(Biome biome) {
        biome.func_203611_a(GenerationStage.Decoration.VEGETAL_DECORATION, Biome.func_222280_a(Feature.field_203234_at, new SeaGrassConfig(80, 0.8), Placement.field_215036_v, IPlacementConfig.field_202468_e));
    }

    public static void func_222312_al(Biome biome) {
        biome.func_203611_a(GenerationStage.Decoration.VEGETAL_DECORATION, Biome.func_222280_a(Feature.field_203235_au, IFeatureConfig.field_202429_e, Placement.field_215038_x, new TopSolidWithNoiseConfig(80, 80.0, 0.0, Heightmap.Type.OCEAN_FLOOR_WG)));
    }

    public static void func_222337_am(Biome biome) {
        biome.func_203611_a(GenerationStage.Decoration.VEGETAL_DECORATION, Biome.func_222280_a(Feature.field_202295_ao, new LiquidsConfig(Fluids.field_204546_a.func_207188_f()), Placement.field_215029_o, new CountRangeConfig(50, 8, 8, 256)));
        biome.func_203611_a(GenerationStage.Decoration.VEGETAL_DECORATION, Biome.func_222280_a(Feature.field_202295_ao, new LiquidsConfig(Fluids.field_204547_b.func_207188_f()), Placement.field_215030_p, new CountRangeConfig(20, 8, 16, 256)));
    }

    public static void func_222305_an(Biome biome) {
        biome.func_203611_a(GenerationStage.Decoration.LOCAL_MODIFICATIONS, Biome.func_222280_a(Feature.field_205172_ag, new IcebergConfig(Blocks.field_150403_cj.func_176223_P()), Placement.field_215009_H, new ChanceConfig(16)));
        biome.func_203611_a(GenerationStage.Decoration.LOCAL_MODIFICATIONS, Biome.func_222280_a(Feature.field_205172_ag, new IcebergConfig(Blocks.field_205164_gk.func_176223_P()), Placement.field_215009_H, new ChanceConfig(200)));
    }

    public static void func_222332_ao(Biome biome) {
        biome.func_203611_a(GenerationStage.Decoration.SURFACE_STRUCTURES, Biome.func_222280_a(Feature.field_205171_af, IFeatureConfig.field_202429_e, Placement.field_215031_q, new CountRangeConfig(20, 30, 32, 64)));
    }

    public static void func_222297_ap(Biome biome) {
        biome.func_203611_a(GenerationStage.Decoration.TOP_LAYER_MODIFICATION, Biome.func_222280_a(Feature.field_202325_Y, IFeatureConfig.field_202429_e, Placement.field_215022_h, IPlacementConfig.field_202468_e));
    }

    public static void func_225489_aq(Biome biome) {
        biome.func_203611_a(GenerationStage.Decoration.SURFACE_STRUCTURES, Biome.func_222280_a(Feature.field_204292_r, IFeatureConfig.field_202429_e, Placement.field_215022_h, IPlacementConfig.field_202468_e));
    }
}

