/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.biome;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import it.unimi.dsi.fastutil.longs.Long2FloatLinkedOpenHashMap;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.FlowingFluidBlock;
import net.minecraft.crash.CrashReport;
import net.minecraft.crash.ReportedException;
import net.minecraft.entity.EntityClassification;
import net.minecraft.entity.EntityType;
import net.minecraft.fluid.Fluids;
import net.minecraft.fluid.IFluidState;
import net.minecraft.util.ObjectIntIdentityMap;
import net.minecraft.util.SharedSeedRandom;
import net.minecraft.util.Util;
import net.minecraft.util.WeightedRandom;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.registry.Registry;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.FoliageColors;
import net.minecraft.world.GrassColors;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.LightType;
import net.minecraft.world.chunk.IChunk;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.GenerationSettings;
import net.minecraft.world.gen.GenerationStage;
import net.minecraft.world.gen.PerlinNoiseGenerator;
import net.minecraft.world.gen.carver.ConfiguredCarver;
import net.minecraft.world.gen.carver.ICarverConfig;
import net.minecraft.world.gen.carver.WorldCarver;
import net.minecraft.world.gen.feature.ConfiguredFeature;
import net.minecraft.world.gen.feature.DecoratedFeatureConfig;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.FlowersFeature;
import net.minecraft.world.gen.feature.IFeatureConfig;
import net.minecraft.world.gen.feature.structure.Structure;
import net.minecraft.world.gen.placement.IPlacementConfig;
import net.minecraft.world.gen.placement.Placement;
import net.minecraft.world.gen.surfacebuilders.ConfiguredSurfaceBuilder;
import net.minecraft.world.gen.surfacebuilders.ISurfaceBuilderConfig;
import net.minecraft.world.gen.surfacebuilders.SurfaceBuilder;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class Biome {
    public static final Logger field_150586_aC = LogManager.getLogger();
    public static final Set<Biome> field_201870_ab = Sets.newHashSet();
    public static final ObjectIntIdentityMap<Biome> field_185373_j = new ObjectIntIdentityMap();
    protected static final PerlinNoiseGenerator field_150605_ac = new PerlinNoiseGenerator(new Random(1234L), 1);
    public static final PerlinNoiseGenerator field_180281_af = new PerlinNoiseGenerator(new Random(2345L), 1);
    @Nullable
    protected String field_205405_aL;
    protected final float field_76748_D;
    protected final float field_76749_E;
    protected final float field_76750_F;
    protected final float field_76751_G;
    protected final int field_76759_H;
    protected final int field_204275_aE;
    @Nullable
    protected final String field_185364_H;
    protected final ConfiguredSurfaceBuilder<?> field_201875_ar;
    protected final Category field_201877_au;
    protected final RainType field_201878_av;
    protected final Map<GenerationStage.Carving, List<ConfiguredCarver<?>>> field_201871_ag = Maps.newHashMap();
    protected final Map<GenerationStage.Decoration, List<ConfiguredFeature<?>>> field_201872_ah = Maps.newHashMap();
    protected final List<ConfiguredFeature<?>> field_201873_ai = Lists.newArrayList();
    protected final Map<Structure<?>, IFeatureConfig> field_201874_aj = Maps.newHashMap();
    private final Map<EntityClassification, List<SpawnListEntry>> field_201880_ax = Maps.newHashMap();
    private final ThreadLocal<Long2FloatLinkedOpenHashMap> field_225488_v = ThreadLocal.withInitial(() -> Util.func_199748_a(() -> {
        Long2FloatLinkedOpenHashMap long2FloatLinkedOpenHashMap = new Long2FloatLinkedOpenHashMap(1024, 0.25f){

            protected void rehash(int n) {
            }
        };
        long2FloatLinkedOpenHashMap.defaultReturnValue(Float.NaN);
        return long2FloatLinkedOpenHashMap;
    }));

    @Nullable
    public static Biome func_185356_b(Biome biome) {
        return field_185373_j.func_148745_a(Registry.field_212624_m.func_148757_b(biome));
    }

    public static <C extends ICarverConfig> ConfiguredCarver<C> func_203606_a(WorldCarver<C> worldCarver, C c) {
        return new ConfiguredCarver<C>(worldCarver, c);
    }

    public static <F extends IFeatureConfig, D extends IPlacementConfig> ConfiguredFeature<?> func_222280_a(Feature<F> feature, F f, Placement<D> placement, D d) {
        Feature<DecoratedFeatureConfig> feature2 = feature instanceof FlowersFeature ? Feature.field_214484_aL : Feature.field_214483_aK;
        return new ConfiguredFeature<DecoratedFeatureConfig>(feature2, new DecoratedFeatureConfig(feature, f, placement, d));
    }

    protected Biome(Builder builder) {
        if (builder.field_205422_a == null || builder.field_205423_b == null || builder.field_205424_c == null || builder.field_205425_d == null || builder.field_205426_e == null || builder.field_205427_f == null || builder.field_205428_g == null || builder.field_205429_h == null || builder.field_205430_i == null) {
            throw new IllegalStateException("You are missing parameters to build a proper biome for " + this.getClass().getSimpleName() + "\n" + builder);
        }
        this.field_201875_ar = builder.field_205422_a;
        this.field_201878_av = builder.field_205423_b;
        this.field_201877_au = builder.field_205424_c;
        this.field_76748_D = builder.field_205425_d.floatValue();
        this.field_76749_E = builder.field_205426_e.floatValue();
        this.field_76750_F = builder.field_205427_f.floatValue();
        this.field_76751_G = builder.field_205428_g.floatValue();
        this.field_76759_H = builder.field_205429_h;
        this.field_204275_aE = builder.field_205430_i;
        this.field_185364_H = builder.field_205431_j;
        for (GenerationStage.Decoration decoration : GenerationStage.Decoration.values()) {
            this.field_201872_ah.put(decoration, Lists.newArrayList());
        }
        for (Enum enum_ : EntityClassification.values()) {
            this.field_201880_ax.put((EntityClassification)enum_, Lists.newArrayList());
        }
    }

    public boolean func_185363_b() {
        return this.field_185364_H != null;
    }

    public int func_76731_a(float f) {
        f /= 3.0f;
        f = MathHelper.func_76131_a(f, -1.0f, 1.0f);
        return MathHelper.func_181758_c(0.62222224f - f * 0.05f, 0.5f + f * 0.1f, 1.0f);
    }

    protected void func_201866_a(EntityClassification entityClassification, SpawnListEntry spawnListEntry) {
        this.field_201880_ax.get((Object)entityClassification).add(spawnListEntry);
    }

    public List<SpawnListEntry> func_76747_a(EntityClassification entityClassification) {
        return this.field_201880_ax.get((Object)entityClassification);
    }

    public RainType func_201851_b() {
        return this.field_201878_av;
    }

    public boolean func_76736_e() {
        return this.func_76727_i() > 0.85f;
    }

    public float func_76741_f() {
        return 0.1f;
    }

    protected float func_180626_a(BlockPos blockPos) {
        if (blockPos.func_177956_o() > 64) {
            float f = (float)(field_150605_ac.func_151601_a((float)blockPos.func_177958_n() / 8.0f, (float)blockPos.func_177952_p() / 8.0f) * 4.0);
            return this.func_185353_n() - (f + (float)blockPos.func_177956_o() - 64.0f) * 0.05f / 30.0f;
        }
        return this.func_185353_n();
    }

    public final float func_225486_c(BlockPos blockPos) {
        long l = blockPos.func_218275_a();
        Long2FloatLinkedOpenHashMap \u26032 = this.field_225488_v.get();
        float \u26033 = \u26032.get(l);
        if (!Float.isNaN(\u26033)) {
            return \u26033;
        }
        float \u26034 = this.func_180626_a(blockPos);
        if (\u26032.size() == 1024) {
            \u26032.removeFirstFloat();
        }
        \u26032.put(l, \u26034);
        return \u26034;
    }

    public boolean func_201848_a(IWorldReader iWorldReader, BlockPos blockPos) {
        return this.func_201854_a(iWorldReader, blockPos, true);
    }

    public boolean func_201854_a(IWorldReader iWorldReader, BlockPos blockPos, boolean bl) {
        if (this.func_225486_c(blockPos) >= 0.15f) {
            return false;
        }
        if (blockPos.func_177956_o() >= 0 && blockPos.func_177956_o() < 256 && iWorldReader.func_175642_b(LightType.BLOCK, blockPos) < 10) {
            BlockState blockState = iWorldReader.func_180495_p(blockPos);
            IFluidState \u26032 = iWorldReader.func_204610_c(blockPos);
            if (\u26032.func_206886_c() == Fluids.field_204546_a && blockState.func_177230_c() instanceof FlowingFluidBlock) {
                if (!bl) {
                    return true;
                }
                boolean bl2 = \u2603 = iWorldReader.func_201671_F(blockPos.func_177976_e()) && iWorldReader.func_201671_F(blockPos.func_177974_f()) && iWorldReader.func_201671_F(blockPos.func_177978_c()) && iWorldReader.func_201671_F(blockPos.func_177968_d());
                if (!\u2603) {
                    return true;
                }
            }
        }
        return false;
    }

    public boolean func_201850_b(IWorldReader iWorldReader, BlockPos blockPos) {
        if (this.func_225486_c(blockPos) >= 0.15f) {
            return false;
        }
        return blockPos.func_177956_o() >= 0 && blockPos.func_177956_o() < 256 && iWorldReader.func_175642_b(LightType.BLOCK, blockPos) < 10 && (\u2603 = iWorldReader.func_180495_p(blockPos)).func_196958_f() && Blocks.field_150433_aE.func_176223_P().func_196955_c(iWorldReader, blockPos);
    }

    public void func_203611_a(GenerationStage.Decoration decoration, ConfiguredFeature<?> configuredFeature) {
        if (configuredFeature.field_222737_a == Feature.field_214484_aL) {
            this.field_201873_ai.add(configuredFeature);
        }
        this.field_201872_ah.get((Object)decoration).add(configuredFeature);
    }

    public <C extends ICarverConfig> void func_203609_a(GenerationStage.Carving carving2, ConfiguredCarver<C> configuredCarver) {
        this.field_201871_ag.computeIfAbsent(carving2, carving -> Lists.newArrayList()).add(configuredCarver);
    }

    public List<ConfiguredCarver<?>> func_203603_a(GenerationStage.Carving carving2) {
        return this.field_201871_ag.computeIfAbsent(carving2, carving -> Lists.newArrayList());
    }

    public <C extends IFeatureConfig> void func_201865_a(Structure<C> structure, C c) {
        this.field_201874_aj.put(structure, c);
    }

    public <C extends IFeatureConfig> boolean func_201858_a(Structure<C> structure) {
        return this.field_201874_aj.containsKey(structure);
    }

    @Nullable
    public <C extends IFeatureConfig> C func_201857_b(Structure<C> structure) {
        return (C)this.field_201874_aj.get(structure);
    }

    public List<ConfiguredFeature<?>> func_201853_g() {
        return this.field_201873_ai;
    }

    public List<ConfiguredFeature<?>> func_203607_a(GenerationStage.Decoration decoration) {
        return this.field_201872_ah.get((Object)decoration);
    }

    public void func_203608_a(GenerationStage.Decoration decoration, ChunkGenerator<? extends GenerationSettings> chunkGenerator, IWorld iWorld, long l, SharedSeedRandom sharedSeedRandom, BlockPos blockPos) {
        int n = 0;
        for (ConfiguredFeature<?> configuredFeature : this.field_201872_ah.get((Object)decoration)) {
            sharedSeedRandom.func_202426_b(l, n, decoration.ordinal());
            try {
                configuredFeature.func_222734_a(iWorld, chunkGenerator, sharedSeedRandom, blockPos);
            }
            catch (Exception exception) {
                CrashReport crashReport = CrashReport.func_85055_a(exception, "Feature placement");
                crashReport.func_85058_a("Feature").func_71507_a("Id", Registry.field_218379_q.func_177774_c(configuredFeature.field_222737_a)).func_189529_a("Description", configuredFeature.field_222737_a::toString);
                throw new ReportedException(crashReport);
            }
            ++n;
        }
    }

    public int func_180627_b(BlockPos blockPos) {
        double d = MathHelper.func_76131_a(this.func_225486_c(blockPos), 0.0f, 1.0f);
        \u2603 = MathHelper.func_76131_a(this.func_76727_i(), 0.0f, 1.0f);
        return GrassColors.func_77480_a(d, \u2603);
    }

    public int func_180625_c(BlockPos blockPos) {
        double d = MathHelper.func_76131_a(this.func_225486_c(blockPos), 0.0f, 1.0f);
        \u2603 = MathHelper.func_76131_a(this.func_76727_i(), 0.0f, 1.0f);
        return FoliageColors.func_77470_a(d, \u2603);
    }

    public void func_206854_a(Random random, IChunk iChunk, int n, int n2, int n3, double d, BlockState blockState, BlockState blockState2, int n4, long l) {
        this.field_201875_ar.func_215451_a(l);
        this.field_201875_ar.func_215450_a(random, iChunk, this, n, n2, n3, d, blockState, blockState2, n4, l);
    }

    public TempCategory func_150561_m() {
        if (this.field_201877_au == Category.OCEAN) {
            return TempCategory.OCEAN;
        }
        if ((double)this.func_185353_n() < 0.2) {
            return TempCategory.COLD;
        }
        if ((double)this.func_185353_n() < 1.0) {
            return TempCategory.MEDIUM;
        }
        return TempCategory.WARM;
    }

    public final float func_185355_j() {
        return this.field_76748_D;
    }

    public final float func_76727_i() {
        return this.field_76751_G;
    }

    public ITextComponent func_205403_k() {
        return new TranslationTextComponent(this.func_210773_k(), new Object[0]);
    }

    public String func_210773_k() {
        if (this.field_205405_aL == null) {
            this.field_205405_aL = Util.func_200697_a("biome", Registry.field_212624_m.func_177774_c(this));
        }
        return this.field_205405_aL;
    }

    public final float func_185360_m() {
        return this.field_76749_E;
    }

    public final float func_185353_n() {
        return this.field_76750_F;
    }

    public final int func_185361_o() {
        return this.field_76759_H;
    }

    public final int func_204274_p() {
        return this.field_204275_aE;
    }

    public final Category func_201856_r() {
        return this.field_201877_au;
    }

    public ConfiguredSurfaceBuilder<?> func_205401_q() {
        return this.field_201875_ar;
    }

    public ISurfaceBuilderConfig func_203944_q() {
        return this.field_201875_ar.func_215452_a();
    }

    @Nullable
    public String func_205402_s() {
        return this.field_185364_H;
    }

    public static class Builder {
        @Nullable
        private ConfiguredSurfaceBuilder<?> field_205422_a;
        @Nullable
        private RainType field_205423_b;
        @Nullable
        private Category field_205424_c;
        @Nullable
        private Float field_205425_d;
        @Nullable
        private Float field_205426_e;
        @Nullable
        private Float field_205427_f;
        @Nullable
        private Float field_205428_g;
        @Nullable
        private Integer field_205429_h;
        @Nullable
        private Integer field_205430_i;
        @Nullable
        private String field_205431_j;

        public <SC extends ISurfaceBuilderConfig> Builder func_222351_a(SurfaceBuilder<SC> surfaceBuilder, SC SC) {
            this.field_205422_a = new ConfiguredSurfaceBuilder<SC>(surfaceBuilder, SC);
            return this;
        }

        public Builder func_205416_a(ConfiguredSurfaceBuilder<?> configuredSurfaceBuilder) {
            this.field_205422_a = configuredSurfaceBuilder;
            return this;
        }

        public Builder func_205415_a(RainType rainType) {
            this.field_205423_b = rainType;
            return this;
        }

        public Builder func_205419_a(Category category) {
            this.field_205424_c = category;
            return this;
        }

        public Builder func_205421_a(float f) {
            this.field_205425_d = Float.valueOf(f);
            return this;
        }

        public Builder func_205420_b(float f) {
            this.field_205426_e = Float.valueOf(f);
            return this;
        }

        public Builder func_205414_c(float f) {
            this.field_205427_f = Float.valueOf(f);
            return this;
        }

        public Builder func_205417_d(float f) {
            this.field_205428_g = Float.valueOf(f);
            return this;
        }

        public Builder func_205412_a(int n) {
            this.field_205429_h = n;
            return this;
        }

        public Builder func_205413_b(int n) {
            this.field_205430_i = n;
            return this;
        }

        public Builder func_205418_a(@Nullable String string) {
            this.field_205431_j = string;
            return this;
        }

        public String toString() {
            return "BiomeBuilder{\nsurfaceBuilder=" + this.field_205422_a + ",\nprecipitation=" + (Object)((Object)this.field_205423_b) + ",\nbiomeCategory=" + (Object)((Object)this.field_205424_c) + ",\ndepth=" + this.field_205425_d + ",\nscale=" + this.field_205426_e + ",\ntemperature=" + this.field_205427_f + ",\ndownfall=" + this.field_205428_g + ",\nwaterColor=" + this.field_205429_h + ",\nwaterFogColor=" + this.field_205430_i + ",\nparent='" + this.field_205431_j + '\'' + "\n" + '}';
        }
    }

    public static class SpawnListEntry
    extends WeightedRandom.Item {
        public final EntityType<?> field_200702_b;
        public final int field_76301_c;
        public final int field_76299_d;

        public SpawnListEntry(EntityType<?> entityType, int n, int n2, int n3) {
            super(n);
            this.field_200702_b = entityType;
            this.field_76301_c = n2;
            this.field_76299_d = n3;
        }

        public String toString() {
            return EntityType.func_200718_a(this.field_200702_b) + "*(" + this.field_76301_c + "-" + this.field_76299_d + "):" + this.field_76292_a;
        }
    }

    public static enum RainType {
        NONE("none"),
        RAIN("rain"),
        SNOW("snow");

        private static final Map<String, RainType> field_222362_d;
        private final String field_222363_e;

        private RainType(String string2) {
            this.field_222363_e = string2;
        }

        public String func_222361_a() {
            return this.field_222363_e;
        }

        static {
            field_222362_d = Arrays.stream(RainType.values()).collect(Collectors.toMap(RainType::func_222361_a, rainType -> rainType));
        }
    }

    public static enum Category {
        NONE("none"),
        TAIGA("taiga"),
        EXTREME_HILLS("extreme_hills"),
        JUNGLE("jungle"),
        MESA("mesa"),
        PLAINS("plains"),
        SAVANNA("savanna"),
        ICY("icy"),
        THEEND("the_end"),
        BEACH("beach"),
        FOREST("forest"),
        OCEAN("ocean"),
        DESERT("desert"),
        RIVER("river"),
        SWAMP("swamp"),
        MUSHROOM("mushroom"),
        NETHER("nether");

        private static final Map<String, Category> field_222354_r;
        private final String field_222355_s;

        private Category(String string2) {
            this.field_222355_s = string2;
        }

        public String func_222352_a() {
            return this.field_222355_s;
        }

        static {
            field_222354_r = Arrays.stream(Category.values()).collect(Collectors.toMap(Category::func_222352_a, category -> category));
        }
    }

    public static enum TempCategory {
        OCEAN("ocean"),
        COLD("cold"),
        MEDIUM("medium"),
        WARM("warm");

        private static final Map<String, TempCategory> field_222358_e;
        private final String field_222359_f;

        private TempCategory(String string2) {
            this.field_222359_f = string2;
        }

        public String func_222357_a() {
            return this.field_222359_f;
        }

        static {
            field_222358_e = Arrays.stream(TempCategory.values()).collect(Collectors.toMap(TempCategory::func_222357_a, tempCategory -> tempCategory));
        }
    }
}

