/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world;

import com.google.common.collect.Maps;
import it.unimi.dsi.fastutil.longs.LongIterator;
import it.unimi.dsi.fastutil.objects.Object2LongMap;
import it.unimi.dsi.fastutil.objects.Object2LongOpenHashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.NetherPortalBlock;
import net.minecraft.block.pattern.BlockPattern;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.ColumnPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.server.ServerWorld;
import net.minecraft.world.server.TicketType;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.util.Supplier;

public class Teleporter {
    private static final Logger field_222274_a = LogManager.getLogger();
    private static final NetherPortalBlock field_196236_a = (NetherPortalBlock)Blocks.field_150427_aO;
    private final ServerWorld field_85192_a;
    private final Random field_77187_a;
    private final Map<ColumnPos, PortalPosition> field_85191_c = Maps.newHashMapWithExpectedSize((int)4096);
    private final Object2LongMap<ColumnPos> field_222275_f = new Object2LongOpenHashMap();

    public Teleporter(ServerWorld serverWorld) {
        this.field_85192_a = serverWorld;
        this.field_77187_a = new Random(serverWorld.func_72905_C());
    }

    public boolean func_222268_a(Entity entity, float f) {
        Vec3d vec3d = entity.func_181014_aG();
        Direction \u26032 = entity.func_181012_aH();
        BlockPattern.PortalInfo \u26033 = this.func_222272_a(new BlockPos(entity), entity.func_213322_ci(), \u26032, vec3d.field_72450_a, vec3d.field_72448_b, entity instanceof PlayerEntity);
        if (\u26033 == null) {
            return false;
        }
        \u2603 = \u26033.field_222505_a;
        \u2603 = \u26033.field_222506_b;
        entity.func_213317_d(\u2603);
        entity.field_70177_z = f + (float)\u26033.field_222507_c;
        if (entity instanceof ServerPlayerEntity) {
            ((ServerPlayerEntity)entity).field_71135_a.func_147364_a(\u2603.field_72450_a, \u2603.field_72448_b, \u2603.field_72449_c, entity.field_70177_z, entity.field_70125_A);
            ((ServerPlayerEntity)entity).field_71135_a.func_184342_d();
        } else {
            entity.func_70012_b(\u2603.field_72450_a, \u2603.field_72448_b, \u2603.field_72449_c, entity.field_70177_z, entity.field_70125_A);
        }
        return true;
    }

    @Nullable
    public BlockPattern.PortalInfo func_222272_a(BlockPos blockPos, Vec3d vec3d, Direction direction, double d, double d2, boolean bl) {
        int n = 128;
        boolean \u26032 = true;
        BlockPos \u26033 = null;
        ColumnPos \u26034 = new ColumnPos(blockPos);
        if (!bl && this.field_222275_f.containsKey((Object)\u26034)) {
            return null;
        }
        PortalPosition \u26035 = this.field_85191_c.get(\u26034);
        if (\u26035 != null) {
            \u26033 = \u26035.field_222267_a;
            \u26035.field_85087_d = this.field_85192_a.func_82737_E();
            \u26032 = false;
        } else {
            double d3 = Double.MAX_VALUE;
            for (int i = -128; i <= 128; ++i) {
                for (\u2603 = -128; \u2603 <= 128; ++\u2603) {
                    BlockPos blockPos2 = blockPos.func_177982_a(i, this.field_85192_a.func_72940_L() - 1 - blockPos.func_177956_o(), \u2603);
                    while (blockPos2.func_177956_o() >= 0) {
                        BlockPos blockPos3;
                        blockPos3 = blockPos2.func_177977_b();
                        if (this.field_85192_a.func_180495_p(blockPos2).func_177230_c() == field_196236_a) {
                            blockPos3 = blockPos2.func_177977_b();
                            while (this.field_85192_a.func_180495_p(blockPos3).func_177230_c() == field_196236_a) {
                                blockPos2 = blockPos3;
                                blockPos3 = blockPos2.func_177977_b();
                            }
                            double d4 = blockPos2.func_177951_i(blockPos);
                            if (d3 < 0.0 || d4 < d3) {
                                d3 = d4;
                                \u26033 = blockPos2;
                            }
                        }
                        blockPos2 = blockPos3;
                    }
                }
            }
        }
        if (\u26033 == null) {
            long l = this.field_85192_a.func_82737_E() + 300L;
            this.field_222275_f.put((Object)\u26034, l);
            return null;
        }
        if (\u26032) {
            this.field_85191_c.put(\u26034, new PortalPosition(\u26033, this.field_85192_a.func_82737_E()));
            Supplier[] supplierArray = new Supplier[2];
            supplierArray[0] = this.field_85192_a.func_201675_m()::func_186058_p;
            supplierArray[1] = () -> \u26034;
            field_222274_a.debug("Adding nether portal ticket for {}:{}", supplierArray);
            this.field_85192_a.func_72863_F().func_217228_a(TicketType.field_219493_f, new ChunkPos(\u26033), 3, \u26034);
        }
        BlockPattern.PatternHelper patternHelper = field_196236_a.func_181089_f(this.field_85192_a, \u26033);
        return patternHelper.func_222504_a(direction, \u26033, d2, vec3d, d);
    }

    public boolean func_85188_a(Entity entity) {
        int n;
        int \u26037;
        int \u26036;
        int \u26035;
        int \u26034;
        int n2;
        double d;
        int n3;
        double d2;
        int n4 = 16;
        double \u26032 = -1.0;
        \u2603 = MathHelper.func_76128_c(entity.field_70165_t);
        \u2603 = MathHelper.func_76128_c(entity.field_70163_u);
        \u2603 = MathHelper.func_76128_c(entity.field_70161_v);
        \u26034 = \u2603;
        \u26035 = \u2603;
        \u26036 = \u2603;
        \u26037 = 0;
        \u2603 = this.field_77187_a.nextInt(4);
        BlockPos.MutableBlockPos \u26033 = new BlockPos.MutableBlockPos();
        for (n = \u2603 - 16; n <= \u2603 + 16; ++n) {
            d2 = (double)n + 0.5 - entity.field_70165_t;
            for (n3 = \u2603 - 16; n3 <= \u2603 + 16; ++n3) {
                d = (double)n3 + 0.5 - entity.field_70161_v;
                block2: for (n2 = this.field_85192_a.func_72940_L() - 1; n2 >= 0; --n2) {
                    if (!this.field_85192_a.func_175623_d(\u26033.func_181079_c(n, n2, n3))) continue;
                    while (n2 > 0 && this.field_85192_a.func_175623_d(\u26033.func_181079_c(n, n2 - 1, n3))) {
                        --n2;
                    }
                    for (\u2603 = \u2603; \u2603 < \u2603 + 4; ++\u2603) {
                        \u2603 = \u2603 % 2;
                        \u2603 = 1 - \u2603;
                        if (\u2603 % 4 >= 2) {
                            \u2603 = -\u2603;
                            \u2603 = -\u2603;
                        }
                        for (\u2603 = 0; \u2603 < 3; ++\u2603) {
                            for (\u2603 = 0; \u2603 < 4; ++\u2603) {
                                for (\u2603 = -1; \u2603 < 4; ++\u2603) {
                                    \u2603 = n + (\u2603 - 1) * \u2603 + \u2603 * \u2603;
                                    \u2603 = n2 + \u2603;
                                    \u2603 = n3 + (\u2603 - 1) * \u2603 - \u2603 * \u2603;
                                    \u26033.func_181079_c(\u2603, \u2603, \u2603);
                                    if (\u2603 < 0 && !this.field_85192_a.func_180495_p(\u26033).func_185904_a().func_76220_a() || \u2603 >= 0 && !this.field_85192_a.func_175623_d(\u26033)) continue block2;
                                }
                            }
                        }
                        double d3 = (double)n2 + 0.5 - entity.field_70163_u;
                        \u2603 = d2 * d2 + d3 * d3 + d * d;
                        if (!(\u26032 < 0.0) && !(\u2603 < \u26032)) continue;
                        \u26032 = \u2603;
                        \u26034 = n;
                        \u26035 = n2;
                        \u26036 = n3;
                        \u26037 = \u2603 % 4;
                    }
                }
            }
        }
        if (\u26032 < 0.0) {
            for (n = \u2603 - 16; n <= \u2603 + 16; ++n) {
                d2 = (double)n + 0.5 - entity.field_70165_t;
                for (n3 = \u2603 - 16; n3 <= \u2603 + 16; ++n3) {
                    d = (double)n3 + 0.5 - entity.field_70161_v;
                    block10: for (n2 = this.field_85192_a.func_72940_L() - 1; n2 >= 0; --n2) {
                        if (!this.field_85192_a.func_175623_d(\u26033.func_181079_c(n, n2, n3))) continue;
                        while (n2 > 0 && this.field_85192_a.func_175623_d(\u26033.func_181079_c(n, n2 - 1, n3))) {
                            --n2;
                        }
                        for (\u2603 = \u2603; \u2603 < \u2603 + 2; ++\u2603) {
                            \u2603 = \u2603 % 2;
                            \u2603 = 1 - \u2603;
                            for (\u2603 = 0; \u2603 < 4; ++\u2603) {
                                for (\u2603 = -1; \u2603 < 4; ++\u2603) {
                                    \u2603 = n + (\u2603 - 1) * \u2603;
                                    \u2603 = n2 + \u2603;
                                    \u2603 = n3 + (\u2603 - 1) * \u2603;
                                    \u26033.func_181079_c(\u2603, \u2603, \u2603);
                                    if (\u2603 < 0 && !this.field_85192_a.func_180495_p(\u26033).func_185904_a().func_76220_a() || \u2603 >= 0 && !this.field_85192_a.func_175623_d(\u26033)) continue block10;
                                }
                            }
                            double d4 = (double)n2 + 0.5 - entity.field_70163_u;
                            \u2603 = d2 * d2 + d4 * d4 + d * d;
                            if (!(\u26032 < 0.0) && !(\u2603 < \u26032)) continue;
                            \u26032 = \u2603;
                            \u26034 = n;
                            \u26035 = n2;
                            \u26036 = n3;
                            \u26037 = \u2603 % 2;
                        }
                    }
                }
            }
        }
        n = \u26037;
        \u2603 = \u26034;
        \u2603 = \u26035;
        n3 = \u26036;
        \u2603 = n % 2;
        \u2603 = 1 - \u2603;
        if (n % 4 >= 2) {
            \u2603 = -\u2603;
            \u2603 = -\u2603;
        }
        if (\u26032 < 0.0) {
            \u2603 = \u26035 = MathHelper.func_76125_a(\u26035, 70, this.field_85192_a.func_72940_L() - 10);
            for (n2 = -1; n2 <= 1; ++n2) {
                for (\u2603 = 1; \u2603 < 3; ++\u2603) {
                    for (\u2603 = -1; \u2603 < 3; ++\u2603) {
                        \u2603 = \u2603 + (\u2603 - 1) * \u2603 + n2 * \u2603;
                        \u2603 = \u2603 + \u2603;
                        \u2603 = n3 + (\u2603 - 1) * \u2603 - n2 * \u2603;
                        \u2603 = \u2603 < 0 ? 1 : 0;
                        \u26033.func_181079_c(\u2603, \u2603, \u2603);
                        this.field_85192_a.func_175656_a(\u26033, \u2603 != 0 ? Blocks.field_150343_Z.func_176223_P() : Blocks.field_150350_a.func_176223_P());
                    }
                }
            }
        }
        for (n2 = -1; n2 < 3; ++n2) {
            for (\u2603 = -1; \u2603 < 4; ++\u2603) {
                if (n2 != -1 && n2 != 2 && \u2603 != -1 && \u2603 != 3) continue;
                \u26033.func_181079_c(\u2603 + n2 * \u2603, \u2603 + \u2603, n3 + n2 * \u2603);
                this.field_85192_a.func_180501_a(\u26033, Blocks.field_150343_Z.func_176223_P(), 3);
            }
        }
        BlockState \u26038 = (BlockState)field_196236_a.func_176223_P().func_206870_a(NetherPortalBlock.field_176550_a, \u2603 == 0 ? Direction.Axis.Z : Direction.Axis.X);
        for (\u2603 = 0; \u2603 < 2; ++\u2603) {
            for (\u2603 = 0; \u2603 < 3; ++\u2603) {
                \u26033.func_181079_c(\u2603 + \u2603 * \u2603, \u2603 + \u2603, n3 + \u2603 * \u2603);
                this.field_85192_a.func_180501_a(\u26033, \u26038, 18);
            }
        }
        return true;
    }

    public void func_85189_a(long l) {
        if (l % 100L == 0L) {
            this.func_222270_b(l);
            this.func_222269_c(l);
        }
    }

    private void func_222270_b(long l) {
        LongIterator longIterator = this.field_222275_f.values().iterator();
        while (longIterator.hasNext()) {
            long l2 = longIterator.nextLong();
            if (l2 > l) continue;
            longIterator.remove();
        }
    }

    private void func_222269_c(long l) {
        \u2603 = l - 300L;
        Iterator<Map.Entry<ColumnPos, PortalPosition>> iterator = this.field_85191_c.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<ColumnPos, PortalPosition> entry = iterator.next();
            PortalPosition \u26032 = entry.getValue();
            if (\u26032.field_85087_d >= \u2603) continue;
            ColumnPos \u26033 = entry.getKey();
            Supplier[] supplierArray = new Supplier[2];
            supplierArray[0] = this.field_85192_a.func_201675_m()::func_186058_p;
            supplierArray[1] = () -> \u26033;
            field_222274_a.debug("Removing nether portal ticket for {}:{}", supplierArray);
            this.field_85192_a.func_72863_F().func_217222_b(TicketType.field_219493_f, new ChunkPos(\u26032.field_222267_a), 3, \u26033);
            iterator.remove();
        }
    }

    static class PortalPosition {
        public final BlockPos field_222267_a;
        public long field_85087_d;

        public PortalPosition(BlockPos blockPos, long l) {
            this.field_222267_a = blockPos;
            this.field_85087_d = l;
        }
    }
}

