/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.math;

import com.google.common.collect.AbstractIterator;
import com.google.common.collect.Lists;
import com.mojang.datafixers.Dynamic;
import com.mojang.datafixers.types.DynamicOps;
import java.util.List;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.function.Consumer;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import javax.annotation.concurrent.Immutable;
import net.minecraft.dispenser.IPosition;
import net.minecraft.entity.Entity;
import net.minecraft.util.AxisRotation;
import net.minecraft.util.Direction;
import net.minecraft.util.IDynamicSerializable;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.CubeCoordinateIterator;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Immutable
public class BlockPos
extends Vec3i
implements IDynamicSerializable {
    private static final Logger field_185335_c = LogManager.getLogger();
    public static final BlockPos field_177992_a = new BlockPos(0, 0, 0);
    private static final int field_177990_b;
    private static final int field_177991_c;
    private static final int field_177989_d;
    private static final long field_177994_h;
    private static final long field_177995_i;
    private static final long field_177993_j;
    private static final int field_218292_j;
    private static final int field_218293_k;

    public BlockPos(int n, int n2, int n3) {
        super(n, n2, n3);
    }

    public BlockPos(double d, double d2, double d3) {
        super(d, d2, d3);
    }

    public BlockPos(Entity entity) {
        this(entity.field_70165_t, entity.field_70163_u, entity.field_70161_v);
    }

    public BlockPos(Vec3d vec3d) {
        this(vec3d.field_72450_a, vec3d.field_72448_b, vec3d.field_72449_c);
    }

    public BlockPos(IPosition iPosition) {
        this(iPosition.func_82615_a(), iPosition.func_82617_b(), iPosition.func_82616_c());
    }

    public BlockPos(Vec3i vec3i) {
        this(vec3i.func_177958_n(), vec3i.func_177956_o(), vec3i.func_177952_p());
    }

    public static <T> BlockPos func_218286_a(Dynamic<T> dynamic) {
        Spliterator.OfInt ofInt = dynamic.asIntStream().spliterator();
        if (ofInt.tryAdvance(arg_0 -> BlockPos.func_218285_c(\u2603 = new int[3], arg_0)) && ofInt.tryAdvance(n -> {
            nArray[1] = n;
        })) {
            ofInt.tryAdvance(n -> {
                nArray[2] = n;
            });
        }
        return new BlockPos(\u2603[0], \u2603[1], \u2603[2]);
    }

    @Override
    public <T> T func_218175_a(DynamicOps<T> dynamicOps) {
        return (T)dynamicOps.createIntList(IntStream.of(this.func_177958_n(), this.func_177956_o(), this.func_177952_p()));
    }

    public static long func_218289_a(long l, Direction direction) {
        return BlockPos.func_218291_a(l, direction.func_82601_c(), direction.func_96559_d(), direction.func_82599_e());
    }

    public static long func_218291_a(long l, int n, int n2, int n3) {
        return BlockPos.func_218276_a(BlockPos.func_218290_b(l) + n, BlockPos.func_218274_c(l) + n2, BlockPos.func_218282_d(l) + n3);
    }

    public static int func_218290_b(long l) {
        return (int)(l << 64 - field_218293_k - field_177990_b >> 64 - field_177990_b);
    }

    public static int func_218274_c(long l) {
        return (int)(l << 64 - field_177989_d >> 64 - field_177989_d);
    }

    public static int func_218282_d(long l) {
        return (int)(l << 64 - field_218292_j - field_177991_c >> 64 - field_177991_c);
    }

    public static BlockPos func_218283_e(long l) {
        return new BlockPos(BlockPos.func_218290_b(l), BlockPos.func_218274_c(l), BlockPos.func_218282_d(l));
    }

    public static long func_218276_a(int n, int n2, int n3) {
        long l = 0L;
        l |= ((long)n & field_177994_h) << field_218293_k;
        l |= ((long)n2 & field_177995_i) << 0;
        return l |= ((long)n3 & field_177993_j) << field_218292_j;
    }

    public static long func_218288_f(long l) {
        return l & 0xFFFFFFFFFFFFFFF0L;
    }

    public long func_218275_a() {
        return BlockPos.func_218276_a(this.func_177958_n(), this.func_177956_o(), this.func_177952_p());
    }

    public BlockPos func_177963_a(double d, double d2, double d3) {
        if (d == 0.0 && d2 == 0.0 && d3 == 0.0) {
            return this;
        }
        return new BlockPos((double)this.func_177958_n() + d, (double)this.func_177956_o() + d2, (double)this.func_177952_p() + d3);
    }

    public BlockPos func_177982_a(int n, int n2, int n3) {
        if (n == 0 && n2 == 0 && n3 == 0) {
            return this;
        }
        return new BlockPos(this.func_177958_n() + n, this.func_177956_o() + n2, this.func_177952_p() + n3);
    }

    public BlockPos func_177971_a(Vec3i vec3i) {
        return this.func_177982_a(vec3i.func_177958_n(), vec3i.func_177956_o(), vec3i.func_177952_p());
    }

    public BlockPos func_177973_b(Vec3i vec3i) {
        return this.func_177982_a(-vec3i.func_177958_n(), -vec3i.func_177956_o(), -vec3i.func_177952_p());
    }

    public BlockPos func_177984_a() {
        return this.func_177981_b(1);
    }

    public BlockPos func_177981_b(int n) {
        return this.func_177967_a(Direction.UP, n);
    }

    public BlockPos func_177977_b() {
        return this.func_177979_c(1);
    }

    public BlockPos func_177979_c(int n) {
        return this.func_177967_a(Direction.DOWN, n);
    }

    public BlockPos func_177978_c() {
        return this.func_177964_d(1);
    }

    public BlockPos func_177964_d(int n) {
        return this.func_177967_a(Direction.NORTH, n);
    }

    public BlockPos func_177968_d() {
        return this.func_177970_e(1);
    }

    public BlockPos func_177970_e(int n) {
        return this.func_177967_a(Direction.SOUTH, n);
    }

    public BlockPos func_177976_e() {
        return this.func_177985_f(1);
    }

    public BlockPos func_177985_f(int n) {
        return this.func_177967_a(Direction.WEST, n);
    }

    public BlockPos func_177974_f() {
        return this.func_177965_g(1);
    }

    public BlockPos func_177965_g(int n) {
        return this.func_177967_a(Direction.EAST, n);
    }

    public BlockPos func_177972_a(Direction direction) {
        return this.func_177967_a(direction, 1);
    }

    public BlockPos func_177967_a(Direction direction, int n) {
        if (n == 0) {
            return this;
        }
        return new BlockPos(this.func_177958_n() + direction.func_82601_c() * n, this.func_177956_o() + direction.func_96559_d() * n, this.func_177952_p() + direction.func_82599_e() * n);
    }

    public BlockPos func_190942_a(Rotation rotation) {
        switch (rotation) {
            default: {
                return this;
            }
            case CLOCKWISE_90: {
                return new BlockPos(-this.func_177952_p(), this.func_177956_o(), this.func_177958_n());
            }
            case CLOCKWISE_180: {
                return new BlockPos(-this.func_177958_n(), this.func_177956_o(), -this.func_177952_p());
            }
            case COUNTERCLOCKWISE_90: 
        }
        return new BlockPos(this.func_177952_p(), this.func_177956_o(), -this.func_177958_n());
    }

    @Override
    public BlockPos func_177955_d(Vec3i vec3i) {
        return new BlockPos(this.func_177956_o() * vec3i.func_177952_p() - this.func_177952_p() * vec3i.func_177956_o(), this.func_177952_p() * vec3i.func_177958_n() - this.func_177958_n() * vec3i.func_177952_p(), this.func_177958_n() * vec3i.func_177956_o() - this.func_177956_o() * vec3i.func_177958_n());
    }

    public BlockPos func_185334_h() {
        return this;
    }

    public static Iterable<BlockPos> func_218278_a(BlockPos blockPos, BlockPos blockPos2) {
        return BlockPos.func_191531_b(Math.min(blockPos.func_177958_n(), blockPos2.func_177958_n()), Math.min(blockPos.func_177956_o(), blockPos2.func_177956_o()), Math.min(blockPos.func_177952_p(), blockPos2.func_177952_p()), Math.max(blockPos.func_177958_n(), blockPos2.func_177958_n()), Math.max(blockPos.func_177956_o(), blockPos2.func_177956_o()), Math.max(blockPos.func_177952_p(), blockPos2.func_177952_p()));
    }

    public static Stream<BlockPos> func_218281_b(BlockPos blockPos, BlockPos blockPos2) {
        return BlockPos.func_218287_a(Math.min(blockPos.func_177958_n(), blockPos2.func_177958_n()), Math.min(blockPos.func_177956_o(), blockPos2.func_177956_o()), Math.min(blockPos.func_177952_p(), blockPos2.func_177952_p()), Math.max(blockPos.func_177958_n(), blockPos2.func_177958_n()), Math.max(blockPos.func_177956_o(), blockPos2.func_177956_o()), Math.max(blockPos.func_177952_p(), blockPos2.func_177952_p()));
    }

    public static Stream<BlockPos> func_218287_a(final int n, final int n2, final int n3, final int n4, final int n5, final int n6) {
        return StreamSupport.stream(new Spliterators.AbstractSpliterator<BlockPos>((long)((n4 - n + 1) * (n5 - n2 + 1) * (n6 - n3 + 1)), 64){
            final CubeCoordinateIterator field_218296_a;
            final MutableBlockPos field_218297_b;
            {
                super(l, n8);
                this.field_218296_a = new CubeCoordinateIterator(n, n2, n3, n4, n5, n6);
                this.field_218297_b = new MutableBlockPos();
            }

            @Override
            public boolean tryAdvance(Consumer<? super BlockPos> consumer) {
                if (this.field_218296_a.func_218301_a()) {
                    consumer.accept(this.field_218297_b.func_181079_c(this.field_218296_a.func_218304_b(), this.field_218296_a.func_218302_c(), this.field_218296_a.func_218303_d()));
                    return true;
                }
                return false;
            }
        }, false);
    }

    public static Iterable<BlockPos> func_191531_b(final int n, final int n2, final int n3, final int n4, final int n5, final int n6) {
        return () -> new AbstractIterator<BlockPos>(){
            final CubeCoordinateIterator field_218298_a;
            final MutableBlockPos field_218299_b;
            {
                this.field_218298_a = new CubeCoordinateIterator(n, n2, n3, n4, n5, n6);
                this.field_218299_b = new MutableBlockPos();
            }

            protected BlockPos computeNext() {
                return this.field_218298_a.func_218301_a() ? this.field_218299_b.func_181079_c(this.field_218298_a.func_218304_b(), this.field_218298_a.func_218302_c(), this.field_218298_a.func_218303_d()) : (BlockPos)this.endOfData();
            }

            protected /* synthetic */ Object computeNext() {
                return this.computeNext();
            }
        };
    }

    @Override
    public /* synthetic */ Vec3i func_177955_d(Vec3i vec3i) {
        return this.func_177955_d(vec3i);
    }

    private static /* synthetic */ void func_218285_c(int[] nArray, int n) {
        nArray[0] = n;
    }

    static {
        field_177991_c = field_177990_b = 1 + MathHelper.func_151239_c(MathHelper.func_151236_b(30000000));
        field_177989_d = 64 - field_177990_b - field_177991_c;
        field_177994_h = (1L << field_177990_b) - 1L;
        field_177995_i = (1L << field_177989_d) - 1L;
        field_177993_j = (1L << field_177991_c) - 1L;
        field_218292_j = field_177989_d;
        field_218293_k = field_177989_d + field_177991_c;
    }

    public static final class PooledMutableBlockPos
    extends MutableBlockPos
    implements AutoCloseable {
        private boolean field_185350_f;
        private static final List<PooledMutableBlockPos> field_185351_g = Lists.newArrayList();

        private PooledMutableBlockPos(int n, int n2, int n3) {
            super(n, n2, n3);
        }

        public static PooledMutableBlockPos func_185346_s() {
            return PooledMutableBlockPos.func_185339_c(0, 0, 0);
        }

        public static PooledMutableBlockPos func_209907_b(Entity entity) {
            return PooledMutableBlockPos.func_185345_c(entity.field_70165_t, entity.field_70163_u, entity.field_70161_v);
        }

        public static PooledMutableBlockPos func_185345_c(double d, double d2, double d3) {
            return PooledMutableBlockPos.func_185339_c(MathHelper.func_76128_c(d), MathHelper.func_76128_c(d2), MathHelper.func_76128_c(d3));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static PooledMutableBlockPos func_185339_c(int n, int n2, int n3) {
            List<PooledMutableBlockPos> list = field_185351_g;
            synchronized (list) {
                if (!field_185351_g.isEmpty() && (\u2603 = field_185351_g.remove(field_185351_g.size() - 1)) != null && \u2603.field_185350_f) {
                    \u2603.field_185350_f = false;
                    \u2603.func_181079_c(n, n2, n3);
                    return \u2603;
                }
            }
            return new PooledMutableBlockPos(n, n2, n3);
        }

        @Override
        public PooledMutableBlockPos func_181079_c(int n, int n2, int n3) {
            return (PooledMutableBlockPos)super.func_181079_c(n, n2, n3);
        }

        @Override
        public PooledMutableBlockPos func_189535_a(Entity entity) {
            return (PooledMutableBlockPos)super.func_189535_a(entity);
        }

        @Override
        public PooledMutableBlockPos func_189532_c(double d, double d2, double d3) {
            return (PooledMutableBlockPos)super.func_189532_c(d, d2, d3);
        }

        @Override
        public PooledMutableBlockPos func_189533_g(Vec3i vec3i) {
            return (PooledMutableBlockPos)super.func_189533_g(vec3i);
        }

        @Override
        public PooledMutableBlockPos func_189536_c(Direction direction) {
            return (PooledMutableBlockPos)super.func_189536_c(direction);
        }

        @Override
        public PooledMutableBlockPos func_189534_c(Direction direction, int n) {
            return (PooledMutableBlockPos)super.func_189534_c(direction, n);
        }

        @Override
        public PooledMutableBlockPos func_196234_d(int n, int n2, int n3) {
            return (PooledMutableBlockPos)super.func_196234_d(n, n2, n3);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void close() {
            List<PooledMutableBlockPos> list = field_185351_g;
            synchronized (list) {
                if (field_185351_g.size() < 100) {
                    field_185351_g.add(this);
                }
                this.field_185350_f = true;
            }
        }

        @Override
        public /* synthetic */ MutableBlockPos func_196234_d(int n, int n2, int n3) {
            return this.func_196234_d(n, n2, n3);
        }

        @Override
        public /* synthetic */ MutableBlockPos func_189534_c(Direction direction, int n) {
            return this.func_189534_c(direction, n);
        }

        @Override
        public /* synthetic */ MutableBlockPos func_189536_c(Direction direction) {
            return this.func_189536_c(direction);
        }

        @Override
        public /* synthetic */ MutableBlockPos func_189533_g(Vec3i vec3i) {
            return this.func_189533_g(vec3i);
        }

        @Override
        public /* synthetic */ MutableBlockPos func_189532_c(double d, double d2, double d3) {
            return this.func_189532_c(d, d2, d3);
        }

        @Override
        public /* synthetic */ MutableBlockPos func_189535_a(Entity entity) {
            return this.func_189535_a(entity);
        }

        @Override
        public /* synthetic */ MutableBlockPos func_181079_c(int n, int n2, int n3) {
            return this.func_181079_c(n, n2, n3);
        }
    }

    public static class MutableBlockPos
    extends BlockPos {
        protected int field_177997_b;
        protected int field_177998_c;
        protected int field_177996_d;

        public MutableBlockPos() {
            this(0, 0, 0);
        }

        public MutableBlockPos(BlockPos blockPos) {
            this(blockPos.func_177958_n(), blockPos.func_177956_o(), blockPos.func_177952_p());
        }

        public MutableBlockPos(int n, int n2, int n3) {
            super(0, 0, 0);
            this.field_177997_b = n;
            this.field_177998_c = n2;
            this.field_177996_d = n3;
        }

        public MutableBlockPos(double d, double d2, double d3) {
            this(MathHelper.func_76128_c(d), MathHelper.func_76128_c(d2), MathHelper.func_76128_c(d3));
        }

        @Override
        public BlockPos func_177963_a(double d, double d2, double d3) {
            return super.func_177963_a(d, d2, d3).func_185334_h();
        }

        @Override
        public BlockPos func_177982_a(int n, int n2, int n3) {
            return super.func_177982_a(n, n2, n3).func_185334_h();
        }

        @Override
        public BlockPos func_177967_a(Direction direction, int n) {
            return super.func_177967_a(direction, n).func_185334_h();
        }

        @Override
        public BlockPos func_190942_a(Rotation rotation) {
            return super.func_190942_a(rotation).func_185334_h();
        }

        @Override
        public int func_177958_n() {
            return this.field_177997_b;
        }

        @Override
        public int func_177956_o() {
            return this.field_177998_c;
        }

        @Override
        public int func_177952_p() {
            return this.field_177996_d;
        }

        public MutableBlockPos func_181079_c(int n, int n2, int n3) {
            this.field_177997_b = n;
            this.field_177998_c = n2;
            this.field_177996_d = n3;
            return this;
        }

        public MutableBlockPos func_189535_a(Entity entity) {
            return this.func_189532_c(entity.field_70165_t, entity.field_70163_u, entity.field_70161_v);
        }

        public MutableBlockPos func_189532_c(double d, double d2, double d3) {
            return this.func_181079_c(MathHelper.func_76128_c(d), MathHelper.func_76128_c(d2), MathHelper.func_76128_c(d3));
        }

        public MutableBlockPos func_189533_g(Vec3i vec3i) {
            return this.func_181079_c(vec3i.func_177958_n(), vec3i.func_177956_o(), vec3i.func_177952_p());
        }

        public MutableBlockPos func_218294_g(long l) {
            return this.func_181079_c(MutableBlockPos.func_218290_b(l), MutableBlockPos.func_218274_c(l), MutableBlockPos.func_218282_d(l));
        }

        public MutableBlockPos func_218295_a(AxisRotation axisRotation, int n, int n2, int n3) {
            return this.func_181079_c(axisRotation.func_197517_a(n, n2, n3, Direction.Axis.X), axisRotation.func_197517_a(n, n2, n3, Direction.Axis.Y), axisRotation.func_197517_a(n, n2, n3, Direction.Axis.Z));
        }

        public MutableBlockPos func_189536_c(Direction direction) {
            return this.func_189534_c(direction, 1);
        }

        public MutableBlockPos func_189534_c(Direction direction, int n) {
            return this.func_181079_c(this.field_177997_b + direction.func_82601_c() * n, this.field_177998_c + direction.func_96559_d() * n, this.field_177996_d + direction.func_82599_e() * n);
        }

        public MutableBlockPos func_196234_d(int n, int n2, int n3) {
            return this.func_181079_c(this.field_177997_b + n, this.field_177998_c + n2, this.field_177996_d + n3);
        }

        public void func_223471_o(int n) {
            this.field_177997_b = n;
        }

        public void func_185336_p(int n) {
            this.field_177998_c = n;
        }

        public void func_223472_q(int n) {
            this.field_177996_d = n;
        }

        @Override
        public BlockPos func_185334_h() {
            return new BlockPos(this);
        }

        @Override
        public /* synthetic */ Vec3i func_177955_d(Vec3i vec3i) {
            return super.func_177955_d(vec3i);
        }
    }
}

