/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.tileentity;

import java.util.List;
import java.util.stream.IntStream;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.ShulkerBoxBlock;
import net.minecraft.block.material.PushReaction;
import net.minecraft.entity.Entity;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.inventory.ItemStackHelper;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.ShulkerBoxContainer;
import net.minecraft.item.DyeColor;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.LockableLootTileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.NonNullList;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;

public class ShulkerBoxTileEntity
extends LockableLootTileEntity
implements ISidedInventory,
ITickableTileEntity {
    private static final int[] field_190595_a = IntStream.range(0, 27).toArray();
    private NonNullList<ItemStack> field_190596_f = NonNullList.func_191197_a(27, ItemStack.field_190927_a);
    private int field_190598_h;
    private AnimationStatus field_190599_i = AnimationStatus.CLOSED;
    private float field_190600_j;
    private float field_190601_k;
    private DyeColor field_190602_l;
    private boolean field_204400_o;

    public ShulkerBoxTileEntity(@Nullable DyeColor dyeColor) {
        super(TileEntityType.field_200993_x);
        this.field_190602_l = dyeColor;
    }

    public ShulkerBoxTileEntity() {
        this((DyeColor)null);
        this.field_204400_o = true;
    }

    @Override
    public void func_73660_a() {
        this.func_190583_o();
        if (this.field_190599_i == AnimationStatus.OPENING || this.field_190599_i == AnimationStatus.CLOSING) {
            this.func_190589_G();
        }
    }

    protected void func_190583_o() {
        this.field_190601_k = this.field_190600_j;
        switch (this.field_190599_i) {
            case CLOSED: {
                this.field_190600_j = 0.0f;
                break;
            }
            case OPENING: {
                this.field_190600_j += 0.1f;
                if (!(this.field_190600_j >= 1.0f)) break;
                this.func_190589_G();
                this.field_190599_i = AnimationStatus.OPENED;
                this.field_190600_j = 1.0f;
                this.func_213975_v();
                break;
            }
            case CLOSING: {
                this.field_190600_j -= 0.1f;
                if (!(this.field_190600_j <= 0.0f)) break;
                this.field_190599_i = AnimationStatus.CLOSED;
                this.field_190600_j = 0.0f;
                this.func_213975_v();
                break;
            }
            case OPENED: {
                this.field_190600_j = 1.0f;
            }
        }
    }

    public AnimationStatus func_190591_p() {
        return this.field_190599_i;
    }

    public AxisAlignedBB func_190584_a(BlockState blockState) {
        return this.func_190587_b(blockState.func_177229_b(ShulkerBoxBlock.field_190957_a));
    }

    public AxisAlignedBB func_190587_b(Direction direction) {
        float f = this.func_190585_a(1.0f);
        return VoxelShapes.func_197868_b().func_197752_a().func_72321_a(0.5f * f * (float)direction.func_82601_c(), 0.5f * f * (float)direction.func_96559_d(), 0.5f * f * (float)direction.func_82599_e());
    }

    private AxisAlignedBB func_190588_c(Direction direction) {
        \u2603 = direction.func_176734_d();
        return this.func_190587_b(direction).func_191195_a(\u2603.func_82601_c(), \u2603.func_96559_d(), \u2603.func_82599_e());
    }

    private void func_190589_G() {
        BlockState blockState = this.field_145850_b.func_180495_p(this.func_174877_v());
        if (!(blockState.func_177230_c() instanceof ShulkerBoxBlock)) {
            return;
        }
        Direction \u26032 = blockState.func_177229_b(ShulkerBoxBlock.field_190957_a);
        AxisAlignedBB \u26033 = this.func_190588_c(\u26032).func_186670_a(this.field_174879_c);
        List<Entity> \u26034 = this.field_145850_b.func_72839_b(null, \u26033);
        if (\u26034.isEmpty()) {
            return;
        }
        for (int i = 0; i < \u26034.size(); ++i) {
            Entity entity = \u26034.get(i);
            if (entity.func_184192_z() == PushReaction.IGNORE) continue;
            double \u26035 = 0.0;
            double \u26036 = 0.0;
            double \u26037 = 0.0;
            AxisAlignedBB \u26038 = entity.func_174813_aQ();
            switch (\u26032.func_176740_k()) {
                case X: {
                    \u26035 = \u26032.func_176743_c() == Direction.AxisDirection.POSITIVE ? \u26033.field_72336_d - \u26038.field_72340_a : \u26038.field_72336_d - \u26033.field_72340_a;
                    \u26035 += 0.01;
                    break;
                }
                case Y: {
                    \u26036 = \u26032.func_176743_c() == Direction.AxisDirection.POSITIVE ? \u26033.field_72337_e - \u26038.field_72338_b : \u26038.field_72337_e - \u26033.field_72338_b;
                    \u26036 += 0.01;
                    break;
                }
                case Z: {
                    \u26037 = \u26032.func_176743_c() == Direction.AxisDirection.POSITIVE ? \u26033.field_72334_f - \u26038.field_72339_c : \u26038.field_72334_f - \u26033.field_72339_c;
                    \u26037 += 0.01;
                }
            }
            entity.func_213315_a(MoverType.SHULKER_BOX, new Vec3d(\u26035 * (double)\u26032.func_82601_c(), \u26036 * (double)\u26032.func_96559_d(), \u26037 * (double)\u26032.func_82599_e()));
        }
    }

    @Override
    public int func_70302_i_() {
        return this.field_190596_f.size();
    }

    @Override
    public boolean func_145842_c(int n, int n2) {
        if (n == 1) {
            this.field_190598_h = n2;
            if (n2 == 0) {
                this.field_190599_i = AnimationStatus.CLOSING;
                this.func_213975_v();
            }
            if (n2 == 1) {
                this.field_190599_i = AnimationStatus.OPENING;
                this.func_213975_v();
            }
            return true;
        }
        return super.func_145842_c(n, n2);
    }

    private void func_213975_v() {
        this.func_195044_w().func_196946_a(this.func_145831_w(), this.func_174877_v(), 3);
    }

    @Override
    public void func_174889_b(PlayerEntity playerEntity) {
        if (!playerEntity.func_175149_v()) {
            if (this.field_190598_h < 0) {
                this.field_190598_h = 0;
            }
            ++this.field_190598_h;
            this.field_145850_b.func_175641_c(this.field_174879_c, this.func_195044_w().func_177230_c(), 1, this.field_190598_h);
            if (this.field_190598_h == 1) {
                this.field_145850_b.func_184133_a(null, this.field_174879_c, SoundEvents.field_191262_fB, SoundCategory.BLOCKS, 0.5f, this.field_145850_b.field_73012_v.nextFloat() * 0.1f + 0.9f);
            }
        }
    }

    @Override
    public void func_174886_c(PlayerEntity playerEntity) {
        if (!playerEntity.func_175149_v()) {
            --this.field_190598_h;
            this.field_145850_b.func_175641_c(this.field_174879_c, this.func_195044_w().func_177230_c(), 1, this.field_190598_h);
            if (this.field_190598_h <= 0) {
                this.field_145850_b.func_184133_a(null, this.field_174879_c, SoundEvents.field_191261_fA, SoundCategory.BLOCKS, 0.5f, this.field_145850_b.field_73012_v.nextFloat() * 0.1f + 0.9f);
            }
        }
    }

    @Override
    protected ITextComponent func_213907_g() {
        return new TranslationTextComponent("container.shulkerBox", new Object[0]);
    }

    @Override
    public void func_145839_a(CompoundNBT compoundNBT) {
        super.func_145839_a(compoundNBT);
        this.func_190586_e(compoundNBT);
    }

    @Override
    public CompoundNBT func_189515_b(CompoundNBT compoundNBT) {
        super.func_189515_b(compoundNBT);
        return this.func_190580_f(compoundNBT);
    }

    public void func_190586_e(CompoundNBT compoundNBT) {
        this.field_190596_f = NonNullList.func_191197_a(this.func_70302_i_(), ItemStack.field_190927_a);
        if (!this.func_184283_b(compoundNBT) && compoundNBT.func_150297_b("Items", 9)) {
            ItemStackHelper.func_191283_b(compoundNBT, this.field_190596_f);
        }
    }

    public CompoundNBT func_190580_f(CompoundNBT compoundNBT) {
        if (!this.func_184282_c(compoundNBT)) {
            ItemStackHelper.func_191281_a(compoundNBT, this.field_190596_f, false);
        }
        return compoundNBT;
    }

    @Override
    protected NonNullList<ItemStack> func_190576_q() {
        return this.field_190596_f;
    }

    @Override
    protected void func_199721_a(NonNullList<ItemStack> nonNullList) {
        this.field_190596_f = nonNullList;
    }

    @Override
    public boolean func_191420_l() {
        for (ItemStack itemStack : this.field_190596_f) {
            if (itemStack.func_190926_b()) continue;
            return false;
        }
        return true;
    }

    @Override
    public int[] func_180463_a(Direction direction) {
        return field_190595_a;
    }

    @Override
    public boolean func_180462_a(int n, ItemStack itemStack, @Nullable Direction direction) {
        return !(Block.func_149634_a(itemStack.func_77973_b()) instanceof ShulkerBoxBlock);
    }

    @Override
    public boolean func_180461_b(int n, ItemStack itemStack, Direction direction) {
        return true;
    }

    public float func_190585_a(float f) {
        return MathHelper.func_219799_g(f, this.field_190601_k, this.field_190600_j);
    }

    public DyeColor func_190592_s() {
        if (this.field_204400_o) {
            this.field_190602_l = ShulkerBoxBlock.func_190954_c(this.func_195044_w().func_177230_c());
            this.field_204400_o = false;
        }
        return this.field_190602_l;
    }

    @Override
    protected Container func_213906_a(int n, PlayerInventory playerInventory) {
        return new ShulkerBoxContainer(n, playerInventory, this);
    }

    public static enum AnimationStatus {
        CLOSED,
        OPENING,
        OPENED,
        CLOSING;

    }
}

