/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.dedicated;

import com.google.common.base.MoreObjects;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.function.Function;
import java.util.function.IntFunction;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import javax.annotation.Nullable;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class PropertyManager<T extends PropertyManager<T>> {
    private static final Logger field_164440_a = LogManager.getLogger();
    private final Properties field_73672_b;

    public PropertyManager(Properties properties) {
        this.field_73672_b = properties;
    }

    public static Properties func_218969_b(Path path) {
        Properties properties = new Properties();
        try (InputStream inputStream = Files.newInputStream(path, new OpenOption[0]);){
            properties.load(inputStream);
        }
        catch (IOException iOException) {
            field_164440_a.error("Failed to load properties from file: " + path);
        }
        return properties;
    }

    public void func_218970_c(Path path) {
        try (OutputStream outputStream = Files.newOutputStream(path, new OpenOption[0]);){
            this.field_73672_b.store(outputStream, "Minecraft server properties");
        }
        catch (IOException iOException) {
            field_164440_a.error("Failed to store properties to file: " + path);
        }
    }

    private static <V extends Number> Function<String, V> func_218963_a(Function<String, V> function) {
        return string -> {
            try {
                return (Number)function.apply((String)string);
            }
            catch (NumberFormatException numberFormatException) {
                return null;
            }
        };
    }

    protected static <V> Function<String, V> func_218964_a(IntFunction<V> intFunction, Function<String, V> function) {
        return string -> {
            try {
                return intFunction.apply(Integer.parseInt(string));
            }
            catch (NumberFormatException numberFormatException) {
                return function.apply((String)string);
            }
        };
    }

    @Nullable
    private String func_218976_c(String string) {
        return (String)this.field_73672_b.get(string);
    }

    @Nullable
    protected <V> V func_218984_a(String string, Function<String, V> function) {
        String string2 = this.func_218976_c(string);
        if (string2 == null) {
            return null;
        }
        this.field_73672_b.remove(string);
        return function.apply(string2);
    }

    protected <V> V func_218983_a(String string, Function<String, V> function, Function<V, String> function2, V v) {
        String string2 = this.func_218976_c(string);
        Object \u26032 = MoreObjects.firstNonNull(string2 != null ? function.apply(string2) : null, v);
        this.field_73672_b.put(string, function2.apply(\u26032));
        return (V)\u26032;
    }

    protected <V> Property<V> func_218981_b(String string, Function<String, V> function, Function<V, String> function2, V v) {
        String string2 = this.func_218976_c(string);
        Object \u26032 = MoreObjects.firstNonNull(string2 != null ? function.apply(string2) : null, v);
        this.field_73672_b.put(string, function2.apply(\u26032));
        return new Property(string, \u26032, function2);
    }

    protected <V> V func_218977_a(String string2, Function<String, V> function, UnaryOperator<V> unaryOperator, Function<V, String> function2, V v) {
        return (V)this.func_218983_a(string2, string -> {
            Object r = function.apply((String)string);
            return r != null ? unaryOperator.apply(r) : null;
        }, function2, v);
    }

    protected <V> V func_218979_a(String string, Function<String, V> function, V v) {
        return (V)this.func_218983_a(string, function, Objects::toString, v);
    }

    protected <V> Property<V> func_218965_b(String string, Function<String, V> function, V v) {
        return this.func_218981_b(string, function, Objects::toString, v);
    }

    protected String func_218973_a(String string, String string2) {
        return this.func_218983_a(string, Function.identity(), Function.identity(), string2);
    }

    @Nullable
    protected String func_218980_a(String string) {
        return (String)this.func_218984_a(string, Function.identity());
    }

    protected int func_218968_a(String string, int n) {
        return this.func_218979_a(string, PropertyManager.func_218963_a(Integer::parseInt), n);
    }

    protected Property<Integer> func_218974_b(String string, int n) {
        return this.func_218965_b(string, PropertyManager.func_218963_a(Integer::parseInt), n);
    }

    protected int func_218962_a(String string, UnaryOperator<Integer> unaryOperator, int n) {
        return this.func_218977_a(string, PropertyManager.func_218963_a(Integer::parseInt), unaryOperator, Objects::toString, n);
    }

    protected long func_218967_a(String string, long l) {
        return this.func_218979_a(string, PropertyManager.func_218963_a(Long::parseLong), l);
    }

    protected boolean func_218982_a(String string, boolean bl) {
        return this.func_218979_a(string, Boolean::valueOf, bl);
    }

    protected Property<Boolean> func_218961_b(String string, boolean bl) {
        return this.func_218965_b(string, Boolean::valueOf, bl);
    }

    @Nullable
    protected Boolean func_218978_b(String string) {
        return this.func_218984_a(string, Boolean::valueOf);
    }

    protected Properties func_218966_a() {
        Properties properties = new Properties();
        properties.putAll((Map<?, ?>)this.field_73672_b);
        return properties;
    }

    protected abstract T func_212857_b_(Properties var1);

    public class Property<V>
    implements Supplier<V> {
        private final String field_219040_b;
        private final V field_219041_c;
        private final Function<V, String> field_219042_d;

        private Property(String string, V v, Function<V, String> function) {
            this.field_219040_b = string;
            this.field_219041_c = v;
            this.field_219042_d = function;
        }

        @Override
        public V get() {
            return this.field_219041_c;
        }

        public T func_219038_a(V v) {
            Properties properties = PropertyManager.this.func_218966_a();
            properties.put(this.field_219040_b, this.field_219042_d.apply(v));
            return PropertyManager.this.func_212857_b_(properties);
        }
    }
}

