/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.realms;

import java.net.InetAddress;
import java.net.UnknownHostException;
import net.minecraft.client.Minecraft;
import net.minecraft.client.network.login.ClientLoginNetHandler;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.ProtocolType;
import net.minecraft.network.handshake.client.CHandshakePacket;
import net.minecraft.network.login.client.CLoginStartPacket;
import net.minecraft.realms.DisconnectedRealmsScreen;
import net.minecraft.realms.Realms;
import net.minecraft.realms.RealmsScreen;
import net.minecraft.util.text.TranslationTextComponent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class RealmsConnect {
    private static final Logger LOGGER = LogManager.getLogger();
    private final RealmsScreen onlineScreen;
    private volatile boolean aborted;
    private NetworkManager connection;

    public RealmsConnect(RealmsScreen realmsScreen) {
        this.onlineScreen = realmsScreen;
    }

    public void connect(final String string, final int n) {
        Realms.setConnectedToRealms(true);
        Realms.narrateNow(Realms.getLocalizedString("mco.connect.success", new Object[0]));
        new Thread("Realms-connect-task"){

            @Override
            public void run() {
                InetAddress inetAddress = null;
                try {
                    inetAddress = InetAddress.getByName(string);
                    if (RealmsConnect.this.aborted) {
                        return;
                    }
                    RealmsConnect.this.connection = NetworkManager.func_181124_a(inetAddress, n, Minecraft.func_71410_x().field_71474_y.func_181148_f());
                    if (RealmsConnect.this.aborted) {
                        return;
                    }
                    RealmsConnect.this.connection.func_150719_a(new ClientLoginNetHandler(RealmsConnect.this.connection, Minecraft.func_71410_x(), RealmsConnect.this.onlineScreen.getProxy(), iTextComponent -> {}));
                    if (RealmsConnect.this.aborted) {
                        return;
                    }
                    RealmsConnect.this.connection.func_179290_a(new CHandshakePacket(string, n, ProtocolType.LOGIN));
                    if (RealmsConnect.this.aborted) {
                        return;
                    }
                    RealmsConnect.this.connection.func_179290_a(new CLoginStartPacket(Minecraft.func_71410_x().func_110432_I().func_148256_e()));
                }
                catch (UnknownHostException \u26032) {
                    Realms.clearResourcePack();
                    if (RealmsConnect.this.aborted) {
                        return;
                    }
                    LOGGER.error("Couldn't connect to world", (Throwable)\u26032);
                    Realms.setScreen(new DisconnectedRealmsScreen(RealmsConnect.this.onlineScreen, "connect.failed", new TranslationTextComponent("disconnect.genericReason", "Unknown host '" + string + "'")));
                }
                catch (Exception \u26033) {
                    Realms.clearResourcePack();
                    if (RealmsConnect.this.aborted) {
                        return;
                    }
                    LOGGER.error("Couldn't connect to world", (Throwable)\u26033);
                    String string2 = \u26033.toString();
                    if (inetAddress != null) {
                        \u2603 = inetAddress + ":" + n;
                        string2 = string2.replaceAll(\u2603, "");
                    }
                    Realms.setScreen(new DisconnectedRealmsScreen(RealmsConnect.this.onlineScreen, "connect.failed", new TranslationTextComponent("disconnect.genericReason", string2)));
                }
            }
        }.start();
    }

    public void abort() {
        this.aborted = true;
        if (this.connection != null && this.connection.func_150724_d()) {
            this.connection.func_150718_a(new TranslationTextComponent("disconnect.genericReason", new Object[0]));
            this.connection.func_179293_l();
        }
    }

    public void tick() {
        if (this.connection != null) {
            if (this.connection.func_150724_d()) {
                this.connection.func_74428_b();
            } else {
                this.connection.func_179293_l();
            }
        }
    }
}

