/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.realms;

import com.mojang.authlib.GameProfile;
import com.mojang.util.UUIDTypeAdapter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.net.Proxy;
import java.time.Duration;
import java.util.Arrays;
import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.chat.NarratorChatListener;
import net.minecraft.client.gui.screen.MainMenuScreen;
import net.minecraft.client.resources.I18n;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.realms.RealmsScreen;
import net.minecraft.realms.RepeatedNarrator;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Session;
import net.minecraft.util.SharedConstants;
import net.minecraft.util.Util;
import net.minecraft.util.text.ChatType;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.GameType;

public class Realms {
    private static final RepeatedNarrator REPEATED_NARRATOR = new RepeatedNarrator(Duration.ofSeconds(5L));

    public static boolean isTouchScreen() {
        return Minecraft.func_71410_x().field_71474_y.field_85185_A;
    }

    public static Proxy getProxy() {
        return Minecraft.func_71410_x().func_110437_J();
    }

    public static String sessionId() {
        Session session = Minecraft.func_71410_x().func_110432_I();
        if (session == null) {
            return null;
        }
        return session.func_111286_b();
    }

    public static String userName() {
        Session session = Minecraft.func_71410_x().func_110432_I();
        if (session == null) {
            return null;
        }
        return session.func_111285_a();
    }

    public static long currentTimeMillis() {
        return Util.func_211177_b();
    }

    public static String getSessionId() {
        return Minecraft.func_71410_x().func_110432_I().func_111286_b();
    }

    public static String getUUID() {
        return Minecraft.func_71410_x().func_110432_I().func_148255_b();
    }

    public static String getName() {
        return Minecraft.func_71410_x().func_110432_I().func_111285_a();
    }

    public static String uuidToName(String string) {
        return Minecraft.func_71410_x().func_152347_ac().fillProfileProperties(new GameProfile(UUIDTypeAdapter.fromString((String)string), null), false).getName();
    }

    public static <V> CompletableFuture<V> execute(Supplier<V> supplier) {
        return Minecraft.func_71410_x().func_213169_a(supplier);
    }

    public static void execute(Runnable runnable) {
        Minecraft.func_71410_x().execute(runnable);
    }

    public static void setScreen(RealmsScreen realmsScreen) {
        Realms.execute(() -> {
            Realms.setScreenDirect(realmsScreen);
            return null;
        });
    }

    public static void setScreenDirect(RealmsScreen realmsScreen) {
        Minecraft.func_71410_x().func_147108_a(realmsScreen.getProxy());
    }

    public static String getGameDirectoryPath() {
        return Minecraft.func_71410_x().field_71412_D.getAbsolutePath();
    }

    public static int survivalId() {
        return GameType.SURVIVAL.func_77148_a();
    }

    public static int creativeId() {
        return GameType.CREATIVE.func_77148_a();
    }

    public static int adventureId() {
        return GameType.ADVENTURE.func_77148_a();
    }

    public static int spectatorId() {
        return GameType.SPECTATOR.func_77148_a();
    }

    public static void setConnectedToRealms(boolean bl) {
        Minecraft.func_71410_x().func_181537_a(bl);
    }

    public static CompletableFuture<?> downloadResourcePack(String string, String string2) {
        return Minecraft.func_71410_x().func_195541_I().func_217818_a(string, string2);
    }

    public static void clearResourcePack() {
        Minecraft.func_71410_x().func_195541_I().func_195749_c();
    }

    public static boolean getRealmsNotificationsEnabled() {
        return Minecraft.func_71410_x().field_71474_y.field_183509_X;
    }

    public static boolean inTitleScreen() {
        return Minecraft.func_71410_x().field_71462_r != null && Minecraft.func_71410_x().field_71462_r instanceof MainMenuScreen;
    }

    public static void deletePlayerTag(File file) {
        if (file.exists()) {
            try {
                CompoundNBT compoundNBT = CompressedStreamTools.func_74796_a(new FileInputStream(file));
                \u2603 = compoundNBT.func_74775_l("Data");
                \u2603.func_82580_o("Player");
                CompressedStreamTools.func_74799_a(compoundNBT, new FileOutputStream(file));
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    public static void openUri(String string) {
        Util.func_110647_a().func_195640_a(string);
    }

    public static void setClipboard(String string) {
        Minecraft.func_71410_x().field_195559_v.func_197960_a(string);
    }

    public static String getMinecraftVersionString() {
        return SharedConstants.func_215069_a().getName();
    }

    public static ResourceLocation resourceLocation(String string) {
        return new ResourceLocation(string);
    }

    public static String getLocalizedString(String string, Object ... objectArray) {
        return I18n.func_135052_a(string, objectArray);
    }

    public static void bind(String string) {
        ResourceLocation resourceLocation = new ResourceLocation(string);
        Minecraft.func_71410_x().func_110434_K().func_110577_a(resourceLocation);
    }

    public static void narrateNow(String string) {
        NarratorChatListener narratorChatListener = NarratorChatListener.field_193643_a;
        narratorChatListener.func_193642_b();
        narratorChatListener.func_192576_a(ChatType.SYSTEM, new StringTextComponent(Realms.fixNarrationNewlines(string)));
    }

    private static String fixNarrationNewlines(String string) {
        return string.replace("\\n", System.lineSeparator());
    }

    public static void narrateNow(String ... stringArray) {
        Realms.narrateNow(Arrays.asList(stringArray));
    }

    public static void narrateNow(Iterable<String> iterable) {
        Realms.narrateNow(Realms.joinNarrations(iterable));
    }

    public static String joinNarrations(Iterable<String> iterable) {
        return String.join((CharSequence)System.lineSeparator(), iterable);
    }

    public static void narrateRepeatedly(String string) {
        REPEATED_NARRATOR.narrate(Realms.fixNarrationNewlines(string));
    }
}

