/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.profiler;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import net.minecraft.profiler.DataPoint;
import net.minecraft.profiler.IProfileResult;
import net.minecraft.util.SharedConstants;
import net.minecraft.util.Util;
import org.apache.commons.io.IOUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class FilledProfileResult
implements IProfileResult {
    private static final Logger field_219930_a = LogManager.getLogger();
    private final Map<String, Long> field_219931_b;
    private final Map<String, Long> field_223508_c;
    private final long field_219932_c;
    private final int field_219933_d;
    private final long field_219934_e;
    private final int field_219935_f;
    private final int field_223509_h;

    public FilledProfileResult(Map<String, Long> map, Map<String, Long> map2, long l, int n, long l2, int n2) {
        this.field_219931_b = map;
        this.field_223508_c = map2;
        this.field_219932_c = l;
        this.field_219933_d = n;
        this.field_219934_e = l2;
        this.field_219935_f = n2;
        this.field_223509_h = n2 - n;
    }

    @Override
    public List<DataPoint> func_219917_a(String string2) {
        String string = string2;
        long l = this.field_219931_b.containsKey("root") ? this.field_219931_b.get("root") : 0L;
        long \u26034 = this.field_219931_b.getOrDefault(string2, -1L);
        long \u26039 = this.field_223508_c.getOrDefault(string2, 0L);
        ArrayList \u26032 = Lists.newArrayList();
        if (!string2.isEmpty()) {
            string2 = string2 + '\u001e';
        }
        long l2 = 0L;
        for (String string3 : this.field_219931_b.keySet()) {
            if (string3.length() <= string2.length() || !string3.startsWith(string2) || string3.indexOf(30, string2.length() + 1) >= 0) continue;
            l2 += this.field_219931_b.get(string3).longValue();
        }
        float \u26033 = l2;
        if (l2 < \u26034) {
            l2 = \u26034;
        }
        if (l < l2) {
            l = l2;
        }
        HashSet hashSet = Sets.newHashSet(this.field_219931_b.keySet());
        hashSet.addAll(this.field_223508_c.keySet());
        for (String string3 : hashSet) {
            if (string3.length() <= string2.length() || !string3.startsWith(string2) || string3.indexOf(30, string2.length() + 1) >= 0) continue;
            long \u26035 = this.field_219931_b.getOrDefault(string3, 0L);
            double \u26036 = (double)\u26035 * 100.0 / (double)l2;
            double \u26037 = (double)\u26035 * 100.0 / (double)l;
            \u2603 = string3.substring(string2.length());
            long \u26038 = this.field_223508_c.getOrDefault(string3, 0L);
            \u26032.add(new DataPoint(\u2603, \u26036, \u26037, \u26038));
        }
        for (String string4 : this.field_219931_b.keySet()) {
            this.field_219931_b.put(string4, this.field_219931_b.get(string4) * 999L / 1000L);
        }
        if ((float)l2 > \u26033) {
            \u26032.add(new DataPoint("unspecified", (double)((float)l2 - \u26033) * 100.0 / (double)l2, (double)((float)l2 - \u26033) * 100.0 / (double)l, \u26039));
        }
        Collections.sort(\u26032);
        \u26032.add(0, new DataPoint(string, 100.0, (double)l2 * 100.0 / (double)l, \u26039));
        return \u26032;
    }

    @Override
    public long func_219918_a() {
        return this.field_219932_c;
    }

    @Override
    public int func_219922_b() {
        return this.field_219933_d;
    }

    @Override
    public long func_219923_c() {
        return this.field_219934_e;
    }

    @Override
    public int func_219921_d() {
        return this.field_219935_f;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean func_219919_a(File file) {
        boolean bl;
        file.getParentFile().mkdirs();
        OutputStreamWriter outputStreamWriter = null;
        try {
            outputStreamWriter = new OutputStreamWriter((OutputStream)new FileOutputStream(file), StandardCharsets.UTF_8);
            outputStreamWriter.write(this.func_219929_a(this.func_219924_f(), this.func_219925_g()));
            bl = true;
        }
        catch (Throwable \u26032) {
            boolean bl2;
            try {
                field_219930_a.error("Could not save profiler results to {}", (Object)file, (Object)\u26032);
                bl2 = false;
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(outputStreamWriter);
                throw throwable;
            }
            IOUtils.closeQuietly((Writer)outputStreamWriter);
            return bl2;
        }
        IOUtils.closeQuietly((Writer)outputStreamWriter);
        return bl;
    }

    protected String func_219929_a(long l, int n) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("---- Minecraft Profiler Results ----\n");
        stringBuilder.append("// ");
        stringBuilder.append(FilledProfileResult.func_219927_h());
        stringBuilder.append("\n\n");
        stringBuilder.append("Version: ").append(SharedConstants.func_215069_a().getId()).append('\n');
        stringBuilder.append("Time span: ").append(l / 1000000L).append(" ms\n");
        stringBuilder.append("Tick span: ").append(n).append(" ticks\n");
        stringBuilder.append("// This is approximately ").append(String.format(Locale.ROOT, "%.2f", Float.valueOf((float)n / ((float)l / 1.0E9f)))).append(" ticks per second. It should be ").append(20).append(" ticks per second\n\n");
        stringBuilder.append("--- BEGIN PROFILE DUMP ---\n\n");
        this.func_219928_a(0, "root", stringBuilder);
        stringBuilder.append("--- END PROFILE DUMP ---\n\n");
        return stringBuilder.toString();
    }

    @Override
    public String func_219920_e() {
        StringBuilder stringBuilder = new StringBuilder();
        this.func_219928_a(0, "root", stringBuilder);
        return stringBuilder.toString();
    }

    private void func_219928_a(int n, String string, StringBuilder stringBuilder2) {
        List<DataPoint> list = this.func_219917_a(string);
        if (list.size() < 3) {
            return;
        }
        for (int i = 1; i < list.size(); ++i) {
            StringBuilder stringBuilder2;
            DataPoint dataPoint = list.get(i);
            stringBuilder2.append(String.format("[%02d] ", n));
            for (int j = 0; j < n; ++j) {
                stringBuilder2.append("|   ");
            }
            stringBuilder2.append(dataPoint.field_219945_c).append('(').append(dataPoint.field_223511_c).append('/').append(String.format(Locale.ROOT, "%.0f", Float.valueOf((float)dataPoint.field_223511_c / (float)this.field_223509_h))).append(')').append(" - ").append(String.format(Locale.ROOT, "%.2f", dataPoint.field_219943_a)).append("%/").append(String.format(Locale.ROOT, "%.2f", dataPoint.field_219944_b)).append("%\n");
            if ("unspecified".equals(dataPoint.field_219945_c)) continue;
            try {
                this.func_219928_a(n + 1, string + '\u001e' + dataPoint.field_219945_c, stringBuilder2);
                continue;
            }
            catch (Exception \u26032) {
                stringBuilder2.append("[[ EXCEPTION ").append(\u26032).append(" ]]");
            }
        }
    }

    private static String func_219927_h() {
        String[] stringArray = new String[]{"Shiny numbers!", "Am I not running fast enough? :(", "I'm working as hard as I can!", "Will I ever be good enough for you? :(", "Speedy. Zoooooom!", "Hello world", "40% better than a crash report.", "Now with extra numbers", "Now with less numbers", "Now with the same numbers", "You should add flames to things, it makes them go faster!", "Do you feel the need for... optimization?", "*cracks redstone whip*", "Maybe if you treated it better then it'll have more motivation to work faster! Poor server."};
        try {
            return stringArray[(int)(Util.func_211178_c() % (long)stringArray.length)];
        }
        catch (Throwable \u26032) {
            return "Witty comment unavailable :(";
        }
    }

    @Override
    public int func_219925_g() {
        return this.field_223509_h;
    }
}

