/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.item.crafting;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSyntaxException;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.client.resources.JsonReloadListener;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.profiler.IProfiler;
import net.minecraft.resources.IResourceManager;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Util;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.World;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class RecipeManager
extends JsonReloadListener {
    private static final Gson field_223401_a = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
    private static final Logger field_199521_c = LogManager.getLogger();
    private Map<IRecipeType<?>, Map<ResourceLocation, IRecipe<?>>> field_199522_d = ImmutableMap.of();
    private boolean field_199523_e;

    public RecipeManager() {
        super(field_223401_a, "recipes");
    }

    @Override
    protected void func_212853_a_(Map<ResourceLocation, JsonObject> map, IResourceManager iResourceManager, IProfiler iProfiler) {
        this.field_199523_e = false;
        HashMap hashMap = Maps.newHashMap();
        for (Map.Entry<ResourceLocation, JsonObject> entry2 : map.entrySet()) {
            ResourceLocation resourceLocation = entry2.getKey();
            try {
                IRecipe<?> iRecipe = RecipeManager.func_215377_a(resourceLocation, entry2.getValue());
                hashMap.computeIfAbsent(iRecipe.func_222127_g(), iRecipeType -> ImmutableMap.builder()).put((Object)resourceLocation, iRecipe);
            }
            catch (JsonParseException | IllegalArgumentException throwable) {
                field_199521_c.error("Parsing error loading recipe {}", (Object)resourceLocation, (Object)throwable);
            }
        }
        this.field_199522_d = (Map)hashMap.entrySet().stream().collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, entry -> ((ImmutableMap.Builder)entry.getValue()).build()));
        field_199521_c.info("Loaded {} recipes", (Object)hashMap.size());
    }

    public <C extends IInventory, T extends IRecipe<C>> Optional<T> func_215371_a(IRecipeType<T> iRecipeType, C c, World world) {
        return this.func_215366_a(iRecipeType).values().stream().flatMap(iRecipe -> Util.func_215081_a(iRecipeType.func_222148_a(iRecipe, world, c))).findFirst();
    }

    public <C extends IInventory, T extends IRecipe<C>> List<T> func_215370_b(IRecipeType<T> iRecipeType, C c, World world) {
        return this.func_215366_a(iRecipeType).values().stream().flatMap(iRecipe -> Util.func_215081_a(iRecipeType.func_222148_a(iRecipe, world, c))).sorted(Comparator.comparing(iRecipe -> iRecipe.func_77571_b().func_77977_a())).collect(Collectors.toList());
    }

    private <C extends IInventory, T extends IRecipe<C>> Map<ResourceLocation, IRecipe<C>> func_215366_a(IRecipeType<T> iRecipeType) {
        return this.field_199522_d.getOrDefault(iRecipeType, Collections.emptyMap());
    }

    public <C extends IInventory, T extends IRecipe<C>> NonNullList<ItemStack> func_215369_c(IRecipeType<T> iRecipeType, C c, World world) {
        Optional<T> optional = this.func_215371_a(iRecipeType, c, world);
        if (optional.isPresent()) {
            return ((IRecipe)optional.get()).func_179532_b(c);
        }
        NonNullList<ItemStack> \u26032 = NonNullList.func_191197_a(c.func_70302_i_(), ItemStack.field_190927_a);
        for (int i = 0; i < \u26032.size(); ++i) {
            \u26032.set(i, c.func_70301_a(i));
        }
        return \u26032;
    }

    public Optional<? extends IRecipe<?>> func_215367_a(ResourceLocation resourceLocation) {
        return this.field_199522_d.values().stream().map(map -> (IRecipe)map.get(resourceLocation)).filter(Objects::nonNull).findFirst();
    }

    public Collection<IRecipe<?>> func_199510_b() {
        return this.field_199522_d.values().stream().flatMap(map -> map.values().stream()).collect(Collectors.toSet());
    }

    public Stream<ResourceLocation> func_215378_c() {
        return this.field_199522_d.values().stream().flatMap(map -> map.keySet().stream());
    }

    public static IRecipe<?> func_215377_a(ResourceLocation resourceLocation, JsonObject jsonObject) {
        String string = JSONUtils.func_151200_h(jsonObject, "type");
        return Registry.field_218368_I.func_218349_b(new ResourceLocation(string)).orElseThrow(() -> new JsonSyntaxException("Invalid or unsupported recipe type '" + string + "'")).func_199425_a_(resourceLocation, jsonObject);
    }

    public void func_223389_a(Iterable<IRecipe<?>> iterable) {
        this.field_199523_e = false;
        HashMap hashMap = Maps.newHashMap();
        iterable.forEach(iRecipe -> {
            Map map2 = hashMap.computeIfAbsent(iRecipe.func_222127_g(), iRecipeType -> Maps.newHashMap());
            IRecipe \u26032 = map2.put(iRecipe.func_199560_c(), iRecipe);
            if (\u26032 != null) {
                throw new IllegalStateException("Duplicate recipe ignored with ID " + iRecipe.func_199560_c());
            }
        });
        this.field_199522_d = ImmutableMap.copyOf((Map)hashMap);
    }
}

