/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.item;

import com.google.common.collect.Multimap;
import net.minecraft.block.BlockState;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.projectile.AbstractArrowEntity;
import net.minecraft.entity.projectile.TridentEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.UseAction;
import net.minecraft.stats.Stats;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;

public class TridentItem
extends Item {
    public TridentItem(Item.Properties properties) {
        super(properties);
        this.func_185043_a(new ResourceLocation("throwing"), (itemStack, world, livingEntity) -> livingEntity != null && livingEntity.func_184587_cr() && livingEntity.func_184607_cu() == itemStack ? 1.0f : 0.0f);
    }

    @Override
    public boolean func_195938_a(BlockState blockState, World world, BlockPos blockPos, PlayerEntity playerEntity) {
        return !playerEntity.func_184812_l_();
    }

    @Override
    public UseAction func_77661_b(ItemStack itemStack) {
        return UseAction.SPEAR;
    }

    @Override
    public int func_77626_a(ItemStack itemStack) {
        return 72000;
    }

    @Override
    public boolean func_77636_d(ItemStack itemStack) {
        return false;
    }

    @Override
    public void func_77615_a(ItemStack itemStack, World world, LivingEntity livingEntity, int n) {
        if (!(livingEntity instanceof PlayerEntity)) {
            return;
        }
        PlayerEntity playerEntity2 = (PlayerEntity)livingEntity;
        int \u26032 = this.func_77626_a(itemStack) - n;
        if (\u26032 < 10) {
            return;
        }
        int \u26033 = EnchantmentHelper.func_203190_g(itemStack);
        if (\u26033 > 0 && !playerEntity2.func_70026_G()) {
            return;
        }
        if (!world.field_72995_K) {
            itemStack.func_222118_a(1, playerEntity2, playerEntity -> playerEntity.func_213334_d(livingEntity.func_184600_cs()));
            if (\u26033 == 0) {
                TridentEntity tridentEntity = new TridentEntity(world, (LivingEntity)playerEntity2, itemStack);
                tridentEntity.func_184547_a(playerEntity2, playerEntity2.field_70125_A, playerEntity2.field_70177_z, 0.0f, 2.5f + (float)\u26033 * 0.5f, 1.0f);
                if (playerEntity2.field_71075_bZ.field_75098_d) {
                    tridentEntity.field_70251_a = AbstractArrowEntity.PickupStatus.CREATIVE_ONLY;
                }
                world.func_217376_c(tridentEntity);
                world.func_217384_a(null, tridentEntity, SoundEvents.field_203274_ip, SoundCategory.PLAYERS, 1.0f, 1.0f);
                if (!playerEntity2.field_71075_bZ.field_75098_d) {
                    playerEntity2.field_71071_by.func_184437_d(itemStack);
                }
            }
        }
        playerEntity2.func_71029_a(Stats.field_75929_E.func_199076_b(this));
        if (\u26033 > 0) {
            float f = playerEntity2.field_70177_z;
            \u2603 = playerEntity2.field_70125_A;
            \u2603 = -MathHelper.func_76126_a(f * ((float)Math.PI / 180)) * MathHelper.func_76134_b(\u2603 * ((float)Math.PI / 180));
            \u2603 = -MathHelper.func_76126_a(\u2603 * ((float)Math.PI / 180));
            \u2603 = MathHelper.func_76134_b(f * ((float)Math.PI / 180)) * MathHelper.func_76134_b(\u2603 * ((float)Math.PI / 180));
            \u2603 = MathHelper.func_76129_c(\u2603 * \u2603 + \u2603 * \u2603 + \u2603 * \u2603);
            \u2603 = 3.0f * ((1.0f + (float)\u26033) / 4.0f);
            playerEntity2.func_70024_g(\u2603 *= \u2603 / \u2603, \u2603 *= \u2603 / \u2603, \u2603 *= \u2603 / \u2603);
            playerEntity2.func_204803_n(20);
            if (playerEntity2.field_70122_E) {
                \u2603 = 1.1999999f;
                playerEntity2.func_213315_a(MoverType.SELF, new Vec3d(0.0, 1.1999999284744263, 0.0));
            }
            SoundEvent \u26034 = \u26033 >= 3 ? SoundEvents.field_203273_io : (\u26033 == 2 ? SoundEvents.field_203272_in : SoundEvents.field_203271_im);
            world.func_217384_a(null, playerEntity2, \u26034, SoundCategory.PLAYERS, 1.0f, 1.0f);
        }
    }

    @Override
    public ActionResult<ItemStack> func_77659_a(World world, PlayerEntity playerEntity, Hand hand) {
        ItemStack itemStack = playerEntity.func_184586_b(hand);
        if (itemStack.func_77952_i() >= itemStack.func_77958_k()) {
            return new ActionResult<ItemStack>(ActionResultType.FAIL, itemStack);
        }
        if (EnchantmentHelper.func_203190_g(itemStack) > 0 && !playerEntity.func_70026_G()) {
            return new ActionResult<ItemStack>(ActionResultType.FAIL, itemStack);
        }
        playerEntity.func_184598_c(hand);
        return new ActionResult<ItemStack>(ActionResultType.SUCCESS, itemStack);
    }

    @Override
    public boolean func_77644_a(ItemStack itemStack, LivingEntity livingEntity2, LivingEntity livingEntity3) {
        itemStack.func_222118_a(1, livingEntity3, livingEntity -> livingEntity.func_213361_c(EquipmentSlotType.MAINHAND));
        return true;
    }

    @Override
    public boolean func_179218_a(ItemStack itemStack, World world, BlockState blockState, BlockPos blockPos, LivingEntity livingEntity2) {
        if ((double)blockState.func_185887_b(world, blockPos) != 0.0) {
            itemStack.func_222118_a(2, livingEntity2, livingEntity -> livingEntity.func_213361_c(EquipmentSlotType.MAINHAND));
        }
        return true;
    }

    @Override
    public Multimap<String, AttributeModifier> func_111205_h(EquipmentSlotType equipmentSlotType) {
        Multimap<String, AttributeModifier> multimap = super.func_111205_h(equipmentSlotType);
        if (equipmentSlotType == EquipmentSlotType.MAINHAND) {
            multimap.put((Object)SharedMonsterAttributes.field_111264_e.func_111108_a(), (Object)new AttributeModifier(field_111210_e, "Tool modifier", 8.0, AttributeModifier.Operation.ADDITION));
            multimap.put((Object)SharedMonsterAttributes.field_188790_f.func_111108_a(), (Object)new AttributeModifier(field_185050_h, "Tool modifier", (double)-2.9f, AttributeModifier.Operation.ADDITION));
        }
        return multimap;
    }

    @Override
    public int func_77619_b() {
        return 1;
    }
}

