/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.item;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.client.renderer.Quaternion;
import net.minecraft.client.renderer.Vector3f;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.enchantment.Enchantments;
import net.minecraft.entity.Entity;
import net.minecraft.entity.ICrossbowUser;
import net.minecraft.entity.IProjectile;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.item.FireworkRocketEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.entity.projectile.AbstractArrowEntity;
import net.minecraft.item.ArrowItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.ShootableItem;
import net.minecraft.item.UseAction;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.stats.Stats;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;

public class CrossbowItem
extends ShootableItem {
    private boolean field_220034_c = false;
    private boolean field_220035_d = false;

    public CrossbowItem(Item.Properties properties) {
        super(properties);
        this.func_185043_a(new ResourceLocation("pull"), (itemStack, world, livingEntity) -> {
            if (livingEntity == null || itemStack.func_77973_b() != this) {
                return 0.0f;
            }
            if (CrossbowItem.func_220012_d(itemStack)) {
                return 0.0f;
            }
            return (float)(itemStack.func_77988_m() - livingEntity.func_184605_cv()) / (float)CrossbowItem.func_220026_e(itemStack);
        });
        this.func_185043_a(new ResourceLocation("pulling"), (itemStack, world, livingEntity) -> livingEntity != null && livingEntity.func_184587_cr() && livingEntity.func_184607_cu() == itemStack && !CrossbowItem.func_220012_d(itemStack) ? 1.0f : 0.0f);
        this.func_185043_a(new ResourceLocation("charged"), (itemStack, world, livingEntity) -> livingEntity != null && CrossbowItem.func_220012_d(itemStack) ? 1.0f : 0.0f);
        this.func_185043_a(new ResourceLocation("firework"), (itemStack, world, livingEntity) -> livingEntity != null && CrossbowItem.func_220012_d(itemStack) && CrossbowItem.func_220019_a(itemStack, Items.field_196152_dE) ? 1.0f : 0.0f);
    }

    @Override
    public Predicate<ItemStack> func_220006_d() {
        return field_220008_b;
    }

    @Override
    public Predicate<ItemStack> func_220004_b() {
        return field_220007_a;
    }

    @Override
    public ActionResult<ItemStack> func_77659_a(World world, PlayerEntity playerEntity, Hand hand) {
        ItemStack itemStack = playerEntity.func_184586_b(hand);
        if (CrossbowItem.func_220012_d(itemStack)) {
            CrossbowItem.func_220014_a(world, playerEntity, hand, itemStack, CrossbowItem.func_220013_l(itemStack), 1.0f);
            CrossbowItem.func_220011_a(itemStack, false);
            return new ActionResult<ItemStack>(ActionResultType.SUCCESS, itemStack);
        }
        if (!playerEntity.func_213356_f(itemStack).func_190926_b()) {
            if (!CrossbowItem.func_220012_d(itemStack)) {
                this.field_220034_c = false;
                this.field_220035_d = false;
                playerEntity.func_184598_c(hand);
            }
            return new ActionResult<ItemStack>(ActionResultType.SUCCESS, itemStack);
        }
        return new ActionResult<ItemStack>(ActionResultType.FAIL, itemStack);
    }

    @Override
    public void func_77615_a(ItemStack itemStack, World world, LivingEntity livingEntity, int n) {
        \u2603 = this.func_77626_a(itemStack) - n;
        float f = CrossbowItem.func_220031_a(\u2603, itemStack);
        if (f >= 1.0f && !CrossbowItem.func_220012_d(itemStack) && CrossbowItem.func_220021_a(livingEntity, itemStack)) {
            CrossbowItem.func_220011_a(itemStack, true);
            SoundCategory soundCategory = livingEntity instanceof PlayerEntity ? SoundCategory.PLAYERS : SoundCategory.HOSTILE;
            world.func_184148_a(null, livingEntity.field_70165_t, livingEntity.field_70163_u, livingEntity.field_70161_v, SoundEvents.field_219610_bB, soundCategory, 1.0f, 1.0f / (field_77697_d.nextFloat() * 0.5f + 1.0f) + 0.2f);
        }
    }

    private static boolean func_220021_a(LivingEntity livingEntity, ItemStack itemStack) {
        int n = EnchantmentHelper.func_77506_a(Enchantments.field_222192_G, itemStack);
        \u2603 = n == 0 ? 1 : 3;
        boolean \u26032 = livingEntity instanceof PlayerEntity && ((PlayerEntity)livingEntity).field_71075_bZ.field_75098_d;
        ItemStack \u26033 = livingEntity.func_213356_f(itemStack);
        ItemStack \u26034 = \u26033.func_77946_l();
        for (\u2603 = 0; \u2603 < \u2603; ++\u2603) {
            if (\u2603 > 0) {
                \u26033 = \u26034.func_77946_l();
            }
            if (\u26033.func_190926_b() && \u26032) {
                \u26033 = new ItemStack(Items.field_151032_g);
                \u26034 = \u26033.func_77946_l();
            }
            if (CrossbowItem.func_220023_a(livingEntity, itemStack, \u26033, \u2603 > 0, \u26032)) continue;
            return false;
        }
        return true;
    }

    private static boolean func_220023_a(LivingEntity livingEntity, ItemStack itemStack3, ItemStack itemStack22, boolean bl, boolean bl2) {
        ItemStack itemStack3;
        if (itemStack22.func_190926_b()) {
            return false;
        }
        boolean bl3 = \u2603 = bl2 && itemStack22.func_77973_b() instanceof ArrowItem;
        if (!(\u2603 || bl2 || bl)) {
            ItemStack itemStack4 = itemStack22.func_77979_a(1);
            if (itemStack22.func_190926_b() && livingEntity instanceof PlayerEntity) {
                ((PlayerEntity)livingEntity).field_71071_by.func_184437_d(itemStack22);
            }
        } else {
            ItemStack itemStack22;
            itemStack4 = itemStack22.func_77946_l();
        }
        CrossbowItem.func_220029_b(itemStack3, itemStack4);
        return true;
    }

    public static boolean func_220012_d(ItemStack itemStack) {
        CompoundNBT compoundNBT = itemStack.func_77978_p();
        return compoundNBT != null && compoundNBT.func_74767_n("Charged");
    }

    public static void func_220011_a(ItemStack itemStack, boolean bl) {
        CompoundNBT compoundNBT = itemStack.func_196082_o();
        compoundNBT.func_74757_a("Charged", bl);
    }

    private static void func_220029_b(ItemStack itemStack, ItemStack itemStack2) {
        CompoundNBT compoundNBT = itemStack.func_196082_o();
        ListNBT \u26032 = compoundNBT.func_150297_b("ChargedProjectiles", 9) ? compoundNBT.func_150295_c("ChargedProjectiles", 10) : new ListNBT();
        \u2603 = new CompoundNBT();
        itemStack2.func_77955_b(\u2603);
        \u26032.add(\u2603);
        compoundNBT.func_218657_a("ChargedProjectiles", \u26032);
    }

    private static List<ItemStack> func_220018_j(ItemStack itemStack) {
        ArrayList arrayList = Lists.newArrayList();
        CompoundNBT \u26032 = itemStack.func_77978_p();
        if (\u26032 != null && \u26032.func_150297_b("ChargedProjectiles", 9) && (\u2603 = \u26032.func_150295_c("ChargedProjectiles", 10)) != null) {
            for (int i = 0; i < \u2603.size(); ++i) {
                CompoundNBT compoundNBT = \u2603.func_150305_b(i);
                arrayList.add(ItemStack.func_199557_a(compoundNBT));
            }
        }
        return arrayList;
    }

    private static void func_220027_k(ItemStack itemStack) {
        CompoundNBT compoundNBT = itemStack.func_77978_p();
        if (compoundNBT != null) {
            ListNBT listNBT = compoundNBT.func_150295_c("ChargedProjectiles", 9);
            listNBT.clear();
            compoundNBT.func_218657_a("ChargedProjectiles", listNBT);
        }
    }

    private static boolean func_220019_a(ItemStack itemStack2, Item item) {
        return CrossbowItem.func_220018_j(itemStack2).stream().anyMatch(itemStack -> itemStack.func_77973_b() == item);
    }

    private static void func_220016_a(World world2, LivingEntity livingEntity2, Hand hand, ItemStack itemStack, ItemStack itemStack2, float f, boolean bl, float f2, float f3, float f4) {
        Entity \u26032;
        if (world2.field_72995_K) {
            return;
        }
        boolean bl2 = \u2603 = itemStack2.func_77973_b() == Items.field_196152_dE;
        if (\u2603) {
            \u26032 = new FireworkRocketEntity(world2, itemStack2, livingEntity2.field_70165_t, livingEntity2.field_70163_u + (double)livingEntity2.func_70047_e() - (double)0.15f, livingEntity2.field_70161_v, true);
        } else {
            World world2;
            \u26032 = CrossbowItem.func_220024_a(world2, livingEntity2, itemStack, itemStack2);
            if (bl || f4 != 0.0f) {
                ((AbstractArrowEntity)\u26032).field_70251_a = AbstractArrowEntity.PickupStatus.CREATIVE_ONLY;
            }
        }
        if (livingEntity2 instanceof ICrossbowUser) {
            ICrossbowUser \u26033 = (ICrossbowUser)((Object)livingEntity2);
            \u26033.func_213670_a(\u26033.func_70638_az(), itemStack, (IProjectile)((Object)\u26032), f4);
        } else {
            Vec3d \u26034 = livingEntity2.func_213286_i(1.0f);
            Quaternion \u26035 = new Quaternion(new Vector3f(\u26034), f4, true);
            Vec3d \u26036 = livingEntity2.func_70676_i(1.0f);
            Vector3f \u26037 = new Vector3f(\u26036);
            \u26037.func_214905_a(\u26035);
            \u26032.func_70186_c(\u26037.func_195899_a(), \u26037.func_195900_b(), \u26037.func_195902_c(), f2, f3);
        }
        itemStack.func_222118_a(\u2603 ? 3 : 1, livingEntity2, livingEntity -> livingEntity.func_213334_d(hand));
        world2.func_217376_c(\u26032);
        world2.func_184148_a(null, livingEntity2.field_70165_t, livingEntity2.field_70163_u, livingEntity2.field_70161_v, SoundEvents.field_219616_bH, SoundCategory.PLAYERS, 1.0f, f);
    }

    private static AbstractArrowEntity func_220024_a(World world, LivingEntity livingEntity, ItemStack itemStack, ItemStack itemStack2) {
        ArrowItem arrowItem = (ArrowItem)(itemStack2.func_77973_b() instanceof ArrowItem ? itemStack2.func_77973_b() : Items.field_151032_g);
        AbstractArrowEntity \u26032 = arrowItem.func_200887_a(world, itemStack2, livingEntity);
        if (livingEntity instanceof PlayerEntity) {
            \u26032.func_70243_d(true);
        }
        \u26032.func_213869_a(SoundEvents.field_219609_bA);
        \u26032.func_213865_o(true);
        int \u26033 = EnchantmentHelper.func_77506_a(Enchantments.field_222194_I, itemStack);
        if (\u26033 > 0) {
            \u26032.func_213872_b((byte)\u26033);
        }
        return \u26032;
    }

    public static void func_220014_a(World world2, LivingEntity livingEntity, Hand hand, ItemStack itemStack, float f, float f2) {
        World world2;
        List<ItemStack> list = CrossbowItem.func_220018_j(itemStack);
        float[] \u26032 = CrossbowItem.func_220028_a(livingEntity.func_70681_au());
        for (int i = 0; i < list.size(); ++i) {
            ItemStack itemStack2 = list.get(i);
            boolean bl = \u2603 = livingEntity instanceof PlayerEntity && ((PlayerEntity)livingEntity).field_71075_bZ.field_75098_d;
            if (itemStack2.func_190926_b()) continue;
            if (i == 0) {
                CrossbowItem.func_220016_a(world2, livingEntity, hand, itemStack, itemStack2, \u26032[i], \u2603, f, f2, 0.0f);
                continue;
            }
            if (i == 1) {
                CrossbowItem.func_220016_a(world2, livingEntity, hand, itemStack, itemStack2, \u26032[i], \u2603, f, f2, -10.0f);
                continue;
            }
            if (i != 2) continue;
            CrossbowItem.func_220016_a(world2, livingEntity, hand, itemStack, itemStack2, \u26032[i], \u2603, f, f2, 10.0f);
        }
        CrossbowItem.func_220015_a(world2, livingEntity, itemStack);
    }

    private static float[] func_220028_a(Random random) {
        boolean bl = random.nextBoolean();
        return new float[]{1.0f, CrossbowItem.func_220032_a(bl), CrossbowItem.func_220032_a(!bl)};
    }

    private static float func_220032_a(boolean bl) {
        float f = bl ? 0.63f : 0.43f;
        return 1.0f / (field_77697_d.nextFloat() * 0.5f + 1.8f) + f;
    }

    private static void func_220015_a(World world, LivingEntity livingEntity, ItemStack itemStack2) {
        ItemStack itemStack2;
        if (livingEntity instanceof ServerPlayerEntity) {
            ServerPlayerEntity serverPlayerEntity = (ServerPlayerEntity)livingEntity;
            if (!world.field_72995_K) {
                CriteriaTriggers.field_215099_F.func_215111_a(serverPlayerEntity, itemStack2);
            }
            serverPlayerEntity.func_71029_a(Stats.field_75929_E.func_199076_b(itemStack2.func_77973_b()));
        }
        CrossbowItem.func_220027_k(itemStack2);
    }

    @Override
    public void func_219972_a(World world, LivingEntity livingEntity, ItemStack itemStack, int n) {
        if (!world.field_72995_K) {
            \u2603 = EnchantmentHelper.func_77506_a(Enchantments.field_222193_H, itemStack);
            SoundEvent soundEvent = this.func_220025_a(\u2603);
            \u2603 = \u2603 == 0 ? SoundEvents.field_219611_bC : null;
            float \u26032 = (float)(itemStack.func_77988_m() - n) / (float)CrossbowItem.func_220026_e(itemStack);
            if (\u26032 < 0.2f) {
                this.field_220034_c = false;
                this.field_220035_d = false;
            }
            if (\u26032 >= 0.2f && !this.field_220034_c) {
                this.field_220034_c = true;
                world.func_184148_a(null, livingEntity.field_70165_t, livingEntity.field_70163_u, livingEntity.field_70161_v, soundEvent, SoundCategory.PLAYERS, 0.5f, 1.0f);
            }
            if (\u26032 >= 0.5f && \u2603 != null && !this.field_220035_d) {
                this.field_220035_d = true;
                world.func_184148_a(null, livingEntity.field_70165_t, livingEntity.field_70163_u, livingEntity.field_70161_v, \u2603, SoundCategory.PLAYERS, 0.5f, 1.0f);
            }
        }
    }

    @Override
    public int func_77626_a(ItemStack itemStack) {
        return CrossbowItem.func_220026_e(itemStack) + 3;
    }

    public static int func_220026_e(ItemStack itemStack) {
        int n = EnchantmentHelper.func_77506_a(Enchantments.field_222193_H, itemStack);
        return n == 0 ? 25 : 25 - 5 * n;
    }

    @Override
    public UseAction func_77661_b(ItemStack itemStack) {
        return UseAction.CROSSBOW;
    }

    private SoundEvent func_220025_a(int n) {
        switch (n) {
            case 1: {
                return SoundEvents.field_219613_bE;
            }
            case 2: {
                return SoundEvents.field_219614_bF;
            }
            case 3: {
                return SoundEvents.field_219615_bG;
            }
        }
        return SoundEvents.field_219612_bD;
    }

    private static float func_220031_a(int n, ItemStack itemStack) {
        float f = (float)n / (float)CrossbowItem.func_220026_e(itemStack);
        if (f > 1.0f) {
            f = 1.0f;
        }
        return f;
    }

    @Override
    public void func_77624_a(ItemStack itemStack, @Nullable World world, List<ITextComponent> list3, ITooltipFlag iTooltipFlag) {
        List<ItemStack> list2 = CrossbowItem.func_220018_j(itemStack);
        if (!CrossbowItem.func_220012_d(itemStack) || list2.isEmpty()) {
            return;
        }
        ItemStack \u26032 = list2.get(0);
        list3.add(new TranslationTextComponent("item.minecraft.crossbow.projectile", new Object[0]).func_150258_a(" ").func_150257_a(\u26032.func_151000_E()));
        if (iTooltipFlag.func_194127_a() && \u26032.func_77973_b() == Items.field_196152_dE) {
            ArrayList arrayList = Lists.newArrayList();
            Items.field_196152_dE.func_77624_a(\u26032, world, arrayList, iTooltipFlag);
            if (!arrayList.isEmpty()) {
                List<ITextComponent> list3;
                for (int i = 0; i < arrayList.size(); ++i) {
                    arrayList.set(i, new StringTextComponent("  ").func_150257_a((ITextComponent)arrayList.get(i)).func_211708_a(TextFormatting.GRAY));
                }
                list3.addAll(arrayList);
            }
        }
    }

    private static float func_220013_l(ItemStack itemStack) {
        if (itemStack.func_77973_b() == Items.field_222114_py && CrossbowItem.func_220019_a(itemStack, Items.field_196152_dE)) {
            return 1.6f;
        }
        return 3.15f;
    }
}

