/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.entity.passive.horse;

import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.CarpetBlock;
import net.minecraft.block.SoundType;
import net.minecraft.entity.AgeableEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ILivingEntityData;
import net.minecraft.entity.IRangedAttackMob;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.goal.BreedGoal;
import net.minecraft.entity.ai.goal.FollowParentGoal;
import net.minecraft.entity.ai.goal.LlamaFollowCaravanGoal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.entity.ai.goal.PanicGoal;
import net.minecraft.entity.ai.goal.RangedAttackGoal;
import net.minecraft.entity.ai.goal.RunAroundLikeCrazyGoal;
import net.minecraft.entity.ai.goal.SwimGoal;
import net.minecraft.entity.ai.goal.WaterAvoidingRandomWalkingGoal;
import net.minecraft.entity.passive.AnimalEntity;
import net.minecraft.entity.passive.WolfEntity;
import net.minecraft.entity.passive.horse.AbstractChestedHorseEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.projectile.LlamaSpitEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.DyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;

public class LlamaEntity
extends AbstractChestedHorseEntity
implements IRangedAttackMob {
    private static final DataParameter<Integer> field_190720_bG = EntityDataManager.func_187226_a(LlamaEntity.class, DataSerializers.field_187192_b);
    private static final DataParameter<Integer> field_190721_bH = EntityDataManager.func_187226_a(LlamaEntity.class, DataSerializers.field_187192_b);
    private static final DataParameter<Integer> field_190722_bI = EntityDataManager.func_187226_a(LlamaEntity.class, DataSerializers.field_187192_b);
    private boolean field_190723_bJ;
    @Nullable
    private LlamaEntity field_190724_bK;
    @Nullable
    private LlamaEntity field_190725_bL;

    public LlamaEntity(EntityType<? extends LlamaEntity> entityType, World world) {
        super((EntityType<? extends AbstractChestedHorseEntity>)entityType, world);
    }

    public boolean func_213800_eB() {
        return false;
    }

    private void func_190706_p(int n) {
        this.field_70180_af.func_187227_b(field_190720_bG, Math.max(1, Math.min(5, n)));
    }

    private void func_190705_dT() {
        int n = this.field_70146_Z.nextFloat() < 0.04f ? 5 : 3;
        this.func_190706_p(1 + this.field_70146_Z.nextInt(n));
    }

    public int func_190707_dL() {
        return this.field_70180_af.func_187225_a(field_190720_bG);
    }

    @Override
    public void func_213281_b(CompoundNBT compoundNBT) {
        super.func_213281_b(compoundNBT);
        compoundNBT.func_74768_a("Variant", this.func_190719_dM());
        compoundNBT.func_74768_a("Strength", this.func_190707_dL());
        if (!this.field_110296_bG.func_70301_a(1).func_190926_b()) {
            compoundNBT.func_218657_a("DecorItem", this.field_110296_bG.func_70301_a(1).func_77955_b(new CompoundNBT()));
        }
    }

    @Override
    public void func_70037_a(CompoundNBT compoundNBT) {
        this.func_190706_p(compoundNBT.func_74762_e("Strength"));
        super.func_70037_a(compoundNBT);
        this.func_190710_o(compoundNBT.func_74762_e("Variant"));
        if (compoundNBT.func_150297_b("DecorItem", 10)) {
            this.field_110296_bG.func_70299_a(1, ItemStack.func_199557_a(compoundNBT.func_74775_l("DecorItem")));
        }
        this.func_110232_cE();
    }

    @Override
    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(0, new SwimGoal(this));
        this.field_70714_bg.func_75776_a(1, new RunAroundLikeCrazyGoal(this, 1.2));
        this.field_70714_bg.func_75776_a(2, new LlamaFollowCaravanGoal(this, 2.1f));
        this.field_70714_bg.func_75776_a(3, new RangedAttackGoal(this, 1.25, 40, 20.0f));
        this.field_70714_bg.func_75776_a(3, new PanicGoal(this, 1.2));
        this.field_70714_bg.func_75776_a(4, new BreedGoal(this, 1.0));
        this.field_70714_bg.func_75776_a(5, new FollowParentGoal(this, 1.0));
        this.field_70714_bg.func_75776_a(6, new WaterAvoidingRandomWalkingGoal(this, 0.7));
        this.field_70714_bg.func_75776_a(7, new LookAtGoal(this, PlayerEntity.class, 6.0f));
        this.field_70714_bg.func_75776_a(8, new LookRandomlyGoal(this));
        this.field_70715_bh.func_75776_a(1, new HurtByTargetGoal(this));
        this.field_70715_bh.func_75776_a(2, new DefendTargetGoal(this));
    }

    @Override
    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(40.0);
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(field_190720_bG, 0);
        this.field_70180_af.func_187214_a(field_190721_bH, -1);
        this.field_70180_af.func_187214_a(field_190722_bI, 0);
    }

    public int func_190719_dM() {
        return MathHelper.func_76125_a(this.field_70180_af.func_187225_a(field_190722_bI), 0, 3);
    }

    public void func_190710_o(int n) {
        this.field_70180_af.func_187227_b(field_190722_bI, n);
    }

    @Override
    protected int func_190686_di() {
        if (this.func_190695_dh()) {
            return 2 + 3 * this.func_190696_dl();
        }
        return super.func_190686_di();
    }

    @Override
    public void func_184232_k(Entity entity) {
        if (!this.func_184196_w(entity)) {
            return;
        }
        float f = MathHelper.func_76134_b(this.field_70761_aq * ((float)Math.PI / 180));
        \u2603 = MathHelper.func_76126_a(this.field_70761_aq * ((float)Math.PI / 180));
        \u2603 = 0.3f;
        entity.func_70107_b(this.field_70165_t + (double)(0.3f * \u2603), this.field_70163_u + this.func_70042_X() + entity.func_70033_W(), this.field_70161_v - (double)(0.3f * f));
    }

    @Override
    public double func_70042_X() {
        return (double)this.func_213302_cg() * 0.67;
    }

    @Override
    public boolean func_82171_bF() {
        return false;
    }

    @Override
    protected boolean func_190678_b(PlayerEntity playerEntity, ItemStack itemStack) {
        int n = 0;
        \u2603 = 0;
        float \u26032 = 0.0f;
        boolean \u26033 = false;
        Item \u26034 = itemStack.func_77973_b();
        if (\u26034 == Items.field_151015_O) {
            n = 10;
            \u2603 = 3;
            \u26032 = 2.0f;
        } else if (\u26034 == Blocks.field_150407_cf.func_199767_j()) {
            n = 90;
            \u2603 = 6;
            \u26032 = 10.0f;
            if (this.func_110248_bS() && this.func_70874_b() == 0 && this.func_204701_dC()) {
                \u26033 = true;
                this.func_146082_f(playerEntity);
            }
        }
        if (this.func_110143_aJ() < this.func_110138_aP() && \u26032 > 0.0f) {
            this.func_70691_i(\u26032);
            \u26033 = true;
        }
        if (this.func_70631_g_() && n > 0) {
            this.field_70170_p.func_195594_a(ParticleTypes.field_197632_y, this.field_70165_t + (double)(this.field_70146_Z.nextFloat() * this.func_213311_cf() * 2.0f) - (double)this.func_213311_cf(), this.field_70163_u + 0.5 + (double)(this.field_70146_Z.nextFloat() * this.func_213302_cg()), this.field_70161_v + (double)(this.field_70146_Z.nextFloat() * this.func_213311_cf() * 2.0f) - (double)this.func_213311_cf(), 0.0, 0.0, 0.0);
            if (!this.field_70170_p.field_72995_K) {
                this.func_110195_a(n);
            }
            \u26033 = true;
        }
        if (\u2603 > 0 && (\u26033 || !this.func_110248_bS()) && this.func_110252_cg() < this.func_190676_dC()) {
            \u26033 = true;
            if (!this.field_70170_p.field_72995_K) {
                this.func_110198_t(\u2603);
            }
        }
        if (\u26033 && !this.func_174814_R()) {
            this.field_70170_p.func_184148_a(null, this.field_70165_t, this.field_70163_u, this.field_70161_v, SoundEvents.field_191253_dD, this.func_184176_by(), 1.0f, 1.0f + (this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.2f);
        }
        return \u26033;
    }

    @Override
    protected boolean func_70610_aX() {
        return this.func_110143_aJ() <= 0.0f || this.func_110204_cc();
    }

    @Override
    @Nullable
    public ILivingEntityData func_213386_a(IWorld iWorld, DifficultyInstance difficultyInstance, SpawnReason spawnReason, @Nullable ILivingEntityData \u260322, @Nullable CompoundNBT compoundNBT) {
        int n;
        ILivingEntityData \u260322 = super.func_213386_a(iWorld, difficultyInstance, spawnReason, \u260322, compoundNBT);
        this.func_190705_dT();
        if (\u260322 instanceof LlamaData) {
            n = ((LlamaData)\u260322).field_190886_a;
        } else {
            n = this.field_70146_Z.nextInt(4);
            \u260322 = new LlamaData(n);
        }
        this.func_190710_o(n);
        return \u260322;
    }

    @Override
    protected SoundEvent func_184785_dv() {
        return SoundEvents.field_191250_dA;
    }

    @Override
    protected SoundEvent func_184639_G() {
        return SoundEvents.field_191260_dz;
    }

    @Override
    protected SoundEvent func_184601_bQ(DamageSource damageSource) {
        return SoundEvents.field_191254_dE;
    }

    @Override
    protected SoundEvent func_184615_bR() {
        return SoundEvents.field_191252_dC;
    }

    @Override
    protected void func_180429_a(BlockPos blockPos, BlockState blockState) {
        this.func_184185_a(SoundEvents.field_191256_dG, 0.15f, 1.0f);
    }

    @Override
    protected void func_190697_dk() {
        this.func_184185_a(SoundEvents.field_191251_dB, 1.0f, (this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.2f + 1.0f);
    }

    @Override
    public void func_190687_dF() {
        SoundEvent soundEvent = this.func_184785_dv();
        if (soundEvent != null) {
            this.func_184185_a(soundEvent, this.func_70599_aP(), this.func_70647_i());
        }
    }

    @Override
    public int func_190696_dl() {
        return this.func_190707_dL();
    }

    @Override
    public boolean func_190677_dK() {
        return true;
    }

    @Override
    public boolean func_190682_f(ItemStack itemStack) {
        Item item = itemStack.func_77973_b();
        return ItemTags.field_200035_e.func_199685_a_(item);
    }

    @Override
    public boolean func_190685_dA() {
        return false;
    }

    @Override
    public void func_76316_a(IInventory iInventory) {
        DyeColor dyeColor = this.func_190704_dO();
        super.func_76316_a(iInventory);
        \u2603 = this.func_190704_dO();
        if (this.field_70173_aa > 20 && \u2603 != null && \u2603 != dyeColor) {
            this.func_184185_a(SoundEvents.field_191257_dH, 0.5f, 1.0f);
        }
    }

    @Override
    protected void func_110232_cE() {
        if (this.field_70170_p.field_72995_K) {
            return;
        }
        super.func_110232_cE();
        this.func_190711_a(LlamaEntity.func_195403_g(this.field_110296_bG.func_70301_a(1)));
    }

    private void func_190711_a(@Nullable DyeColor dyeColor) {
        this.field_70180_af.func_187227_b(field_190721_bH, dyeColor == null ? -1 : dyeColor.func_196059_a());
    }

    @Nullable
    private static DyeColor func_195403_g(ItemStack itemStack) {
        Block block = Block.func_149634_a(itemStack.func_77973_b());
        if (block instanceof CarpetBlock) {
            return ((CarpetBlock)block).func_196547_d();
        }
        return null;
    }

    @Nullable
    public DyeColor func_190704_dO() {
        int n = this.field_70180_af.func_187225_a(field_190721_bH);
        return n == -1 ? null : DyeColor.func_196056_a(n);
    }

    @Override
    public int func_190676_dC() {
        return 30;
    }

    @Override
    public boolean func_70878_b(AnimalEntity animalEntity) {
        return animalEntity != this && animalEntity instanceof LlamaEntity && this.func_110200_cJ() && ((LlamaEntity)animalEntity).func_110200_cJ();
    }

    @Override
    public LlamaEntity func_90011_a(AgeableEntity ageableEntity) {
        LlamaEntity llamaEntity = this.func_213799_eF();
        this.func_190681_a(ageableEntity, llamaEntity);
        \u2603 = (LlamaEntity)ageableEntity;
        int \u26032 = this.field_70146_Z.nextInt(Math.max(this.func_190707_dL(), \u2603.func_190707_dL())) + 1;
        if (this.field_70146_Z.nextFloat() < 0.03f) {
            ++\u26032;
        }
        llamaEntity.func_190706_p(\u26032);
        llamaEntity.func_190710_o(this.field_70146_Z.nextBoolean() ? this.func_190719_dM() : \u2603.func_190719_dM());
        return llamaEntity;
    }

    protected LlamaEntity func_213799_eF() {
        return EntityType.field_200769_I.func_200721_a(this.field_70170_p);
    }

    private void func_190713_e(LivingEntity livingEntity) {
        LlamaSpitEntity llamaSpitEntity = new LlamaSpitEntity(this.field_70170_p, this);
        double \u26032 = livingEntity.field_70165_t - this.field_70165_t;
        double \u26033 = livingEntity.func_174813_aQ().field_72338_b + (double)(livingEntity.func_213302_cg() / 3.0f) - llamaSpitEntity.field_70163_u;
        double \u26034 = livingEntity.field_70161_v - this.field_70161_v;
        float \u26035 = MathHelper.func_76133_a(\u26032 * \u26032 + \u26034 * \u26034) * 0.2f;
        llamaSpitEntity.func_70186_c(\u26032, \u26033 + (double)\u26035, \u26034, 1.5f, 10.0f);
        this.field_70170_p.func_184148_a(null, this.field_70165_t, this.field_70163_u, this.field_70161_v, SoundEvents.field_191255_dF, this.func_184176_by(), 1.0f, 1.0f + (this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.2f);
        this.field_70170_p.func_217376_c(llamaSpitEntity);
        this.field_190723_bJ = true;
    }

    private void func_190714_x(boolean bl) {
        this.field_190723_bJ = bl;
    }

    @Override
    public void func_180430_e(float f, float f2) {
        BlockState blockState;
        int n = MathHelper.func_76123_f((f * 0.5f - 3.0f) * f2);
        if (n <= 0) {
            return;
        }
        if (f >= 6.0f) {
            this.func_70097_a(DamageSource.field_76379_h, n);
            if (this.func_184207_aI()) {
                for (Entity entity : this.func_184182_bu()) {
                    entity.func_70097_a(DamageSource.field_76379_h, n);
                }
            }
        }
        if (!(blockState = this.field_70170_p.func_180495_p(new BlockPos(this.field_70165_t, this.field_70163_u - 0.2 - (double)this.field_70126_B, this.field_70161_v))).func_196958_f() && !this.func_174814_R()) {
            SoundType soundType = blockState.func_215695_r();
            this.field_70170_p.func_184148_a(null, this.field_70165_t, this.field_70163_u, this.field_70161_v, soundType.func_185844_d(), this.func_184176_by(), soundType.func_185843_a() * 0.5f, soundType.func_185847_b() * 0.75f);
        }
    }

    public void func_190709_dP() {
        if (this.field_190724_bK != null) {
            this.field_190724_bK.field_190725_bL = null;
        }
        this.field_190724_bK = null;
    }

    public void func_190715_a(LlamaEntity llamaEntity) {
        this.field_190724_bK = llamaEntity;
        this.field_190724_bK.field_190725_bL = this;
    }

    public boolean func_190712_dQ() {
        return this.field_190725_bL != null;
    }

    public boolean func_190718_dR() {
        return this.field_190724_bK != null;
    }

    @Nullable
    public LlamaEntity func_190716_dS() {
        return this.field_190724_bK;
    }

    @Override
    protected double func_190634_dg() {
        return 2.0;
    }

    @Override
    protected void func_190679_dD() {
        if (!this.func_190718_dR() && this.func_70631_g_()) {
            super.func_190679_dD();
        }
    }

    @Override
    public boolean func_190684_dE() {
        return false;
    }

    @Override
    public void func_82196_d(LivingEntity livingEntity, float f) {
        this.func_190713_e(livingEntity);
    }

    @Override
    public /* synthetic */ AgeableEntity func_90011_a(AgeableEntity ageableEntity) {
        return this.func_90011_a(ageableEntity);
    }

    static class DefendTargetGoal
    extends NearestAttackableTargetGoal<WolfEntity> {
        public DefendTargetGoal(LlamaEntity llamaEntity) {
            super(llamaEntity, WolfEntity.class, 16, false, true, livingEntity -> !((WolfEntity)livingEntity).func_70909_n());
        }

        @Override
        protected double func_111175_f() {
            return super.func_111175_f() * 0.25;
        }
    }

    static class HurtByTargetGoal
    extends net.minecraft.entity.ai.goal.HurtByTargetGoal {
        public HurtByTargetGoal(LlamaEntity llamaEntity) {
            super(llamaEntity, new Class[0]);
        }

        @Override
        public boolean func_75253_b() {
            LlamaEntity llamaEntity;
            if (this.field_75299_d instanceof LlamaEntity && (llamaEntity = (LlamaEntity)this.field_75299_d).field_190723_bJ) {
                llamaEntity.func_190714_x(false);
                return false;
            }
            return super.func_75253_b();
        }
    }

    static class LlamaData
    implements ILivingEntityData {
        public final int field_190886_a;

        private LlamaData(int n) {
            this.field_190886_a = n;
        }
    }
}

