/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.entity.passive;

import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.goal.SitGoal;
import net.minecraft.entity.passive.AnimalEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.particles.BasicParticleType;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.scoreboard.Team;
import net.minecraft.server.management.PreYggdrasilConverter;
import net.minecraft.util.DamageSource;
import net.minecraft.world.GameRules;
import net.minecraft.world.World;

public abstract class TameableEntity
extends AnimalEntity {
    protected static final DataParameter<Byte> field_184755_bv = EntityDataManager.func_187226_a(TameableEntity.class, DataSerializers.field_187191_a);
    protected static final DataParameter<Optional<UUID>> field_184756_bw = EntityDataManager.func_187226_a(TameableEntity.class, DataSerializers.field_187203_m);
    protected SitGoal field_70911_d;

    protected TameableEntity(EntityType<? extends TameableEntity> entityType, World world) {
        super((EntityType<? extends AnimalEntity>)entityType, world);
        this.func_175544_ck();
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(field_184755_bv, (byte)0);
        this.field_70180_af.func_187214_a(field_184756_bw, Optional.empty());
    }

    @Override
    public void func_213281_b(CompoundNBT compoundNBT) {
        super.func_213281_b(compoundNBT);
        if (this.func_184753_b() == null) {
            compoundNBT.func_74778_a("OwnerUUID", "");
        } else {
            compoundNBT.func_74778_a("OwnerUUID", this.func_184753_b().toString());
        }
        compoundNBT.func_74757_a("Sitting", this.func_70906_o());
    }

    @Override
    public void func_70037_a(CompoundNBT compoundNBT2) {
        String \u26033;
        super.func_70037_a(compoundNBT2);
        if (compoundNBT2.func_150297_b("OwnerUUID", 8)) {
            \u26033 = compoundNBT2.func_74779_i("OwnerUUID");
        } else {
            CompoundNBT compoundNBT2;
            String \u26032 = compoundNBT2.func_74779_i("Owner");
            \u26033 = PreYggdrasilConverter.func_187473_a(this.func_184102_h(), \u26032);
        }
        if (!\u26033.isEmpty()) {
            try {
                this.func_184754_b(UUID.fromString(\u26033));
                this.func_70903_f(true);
            }
            catch (Throwable \u26034) {
                this.func_70903_f(false);
            }
        }
        if (this.field_70911_d != null) {
            this.field_70911_d.func_75270_a(compoundNBT2.func_74767_n("Sitting"));
        }
        this.func_70904_g(compoundNBT2.func_74767_n("Sitting"));
    }

    @Override
    public boolean func_184652_a(PlayerEntity playerEntity) {
        return !this.func_110167_bD();
    }

    protected void func_70908_e(boolean bl) {
        BasicParticleType basicParticleType = ParticleTypes.field_197633_z;
        if (!bl) {
            basicParticleType = ParticleTypes.field_197601_L;
        }
        for (int i = 0; i < 7; ++i) {
            double d = this.field_70146_Z.nextGaussian() * 0.02;
            \u2603 = this.field_70146_Z.nextGaussian() * 0.02;
            \u2603 = this.field_70146_Z.nextGaussian() * 0.02;
            this.field_70170_p.func_195594_a(basicParticleType, this.field_70165_t + (double)(this.field_70146_Z.nextFloat() * this.func_213311_cf() * 2.0f) - (double)this.func_213311_cf(), this.field_70163_u + 0.5 + (double)(this.field_70146_Z.nextFloat() * this.func_213302_cg()), this.field_70161_v + (double)(this.field_70146_Z.nextFloat() * this.func_213311_cf() * 2.0f) - (double)this.func_213311_cf(), d, \u2603, \u2603);
        }
    }

    @Override
    public void func_70103_a(byte by) {
        if (by == 7) {
            this.func_70908_e(true);
        } else if (by == 6) {
            this.func_70908_e(false);
        } else {
            super.func_70103_a(by);
        }
    }

    public boolean func_70909_n() {
        return (this.field_70180_af.func_187225_a(field_184755_bv) & 4) != 0;
    }

    public void func_70903_f(boolean bl) {
        byte by = this.field_70180_af.func_187225_a(field_184755_bv);
        if (bl) {
            this.field_70180_af.func_187227_b(field_184755_bv, (byte)(by | 4));
        } else {
            this.field_70180_af.func_187227_b(field_184755_bv, (byte)(by & 0xFFFFFFFB));
        }
        this.func_175544_ck();
    }

    protected void func_175544_ck() {
    }

    public boolean func_70906_o() {
        return (this.field_70180_af.func_187225_a(field_184755_bv) & 1) != 0;
    }

    public void func_70904_g(boolean bl) {
        byte by = this.field_70180_af.func_187225_a(field_184755_bv);
        if (bl) {
            this.field_70180_af.func_187227_b(field_184755_bv, (byte)(by | 1));
        } else {
            this.field_70180_af.func_187227_b(field_184755_bv, (byte)(by & 0xFFFFFFFE));
        }
    }

    @Nullable
    public UUID func_184753_b() {
        return this.field_70180_af.func_187225_a(field_184756_bw).orElse(null);
    }

    public void func_184754_b(@Nullable UUID uUID) {
        this.field_70180_af.func_187227_b(field_184756_bw, Optional.ofNullable(uUID));
    }

    public void func_193101_c(PlayerEntity playerEntity) {
        this.func_70903_f(true);
        this.func_184754_b(playerEntity.func_110124_au());
        if (playerEntity instanceof ServerPlayerEntity) {
            CriteriaTriggers.field_193136_w.func_193178_a((ServerPlayerEntity)playerEntity, this);
        }
    }

    @Nullable
    public LivingEntity func_70902_q() {
        try {
            UUID uUID = this.func_184753_b();
            if (uUID == null) {
                return null;
            }
            return this.field_70170_p.func_217371_b(uUID);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return null;
        }
    }

    @Override
    public boolean func_213336_c(LivingEntity livingEntity) {
        if (this.func_152114_e(livingEntity)) {
            return false;
        }
        return super.func_213336_c(livingEntity);
    }

    public boolean func_152114_e(LivingEntity livingEntity) {
        return livingEntity == this.func_70902_q();
    }

    public SitGoal func_70907_r() {
        return this.field_70911_d;
    }

    public boolean func_142018_a(LivingEntity livingEntity, LivingEntity livingEntity2) {
        return true;
    }

    @Override
    public Team func_96124_cp() {
        LivingEntity livingEntity;
        if (this.func_70909_n() && (livingEntity = this.func_70902_q()) != null) {
            return livingEntity.func_96124_cp();
        }
        return super.func_96124_cp();
    }

    @Override
    public boolean func_184191_r(Entity entity2) {
        Entity entity2;
        if (this.func_70909_n()) {
            LivingEntity livingEntity = this.func_70902_q();
            if (entity2 == livingEntity) {
                return true;
            }
            if (livingEntity != null) {
                return livingEntity.func_184191_r(entity2);
            }
        }
        return super.func_184191_r(entity2);
    }

    @Override
    public void func_70645_a(DamageSource damageSource) {
        if (!this.field_70170_p.field_72995_K && this.field_70170_p.func_82736_K().func_223586_b(GameRules.field_223609_l) && this.func_70902_q() instanceof ServerPlayerEntity) {
            this.func_70902_q().func_145747_a(this.func_110142_aN().func_151521_b());
        }
        super.func_70645_a(damageSource);
    }
}

