/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.entity.monster;

import java.util.Random;
import java.util.function.Predicate;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.ShootableItem;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.Difficulty;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.LightType;
import net.minecraft.world.World;

public abstract class MonsterEntity
extends CreatureEntity
implements IMob {
    protected MonsterEntity(EntityType<? extends MonsterEntity> entityType, World world) {
        super((EntityType<? extends CreatureEntity>)entityType, world);
        this.field_70728_aV = 5;
    }

    @Override
    public SoundCategory func_184176_by() {
        return SoundCategory.HOSTILE;
    }

    @Override
    public void func_70636_d() {
        this.func_82168_bl();
        this.func_213623_ec();
        super.func_70636_d();
    }

    protected void func_213623_ec() {
        float f = this.func_70013_c();
        if (f > 0.5f) {
            this.field_70708_bq += 2;
        }
    }

    @Override
    public void func_70071_h_() {
        super.func_70071_h_();
        if (!this.field_70170_p.field_72995_K && this.field_70170_p.func_175659_aa() == Difficulty.PEACEFUL) {
            this.func_70106_y();
        }
    }

    @Override
    protected SoundEvent func_184184_Z() {
        return SoundEvents.field_187593_cC;
    }

    @Override
    protected SoundEvent func_184181_aa() {
        return SoundEvents.field_187591_cB;
    }

    @Override
    public boolean func_70097_a(DamageSource damageSource, float f) {
        if (this.func_180431_b(damageSource)) {
            return false;
        }
        return super.func_70097_a(damageSource, f);
    }

    @Override
    protected SoundEvent func_184601_bQ(DamageSource damageSource) {
        return SoundEvents.field_187741_cz;
    }

    @Override
    protected SoundEvent func_184615_bR() {
        return SoundEvents.field_187738_cy;
    }

    @Override
    protected SoundEvent func_184588_d(int n) {
        if (n > 4) {
            return SoundEvents.field_187735_cx;
        }
        return SoundEvents.field_187589_cA;
    }

    @Override
    public float func_205022_a(BlockPos blockPos, IWorldReader iWorldReader) {
        return 0.5f - iWorldReader.func_205052_D(blockPos);
    }

    public static boolean func_223323_a(IWorld iWorld, BlockPos blockPos, Random random) {
        if (iWorld.func_175642_b(LightType.SKY, blockPos) > random.nextInt(32)) {
            return false;
        }
        int n = iWorld.func_201672_e().func_72911_I() ? iWorld.func_205049_d(blockPos, 10) : iWorld.func_201696_r(blockPos);
        return n <= random.nextInt(8);
    }

    public static boolean func_223325_c(EntityType<? extends MonsterEntity> entityType, IWorld iWorld, SpawnReason spawnReason, BlockPos blockPos, Random random) {
        return iWorld.func_175659_aa() != Difficulty.PEACEFUL && MonsterEntity.func_223323_a(iWorld, blockPos, random) && MonsterEntity.func_223315_a(entityType, iWorld, spawnReason, blockPos, random);
    }

    public static boolean func_223324_d(EntityType<? extends MonsterEntity> entityType, IWorld iWorld, SpawnReason spawnReason, BlockPos blockPos, Random random) {
        return iWorld.func_175659_aa() != Difficulty.PEACEFUL && MonsterEntity.func_223315_a(entityType, iWorld, spawnReason, blockPos, random);
    }

    @Override
    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110140_aT().func_111150_b(SharedMonsterAttributes.field_111264_e);
    }

    @Override
    protected boolean func_146066_aG() {
        return true;
    }

    public boolean func_191990_c(PlayerEntity playerEntity) {
        return true;
    }

    @Override
    public ItemStack func_213356_f(ItemStack itemStack) {
        if (itemStack.func_77973_b() instanceof ShootableItem) {
            Predicate<ItemStack> predicate = ((ShootableItem)itemStack.func_77973_b()).func_220006_d();
            ItemStack \u26032 = ShootableItem.func_220005_a(this, predicate);
            return \u26032.func_190926_b() ? new ItemStack(Items.field_151032_g) : \u26032;
        }
        return ItemStack.field_190927_a;
    }
}

