/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.entity.monster;

import java.util.EnumSet;
import java.util.Random;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.FlyingEntity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.Pose;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.controller.MovementController;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.projectile.FireballEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.Difficulty;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;

public class GhastEntity
extends FlyingEntity
implements IMob {
    private static final DataParameter<Boolean> field_184683_a = EntityDataManager.func_187226_a(GhastEntity.class, DataSerializers.field_187198_h);
    private int field_92014_j = 1;

    public GhastEntity(EntityType<? extends GhastEntity> entityType, World world) {
        super((EntityType<? extends FlyingEntity>)entityType, world);
        this.field_70728_aV = 5;
        this.field_70765_h = new MoveHelperController(this);
    }

    @Override
    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(5, new RandomFlyGoal(this));
        this.field_70714_bg.func_75776_a(7, new LookAroundGoal(this));
        this.field_70714_bg.func_75776_a(7, new FireballAttackGoal(this));
        this.field_70715_bh.func_75776_a(1, new NearestAttackableTargetGoal<PlayerEntity>(this, PlayerEntity.class, 10, true, false, livingEntity -> Math.abs(livingEntity.field_70163_u - this.field_70163_u) <= 4.0));
    }

    public boolean func_110182_bF() {
        return this.field_70180_af.func_187225_a(field_184683_a);
    }

    public void func_175454_a(boolean bl) {
        this.field_70180_af.func_187227_b(field_184683_a, bl);
    }

    public int func_175453_cd() {
        return this.field_92014_j;
    }

    @Override
    public void func_70071_h_() {
        super.func_70071_h_();
        if (!this.field_70170_p.field_72995_K && this.field_70170_p.func_175659_aa() == Difficulty.PEACEFUL) {
            this.func_70106_y();
        }
    }

    @Override
    public boolean func_70097_a(DamageSource damageSource, float f) {
        if (this.func_180431_b(damageSource)) {
            return false;
        }
        if (damageSource.func_76364_f() instanceof FireballEntity && damageSource.func_76346_g() instanceof PlayerEntity) {
            super.func_70097_a(damageSource, 1000.0f);
            return true;
        }
        return super.func_70097_a(damageSource, f);
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(field_184683_a, false);
    }

    @Override
    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(10.0);
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(100.0);
    }

    @Override
    public SoundCategory func_184176_by() {
        return SoundCategory.HOSTILE;
    }

    @Override
    protected SoundEvent func_184639_G() {
        return SoundEvents.field_187551_bH;
    }

    @Override
    protected SoundEvent func_184601_bQ(DamageSource damageSource) {
        return SoundEvents.field_187555_bJ;
    }

    @Override
    protected SoundEvent func_184615_bR() {
        return SoundEvents.field_187553_bI;
    }

    @Override
    protected float func_70599_aP() {
        return 10.0f;
    }

    public static boolean func_223368_b(EntityType<GhastEntity> entityType, IWorld iWorld, SpawnReason spawnReason, BlockPos blockPos, Random random) {
        return iWorld.func_175659_aa() != Difficulty.PEACEFUL && random.nextInt(20) == 0 && GhastEntity.func_223315_a(entityType, iWorld, spawnReason, blockPos, random);
    }

    @Override
    public int func_70641_bl() {
        return 1;
    }

    @Override
    public void func_213281_b(CompoundNBT compoundNBT) {
        super.func_213281_b(compoundNBT);
        compoundNBT.func_74768_a("ExplosionPower", this.field_92014_j);
    }

    @Override
    public void func_70037_a(CompoundNBT compoundNBT) {
        super.func_70037_a(compoundNBT);
        if (compoundNBT.func_150297_b("ExplosionPower", 99)) {
            this.field_92014_j = compoundNBT.func_74762_e("ExplosionPower");
        }
    }

    @Override
    protected float func_213348_b(Pose pose, EntitySize entitySize) {
        return 2.6f;
    }

    static class FireballAttackGoal
    extends Goal {
        private final GhastEntity field_179470_b;
        public int field_179471_a;

        public FireballAttackGoal(GhastEntity ghastEntity) {
            this.field_179470_b = ghastEntity;
        }

        @Override
        public boolean func_75250_a() {
            return this.field_179470_b.func_70638_az() != null;
        }

        @Override
        public void func_75249_e() {
            this.field_179471_a = 0;
        }

        @Override
        public void func_75251_c() {
            this.field_179470_b.func_175454_a(false);
        }

        @Override
        public void func_75246_d() {
            LivingEntity livingEntity = this.field_179470_b.func_70638_az();
            double \u26032 = 64.0;
            if (livingEntity.func_70068_e(this.field_179470_b) < 4096.0 && this.field_179470_b.func_70685_l(livingEntity)) {
                World world = this.field_179470_b.field_70170_p;
                ++this.field_179471_a;
                if (this.field_179471_a == 10) {
                    world.func_217378_a(null, 1015, new BlockPos(this.field_179470_b), 0);
                }
                if (this.field_179471_a == 20) {
                    double d = 4.0;
                    Vec3d \u26033 = this.field_179470_b.func_70676_i(1.0f);
                    \u2603 = livingEntity.field_70165_t - (this.field_179470_b.field_70165_t + \u26033.field_72450_a * 4.0);
                    \u2603 = livingEntity.func_174813_aQ().field_72338_b + (double)(livingEntity.func_213302_cg() / 2.0f) - (0.5 + this.field_179470_b.field_70163_u + (double)(this.field_179470_b.func_213302_cg() / 2.0f));
                    \u2603 = livingEntity.field_70161_v - (this.field_179470_b.field_70161_v + \u26033.field_72449_c * 4.0);
                    world.func_217378_a(null, 1016, new BlockPos(this.field_179470_b), 0);
                    FireballEntity \u26034 = new FireballEntity(world, this.field_179470_b, \u2603, \u2603, \u2603);
                    \u26034.field_92057_e = this.field_179470_b.func_175453_cd();
                    \u26034.field_70165_t = this.field_179470_b.field_70165_t + \u26033.field_72450_a * 4.0;
                    \u26034.field_70163_u = this.field_179470_b.field_70163_u + (double)(this.field_179470_b.func_213302_cg() / 2.0f) + 0.5;
                    \u26034.field_70161_v = this.field_179470_b.field_70161_v + \u26033.field_72449_c * 4.0;
                    world.func_217376_c(\u26034);
                    this.field_179471_a = -40;
                }
            } else if (this.field_179471_a > 0) {
                --this.field_179471_a;
            }
            this.field_179470_b.func_175454_a(this.field_179471_a > 10);
        }
    }

    static class LookAroundGoal
    extends Goal {
        private final GhastEntity field_179472_a;

        public LookAroundGoal(GhastEntity ghastEntity) {
            this.field_179472_a = ghastEntity;
            this.func_220684_a(EnumSet.of(Goal.Flag.LOOK));
        }

        @Override
        public boolean func_75250_a() {
            return true;
        }

        @Override
        public void func_75246_d() {
            if (this.field_179472_a.func_70638_az() == null) {
                Vec3d vec3d = this.field_179472_a.func_213322_ci();
                this.field_179472_a.field_70761_aq = this.field_179472_a.field_70177_z = -((float)MathHelper.func_181159_b(vec3d.field_72450_a, vec3d.field_72449_c)) * 57.295776f;
            } else {
                LivingEntity livingEntity = this.field_179472_a.func_70638_az();
                double \u26032 = 64.0;
                if (livingEntity.func_70068_e(this.field_179472_a) < 4096.0) {
                    double d = livingEntity.field_70165_t - this.field_179472_a.field_70165_t;
                    \u2603 = livingEntity.field_70161_v - this.field_179472_a.field_70161_v;
                    this.field_179472_a.field_70761_aq = this.field_179472_a.field_70177_z = -((float)MathHelper.func_181159_b(d, \u2603)) * 57.295776f;
                }
            }
        }
    }

    static class RandomFlyGoal
    extends Goal {
        private final GhastEntity field_179454_a;

        public RandomFlyGoal(GhastEntity ghastEntity) {
            this.field_179454_a = ghastEntity;
            this.func_220684_a(EnumSet.of(Goal.Flag.MOVE));
        }

        @Override
        public boolean func_75250_a() {
            MovementController movementController = this.field_179454_a.func_70605_aq();
            if (!movementController.func_75640_a()) {
                return true;
            }
            double \u26032 = movementController.func_179917_d() - this.field_179454_a.field_70165_t;
            double \u26033 = \u26032 * \u26032 + (\u2603 = movementController.func_179919_e() - this.field_179454_a.field_70163_u) * \u2603 + (\u2603 = movementController.func_179918_f() - this.field_179454_a.field_70161_v) * \u2603;
            return \u26033 < 1.0 || \u26033 > 3600.0;
        }

        @Override
        public boolean func_75253_b() {
            return false;
        }

        @Override
        public void func_75249_e() {
            Random random = this.field_179454_a.func_70681_au();
            double \u26032 = this.field_179454_a.field_70165_t + (double)((random.nextFloat() * 2.0f - 1.0f) * 16.0f);
            double \u26033 = this.field_179454_a.field_70163_u + (double)((random.nextFloat() * 2.0f - 1.0f) * 16.0f);
            double \u26034 = this.field_179454_a.field_70161_v + (double)((random.nextFloat() * 2.0f - 1.0f) * 16.0f);
            this.field_179454_a.func_70605_aq().func_75642_a(\u26032, \u26033, \u26034, 1.0);
        }
    }

    static class MoveHelperController
    extends MovementController {
        private final GhastEntity field_179927_g;
        private int field_179928_h;

        public MoveHelperController(GhastEntity ghastEntity) {
            super(ghastEntity);
            this.field_179927_g = ghastEntity;
        }

        @Override
        public void func_75641_c() {
            if (this.field_188491_h != MovementController.Action.MOVE_TO) {
                return;
            }
            if (this.field_179928_h-- <= 0) {
                this.field_179928_h += this.field_179927_g.func_70681_au().nextInt(5) + 2;
                Vec3d vec3d = new Vec3d(this.field_75646_b - this.field_179927_g.field_70165_t, this.field_75647_c - this.field_179927_g.field_70163_u, this.field_75644_d - this.field_179927_g.field_70161_v);
                double \u26032 = vec3d.func_72433_c();
                if (this.func_220673_a(vec3d = vec3d.func_72432_b(), MathHelper.func_76143_f(\u26032))) {
                    this.field_179927_g.func_213317_d(this.field_179927_g.func_213322_ci().func_178787_e(vec3d.func_186678_a(0.1)));
                } else {
                    this.field_188491_h = MovementController.Action.WAIT;
                }
            }
        }

        private boolean func_220673_a(Vec3d vec3d, int n) {
            AxisAlignedBB axisAlignedBB = this.field_179927_g.func_174813_aQ();
            for (int i = 1; i < n; ++i) {
                if (this.field_179927_g.field_70170_p.func_195586_b(this.field_179927_g, axisAlignedBB = axisAlignedBB.func_191194_a(vec3d))) continue;
                return false;
            }
            return true;
        }
    }
}

