/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.entity;

import com.google.common.collect.Maps;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractSkullBlock;
import net.minecraft.block.Blocks;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ILivingEntityData;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.EntitySenses;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.controller.BodyController;
import net.minecraft.entity.ai.controller.JumpController;
import net.minecraft.entity.ai.controller.LookController;
import net.minecraft.entity.ai.controller.MovementController;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.GoalSelector;
import net.minecraft.entity.item.BoatEntity;
import net.minecraft.entity.item.HangingEntity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.item.LeashKnotEntity;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.Fluid;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ArmorItem;
import net.minecraft.item.AxeItem;
import net.minecraft.item.BlockItem;
import net.minecraft.item.BowItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.SwordItem;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.FloatNBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.network.DebugPacketSender;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.play.server.SMountEntityPacket;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.pathfinding.GroundPathNavigator;
import net.minecraft.pathfinding.PathNavigator;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.tags.Tag;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Hand;
import net.minecraft.util.HandSide;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.Difficulty;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.GameRules;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraft.world.storage.loot.LootContext;

public abstract class MobEntity
extends LivingEntity {
    private static final DataParameter<Byte> field_184654_a = EntityDataManager.func_187226_a(MobEntity.class, DataSerializers.field_187191_a);
    public int field_70757_a;
    protected int field_70728_aV;
    protected LookController field_70749_g;
    protected MovementController field_70765_h;
    protected JumpController field_70767_i;
    private final BodyController field_70762_j;
    protected PathNavigator field_70699_by;
    protected final GoalSelector field_70714_bg;
    protected final GoalSelector field_70715_bh;
    private LivingEntity field_70696_bz;
    private final EntitySenses field_70723_bA;
    private final NonNullList<ItemStack> field_184656_bv = NonNullList.func_191197_a(2, ItemStack.field_190927_a);
    protected final float[] field_82174_bp = new float[2];
    private final NonNullList<ItemStack> field_184657_bw = NonNullList.func_191197_a(4, ItemStack.field_190927_a);
    protected final float[] field_184655_bs = new float[4];
    private boolean field_82172_bs;
    private boolean field_82179_bU;
    private final Map<PathNodeType, Float> field_184658_bz = Maps.newEnumMap(PathNodeType.class);
    private ResourceLocation field_184659_bA;
    private long field_184653_bB;
    @Nullable
    private Entity field_110168_bw;
    private int field_213400_bI;
    @Nullable
    private CompoundNBT field_110170_bx;
    private BlockPos field_213401_bK = BlockPos.field_177992_a;
    private float field_213402_bL = -1.0f;

    protected MobEntity(EntityType<? extends MobEntity> entityType, World world) {
        super((EntityType<? extends LivingEntity>)entityType, world);
        this.field_70714_bg = new GoalSelector(world == null || world.func_217381_Z() == null ? null : world.func_217381_Z());
        this.field_70715_bh = new GoalSelector(world == null || world.func_217381_Z() == null ? null : world.func_217381_Z());
        this.field_70749_g = new LookController(this);
        this.field_70765_h = new MovementController(this);
        this.field_70767_i = new JumpController(this);
        this.field_70762_j = this.func_184650_s();
        this.field_70699_by = this.func_175447_b(world);
        this.field_70723_bA = new EntitySenses(this);
        Arrays.fill(this.field_184655_bs, 0.085f);
        Arrays.fill(this.field_82174_bp, 0.085f);
        if (world != null && !world.field_72995_K) {
            this.func_184651_r();
        }
    }

    protected void func_184651_r() {
    }

    @Override
    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110140_aT().func_111150_b(SharedMonsterAttributes.field_111265_b).func_111128_a(16.0);
        this.func_110140_aT().func_111150_b(SharedMonsterAttributes.field_221120_g);
    }

    protected PathNavigator func_175447_b(World world) {
        return new GroundPathNavigator(this, world);
    }

    public float func_184643_a(PathNodeType pathNodeType) {
        Float f = this.field_184658_bz.get((Object)pathNodeType);
        return f == null ? pathNodeType.func_186289_a() : f.floatValue();
    }

    public void func_184644_a(PathNodeType pathNodeType, float f) {
        this.field_184658_bz.put(pathNodeType, Float.valueOf(f));
    }

    protected BodyController func_184650_s() {
        return new BodyController(this);
    }

    public LookController func_70671_ap() {
        return this.field_70749_g;
    }

    public MovementController func_70605_aq() {
        if (this.func_184218_aH() && this.func_184187_bx() instanceof MobEntity) {
            MobEntity mobEntity = (MobEntity)this.func_184187_bx();
            return mobEntity.func_70605_aq();
        }
        return this.field_70765_h;
    }

    public JumpController func_70683_ar() {
        return this.field_70767_i;
    }

    public PathNavigator func_70661_as() {
        if (this.func_184218_aH() && this.func_184187_bx() instanceof MobEntity) {
            MobEntity mobEntity = (MobEntity)this.func_184187_bx();
            return mobEntity.func_70661_as();
        }
        return this.field_70699_by;
    }

    public EntitySenses func_70635_at() {
        return this.field_70723_bA;
    }

    @Nullable
    public LivingEntity func_70638_az() {
        return this.field_70696_bz;
    }

    public void func_70624_b(@Nullable LivingEntity livingEntity) {
        this.field_70696_bz = livingEntity;
    }

    @Override
    public boolean func_213358_a(EntityType<?> entityType) {
        return entityType != EntityType.field_200811_y;
    }

    public void func_70615_aA() {
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(field_184654_a, (byte)0);
    }

    public int func_70627_aG() {
        return 80;
    }

    public void func_70642_aH() {
        SoundEvent soundEvent = this.func_184639_G();
        if (soundEvent != null) {
            this.func_184185_a(soundEvent, this.func_70599_aP(), this.func_70647_i());
        }
    }

    @Override
    public void func_70030_z() {
        super.func_70030_z();
        this.field_70170_p.func_217381_Z().func_76320_a("mobBaseTick");
        if (this.func_70089_S() && this.field_70146_Z.nextInt(1000) < this.field_70757_a++) {
            this.func_175456_n();
            this.func_70642_aH();
        }
        this.field_70170_p.func_217381_Z().func_76319_b();
    }

    @Override
    protected void func_184581_c(DamageSource damageSource) {
        this.func_175456_n();
        super.func_184581_c(damageSource);
    }

    private void func_175456_n() {
        this.field_70757_a = -this.func_70627_aG();
    }

    @Override
    protected int func_70693_a(PlayerEntity playerEntity) {
        if (this.field_70728_aV > 0) {
            int n = this.field_70728_aV;
            for (\u2603 = 0; \u2603 < this.field_184657_bw.size(); ++\u2603) {
                if (this.field_184657_bw.get(\u2603).func_190926_b() || !(this.field_184655_bs[\u2603] <= 1.0f)) continue;
                n += 1 + this.field_70146_Z.nextInt(3);
            }
            for (\u2603 = 0; \u2603 < this.field_184656_bv.size(); ++\u2603) {
                if (this.field_184656_bv.get(\u2603).func_190926_b() || !(this.field_82174_bp[\u2603] <= 1.0f)) continue;
                n += 1 + this.field_70146_Z.nextInt(3);
            }
            return n;
        }
        return this.field_70728_aV;
    }

    public void func_70656_aK() {
        if (this.field_70170_p.field_72995_K) {
            for (int i = 0; i < 20; ++i) {
                double d = this.field_70146_Z.nextGaussian() * 0.02;
                \u2603 = this.field_70146_Z.nextGaussian() * 0.02;
                \u2603 = this.field_70146_Z.nextGaussian() * 0.02;
                \u2603 = 10.0;
                this.field_70170_p.func_195594_a(ParticleTypes.field_197598_I, this.field_70165_t + (double)(this.field_70146_Z.nextFloat() * this.func_213311_cf() * 2.0f) - (double)this.func_213311_cf() - d * 10.0, this.field_70163_u + (double)(this.field_70146_Z.nextFloat() * this.func_213302_cg()) - \u2603 * 10.0, this.field_70161_v + (double)(this.field_70146_Z.nextFloat() * this.func_213311_cf() * 2.0f) - (double)this.func_213311_cf() - \u2603 * 10.0, d, \u2603, \u2603);
            }
        } else {
            this.field_70170_p.func_72960_a(this, (byte)20);
        }
    }

    @Override
    public void func_70103_a(byte by) {
        if (by == 20) {
            this.func_70656_aK();
        } else {
            super.func_70103_a(by);
        }
    }

    @Override
    public void func_70071_h_() {
        super.func_70071_h_();
        if (!this.field_70170_p.field_72995_K) {
            this.func_110159_bB();
            if (this.field_70173_aa % 5 == 0) {
                this.func_213385_F();
            }
        }
    }

    protected void func_213385_F() {
        boolean bl = !(this.func_184179_bs() instanceof MobEntity);
        \u2603 = !(this.func_184187_bx() instanceof BoatEntity);
        this.field_70714_bg.func_220878_a(Goal.Flag.MOVE, bl);
        this.field_70714_bg.func_220878_a(Goal.Flag.JUMP, bl && \u2603);
        this.field_70714_bg.func_220878_a(Goal.Flag.LOOK, bl);
    }

    @Override
    protected float func_110146_f(float f, float f2) {
        this.field_70762_j.func_75664_a();
        return f2;
    }

    @Nullable
    protected SoundEvent func_184639_G() {
        return null;
    }

    @Override
    public void func_213281_b(CompoundNBT compoundNBT2) {
        super.func_213281_b(compoundNBT2);
        compoundNBT2.func_74757_a("CanPickUpLoot", this.func_98052_bS());
        compoundNBT2.func_74757_a("PersistenceRequired", this.field_82179_bU);
        ListNBT listNBT = new ListNBT();
        for (ItemStack itemStack : this.field_184657_bw) {
            CompoundNBT compoundNBT = new CompoundNBT();
            if (!itemStack.func_190926_b()) {
                itemStack.func_77955_b(compoundNBT);
            }
            listNBT.add(compoundNBT);
        }
        compoundNBT2.func_218657_a("ArmorItems", listNBT);
        ListNBT \u26032 = new ListNBT();
        for (ItemStack itemStack : this.field_184656_bv) {
            CompoundNBT compoundNBT3 = new CompoundNBT();
            if (!itemStack.func_190926_b()) {
                itemStack.func_77955_b(compoundNBT3);
            }
            \u26032.add(compoundNBT3);
        }
        compoundNBT2.func_218657_a("HandItems", \u26032);
        ListNBT listNBT2 = new ListNBT();
        for (float object : this.field_184655_bs) {
            listNBT2.add(new FloatNBT(object));
        }
        compoundNBT2.func_218657_a("ArmorDropChances", listNBT2);
        ListNBT listNBT3 = new ListNBT();
        for (float f : this.field_82174_bp) {
            listNBT3.add(new FloatNBT(f));
        }
        compoundNBT2.func_218657_a("HandDropChances", listNBT3);
        if (this.field_110168_bw != null) {
            CompoundNBT compoundNBT = new CompoundNBT();
            if (this.field_110168_bw instanceof LivingEntity) {
                UUID uUID = this.field_110168_bw.func_110124_au();
                compoundNBT.func_186854_a("UUID", uUID);
            } else if (this.field_110168_bw instanceof HangingEntity) {
                BlockPos blockPos = ((HangingEntity)this.field_110168_bw).func_174857_n();
                compoundNBT.func_74768_a("X", blockPos.func_177958_n());
                compoundNBT.func_74768_a("Y", blockPos.func_177956_o());
                compoundNBT.func_74768_a("Z", blockPos.func_177952_p());
            }
            compoundNBT2.func_218657_a("Leash", compoundNBT);
        }
        compoundNBT2.func_74757_a("LeftHanded", this.func_184638_cS());
        if (this.field_184659_bA != null) {
            compoundNBT2.func_74778_a("DeathLootTable", this.field_184659_bA.toString());
            if (this.field_184653_bB != 0L) {
                compoundNBT2.func_74772_a("DeathLootTableSeed", this.field_184653_bB);
            }
        }
        if (this.func_175446_cd()) {
            compoundNBT2.func_74757_a("NoAI", this.func_175446_cd());
        }
    }

    @Override
    public void func_70037_a(CompoundNBT compoundNBT2) {
        CompoundNBT compoundNBT2;
        int n;
        ListNBT listNBT;
        super.func_70037_a(compoundNBT2);
        if (compoundNBT2.func_150297_b("CanPickUpLoot", 1)) {
            this.func_98053_h(compoundNBT2.func_74767_n("CanPickUpLoot"));
        }
        this.field_82179_bU = compoundNBT2.func_74767_n("PersistenceRequired");
        if (compoundNBT2.func_150297_b("ArmorItems", 9)) {
            listNBT = compoundNBT2.func_150295_c("ArmorItems", 10);
            for (n = 0; n < this.field_184657_bw.size(); ++n) {
                this.field_184657_bw.set(n, ItemStack.func_199557_a(listNBT.func_150305_b(n)));
            }
        }
        if (compoundNBT2.func_150297_b("HandItems", 9)) {
            listNBT = compoundNBT2.func_150295_c("HandItems", 10);
            for (n = 0; n < this.field_184656_bv.size(); ++n) {
                this.field_184656_bv.set(n, ItemStack.func_199557_a(listNBT.func_150305_b(n)));
            }
        }
        if (compoundNBT2.func_150297_b("ArmorDropChances", 9)) {
            listNBT = compoundNBT2.func_150295_c("ArmorDropChances", 5);
            for (n = 0; n < listNBT.size(); ++n) {
                this.field_184655_bs[n] = listNBT.func_150308_e(n);
            }
        }
        if (compoundNBT2.func_150297_b("HandDropChances", 9)) {
            listNBT = compoundNBT2.func_150295_c("HandDropChances", 5);
            for (n = 0; n < listNBT.size(); ++n) {
                this.field_82174_bp[n] = listNBT.func_150308_e(n);
            }
        }
        if (compoundNBT2.func_150297_b("Leash", 10)) {
            this.field_110170_bx = compoundNBT2.func_74775_l("Leash");
        }
        this.func_184641_n(compoundNBT2.func_74767_n("LeftHanded"));
        if (compoundNBT2.func_150297_b("DeathLootTable", 8)) {
            this.field_184659_bA = new ResourceLocation(compoundNBT2.func_74779_i("DeathLootTable"));
            this.field_184653_bB = compoundNBT2.func_74763_f("DeathLootTableSeed");
        }
        this.func_94061_f(compoundNBT2.func_74767_n("NoAI"));
    }

    @Override
    protected void func_213354_a(DamageSource damageSource, boolean bl) {
        super.func_213354_a(damageSource, bl);
        this.field_184659_bA = null;
    }

    @Override
    protected LootContext.Builder func_213363_a(boolean bl, DamageSource damageSource) {
        return super.func_213363_a(bl, damageSource).func_216020_a(this.field_184653_bB, this.field_70146_Z);
    }

    @Override
    public final ResourceLocation func_213346_cF() {
        return this.field_184659_bA == null ? this.func_184647_J() : this.field_184659_bA;
    }

    protected ResourceLocation func_184647_J() {
        return super.func_213346_cF();
    }

    public void func_191989_p(float f) {
        this.field_191988_bg = f;
    }

    public void func_70657_f(float f) {
        this.field_70701_bs = f;
    }

    public void func_184646_p(float f) {
        this.field_70702_br = f;
    }

    @Override
    public void func_70659_e(float f) {
        super.func_70659_e(f);
        this.func_191989_p(f);
    }

    @Override
    public void func_70636_d() {
        super.func_70636_d();
        this.field_70170_p.func_217381_Z().func_76320_a("looting");
        if (!this.field_70170_p.field_72995_K && this.func_98052_bS() && this.func_70089_S() && !this.field_70729_aU && this.field_70170_p.func_82736_K().func_223586_b(GameRules.field_223599_b)) {
            List<ItemEntity> list = this.field_70170_p.func_217357_a(ItemEntity.class, this.func_174813_aQ().func_72314_b(1.0, 0.0, 1.0));
            for (ItemEntity itemEntity : list) {
                if (itemEntity.field_70128_L || itemEntity.func_92059_d().func_190926_b() || itemEntity.func_174874_s()) continue;
                this.func_175445_a(itemEntity);
            }
        }
        this.field_70170_p.func_217381_Z().func_76319_b();
    }

    protected void func_175445_a(ItemEntity itemEntity) {
        ItemStack itemStack = itemEntity.func_92059_d();
        boolean \u26032 = this.func_208003_a(itemStack, \u2603 = this.func_184582_a(\u2603 = MobEntity.func_184640_d(itemStack)), \u2603);
        if (\u26032 && this.func_175448_a(itemStack)) {
            double d = this.func_205712_c(\u2603);
            if (!\u2603.func_190926_b() && (double)(this.field_70146_Z.nextFloat() - 0.1f) < d) {
                this.func_199701_a_(\u2603);
            }
            this.func_184201_a(\u2603, itemStack);
            switch (\u2603.func_188453_a()) {
                case HAND: {
                    this.field_82174_bp[\u2603.func_188454_b()] = 2.0f;
                    break;
                }
                case ARMOR: {
                    this.field_184655_bs[\u2603.func_188454_b()] = 2.0f;
                }
            }
            this.field_82179_bU = true;
            this.func_71001_a(itemEntity, itemStack.func_190916_E());
            itemEntity.func_70106_y();
        }
    }

    protected boolean func_208003_a(ItemStack itemStack, ItemStack itemStack2, EquipmentSlotType equipmentSlotType) {
        boolean \u26032 = true;
        if (!itemStack2.func_190926_b()) {
            if (equipmentSlotType.func_188453_a() == EquipmentSlotType.Group.HAND) {
                if (itemStack.func_77973_b() instanceof SwordItem && !(itemStack2.func_77973_b() instanceof SwordItem)) {
                    \u26032 = true;
                } else if (itemStack.func_77973_b() instanceof SwordItem && itemStack2.func_77973_b() instanceof SwordItem) {
                    SwordItem swordItem = (SwordItem)itemStack.func_77973_b();
                    \u2603 = (SwordItem)itemStack2.func_77973_b();
                    \u26032 = swordItem.func_200894_d() == \u2603.func_200894_d() ? itemStack.func_77952_i() < itemStack2.func_77952_i() || itemStack.func_77942_o() && !itemStack2.func_77942_o() : swordItem.func_200894_d() > \u2603.func_200894_d();
                } else {
                    \u26032 = itemStack.func_77973_b() instanceof BowItem && itemStack2.func_77973_b() instanceof BowItem ? itemStack.func_77942_o() && !itemStack2.func_77942_o() : false;
                }
            } else if (itemStack.func_77973_b() instanceof ArmorItem && !(itemStack2.func_77973_b() instanceof ArmorItem)) {
                \u26032 = true;
            } else if (itemStack.func_77973_b() instanceof ArmorItem && itemStack2.func_77973_b() instanceof ArmorItem && !EnchantmentHelper.func_190938_b(itemStack2)) {
                ArmorItem armorItem = (ArmorItem)itemStack.func_77973_b();
                \u2603 = (ArmorItem)itemStack2.func_77973_b();
                \u26032 = armorItem.func_200881_e() == \u2603.func_200881_e() ? itemStack.func_77952_i() < itemStack2.func_77952_i() || itemStack.func_77942_o() && !itemStack2.func_77942_o() : armorItem.func_200881_e() > \u2603.func_200881_e();
            } else {
                \u26032 = false;
            }
        }
        return \u26032;
    }

    protected boolean func_175448_a(ItemStack itemStack) {
        return true;
    }

    public boolean func_213397_c(double d) {
        return true;
    }

    public boolean func_213392_I() {
        return false;
    }

    protected void func_70623_bb() {
        if (this.func_104002_bU() || this.func_213392_I()) {
            this.field_70708_bq = 0;
            return;
        }
        PlayerEntity playerEntity = this.field_70170_p.func_217362_a(this, -1.0);
        if (playerEntity != null) {
            double d = playerEntity.func_70068_e(this);
            if (d > 16384.0 && this.func_213397_c(d)) {
                this.func_70106_y();
            }
            if (this.field_70708_bq > 600 && this.field_70146_Z.nextInt(800) == 0 && d > 1024.0 && this.func_213397_c(d)) {
                this.func_70106_y();
            } else if (d < 1024.0) {
                this.field_70708_bq = 0;
            }
        }
    }

    @Override
    protected final void func_70626_be() {
        ++this.field_70708_bq;
        this.field_70170_p.func_217381_Z().func_76320_a("checkDespawn");
        this.func_70623_bb();
        this.field_70170_p.func_217381_Z().func_76319_b();
        this.field_70170_p.func_217381_Z().func_76320_a("sensing");
        this.field_70723_bA.func_75523_a();
        this.field_70170_p.func_217381_Z().func_76319_b();
        this.field_70170_p.func_217381_Z().func_76320_a("targetSelector");
        this.field_70715_bh.func_75774_a();
        this.field_70170_p.func_217381_Z().func_76319_b();
        this.field_70170_p.func_217381_Z().func_76320_a("goalSelector");
        this.field_70714_bg.func_75774_a();
        this.field_70170_p.func_217381_Z().func_76319_b();
        this.field_70170_p.func_217381_Z().func_76320_a("navigation");
        this.field_70699_by.func_75501_e();
        this.field_70170_p.func_217381_Z().func_76319_b();
        this.field_70170_p.func_217381_Z().func_76320_a("mob tick");
        this.func_70619_bc();
        this.field_70170_p.func_217381_Z().func_76319_b();
        this.field_70170_p.func_217381_Z().func_76320_a("controls");
        this.field_70170_p.func_217381_Z().func_76320_a("move");
        this.field_70765_h.func_75641_c();
        this.field_70170_p.func_217381_Z().func_219895_b("look");
        this.field_70749_g.func_75649_a();
        this.field_70170_p.func_217381_Z().func_219895_b("jump");
        this.field_70767_i.func_75661_b();
        this.field_70170_p.func_217381_Z().func_76319_b();
        this.field_70170_p.func_217381_Z().func_76319_b();
        this.func_213387_K();
    }

    protected void func_213387_K() {
        DebugPacketSender.func_218800_a(this.field_70170_p, this, this.field_70714_bg);
    }

    protected void func_70619_bc() {
    }

    public int func_70646_bf() {
        return 40;
    }

    public int func_184649_cE() {
        return 75;
    }

    public int func_213396_dB() {
        return 10;
    }

    public void func_70625_a(Entity entity, float f, float f2) {
        double \u26032;
        double d = entity.field_70165_t - this.field_70165_t;
        \u2603 = entity.field_70161_v - this.field_70161_v;
        if (entity instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            \u26032 = livingEntity.field_70163_u + (double)livingEntity.func_70047_e() - (this.field_70163_u + (double)this.func_70047_e());
        } else {
            \u26032 = (entity.func_174813_aQ().field_72338_b + entity.func_174813_aQ().field_72337_e) / 2.0 - (this.field_70163_u + (double)this.func_70047_e());
        }
        double d2 = MathHelper.func_76133_a(d * d + \u2603 * \u2603);
        float \u26033 = (float)(MathHelper.func_181159_b(\u2603, d) * 57.2957763671875) - 90.0f;
        float \u26034 = (float)(-(MathHelper.func_181159_b(\u26032, d2) * 57.2957763671875));
        this.field_70125_A = this.func_70663_b(this.field_70125_A, \u26034, f2);
        this.field_70177_z = this.func_70663_b(this.field_70177_z, \u26033, f);
    }

    private float func_70663_b(float f, float f2, float f3) {
        \u2603 = MathHelper.func_76142_g(f2 - f);
        if (\u2603 > f3) {
            \u2603 = f3;
        }
        if (\u2603 < -f3) {
            \u2603 = -f3;
        }
        return f + \u2603;
    }

    public static boolean func_223315_a(EntityType<? extends MobEntity> entityType, IWorld iWorld, SpawnReason spawnReason, BlockPos blockPos, Random random) {
        BlockPos blockPos2 = blockPos.func_177977_b();
        return spawnReason == SpawnReason.SPAWNER || iWorld.func_180495_p(blockPos2).func_215688_a(iWorld, blockPos2, entityType);
    }

    public boolean func_213380_a(IWorld iWorld, SpawnReason spawnReason) {
        return true;
    }

    public boolean func_205019_a(IWorldReader iWorldReader) {
        return !iWorldReader.func_72953_d(this.func_174813_aQ()) && iWorldReader.func_217346_i(this);
    }

    public int func_70641_bl() {
        return 4;
    }

    public boolean func_204209_c(int n) {
        return false;
    }

    @Override
    public int func_82143_as() {
        if (this.func_70638_az() == null) {
            return 3;
        }
        int n = (int)(this.func_110143_aJ() - this.func_110138_aP() * 0.33f);
        if ((n -= (3 - this.field_70170_p.func_175659_aa().func_151525_a()) * 4) < 0) {
            n = 0;
        }
        return n + 3;
    }

    @Override
    public Iterable<ItemStack> func_184214_aD() {
        return this.field_184656_bv;
    }

    @Override
    public Iterable<ItemStack> func_184193_aE() {
        return this.field_184657_bw;
    }

    @Override
    public ItemStack func_184582_a(EquipmentSlotType equipmentSlotType) {
        switch (equipmentSlotType.func_188453_a()) {
            case HAND: {
                return this.field_184656_bv.get(equipmentSlotType.func_188454_b());
            }
            case ARMOR: {
                return this.field_184657_bw.get(equipmentSlotType.func_188454_b());
            }
        }
        return ItemStack.field_190927_a;
    }

    @Override
    public void func_184201_a(EquipmentSlotType equipmentSlotType, ItemStack itemStack) {
        switch (equipmentSlotType.func_188453_a()) {
            case HAND: {
                this.field_184656_bv.set(equipmentSlotType.func_188454_b(), itemStack);
                break;
            }
            case ARMOR: {
                this.field_184657_bw.set(equipmentSlotType.func_188454_b(), itemStack);
            }
        }
    }

    @Override
    protected void func_213333_a(DamageSource damageSource, int n, boolean bl) {
        super.func_213333_a(damageSource, n, bl);
        for (EquipmentSlotType equipmentSlotType : EquipmentSlotType.values()) {
            ItemStack itemStack = this.func_184582_a(equipmentSlotType);
            float \u26032 = this.func_205712_c(equipmentSlotType);
            boolean bl2 = \u2603 = \u26032 > 1.0f;
            if (itemStack.func_190926_b() || EnchantmentHelper.func_190939_c(itemStack) || !bl && !\u2603 || !(this.field_70146_Z.nextFloat() - (float)n * 0.01f < \u26032)) continue;
            if (!\u2603 && itemStack.func_77984_f()) {
                itemStack.func_196085_b(itemStack.func_77958_k() - this.field_70146_Z.nextInt(1 + this.field_70146_Z.nextInt(Math.max(itemStack.func_77958_k() - 3, 1))));
            }
            this.func_199701_a_(itemStack);
        }
    }

    protected float func_205712_c(EquipmentSlotType equipmentSlotType2) {
        float \u26032;
        switch (equipmentSlotType2.func_188453_a()) {
            case HAND: {
                \u26032 = this.field_82174_bp[equipmentSlotType2.func_188454_b()];
                break;
            }
            case ARMOR: {
                EquipmentSlotType equipmentSlotType2;
                \u26032 = this.field_184655_bs[equipmentSlotType2.func_188454_b()];
                break;
            }
            default: {
                \u26032 = 0.0f;
            }
        }
        return \u26032;
    }

    protected void func_180481_a(DifficultyInstance difficultyInstance) {
        if (this.field_70146_Z.nextFloat() < 0.15f * difficultyInstance.func_180170_c()) {
            int n = this.field_70146_Z.nextInt(2);
            float f = \u2603 = this.field_70170_p.func_175659_aa() == Difficulty.HARD ? 0.1f : 0.25f;
            if (this.field_70146_Z.nextFloat() < 0.095f) {
                ++n;
            }
            if (this.field_70146_Z.nextFloat() < 0.095f) {
                ++n;
            }
            if (this.field_70146_Z.nextFloat() < 0.095f) {
                ++n;
            }
            boolean \u26032 = true;
            for (EquipmentSlotType equipmentSlotType : EquipmentSlotType.values()) {
                if (equipmentSlotType.func_188453_a() != EquipmentSlotType.Group.ARMOR) continue;
                ItemStack itemStack = this.func_184582_a(equipmentSlotType);
                if (!\u26032 && this.field_70146_Z.nextFloat() < \u2603) break;
                \u26032 = false;
                if (!itemStack.func_190926_b() || (\u2603 = MobEntity.func_184636_a(equipmentSlotType, n)) == null) continue;
                this.func_184201_a(equipmentSlotType, new ItemStack(\u2603));
            }
        }
    }

    public static EquipmentSlotType func_184640_d(ItemStack itemStack) {
        Item item = itemStack.func_77973_b();
        if (item == Blocks.field_196625_cS.func_199767_j() || item instanceof BlockItem && ((BlockItem)item).func_179223_d() instanceof AbstractSkullBlock) {
            return EquipmentSlotType.HEAD;
        }
        if (item instanceof ArmorItem) {
            return ((ArmorItem)item).func_185083_B_();
        }
        if (item == Items.field_185160_cR) {
            return EquipmentSlotType.CHEST;
        }
        if (item == Items.field_185159_cQ) {
            return EquipmentSlotType.OFFHAND;
        }
        return EquipmentSlotType.MAINHAND;
    }

    @Nullable
    public static Item func_184636_a(EquipmentSlotType equipmentSlotType, int n) {
        switch (equipmentSlotType) {
            case HEAD: {
                if (n == 0) {
                    return Items.field_151024_Q;
                }
                if (n == 1) {
                    return Items.field_151169_ag;
                }
                if (n == 2) {
                    return Items.field_151020_U;
                }
                if (n == 3) {
                    return Items.field_151028_Y;
                }
                if (n == 4) {
                    return Items.field_151161_ac;
                }
            }
            case CHEST: {
                if (n == 0) {
                    return Items.field_151027_R;
                }
                if (n == 1) {
                    return Items.field_151171_ah;
                }
                if (n == 2) {
                    return Items.field_151023_V;
                }
                if (n == 3) {
                    return Items.field_151030_Z;
                }
                if (n == 4) {
                    return Items.field_151163_ad;
                }
            }
            case LEGS: {
                if (n == 0) {
                    return Items.field_151026_S;
                }
                if (n == 1) {
                    return Items.field_151149_ai;
                }
                if (n == 2) {
                    return Items.field_151022_W;
                }
                if (n == 3) {
                    return Items.field_151165_aa;
                }
                if (n == 4) {
                    return Items.field_151173_ae;
                }
            }
            case FEET: {
                if (n == 0) {
                    return Items.field_151021_T;
                }
                if (n == 1) {
                    return Items.field_151151_aj;
                }
                if (n == 2) {
                    return Items.field_151029_X;
                }
                if (n == 3) {
                    return Items.field_151167_ab;
                }
                if (n != 4) break;
                return Items.field_151175_af;
            }
        }
        return null;
    }

    protected void func_180483_b(DifficultyInstance difficultyInstance) {
        float f = difficultyInstance.func_180170_c();
        if (!this.func_184614_ca().func_190926_b() && this.field_70146_Z.nextFloat() < 0.25f * f) {
            this.func_184201_a(EquipmentSlotType.MAINHAND, EnchantmentHelper.func_77504_a(this.field_70146_Z, this.func_184614_ca(), (int)(5.0f + f * (float)this.field_70146_Z.nextInt(18)), false));
        }
        for (EquipmentSlotType equipmentSlotType : EquipmentSlotType.values()) {
            if (equipmentSlotType.func_188453_a() != EquipmentSlotType.Group.ARMOR || (\u2603 = this.func_184582_a(equipmentSlotType)).func_190926_b() || !(this.field_70146_Z.nextFloat() < 0.5f * f)) continue;
            this.func_184201_a(equipmentSlotType, EnchantmentHelper.func_77504_a(this.field_70146_Z, \u2603, (int)(5.0f + f * (float)this.field_70146_Z.nextInt(18)), false));
        }
    }

    @Nullable
    public ILivingEntityData func_213386_a(IWorld iWorld, DifficultyInstance difficultyInstance, SpawnReason spawnReason, @Nullable ILivingEntityData iLivingEntityData, @Nullable CompoundNBT compoundNBT) {
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111121_a(new AttributeModifier("Random spawn bonus", this.field_70146_Z.nextGaussian() * 0.05, AttributeModifier.Operation.MULTIPLY_BASE));
        if (this.field_70146_Z.nextFloat() < 0.05f) {
            this.func_184641_n(true);
        } else {
            this.func_184641_n(false);
        }
        return iLivingEntityData;
    }

    public boolean func_82171_bF() {
        return false;
    }

    public void func_110163_bv() {
        this.field_82179_bU = true;
    }

    public void func_184642_a(EquipmentSlotType equipmentSlotType, float f) {
        switch (equipmentSlotType.func_188453_a()) {
            case HAND: {
                this.field_82174_bp[equipmentSlotType.func_188454_b()] = f;
                break;
            }
            case ARMOR: {
                this.field_184655_bs[equipmentSlotType.func_188454_b()] = f;
            }
        }
    }

    public boolean func_98052_bS() {
        return this.field_82172_bs;
    }

    public void func_98053_h(boolean bl) {
        this.field_82172_bs = bl;
    }

    @Override
    public boolean func_213365_e(ItemStack itemStack) {
        EquipmentSlotType equipmentSlotType = MobEntity.func_184640_d(itemStack);
        return this.func_184582_a(equipmentSlotType).func_190926_b() && this.func_98052_bS();
    }

    public boolean func_104002_bU() {
        return this.field_82179_bU;
    }

    @Override
    public final boolean func_184230_a(PlayerEntity playerEntity, Hand hand) {
        if (!this.func_70089_S()) {
            return false;
        }
        if (this.func_110166_bE() == playerEntity) {
            this.func_110160_i(true, !playerEntity.field_71075_bZ.field_75098_d);
            return true;
        }
        ItemStack itemStack = playerEntity.func_184586_b(hand);
        if (itemStack.func_77973_b() == Items.field_151058_ca && this.func_184652_a(playerEntity)) {
            this.func_110162_b(playerEntity, true);
            itemStack.func_190918_g(1);
            return true;
        }
        if (this.func_184645_a(playerEntity, hand)) {
            return true;
        }
        return super.func_184230_a(playerEntity, hand);
    }

    protected boolean func_184645_a(PlayerEntity playerEntity, Hand hand) {
        return false;
    }

    public boolean func_213383_dH() {
        return this.func_213389_a(new BlockPos(this));
    }

    public boolean func_213389_a(BlockPos blockPos) {
        if (this.field_213402_bL == -1.0f) {
            return true;
        }
        return this.field_213401_bK.func_177951_i(blockPos) < (double)(this.field_213402_bL * this.field_213402_bL);
    }

    public void func_213390_a(BlockPos blockPos, int n) {
        this.field_213401_bK = blockPos;
        this.field_213402_bL = n;
    }

    public BlockPos func_213384_dI() {
        return this.field_213401_bK;
    }

    public float func_213391_dJ() {
        return this.field_213402_bL;
    }

    public boolean func_213394_dL() {
        return this.field_213402_bL != -1.0f;
    }

    protected void func_110159_bB() {
        if (this.field_110170_bx != null) {
            this.func_110165_bF();
        }
        if (this.field_110168_bw == null) {
            return;
        }
        if (!this.func_70089_S() || !this.field_110168_bw.func_70089_S()) {
            this.func_110160_i(true, true);
        }
    }

    public void func_110160_i(boolean bl, boolean bl2) {
        if (this.field_110168_bw != null) {
            this.field_98038_p = false;
            if (!(this.field_110168_bw instanceof PlayerEntity)) {
                this.field_110168_bw.field_98038_p = false;
            }
            this.field_110168_bw = null;
            if (!this.field_70170_p.field_72995_K && bl2) {
                this.func_199703_a(Items.field_151058_ca);
            }
            if (!this.field_70170_p.field_72995_K && bl && this.field_70170_p instanceof ServerWorld) {
                ((ServerWorld)this.field_70170_p).func_72863_F().func_217218_b(this, new SMountEntityPacket(this, null));
            }
        }
    }

    public boolean func_184652_a(PlayerEntity playerEntity) {
        return !this.func_110167_bD() && !(this instanceof IMob);
    }

    public boolean func_110167_bD() {
        return this.field_110168_bw != null;
    }

    @Nullable
    public Entity func_110166_bE() {
        if (this.field_110168_bw == null && this.field_213400_bI != 0 && this.field_70170_p.field_72995_K) {
            this.field_110168_bw = this.field_70170_p.func_73045_a(this.field_213400_bI);
        }
        return this.field_110168_bw;
    }

    public void func_110162_b(Entity entity, boolean bl) {
        this.field_110168_bw = entity;
        this.field_98038_p = true;
        if (!(this.field_110168_bw instanceof PlayerEntity)) {
            this.field_110168_bw.field_98038_p = true;
        }
        if (!this.field_70170_p.field_72995_K && bl && this.field_70170_p instanceof ServerWorld) {
            ((ServerWorld)this.field_70170_p).func_72863_F().func_217218_b(this, new SMountEntityPacket(this, this.field_110168_bw));
        }
        if (this.func_184218_aH()) {
            this.func_184210_p();
        }
    }

    public void func_213381_d(int n) {
        this.field_213400_bI = n;
        this.func_110160_i(false, false);
    }

    @Override
    public boolean func_184205_a(Entity entity, boolean bl) {
        \u2603 = super.func_184205_a(entity, bl);
        if (\u2603 && this.func_110167_bD()) {
            this.func_110160_i(true, true);
        }
        return \u2603;
    }

    private void func_110165_bF() {
        if (this.field_110170_bx != null && this.field_70170_p instanceof ServerWorld) {
            if (this.field_110170_bx.func_186855_b("UUID")) {
                UUID uUID = this.field_110170_bx.func_186857_a("UUID");
                Entity \u26032 = ((ServerWorld)this.field_70170_p).func_217461_a(uUID);
                if (\u26032 != null) {
                    this.func_110162_b(\u26032, true);
                }
            } else if (this.field_110170_bx.func_150297_b("X", 99) && this.field_110170_bx.func_150297_b("Y", 99) && this.field_110170_bx.func_150297_b("Z", 99)) {
                BlockPos \u26033 = new BlockPos(this.field_110170_bx.func_74762_e("X"), this.field_110170_bx.func_74762_e("Y"), this.field_110170_bx.func_74762_e("Z"));
                this.func_110162_b(LeashKnotEntity.func_213855_a(this.field_70170_p, \u26033), true);
            } else {
                this.func_110160_i(false, true);
            }
            this.field_110170_bx = null;
        }
    }

    @Override
    public boolean func_174820_d(int n2, ItemStack itemStack2) {
        ItemStack itemStack2;
        int n2;
        EquipmentSlotType equipmentSlotType;
        if (n2 == 98) {
            equipmentSlotType = EquipmentSlotType.MAINHAND;
        } else if (n2 == 99) {
            equipmentSlotType = EquipmentSlotType.OFFHAND;
        } else if (n2 == 100 + EquipmentSlotType.HEAD.func_188454_b()) {
            equipmentSlotType = EquipmentSlotType.HEAD;
        } else if (n2 == 100 + EquipmentSlotType.CHEST.func_188454_b()) {
            equipmentSlotType = EquipmentSlotType.CHEST;
        } else if (n2 == 100 + EquipmentSlotType.LEGS.func_188454_b()) {
            equipmentSlotType = EquipmentSlotType.LEGS;
        } else if (n2 == 100 + EquipmentSlotType.FEET.func_188454_b()) {
            equipmentSlotType = EquipmentSlotType.FEET;
        } else {
            return false;
        }
        if (itemStack2.func_190926_b() || MobEntity.func_184648_b(equipmentSlotType, itemStack2) || equipmentSlotType == EquipmentSlotType.HEAD) {
            this.func_184201_a(equipmentSlotType, itemStack2);
            return true;
        }
        return false;
    }

    @Override
    public boolean func_184186_bw() {
        return this.func_82171_bF() && super.func_184186_bw();
    }

    public static boolean func_184648_b(EquipmentSlotType equipmentSlotType, ItemStack itemStack) {
        EquipmentSlotType equipmentSlotType2 = MobEntity.func_184640_d(itemStack);
        return equipmentSlotType2 == equipmentSlotType || equipmentSlotType2 == EquipmentSlotType.MAINHAND && equipmentSlotType == EquipmentSlotType.OFFHAND || equipmentSlotType2 == EquipmentSlotType.OFFHAND && equipmentSlotType == EquipmentSlotType.MAINHAND;
    }

    @Override
    public boolean func_70613_aW() {
        return super.func_70613_aW() && !this.func_175446_cd();
    }

    public void func_94061_f(boolean bl) {
        byte by = this.field_70180_af.func_187225_a(field_184654_a);
        this.field_70180_af.func_187227_b(field_184654_a, bl ? (byte)(by | 1) : (byte)(by & 0xFFFFFFFE));
    }

    public void func_184641_n(boolean bl) {
        byte by = this.field_70180_af.func_187225_a(field_184654_a);
        this.field_70180_af.func_187227_b(field_184654_a, bl ? (byte)(by | 2) : (byte)(by & 0xFFFFFFFD));
    }

    public void func_213395_q(boolean bl) {
        byte by = this.field_70180_af.func_187225_a(field_184654_a);
        this.field_70180_af.func_187227_b(field_184654_a, bl ? (byte)(by | 4) : (byte)(by & 0xFFFFFFFB));
    }

    public boolean func_175446_cd() {
        return (this.field_70180_af.func_187225_a(field_184654_a) & 1) != 0;
    }

    public boolean func_184638_cS() {
        return (this.field_70180_af.func_187225_a(field_184654_a) & 2) != 0;
    }

    public boolean func_213398_dR() {
        return (this.field_70180_af.func_187225_a(field_184654_a) & 4) != 0;
    }

    @Override
    public HandSide func_184591_cq() {
        return this.func_184638_cS() ? HandSide.LEFT : HandSide.RIGHT;
    }

    @Override
    public boolean func_213336_c(LivingEntity livingEntity) {
        if (livingEntity.func_200600_R() == EntityType.field_200729_aH && ((PlayerEntity)livingEntity).field_71075_bZ.field_75102_a) {
            return false;
        }
        return super.func_213336_c(livingEntity);
    }

    @Override
    public boolean func_70652_k(Entity entity2) {
        boolean bl;
        float f = (float)this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111126_e();
        \u2603 = (float)this.func_110148_a(SharedMonsterAttributes.field_221120_g).func_111126_e();
        if (entity2 instanceof LivingEntity) {
            f += EnchantmentHelper.func_152377_a(this.func_184614_ca(), ((LivingEntity)entity2).func_70668_bt());
            \u2603 += (float)EnchantmentHelper.func_77501_a(this);
        }
        if ((\u2603 = EnchantmentHelper.func_90036_a(this)) > 0) {
            entity2.func_70015_d(\u2603 * 4);
        }
        if (bl = entity2.func_70097_a(DamageSource.func_76358_a(this), f)) {
            Entity entity2;
            if (\u2603 > 0.0f && entity2 instanceof LivingEntity) {
                ((LivingEntity)entity2).func_70653_a(this, \u2603 * 0.5f, MathHelper.func_76126_a(this.field_70177_z * ((float)Math.PI / 180)), -MathHelper.func_76134_b(this.field_70177_z * ((float)Math.PI / 180)));
                this.func_213317_d(this.func_213322_ci().func_216372_d(0.6, 1.0, 0.6));
            }
            if (entity2 instanceof PlayerEntity) {
                PlayerEntity playerEntity = (PlayerEntity)entity2;
                ItemStack \u26032 = this.func_184614_ca();
                ItemStack itemStack = \u2603 = playerEntity.func_184587_cr() ? playerEntity.func_184607_cu() : ItemStack.field_190927_a;
                if (!\u26032.func_190926_b() && !\u2603.func_190926_b() && \u26032.func_77973_b() instanceof AxeItem && \u2603.func_77973_b() == Items.field_185159_cQ) {
                    float f2 = 0.25f + (float)EnchantmentHelper.func_185293_e(this) * 0.05f;
                    if (this.field_70146_Z.nextFloat() < f2) {
                        playerEntity.func_184811_cZ().func_185145_a(Items.field_185159_cQ, 100);
                        this.field_70170_p.func_72960_a(playerEntity, (byte)30);
                    }
                }
            }
            this.func_174815_a(this, entity2);
        }
        return bl;
    }

    protected boolean func_204609_dp() {
        if (this.field_70170_p.func_72935_r() && !this.field_70170_p.field_72995_K) {
            float f = this.func_70013_c();
            BlockPos blockPos = \u2603 = this.func_184187_bx() instanceof BoatEntity ? new BlockPos(this.field_70165_t, Math.round(this.field_70163_u), this.field_70161_v).func_177984_a() : new BlockPos(this.field_70165_t, Math.round(this.field_70163_u), this.field_70161_v);
            if (f > 0.5f && this.field_70146_Z.nextFloat() * 30.0f < (f - 0.4f) * 2.0f && this.field_70170_p.func_217337_f(\u2603)) {
                return true;
            }
        }
        return false;
    }

    @Override
    protected void func_180466_bG(Tag<Fluid> tag) {
        if (this.func_70661_as().func_212238_t()) {
            super.func_180466_bG(tag);
        } else {
            this.func_213317_d(this.func_213322_ci().func_72441_c(0.0, 0.3, 0.0));
        }
    }

    public boolean func_213382_a(Item item) {
        return this.func_184614_ca().func_77973_b() == item || this.func_184592_cb().func_77973_b() == item;
    }
}

