/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.data;

import com.google.common.collect.Maps;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.BufferedWriter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DirectoryCache;
import net.minecraft.data.IDataProvider;
import net.minecraft.tags.Tag;
import net.minecraft.tags.TagCollection;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class TagsProvider<T>
implements IDataProvider {
    private static final Logger field_200436_d = LogManager.getLogger();
    private static final Gson field_200437_e = new GsonBuilder().setPrettyPrinting().create();
    protected final DataGenerator field_200433_a;
    protected final Registry<T> field_200435_c;
    protected final Map<Tag<T>, Tag.Builder<T>> field_200434_b = Maps.newLinkedHashMap();

    protected TagsProvider(DataGenerator dataGenerator, Registry<T> registry) {
        this.field_200433_a = dataGenerator;
        this.field_200435_c = registry;
    }

    protected abstract void func_200432_c();

    @Override
    public void func_200398_a(DirectoryCache directoryCache) {
        this.field_200434_b.clear();
        this.func_200432_c();
        TagCollection tagCollection = new TagCollection(resourceLocation -> Optional.empty(), "", false, "generated");
        Map \u26032 = this.field_200434_b.entrySet().stream().collect(Collectors.toMap(entry -> ((Tag)entry.getKey()).func_199886_b(), Map.Entry::getValue));
        tagCollection.func_219779_a(\u26032);
        tagCollection.func_200039_c().forEach((resourceLocation, tag) -> {
            JsonObject jsonObject = tag.func_200571_a(this.field_200435_c::func_177774_c);
            Path \u26032 = this.func_200431_a((ResourceLocation)resourceLocation);
            try {
                DirectoryCache directoryCache2;
                String string = field_200437_e.toJson((JsonElement)jsonObject);
                \u2603 = field_208307_a.hashUnencodedChars((CharSequence)string).toString();
                if (!Objects.equals(directoryCache.func_208323_a(\u26032), \u2603) || !Files.exists(\u26032, new LinkOption[0])) {
                    Files.createDirectories(\u26032.getParent(), new FileAttribute[0]);
                    try (BufferedWriter bufferedWriter = Files.newBufferedWriter(\u26032, new OpenOption[0]);){
                        bufferedWriter.write(string);
                    }
                }
                directoryCache.func_208316_a(\u26032, \u2603);
            }
            catch (IOException iOException) {
                field_200436_d.error("Couldn't save tags to {}", (Object)\u26032, (Object)iOException);
            }
        });
        this.func_200429_a(tagCollection);
    }

    protected abstract void func_200429_a(TagCollection<T> var1);

    protected abstract Path func_200431_a(ResourceLocation var1);

    protected Tag.Builder<T> func_200426_a(Tag<T> tag2) {
        return this.field_200434_b.computeIfAbsent(tag2, tag -> Tag.Builder.func_200047_a());
    }
}

