/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.command.arguments;

import com.google.common.collect.Lists;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.concurrent.CompletableFuture;
import net.minecraft.command.CommandSource;
import net.minecraft.command.ISuggestionProvider;
import net.minecraft.scoreboard.ScoreCriteria;
import net.minecraft.stats.Stat;
import net.minecraft.stats.StatType;
import net.minecraft.util.registry.Registry;
import net.minecraft.util.text.TranslationTextComponent;

public class ObjectiveCriteriaArgument
implements ArgumentType<ScoreCriteria> {
    private static final Collection<String> field_201318_b = Arrays.asList("foo", "foo.bar.baz", "minecraft:foo");
    public static final DynamicCommandExceptionType field_197164_a = new DynamicCommandExceptionType(object -> new TranslationTextComponent("argument.criteria.invalid", object));

    private ObjectiveCriteriaArgument() {
    }

    public static ObjectiveCriteriaArgument func_197162_a() {
        return new ObjectiveCriteriaArgument();
    }

    public static ScoreCriteria func_197161_a(CommandContext<CommandSource> commandContext, String string) {
        return (ScoreCriteria)commandContext.getArgument(string, ScoreCriteria.class);
    }

    public ScoreCriteria parse(StringReader stringReader) throws CommandSyntaxException {
        int n = stringReader.getCursor();
        while (stringReader.canRead() && stringReader.peek() != ' ') {
            stringReader.skip();
        }
        String \u26032 = stringReader.getString().substring(n, stringReader.getCursor());
        return ScoreCriteria.func_216390_a(\u26032).orElseThrow(() -> {
            stringReader.setCursor(n);
            return field_197164_a.create((Object)\u26032);
        });
    }

    public <S> CompletableFuture<Suggestions> listSuggestions(CommandContext<S> commandContext, SuggestionsBuilder suggestionsBuilder) {
        ArrayList arrayList = Lists.newArrayList(ScoreCriteria.field_96643_a.keySet());
        for (StatType statType : Registry.field_212634_w) {
            for (Object t : statType.func_199080_a()) {
                String string = this.func_199815_a(statType, t);
                arrayList.add(string);
            }
        }
        return ISuggestionProvider.func_197005_b(arrayList, suggestionsBuilder);
    }

    public <T> String func_199815_a(StatType<T> statType, Object object) {
        return Stat.func_197918_a(statType, object);
    }

    public Collection<String> getExamples() {
        return field_201318_b;
    }

    public /* synthetic */ Object parse(StringReader stringReader) throws CommandSyntaxException {
        return this.parse(stringReader);
    }
}

