/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.util;

import com.google.common.collect.Maps;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import org.lwjgl.glfw.GLFW;
import org.lwjgl.glfw.GLFWCharModsCallbackI;
import org.lwjgl.glfw.GLFWCursorPosCallbackI;
import org.lwjgl.glfw.GLFWKeyCallbackI;
import org.lwjgl.glfw.GLFWMouseButtonCallbackI;
import org.lwjgl.glfw.GLFWScrollCallbackI;

public class InputMappings {
    @Nullable
    private static final MethodHandle field_224792_b;
    private static final int field_224793_c;
    public static final Input field_197958_a;

    public static Input func_197954_a(int n, int n2) {
        if (n == -1) {
            return Type.SCANCODE.func_197944_a(n2);
        }
        return Type.KEYSYM.func_197944_a(n);
    }

    public static Input func_197955_a(String string2) {
        String string2;
        if (Input.field_199875_d.containsKey(string2)) {
            return (Input)Input.field_199875_d.get(string2);
        }
        for (Type type : Type.values()) {
            if (!string2.startsWith(type.field_197952_f)) continue;
            String string3 = string2.substring(type.field_197952_f.length() + 1);
            return type.func_197944_a(Integer.parseInt(string3));
        }
        throw new IllegalArgumentException("Unknown key name: " + string2);
    }

    public static boolean func_216506_a(long l, int n) {
        return GLFW.glfwGetKey((long)l, (int)n) == 1;
    }

    public static void func_216505_a(long l, GLFWKeyCallbackI gLFWKeyCallbackI, GLFWCharModsCallbackI gLFWCharModsCallbackI) {
        GLFW.glfwSetKeyCallback((long)l, (GLFWKeyCallbackI)gLFWKeyCallbackI);
        GLFW.glfwSetCharModsCallback((long)l, (GLFWCharModsCallbackI)gLFWCharModsCallbackI);
    }

    public static void func_216503_a(long l, GLFWCursorPosCallbackI gLFWCursorPosCallbackI, GLFWMouseButtonCallbackI gLFWMouseButtonCallbackI, GLFWScrollCallbackI gLFWScrollCallbackI) {
        GLFW.glfwSetCursorPosCallback((long)l, (GLFWCursorPosCallbackI)gLFWCursorPosCallbackI);
        GLFW.glfwSetMouseButtonCallback((long)l, (GLFWMouseButtonCallbackI)gLFWMouseButtonCallbackI);
        GLFW.glfwSetScrollCallback((long)l, (GLFWScrollCallbackI)gLFWScrollCallbackI);
    }

    public static void func_216504_a(long l, int n, double d, double d2) {
        GLFW.glfwSetCursorPos((long)l, (double)d, (double)d2);
        GLFW.glfwSetInputMode((long)l, (int)208897, (int)n);
    }

    public static boolean func_224790_a() {
        try {
            return field_224792_b != null && field_224792_b.invokeExact();
        }
        catch (Throwable throwable) {
            throw new RuntimeException(throwable);
        }
    }

    public static void func_224791_a(long l, boolean bl) {
        if (InputMappings.func_224790_a()) {
            GLFW.glfwSetInputMode((long)l, (int)field_224793_c, (int)(bl ? 1 : 0));
        }
    }

    @Nullable
    public static String func_216507_a(int n) {
        return GLFW.glfwGetKeyName((int)n, (int)-1);
    }

    @Nullable
    public static String func_216502_b(int n) {
        return GLFW.glfwGetKeyName((int)-1, (int)n);
    }

    static {
        MethodHandles.Lookup lookup = MethodHandles.lookup();
        MethodType \u26032 = MethodType.methodType(Boolean.TYPE);
        MethodHandle \u26033 = null;
        int \u26034 = 0;
        try {
            \u26033 = lookup.findStatic(GLFW.class, "glfwRawMouseMotionSupported", \u26032);
            MethodHandle methodHandle = lookup.findStaticGetter(GLFW.class, "GLFW_RAW_MOUSE_MOTION", Integer.TYPE);
            \u26034 = methodHandle.invokeExact();
        }
        catch (NoSuchFieldException | NoSuchMethodException methodHandle) {
        }
        catch (Throwable throwable) {
            throw new RuntimeException(throwable);
        }
        field_224792_b = \u26033;
        field_224793_c = \u26034;
        field_197958_a = Type.KEYSYM.func_197944_a(-1);
    }

    public static final class Input {
        private final String field_197939_a;
        private final Type field_197940_b;
        private final int field_197941_c;
        private static final Map<String, Input> field_199875_d = Maps.newHashMap();

        private Input(String string, Type type, int n) {
            this.field_197939_a = string;
            this.field_197940_b = type;
            this.field_197941_c = n;
            field_199875_d.put(string, this);
        }

        public Type func_197938_b() {
            return this.field_197940_b;
        }

        public int func_197937_c() {
            return this.field_197941_c;
        }

        public String func_197935_d() {
            return this.field_197939_a;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null || this.getClass() != object.getClass()) {
                return false;
            }
            Input input = (Input)object;
            return this.field_197941_c == input.field_197941_c && this.field_197940_b == input.field_197940_b;
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.field_197940_b, this.field_197941_c});
        }

        public String toString() {
            return this.field_197939_a;
        }
    }

    public static enum Type {
        KEYSYM("key.keyboard"),
        SCANCODE("scancode"),
        MOUSE("key.mouse");

        private static final String[] field_197950_d;
        private final Int2ObjectMap<Input> field_197951_e = new Int2ObjectOpenHashMap();
        private final String field_197952_f;

        private static void func_197943_a(Type type, String string, int n) {
            Input input = new Input(string, type, n);
            type.field_197951_e.put(n, (Object)input);
        }

        private Type(String string2) {
            this.field_197952_f = string2;
        }

        public Input func_197944_a(int n) {
            if (this.field_197951_e.containsKey(n)) {
                return (Input)this.field_197951_e.get(n);
            }
            String string = this == MOUSE ? (n <= 2 ? "." + field_197950_d[n] : "." + (n + 1)) : "." + n;
            Input \u26032 = new Input(this.field_197952_f + string, this, n);
            this.field_197951_e.put(n, (Object)\u26032);
            return \u26032;
        }

        public String func_216500_a() {
            return this.field_197952_f;
        }

        static {
            Type.func_197943_a(KEYSYM, "key.keyboard.unknown", -1);
            Type.func_197943_a(MOUSE, "key.mouse.left", 0);
            Type.func_197943_a(MOUSE, "key.mouse.right", 1);
            Type.func_197943_a(MOUSE, "key.mouse.middle", 2);
            Type.func_197943_a(MOUSE, "key.mouse.4", 3);
            Type.func_197943_a(MOUSE, "key.mouse.5", 4);
            Type.func_197943_a(MOUSE, "key.mouse.6", 5);
            Type.func_197943_a(MOUSE, "key.mouse.7", 6);
            Type.func_197943_a(MOUSE, "key.mouse.8", 7);
            Type.func_197943_a(KEYSYM, "key.keyboard.0", 48);
            Type.func_197943_a(KEYSYM, "key.keyboard.1", 49);
            Type.func_197943_a(KEYSYM, "key.keyboard.2", 50);
            Type.func_197943_a(KEYSYM, "key.keyboard.3", 51);
            Type.func_197943_a(KEYSYM, "key.keyboard.4", 52);
            Type.func_197943_a(KEYSYM, "key.keyboard.5", 53);
            Type.func_197943_a(KEYSYM, "key.keyboard.6", 54);
            Type.func_197943_a(KEYSYM, "key.keyboard.7", 55);
            Type.func_197943_a(KEYSYM, "key.keyboard.8", 56);
            Type.func_197943_a(KEYSYM, "key.keyboard.9", 57);
            Type.func_197943_a(KEYSYM, "key.keyboard.a", 65);
            Type.func_197943_a(KEYSYM, "key.keyboard.b", 66);
            Type.func_197943_a(KEYSYM, "key.keyboard.c", 67);
            Type.func_197943_a(KEYSYM, "key.keyboard.d", 68);
            Type.func_197943_a(KEYSYM, "key.keyboard.e", 69);
            Type.func_197943_a(KEYSYM, "key.keyboard.f", 70);
            Type.func_197943_a(KEYSYM, "key.keyboard.g", 71);
            Type.func_197943_a(KEYSYM, "key.keyboard.h", 72);
            Type.func_197943_a(KEYSYM, "key.keyboard.i", 73);
            Type.func_197943_a(KEYSYM, "key.keyboard.j", 74);
            Type.func_197943_a(KEYSYM, "key.keyboard.k", 75);
            Type.func_197943_a(KEYSYM, "key.keyboard.l", 76);
            Type.func_197943_a(KEYSYM, "key.keyboard.m", 77);
            Type.func_197943_a(KEYSYM, "key.keyboard.n", 78);
            Type.func_197943_a(KEYSYM, "key.keyboard.o", 79);
            Type.func_197943_a(KEYSYM, "key.keyboard.p", 80);
            Type.func_197943_a(KEYSYM, "key.keyboard.q", 81);
            Type.func_197943_a(KEYSYM, "key.keyboard.r", 82);
            Type.func_197943_a(KEYSYM, "key.keyboard.s", 83);
            Type.func_197943_a(KEYSYM, "key.keyboard.t", 84);
            Type.func_197943_a(KEYSYM, "key.keyboard.u", 85);
            Type.func_197943_a(KEYSYM, "key.keyboard.v", 86);
            Type.func_197943_a(KEYSYM, "key.keyboard.w", 87);
            Type.func_197943_a(KEYSYM, "key.keyboard.x", 88);
            Type.func_197943_a(KEYSYM, "key.keyboard.y", 89);
            Type.func_197943_a(KEYSYM, "key.keyboard.z", 90);
            Type.func_197943_a(KEYSYM, "key.keyboard.f1", 290);
            Type.func_197943_a(KEYSYM, "key.keyboard.f2", 291);
            Type.func_197943_a(KEYSYM, "key.keyboard.f3", 292);
            Type.func_197943_a(KEYSYM, "key.keyboard.f4", 293);
            Type.func_197943_a(KEYSYM, "key.keyboard.f5", 294);
            Type.func_197943_a(KEYSYM, "key.keyboard.f6", 295);
            Type.func_197943_a(KEYSYM, "key.keyboard.f7", 296);
            Type.func_197943_a(KEYSYM, "key.keyboard.f8", 297);
            Type.func_197943_a(KEYSYM, "key.keyboard.f9", 298);
            Type.func_197943_a(KEYSYM, "key.keyboard.f10", 299);
            Type.func_197943_a(KEYSYM, "key.keyboard.f11", 300);
            Type.func_197943_a(KEYSYM, "key.keyboard.f12", 301);
            Type.func_197943_a(KEYSYM, "key.keyboard.f13", 302);
            Type.func_197943_a(KEYSYM, "key.keyboard.f14", 303);
            Type.func_197943_a(KEYSYM, "key.keyboard.f15", 304);
            Type.func_197943_a(KEYSYM, "key.keyboard.f16", 305);
            Type.func_197943_a(KEYSYM, "key.keyboard.f17", 306);
            Type.func_197943_a(KEYSYM, "key.keyboard.f18", 307);
            Type.func_197943_a(KEYSYM, "key.keyboard.f19", 308);
            Type.func_197943_a(KEYSYM, "key.keyboard.f20", 309);
            Type.func_197943_a(KEYSYM, "key.keyboard.f21", 310);
            Type.func_197943_a(KEYSYM, "key.keyboard.f22", 311);
            Type.func_197943_a(KEYSYM, "key.keyboard.f23", 312);
            Type.func_197943_a(KEYSYM, "key.keyboard.f24", 313);
            Type.func_197943_a(KEYSYM, "key.keyboard.f25", 314);
            Type.func_197943_a(KEYSYM, "key.keyboard.num.lock", 282);
            Type.func_197943_a(KEYSYM, "key.keyboard.keypad.0", 320);
            Type.func_197943_a(KEYSYM, "key.keyboard.keypad.1", 321);
            Type.func_197943_a(KEYSYM, "key.keyboard.keypad.2", 322);
            Type.func_197943_a(KEYSYM, "key.keyboard.keypad.3", 323);
            Type.func_197943_a(KEYSYM, "key.keyboard.keypad.4", 324);
            Type.func_197943_a(KEYSYM, "key.keyboard.keypad.5", 325);
            Type.func_197943_a(KEYSYM, "key.keyboard.keypad.6", 326);
            Type.func_197943_a(KEYSYM, "key.keyboard.keypad.7", 327);
            Type.func_197943_a(KEYSYM, "key.keyboard.keypad.8", 328);
            Type.func_197943_a(KEYSYM, "key.keyboard.keypad.9", 329);
            Type.func_197943_a(KEYSYM, "key.keyboard.keypad.add", 334);
            Type.func_197943_a(KEYSYM, "key.keyboard.keypad.decimal", 330);
            Type.func_197943_a(KEYSYM, "key.keyboard.keypad.enter", 335);
            Type.func_197943_a(KEYSYM, "key.keyboard.keypad.equal", 336);
            Type.func_197943_a(KEYSYM, "key.keyboard.keypad.multiply", 332);
            Type.func_197943_a(KEYSYM, "key.keyboard.keypad.divide", 331);
            Type.func_197943_a(KEYSYM, "key.keyboard.keypad.subtract", 333);
            Type.func_197943_a(KEYSYM, "key.keyboard.down", 264);
            Type.func_197943_a(KEYSYM, "key.keyboard.left", 263);
            Type.func_197943_a(KEYSYM, "key.keyboard.right", 262);
            Type.func_197943_a(KEYSYM, "key.keyboard.up", 265);
            Type.func_197943_a(KEYSYM, "key.keyboard.apostrophe", 39);
            Type.func_197943_a(KEYSYM, "key.keyboard.backslash", 92);
            Type.func_197943_a(KEYSYM, "key.keyboard.comma", 44);
            Type.func_197943_a(KEYSYM, "key.keyboard.equal", 61);
            Type.func_197943_a(KEYSYM, "key.keyboard.grave.accent", 96);
            Type.func_197943_a(KEYSYM, "key.keyboard.left.bracket", 91);
            Type.func_197943_a(KEYSYM, "key.keyboard.minus", 45);
            Type.func_197943_a(KEYSYM, "key.keyboard.period", 46);
            Type.func_197943_a(KEYSYM, "key.keyboard.right.bracket", 93);
            Type.func_197943_a(KEYSYM, "key.keyboard.semicolon", 59);
            Type.func_197943_a(KEYSYM, "key.keyboard.slash", 47);
            Type.func_197943_a(KEYSYM, "key.keyboard.space", 32);
            Type.func_197943_a(KEYSYM, "key.keyboard.tab", 258);
            Type.func_197943_a(KEYSYM, "key.keyboard.left.alt", 342);
            Type.func_197943_a(KEYSYM, "key.keyboard.left.control", 341);
            Type.func_197943_a(KEYSYM, "key.keyboard.left.shift", 340);
            Type.func_197943_a(KEYSYM, "key.keyboard.left.win", 343);
            Type.func_197943_a(KEYSYM, "key.keyboard.right.alt", 346);
            Type.func_197943_a(KEYSYM, "key.keyboard.right.control", 345);
            Type.func_197943_a(KEYSYM, "key.keyboard.right.shift", 344);
            Type.func_197943_a(KEYSYM, "key.keyboard.right.win", 347);
            Type.func_197943_a(KEYSYM, "key.keyboard.enter", 257);
            Type.func_197943_a(KEYSYM, "key.keyboard.escape", 256);
            Type.func_197943_a(KEYSYM, "key.keyboard.backspace", 259);
            Type.func_197943_a(KEYSYM, "key.keyboard.delete", 261);
            Type.func_197943_a(KEYSYM, "key.keyboard.end", 269);
            Type.func_197943_a(KEYSYM, "key.keyboard.home", 268);
            Type.func_197943_a(KEYSYM, "key.keyboard.insert", 260);
            Type.func_197943_a(KEYSYM, "key.keyboard.page.down", 267);
            Type.func_197943_a(KEYSYM, "key.keyboard.page.up", 266);
            Type.func_197943_a(KEYSYM, "key.keyboard.caps.lock", 280);
            Type.func_197943_a(KEYSYM, "key.keyboard.pause", 284);
            Type.func_197943_a(KEYSYM, "key.keyboard.scroll.lock", 281);
            Type.func_197943_a(KEYSYM, "key.keyboard.menu", 348);
            Type.func_197943_a(KEYSYM, "key.keyboard.print.screen", 283);
            Type.func_197943_a(KEYSYM, "key.keyboard.world.1", 161);
            Type.func_197943_a(KEYSYM, "key.keyboard.world.2", 162);
            field_197950_d = new String[]{"left", "middle", "right"};
        }
    }
}

