/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.util;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import net.minecraft.client.gui.recipebook.RecipeList;
import net.minecraft.client.util.RecipeBookCategories;
import net.minecraft.inventory.container.BlastFurnaceContainer;
import net.minecraft.inventory.container.FurnaceContainer;
import net.minecraft.inventory.container.PlayerContainer;
import net.minecraft.inventory.container.RecipeBookContainer;
import net.minecraft.inventory.container.SmokerContainer;
import net.minecraft.inventory.container.WorkbenchContainer;
import net.minecraft.item.BlockItem;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.item.crafting.RecipeBook;
import net.minecraft.item.crafting.RecipeManager;

public class ClientRecipeBook
extends RecipeBook {
    private final RecipeManager field_199645_e;
    private final Map<RecipeBookCategories, List<RecipeList>> field_197931_e = Maps.newHashMap();
    private final List<RecipeList> field_197932_f = Lists.newArrayList();

    public ClientRecipeBook(RecipeManager recipeManager) {
        this.field_199645_e = recipeManager;
    }

    public void func_199644_c() {
        this.field_197932_f.clear();
        this.field_197931_e.clear();
        HashBasedTable hashBasedTable = HashBasedTable.create();
        for (IRecipe<?> iRecipe : this.field_199645_e.func_199510_b()) {
            RecipeList \u26033;
            if (iRecipe.func_192399_d()) continue;
            RecipeBookCategories recipeBookCategories = ClientRecipeBook.func_202887_g(iRecipe);
            String \u26032 = iRecipe.func_193358_e();
            if (\u26032.isEmpty()) {
                \u26033 = this.func_202889_b(recipeBookCategories);
            } else {
                \u26033 = (RecipeList)hashBasedTable.get((Object)recipeBookCategories, (Object)\u26032);
                if (\u26033 == null) {
                    \u26033 = this.func_202889_b(recipeBookCategories);
                    hashBasedTable.put((Object)recipeBookCategories, (Object)\u26032, (Object)\u26033);
                }
            }
            \u26033.func_192709_a(iRecipe);
        }
    }

    private RecipeList func_202889_b(RecipeBookCategories recipeBookCategories2) {
        RecipeList recipeList = new RecipeList();
        this.field_197932_f.add(recipeList);
        this.field_197931_e.computeIfAbsent(recipeBookCategories2, recipeBookCategories -> Lists.newArrayList()).add(recipeList);
        if (recipeBookCategories2 == RecipeBookCategories.FURNACE_BLOCKS || recipeBookCategories2 == RecipeBookCategories.FURNACE_FOOD || recipeBookCategories2 == RecipeBookCategories.FURNACE_MISC) {
            this.func_216767_a(RecipeBookCategories.FURNACE_SEARCH, recipeList);
        } else if (recipeBookCategories2 == RecipeBookCategories.BLAST_FURNACE_BLOCKS || recipeBookCategories2 == RecipeBookCategories.BLAST_FURNACE_MISC) {
            this.func_216767_a(RecipeBookCategories.BLAST_FURNACE_SEARCH, recipeList);
        } else if (recipeBookCategories2 == RecipeBookCategories.SMOKER_FOOD) {
            this.func_216767_a(RecipeBookCategories.SMOKER_SEARCH, recipeList);
        } else if (recipeBookCategories2 == RecipeBookCategories.STONECUTTER) {
            this.func_216767_a(RecipeBookCategories.STONECUTTER, recipeList);
        } else if (recipeBookCategories2 == RecipeBookCategories.CAMPFIRE) {
            this.func_216767_a(RecipeBookCategories.CAMPFIRE, recipeList);
        } else {
            this.func_216767_a(RecipeBookCategories.SEARCH, recipeList);
        }
        return recipeList;
    }

    private void func_216767_a(RecipeBookCategories recipeBookCategories2, RecipeList recipeList) {
        this.field_197931_e.computeIfAbsent(recipeBookCategories2, recipeBookCategories -> Lists.newArrayList()).add(recipeList);
    }

    private static RecipeBookCategories func_202887_g(IRecipe<?> iRecipe) {
        IRecipeType<?> iRecipeType = iRecipe.func_222127_g();
        if (iRecipeType == IRecipeType.field_222150_b) {
            if (iRecipe.func_77571_b().func_77973_b().func_219971_r()) {
                return RecipeBookCategories.FURNACE_FOOD;
            }
            if (iRecipe.func_77571_b().func_77973_b() instanceof BlockItem) {
                return RecipeBookCategories.FURNACE_BLOCKS;
            }
            return RecipeBookCategories.FURNACE_MISC;
        }
        if (iRecipeType == IRecipeType.field_222151_c) {
            if (iRecipe.func_77571_b().func_77973_b() instanceof BlockItem) {
                return RecipeBookCategories.BLAST_FURNACE_BLOCKS;
            }
            return RecipeBookCategories.BLAST_FURNACE_MISC;
        }
        if (iRecipeType == IRecipeType.field_222152_d) {
            return RecipeBookCategories.SMOKER_FOOD;
        }
        if (iRecipeType == IRecipeType.field_222154_f) {
            return RecipeBookCategories.STONECUTTER;
        }
        if (iRecipeType == IRecipeType.field_222153_e) {
            return RecipeBookCategories.CAMPFIRE;
        }
        ItemStack \u26032 = iRecipe.func_77571_b();
        ItemGroup \u26033 = \u26032.func_77973_b().func_77640_w();
        if (\u26033 == ItemGroup.field_78030_b) {
            return RecipeBookCategories.BUILDING_BLOCKS;
        }
        if (\u26033 == ItemGroup.field_78040_i || \u26033 == ItemGroup.field_78037_j) {
            return RecipeBookCategories.EQUIPMENT;
        }
        if (\u26033 == ItemGroup.field_78028_d) {
            return RecipeBookCategories.REDSTONE;
        }
        return RecipeBookCategories.MISC;
    }

    public static List<RecipeBookCategories> func_216769_b(RecipeBookContainer<?> recipeBookContainer) {
        if (recipeBookContainer instanceof WorkbenchContainer || recipeBookContainer instanceof PlayerContainer) {
            return Lists.newArrayList((Object[])new RecipeBookCategories[]{RecipeBookCategories.SEARCH, RecipeBookCategories.EQUIPMENT, RecipeBookCategories.BUILDING_BLOCKS, RecipeBookCategories.MISC, RecipeBookCategories.REDSTONE});
        }
        if (recipeBookContainer instanceof FurnaceContainer) {
            return Lists.newArrayList((Object[])new RecipeBookCategories[]{RecipeBookCategories.FURNACE_SEARCH, RecipeBookCategories.FURNACE_FOOD, RecipeBookCategories.FURNACE_BLOCKS, RecipeBookCategories.FURNACE_MISC});
        }
        if (recipeBookContainer instanceof BlastFurnaceContainer) {
            return Lists.newArrayList((Object[])new RecipeBookCategories[]{RecipeBookCategories.BLAST_FURNACE_SEARCH, RecipeBookCategories.BLAST_FURNACE_BLOCKS, RecipeBookCategories.BLAST_FURNACE_MISC});
        }
        if (recipeBookContainer instanceof SmokerContainer) {
            return Lists.newArrayList((Object[])new RecipeBookCategories[]{RecipeBookCategories.SMOKER_SEARCH, RecipeBookCategories.SMOKER_FOOD});
        }
        return Lists.newArrayList();
    }

    public List<RecipeList> func_199642_d() {
        return this.field_197932_f;
    }

    public List<RecipeList> func_202891_a(RecipeBookCategories recipeBookCategories) {
        return this.field_197931_e.getOrDefault((Object)recipeBookCategories, Collections.emptyList());
    }
}

