/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.resources;

import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Collections;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.client.resources.ResourceIndex;
import net.minecraft.util.ResourceLocation;

public class FolderResourceIndex
extends ResourceIndex {
    private final File field_188548_a;

    public FolderResourceIndex(File file) {
        this.field_188548_a = file;
    }

    @Override
    public File func_188547_a(ResourceLocation resourceLocation) {
        return new File(this.field_188548_a, resourceLocation.toString().replace(':', '/'));
    }

    @Override
    public File func_200009_a(String string) {
        return new File(this.field_188548_a, string);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Collection<String> func_211685_a(String string2, int n, Predicate<String> predicate) {
        Path path2 = this.field_188548_a.toPath().resolve("minecraft/");
        try (Stream<Path> \u260322222 = Files.walk(path2.resolve(string2), n, new FileVisitOption[0]);){
            Collection collection = \u260322222.filter(path -> Files.isRegularFile(path, new LinkOption[0])).filter(path -> !path.endsWith(".mcmeta")).map(path2::relativize).map(Object::toString).map(string -> string.replaceAll("\\\\", "/")).filter(predicate).collect(Collectors.toList());
            return collection;
        }
        catch (NoSuchFileException \u260322222) {
            return Collections.emptyList();
        }
        catch (IOException iOException) {
            field_152783_a.warn("Unable to getFiles on {}", (Object)string2, (Object)iOException);
        }
        return Collections.emptyList();
    }
}

