/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.texture;

import com.google.common.collect.Lists;
import com.mojang.datafixers.util.Pair;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.texture.NativeImage;
import net.minecraft.client.renderer.texture.PngSizeInfo;
import net.minecraft.client.resources.data.AnimationFrame;
import net.minecraft.client.resources.data.AnimationMetadataSection;
import net.minecraft.crash.CrashReport;
import net.minecraft.crash.CrashReportCategory;
import net.minecraft.crash.ReportedException;
import net.minecraft.resources.IResource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Util;

public class TextureAtlasSprite {
    private final ResourceLocation field_110984_i;
    protected final int field_130223_c;
    protected final int field_130224_d;
    protected NativeImage[] field_195670_c;
    @Nullable
    protected int[] field_195671_d;
    @Nullable
    protected int[] field_195672_e;
    protected NativeImage[] field_176605_b;
    private AnimationMetadataSection field_110982_k;
    protected int field_110975_c;
    protected int field_110974_d;
    private float field_110979_l;
    private float field_110980_m;
    private float field_110977_n;
    private float field_110978_o;
    protected int field_110973_g;
    protected int field_110983_h;
    private static final float[] field_195674_s = Util.func_200696_a(new float[256], fArray -> {
        for (int i = 0; i < ((float[])fArray).length; ++i) {
            fArray[i] = (float)Math.pow((float)i / 255.0f, 2.2);
        }
    });

    protected TextureAtlasSprite(ResourceLocation resourceLocation, int n, int n2) {
        this.field_110984_i = resourceLocation;
        this.field_130223_c = n;
        this.field_130224_d = n2;
    }

    protected TextureAtlasSprite(ResourceLocation resourceLocation, PngSizeInfo pngSizeInfo2, @Nullable AnimationMetadataSection animationMetadataSection2) {
        AnimationMetadataSection animationMetadataSection2;
        this.field_110984_i = resourceLocation;
        if (animationMetadataSection2 != null) {
            Pair<Integer, Integer> pair = TextureAtlasSprite.func_217788_b(animationMetadataSection2.func_110474_b(), animationMetadataSection2.func_110471_a(), pngSizeInfo2.field_188533_a, pngSizeInfo2.field_188534_b);
            this.field_130223_c = (Integer)pair.getFirst();
            this.field_130224_d = (Integer)pair.getSecond();
            if (!TextureAtlasSprite.func_217787_a(pngSizeInfo2.field_188533_a, this.field_130223_c) || !TextureAtlasSprite.func_217787_a(pngSizeInfo2.field_188534_b, this.field_130224_d)) {
                throw new IllegalArgumentException(String.format("Image size %s,%s is not multiply of frame size %s,%s", this.field_130223_c, this.field_130224_d, pngSizeInfo2.field_188533_a, pngSizeInfo2.field_188534_b));
            }
        } else {
            PngSizeInfo pngSizeInfo2;
            this.field_130223_c = pngSizeInfo2.field_188533_a;
            this.field_130224_d = pngSizeInfo2.field_188534_b;
        }
        this.field_110982_k = animationMetadataSection2;
    }

    private static Pair<Integer, Integer> func_217788_b(int n, int n2, int n3, int n4) {
        if (n != -1) {
            if (n2 != -1) {
                return Pair.of((Object)n, (Object)n2);
            }
            return Pair.of((Object)n, (Object)n4);
        }
        if (n2 != -1) {
            return Pair.of((Object)n3, (Object)n2);
        }
        \u2603 = Math.min(n3, n4);
        return Pair.of((Object)\u2603, (Object)\u2603);
    }

    private static boolean func_217787_a(int n, int n2) {
        return n / n2 * n2 == n;
    }

    private void func_195666_b(int n) {
        NativeImage[] nativeImageArray = new NativeImage[n + 1];
        nativeImageArray[0] = this.field_195670_c[0];
        if (n > 0) {
            int n2;
            boolean bl = false;
            block0: for (n2 = 0; n2 < this.field_195670_c[0].func_195702_a(); ++n2) {
                for (\u2603 = 0; \u2603 < this.field_195670_c[0].func_195714_b(); ++\u2603) {
                    if (this.field_195670_c[0].func_195709_a(n2, \u2603) >> 24 != 0) continue;
                    bl = true;
                    break block0;
                }
            }
            for (n2 = 1; n2 <= n; ++n2) {
                NativeImage nativeImage;
                if (this.field_195670_c.length > n2 && this.field_195670_c[n2] != null) {
                    nativeImageArray[n2] = this.field_195670_c[n2];
                    continue;
                }
                NativeImage nativeImage2 = nativeImageArray[n2 - 1];
                nativeImage = new NativeImage(nativeImage2.func_195702_a() >> 1, nativeImage2.func_195714_b() >> 1, false);
                int \u26032 = nativeImage.func_195702_a();
                int \u26033 = nativeImage.func_195714_b();
                for (int i = 0; i < \u26032; ++i) {
                    for (\u2603 = 0; \u2603 < \u26033; ++\u2603) {
                        nativeImage.func_195700_a(i, \u2603, TextureAtlasSprite.func_195661_b(nativeImage2.func_195709_a(i * 2 + 0, \u2603 * 2 + 0), nativeImage2.func_195709_a(i * 2 + 1, \u2603 * 2 + 0), nativeImage2.func_195709_a(i * 2 + 0, \u2603 * 2 + 1), nativeImage2.func_195709_a(i * 2 + 1, \u2603 * 2 + 1), bl));
                    }
                }
                nativeImageArray[n2] = nativeImage;
            }
            for (n2 = n + 1; n2 < this.field_195670_c.length; ++n2) {
                if (this.field_195670_c[n2] == null) continue;
                this.field_195670_c[n2].close();
            }
        }
        this.field_195670_c = nativeImageArray;
    }

    private static int func_195661_b(int n, int n2, int n3, int n4, boolean bl) {
        if (bl) {
            float f = 0.0f;
            \u2603 = 0.0f;
            \u2603 = 0.0f;
            \u2603 = 0.0f;
            if (n >> 24 != 0) {
                f += TextureAtlasSprite.func_195660_c(n >> 24);
                \u2603 += TextureAtlasSprite.func_195660_c(n >> 16);
                \u2603 += TextureAtlasSprite.func_195660_c(n >> 8);
                \u2603 += TextureAtlasSprite.func_195660_c(n >> 0);
            }
            if (n2 >> 24 != 0) {
                f += TextureAtlasSprite.func_195660_c(n2 >> 24);
                \u2603 += TextureAtlasSprite.func_195660_c(n2 >> 16);
                \u2603 += TextureAtlasSprite.func_195660_c(n2 >> 8);
                \u2603 += TextureAtlasSprite.func_195660_c(n2 >> 0);
            }
            if (n3 >> 24 != 0) {
                f += TextureAtlasSprite.func_195660_c(n3 >> 24);
                \u2603 += TextureAtlasSprite.func_195660_c(n3 >> 16);
                \u2603 += TextureAtlasSprite.func_195660_c(n3 >> 8);
                \u2603 += TextureAtlasSprite.func_195660_c(n3 >> 0);
            }
            if (n4 >> 24 != 0) {
                f += TextureAtlasSprite.func_195660_c(n4 >> 24);
                \u2603 += TextureAtlasSprite.func_195660_c(n4 >> 16);
                \u2603 += TextureAtlasSprite.func_195660_c(n4 >> 8);
                \u2603 += TextureAtlasSprite.func_195660_c(n4 >> 0);
            }
            int \u26032 = (int)(Math.pow(f /= 4.0f, 0.45454545454545453) * 255.0);
            int \u26033 = (int)(Math.pow(\u2603 /= 4.0f, 0.45454545454545453) * 255.0);
            int \u26034 = (int)(Math.pow(\u2603 /= 4.0f, 0.45454545454545453) * 255.0);
            int \u26035 = (int)(Math.pow(\u2603 /= 4.0f, 0.45454545454545453) * 255.0);
            if (\u26032 < 96) {
                \u26032 = 0;
            }
            return \u26032 << 24 | \u26033 << 16 | \u26034 << 8 | \u26035;
        }
        int n5 = TextureAtlasSprite.func_195669_a(n, n2, n3, n4, 24);
        \u2603 = TextureAtlasSprite.func_195669_a(n, n2, n3, n4, 16);
        \u2603 = TextureAtlasSprite.func_195669_a(n, n2, n3, n4, 8);
        \u2603 = TextureAtlasSprite.func_195669_a(n, n2, n3, n4, 0);
        return n5 << 24 | \u2603 << 16 | \u2603 << 8 | \u2603;
    }

    private static int func_195669_a(int n, int n2, int n3, int n4, int n5) {
        float f = TextureAtlasSprite.func_195660_c(n >> n5);
        \u2603 = TextureAtlasSprite.func_195660_c(n2 >> n5);
        \u2603 = TextureAtlasSprite.func_195660_c(n3 >> n5);
        \u2603 = TextureAtlasSprite.func_195660_c(n4 >> n5);
        \u2603 = (float)((double)((float)Math.pow((double)(f + \u2603 + \u2603 + \u2603) * 0.25, 0.45454545454545453)));
        return (int)((double)\u2603 * 255.0);
    }

    private static float func_195660_c(int n) {
        return field_195674_s[n & 0xFF];
    }

    private void func_195659_d(int n) {
        \u2603 = 0;
        \u2603 = 0;
        if (this.field_195671_d != null) {
            \u2603 = this.field_195671_d[n] * this.field_130223_c;
            \u2603 = this.field_195672_e[n] * this.field_130224_d;
        }
        this.func_195667_a(\u2603, \u2603, this.field_195670_c);
    }

    private void func_195667_a(int n, int n2, NativeImage[] nativeImageArray) {
        for (int i = 0; i < this.field_195670_c.length; ++i) {
            nativeImageArray[i].func_195706_a(i, this.field_110975_c >> i, this.field_110974_d >> i, n >> i, n2 >> i, this.field_130223_c >> i, this.field_130224_d >> i, this.field_195670_c.length > 1);
        }
    }

    public void func_217789_a(int n, int n2, int n3, int n4) {
        this.field_110975_c = n3;
        this.field_110974_d = n4;
        this.field_110979_l = (float)n3 / (float)n;
        this.field_110980_m = (float)(n3 + this.field_130223_c) / (float)n;
        this.field_110977_n = (float)n4 / (float)n2;
        this.field_110978_o = (float)(n4 + this.field_130224_d) / (float)n2;
    }

    public int func_94211_a() {
        return this.field_130223_c;
    }

    public int func_94216_b() {
        return this.field_130224_d;
    }

    public float func_94209_e() {
        return this.field_110979_l;
    }

    public float func_94212_f() {
        return this.field_110980_m;
    }

    public float func_94214_a(double d) {
        float f = this.field_110980_m - this.field_110979_l;
        return this.field_110979_l + f * (float)d / 16.0f;
    }

    public float func_188537_a(float f) {
        \u2603 = this.field_110980_m - this.field_110979_l;
        return (f - this.field_110979_l) / \u2603 * 16.0f;
    }

    public float func_94206_g() {
        return this.field_110977_n;
    }

    public float func_94210_h() {
        return this.field_110978_o;
    }

    public float func_94207_b(double d) {
        float f = this.field_110978_o - this.field_110977_n;
        return this.field_110977_n + f * (float)d / 16.0f;
    }

    public float func_188536_b(float f) {
        \u2603 = this.field_110978_o - this.field_110977_n;
        return (f - this.field_110977_n) / \u2603 * 16.0f;
    }

    public ResourceLocation func_195668_m() {
        return this.field_110984_i;
    }

    public void func_94219_l() {
        ++this.field_110983_h;
        if (this.field_110983_h >= this.field_110982_k.func_110472_a(this.field_110973_g)) {
            int n = this.field_110982_k.func_110468_c(this.field_110973_g);
            \u2603 = this.field_110982_k.func_110473_c() == 0 ? this.func_110970_k() : this.field_110982_k.func_110473_c();
            this.field_110973_g = (this.field_110973_g + 1) % \u2603;
            this.field_110983_h = 0;
            \u2603 = this.field_110982_k.func_110468_c(this.field_110973_g);
            if (n != \u2603 && \u2603 >= 0 && \u2603 < this.func_110970_k()) {
                this.func_195659_d(\u2603);
            }
        } else if (this.field_110982_k.func_177219_e()) {
            this.func_180599_n();
        }
    }

    private void func_180599_n() {
        double d = 1.0 - (double)this.field_110983_h / (double)this.field_110982_k.func_110472_a(this.field_110973_g);
        int \u26032 = this.field_110982_k.func_110468_c(this.field_110973_g);
        if (\u26032 != (\u2603 = this.field_110982_k.func_110468_c((this.field_110973_g + 1) % (\u2603 = this.field_110982_k.func_110473_c() == 0 ? this.func_110970_k() : this.field_110982_k.func_110473_c()))) && \u2603 >= 0 && \u2603 < this.func_110970_k()) {
            if (this.field_176605_b == null || this.field_176605_b.length != this.field_195670_c.length) {
                if (this.field_176605_b != null) {
                    for (NativeImage nativeImage : this.field_176605_b) {
                        if (nativeImage == null) continue;
                        nativeImage.close();
                    }
                }
                this.field_176605_b = new NativeImage[this.field_195670_c.length];
            }
            for (int i = 0; i < this.field_195670_c.length; ++i) {
                \u2603 = this.field_130223_c >> i;
                \u2603 = this.field_130224_d >> i;
                if (this.field_176605_b[i] == null) {
                    this.field_176605_b[i] = new NativeImage(\u2603, \u2603, false);
                }
                for (\u2603 = 0; \u2603 < \u2603; ++\u2603) {
                    for (\u2603 = 0; \u2603 < \u2603; ++\u2603) {
                        \u2603 = this.func_195665_a(\u26032, i, \u2603, \u2603);
                        \u2603 = this.func_195665_a(\u2603, i, \u2603, \u2603);
                        \u2603 = this.func_188535_a(d, \u2603 >> 16 & 0xFF, \u2603 >> 16 & 0xFF);
                        \u2603 = this.func_188535_a(d, \u2603 >> 8 & 0xFF, \u2603 >> 8 & 0xFF);
                        \u2603 = this.func_188535_a(d, \u2603 & 0xFF, \u2603 & 0xFF);
                        this.field_176605_b[i].func_195700_a(\u2603, \u2603, \u2603 & 0xFF000000 | \u2603 << 16 | \u2603 << 8 | \u2603);
                    }
                }
            }
            this.func_195667_a(0, 0, this.field_176605_b);
        }
    }

    private int func_188535_a(double d, int n, int n2) {
        return (int)(d * (double)n + (1.0 - d) * (double)n2);
    }

    public int func_110970_k() {
        return this.field_195671_d == null ? 0 : this.field_195671_d.length;
    }

    public void func_195664_a(IResource iResource, int n) throws IOException {
        NativeImage nativeImage = NativeImage.func_195713_a(iResource.func_199027_b());
        this.field_195670_c = new NativeImage[n];
        this.field_195670_c[0] = nativeImage;
        int \u26032 = this.field_110982_k != null && this.field_110982_k.func_110474_b() != -1 ? nativeImage.func_195702_a() / this.field_110982_k.func_110474_b() : nativeImage.func_195702_a() / this.field_130223_c;
        int \u26033 = this.field_110982_k != null && this.field_110982_k.func_110471_a() != -1 ? nativeImage.func_195714_b() / this.field_110982_k.func_110471_a() : nativeImage.func_195714_b() / this.field_130224_d;
        if (this.field_110982_k != null && this.field_110982_k.func_110473_c() > 0) {
            int n2 = (Integer)this.field_110982_k.func_130073_e().stream().max(Integer::compareTo).get() + 1;
            this.field_195671_d = new int[n2];
            this.field_195672_e = new int[n2];
            Arrays.fill(this.field_195671_d, -1);
            Arrays.fill(this.field_195672_e, -1);
            for (int n3 : this.field_110982_k.func_130073_e()) {
                if (n3 >= \u26032 * \u26033) {
                    throw new RuntimeException("invalid frameindex " + n3);
                }
                \u2603 = n3 / \u26032;
                this.field_195671_d[n3] = \u2603 = n3 % \u26032;
                this.field_195672_e[n3] = \u2603;
            }
        } else {
            int n4;
            ArrayList arrayList = Lists.newArrayList();
            int \u26034 = \u26032 * \u26033;
            this.field_195671_d = new int[\u26034];
            this.field_195672_e = new int[\u26034];
            for (n4 = 0; n4 < \u26033; ++n4) {
                \u2603 = 0;
                while (\u2603 < \u26032) {
                    \u2603 = n4 * \u26032 + \u2603;
                    this.field_195671_d[\u2603] = \u2603++;
                    this.field_195672_e[\u2603] = n4;
                    arrayList.add(new AnimationFrame(\u2603, -1));
                }
            }
            n4 = 1;
            \u2603 = 0;
            if (this.field_110982_k != null) {
                n4 = this.field_110982_k.func_110469_d();
                \u2603 = this.field_110982_k.func_177219_e() ? 1 : 0;
            }
            this.field_110982_k = new AnimationMetadataSection(arrayList, this.field_130223_c, this.field_130224_d, n4, \u2603 != 0);
        }
    }

    public void func_147963_d(int n) {
        try {
            this.func_195666_b(n);
        }
        catch (Throwable throwable) {
            CrashReport crashReport = CrashReport.func_85055_a(throwable, "Generating mipmaps for frame");
            CrashReportCategory \u26032 = crashReport.func_85058_a("Frame being iterated");
            \u26032.func_189529_a("Frame sizes", () -> {
                StringBuilder stringBuilder = new StringBuilder();
                for (NativeImage nativeImage : this.field_195670_c) {
                    if (stringBuilder.length() > 0) {
                        stringBuilder.append(", ");
                    }
                    stringBuilder.append(nativeImage == null ? "null" : nativeImage.func_195702_a() + "x" + nativeImage.func_195714_b());
                }
                return stringBuilder.toString();
            });
            throw new ReportedException(crashReport);
        }
    }

    public void func_130103_l() {
        if (this.field_195670_c != null) {
            for (NativeImage nativeImage : this.field_195670_c) {
                if (nativeImage == null) continue;
                nativeImage.close();
            }
        }
        this.field_195670_c = null;
        if (this.field_176605_b != null) {
            for (NativeImage nativeImage : this.field_176605_b) {
                if (nativeImage == null) continue;
                nativeImage.close();
            }
        }
        this.field_176605_b = null;
    }

    public boolean func_130098_m() {
        return this.field_110982_k != null && this.field_110982_k.func_110473_c() > 1;
    }

    public String toString() {
        int n = this.field_195671_d == null ? 0 : this.field_195671_d.length;
        return "TextureAtlasSprite{name='" + this.field_110984_i + '\'' + ", frameCount=" + n + ", x=" + this.field_110975_c + ", y=" + this.field_110974_d + ", height=" + this.field_130224_d + ", width=" + this.field_130223_c + ", u0=" + this.field_110979_l + ", u1=" + this.field_110980_m + ", v0=" + this.field_110977_n + ", v1=" + this.field_110978_o + '}';
    }

    private int func_195665_a(int n, int n2, int n3, int n4) {
        return this.field_195670_c[n2].func_195709_a(n3 + (this.field_195671_d[n] * this.field_130223_c >> n2), n4 + (this.field_195672_e[n] * this.field_130224_d >> n2));
    }

    public boolean func_195662_a(int n, int n2, int n3) {
        return (this.field_195670_c[0].func_195709_a(n2 + this.field_195671_d[n] * this.field_130223_c, n3 + this.field_195672_e[n] * this.field_130224_d) >> 24 & 0xFF) == 0;
    }

    public void func_195663_q() {
        this.func_195659_d(0);
    }
}

