/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.texture;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.mojang.blaze3d.platform.TextureUtil;
import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.StitcherException;
import net.minecraft.client.renderer.texture.ITickableTextureObject;
import net.minecraft.client.renderer.texture.MissingTextureSprite;
import net.minecraft.client.renderer.texture.PngSizeInfo;
import net.minecraft.client.renderer.texture.Stitcher;
import net.minecraft.client.renderer.texture.Texture;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.data.AnimationMetadataSection;
import net.minecraft.crash.CrashReport;
import net.minecraft.crash.CrashReportCategory;
import net.minecraft.crash.ReportedException;
import net.minecraft.profiler.IProfiler;
import net.minecraft.resources.IResource;
import net.minecraft.resources.IResourceManager;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Util;
import net.minecraft.util.math.MathHelper;
import org.apache.commons.io.IOUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class AtlasTexture
extends Texture
implements ITickableTextureObject {
    private static final Logger field_147635_d = LogManager.getLogger();
    public static final ResourceLocation field_110575_b = new ResourceLocation("textures/atlas/blocks.png");
    public static final ResourceLocation field_215262_g = new ResourceLocation("textures/atlas/particles.png");
    public static final ResourceLocation field_215263_h = new ResourceLocation("textures/atlas/paintings.png");
    public static final ResourceLocation field_215264_i = new ResourceLocation("textures/atlas/mob_effects.png");
    private final List<TextureAtlasSprite> field_94258_i = Lists.newArrayList();
    private final Set<ResourceLocation> field_195427_i = Sets.newHashSet();
    private final Map<ResourceLocation, TextureAtlasSprite> field_94252_e = Maps.newHashMap();
    private final String field_94254_c;
    private final int field_215265_o;
    private int field_147636_j;
    private final TextureAtlasSprite field_94249_f = MissingTextureSprite.func_217790_a();

    public AtlasTexture(String string) {
        this.field_94254_c = string;
        this.field_215265_o = Minecraft.func_71369_N();
    }

    @Override
    public void func_195413_a(IResourceManager iResourceManager) throws IOException {
    }

    public void func_215260_a(SheetData sheetData) {
        this.field_195427_i.clear();
        this.field_195427_i.addAll(sheetData.field_217805_a);
        field_147635_d.info("Created: {}x{} {}-atlas", (Object)sheetData.field_217806_b, (Object)sheetData.field_217807_c, (Object)this.field_94254_c);
        TextureUtil.prepareImage(this.func_110552_b(), this.field_147636_j, sheetData.field_217806_b, sheetData.field_217807_c);
        this.func_195419_g();
        for (TextureAtlasSprite textureAtlasSprite : sheetData.field_217808_d) {
            this.field_94252_e.put(textureAtlasSprite.func_195668_m(), textureAtlasSprite);
            try {
                textureAtlasSprite.func_195663_q();
            }
            catch (Throwable throwable) {
                CrashReport crashReport = CrashReport.func_85055_a(throwable, "Stitching texture atlas");
                CrashReportCategory \u26032 = crashReport.func_85058_a("Texture being stitched together");
                \u26032.func_71507_a("Atlas path", this.field_94254_c);
                \u26032.func_71507_a("Sprite", textureAtlasSprite);
                throw new ReportedException(crashReport);
            }
            if (!textureAtlasSprite.func_130098_m()) continue;
            this.field_94258_i.add(textureAtlasSprite);
        }
    }

    public SheetData func_215254_a(IResourceManager iResourceManager, Iterable<ResourceLocation> iterable, IProfiler iProfiler) {
        HashSet hashSet = Sets.newHashSet();
        iProfiler.func_76320_a("preparing");
        iterable.forEach(resourceLocation -> {
            if (resourceLocation == null) {
                throw new IllegalArgumentException("Location cannot be null!");
            }
            hashSet.add(resourceLocation);
        });
        int \u26032 = this.field_215265_o;
        Stitcher \u26033 = new Stitcher(\u26032, \u26032, this.field_147636_j);
        int \u26034 = Integer.MAX_VALUE;
        int \u26035 = 1 << this.field_147636_j;
        iProfiler.func_219895_b("extracting_frames");
        for (TextureAtlasSprite textureAtlasSprite2 : this.func_215256_a(iResourceManager, hashSet)) {
            \u26034 = Math.min(\u26034, Math.min(textureAtlasSprite2.func_94211_a(), textureAtlasSprite2.func_94216_b()));
            int n = Math.min(Integer.lowestOneBit(textureAtlasSprite2.func_94211_a()), Integer.lowestOneBit(textureAtlasSprite2.func_94216_b()));
            if (n < \u26035) {
                field_147635_d.warn("Texture {} with size {}x{} limits mip level from {} to {}", (Object)textureAtlasSprite2.func_195668_m(), (Object)textureAtlasSprite2.func_94211_a(), (Object)textureAtlasSprite2.func_94216_b(), (Object)MathHelper.func_151239_c(\u26035), (Object)MathHelper.func_151239_c(n));
                \u26035 = n;
            }
            \u26033.func_110934_a(textureAtlasSprite2);
        }
        int n = Math.min(\u26034, \u26035);
        \u2603 = MathHelper.func_151239_c(n);
        if (\u2603 < this.field_147636_j) {
            field_147635_d.warn("{}: dropping miplevel from {} to {}, because of minimum power of two: {}", (Object)this.field_94254_c, (Object)this.field_147636_j, (Object)\u2603, (Object)n);
            this.field_147636_j = \u2603;
        }
        iProfiler.func_219895_b("mipmapping");
        this.field_94249_f.func_147963_d(this.field_147636_j);
        iProfiler.func_219895_b("register");
        \u26033.func_110934_a(this.field_94249_f);
        iProfiler.func_219895_b("stitching");
        try {
            \u26033.func_94305_f();
        }
        catch (StitcherException \u26036) {
            CrashReport crashReport = CrashReport.func_85055_a(\u26036, "Stitching");
            CrashReportCategory \u26037 = crashReport.func_85058_a("Stitcher");
            \u26037.func_71507_a("Sprites", \u26036.func_225331_a().stream().map(textureAtlasSprite -> String.format("%s[%dx%d]", textureAtlasSprite.func_195668_m(), textureAtlasSprite.func_94211_a(), textureAtlasSprite.func_94216_b())).collect(Collectors.joining(",")));
            \u26037.func_71507_a("Max Texture Size", \u26032);
            throw new ReportedException(crashReport);
        }
        iProfiler.func_219895_b("loading");
        List<TextureAtlasSprite> list = this.func_215259_a(iResourceManager, \u26033);
        iProfiler.func_76319_b();
        return new SheetData(hashSet, \u26033.func_110935_a(), \u26033.func_110936_b(), list);
    }

    private Collection<TextureAtlasSprite> func_215256_a(IResourceManager iResourceManager, Set<ResourceLocation> set) {
        ArrayList<CompletableFuture<Void>> arrayList = new ArrayList<CompletableFuture<Void>>();
        ConcurrentLinkedQueue<TextureAtlasSprite> \u26032 = new ConcurrentLinkedQueue<TextureAtlasSprite>();
        for (ResourceLocation resourceLocation : set) {
            if (this.field_94249_f.func_195668_m().equals(resourceLocation)) continue;
            arrayList.add(CompletableFuture.runAsync(() -> {
                TextureAtlasSprite \u26033;
                ResourceLocation resourceLocation2 = this.func_195420_b(resourceLocation);
                try (IResource iResource = iResourceManager.func_199002_a(resourceLocation2);){
                    PngSizeInfo pngSizeInfo = new PngSizeInfo(iResource.toString(), iResource.func_199027_b());
                    AnimationMetadataSection \u26032 = iResource.func_199028_a(AnimationMetadataSection.field_195817_a);
                    \u26033 = new TextureAtlasSprite(resourceLocation, pngSizeInfo, \u26032);
                }
                catch (RuntimeException runtimeException) {
                    field_147635_d.error("Unable to parse metadata from {} : {}", (Object)resourceLocation2, (Object)runtimeException);
                    return;
                }
                catch (IOException iOException) {
                    field_147635_d.error("Using missing texture, unable to load {} : {}", (Object)resourceLocation2, (Object)iOException);
                    return;
                }
                \u26032.add(\u26033);
            }, Util.func_215072_e()));
        }
        CompletableFuture.allOf(arrayList.toArray(new CompletableFuture[0])).join();
        return \u26032;
    }

    private List<TextureAtlasSprite> func_215259_a(IResourceManager iResourceManager, Stitcher stitcher) {
        ConcurrentLinkedQueue<TextureAtlasSprite> concurrentLinkedQueue = new ConcurrentLinkedQueue<TextureAtlasSprite>();
        ArrayList<CompletableFuture<Void>> \u26032 = new ArrayList<CompletableFuture<Void>>();
        for (TextureAtlasSprite textureAtlasSprite : stitcher.func_94309_g()) {
            if (textureAtlasSprite == this.field_94249_f) {
                concurrentLinkedQueue.add(textureAtlasSprite);
                continue;
            }
            \u26032.add(CompletableFuture.runAsync(() -> {
                if (this.func_195422_a(iResourceManager, textureAtlasSprite)) {
                    concurrentLinkedQueue.add(textureAtlasSprite);
                }
            }, Util.func_215072_e()));
        }
        CompletableFuture.allOf(\u26032.toArray(new CompletableFuture[0])).join();
        return new ArrayList<TextureAtlasSprite>(concurrentLinkedQueue);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean func_195422_a(IResourceManager iResourceManager, TextureAtlasSprite textureAtlasSprite) {
        ResourceLocation resourceLocation = this.func_195420_b(textureAtlasSprite.func_195668_m());
        IResource \u26032 = null;
        try {
            \u26032 = iResourceManager.func_199002_a(resourceLocation);
            textureAtlasSprite.func_195664_a(\u26032, this.field_147636_j + 1);
        }
        catch (RuntimeException \u26033) {
            field_147635_d.error("Unable to parse metadata from {}", (Object)resourceLocation, (Object)\u26033);
            boolean bl = false;
            return bl;
        }
        catch (IOException \u26034) {
            field_147635_d.error("Using missing texture, unable to load {}", (Object)resourceLocation, (Object)\u26034);
            boolean bl = false;
            return bl;
        }
        finally {
            IOUtils.closeQuietly((Closeable)\u26032);
        }
        try {
            textureAtlasSprite.func_147963_d(this.field_147636_j);
        }
        catch (Throwable \u26035) {
            CrashReport crashReport = CrashReport.func_85055_a(\u26035, "Applying mipmap");
            CrashReportCategory \u26036 = crashReport.func_85058_a("Sprite being mipmapped");
            \u26036.func_189529_a("Sprite name", () -> textureAtlasSprite.func_195668_m().toString());
            \u26036.func_189529_a("Sprite size", () -> textureAtlasSprite.func_94211_a() + " x " + textureAtlasSprite.func_94216_b());
            \u26036.func_189529_a("Sprite frames", () -> textureAtlasSprite.func_110970_k() + " frames");
            \u26036.func_71507_a("Mipmap levels", this.field_147636_j);
            throw new ReportedException(crashReport);
        }
        return true;
    }

    private ResourceLocation func_195420_b(ResourceLocation resourceLocation) {
        return new ResourceLocation(resourceLocation.func_110624_b(), String.format("%s/%s%s", this.field_94254_c, resourceLocation.func_110623_a(), ".png"));
    }

    public TextureAtlasSprite func_110572_b(String string) {
        return this.func_195424_a(new ResourceLocation(string));
    }

    public void func_94248_c() {
        this.func_195412_h();
        for (TextureAtlasSprite textureAtlasSprite : this.field_94258_i) {
            textureAtlasSprite.func_94219_l();
        }
    }

    @Override
    public void func_110550_d() {
        this.func_94248_c();
    }

    public void func_147633_a(int n) {
        this.field_147636_j = n;
    }

    public TextureAtlasSprite func_195424_a(ResourceLocation resourceLocation) {
        TextureAtlasSprite textureAtlasSprite = this.field_94252_e.get(resourceLocation);
        if (textureAtlasSprite == null) {
            return this.field_94249_f;
        }
        return textureAtlasSprite;
    }

    public void func_195419_g() {
        for (TextureAtlasSprite textureAtlasSprite : this.field_94252_e.values()) {
            textureAtlasSprite.func_130103_l();
        }
        this.field_94252_e.clear();
        this.field_94258_i.clear();
    }

    public static class SheetData {
        final Set<ResourceLocation> field_217805_a;
        final int field_217806_b;
        final int field_217807_c;
        final List<TextureAtlasSprite> field_217808_d;

        public SheetData(Set<ResourceLocation> set, int n, int n2, List<TextureAtlasSprite> list) {
            this.field_217805_a = set;
            this.field_217806_b = n;
            this.field_217807_c = n2;
            this.field_217808_d = list;
        }
    }
}

