/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.model;

import javax.annotation.Nullable;
import net.minecraft.client.renderer.FaceDirection;
import net.minecraft.client.renderer.Quaternion;
import net.minecraft.client.renderer.Vector3f;
import net.minecraft.client.renderer.Vector4f;
import net.minecraft.client.renderer.model.BakedQuad;
import net.minecraft.client.renderer.model.BlockFaceUV;
import net.minecraft.client.renderer.model.BlockPartFace;
import net.minecraft.client.renderer.model.BlockPartRotation;
import net.minecraft.client.renderer.model.ModelRotation;
import net.minecraft.client.renderer.texture.ISprite;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.util.Direction;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3i;

public class FaceBakery {
    private static final float field_178418_a = 1.0f / (float)Math.cos(0.3926991f) - 1.0f;
    private static final float field_178417_b = 1.0f / (float)Math.cos(0.7853981852531433) - 1.0f;
    private static final Rotation[] field_188016_c = new Rotation[ModelRotation.values().length * Direction.values().length];
    private static final Rotation field_188017_d = new Rotation(){

        @Override
        BlockFaceUV func_188007_a(float f, float f2, float f3, float f4) {
            return new BlockFaceUV(new float[]{f, f2, f3, f4}, 0);
        }
    };
    private static final Rotation field_188018_e = new Rotation(){

        @Override
        BlockFaceUV func_188007_a(float f, float f2, float f3, float f4) {
            return new BlockFaceUV(new float[]{f4, 16.0f - f, f2, 16.0f - f3}, 270);
        }
    };
    private static final Rotation field_188019_f = new Rotation(){

        @Override
        BlockFaceUV func_188007_a(float f, float f2, float f3, float f4) {
            return new BlockFaceUV(new float[]{16.0f - f, 16.0f - f2, 16.0f - f3, 16.0f - f4}, 0);
        }
    };
    private static final Rotation field_188020_g = new Rotation(){

        @Override
        BlockFaceUV func_188007_a(float f, float f2, float f3, float f4) {
            return new BlockFaceUV(new float[]{16.0f - f2, f3, 16.0f - f4, f}, 90);
        }
    };

    public BakedQuad func_217648_a(Vector3f vector3f, Vector3f vector3f2, BlockPartFace blockPartFace, TextureAtlasSprite textureAtlasSprite, Direction direction, ISprite iSprite, @Nullable BlockPartRotation blockPartRotation, boolean bl) {
        BlockFaceUV blockFaceUV = blockPartFace.field_178243_e;
        if (iSprite.func_188049_c()) {
            blockFaceUV = this.func_188010_a(blockPartFace.field_178243_e, direction, iSprite.func_188048_b());
        }
        float[] \u26032 = new float[blockFaceUV.field_178351_a.length];
        System.arraycopy(blockFaceUV.field_178351_a, 0, \u26032, 0, \u26032.length);
        float \u26033 = (float)textureAtlasSprite.func_94211_a() / (textureAtlasSprite.func_94212_f() - textureAtlasSprite.func_94209_e());
        float \u26034 = (float)textureAtlasSprite.func_94216_b() / (textureAtlasSprite.func_94210_h() - textureAtlasSprite.func_94206_g());
        float \u26035 = 4.0f / Math.max(\u26034, \u26033);
        float \u26036 = (blockFaceUV.field_178351_a[0] + blockFaceUV.field_178351_a[0] + blockFaceUV.field_178351_a[2] + blockFaceUV.field_178351_a[2]) / 4.0f;
        float \u26037 = (blockFaceUV.field_178351_a[1] + blockFaceUV.field_178351_a[1] + blockFaceUV.field_178351_a[3] + blockFaceUV.field_178351_a[3]) / 4.0f;
        blockFaceUV.field_178351_a[0] = MathHelper.func_219799_g(\u26035, blockFaceUV.field_178351_a[0], \u26036);
        blockFaceUV.field_178351_a[2] = MathHelper.func_219799_g(\u26035, blockFaceUV.field_178351_a[2], \u26036);
        blockFaceUV.field_178351_a[1] = MathHelper.func_219799_g(\u26035, blockFaceUV.field_178351_a[1], \u26037);
        blockFaceUV.field_178351_a[3] = MathHelper.func_219799_g(\u26035, blockFaceUV.field_178351_a[3], \u26037);
        int[] \u26038 = this.func_188012_a(blockFaceUV, textureAtlasSprite, direction, this.func_199337_a(vector3f, vector3f2), iSprite.func_188048_b(), blockPartRotation, bl);
        Direction \u26039 = FaceBakery.func_178410_a(\u26038);
        System.arraycopy(\u26032, 0, blockFaceUV.field_178351_a, 0, \u26032.length);
        if (blockPartRotation == null) {
            this.func_178408_a(\u26038, \u26039);
        }
        return new BakedQuad(\u26038, blockPartFace.field_178245_c, \u26039, textureAtlasSprite);
    }

    private BlockFaceUV func_188010_a(BlockFaceUV blockFaceUV, Direction direction, ModelRotation modelRotation) {
        return field_188016_c[FaceBakery.func_188014_a(modelRotation, direction)].func_188006_a(blockFaceUV);
    }

    private int[] func_188012_a(BlockFaceUV blockFaceUV, TextureAtlasSprite textureAtlasSprite, Direction direction, float[] fArray, ModelRotation modelRotation, @Nullable BlockPartRotation blockPartRotation, boolean bl) {
        int[] nArray = new int[28];
        for (int i = 0; i < 4; ++i) {
            this.func_188015_a(nArray, i, direction, blockFaceUV, fArray, textureAtlasSprite, modelRotation, blockPartRotation, bl);
        }
        return nArray;
    }

    private int func_178413_a(Direction direction) {
        float f = this.func_178412_b(direction);
        int \u26032 = MathHelper.func_76125_a((int)(f * 255.0f), 0, 255);
        return 0xFF000000 | \u26032 << 16 | \u26032 << 8 | \u26032;
    }

    private float func_178412_b(Direction direction) {
        switch (direction) {
            case DOWN: {
                return 0.5f;
            }
            case UP: {
                return 1.0f;
            }
            case NORTH: 
            case SOUTH: {
                return 0.8f;
            }
            case WEST: 
            case EAST: {
                return 0.6f;
            }
        }
        return 1.0f;
    }

    private float[] func_199337_a(Vector3f vector3f, Vector3f vector3f2) {
        float[] fArray = new float[Direction.values().length];
        fArray[FaceDirection.Constants.field_179176_f] = vector3f.func_195899_a() / 16.0f;
        fArray[FaceDirection.Constants.field_179178_e] = vector3f.func_195900_b() / 16.0f;
        fArray[FaceDirection.Constants.field_179177_d] = vector3f.func_195902_c() / 16.0f;
        fArray[FaceDirection.Constants.field_179180_c] = vector3f2.func_195899_a() / 16.0f;
        fArray[FaceDirection.Constants.field_179179_b] = vector3f2.func_195900_b() / 16.0f;
        fArray[FaceDirection.Constants.field_179181_a] = vector3f2.func_195902_c() / 16.0f;
        return fArray;
    }

    private void func_188015_a(int[] nArray, int n, Direction direction, BlockFaceUV blockFaceUV, float[] fArray, TextureAtlasSprite textureAtlasSprite, ModelRotation modelRotation, @Nullable BlockPartRotation blockPartRotation, boolean bl) {
        Direction direction2 = modelRotation.func_177523_a(direction);
        int \u26032 = bl ? this.func_178413_a(direction2) : -1;
        FaceDirection.VertexInformation \u26033 = FaceDirection.func_179027_a(direction).func_179025_a(n);
        Vector3f \u26034 = new Vector3f(fArray[\u26033.field_179184_a], fArray[\u26033.field_179182_b], fArray[\u26033.field_179183_c]);
        this.func_199336_a(\u26034, blockPartRotation);
        int \u26035 = this.func_199335_a(\u26034, direction, n, modelRotation);
        this.func_199333_a(nArray, \u26035, n, \u26034, \u26032, textureAtlasSprite, blockFaceUV);
    }

    private void func_199333_a(int[] nArray, int n, int n2, Vector3f vector3f, int n3, TextureAtlasSprite textureAtlasSprite, BlockFaceUV blockFaceUV) {
        int n4 = n * 7;
        nArray[n4] = Float.floatToRawIntBits(vector3f.func_195899_a());
        nArray[n4 + 1] = Float.floatToRawIntBits(vector3f.func_195900_b());
        nArray[n4 + 2] = Float.floatToRawIntBits(vector3f.func_195902_c());
        nArray[n4 + 3] = n3;
        nArray[n4 + 4] = Float.floatToRawIntBits(textureAtlasSprite.func_94214_a(blockFaceUV.func_178348_a(n2)));
        nArray[n4 + 4 + 1] = Float.floatToRawIntBits(textureAtlasSprite.func_94207_b(blockFaceUV.func_178346_b(n2)));
    }

    private void func_199336_a(Vector3f vector3f, @Nullable BlockPartRotation blockPartRotation) {
        Vector3f vector3f2;
        if (blockPartRotation == null) {
            return;
        }
        switch (blockPartRotation.field_178342_b) {
            case X: {
                vector3f2 = new Vector3f(1.0f, 0.0f, 0.0f);
                \u2603 = new Vector3f(0.0f, 1.0f, 1.0f);
                break;
            }
            case Y: {
                vector3f2 = new Vector3f(0.0f, 1.0f, 0.0f);
                \u2603 = new Vector3f(1.0f, 0.0f, 1.0f);
                break;
            }
            case Z: {
                vector3f2 = new Vector3f(0.0f, 0.0f, 1.0f);
                \u2603 = new Vector3f(1.0f, 1.0f, 0.0f);
                break;
            }
            default: {
                throw new IllegalArgumentException("There are only 3 axes");
            }
        }
        Quaternion \u26032 = new Quaternion(vector3f2, blockPartRotation.field_178343_c, true);
        if (blockPartRotation.field_178341_d) {
            if (Math.abs(blockPartRotation.field_178343_c) == 22.5f) {
                \u2603.func_195898_a(field_178418_a);
            } else {
                \u2603.func_195898_a(field_178417_b);
            }
            \u2603.func_195904_b(1.0f, 1.0f, 1.0f);
        } else {
            \u2603.func_195905_a(1.0f, 1.0f, 1.0f);
        }
        this.func_199334_a(vector3f, new Vector3f(blockPartRotation.field_178344_a), \u26032, \u2603);
    }

    public int func_199335_a(Vector3f vector3f, Direction direction, int n, ModelRotation modelRotation) {
        if (modelRotation == ModelRotation.X0_Y0) {
            return n;
        }
        this.func_199334_a(vector3f, new Vector3f(0.5f, 0.5f, 0.5f), modelRotation.func_217650_a(), new Vector3f(1.0f, 1.0f, 1.0f));
        return modelRotation.func_177520_a(direction, n);
    }

    private void func_199334_a(Vector3f vector3f, Vector3f vector3f2, Quaternion quaternion, Vector3f vector3f3) {
        Vector4f vector4f = new Vector4f(vector3f.func_195899_a() - vector3f2.func_195899_a(), vector3f.func_195900_b() - vector3f2.func_195900_b(), vector3f.func_195902_c() - vector3f2.func_195902_c(), 1.0f);
        vector4f.func_195912_a(quaternion);
        vector4f.func_195909_a(vector3f3);
        vector3f.func_195905_a(vector4f.func_195910_a() + vector3f2.func_195899_a(), vector4f.func_195913_b() + vector3f2.func_195900_b(), vector4f.func_195914_c() + vector3f2.func_195902_c());
    }

    public static Direction func_178410_a(int[] nArray) {
        Vector3f vector3f = new Vector3f(Float.intBitsToFloat(nArray[0]), Float.intBitsToFloat(nArray[1]), Float.intBitsToFloat(nArray[2]));
        \u2603 = new Vector3f(Float.intBitsToFloat(nArray[7]), Float.intBitsToFloat(nArray[8]), Float.intBitsToFloat(nArray[9]));
        \u2603 = new Vector3f(Float.intBitsToFloat(nArray[14]), Float.intBitsToFloat(nArray[15]), Float.intBitsToFloat(nArray[16]));
        \u2603 = new Vector3f(vector3f);
        \u2603.func_195897_a(\u2603);
        \u2603 = new Vector3f(\u2603);
        \u2603.func_195897_a(\u2603);
        \u2603 = new Vector3f(\u2603);
        \u2603.func_195896_c(\u2603);
        \u2603.func_195906_d();
        Direction \u26032 = null;
        float \u26033 = 0.0f;
        for (Direction direction : Direction.values()) {
            Vec3i vec3i = direction.func_176730_m();
            Vector3f \u26034 = new Vector3f(vec3i.func_177958_n(), vec3i.func_177956_o(), vec3i.func_177952_p());
            float \u26035 = \u2603.func_195903_b(\u26034);
            if (!(\u26035 >= 0.0f) || !(\u26035 > \u26033)) continue;
            \u26033 = \u26035;
            \u26032 = direction;
        }
        if (\u26032 == null) {
            return Direction.UP;
        }
        return \u26032;
    }

    private void func_178408_a(int[] nArray, Direction direction2) {
        Direction direction2;
        int[] nArray2 = new int[nArray.length];
        System.arraycopy(nArray, 0, nArray2, 0, nArray.length);
        float[] \u26032 = new float[Direction.values().length];
        \u26032[FaceDirection.Constants.field_179176_f] = 999.0f;
        \u26032[FaceDirection.Constants.field_179178_e] = 999.0f;
        \u26032[FaceDirection.Constants.field_179177_d] = 999.0f;
        \u26032[FaceDirection.Constants.field_179180_c] = -999.0f;
        \u26032[FaceDirection.Constants.field_179179_b] = -999.0f;
        \u26032[FaceDirection.Constants.field_179181_a] = -999.0f;
        for (int i = 0; i < 4; ++i) {
            i = 7 * i;
            float f = Float.intBitsToFloat(nArray2[i]);
            \u2603 = Float.intBitsToFloat(nArray2[i + 1]);
            \u26034 = Float.intBitsToFloat(nArray2[i + 2]);
            if (f < \u26032[FaceDirection.Constants.field_179176_f]) {
                \u26032[FaceDirection.Constants.field_179176_f] = f;
            }
            if (\u2603 < \u26032[FaceDirection.Constants.field_179178_e]) {
                \u26032[FaceDirection.Constants.field_179178_e] = \u2603;
            }
            if (\u26034 < \u26032[FaceDirection.Constants.field_179177_d]) {
                \u26032[FaceDirection.Constants.field_179177_d] = \u26034;
            }
            if (f > \u26032[FaceDirection.Constants.field_179180_c]) {
                \u26032[FaceDirection.Constants.field_179180_c] = f;
            }
            if (\u2603 > \u26032[FaceDirection.Constants.field_179179_b]) {
                \u26032[FaceDirection.Constants.field_179179_b] = \u2603;
            }
            if (!(\u26034 > \u26032[FaceDirection.Constants.field_179181_a])) continue;
            \u26032[FaceDirection.Constants.field_179181_a] = \u26034;
        }
        FaceDirection \u26033 = FaceDirection.func_179027_a(direction2);
        for (int i = 0; i < 4; ++i) {
            \u2603 = 7 * i;
            FaceDirection.VertexInformation vertexInformation = \u26033.func_179025_a(i);
            float \u26034 = \u26032[vertexInformation.field_179184_a];
            float \u26035 = \u26032[vertexInformation.field_179182_b];
            float \u26036 = \u26032[vertexInformation.field_179183_c];
            nArray[\u2603] = Float.floatToRawIntBits(\u26034);
            nArray[\u2603 + 1] = Float.floatToRawIntBits(\u26035);
            nArray[\u2603 + 2] = Float.floatToRawIntBits(\u26036);
            for (int j = 0; j < 4; ++j) {
                \u2603 = 7 * j;
                float f = Float.intBitsToFloat(nArray2[\u2603]);
                \u2603 = Float.intBitsToFloat(nArray2[\u2603 + 1]);
                \u2603 = Float.intBitsToFloat(nArray2[\u2603 + 2]);
                if (!MathHelper.func_180185_a(\u26034, f) || !MathHelper.func_180185_a(\u26035, \u2603) || !MathHelper.func_180185_a(\u26036, \u2603)) continue;
                nArray[\u2603 + 4] = nArray2[\u2603 + 4];
                nArray[\u2603 + 4 + 1] = nArray2[\u2603 + 4 + 1];
            }
        }
    }

    private static void func_188013_a(ModelRotation modelRotation, Direction direction, Rotation rotation) {
        FaceBakery.field_188016_c[FaceBakery.func_188014_a((ModelRotation)modelRotation, (Direction)direction)] = rotation;
    }

    private static int func_188014_a(ModelRotation modelRotation, Direction direction) {
        return ModelRotation.values().length * direction.ordinal() + modelRotation.ordinal();
    }

    static {
        FaceBakery.func_188013_a(ModelRotation.X0_Y0, Direction.DOWN, field_188017_d);
        FaceBakery.func_188013_a(ModelRotation.X0_Y0, Direction.EAST, field_188017_d);
        FaceBakery.func_188013_a(ModelRotation.X0_Y0, Direction.NORTH, field_188017_d);
        FaceBakery.func_188013_a(ModelRotation.X0_Y0, Direction.SOUTH, field_188017_d);
        FaceBakery.func_188013_a(ModelRotation.X0_Y0, Direction.UP, field_188017_d);
        FaceBakery.func_188013_a(ModelRotation.X0_Y0, Direction.WEST, field_188017_d);
        FaceBakery.func_188013_a(ModelRotation.X0_Y90, Direction.EAST, field_188017_d);
        FaceBakery.func_188013_a(ModelRotation.X0_Y90, Direction.NORTH, field_188017_d);
        FaceBakery.func_188013_a(ModelRotation.X0_Y90, Direction.SOUTH, field_188017_d);
        FaceBakery.func_188013_a(ModelRotation.X0_Y90, Direction.WEST, field_188017_d);
        FaceBakery.func_188013_a(ModelRotation.X0_Y180, Direction.EAST, field_188017_d);
        FaceBakery.func_188013_a(ModelRotation.X0_Y180, Direction.NORTH, field_188017_d);
        FaceBakery.func_188013_a(ModelRotation.X0_Y180, Direction.SOUTH, field_188017_d);
        FaceBakery.func_188013_a(ModelRotation.X0_Y180, Direction.WEST, field_188017_d);
        FaceBakery.func_188013_a(ModelRotation.X0_Y270, Direction.EAST, field_188017_d);
        FaceBakery.func_188013_a(ModelRotation.X0_Y270, Direction.NORTH, field_188017_d);
        FaceBakery.func_188013_a(ModelRotation.X0_Y270, Direction.SOUTH, field_188017_d);
        FaceBakery.func_188013_a(ModelRotation.X0_Y270, Direction.WEST, field_188017_d);
        FaceBakery.func_188013_a(ModelRotation.X90_Y0, Direction.DOWN, field_188017_d);
        FaceBakery.func_188013_a(ModelRotation.X90_Y0, Direction.SOUTH, field_188017_d);
        FaceBakery.func_188013_a(ModelRotation.X90_Y90, Direction.DOWN, field_188017_d);
        FaceBakery.func_188013_a(ModelRotation.X90_Y180, Direction.DOWN, field_188017_d);
        FaceBakery.func_188013_a(ModelRotation.X90_Y180, Direction.NORTH, field_188017_d);
        FaceBakery.func_188013_a(ModelRotation.X90_Y270, Direction.DOWN, field_188017_d);
        FaceBakery.func_188013_a(ModelRotation.X180_Y0, Direction.DOWN, field_188017_d);
        FaceBakery.func_188013_a(ModelRotation.X180_Y0, Direction.UP, field_188017_d);
        FaceBakery.func_188013_a(ModelRotation.X270_Y0, Direction.SOUTH, field_188017_d);
        FaceBakery.func_188013_a(ModelRotation.X270_Y0, Direction.UP, field_188017_d);
        FaceBakery.func_188013_a(ModelRotation.X270_Y90, Direction.UP, field_188017_d);
        FaceBakery.func_188013_a(ModelRotation.X270_Y180, Direction.NORTH, field_188017_d);
        FaceBakery.func_188013_a(ModelRotation.X270_Y180, Direction.UP, field_188017_d);
        FaceBakery.func_188013_a(ModelRotation.X270_Y270, Direction.UP, field_188017_d);
        FaceBakery.func_188013_a(ModelRotation.X0_Y270, Direction.UP, field_188018_e);
        FaceBakery.func_188013_a(ModelRotation.X0_Y90, Direction.DOWN, field_188018_e);
        FaceBakery.func_188013_a(ModelRotation.X90_Y0, Direction.WEST, field_188018_e);
        FaceBakery.func_188013_a(ModelRotation.X90_Y90, Direction.WEST, field_188018_e);
        FaceBakery.func_188013_a(ModelRotation.X90_Y180, Direction.WEST, field_188018_e);
        FaceBakery.func_188013_a(ModelRotation.X90_Y270, Direction.NORTH, field_188018_e);
        FaceBakery.func_188013_a(ModelRotation.X90_Y270, Direction.SOUTH, field_188018_e);
        FaceBakery.func_188013_a(ModelRotation.X90_Y270, Direction.WEST, field_188018_e);
        FaceBakery.func_188013_a(ModelRotation.X180_Y90, Direction.UP, field_188018_e);
        FaceBakery.func_188013_a(ModelRotation.X180_Y270, Direction.DOWN, field_188018_e);
        FaceBakery.func_188013_a(ModelRotation.X270_Y0, Direction.EAST, field_188018_e);
        FaceBakery.func_188013_a(ModelRotation.X270_Y90, Direction.EAST, field_188018_e);
        FaceBakery.func_188013_a(ModelRotation.X270_Y90, Direction.NORTH, field_188018_e);
        FaceBakery.func_188013_a(ModelRotation.X270_Y90, Direction.SOUTH, field_188018_e);
        FaceBakery.func_188013_a(ModelRotation.X270_Y180, Direction.EAST, field_188018_e);
        FaceBakery.func_188013_a(ModelRotation.X270_Y270, Direction.EAST, field_188018_e);
        FaceBakery.func_188013_a(ModelRotation.X0_Y180, Direction.DOWN, field_188019_f);
        FaceBakery.func_188013_a(ModelRotation.X0_Y180, Direction.UP, field_188019_f);
        FaceBakery.func_188013_a(ModelRotation.X90_Y0, Direction.NORTH, field_188019_f);
        FaceBakery.func_188013_a(ModelRotation.X90_Y0, Direction.UP, field_188019_f);
        FaceBakery.func_188013_a(ModelRotation.X90_Y90, Direction.UP, field_188019_f);
        FaceBakery.func_188013_a(ModelRotation.X90_Y180, Direction.SOUTH, field_188019_f);
        FaceBakery.func_188013_a(ModelRotation.X90_Y180, Direction.UP, field_188019_f);
        FaceBakery.func_188013_a(ModelRotation.X90_Y270, Direction.UP, field_188019_f);
        FaceBakery.func_188013_a(ModelRotation.X180_Y0, Direction.EAST, field_188019_f);
        FaceBakery.func_188013_a(ModelRotation.X180_Y0, Direction.NORTH, field_188019_f);
        FaceBakery.func_188013_a(ModelRotation.X180_Y0, Direction.SOUTH, field_188019_f);
        FaceBakery.func_188013_a(ModelRotation.X180_Y0, Direction.WEST, field_188019_f);
        FaceBakery.func_188013_a(ModelRotation.X180_Y90, Direction.EAST, field_188019_f);
        FaceBakery.func_188013_a(ModelRotation.X180_Y90, Direction.NORTH, field_188019_f);
        FaceBakery.func_188013_a(ModelRotation.X180_Y90, Direction.SOUTH, field_188019_f);
        FaceBakery.func_188013_a(ModelRotation.X180_Y90, Direction.WEST, field_188019_f);
        FaceBakery.func_188013_a(ModelRotation.X180_Y180, Direction.DOWN, field_188019_f);
        FaceBakery.func_188013_a(ModelRotation.X180_Y180, Direction.EAST, field_188019_f);
        FaceBakery.func_188013_a(ModelRotation.X180_Y180, Direction.NORTH, field_188019_f);
        FaceBakery.func_188013_a(ModelRotation.X180_Y180, Direction.SOUTH, field_188019_f);
        FaceBakery.func_188013_a(ModelRotation.X180_Y180, Direction.UP, field_188019_f);
        FaceBakery.func_188013_a(ModelRotation.X180_Y180, Direction.WEST, field_188019_f);
        FaceBakery.func_188013_a(ModelRotation.X180_Y270, Direction.EAST, field_188019_f);
        FaceBakery.func_188013_a(ModelRotation.X180_Y270, Direction.NORTH, field_188019_f);
        FaceBakery.func_188013_a(ModelRotation.X180_Y270, Direction.SOUTH, field_188019_f);
        FaceBakery.func_188013_a(ModelRotation.X180_Y270, Direction.WEST, field_188019_f);
        FaceBakery.func_188013_a(ModelRotation.X270_Y0, Direction.DOWN, field_188019_f);
        FaceBakery.func_188013_a(ModelRotation.X270_Y0, Direction.NORTH, field_188019_f);
        FaceBakery.func_188013_a(ModelRotation.X270_Y90, Direction.DOWN, field_188019_f);
        FaceBakery.func_188013_a(ModelRotation.X270_Y180, Direction.DOWN, field_188019_f);
        FaceBakery.func_188013_a(ModelRotation.X270_Y180, Direction.SOUTH, field_188019_f);
        FaceBakery.func_188013_a(ModelRotation.X270_Y270, Direction.DOWN, field_188019_f);
        FaceBakery.func_188013_a(ModelRotation.X0_Y90, Direction.UP, field_188020_g);
        FaceBakery.func_188013_a(ModelRotation.X0_Y270, Direction.DOWN, field_188020_g);
        FaceBakery.func_188013_a(ModelRotation.X90_Y0, Direction.EAST, field_188020_g);
        FaceBakery.func_188013_a(ModelRotation.X90_Y90, Direction.EAST, field_188020_g);
        FaceBakery.func_188013_a(ModelRotation.X90_Y90, Direction.NORTH, field_188020_g);
        FaceBakery.func_188013_a(ModelRotation.X90_Y90, Direction.SOUTH, field_188020_g);
        FaceBakery.func_188013_a(ModelRotation.X90_Y180, Direction.EAST, field_188020_g);
        FaceBakery.func_188013_a(ModelRotation.X90_Y270, Direction.EAST, field_188020_g);
        FaceBakery.func_188013_a(ModelRotation.X270_Y0, Direction.WEST, field_188020_g);
        FaceBakery.func_188013_a(ModelRotation.X180_Y90, Direction.DOWN, field_188020_g);
        FaceBakery.func_188013_a(ModelRotation.X180_Y270, Direction.UP, field_188020_g);
        FaceBakery.func_188013_a(ModelRotation.X270_Y90, Direction.WEST, field_188020_g);
        FaceBakery.func_188013_a(ModelRotation.X270_Y180, Direction.WEST, field_188020_g);
        FaceBakery.func_188013_a(ModelRotation.X270_Y270, Direction.NORTH, field_188020_g);
        FaceBakery.func_188013_a(ModelRotation.X270_Y270, Direction.SOUTH, field_188020_g);
        FaceBakery.func_188013_a(ModelRotation.X270_Y270, Direction.WEST, field_188020_g);
    }

    static abstract class Rotation {
        private Rotation() {
        }

        public BlockFaceUV func_188006_a(BlockFaceUV blockFaceUV) {
            float f = blockFaceUV.func_178348_a(blockFaceUV.func_178345_c(0));
            \u2603 = blockFaceUV.func_178346_b(blockFaceUV.func_178345_c(0));
            \u2603 = blockFaceUV.func_178348_a(blockFaceUV.func_178345_c(2));
            \u2603 = blockFaceUV.func_178346_b(blockFaceUV.func_178345_c(2));
            return this.func_188007_a(f, \u2603, \u2603, \u2603);
        }

        abstract BlockFaceUV func_188007_a(float var1, float var2, float var3, float var4);
    }
}

