/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.entity.layers;

import com.google.common.collect.Maps;
import com.mojang.blaze3d.platform.GlStateManager;
import java.util.Map;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.entity.IEntityRenderer;
import net.minecraft.client.renderer.entity.layers.LayerRenderer;
import net.minecraft.client.renderer.entity.model.BipedModel;
import net.minecraft.client.renderer.entity.model.EntityModel;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ArmorItem;
import net.minecraft.item.DyeableArmorItem;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;

public abstract class ArmorLayer<T extends LivingEntity, M extends BipedModel<T>, A extends BipedModel<T>>
extends LayerRenderer<T, M> {
    protected static final ResourceLocation field_177188_b = new ResourceLocation("textures/misc/enchanted_item_glint.png");
    protected final A field_177189_c;
    protected final A field_177186_d;
    private float field_177187_e = 1.0f;
    private float field_177184_f = 1.0f;
    private float field_177185_g = 1.0f;
    private float field_177192_h = 1.0f;
    private boolean field_177193_i;
    private static final Map<String, ResourceLocation> field_177191_j = Maps.newHashMap();

    protected ArmorLayer(IEntityRenderer<T, M> iEntityRenderer, A a, A a2) {
        super(iEntityRenderer);
        this.field_177189_c = a;
        this.field_177186_d = a2;
    }

    @Override
    public void func_212842_a_(T t, float f, float f2, float f3, float f4, float f5, float f6, float f7) {
        this.func_188361_a(t, f, f2, f3, f4, f5, f6, f7, EquipmentSlotType.CHEST);
        this.func_188361_a(t, f, f2, f3, f4, f5, f6, f7, EquipmentSlotType.LEGS);
        this.func_188361_a(t, f, f2, f3, f4, f5, f6, f7, EquipmentSlotType.FEET);
        this.func_188361_a(t, f, f2, f3, f4, f5, f6, f7, EquipmentSlotType.HEAD);
    }

    @Override
    public boolean func_177142_b() {
        return false;
    }

    private void func_188361_a(T t, float f, float f2, float f3, float f4, float f5, float f6, float f7, EquipmentSlotType equipmentSlotType) {
        ItemStack itemStack = ((LivingEntity)t).func_184582_a(equipmentSlotType);
        if (!(itemStack.func_77973_b() instanceof ArmorItem)) {
            return;
        }
        ArmorItem \u26032 = (ArmorItem)itemStack.func_77973_b();
        if (\u26032.func_185083_B_() != equipmentSlotType) {
            return;
        }
        A \u26033 = this.func_215337_a(equipmentSlotType);
        ((BipedModel)this.func_215332_c()).func_217148_a(\u26033);
        ((BipedModel)\u26033).func_212843_a_(t, f, f2, f3);
        this.func_188359_a(\u26033, equipmentSlotType);
        boolean \u26034 = this.func_188363_b(equipmentSlotType);
        this.func_215333_a(this.func_177181_a(\u26032, \u26034));
        if (\u26032 instanceof DyeableArmorItem) {
            int n = ((DyeableArmorItem)\u26032).func_200886_f(itemStack);
            float \u26035 = (float)(n >> 16 & 0xFF) / 255.0f;
            float \u26036 = (float)(n >> 8 & 0xFF) / 255.0f;
            float \u26037 = (float)(n & 0xFF) / 255.0f;
            GlStateManager.color4f(this.field_177184_f * \u26035, this.field_177185_g * \u26036, this.field_177192_h * \u26037, this.field_177187_e);
            ((BipedModel)\u26033).func_78088_a(t, f, f2, f4, f5, f6, f7);
            this.func_215333_a(this.func_177178_a(\u26032, \u26034, "overlay"));
        }
        GlStateManager.color4f(this.field_177184_f, this.field_177185_g, this.field_177192_h, this.field_177187_e);
        ((BipedModel)\u26033).func_78088_a(t, f, f2, f4, f5, f6, f7);
        if (!this.field_177193_i && itemStack.func_77948_v()) {
            ArmorLayer.func_215338_a(this::func_215333_a, t, \u26033, f, f2, f3, f4, f5, f6, f7);
        }
    }

    public A func_215337_a(EquipmentSlotType equipmentSlotType) {
        return this.func_188363_b(equipmentSlotType) ? this.field_177189_c : this.field_177186_d;
    }

    private boolean func_188363_b(EquipmentSlotType equipmentSlotType) {
        return equipmentSlotType == EquipmentSlotType.LEGS;
    }

    public static <T extends Entity> void func_215338_a(Consumer<ResourceLocation> consumer, T t, EntityModel<T> entityModel, float f, float f2, float f3, float f4, float f5, float f6, float f7) {
        \u2603 = (float)t.field_70173_aa + f3;
        consumer.accept(field_177188_b);
        GameRenderer gameRenderer = Minecraft.func_71410_x().field_71460_t;
        gameRenderer.func_191514_d(true);
        GlStateManager.enableBlend();
        GlStateManager.depthFunc(514);
        GlStateManager.depthMask(false);
        float \u26032 = 0.5f;
        GlStateManager.color4f(0.5f, 0.5f, 0.5f, 1.0f);
        for (int i = 0; i < 2; ++i) {
            GlStateManager.disableLighting();
            GlStateManager.blendFunc(GlStateManager.SourceFactor.SRC_COLOR, GlStateManager.DestFactor.ONE);
            float f8 = 0.76f;
            GlStateManager.color4f(0.38f, 0.19f, 0.608f, 1.0f);
            GlStateManager.matrixMode(5890);
            GlStateManager.loadIdentity();
            \u2603 = 0.33333334f;
            GlStateManager.scalef(0.33333334f, 0.33333334f, 0.33333334f);
            GlStateManager.rotatef(30.0f - (float)i * 60.0f, 0.0f, 0.0f, 1.0f);
            GlStateManager.translatef(0.0f, \u2603 * (0.001f + (float)i * 0.003f) * 20.0f, 0.0f);
            GlStateManager.matrixMode(5888);
            entityModel.func_78088_a(t, f, f2, f4, f5, f6, f7);
            GlStateManager.blendFunc(GlStateManager.SourceFactor.ONE, GlStateManager.DestFactor.ZERO);
        }
        GlStateManager.matrixMode(5890);
        GlStateManager.loadIdentity();
        GlStateManager.matrixMode(5888);
        GlStateManager.enableLighting();
        GlStateManager.depthMask(true);
        GlStateManager.depthFunc(515);
        GlStateManager.disableBlend();
        gameRenderer.func_191514_d(false);
    }

    private ResourceLocation func_177181_a(ArmorItem armorItem, boolean bl) {
        return this.func_177178_a(armorItem, bl, null);
    }

    private ResourceLocation func_177178_a(ArmorItem armorItem, boolean bl, @Nullable String string) {
        \u2603 = "textures/models/armor/" + armorItem.func_200880_d().func_200897_d() + "_layer_" + (bl ? 2 : 1) + (string == null ? "" : "_" + string) + ".png";
        return field_177191_j.computeIfAbsent(\u2603, ResourceLocation::new);
    }

    protected abstract void func_188359_a(A var1, EquipmentSlotType var2);

    protected abstract void func_177194_a(A var1);
}

