/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.entity;

import com.mojang.blaze3d.platform.GlStateManager;
import net.minecraft.client.entity.player.AbstractClientPlayerEntity;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.client.renderer.entity.LivingRenderer;
import net.minecraft.client.renderer.entity.layers.ArrowLayer;
import net.minecraft.client.renderer.entity.layers.BipedArmorLayer;
import net.minecraft.client.renderer.entity.layers.CapeLayer;
import net.minecraft.client.renderer.entity.layers.Deadmau5HeadLayer;
import net.minecraft.client.renderer.entity.layers.ElytraLayer;
import net.minecraft.client.renderer.entity.layers.HeadLayer;
import net.minecraft.client.renderer.entity.layers.HeldItemLayer;
import net.minecraft.client.renderer.entity.layers.ParrotVariantLayer;
import net.minecraft.client.renderer.entity.layers.SpinAttackEffectLayer;
import net.minecraft.client.renderer.entity.model.BipedModel;
import net.minecraft.client.renderer.entity.model.PlayerModel;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerModelPart;
import net.minecraft.item.CrossbowItem;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.UseAction;
import net.minecraft.scoreboard.Score;
import net.minecraft.util.Hand;
import net.minecraft.util.HandSide;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;

public class PlayerRenderer
extends LivingRenderer<AbstractClientPlayerEntity, PlayerModel<AbstractClientPlayerEntity>> {
    public PlayerRenderer(EntityRendererManager entityRendererManager) {
        this(entityRendererManager, false);
    }

    public PlayerRenderer(EntityRendererManager entityRendererManager, boolean bl) {
        super(entityRendererManager, new PlayerModel(0.0f, bl), 0.5f);
        this.func_177094_a(new BipedArmorLayer(this, new BipedModel(0.5f), new BipedModel(1.0f)));
        this.func_177094_a(new HeldItemLayer<AbstractClientPlayerEntity, PlayerModel<AbstractClientPlayerEntity>>(this));
        this.func_177094_a(new ArrowLayer<AbstractClientPlayerEntity, PlayerModel<AbstractClientPlayerEntity>>(this));
        this.func_177094_a(new Deadmau5HeadLayer(this));
        this.func_177094_a(new CapeLayer(this));
        this.func_177094_a(new HeadLayer<AbstractClientPlayerEntity, PlayerModel<AbstractClientPlayerEntity>>(this));
        this.func_177094_a(new ElytraLayer<AbstractClientPlayerEntity, PlayerModel<AbstractClientPlayerEntity>>(this));
        this.func_177094_a(new ParrotVariantLayer<AbstractClientPlayerEntity>(this));
        this.func_177094_a(new SpinAttackEffectLayer<AbstractClientPlayerEntity>(this));
    }

    @Override
    public void func_76986_a(AbstractClientPlayerEntity abstractClientPlayerEntity, double d, double d2, double d3, float f, float f2) {
        if (abstractClientPlayerEntity.func_175144_cb() && this.field_76990_c.field_217783_c.func_216773_g() != abstractClientPlayerEntity) {
            return;
        }
        double d4 = d2;
        if (abstractClientPlayerEntity.func_213287_bg()) {
            d4 -= 0.125;
        }
        this.func_177137_d(abstractClientPlayerEntity);
        GlStateManager.setProfile(GlStateManager.Profile.PLAYER_SKIN);
        super.func_76986_a(abstractClientPlayerEntity, d, d4, d3, f, f2);
        GlStateManager.unsetProfile(GlStateManager.Profile.PLAYER_SKIN);
    }

    private void func_177137_d(AbstractClientPlayerEntity abstractClientPlayerEntity) {
        PlayerModel playerModel = (PlayerModel)this.func_217764_d();
        if (abstractClientPlayerEntity.func_175149_v()) {
            playerModel.func_178719_a(false);
            playerModel.field_78116_c.field_78806_j = true;
            playerModel.field_178720_f.field_78806_j = true;
        } else {
            ItemStack itemStack = abstractClientPlayerEntity.func_184614_ca();
            \u2603 = abstractClientPlayerEntity.func_184592_cb();
            playerModel.func_178719_a(true);
            playerModel.field_178720_f.field_78806_j = abstractClientPlayerEntity.func_175148_a(PlayerModelPart.HAT);
            playerModel.field_178730_v.field_78806_j = abstractClientPlayerEntity.func_175148_a(PlayerModelPart.JACKET);
            playerModel.field_178733_c.field_78806_j = abstractClientPlayerEntity.func_175148_a(PlayerModelPart.LEFT_PANTS_LEG);
            playerModel.field_178731_d.field_78806_j = abstractClientPlayerEntity.func_175148_a(PlayerModelPart.RIGHT_PANTS_LEG);
            playerModel.field_178734_a.field_78806_j = abstractClientPlayerEntity.func_175148_a(PlayerModelPart.LEFT_SLEEVE);
            playerModel.field_178732_b.field_78806_j = abstractClientPlayerEntity.func_175148_a(PlayerModelPart.RIGHT_SLEEVE);
            playerModel.field_78117_n = abstractClientPlayerEntity.func_213287_bg();
            BipedModel.ArmPose \u26032 = this.func_217766_a(abstractClientPlayerEntity, itemStack, \u2603, Hand.MAIN_HAND);
            BipedModel.ArmPose \u26033 = this.func_217766_a(abstractClientPlayerEntity, itemStack, \u2603, Hand.OFF_HAND);
            if (abstractClientPlayerEntity.func_184591_cq() == HandSide.RIGHT) {
                playerModel.field_187076_m = \u26032;
                playerModel.field_187075_l = \u26033;
            } else {
                playerModel.field_187076_m = \u26033;
                playerModel.field_187075_l = \u26032;
            }
        }
    }

    private BipedModel.ArmPose func_217766_a(AbstractClientPlayerEntity abstractClientPlayerEntity, ItemStack itemStack4, ItemStack itemStack2, Hand hand) {
        BipedModel.ArmPose armPose = BipedModel.ArmPose.EMPTY;
        ItemStack itemStack3 = \u2603 = hand == Hand.MAIN_HAND ? itemStack4 : itemStack2;
        if (!\u2603.func_190926_b()) {
            armPose = BipedModel.ArmPose.ITEM;
            if (abstractClientPlayerEntity.func_184605_cv() > 0) {
                UseAction useAction = \u2603.func_77975_n();
                if (useAction == UseAction.BLOCK) {
                    armPose = BipedModel.ArmPose.BLOCK;
                } else if (useAction == UseAction.BOW) {
                    armPose = BipedModel.ArmPose.BOW_AND_ARROW;
                } else if (useAction == UseAction.SPEAR) {
                    armPose = BipedModel.ArmPose.THROW_SPEAR;
                } else if (useAction == UseAction.CROSSBOW && hand == abstractClientPlayerEntity.func_184600_cs()) {
                    armPose = BipedModel.ArmPose.CROSSBOW_CHARGE;
                }
            } else {
                ItemStack itemStack4;
                boolean \u26032 = itemStack4.func_77973_b() == Items.field_222114_py;
                boolean \u26033 = CrossbowItem.func_220012_d(itemStack4);
                boolean \u26034 = itemStack2.func_77973_b() == Items.field_222114_py;
                boolean \u26035 = CrossbowItem.func_220012_d(itemStack2);
                if (\u26032 && \u26033) {
                    armPose = BipedModel.ArmPose.CROSSBOW_HOLD;
                }
                if (\u26034 && \u26035 && itemStack4.func_77973_b().func_77661_b(itemStack4) == UseAction.NONE) {
                    armPose = BipedModel.ArmPose.CROSSBOW_HOLD;
                }
            }
        }
        return armPose;
    }

    @Override
    public ResourceLocation func_110775_a(AbstractClientPlayerEntity abstractClientPlayerEntity) {
        return abstractClientPlayerEntity.func_110306_p();
    }

    @Override
    protected void func_77041_b(AbstractClientPlayerEntity abstractClientPlayerEntity, float f) {
        \u2603 = 0.9375f;
        GlStateManager.scalef(0.9375f, 0.9375f, 0.9375f);
    }

    @Override
    protected void func_188296_a(AbstractClientPlayerEntity abstractClientPlayerEntity2, double d, double d2, double d3, String string, double d4) {
        AbstractClientPlayerEntity abstractClientPlayerEntity2;
        if (d4 < 100.0 && (\u2603 = (\u2603 = abstractClientPlayerEntity2.func_96123_co()).func_96539_a(2)) != null) {
            Score score = \u2603.func_96529_a(abstractClientPlayerEntity2.func_195047_I_(), \u2603);
            this.func_147906_a(abstractClientPlayerEntity2, score.func_96652_c() + " " + \u2603.func_96678_d().func_150254_d(), d, d2, d3, 64);
            this.func_76983_a().getClass();
            d2 += (double)(9.0f * 1.15f * 0.025f);
        }
        super.func_188296_a(abstractClientPlayerEntity2, d, d2, d3, string, d4);
    }

    public void func_177138_b(AbstractClientPlayerEntity abstractClientPlayerEntity) {
        float f = 1.0f;
        GlStateManager.color3f(1.0f, 1.0f, 1.0f);
        \u2603 = 0.0625f;
        PlayerModel \u26032 = (PlayerModel)this.func_217764_d();
        this.func_177137_d(abstractClientPlayerEntity);
        GlStateManager.enableBlend();
        \u26032.field_217112_c = 0.0f;
        \u26032.field_78117_n = false;
        \u26032.field_205061_a = 0.0f;
        \u26032.func_212844_a_(abstractClientPlayerEntity, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0625f);
        \u26032.field_178723_h.field_78795_f = 0.0f;
        \u26032.field_178723_h.func_78785_a(0.0625f);
        \u26032.field_178732_b.field_78795_f = 0.0f;
        \u26032.field_178732_b.func_78785_a(0.0625f);
        GlStateManager.disableBlend();
    }

    public void func_177139_c(AbstractClientPlayerEntity abstractClientPlayerEntity) {
        float f = 1.0f;
        GlStateManager.color3f(1.0f, 1.0f, 1.0f);
        \u2603 = 0.0625f;
        PlayerModel \u26032 = (PlayerModel)this.func_217764_d();
        this.func_177137_d(abstractClientPlayerEntity);
        GlStateManager.enableBlend();
        \u26032.field_78117_n = false;
        \u26032.field_217112_c = 0.0f;
        \u26032.field_205061_a = 0.0f;
        \u26032.func_212844_a_(abstractClientPlayerEntity, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0625f);
        \u26032.field_178724_i.field_78795_f = 0.0f;
        \u26032.field_178724_i.func_78785_a(0.0625f);
        \u26032.field_178734_a.field_78795_f = 0.0f;
        \u26032.field_178734_a.func_78785_a(0.0625f);
        GlStateManager.disableBlend();
    }

    @Override
    protected void func_77043_a(AbstractClientPlayerEntity abstractClientPlayerEntity, float f, float f2, float f3) {
        float f4;
        f4 = abstractClientPlayerEntity.func_205015_b(f3);
        if (abstractClientPlayerEntity.func_184613_cA()) {
            super.func_77043_a(abstractClientPlayerEntity, f, f2, f3);
            \u2603 = (float)abstractClientPlayerEntity.func_184599_cB() + f3;
            \u2603 = MathHelper.func_76131_a(\u2603 * \u2603 / 100.0f, 0.0f, 1.0f);
            if (!abstractClientPlayerEntity.func_204805_cN()) {
                GlStateManager.rotatef(\u2603 * (-90.0f - abstractClientPlayerEntity.field_70125_A), 1.0f, 0.0f, 0.0f);
            }
            Vec3d vec3d = abstractClientPlayerEntity.func_70676_i(f3);
            \u2603 = abstractClientPlayerEntity.func_213322_ci();
            double \u26032 = Entity.func_213296_b(\u2603);
            double \u26033 = Entity.func_213296_b(vec3d);
            if (\u26032 > 0.0 && \u26033 > 0.0) {
                double d = (\u2603.field_72450_a * vec3d.field_72450_a + \u2603.field_72449_c * vec3d.field_72449_c) / (Math.sqrt(\u26032) * Math.sqrt(\u26033));
                \u2603 = \u2603.field_72450_a * vec3d.field_72449_c - \u2603.field_72449_c * vec3d.field_72450_a;
                GlStateManager.rotatef((float)(Math.signum(\u2603) * Math.acos(d)) * 180.0f / (float)Math.PI, 0.0f, 1.0f, 0.0f);
            }
        } else if (f4 > 0.0f) {
            super.func_77043_a(abstractClientPlayerEntity, f, f2, f3);
            \u2603 = abstractClientPlayerEntity.func_70090_H() ? -90.0f - abstractClientPlayerEntity.field_70125_A : -90.0f;
            \u2603 = MathHelper.func_219799_g(f4, 0.0f, \u2603);
            GlStateManager.rotatef(\u2603, 1.0f, 0.0f, 0.0f);
            if (abstractClientPlayerEntity.func_213314_bj()) {
                GlStateManager.translatef(0.0f, -1.0f, 0.3f);
            }
        } else {
            super.func_77043_a(abstractClientPlayerEntity, f, f2, f3);
        }
    }
}

