/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.debug;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.mojang.blaze3d.platform.GlStateManager;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.renderer.ActiveRenderInfo;
import net.minecraft.client.renderer.debug.DebugRenderer;
import net.minecraft.client.renderer.debug.PathfindingDebugRenderer;
import net.minecraft.dispenser.IPosition;
import net.minecraft.pathfinding.Path;
import net.minecraft.util.RandomObjectDescriptor;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.SectionPos;
import net.minecraft.util.math.Vec3i;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class PointOfInterestDebugRenderer
implements DebugRenderer.IDebugRenderer {
    private static final Logger field_217711_a = LogManager.getLogger();
    private final Minecraft field_217712_b;
    private final Map<BlockPos, POIInfo> field_217713_c = Maps.newHashMap();
    private final Set<SectionPos> field_217714_d = Sets.newHashSet();
    private final Map<UUID, BrainInfo> field_217715_e = Maps.newHashMap();
    private UUID field_217716_f;

    public PointOfInterestDebugRenderer(Minecraft minecraft) {
        this.field_217712_b = minecraft;
    }

    @Override
    public void func_217675_a() {
        this.field_217713_c.clear();
        this.field_217714_d.clear();
        this.field_217715_e.clear();
        this.field_217716_f = null;
    }

    public void func_217691_a(POIInfo pOIInfo) {
        this.field_217713_c.put(pOIInfo.field_217755_a, pOIInfo);
    }

    public void func_217698_a(BlockPos blockPos) {
        this.field_217713_c.remove(blockPos);
    }

    public void func_217706_a(BlockPos blockPos, int n) {
        POIInfo pOIInfo = this.field_217713_c.get(blockPos);
        if (pOIInfo == null) {
            field_217711_a.warn("Strange, setFreeTicketCount was called for an unknown POI: " + blockPos);
            return;
        }
        pOIInfo.field_217757_c = n;
    }

    public void func_217701_a(SectionPos sectionPos) {
        this.field_217714_d.add(sectionPos);
    }

    public void func_217700_b(SectionPos sectionPos) {
        this.field_217714_d.remove(sectionPos);
    }

    public void func_217692_a(BrainInfo brainInfo) {
        this.field_217715_e.put(brainInfo.field_217747_a, brainInfo);
    }

    @Override
    public void func_217676_a(long l) {
        GlStateManager.pushMatrix();
        GlStateManager.enableBlend();
        GlStateManager.blendFuncSeparate(GlStateManager.SourceFactor.SRC_ALPHA, GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, GlStateManager.SourceFactor.ONE, GlStateManager.DestFactor.ZERO);
        GlStateManager.disableTexture();
        this.func_217708_b();
        GlStateManager.enableTexture();
        GlStateManager.disableBlend();
        GlStateManager.popMatrix();
        if (!this.field_217712_b.field_71439_g.func_175149_v()) {
            this.func_217710_d();
        }
    }

    private void func_217708_b() {
        BlockPos blockPos = this.func_217709_c().func_216780_d();
        this.field_217714_d.forEach(sectionPos -> {
            if (blockPos.func_218141_a(sectionPos.func_218160_t(), 60.0)) {
                PointOfInterestDebugRenderer.func_217702_c(sectionPos);
            }
        });
        this.field_217715_e.values().forEach(brainInfo -> {
            if (this.func_217694_d((BrainInfo)brainInfo)) {
                this.func_217704_b((BrainInfo)brainInfo);
            }
        });
        for (BlockPos blockPos3 : this.field_217713_c.keySet()) {
            if (!blockPos.func_218141_a(blockPos3, 30.0)) continue;
            PointOfInterestDebugRenderer.func_217699_b(blockPos3);
        }
        this.field_217713_c.values().forEach(pOIInfo -> {
            if (blockPos.func_218141_a(pOIInfo.field_217755_a, 30.0)) {
                this.func_217705_b((POIInfo)pOIInfo);
            }
        });
        this.func_222915_d().forEach((blockPos2, list) -> {
            if (blockPos.func_218141_a((Vec3i)blockPos2, 30.0)) {
                this.func_222921_a((BlockPos)blockPos2, (List<String>)list);
            }
        });
    }

    private static void func_217702_c(SectionPos sectionPos) {
        float f = 1.0f;
        BlockPos \u26032 = sectionPos.func_218160_t();
        BlockPos \u26033 = \u26032.func_177963_a(-1.0, -1.0, -1.0);
        BlockPos \u26034 = \u26032.func_177963_a(1.0, 1.0, 1.0);
        DebugRenderer.func_217735_a(\u26033, \u26034, 0.2f, 1.0f, 0.2f, 0.15f);
    }

    private static void func_217699_b(BlockPos blockPos) {
        float f = 0.05f;
        DebugRenderer.func_217736_a(blockPos, 0.05f, 0.2f, 0.2f, 1.0f, 0.3f);
    }

    private void func_222921_a(BlockPos blockPos, List<String> list) {
        float f = 0.05f;
        DebugRenderer.func_217736_a(blockPos, 0.05f, 0.2f, 0.2f, 1.0f, 0.3f);
        PointOfInterestDebugRenderer.func_222923_a("" + list, blockPos, 0, -256);
        PointOfInterestDebugRenderer.func_222923_a("Ghost POI", blockPos, 1, -65536);
    }

    private void func_217705_b(POIInfo pOIInfo) {
        int n = 0;
        if (this.func_217696_c(pOIInfo).size() < 4) {
            PointOfInterestDebugRenderer.func_217695_a("" + this.func_217696_c(pOIInfo), pOIInfo, n, -256);
        } else {
            PointOfInterestDebugRenderer.func_217695_a("" + this.func_217696_c(pOIInfo).size() + " ticket holders", pOIInfo, n, -256);
        }
        PointOfInterestDebugRenderer.func_217695_a("Free tickets: " + pOIInfo.field_217757_c, pOIInfo, ++n, -256);
        PointOfInterestDebugRenderer.func_217695_a(pOIInfo.field_217756_b, pOIInfo, ++n, -1);
    }

    private void func_222918_b(BrainInfo brainInfo) {
        if (brainInfo.field_222930_g != null) {
            PathfindingDebugRenderer.func_222911_a(this.func_217709_c(), brainInfo.field_222930_g, 0.5f, false, false);
        }
    }

    private void func_217704_b(BrainInfo brainInfo2) {
        BrainInfo brainInfo2;
        boolean bl = this.func_217703_c(brainInfo2);
        int \u26032 = 0;
        PointOfInterestDebugRenderer.func_217693_a(brainInfo2.field_217750_d, \u26032, brainInfo2.field_217749_c, -1, 0.03f);
        ++\u26032;
        if (bl) {
            PointOfInterestDebugRenderer.func_217693_a(brainInfo2.field_217750_d, \u26032, brainInfo2.field_222928_d + " " + brainInfo2.field_222929_e + "xp", -1, 0.02f);
            ++\u26032;
        }
        if (bl && !brainInfo2.field_223455_g.equals("")) {
            PointOfInterestDebugRenderer.func_217693_a(brainInfo2.field_217750_d, \u26032, brainInfo2.field_223455_g, -98404, 0.02f);
            ++\u26032;
        }
        if (bl) {
            for (String string : brainInfo2.field_217752_f) {
                PointOfInterestDebugRenderer.func_217693_a(brainInfo2.field_217750_d, \u26032, string, -16711681, 0.02f);
                ++\u26032;
            }
        }
        if (bl) {
            for (String string : brainInfo2.field_217751_e) {
                PointOfInterestDebugRenderer.func_217693_a(brainInfo2.field_217750_d, \u26032, string, -16711936, 0.02f);
                ++\u26032;
            }
        }
        if (brainInfo2.field_223456_i) {
            PointOfInterestDebugRenderer.func_217693_a(brainInfo2.field_217750_d, \u26032, "Wants Golem", -23296, 0.02f);
            ++\u26032;
        }
        if (bl) {
            for (String string : brainInfo2.field_223457_m) {
                if (string.startsWith(brainInfo2.field_217749_c)) {
                    PointOfInterestDebugRenderer.func_217693_a(brainInfo2.field_217750_d, \u26032, string, -1, 0.02f);
                } else {
                    PointOfInterestDebugRenderer.func_217693_a(brainInfo2.field_217750_d, \u26032, string, -23296, 0.02f);
                }
                ++\u26032;
            }
        }
        if (bl) {
            for (String string : Lists.reverse(brainInfo2.field_217753_g)) {
                PointOfInterestDebugRenderer.func_217693_a(brainInfo2.field_217750_d, \u26032, string, -3355444, 0.02f);
                ++\u26032;
            }
        }
        if (bl) {
            this.func_222918_b(brainInfo2);
        }
    }

    private static void func_217695_a(String string, POIInfo pOIInfo, int n, int n2) {
        BlockPos blockPos = pOIInfo.field_217755_a;
        PointOfInterestDebugRenderer.func_222923_a(string, blockPos, n, n2);
    }

    private static void func_222923_a(String string, BlockPos blockPos, int n, int n2) {
        double d = 1.3;
        \u2603 = 0.2;
        \u2603 = (double)blockPos.func_177958_n() + 0.5;
        \u2603 = (double)blockPos.func_177956_o() + 1.3 + (double)n * 0.2;
        \u2603 = (double)blockPos.func_177952_p() + 0.5;
        DebugRenderer.func_217734_a(string, \u2603, \u2603, \u2603, n2, 0.02f, true, 0.0f, true);
    }

    private static void func_217693_a(IPosition iPosition, int n, String string, int n2, float f) {
        double d = 2.4;
        \u2603 = 0.25;
        BlockPos \u26032 = new BlockPos(iPosition);
        \u2603 = (double)\u26032.func_177958_n() + 0.5;
        \u2603 = iPosition.func_82617_b() + 2.4 + (double)n * 0.25;
        \u2603 = (double)\u26032.func_177952_p() + 0.5;
        float \u26033 = 0.5f;
        DebugRenderer.func_217734_a(string, \u2603, \u2603, \u2603, n2, f, false, 0.5f, true);
    }

    private ActiveRenderInfo func_217709_c() {
        return this.field_217712_b.field_71460_t.func_215316_n();
    }

    private Set<String> func_217696_c(POIInfo pOIInfo) {
        return this.func_217697_c(pOIInfo.field_217755_a).stream().map(RandomObjectDescriptor::func_218810_a).collect(Collectors.toSet());
    }

    private boolean func_217703_c(BrainInfo brainInfo) {
        return Objects.equals(this.field_217716_f, brainInfo.field_217747_a);
    }

    private boolean func_217694_d(BrainInfo brainInfo) {
        ClientPlayerEntity clientPlayerEntity = this.field_217712_b.field_71439_g;
        BlockPos \u26032 = new BlockPos(clientPlayerEntity.field_70165_t, brainInfo.field_217750_d.func_82617_b(), clientPlayerEntity.field_70161_v);
        BlockPos \u26033 = new BlockPos(brainInfo.field_217750_d);
        return \u26032.func_218141_a(\u26033, 30.0);
    }

    private Collection<UUID> func_217697_c(BlockPos blockPos) {
        return this.field_217715_e.values().stream().filter(brainInfo -> ((BrainInfo)brainInfo).func_217744_a(blockPos)).map(BrainInfo::func_217746_a).collect(Collectors.toSet());
    }

    private Map<BlockPos, List<String>> func_222915_d() {
        HashMap hashMap = Maps.newHashMap();
        for (BrainInfo brainInfo : this.field_217715_e.values()) {
            for (BlockPos blockPos : brainInfo.field_217754_h) {
                if (this.field_217713_c.containsKey(blockPos)) continue;
                List list = (List)hashMap.get(blockPos);
                if (list == null) {
                    list = Lists.newArrayList();
                    hashMap.put(blockPos, list);
                }
                list.add(brainInfo.field_217749_c);
            }
        }
        return hashMap;
    }

    private void func_217710_d() {
        DebugRenderer.func_217728_a(this.field_217712_b.func_175606_aa(), 8).ifPresent(entity -> {
            this.field_217716_f = entity.func_110124_au();
        });
    }

    public static class BrainInfo {
        public final UUID field_217747_a;
        public final int field_217748_b;
        public final String field_217749_c;
        public final String field_222928_d;
        public final int field_222929_e;
        public final IPosition field_217750_d;
        public final String field_223455_g;
        public final Path field_222930_g;
        public final boolean field_223456_i;
        public final List<String> field_217751_e = Lists.newArrayList();
        public final List<String> field_217752_f = Lists.newArrayList();
        public final List<String> field_217753_g = Lists.newArrayList();
        public final List<String> field_223457_m = Lists.newArrayList();
        public final Set<BlockPos> field_217754_h = Sets.newHashSet();

        public BrainInfo(UUID uUID, int n, String string, String string2, int n2, IPosition iPosition, String string3, @Nullable Path path, boolean bl) {
            this.field_217747_a = uUID;
            this.field_217748_b = n;
            this.field_217749_c = string;
            this.field_222928_d = string2;
            this.field_222929_e = n2;
            this.field_217750_d = iPosition;
            this.field_223455_g = string3;
            this.field_222930_g = path;
            this.field_223456_i = bl;
        }

        private boolean func_217744_a(BlockPos blockPos) {
            return this.field_217754_h.stream().anyMatch(blockPos::equals);
        }

        public UUID func_217746_a() {
            return this.field_217747_a;
        }
    }

    public static class POIInfo {
        public final BlockPos field_217755_a;
        public String field_217756_b;
        public int field_217757_c;

        public POIInfo(BlockPos blockPos, String string, int n) {
            this.field_217755_a = blockPos;
            this.field_217756_b = string;
            this.field_217757_c = n;
        }
    }
}

