/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.color;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.RedstoneWireBlock;
import net.minecraft.block.ShearableDoublePlantBlock;
import net.minecraft.block.StemBlock;
import net.minecraft.block.material.MaterialColor;
import net.minecraft.client.renderer.color.IBlockColor;
import net.minecraft.state.IProperty;
import net.minecraft.state.properties.DoubleBlockHalf;
import net.minecraft.util.ObjectIntIdentityMap;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.FoliageColors;
import net.minecraft.world.GrassColors;
import net.minecraft.world.IEnviromentBlockReader;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeColors;

public class BlockColors {
    private final ObjectIntIdentityMap<IBlockColor> field_186725_a = new ObjectIntIdentityMap(32);
    private final Map<Block, Set<IProperty<?>>> field_225311_b = Maps.newHashMap();

    public static BlockColors func_186723_a() {
        BlockColors blockColors = new BlockColors();
        blockColors.func_186722_a((blockState, iEnviromentBlockReader, blockPos, n) -> {
            if (iEnviromentBlockReader == null || blockPos == null) {
                return -1;
            }
            return BiomeColors.func_217613_a(iEnviromentBlockReader, blockState.func_177229_b(ShearableDoublePlantBlock.field_208063_b) == DoubleBlockHalf.UPPER ? blockPos.func_177977_b() : blockPos);
        }, Blocks.field_196805_gi, Blocks.field_196804_gh);
        blockColors.func_225308_a(ShearableDoublePlantBlock.field_208063_b, Blocks.field_196805_gi, Blocks.field_196804_gh);
        blockColors.func_186722_a((blockState, iEnviromentBlockReader, blockPos, n) -> {
            if (iEnviromentBlockReader == null || blockPos == null) {
                return GrassColors.func_77480_a(0.5, 1.0);
            }
            return BiomeColors.func_217613_a(iEnviromentBlockReader, blockPos);
        }, Blocks.field_196658_i, Blocks.field_196554_aH, Blocks.field_150349_c, Blocks.field_196683_eB);
        blockColors.func_186722_a((blockState, iEnviromentBlockReader, blockPos, n) -> FoliageColors.func_77466_a(), Blocks.field_196645_X);
        blockColors.func_186722_a((blockState, iEnviromentBlockReader, blockPos, n) -> FoliageColors.func_77469_b(), Blocks.field_196647_Y);
        blockColors.func_186722_a((blockState, iEnviromentBlockReader, blockPos, n) -> {
            if (iEnviromentBlockReader == null || blockPos == null) {
                return FoliageColors.func_77468_c();
            }
            return BiomeColors.func_217615_b(iEnviromentBlockReader, blockPos);
        }, Blocks.field_196642_W, Blocks.field_196648_Z, Blocks.field_196572_aa, Blocks.field_196574_ab, Blocks.field_150395_bd);
        blockColors.func_186722_a((blockState, iEnviromentBlockReader, blockPos, n) -> {
            if (iEnviromentBlockReader == null || blockPos == null) {
                return -1;
            }
            return BiomeColors.func_217612_c(iEnviromentBlockReader, blockPos);
        }, Blocks.field_150355_j, Blocks.field_203203_C, Blocks.field_150383_bp);
        blockColors.func_186722_a((blockState, iEnviromentBlockReader, blockPos, n) -> RedstoneWireBlock.func_176337_b(blockState.func_177229_b(RedstoneWireBlock.field_176351_O)), Blocks.field_150488_af);
        blockColors.func_225308_a(RedstoneWireBlock.field_176351_O, Blocks.field_150488_af);
        blockColors.func_186722_a((blockState, iEnviromentBlockReader, blockPos, n) -> {
            if (iEnviromentBlockReader == null || blockPos == null) {
                return -1;
            }
            return BiomeColors.func_217613_a(iEnviromentBlockReader, blockPos);
        }, Blocks.field_196608_cF);
        blockColors.func_186722_a((blockState, iEnviromentBlockReader, blockPos, n) -> 14731036, Blocks.field_196713_dt, Blocks.field_196711_ds);
        blockColors.func_186722_a((blockState, iEnviromentBlockReader, blockPos, n) -> {
            \u2603 = blockState.func_177229_b(StemBlock.field_176484_a);
            \u2603 = \u2603 * 32;
            \u2603 = 255 - \u2603 * 8;
            \u2603 = \u2603 * 4;
            return \u2603 << 16 | \u2603 << 8 | \u2603;
        }, Blocks.field_150394_bc, Blocks.field_150393_bb);
        blockColors.func_225308_a(StemBlock.field_176484_a, Blocks.field_150394_bc, Blocks.field_150393_bb);
        blockColors.func_186722_a((blockState, iEnviromentBlockReader, blockPos, n) -> {
            if (iEnviromentBlockReader == null || blockPos == null) {
                return 7455580;
            }
            return 2129968;
        }, Blocks.field_196651_dG);
        return blockColors;
    }

    public int func_189991_a(BlockState blockState, World world, BlockPos blockPos) {
        IBlockColor iBlockColor = this.field_186725_a.func_148745_a(Registry.field_212618_g.func_148757_b(blockState.func_177230_c()));
        if (iBlockColor != null) {
            return iBlockColor.getColor(blockState, null, null, 0);
        }
        MaterialColor \u26032 = blockState.func_185909_g(world, blockPos);
        return \u26032 != null ? \u26032.field_76291_p : -1;
    }

    public int func_216860_a(BlockState blockState, @Nullable IEnviromentBlockReader iEnviromentBlockReader, @Nullable BlockPos blockPos, int n) {
        IBlockColor iBlockColor = this.field_186725_a.func_148745_a(Registry.field_212618_g.func_148757_b(blockState.func_177230_c()));
        return iBlockColor == null ? -1 : iBlockColor.getColor(blockState, iEnviromentBlockReader, blockPos, n);
    }

    public void func_186722_a(IBlockColor iBlockColor, Block ... blockArray) {
        for (Block block : blockArray) {
            this.field_186725_a.func_148746_a(iBlockColor, Registry.field_212618_g.func_148757_b(block));
        }
    }

    private void func_225309_a(Set<IProperty<?>> set, Block ... blockArray) {
        for (Block block : blockArray) {
            this.field_225311_b.put(block, set);
        }
    }

    private void func_225308_a(IProperty<?> iProperty, Block ... blockArray) {
        this.func_225309_a((Set<IProperty<?>>)ImmutableSet.of(iProperty), blockArray);
    }

    public Set<IProperty<?>> func_225310_a(Block block) {
        return (Set)this.field_225311_b.getOrDefault(block, (Set<IProperty<?>>)ImmutableSet.of());
    }
}

