/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.chunk;

import com.google.common.collect.Sets;
import com.mojang.blaze3d.platform.GLX;
import java.util.HashSet;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.locks.ReentrantLock;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRenderType;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.ActiveRenderInfo;
import net.minecraft.client.renderer.BlockModelRenderer;
import net.minecraft.client.renderer.BlockRendererDispatcher;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.WorldRenderer;
import net.minecraft.client.renderer.chunk.ChunkRenderCache;
import net.minecraft.client.renderer.chunk.ChunkRenderTask;
import net.minecraft.client.renderer.chunk.CompiledChunk;
import net.minecraft.client.renderer.chunk.VisGraph;
import net.minecraft.client.renderer.tileentity.TileEntityRenderer;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.renderer.vertex.VertexBuffer;
import net.minecraft.fluid.IFluidState;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.Direction;
import net.minecraft.util.Util;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;

public class ChunkRender {
    private volatile World field_178588_d;
    private final WorldRenderer field_178589_e;
    public static int field_178592_a;
    public CompiledChunk field_178590_b = CompiledChunk.field_178502_a;
    private final ReentrantLock field_178587_g = new ReentrantLock();
    private final ReentrantLock field_178598_h = new ReentrantLock();
    private ChunkRenderTask field_178599_i;
    private final Set<TileEntity> field_181056_j = Sets.newHashSet();
    private final VertexBuffer[] field_178594_l = new VertexBuffer[BlockRenderLayer.values().length];
    public AxisAlignedBB field_178591_c;
    private int field_178595_m = -1;
    private boolean field_178593_n = true;
    private final BlockPos.MutableBlockPos field_178586_f = new BlockPos.MutableBlockPos(-1, -1, -1);
    private final BlockPos.MutableBlockPos[] field_181702_p = Util.func_200696_a(new BlockPos.MutableBlockPos[6], mutableBlockPosArray -> {
        for (int i = 0; i < ((BlockPos.MutableBlockPos[])mutableBlockPosArray).length; ++i) {
            mutableBlockPosArray[i] = new BlockPos.MutableBlockPos();
        }
    });
    private boolean field_188284_q;

    public ChunkRender(World world, WorldRenderer worldRenderer) {
        this.field_178588_d = world;
        this.field_178589_e = worldRenderer;
        if (GLX.useVbo()) {
            for (int i = 0; i < BlockRenderLayer.values().length; ++i) {
                this.field_178594_l[i] = new VertexBuffer(DefaultVertexFormats.field_176600_a);
            }
        }
    }

    private static boolean func_217673_a(BlockPos blockPos, World world) {
        return !world.func_212866_a_(blockPos.func_177958_n() >> 4, blockPos.func_177952_p() >> 4).func_76621_g();
    }

    public boolean func_217674_b() {
        int n = 24;
        if (this.func_188280_f() > 576.0) {
            World world = this.func_188283_p();
            return ChunkRender.func_217673_a(this.field_181702_p[Direction.WEST.ordinal()], world) && ChunkRender.func_217673_a(this.field_181702_p[Direction.NORTH.ordinal()], world) && ChunkRender.func_217673_a(this.field_181702_p[Direction.EAST.ordinal()], world) && ChunkRender.func_217673_a(this.field_181702_p[Direction.SOUTH.ordinal()], world);
        }
        return true;
    }

    public boolean func_178577_a(int n) {
        if (this.field_178595_m == n) {
            return false;
        }
        this.field_178595_m = n;
        return true;
    }

    public VertexBuffer func_178565_b(int n) {
        return this.field_178594_l[n];
    }

    public void func_189562_a(int n, int n2, int n3) {
        if (n == this.field_178586_f.func_177958_n() && n2 == this.field_178586_f.func_177956_o() && n3 == this.field_178586_f.func_177952_p()) {
            return;
        }
        this.func_178585_h();
        this.field_178586_f.func_181079_c(n, n2, n3);
        this.field_178591_c = new AxisAlignedBB(n, n2, n3, n + 16, n2 + 16, n3 + 16);
        for (Direction direction : Direction.values()) {
            this.field_181702_p[direction.ordinal()].func_189533_g(this.field_178586_f).func_189534_c(direction, 16);
        }
    }

    public void func_178570_a(float f, float f2, float f3, ChunkRenderTask chunkRenderTask) {
        CompiledChunk compiledChunk = chunkRenderTask.func_178544_c();
        if (compiledChunk.func_178487_c() == null || compiledChunk.func_178491_b(BlockRenderLayer.TRANSLUCENT)) {
            return;
        }
        this.func_178573_a(chunkRenderTask.func_178545_d().func_179038_a(BlockRenderLayer.TRANSLUCENT), this.field_178586_f);
        chunkRenderTask.func_178545_d().func_179038_a(BlockRenderLayer.TRANSLUCENT).func_178993_a(compiledChunk.func_178487_c());
        this.func_178584_a(BlockRenderLayer.TRANSLUCENT, f, f2, f3, chunkRenderTask.func_178545_d().func_179038_a(BlockRenderLayer.TRANSLUCENT), compiledChunk);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void func_178581_b(float f, float f2, float f3, ChunkRenderTask chunkRenderTask) {
        CompiledChunk compiledChunk = new CompiledChunk();
        boolean \u26032 = true;
        BlockPos \u26033 = this.field_178586_f.func_185334_h();
        BlockPos \u26034 = \u26033.func_177982_a(15, 15, 15);
        World \u26035 = this.field_178588_d;
        if (\u26035 == null) {
            return;
        }
        chunkRenderTask.func_178540_f().lock();
        try {
            if (chunkRenderTask.func_178546_a() != ChunkRenderTask.Status.COMPILING) {
                return;
            }
            chunkRenderTask.func_178543_a(compiledChunk);
        }
        finally {
            chunkRenderTask.func_178540_f().unlock();
        }
        VisGraph \u26036 = new VisGraph();
        HashSet \u26037 = Sets.newHashSet();
        ChunkRenderCache \u26038 = chunkRenderTask.func_217667_c();
        if (\u26038 != null) {
            ++field_178592_a;
            boolean[] object = new boolean[BlockRenderLayer.values().length];
            BlockModelRenderer.func_211847_a();
            Random \u26039 = new Random();
            BlockRendererDispatcher \u260310 = Minecraft.func_71410_x().func_175602_ab();
            for (BlockPos blockPos : BlockPos.func_218278_a(\u26033, \u26034)) {
                Object object2;
                BlockState blockState = \u26038.func_180495_p(blockPos);
                Block block = blockState.func_177230_c();
                if (blockState.func_200015_d(\u26038, blockPos)) {
                    \u26036.func_178606_a(blockPos);
                }
                if (block.func_149716_u() && (object2 = \u26038.func_212399_a(blockPos, Chunk.CreateEntityType.CHECK)) != null && (\u2603 = TileEntityRendererDispatcher.field_147556_a.func_147547_b((TileEntity)object2)) != null) {
                    compiledChunk.func_178490_a((TileEntity)object2);
                    if (((TileEntityRenderer)\u2603).func_188185_a(object2)) {
                        \u26037.add(object2);
                    }
                }
                if (!(object2 = \u26038.func_204610_c(blockPos)).func_206888_e()) {
                    BlockRenderLayer object22 = object2.func_180664_k();
                    int \u260312 = object22.ordinal();
                    BufferBuilder \u260313 = chunkRenderTask.func_178545_d().func_179039_a(\u260312);
                    if (!compiledChunk.func_178492_d(object22)) {
                        compiledChunk.func_178493_c(object22);
                        this.func_178573_a(\u260313, \u26033);
                    }
                    int n = \u260312;
                    object[n] = object[n] | \u260310.func_215331_a(blockPos, \u26038, \u260313, (IFluidState)object2);
                }
                if (blockState.func_185901_i() == BlockRenderType.INVISIBLE) continue;
                \u2603 = block.func_180664_k();
                int \u260314 = ((Enum)\u2603).ordinal();
                BufferBuilder \u260315 = chunkRenderTask.func_178545_d().func_179039_a(\u260314);
                if (!compiledChunk.func_178492_d((BlockRenderLayer)((Object)\u2603))) {
                    compiledChunk.func_178493_c((BlockRenderLayer)((Object)\u2603));
                    this.func_178573_a(\u260315, \u26033);
                }
                int n = \u260314;
                object[n] = object[n] | \u260310.func_215330_a(blockState, blockPos, \u26038, \u260315, \u26039);
            }
            for (BlockRenderLayer blockRenderLayer : BlockRenderLayer.values()) {
                if (object[blockRenderLayer.ordinal()]) {
                    compiledChunk.func_178486_a(blockRenderLayer);
                }
                if (!compiledChunk.func_178492_d(blockRenderLayer)) continue;
                this.func_178584_a(blockRenderLayer, f, f2, f3, chunkRenderTask.func_178545_d().func_179038_a(blockRenderLayer), compiledChunk);
            }
            BlockModelRenderer.func_210266_a();
        }
        compiledChunk.func_178488_a(\u26036.func_178607_a());
        this.field_178587_g.lock();
        try {
            HashSet hashSet = Sets.newHashSet((Iterable)\u26037);
            \u2603 = Sets.newHashSet(this.field_181056_j);
            hashSet.removeAll(this.field_181056_j);
            \u2603.removeAll(\u26037);
            this.field_181056_j.clear();
            this.field_181056_j.addAll(\u26037);
            this.field_178589_e.func_181023_a(\u2603, hashSet);
        }
        finally {
            this.field_178587_g.unlock();
        }
    }

    protected void func_178578_b() {
        this.field_178587_g.lock();
        try {
            if (this.field_178599_i != null && this.field_178599_i.func_178546_a() != ChunkRenderTask.Status.DONE) {
                this.field_178599_i.func_178542_e();
                this.field_178599_i = null;
            }
        }
        finally {
            this.field_178587_g.unlock();
        }
    }

    public ReentrantLock func_178579_c() {
        return this.field_178587_g;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ChunkRenderTask func_178574_d() {
        this.field_178587_g.lock();
        try {
            this.func_178578_b();
            BlockPos blockPos = this.field_178586_f.func_185334_h();
            boolean \u26032 = true;
            ChunkRenderCache \u26033 = ChunkRenderCache.func_212397_a(this.field_178588_d, blockPos.func_177982_a(-1, -1, -1), blockPos.func_177982_a(16, 16, 16), 1);
            ChunkRenderTask chunkRenderTask = this.field_178599_i = new ChunkRenderTask(this, ChunkRenderTask.Type.REBUILD_CHUNK, this.func_188280_f(), \u26033);
            return chunkRenderTask;
        }
        finally {
            this.field_178587_g.unlock();
        }
    }

    @Nullable
    public ChunkRenderTask func_178582_e() {
        this.field_178587_g.lock();
        try {
            if (this.field_178599_i != null && this.field_178599_i.func_178546_a() == ChunkRenderTask.Status.PENDING) {
                ChunkRenderTask chunkRenderTask = null;
                return chunkRenderTask;
            }
            if (this.field_178599_i != null && this.field_178599_i.func_178546_a() != ChunkRenderTask.Status.DONE) {
                this.field_178599_i.func_178542_e();
                this.field_178599_i = null;
            }
            this.field_178599_i = new ChunkRenderTask(this, ChunkRenderTask.Type.RESORT_TRANSPARENCY, this.func_188280_f(), null);
            this.field_178599_i.func_178543_a(this.field_178590_b);
            ChunkRenderTask chunkRenderTask = this.field_178599_i;
            return chunkRenderTask;
        }
        finally {
            this.field_178587_g.unlock();
        }
    }

    protected double func_188280_f() {
        ActiveRenderInfo activeRenderInfo = Minecraft.func_71410_x().field_71460_t.func_215316_n();
        double \u26032 = this.field_178591_c.field_72340_a + 8.0 - activeRenderInfo.func_216785_c().field_72450_a;
        double \u26033 = this.field_178591_c.field_72338_b + 8.0 - activeRenderInfo.func_216785_c().field_72448_b;
        double \u26034 = this.field_178591_c.field_72339_c + 8.0 - activeRenderInfo.func_216785_c().field_72449_c;
        return \u26032 * \u26032 + \u26033 * \u26033 + \u26034 * \u26034;
    }

    private void func_178573_a(BufferBuilder bufferBuilder, BlockPos blockPos) {
        bufferBuilder.func_181668_a(7, DefaultVertexFormats.field_176600_a);
        bufferBuilder.func_178969_c(-blockPos.func_177958_n(), -blockPos.func_177956_o(), -blockPos.func_177952_p());
    }

    private void func_178584_a(BlockRenderLayer blockRenderLayer, float f, float f2, float f3, BufferBuilder bufferBuilder, CompiledChunk compiledChunk) {
        if (blockRenderLayer == BlockRenderLayer.TRANSLUCENT && !compiledChunk.func_178491_b(blockRenderLayer)) {
            bufferBuilder.func_181674_a(f, f2, f3);
            compiledChunk.func_178494_a(bufferBuilder.func_181672_a());
        }
        bufferBuilder.func_178977_d();
    }

    public CompiledChunk func_178571_g() {
        return this.field_178590_b;
    }

    public void func_178580_a(CompiledChunk compiledChunk) {
        this.field_178598_h.lock();
        try {
            this.field_178590_b = compiledChunk;
        }
        finally {
            this.field_178598_h.unlock();
        }
    }

    public void func_178585_h() {
        this.func_178578_b();
        this.field_178590_b = CompiledChunk.field_178502_a;
        this.field_178593_n = true;
    }

    public void func_178566_a() {
        this.func_178585_h();
        this.field_178588_d = null;
        for (int i = 0; i < BlockRenderLayer.values().length; ++i) {
            if (this.field_178594_l[i] == null) continue;
            this.field_178594_l[i].func_177362_c();
        }
    }

    public BlockPos func_178568_j() {
        return this.field_178586_f;
    }

    public void func_178575_a(boolean bl) {
        if (this.field_178593_n) {
            bl |= this.field_188284_q;
        }
        this.field_178593_n = true;
        this.field_188284_q = bl;
    }

    public void func_188282_m() {
        this.field_178593_n = false;
        this.field_188284_q = false;
    }

    public boolean func_178569_m() {
        return this.field_178593_n;
    }

    public boolean func_188281_o() {
        return this.field_178593_n && this.field_188284_q;
    }

    public BlockPos func_181701_a(Direction direction) {
        return this.field_181702_p[direction.ordinal()];
    }

    public World func_188283_p() {
        return this.field_178588_d;
    }
}

