/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Queues;
import com.google.common.collect.Sets;
import com.google.gson.JsonSyntaxException;
import com.mojang.blaze3d.platform.GLX;
import com.mojang.blaze3d.platform.GlStateManager;
import java.io.IOException;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractSignBlock;
import net.minecraft.block.AbstractSkullBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.ChestBlock;
import net.minecraft.block.ComposterBlock;
import net.minecraft.block.EnderChestBlock;
import net.minecraft.block.LeavesBlock;
import net.minecraft.block.SoundType;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.SimpleSound;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.renderer.AbstractChunkRenderContainer;
import net.minecraft.client.renderer.ActiveRenderInfo;
import net.minecraft.client.renderer.BlockRendererDispatcher;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.DestroyBlockProgress;
import net.minecraft.client.renderer.GLAllocation;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.RenderList;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.VboRenderList;
import net.minecraft.client.renderer.Vector3d;
import net.minecraft.client.renderer.Vector4f;
import net.minecraft.client.renderer.ViewFrustum;
import net.minecraft.client.renderer.chunk.ChunkRender;
import net.minecraft.client.renderer.chunk.ChunkRenderDispatcher;
import net.minecraft.client.renderer.chunk.CompiledChunk;
import net.minecraft.client.renderer.chunk.IChunkRendererFactory;
import net.minecraft.client.renderer.chunk.ListedChunkRender;
import net.minecraft.client.renderer.chunk.VisGraph;
import net.minecraft.client.renderer.culling.ClippingHelper;
import net.minecraft.client.renderer.culling.Frustum;
import net.minecraft.client.renderer.culling.ICamera;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.client.renderer.model.ModelBakery;
import net.minecraft.client.renderer.texture.AtlasTexture;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.renderer.vertex.VertexBuffer;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.client.renderer.vertex.VertexFormatElement;
import net.minecraft.client.settings.CloudOption;
import net.minecraft.client.settings.ParticleStatus;
import net.minecraft.client.shader.Framebuffer;
import net.minecraft.client.shader.ShaderGroup;
import net.minecraft.client.shader.ShaderLinkHelper;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.crash.CrashReport;
import net.minecraft.crash.CrashReportCategory;
import net.minecraft.crash.ReportedException;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.BoneMealItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.MusicDiscItem;
import net.minecraft.particles.BasicParticleType;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ItemParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.resources.IResourceManager;
import net.minecraft.resources.IResourceManagerReloadListener;
import net.minecraft.state.properties.ChestType;
import net.minecraft.tileentity.ChestTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.Util;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraft.world.border.WorldBorder;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.dimension.DimensionType;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class WorldRenderer
implements AutoCloseable,
IResourceManagerReloadListener {
    private static final Logger field_147599_m = LogManager.getLogger();
    private static final ResourceLocation field_110927_h = new ResourceLocation("textures/environment/moon_phases.png");
    private static final ResourceLocation field_110928_i = new ResourceLocation("textures/environment/sun.png");
    private static final ResourceLocation field_110925_j = new ResourceLocation("textures/environment/clouds.png");
    private static final ResourceLocation field_110926_k = new ResourceLocation("textures/environment/end_sky.png");
    private static final ResourceLocation field_175006_g = new ResourceLocation("textures/misc/forcefield.png");
    public static final Direction[] field_200006_a = Direction.values();
    private final Minecraft field_72777_q;
    private final TextureManager field_72770_i;
    private final EntityRendererManager field_175010_j;
    private ClientWorld field_72769_h;
    private Set<ChunkRender> field_175009_l = Sets.newLinkedHashSet();
    private List<LocalRenderInformationContainer> field_72755_R = Lists.newArrayListWithCapacity((int)69696);
    private final Set<TileEntity> field_181024_n = Sets.newHashSet();
    private ViewFrustum field_175008_n;
    private int field_72772_v = -1;
    private int field_72771_w = -1;
    private int field_72781_x = -1;
    private final VertexFormat field_175014_r;
    private VertexBuffer field_175013_s;
    private VertexBuffer field_175012_t;
    private VertexBuffer field_175011_u;
    private final int field_204606_x = 28;
    private boolean field_204607_y = true;
    private int field_204608_z = -1;
    private VertexBuffer field_204601_A;
    private int field_72773_u;
    private final Map<Integer, DestroyBlockProgress> field_72738_E = Maps.newHashMap();
    private final Map<BlockPos, ISound> field_147593_P = Maps.newHashMap();
    private final TextureAtlasSprite[] field_94141_F = new TextureAtlasSprite[10];
    private Framebuffer field_175015_z;
    private ShaderGroup field_174991_A;
    private double field_174992_B = Double.MIN_VALUE;
    private double field_174993_C = Double.MIN_VALUE;
    private double field_174987_D = Double.MIN_VALUE;
    private int field_174988_E = Integer.MIN_VALUE;
    private int field_174989_F = Integer.MIN_VALUE;
    private int field_174990_G = Integer.MIN_VALUE;
    private double field_174997_H = Double.MIN_VALUE;
    private double field_174998_I = Double.MIN_VALUE;
    private double field_174999_J = Double.MIN_VALUE;
    private double field_175000_K = Double.MIN_VALUE;
    private double field_174994_L = Double.MIN_VALUE;
    private int field_204602_S = Integer.MIN_VALUE;
    private int field_204603_T = Integer.MIN_VALUE;
    private int field_204604_U = Integer.MIN_VALUE;
    private Vec3d field_204605_V = Vec3d.field_186680_a;
    private CloudOption field_204800_W;
    private ChunkRenderDispatcher field_174995_M;
    private AbstractChunkRenderContainer field_174996_N;
    private int field_72739_F = -1;
    private int field_72740_G = 2;
    private int field_72749_I;
    private int field_72750_J;
    private boolean field_175002_T;
    private ClippingHelper field_175001_U;
    private final Vector4f[] field_175004_V = new Vector4f[8];
    private final Vector3d field_175003_W = new Vector3d(0.0, 0.0, 0.0);
    private boolean field_175005_X;
    private IChunkRendererFactory field_175007_a;
    private double field_147596_f;
    private double field_147597_g;
    private double field_147602_h;
    private boolean field_147595_R = true;
    private boolean field_184386_ad;

    public WorldRenderer(Minecraft minecraft) {
        this.field_72777_q = minecraft;
        this.field_175010_j = minecraft.func_175598_ae();
        this.field_72770_i = minecraft.func_110434_K();
        this.field_175005_X = GLX.useVbo();
        if (this.field_175005_X) {
            this.field_174996_N = new VboRenderList();
            this.field_175007_a = ChunkRender::new;
        } else {
            this.field_174996_N = new RenderList();
            this.field_175007_a = ListedChunkRender::new;
        }
        this.field_175014_r = new VertexFormat();
        this.field_175014_r.func_181721_a(new VertexFormatElement(0, VertexFormatElement.Type.FLOAT, VertexFormatElement.Usage.POSITION, 3));
        this.func_174963_q();
        this.func_174980_p();
        this.func_174964_o();
    }

    @Override
    public void close() {
        if (this.field_174991_A != null) {
            this.field_174991_A.close();
        }
    }

    @Override
    public void func_195410_a(IResourceManager iResourceManager) {
        this.field_72770_i.func_110577_a(field_175006_g);
        GlStateManager.texParameter(3553, 10242, 10497);
        GlStateManager.texParameter(3553, 10243, 10497);
        GlStateManager.bindTexture(0);
        this.func_174971_n();
        this.func_174966_b();
    }

    private void func_174971_n() {
        AtlasTexture atlasTexture = this.field_72777_q.func_147117_R();
        this.field_94141_F[0] = atlasTexture.func_195424_a(ModelBakery.field_207770_h);
        this.field_94141_F[1] = atlasTexture.func_195424_a(ModelBakery.field_207771_i);
        this.field_94141_F[2] = atlasTexture.func_195424_a(ModelBakery.field_207772_j);
        this.field_94141_F[3] = atlasTexture.func_195424_a(ModelBakery.field_207773_k);
        this.field_94141_F[4] = atlasTexture.func_195424_a(ModelBakery.field_207774_l);
        this.field_94141_F[5] = atlasTexture.func_195424_a(ModelBakery.field_207775_m);
        this.field_94141_F[6] = atlasTexture.func_195424_a(ModelBakery.field_207776_n);
        this.field_94141_F[7] = atlasTexture.func_195424_a(ModelBakery.field_207777_o);
        this.field_94141_F[8] = atlasTexture.func_195424_a(ModelBakery.field_207778_p);
        this.field_94141_F[9] = atlasTexture.func_195424_a(ModelBakery.field_207779_q);
    }

    public void func_174966_b() {
        if (GLX.usePostProcess) {
            if (ShaderLinkHelper.func_148074_b() == null) {
                ShaderLinkHelper.func_148076_a();
            }
            if (this.field_174991_A != null) {
                this.field_174991_A.close();
            }
            ResourceLocation resourceLocation = new ResourceLocation("shaders/post/entity_outline.json");
            try {
                this.field_174991_A = new ShaderGroup(this.field_72777_q.func_110434_K(), this.field_72777_q.func_195551_G(), this.field_72777_q.func_147110_a(), resourceLocation);
                this.field_174991_A.func_148026_a(this.field_72777_q.field_195558_d.func_198109_k(), this.field_72777_q.field_195558_d.func_198091_l());
                this.field_175015_z = this.field_174991_A.func_177066_a("final");
            }
            catch (IOException \u26032) {
                field_147599_m.warn("Failed to load shader: {}", (Object)resourceLocation, (Object)\u26032);
                this.field_174991_A = null;
                this.field_175015_z = null;
            }
            catch (JsonSyntaxException \u26033) {
                field_147599_m.warn("Failed to load shader: {}", (Object)resourceLocation, (Object)\u26033);
                this.field_174991_A = null;
                this.field_175015_z = null;
            }
        } else {
            this.field_174991_A = null;
            this.field_175015_z = null;
        }
    }

    public void func_174975_c() {
        if (this.func_174985_d()) {
            GlStateManager.enableBlend();
            GlStateManager.blendFuncSeparate(GlStateManager.SourceFactor.SRC_ALPHA, GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, GlStateManager.SourceFactor.ZERO, GlStateManager.DestFactor.ONE);
            this.field_175015_z.func_178038_a(this.field_72777_q.field_195558_d.func_198109_k(), this.field_72777_q.field_195558_d.func_198091_l(), false);
            GlStateManager.disableBlend();
        }
    }

    protected boolean func_174985_d() {
        return this.field_175015_z != null && this.field_174991_A != null && this.field_72777_q.field_71439_g != null;
    }

    private void func_174964_o() {
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder \u26032 = tessellator.func_178180_c();
        if (this.field_175011_u != null) {
            this.field_175011_u.func_177362_c();
        }
        if (this.field_72781_x >= 0) {
            GLAllocation.func_74523_b(this.field_72781_x);
            this.field_72781_x = -1;
        }
        if (this.field_175005_X) {
            this.field_175011_u = new VertexBuffer(this.field_175014_r);
            this.func_174968_a(\u26032, -16.0f, true);
            \u26032.func_178977_d();
            \u26032.func_178965_a();
            this.field_175011_u.func_181722_a(\u26032.func_178966_f());
        } else {
            this.field_72781_x = GLAllocation.func_74526_a(1);
            GlStateManager.newList(this.field_72781_x, 4864);
            this.func_174968_a(\u26032, -16.0f, true);
            tessellator.func_78381_a();
            GlStateManager.endList();
        }
    }

    private void func_174980_p() {
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder \u26032 = tessellator.func_178180_c();
        if (this.field_175012_t != null) {
            this.field_175012_t.func_177362_c();
        }
        if (this.field_72771_w >= 0) {
            GLAllocation.func_74523_b(this.field_72771_w);
            this.field_72771_w = -1;
        }
        if (this.field_175005_X) {
            this.field_175012_t = new VertexBuffer(this.field_175014_r);
            this.func_174968_a(\u26032, 16.0f, false);
            \u26032.func_178977_d();
            \u26032.func_178965_a();
            this.field_175012_t.func_181722_a(\u26032.func_178966_f());
        } else {
            this.field_72771_w = GLAllocation.func_74526_a(1);
            GlStateManager.newList(this.field_72771_w, 4864);
            this.func_174968_a(\u26032, 16.0f, false);
            tessellator.func_78381_a();
            GlStateManager.endList();
        }
    }

    private void func_174968_a(BufferBuilder bufferBuilder, float f, boolean bl) {
        int n = 64;
        \u2603 = 6;
        bufferBuilder.func_181668_a(7, DefaultVertexFormats.field_181705_e);
        for (\u2603 = -384; \u2603 <= 384; \u2603 += 64) {
            for (\u2603 = -384; \u2603 <= 384; \u2603 += 64) {
                float f2 = \u2603;
                \u2603 = \u2603 + 64;
                if (bl) {
                    \u2603 = \u2603;
                    f2 = \u2603 + 64;
                }
                bufferBuilder.func_181662_b(f2, f, \u2603).func_181675_d();
                bufferBuilder.func_181662_b(\u2603, f, \u2603).func_181675_d();
                bufferBuilder.func_181662_b(\u2603, f, \u2603 + 64).func_181675_d();
                bufferBuilder.func_181662_b(f2, f, \u2603 + 64).func_181675_d();
            }
        }
    }

    private void func_174963_q() {
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder \u26032 = tessellator.func_178180_c();
        if (this.field_175013_s != null) {
            this.field_175013_s.func_177362_c();
        }
        if (this.field_72772_v >= 0) {
            GLAllocation.func_74523_b(this.field_72772_v);
            this.field_72772_v = -1;
        }
        if (this.field_175005_X) {
            this.field_175013_s = new VertexBuffer(this.field_175014_r);
            this.func_180444_a(\u26032);
            \u26032.func_178977_d();
            \u26032.func_178965_a();
            this.field_175013_s.func_181722_a(\u26032.func_178966_f());
        } else {
            this.field_72772_v = GLAllocation.func_74526_a(1);
            GlStateManager.pushMatrix();
            GlStateManager.newList(this.field_72772_v, 4864);
            this.func_180444_a(\u26032);
            tessellator.func_78381_a();
            GlStateManager.endList();
            GlStateManager.popMatrix();
        }
    }

    private void func_180444_a(BufferBuilder bufferBuilder) {
        Random random = new Random(10842L);
        bufferBuilder.func_181668_a(7, DefaultVertexFormats.field_181705_e);
        for (int i = 0; i < 1500; ++i) {
            double d = random.nextFloat() * 2.0f - 1.0f;
            \u2603 = random.nextFloat() * 2.0f - 1.0f;
            \u2603 = random.nextFloat() * 2.0f - 1.0f;
            \u2603 = 0.15f + random.nextFloat() * 0.1f;
            \u2603 = d * d + \u2603 * \u2603 + \u2603 * \u2603;
            if (!(\u2603 < 1.0) || !(\u2603 > 0.01)) continue;
            \u2603 = 1.0 / Math.sqrt(\u2603);
            \u2603 = (d *= \u2603) * 100.0;
            \u2603 = (\u2603 *= \u2603) * 100.0;
            \u2603 = (\u2603 *= \u2603) * 100.0;
            \u2603 = Math.atan2(d, \u2603);
            \u2603 = Math.sin(\u2603);
            \u2603 = Math.cos(\u2603);
            \u2603 = Math.atan2(Math.sqrt(d * d + \u2603 * \u2603), \u2603);
            \u2603 = Math.sin(\u2603);
            \u2603 = Math.cos(\u2603);
            \u2603 = random.nextDouble() * Math.PI * 2.0;
            \u2603 = Math.sin(\u2603);
            \u2603 = Math.cos(\u2603);
            for (int j = 0; j < 4; ++j) {
                double d2 = 0.0;
                \u2603 = (double)((j & 2) - 1) * \u2603;
                \u2603 = (double)((j + 1 & 2) - 1) * \u2603;
                \u2603 = 0.0;
                \u2603 = \u2603 * \u2603 - \u2603 * \u2603;
                \u2603 = \u2603 = \u2603 * \u2603 + \u2603 * \u2603;
                \u2603 = \u2603 * \u2603 + 0.0 * \u2603;
                \u2603 = 0.0 * \u2603 - \u2603 * \u2603;
                \u2603 = \u2603 * \u2603 - \u2603 * \u2603;
                \u2603 = \u2603;
                \u2603 = \u2603 * \u2603 + \u2603 * \u2603;
                bufferBuilder.func_181662_b(\u2603 + \u2603, \u2603 + \u2603, \u2603 + \u2603).func_181675_d();
            }
        }
    }

    public void func_72732_a(@Nullable ClientWorld clientWorld) {
        this.field_174992_B = Double.MIN_VALUE;
        this.field_174993_C = Double.MIN_VALUE;
        this.field_174987_D = Double.MIN_VALUE;
        this.field_174988_E = Integer.MIN_VALUE;
        this.field_174989_F = Integer.MIN_VALUE;
        this.field_174990_G = Integer.MIN_VALUE;
        this.field_175010_j.func_78717_a(clientWorld);
        this.field_72769_h = clientWorld;
        if (clientWorld != null) {
            this.func_72712_a();
        } else {
            this.field_175009_l.clear();
            this.field_72755_R.clear();
            if (this.field_175008_n != null) {
                this.field_175008_n.func_178160_a();
                this.field_175008_n = null;
            }
            if (this.field_174995_M != null) {
                this.field_174995_M.func_188244_g();
            }
            this.field_174995_M = null;
            this.field_181024_n.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void func_72712_a() {
        if (this.field_72769_h == null) {
            return;
        }
        if (this.field_174995_M == null) {
            this.field_174995_M = new ChunkRenderDispatcher(this.field_72777_q.func_147111_S());
        }
        this.field_147595_R = true;
        this.field_204607_y = true;
        LeavesBlock.func_196475_b(this.field_72777_q.field_71474_y.field_74347_j);
        this.field_72739_F = this.field_72777_q.field_71474_y.field_151451_c;
        boolean bl = this.field_175005_X;
        this.field_175005_X = GLX.useVbo();
        if (bl && !this.field_175005_X) {
            this.field_174996_N = new RenderList();
            this.field_175007_a = ListedChunkRender::new;
        } else if (!bl && this.field_175005_X) {
            this.field_174996_N = new VboRenderList();
            this.field_175007_a = ChunkRender::new;
        }
        if (bl != this.field_175005_X) {
            this.func_174963_q();
            this.func_174980_p();
            this.func_174964_o();
        }
        if (this.field_175008_n != null) {
            this.field_175008_n.func_178160_a();
        }
        this.func_174986_e();
        Set<TileEntity> set = this.field_181024_n;
        synchronized (set) {
            this.field_181024_n.clear();
        }
        this.field_175008_n = new ViewFrustum(this.field_72769_h, this.field_72777_q.field_71474_y.field_151451_c, this, this.field_175007_a);
        if (this.field_72769_h != null && (\u2603 = this.field_72777_q.func_175606_aa()) != null) {
            this.field_175008_n.func_178163_a(\u2603.field_70165_t, \u2603.field_70161_v);
        }
        this.field_72740_G = 2;
    }

    protected void func_174986_e() {
        this.field_175009_l.clear();
        this.field_174995_M.func_178514_b();
    }

    public void func_72720_a(int n, int n2) {
        this.func_174979_m();
        if (!GLX.usePostProcess) {
            return;
        }
        if (this.field_174991_A != null) {
            this.field_174991_A.func_148026_a(n, n2);
        }
    }

    public void func_224745_a(ActiveRenderInfo activeRenderInfo) {
        TileEntityRendererDispatcher.field_147556_a.func_217665_a(this.field_72769_h, this.field_72777_q.func_110434_K(), this.field_72777_q.field_71466_p, activeRenderInfo, this.field_72777_q.field_71476_x);
        this.field_175010_j.func_217781_a(this.field_72769_h, this.field_72777_q.field_71466_p, activeRenderInfo, this.field_72777_q.field_147125_j, this.field_72777_q.field_71474_y);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void func_215326_a(ActiveRenderInfo activeRenderInfo, ICamera iCamera, float f2) {
        if (this.field_72740_G > 0) {
            --this.field_72740_G;
            return;
        }
        double d = activeRenderInfo.func_216785_c().field_72450_a;
        double d2 = activeRenderInfo.func_216785_c().field_72448_b;
        \u2603 = activeRenderInfo.func_216785_c().field_72449_c;
        this.field_72769_h.func_217381_Z().func_76320_a("prepare");
        this.field_72749_I = 0;
        this.field_72750_J = 0;
        \u2603 = activeRenderInfo.func_216785_c().field_72450_a;
        \u2603 = activeRenderInfo.func_216785_c().field_72448_b;
        \u2603 = activeRenderInfo.func_216785_c().field_72449_c;
        TileEntityRendererDispatcher.field_147554_b = \u2603;
        TileEntityRendererDispatcher.field_147555_c = \u2603;
        TileEntityRendererDispatcher.field_147552_d = \u2603;
        this.field_175010_j.func_178628_a(\u2603, \u2603, \u2603);
        this.field_72777_q.field_71460_t.func_180436_i();
        this.field_72769_h.func_217381_Z().func_219895_b("entities");
        ArrayList \u26032 = Lists.newArrayList();
        ArrayList \u26033 = Lists.newArrayList();
        for (Entity entity : this.field_72769_h.func_217416_b()) {
            if (!this.field_175010_j.func_178635_a(entity, iCamera, d, d2, \u2603) && !entity.func_184215_y(this.field_72777_q.field_71439_g) || entity == activeRenderInfo.func_216773_g() && !activeRenderInfo.func_216770_i() && (!(activeRenderInfo.func_216773_g() instanceof LivingEntity) || !((LivingEntity)activeRenderInfo.func_216773_g()).func_70608_bn())) continue;
            ++this.field_72749_I;
            this.field_175010_j.func_188388_a(entity, f2, false);
            if (entity.func_184202_aL() || entity instanceof PlayerEntity && this.field_72777_q.field_71439_g.func_175149_v() && this.field_72777_q.field_71474_y.field_178883_an.func_151470_d()) {
                \u26032.add(entity);
            }
            if (!this.field_175010_j.func_188390_b(entity)) continue;
            \u26033.add(entity);
        }
        if (!\u26033.isEmpty()) {
            for (Entity entity : \u26033) {
                this.field_175010_j.func_188389_a(entity, f2);
            }
        }
        if (this.func_174985_d() && (!\u26032.isEmpty() || this.field_184386_ad)) {
            this.field_72769_h.func_217381_Z().func_219895_b("entityOutlines");
            this.field_175015_z.func_216493_b(Minecraft.field_142025_a);
            boolean bl = this.field_184386_ad = !\u26032.isEmpty();
            if (!\u26032.isEmpty()) {
                GlStateManager.depthFunc(519);
                GlStateManager.disableFog();
                this.field_175015_z.func_147610_a(false);
                RenderHelper.func_74518_a();
                this.field_175010_j.func_178632_c(true);
                for (int i = 0; i < \u26032.size(); ++i) {
                    this.field_175010_j.func_188388_a((Entity)\u26032.get(i), f2, false);
                }
                this.field_175010_j.func_178632_c(false);
                RenderHelper.func_74519_b();
                GlStateManager.depthMask(false);
                this.field_174991_A.func_148018_a(f2);
                GlStateManager.enableLighting();
                GlStateManager.depthMask(true);
                GlStateManager.enableFog();
                GlStateManager.enableBlend();
                GlStateManager.enableColorMaterial();
                GlStateManager.depthFunc(515);
                GlStateManager.enableDepthTest();
                GlStateManager.enableAlphaTest();
            }
            this.field_72777_q.func_147110_a().func_147610_a(false);
        }
        this.field_72769_h.func_217381_Z().func_219895_b("blockentities");
        RenderHelper.func_74519_b();
        for (LocalRenderInformationContainer localRenderInformationContainer : this.field_72755_R) {
            List<TileEntity> list = localRenderInformationContainer.field_178036_a.func_178571_g().func_178485_b();
            if (list.isEmpty()) continue;
            for (TileEntity \u26034 : list) {
                TileEntityRendererDispatcher.field_147556_a.func_180546_a(\u26034, f2, -1);
            }
        }
        Set<TileEntity> i = this.field_181024_n;
        synchronized (i) {
            for (TileEntity tileEntity : this.field_181024_n) {
                TileEntityRendererDispatcher.field_147556_a.func_180546_a(tileEntity, f2, -1);
            }
        }
        this.func_180443_s();
        for (DestroyBlockProgress destroyBlockProgress : this.field_72738_E.values()) {
            BlockPos blockPos = destroyBlockProgress.func_180246_b();
            BlockState blockState = this.field_72769_h.func_180495_p(blockPos);
            if (!blockState.func_177230_c().func_149716_u()) continue;
            TileEntity tileEntity = this.field_72769_h.func_175625_s(blockPos);
            if (tileEntity instanceof ChestTileEntity && blockState.func_177229_b(ChestBlock.field_196314_b) == ChestType.LEFT) {
                BlockPos blockPos2 = blockPos.func_177972_a(blockState.func_177229_b(ChestBlock.field_176459_a).func_176746_e());
                tileEntity = this.field_72769_h.func_175625_s(blockPos2);
            }
            if (tileEntity == null || !blockState.func_191057_i()) continue;
            TileEntityRendererDispatcher.field_147556_a.func_180546_a(tileEntity, f2, destroyBlockProgress.func_73106_e());
        }
        this.func_174969_t();
        this.field_72777_q.field_71460_t.func_175072_h();
        this.field_72777_q.func_213239_aq().func_76319_b();
    }

    public String func_72735_c() {
        int n = this.field_175008_n.field_178164_f.length;
        \u2603 = this.func_184382_g();
        return String.format("C: %d/%d %sD: %d, %s", \u2603, n, this.field_72777_q.field_175612_E ? "(s) " : "", this.field_72739_F, this.field_174995_M == null ? "null" : this.field_174995_M.func_178504_a());
    }

    protected int func_184382_g() {
        int n = 0;
        for (LocalRenderInformationContainer localRenderInformationContainer : this.field_72755_R) {
            CompiledChunk compiledChunk = ((LocalRenderInformationContainer)localRenderInformationContainer).field_178036_a.field_178590_b;
            if (compiledChunk == CompiledChunk.field_178502_a || compiledChunk.func_178489_a()) continue;
            ++n;
        }
        return n;
    }

    public String func_72723_d() {
        return "E: " + this.field_72749_I + "/" + this.field_72769_h.func_217425_f() + ", B: " + this.field_72750_J;
    }

    public void func_215320_a(ActiveRenderInfo activeRenderInfo2, ICamera object, int n, boolean bl2) {
        if (this.field_72777_q.field_71474_y.field_151451_c != this.field_72739_F) {
            this.func_72712_a();
        }
        this.field_72769_h.func_217381_Z().func_76320_a("camera");
        double d = this.field_72777_q.field_71439_g.field_70165_t - this.field_174992_B;
        double d2 = this.field_72777_q.field_71439_g.field_70163_u - this.field_174993_C;
        \u2603 = this.field_72777_q.field_71439_g.field_70161_v - this.field_174987_D;
        if (this.field_174988_E != this.field_72777_q.field_71439_g.field_70176_ah || this.field_174989_F != this.field_72777_q.field_71439_g.field_70162_ai || this.field_174990_G != this.field_72777_q.field_71439_g.field_70164_aj || d * d + d2 * d2 + \u2603 * \u2603 > 16.0) {
            this.field_174992_B = this.field_72777_q.field_71439_g.field_70165_t;
            this.field_174993_C = this.field_72777_q.field_71439_g.field_70163_u;
            this.field_174987_D = this.field_72777_q.field_71439_g.field_70161_v;
            this.field_174988_E = this.field_72777_q.field_71439_g.field_70176_ah;
            this.field_174989_F = this.field_72777_q.field_71439_g.field_70162_ai;
            this.field_174990_G = this.field_72777_q.field_71439_g.field_70164_aj;
            this.field_175008_n.func_178163_a(this.field_72777_q.field_71439_g.field_70165_t, this.field_72777_q.field_71439_g.field_70161_v);
        }
        this.field_72769_h.func_217381_Z().func_219895_b("renderlistcamera");
        this.field_174996_N.func_178004_a(activeRenderInfo2.func_216785_c().field_72450_a, activeRenderInfo2.func_216785_c().field_72448_b, activeRenderInfo2.func_216785_c().field_72449_c);
        this.field_174995_M.func_217669_a(activeRenderInfo2.func_216785_c());
        this.field_72769_h.func_217381_Z().func_219895_b("cull");
        if (this.field_175001_U != null) {
            Frustum \u26032 = new Frustum(this.field_175001_U);
            \u26032.func_78547_a(this.field_175003_W.field_181059_a, this.field_175003_W.field_181060_b, this.field_175003_W.field_181061_c);
            object = \u26032;
        }
        this.field_72777_q.func_213239_aq().func_219895_b("culling");
        BlockPos \u260317 = activeRenderInfo2.func_216780_d();
        ChunkRender \u26033 = this.field_175008_n.func_178161_a(\u260317);
        BlockPos \u26034 = new BlockPos(MathHelper.func_76128_c(activeRenderInfo2.func_216785_c().field_72450_a / 16.0) * 16, MathHelper.func_76128_c(activeRenderInfo2.func_216785_c().field_72448_b / 16.0) * 16, MathHelper.func_76128_c(activeRenderInfo2.func_216785_c().field_72449_c / 16.0) * 16);
        float \u26035 = activeRenderInfo2.func_216777_e();
        float \u26036 = activeRenderInfo2.func_216778_f();
        this.field_147595_R = this.field_147595_R || !this.field_175009_l.isEmpty() || activeRenderInfo2.func_216785_c().field_72450_a != this.field_174997_H || activeRenderInfo2.func_216785_c().field_72448_b != this.field_174998_I || activeRenderInfo2.func_216785_c().field_72449_c != this.field_174999_J || (double)\u26035 != this.field_175000_K || (double)\u26036 != this.field_174994_L;
        this.field_174997_H = activeRenderInfo2.func_216785_c().field_72450_a;
        this.field_174998_I = activeRenderInfo2.func_216785_c().field_72448_b;
        this.field_174999_J = activeRenderInfo2.func_216785_c().field_72449_c;
        this.field_175000_K = \u26035;
        this.field_174994_L = \u26036;
        boolean \u26037 = this.field_175001_U != null;
        this.field_72777_q.func_213239_aq().func_219895_b("update");
        if (!\u26037 && this.field_147595_R) {
            this.field_147595_R = false;
            this.field_72755_R = Lists.newArrayList();
            ArrayDeque collection = Queues.newArrayDeque();
            Entity.func_184227_b(MathHelper.func_151237_a((double)this.field_72777_q.field_71474_y.field_151451_c / 8.0, 1.0, 2.5));
            boolean \u26038 = this.field_72777_q.field_175612_E;
            if (\u26033 == null) {
                int n2 = \u260317.func_177956_o() > 0 ? 248 : 8;
                for (\u2603 = -this.field_72739_F; \u2603 <= this.field_72739_F; ++\u2603) {
                    for (\u2603 = -this.field_72739_F; \u2603 <= this.field_72739_F; ++\u2603) {
                        ChunkRender chunkRender = this.field_175008_n.func_178161_a(new BlockPos((\u2603 << 4) + 8, n2, (\u2603 << 4) + 8));
                        if (chunkRender == null || !object.func_78546_a(chunkRender.field_178591_c)) continue;
                        chunkRender.func_178577_a(n);
                        collection.add(new LocalRenderInformationContainer(chunkRender, null, 0));
                    }
                }
            } else {
                boolean \u260312 = false;
                LocalRenderInformationContainer \u26039 = new LocalRenderInformationContainer(\u26033, null, 0);
                Set<Direction> \u260310 = this.func_174978_c(\u260317);
                if (\u260310.size() == 1) {
                    Vec3d vec3d = activeRenderInfo2.func_216787_l();
                    Direction \u260311 = Direction.func_210769_a(vec3d.field_72450_a, vec3d.field_72448_b, vec3d.field_72449_c).func_176734_d();
                    \u260310.remove(\u260311);
                }
                if (\u260310.isEmpty()) {
                    \u260312 = true;
                }
                if (!\u260312 || bl2) {
                    if (bl2 && this.field_72769_h.func_180495_p(\u260317).func_200015_d(this.field_72769_h, \u260317)) {
                        \u26038 = false;
                    }
                    \u26033.func_178577_a(n);
                    collection.add(\u26039);
                } else {
                    this.field_72755_R.add(\u26039);
                }
            }
            this.field_72777_q.func_213239_aq().func_76320_a("iteration");
            while (!collection.isEmpty()) {
                LocalRenderInformationContainer localRenderInformationContainer = (LocalRenderInformationContainer)collection.poll();
                ChunkRender \u260313 = localRenderInformationContainer.field_178036_a;
                Direction \u260314 = localRenderInformationContainer.field_178034_b;
                this.field_72755_R.add(localRenderInformationContainer);
                for (Direction direction : field_200006_a) {
                    ChunkRender chunkRender = this.func_181562_a(\u26034, \u260313, direction);
                    if (\u26038 && localRenderInformationContainer.func_189560_a(direction.func_176734_d()) || \u26038 && \u260314 != null && !\u260313.func_178571_g().func_178495_a(\u260314.func_176734_d(), direction) || chunkRender == null || !chunkRender.func_217674_b() || !chunkRender.func_178577_a(n) || !object.func_78546_a(chunkRender.field_178591_c)) continue;
                    LocalRenderInformationContainer \u260315 = new LocalRenderInformationContainer(chunkRender, direction, localRenderInformationContainer.field_178032_d + 1);
                    \u260315.func_189561_a(localRenderInformationContainer.field_178035_c, direction);
                    collection.add(\u260315);
                }
            }
            this.field_72777_q.func_213239_aq().func_76319_b();
        }
        this.field_72777_q.func_213239_aq().func_219895_b("captureFrustum");
        if (this.field_175002_T) {
            this.func_174984_a(activeRenderInfo2.func_216785_c().field_72450_a, activeRenderInfo2.func_216785_c().field_72448_b, activeRenderInfo2.func_216785_c().field_72449_c);
            this.field_175002_T = false;
        }
        this.field_72777_q.func_213239_aq().func_219895_b("rebuildNear");
        Set<ChunkRender> set = this.field_175009_l;
        this.field_175009_l = Sets.newLinkedHashSet();
        for (LocalRenderInformationContainer localRenderInformationContainer : this.field_72755_R) {
            boolean bl;
            ChunkRender chunkRender = localRenderInformationContainer.field_178036_a;
            if (!chunkRender.func_178569_m() && !set.contains(chunkRender)) continue;
            this.field_147595_R = true;
            BlockPos \u260316 = chunkRender.func_178568_j().func_177982_a(8, 8, 8);
            boolean bl3 = bl = \u260316.func_177951_i(\u260317) < 768.0;
            if (chunkRender.func_188281_o() || bl) {
                this.field_72777_q.func_213239_aq().func_76320_a("build near");
                this.field_174995_M.func_178505_b(chunkRender);
                chunkRender.func_188282_m();
                this.field_72777_q.func_213239_aq().func_76319_b();
                continue;
            }
            this.field_175009_l.add(chunkRender);
        }
        this.field_175009_l.addAll(set);
        this.field_72777_q.func_213239_aq().func_76319_b();
    }

    private Set<Direction> func_174978_c(BlockPos blockPos) {
        VisGraph visGraph = new VisGraph();
        BlockPos \u26032 = new BlockPos(blockPos.func_177958_n() >> 4 << 4, blockPos.func_177956_o() >> 4 << 4, blockPos.func_177952_p() >> 4 << 4);
        Chunk \u26033 = this.field_72769_h.func_175726_f(\u26032);
        for (BlockPos blockPos2 : BlockPos.func_218278_a(\u26032, \u26032.func_177982_a(15, 15, 15))) {
            if (!\u26033.func_180495_p(blockPos2).func_200015_d(this.field_72769_h, blockPos2)) continue;
            visGraph.func_178606_a(blockPos2);
        }
        return visGraph.func_178609_b(blockPos);
    }

    @Nullable
    private ChunkRender func_181562_a(BlockPos blockPos, ChunkRender chunkRender, Direction direction) {
        BlockPos blockPos2 = chunkRender.func_181701_a(direction);
        if (MathHelper.func_76130_a(blockPos.func_177958_n() - blockPos2.func_177958_n()) > this.field_72739_F * 16) {
            return null;
        }
        if (blockPos2.func_177956_o() < 0 || blockPos2.func_177956_o() >= 256) {
            return null;
        }
        if (MathHelper.func_76130_a(blockPos.func_177952_p() - blockPos2.func_177952_p()) > this.field_72739_F * 16) {
            return null;
        }
        return this.field_175008_n.func_178161_a(blockPos2);
    }

    private void func_174984_a(double d, double d2, double d3) {
    }

    public int func_215323_a(BlockRenderLayer blockRenderLayer2, ActiveRenderInfo activeRenderInfo) {
        BlockRenderLayer blockRenderLayer2;
        RenderHelper.func_74518_a();
        if (blockRenderLayer2 == BlockRenderLayer.TRANSLUCENT) {
            this.field_72777_q.func_213239_aq().func_76320_a("translucent_sort");
            double d = activeRenderInfo.func_216785_c().field_72450_a - this.field_147596_f;
            \u2603 = activeRenderInfo.func_216785_c().field_72448_b - this.field_147597_g;
            \u2603 = activeRenderInfo.func_216785_c().field_72449_c - this.field_147602_h;
            if (d * d + \u2603 * \u2603 + \u2603 * \u2603 > 1.0) {
                this.field_147596_f = activeRenderInfo.func_216785_c().field_72450_a;
                this.field_147597_g = activeRenderInfo.func_216785_c().field_72448_b;
                this.field_147602_h = activeRenderInfo.func_216785_c().field_72449_c;
                int n = 0;
                for (LocalRenderInformationContainer localRenderInformationContainer : this.field_72755_R) {
                    if (!((LocalRenderInformationContainer)localRenderInformationContainer).field_178036_a.field_178590_b.func_178492_d(blockRenderLayer2) || n++ >= 15) continue;
                    this.field_174995_M.func_178509_c(localRenderInformationContainer.field_178036_a);
                }
            }
            this.field_72777_q.func_213239_aq().func_76319_b();
        }
        this.field_72777_q.func_213239_aq().func_76320_a("filterempty");
        int n = 0;
        boolean \u26032 = blockRenderLayer2 == BlockRenderLayer.TRANSLUCENT;
        \u2603 = \u26032 ? this.field_72755_R.size() - 1 : 0;
        \u2603 = \u26032 ? -1 : this.field_72755_R.size();
        \u2603 = \u26032 ? -1 : 1;
        for (\u2603 = \u2603; \u2603 != \u2603; \u2603 += \u2603) {
            ChunkRender chunkRender = this.field_72755_R.get(\u2603).field_178036_a;
            if (chunkRender.func_178571_g().func_178491_b(blockRenderLayer2)) continue;
            ++n;
            this.field_174996_N.func_178002_a(chunkRender, blockRenderLayer2);
        }
        this.field_72777_q.func_213239_aq().func_194339_b(() -> "render_" + (Object)((Object)blockRenderLayer2));
        this.func_174982_a(blockRenderLayer2);
        this.field_72777_q.func_213239_aq().func_76319_b();
        return n;
    }

    private void func_174982_a(BlockRenderLayer blockRenderLayer) {
        this.field_72777_q.field_71460_t.func_180436_i();
        if (GLX.useVbo()) {
            GlStateManager.enableClientState(32884);
            GLX.glClientActiveTexture(GLX.GL_TEXTURE0);
            GlStateManager.enableClientState(32888);
            GLX.glClientActiveTexture(GLX.GL_TEXTURE1);
            GlStateManager.enableClientState(32888);
            GLX.glClientActiveTexture(GLX.GL_TEXTURE0);
            GlStateManager.enableClientState(32886);
        }
        this.field_174996_N.func_178001_a(blockRenderLayer);
        if (GLX.useVbo()) {
            List<VertexFormatElement> list = DefaultVertexFormats.field_176600_a.func_177343_g();
            for (VertexFormatElement vertexFormatElement : list) {
                VertexFormatElement.Usage usage = vertexFormatElement.func_177375_c();
                int \u26032 = vertexFormatElement.func_177369_e();
                switch (usage) {
                    case POSITION: {
                        GlStateManager.disableClientState(32884);
                        break;
                    }
                    case UV: {
                        GLX.glClientActiveTexture(GLX.GL_TEXTURE0 + \u26032);
                        GlStateManager.disableClientState(32888);
                        GLX.glClientActiveTexture(GLX.GL_TEXTURE0);
                        break;
                    }
                    case COLOR: {
                        GlStateManager.disableClientState(32886);
                        GlStateManager.clearCurrentColor();
                    }
                }
            }
        }
        this.field_72777_q.field_71460_t.func_175072_h();
    }

    private void func_174965_a(Iterator<DestroyBlockProgress> iterator) {
        while (iterator.hasNext()) {
            DestroyBlockProgress destroyBlockProgress = iterator.next();
            int \u26032 = destroyBlockProgress.func_82743_f();
            if (this.field_72773_u - \u26032 <= 400) continue;
            iterator.remove();
        }
    }

    public void func_72734_e() {
        ++this.field_72773_u;
        if (this.field_72773_u % 20 == 0) {
            this.func_174965_a(this.field_72738_E.values().iterator());
        }
    }

    private void func_180448_r() {
        GlStateManager.disableFog();
        GlStateManager.disableAlphaTest();
        GlStateManager.enableBlend();
        GlStateManager.blendFuncSeparate(GlStateManager.SourceFactor.SRC_ALPHA, GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, GlStateManager.SourceFactor.ONE, GlStateManager.DestFactor.ZERO);
        RenderHelper.func_74518_a();
        GlStateManager.depthMask(false);
        this.field_72770_i.func_110577_a(field_110926_k);
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder \u26032 = tessellator.func_178180_c();
        for (int i = 0; i < 6; ++i) {
            GlStateManager.pushMatrix();
            if (i == 1) {
                GlStateManager.rotatef(90.0f, 1.0f, 0.0f, 0.0f);
            }
            if (i == 2) {
                GlStateManager.rotatef(-90.0f, 1.0f, 0.0f, 0.0f);
            }
            if (i == 3) {
                GlStateManager.rotatef(180.0f, 1.0f, 0.0f, 0.0f);
            }
            if (i == 4) {
                GlStateManager.rotatef(90.0f, 0.0f, 0.0f, 1.0f);
            }
            if (i == 5) {
                GlStateManager.rotatef(-90.0f, 0.0f, 0.0f, 1.0f);
            }
            \u26032.func_181668_a(7, DefaultVertexFormats.field_181709_i);
            \u26032.func_181662_b(-100.0, -100.0, -100.0).func_187315_a(0.0, 0.0).func_181669_b(40, 40, 40, 255).func_181675_d();
            \u26032.func_181662_b(-100.0, -100.0, 100.0).func_187315_a(0.0, 16.0).func_181669_b(40, 40, 40, 255).func_181675_d();
            \u26032.func_181662_b(100.0, -100.0, 100.0).func_187315_a(16.0, 16.0).func_181669_b(40, 40, 40, 255).func_181675_d();
            \u26032.func_181662_b(100.0, -100.0, -100.0).func_187315_a(16.0, 0.0).func_181669_b(40, 40, 40, 255).func_181675_d();
            tessellator.func_78381_a();
            GlStateManager.popMatrix();
        }
        GlStateManager.depthMask(true);
        GlStateManager.enableTexture();
        GlStateManager.disableBlend();
        GlStateManager.enableAlphaTest();
    }

    public void func_195465_a(float f2) {
        float f2;
        int \u260310;
        int \u26038;
        if (this.field_72777_q.field_71441_e.field_73011_w.func_186058_p() == DimensionType.field_223229_c_) {
            this.func_180448_r();
            return;
        }
        if (!this.field_72777_q.field_71441_e.field_73011_w.func_76569_d()) {
            return;
        }
        GlStateManager.disableTexture();
        Vec3d vec3d = this.field_72769_h.func_217382_a(this.field_72777_q.field_71460_t.func_215316_n().func_216780_d(), f2);
        float \u26032 = (float)vec3d.field_72450_a;
        float \u26033 = (float)vec3d.field_72448_b;
        float \u26034 = (float)vec3d.field_72449_c;
        GlStateManager.color3f(\u26032, \u26033, \u26034);
        Tessellator \u26035 = Tessellator.func_178181_a();
        BufferBuilder \u26036 = \u26035.func_178180_c();
        GlStateManager.depthMask(false);
        GlStateManager.enableFog();
        GlStateManager.color3f(\u26032, \u26033, \u26034);
        if (this.field_175005_X) {
            this.field_175012_t.func_177359_a();
            GlStateManager.enableClientState(32884);
            GlStateManager.vertexPointer(3, 5126, 12, 0);
            this.field_175012_t.func_177358_a(7);
            VertexBuffer.func_177361_b();
            GlStateManager.disableClientState(32884);
        } else {
            GlStateManager.callList(this.field_72771_w);
        }
        GlStateManager.disableFog();
        GlStateManager.disableAlphaTest();
        GlStateManager.enableBlend();
        GlStateManager.blendFuncSeparate(GlStateManager.SourceFactor.SRC_ALPHA, GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, GlStateManager.SourceFactor.ONE, GlStateManager.DestFactor.ZERO);
        RenderHelper.func_74518_a();
        float[] \u26037 = this.field_72769_h.field_73011_w.func_76560_a(this.field_72769_h.func_72826_c(f2), f2);
        if (\u26037 != null) {
            GlStateManager.disableTexture();
            GlStateManager.shadeModel(7425);
            GlStateManager.pushMatrix();
            GlStateManager.rotatef(90.0f, 1.0f, 0.0f, 0.0f);
            GlStateManager.rotatef(MathHelper.func_76126_a(this.field_72769_h.func_72929_e(f2)) < 0.0f ? 180.0f : 0.0f, 0.0f, 0.0f, 1.0f);
            GlStateManager.rotatef(90.0f, 0.0f, 0.0f, 1.0f);
            float f3 = \u26037[0];
            \u2603 = \u26037[1];
            \u2603 = \u26037[2];
            \u26036.func_181668_a(6, DefaultVertexFormats.field_181706_f);
            \u26036.func_181662_b(0.0, 100.0, 0.0).func_181666_a(f3, \u2603, \u2603, \u26037[3]).func_181675_d();
            \u26038 = 16;
            for (\u260310 = 0; \u260310 <= 16; ++\u260310) {
                float f4 = (float)\u260310 * ((float)Math.PI * 2) / 16.0f;
                \u2603 = MathHelper.func_76126_a(f4);
                \u2603 = MathHelper.func_76134_b(f4);
                \u26036.func_181662_b(\u2603 * 120.0f, \u2603 * 120.0f, -\u2603 * 40.0f * \u26037[3]).func_181666_a(\u26037[0], \u26037[1], \u26037[2], 0.0f).func_181675_d();
            }
            \u26035.func_78381_a();
            GlStateManager.popMatrix();
            GlStateManager.shadeModel(7424);
        }
        GlStateManager.enableTexture();
        GlStateManager.blendFuncSeparate(GlStateManager.SourceFactor.SRC_ALPHA, GlStateManager.DestFactor.ONE, GlStateManager.SourceFactor.ONE, GlStateManager.DestFactor.ZERO);
        GlStateManager.pushMatrix();
        f3 = 1.0f - this.field_72769_h.func_72867_j(f2);
        GlStateManager.color4f(1.0f, 1.0f, 1.0f, f3);
        GlStateManager.rotatef(-90.0f, 0.0f, 1.0f, 0.0f);
        GlStateManager.rotatef(this.field_72769_h.func_72826_c(f2) * 360.0f, 1.0f, 0.0f, 0.0f);
        \u2603 = 30.0f;
        this.field_72770_i.func_110577_a(field_110928_i);
        \u26036.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        \u26036.func_181662_b(-\u2603, 100.0, -\u2603).func_187315_a(0.0, 0.0).func_181675_d();
        \u26036.func_181662_b(\u2603, 100.0, -\u2603).func_187315_a(1.0, 0.0).func_181675_d();
        \u26036.func_181662_b(\u2603, 100.0, \u2603).func_187315_a(1.0, 1.0).func_181675_d();
        \u26036.func_181662_b(-\u2603, 100.0, \u2603).func_187315_a(0.0, 1.0).func_181675_d();
        \u26035.func_78381_a();
        \u2603 = 20.0f;
        this.field_72770_i.func_110577_a(field_110927_h);
        int \u26039 = this.field_72769_h.func_72853_d();
        \u26038 = \u26039 % 4;
        \u260310 = \u26039 / 4 % 2;
        f4 = (float)(\u26038 + 0) / 4.0f;
        \u2603 = (float)(\u260310 + 0) / 2.0f;
        \u2603 = (float)(\u26038 + 1) / 4.0f;
        \u2603 = (float)(\u260310 + 1) / 2.0f;
        \u26036.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        \u26036.func_181662_b(-\u2603, -100.0, \u2603).func_187315_a(\u2603, \u2603).func_181675_d();
        \u26036.func_181662_b(\u2603, -100.0, \u2603).func_187315_a(f4, \u2603).func_181675_d();
        \u26036.func_181662_b(\u2603, -100.0, -\u2603).func_187315_a(f4, \u2603).func_181675_d();
        \u26036.func_181662_b(-\u2603, -100.0, -\u2603).func_187315_a(\u2603, \u2603).func_181675_d();
        \u26035.func_78381_a();
        GlStateManager.disableTexture();
        \u2603 = this.field_72769_h.func_72880_h(f2) * f3;
        if (\u2603 > 0.0f) {
            GlStateManager.color4f(\u2603, \u2603, \u2603, \u2603);
            if (this.field_175005_X) {
                this.field_175013_s.func_177359_a();
                GlStateManager.enableClientState(32884);
                GlStateManager.vertexPointer(3, 5126, 12, 0);
                this.field_175013_s.func_177358_a(7);
                VertexBuffer.func_177361_b();
                GlStateManager.disableClientState(32884);
            } else {
                GlStateManager.callList(this.field_72772_v);
            }
        }
        GlStateManager.color4f(1.0f, 1.0f, 1.0f, 1.0f);
        GlStateManager.disableBlend();
        GlStateManager.enableAlphaTest();
        GlStateManager.enableFog();
        GlStateManager.popMatrix();
        GlStateManager.disableTexture();
        GlStateManager.color3f(0.0f, 0.0f, 0.0f);
        double \u260311 = this.field_72777_q.field_71439_g.func_174824_e((float)f2).field_72448_b - this.field_72769_h.func_72919_O();
        if (\u260311 < 0.0) {
            GlStateManager.pushMatrix();
            GlStateManager.translatef(0.0f, 12.0f, 0.0f);
            if (this.field_175005_X) {
                this.field_175011_u.func_177359_a();
                GlStateManager.enableClientState(32884);
                GlStateManager.vertexPointer(3, 5126, 12, 0);
                this.field_175011_u.func_177358_a(7);
                VertexBuffer.func_177361_b();
                GlStateManager.disableClientState(32884);
            } else {
                GlStateManager.callList(this.field_72781_x);
            }
            GlStateManager.popMatrix();
        }
        if (this.field_72769_h.field_73011_w.func_76561_g()) {
            GlStateManager.color3f(\u26032 * 0.2f + 0.04f, \u26033 * 0.2f + 0.04f, \u26034 * 0.6f + 0.1f);
        } else {
            GlStateManager.color3f(\u26032, \u26033, \u26034);
        }
        GlStateManager.pushMatrix();
        GlStateManager.translatef(0.0f, -((float)(\u260311 - 16.0)), 0.0f);
        GlStateManager.callList(this.field_72781_x);
        GlStateManager.popMatrix();
        GlStateManager.enableTexture();
        GlStateManager.depthMask(true);
    }

    public void func_195466_a(float f, double d, double d2, double d3) {
        if (!this.field_72777_q.field_71441_e.field_73011_w.func_76569_d()) {
            return;
        }
        float f2 = 12.0f;
        \u2603 = 4.0f;
        double \u26032 = 2.0E-4;
        double \u26033 = ((float)this.field_72773_u + f) * 0.03f;
        double \u26034 = (d + \u26033) / 12.0;
        double \u26035 = this.field_72769_h.field_73011_w.func_76571_f() - (float)d2 + 0.33f;
        double \u26036 = d3 / 12.0 + (double)0.33f;
        \u26034 -= (double)(MathHelper.func_76128_c(\u26034 / 2048.0) * 2048);
        \u26036 -= (double)(MathHelper.func_76128_c(\u26036 / 2048.0) * 2048);
        \u2603 = (float)(\u26034 - (double)MathHelper.func_76128_c(\u26034));
        \u2603 = (float)(\u26035 / 4.0 - (double)MathHelper.func_76128_c(\u26035 / 4.0)) * 4.0f;
        \u2603 = (float)(\u26036 - (double)MathHelper.func_76128_c(\u26036));
        Vec3d \u26037 = this.field_72769_h.func_72824_f(f);
        int \u26038 = (int)Math.floor(\u26034);
        int \u26039 = (int)Math.floor(\u26035 / 4.0);
        int \u260310 = (int)Math.floor(\u26036);
        if (\u26038 != this.field_204602_S || \u26039 != this.field_204603_T || \u260310 != this.field_204604_U || this.field_72777_q.field_71474_y.func_216842_e() != this.field_204800_W || this.field_204605_V.func_72436_e(\u26037) > 2.0E-4) {
            this.field_204602_S = \u26038;
            this.field_204603_T = \u26039;
            this.field_204604_U = \u260310;
            this.field_204605_V = \u26037;
            this.field_204800_W = this.field_72777_q.field_71474_y.func_216842_e();
            this.field_204607_y = true;
        }
        if (this.field_204607_y) {
            this.field_204607_y = false;
            Tessellator tessellator = Tessellator.func_178181_a();
            BufferBuilder \u260311 = tessellator.func_178180_c();
            if (this.field_204601_A != null) {
                this.field_204601_A.func_177362_c();
            }
            if (this.field_204608_z >= 0) {
                GLAllocation.func_74523_b(this.field_204608_z);
                this.field_204608_z = -1;
            }
            if (this.field_175005_X) {
                this.field_204601_A = new VertexBuffer(DefaultVertexFormats.field_181712_l);
                this.func_204600_a(\u260311, \u26034, \u26035, \u26036, \u26037);
                \u260311.func_178977_d();
                \u260311.func_178965_a();
                this.field_204601_A.func_181722_a(\u260311.func_178966_f());
            } else {
                this.field_204608_z = GLAllocation.func_74526_a(1);
                GlStateManager.newList(this.field_204608_z, 4864);
                this.func_204600_a(\u260311, \u26034, \u26035, \u26036, \u26037);
                tessellator.func_78381_a();
                GlStateManager.endList();
            }
        }
        GlStateManager.disableCull();
        this.field_72770_i.func_110577_a(field_110925_j);
        GlStateManager.enableBlend();
        GlStateManager.blendFuncSeparate(GlStateManager.SourceFactor.SRC_ALPHA, GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, GlStateManager.SourceFactor.ONE, GlStateManager.DestFactor.ZERO);
        GlStateManager.pushMatrix();
        GlStateManager.scalef(12.0f, 1.0f, 12.0f);
        GlStateManager.translatef(-\u2603, \u2603, -\u2603);
        if (this.field_175005_X && this.field_204601_A != null) {
            this.field_204601_A.func_177359_a();
            GlStateManager.enableClientState(32884);
            GlStateManager.enableClientState(32888);
            GLX.glClientActiveTexture(GLX.GL_TEXTURE0);
            GlStateManager.enableClientState(32886);
            GlStateManager.enableClientState(32885);
            GlStateManager.vertexPointer(3, 5126, 28, 0);
            GlStateManager.texCoordPointer(2, 5126, 28, 12);
            GlStateManager.colorPointer(4, 5121, 28, 20);
            GlStateManager.normalPointer(5120, 28, 24);
            for (int i = \u2603 = this.field_204800_W == CloudOption.FANCY ? 0 : 1; i < 2; ++i) {
                if (i == 0) {
                    GlStateManager.colorMask(false, false, false, false);
                } else {
                    GlStateManager.colorMask(true, true, true, true);
                }
                this.field_204601_A.func_177358_a(7);
            }
            VertexBuffer.func_177361_b();
            GlStateManager.disableClientState(32884);
            GlStateManager.disableClientState(32888);
            GlStateManager.disableClientState(32886);
            GlStateManager.disableClientState(32885);
        } else if (this.field_204608_z >= 0) {
            for (int i = \u2603 = this.field_204800_W == CloudOption.FANCY ? 0 : 1; i < 2; ++i) {
                if (i == 0) {
                    GlStateManager.colorMask(false, false, false, false);
                } else {
                    GlStateManager.colorMask(true, true, true, true);
                }
                GlStateManager.callList(this.field_204608_z);
            }
        }
        GlStateManager.popMatrix();
        GlStateManager.clearCurrentColor();
        GlStateManager.color4f(1.0f, 1.0f, 1.0f, 1.0f);
        GlStateManager.disableBlend();
        GlStateManager.enableCull();
    }

    private void func_204600_a(BufferBuilder bufferBuilder, double d, double d2, double d3, Vec3d vec3d) {
        float f = 4.0f;
        \u2603 = 0.00390625f;
        int \u26032 = 8;
        int \u26033 = 4;
        \u2603 = 9.765625E-4f;
        \u2603 = (float)MathHelper.func_76128_c(d) * 0.00390625f;
        \u2603 = (float)MathHelper.func_76128_c(d3) * 0.00390625f;
        \u2603 = (float)vec3d.field_72450_a;
        \u2603 = (float)vec3d.field_72448_b;
        \u2603 = (float)vec3d.field_72449_c;
        \u2603 = \u2603 * 0.9f;
        \u2603 = \u2603 * 0.9f;
        \u2603 = \u2603 * 0.9f;
        \u2603 = \u2603 * 0.7f;
        \u2603 = \u2603 * 0.7f;
        \u2603 = \u2603 * 0.7f;
        \u2603 = \u2603 * 0.8f;
        \u2603 = \u2603 * 0.8f;
        \u2603 = \u2603 * 0.8f;
        bufferBuilder.func_181668_a(7, DefaultVertexFormats.field_181712_l);
        \u2603 = (float)Math.floor(d2 / 4.0) * 4.0f;
        if (this.field_204800_W == CloudOption.FANCY) {
            for (int i = -3; i <= 4; ++i) {
                for (\u2603 = -3; \u2603 <= 4; ++\u2603) {
                    float f2 = i * 8;
                    \u2603 = \u2603 * 8;
                    if (\u2603 > -5.0f) {
                        bufferBuilder.func_181662_b(f2 + 0.0f, \u2603 + 0.0f, \u2603 + 8.0f).func_187315_a((f2 + 0.0f) * 0.00390625f + \u2603, (\u2603 + 8.0f) * 0.00390625f + \u2603).func_181666_a(\u2603, \u2603, \u2603, 0.8f).func_181663_c(0.0f, -1.0f, 0.0f).func_181675_d();
                        bufferBuilder.func_181662_b(f2 + 8.0f, \u2603 + 0.0f, \u2603 + 8.0f).func_187315_a((f2 + 8.0f) * 0.00390625f + \u2603, (\u2603 + 8.0f) * 0.00390625f + \u2603).func_181666_a(\u2603, \u2603, \u2603, 0.8f).func_181663_c(0.0f, -1.0f, 0.0f).func_181675_d();
                        bufferBuilder.func_181662_b(f2 + 8.0f, \u2603 + 0.0f, \u2603 + 0.0f).func_187315_a((f2 + 8.0f) * 0.00390625f + \u2603, (\u2603 + 0.0f) * 0.00390625f + \u2603).func_181666_a(\u2603, \u2603, \u2603, 0.8f).func_181663_c(0.0f, -1.0f, 0.0f).func_181675_d();
                        bufferBuilder.func_181662_b(f2 + 0.0f, \u2603 + 0.0f, \u2603 + 0.0f).func_187315_a((f2 + 0.0f) * 0.00390625f + \u2603, (\u2603 + 0.0f) * 0.00390625f + \u2603).func_181666_a(\u2603, \u2603, \u2603, 0.8f).func_181663_c(0.0f, -1.0f, 0.0f).func_181675_d();
                    }
                    if (\u2603 <= 5.0f) {
                        bufferBuilder.func_181662_b(f2 + 0.0f, \u2603 + 4.0f - 9.765625E-4f, \u2603 + 8.0f).func_187315_a((f2 + 0.0f) * 0.00390625f + \u2603, (\u2603 + 8.0f) * 0.00390625f + \u2603).func_181666_a(\u2603, \u2603, \u2603, 0.8f).func_181663_c(0.0f, 1.0f, 0.0f).func_181675_d();
                        bufferBuilder.func_181662_b(f2 + 8.0f, \u2603 + 4.0f - 9.765625E-4f, \u2603 + 8.0f).func_187315_a((f2 + 8.0f) * 0.00390625f + \u2603, (\u2603 + 8.0f) * 0.00390625f + \u2603).func_181666_a(\u2603, \u2603, \u2603, 0.8f).func_181663_c(0.0f, 1.0f, 0.0f).func_181675_d();
                        bufferBuilder.func_181662_b(f2 + 8.0f, \u2603 + 4.0f - 9.765625E-4f, \u2603 + 0.0f).func_187315_a((f2 + 8.0f) * 0.00390625f + \u2603, (\u2603 + 0.0f) * 0.00390625f + \u2603).func_181666_a(\u2603, \u2603, \u2603, 0.8f).func_181663_c(0.0f, 1.0f, 0.0f).func_181675_d();
                        bufferBuilder.func_181662_b(f2 + 0.0f, \u2603 + 4.0f - 9.765625E-4f, \u2603 + 0.0f).func_187315_a((f2 + 0.0f) * 0.00390625f + \u2603, (\u2603 + 0.0f) * 0.00390625f + \u2603).func_181666_a(\u2603, \u2603, \u2603, 0.8f).func_181663_c(0.0f, 1.0f, 0.0f).func_181675_d();
                    }
                    if (i > -1) {
                        for (int j = 0; j < 8; ++j) {
                            bufferBuilder.func_181662_b(f2 + (float)j + 0.0f, \u2603 + 0.0f, \u2603 + 8.0f).func_187315_a((f2 + (float)j + 0.5f) * 0.00390625f + \u2603, (\u2603 + 8.0f) * 0.00390625f + \u2603).func_181666_a(\u2603, \u2603, \u2603, 0.8f).func_181663_c(-1.0f, 0.0f, 0.0f).func_181675_d();
                            bufferBuilder.func_181662_b(f2 + (float)j + 0.0f, \u2603 + 4.0f, \u2603 + 8.0f).func_187315_a((f2 + (float)j + 0.5f) * 0.00390625f + \u2603, (\u2603 + 8.0f) * 0.00390625f + \u2603).func_181666_a(\u2603, \u2603, \u2603, 0.8f).func_181663_c(-1.0f, 0.0f, 0.0f).func_181675_d();
                            bufferBuilder.func_181662_b(f2 + (float)j + 0.0f, \u2603 + 4.0f, \u2603 + 0.0f).func_187315_a((f2 + (float)j + 0.5f) * 0.00390625f + \u2603, (\u2603 + 0.0f) * 0.00390625f + \u2603).func_181666_a(\u2603, \u2603, \u2603, 0.8f).func_181663_c(-1.0f, 0.0f, 0.0f).func_181675_d();
                            bufferBuilder.func_181662_b(f2 + (float)j + 0.0f, \u2603 + 0.0f, \u2603 + 0.0f).func_187315_a((f2 + (float)j + 0.5f) * 0.00390625f + \u2603, (\u2603 + 0.0f) * 0.00390625f + \u2603).func_181666_a(\u2603, \u2603, \u2603, 0.8f).func_181663_c(-1.0f, 0.0f, 0.0f).func_181675_d();
                        }
                    }
                    if (i <= 1) {
                        for (j = 0; j < 8; ++j) {
                            bufferBuilder.func_181662_b(f2 + (float)j + 1.0f - 9.765625E-4f, \u2603 + 0.0f, \u2603 + 8.0f).func_187315_a((f2 + (float)j + 0.5f) * 0.00390625f + \u2603, (\u2603 + 8.0f) * 0.00390625f + \u2603).func_181666_a(\u2603, \u2603, \u2603, 0.8f).func_181663_c(1.0f, 0.0f, 0.0f).func_181675_d();
                            bufferBuilder.func_181662_b(f2 + (float)j + 1.0f - 9.765625E-4f, \u2603 + 4.0f, \u2603 + 8.0f).func_187315_a((f2 + (float)j + 0.5f) * 0.00390625f + \u2603, (\u2603 + 8.0f) * 0.00390625f + \u2603).func_181666_a(\u2603, \u2603, \u2603, 0.8f).func_181663_c(1.0f, 0.0f, 0.0f).func_181675_d();
                            bufferBuilder.func_181662_b(f2 + (float)j + 1.0f - 9.765625E-4f, \u2603 + 4.0f, \u2603 + 0.0f).func_187315_a((f2 + (float)j + 0.5f) * 0.00390625f + \u2603, (\u2603 + 0.0f) * 0.00390625f + \u2603).func_181666_a(\u2603, \u2603, \u2603, 0.8f).func_181663_c(1.0f, 0.0f, 0.0f).func_181675_d();
                            bufferBuilder.func_181662_b(f2 + (float)j + 1.0f - 9.765625E-4f, \u2603 + 0.0f, \u2603 + 0.0f).func_187315_a((f2 + (float)j + 0.5f) * 0.00390625f + \u2603, (\u2603 + 0.0f) * 0.00390625f + \u2603).func_181666_a(\u2603, \u2603, \u2603, 0.8f).func_181663_c(1.0f, 0.0f, 0.0f).func_181675_d();
                        }
                    }
                    if (\u2603 > -1) {
                        for (j = 0; j < 8; ++j) {
                            bufferBuilder.func_181662_b(f2 + 0.0f, \u2603 + 4.0f, \u2603 + (float)j + 0.0f).func_187315_a((f2 + 0.0f) * 0.00390625f + \u2603, (\u2603 + (float)j + 0.5f) * 0.00390625f + \u2603).func_181666_a(\u2603, \u2603, \u2603, 0.8f).func_181663_c(0.0f, 0.0f, -1.0f).func_181675_d();
                            bufferBuilder.func_181662_b(f2 + 8.0f, \u2603 + 4.0f, \u2603 + (float)j + 0.0f).func_187315_a((f2 + 8.0f) * 0.00390625f + \u2603, (\u2603 + (float)j + 0.5f) * 0.00390625f + \u2603).func_181666_a(\u2603, \u2603, \u2603, 0.8f).func_181663_c(0.0f, 0.0f, -1.0f).func_181675_d();
                            bufferBuilder.func_181662_b(f2 + 8.0f, \u2603 + 0.0f, \u2603 + (float)j + 0.0f).func_187315_a((f2 + 8.0f) * 0.00390625f + \u2603, (\u2603 + (float)j + 0.5f) * 0.00390625f + \u2603).func_181666_a(\u2603, \u2603, \u2603, 0.8f).func_181663_c(0.0f, 0.0f, -1.0f).func_181675_d();
                            bufferBuilder.func_181662_b(f2 + 0.0f, \u2603 + 0.0f, \u2603 + (float)j + 0.0f).func_187315_a((f2 + 0.0f) * 0.00390625f + \u2603, (\u2603 + (float)j + 0.5f) * 0.00390625f + \u2603).func_181666_a(\u2603, \u2603, \u2603, 0.8f).func_181663_c(0.0f, 0.0f, -1.0f).func_181675_d();
                        }
                    }
                    if (\u2603 > 1) continue;
                    for (j = 0; j < 8; ++j) {
                        bufferBuilder.func_181662_b(f2 + 0.0f, \u2603 + 4.0f, \u2603 + (float)j + 1.0f - 9.765625E-4f).func_187315_a((f2 + 0.0f) * 0.00390625f + \u2603, (\u2603 + (float)j + 0.5f) * 0.00390625f + \u2603).func_181666_a(\u2603, \u2603, \u2603, 0.8f).func_181663_c(0.0f, 0.0f, 1.0f).func_181675_d();
                        bufferBuilder.func_181662_b(f2 + 8.0f, \u2603 + 4.0f, \u2603 + (float)j + 1.0f - 9.765625E-4f).func_187315_a((f2 + 8.0f) * 0.00390625f + \u2603, (\u2603 + (float)j + 0.5f) * 0.00390625f + \u2603).func_181666_a(\u2603, \u2603, \u2603, 0.8f).func_181663_c(0.0f, 0.0f, 1.0f).func_181675_d();
                        bufferBuilder.func_181662_b(f2 + 8.0f, \u2603 + 0.0f, \u2603 + (float)j + 1.0f - 9.765625E-4f).func_187315_a((f2 + 8.0f) * 0.00390625f + \u2603, (\u2603 + (float)j + 0.5f) * 0.00390625f + \u2603).func_181666_a(\u2603, \u2603, \u2603, 0.8f).func_181663_c(0.0f, 0.0f, 1.0f).func_181675_d();
                        bufferBuilder.func_181662_b(f2 + 0.0f, \u2603 + 0.0f, \u2603 + (float)j + 1.0f - 9.765625E-4f).func_187315_a((f2 + 0.0f) * 0.00390625f + \u2603, (\u2603 + (float)j + 0.5f) * 0.00390625f + \u2603).func_181666_a(\u2603, \u2603, \u2603, 0.8f).func_181663_c(0.0f, 0.0f, 1.0f).func_181675_d();
                    }
                }
            }
        } else {
            boolean bl = true;
            int \u26034 = 32;
            for (int i = -32; i < 32; i += 32) {
                for (\u2603 = -32; \u2603 < 32; \u2603 += 32) {
                    bufferBuilder.func_181662_b(i + 0, \u2603, \u2603 + 32).func_187315_a((float)(i + 0) * 0.00390625f + \u2603, (float)(\u2603 + 32) * 0.00390625f + \u2603).func_181666_a(\u2603, \u2603, \u2603, 0.8f).func_181663_c(0.0f, -1.0f, 0.0f).func_181675_d();
                    bufferBuilder.func_181662_b(i + 32, \u2603, \u2603 + 32).func_187315_a((float)(i + 32) * 0.00390625f + \u2603, (float)(\u2603 + 32) * 0.00390625f + \u2603).func_181666_a(\u2603, \u2603, \u2603, 0.8f).func_181663_c(0.0f, -1.0f, 0.0f).func_181675_d();
                    bufferBuilder.func_181662_b(i + 32, \u2603, \u2603 + 0).func_187315_a((float)(i + 32) * 0.00390625f + \u2603, (float)(\u2603 + 0) * 0.00390625f + \u2603).func_181666_a(\u2603, \u2603, \u2603, 0.8f).func_181663_c(0.0f, -1.0f, 0.0f).func_181675_d();
                    bufferBuilder.func_181662_b(i + 0, \u2603, \u2603 + 0).func_187315_a((float)(i + 0) * 0.00390625f + \u2603, (float)(\u2603 + 0) * 0.00390625f + \u2603).func_181666_a(\u2603, \u2603, \u2603, 0.8f).func_181663_c(0.0f, -1.0f, 0.0f).func_181675_d();
                }
            }
        }
    }

    public void func_174967_a(long l) {
        this.field_147595_R |= this.field_174995_M.func_178516_a(l);
        if (!this.field_175009_l.isEmpty()) {
            Iterator<ChunkRender> iterator = this.field_175009_l.iterator();
            while (iterator.hasNext() && (\u2603 = (\u2603 = iterator.next()).func_188281_o() ? this.field_174995_M.func_178505_b(\u2603) : this.field_174995_M.func_178507_a(\u2603))) {
                \u2603.func_188282_m();
                iterator.remove();
                long l2 = l - Util.func_211178_c();
                if (l2 >= 0L) continue;
                break;
            }
        }
    }

    public void func_215322_a(ActiveRenderInfo activeRenderInfo, float f) {
        float \u260320;
        double d;
        double \u260319;
        float f2;
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder \u26032 = tessellator.func_178180_c();
        WorldBorder \u26033 = this.field_72769_h.func_175723_af();
        double \u26034 = this.field_72777_q.field_71474_y.field_151451_c * 16;
        if (activeRenderInfo.func_216785_c().field_72450_a < \u26033.func_177728_d() - \u26034 && activeRenderInfo.func_216785_c().field_72450_a > \u26033.func_177726_b() + \u26034 && activeRenderInfo.func_216785_c().field_72449_c < \u26033.func_177733_e() - \u26034 && activeRenderInfo.func_216785_c().field_72449_c > \u26033.func_177736_c() + \u26034) {
            return;
        }
        double \u26035 = 1.0 - \u26033.func_177729_b(activeRenderInfo.func_216785_c().field_72450_a, activeRenderInfo.func_216785_c().field_72449_c) / \u26034;
        \u26035 = Math.pow(\u26035, 4.0);
        double \u26036 = activeRenderInfo.func_216785_c().field_72450_a;
        double \u26037 = activeRenderInfo.func_216785_c().field_72448_b;
        double \u26038 = activeRenderInfo.func_216785_c().field_72449_c;
        GlStateManager.enableBlend();
        GlStateManager.blendFuncSeparate(GlStateManager.SourceFactor.SRC_ALPHA, GlStateManager.DestFactor.ONE, GlStateManager.SourceFactor.ONE, GlStateManager.DestFactor.ZERO);
        this.field_72770_i.func_110577_a(field_175006_g);
        GlStateManager.depthMask(false);
        GlStateManager.pushMatrix();
        int \u26039 = \u26033.func_177734_a().func_177766_a();
        float \u260310 = (float)(\u26039 >> 16 & 0xFF) / 255.0f;
        float \u260311 = (float)(\u26039 >> 8 & 0xFF) / 255.0f;
        float \u260312 = (float)(\u26039 & 0xFF) / 255.0f;
        GlStateManager.color4f(\u260310, \u260311, \u260312, (float)\u26035);
        GlStateManager.polygonOffset(-3.0f, -3.0f);
        GlStateManager.enablePolygonOffset();
        GlStateManager.alphaFunc(516, 0.1f);
        GlStateManager.enableAlphaTest();
        GlStateManager.disableCull();
        float \u260313 = (float)(Util.func_211177_b() % 3000L) / 3000.0f;
        float \u260314 = 0.0f;
        float \u260315 = 0.0f;
        float \u260316 = 128.0f;
        \u26032.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        \u26032.func_178969_c(-\u26036, -\u26037, -\u26038);
        double \u260317 = Math.max((double)MathHelper.func_76128_c(\u26038 - \u26034), \u26033.func_177736_c());
        double \u260318 = Math.min((double)MathHelper.func_76143_f(\u26038 + \u26034), \u26033.func_177733_e());
        if (\u26036 > \u26033.func_177728_d() - \u26034) {
            f2 = 0.0f;
            \u260319 = \u260317;
            while (\u260319 < \u260318) {
                d = Math.min(1.0, \u260318 - \u260319);
                \u260320 = (float)d * 0.5f;
                \u26032.func_181662_b(\u26033.func_177728_d(), 256.0, \u260319).func_187315_a(\u260313 + f2, \u260313 + 0.0f).func_181675_d();
                \u26032.func_181662_b(\u26033.func_177728_d(), 256.0, \u260319 + d).func_187315_a(\u260313 + \u260320 + f2, \u260313 + 0.0f).func_181675_d();
                \u26032.func_181662_b(\u26033.func_177728_d(), 0.0, \u260319 + d).func_187315_a(\u260313 + \u260320 + f2, \u260313 + 128.0f).func_181675_d();
                \u26032.func_181662_b(\u26033.func_177728_d(), 0.0, \u260319).func_187315_a(\u260313 + f2, \u260313 + 128.0f).func_181675_d();
                \u260319 += 1.0;
                f2 += 0.5f;
            }
        }
        if (\u26036 < \u26033.func_177726_b() + \u26034) {
            f2 = 0.0f;
            \u260319 = \u260317;
            while (\u260319 < \u260318) {
                d = Math.min(1.0, \u260318 - \u260319);
                \u260320 = (float)d * 0.5f;
                \u26032.func_181662_b(\u26033.func_177726_b(), 256.0, \u260319).func_187315_a(\u260313 + f2, \u260313 + 0.0f).func_181675_d();
                \u26032.func_181662_b(\u26033.func_177726_b(), 256.0, \u260319 + d).func_187315_a(\u260313 + \u260320 + f2, \u260313 + 0.0f).func_181675_d();
                \u26032.func_181662_b(\u26033.func_177726_b(), 0.0, \u260319 + d).func_187315_a(\u260313 + \u260320 + f2, \u260313 + 128.0f).func_181675_d();
                \u26032.func_181662_b(\u26033.func_177726_b(), 0.0, \u260319).func_187315_a(\u260313 + f2, \u260313 + 128.0f).func_181675_d();
                \u260319 += 1.0;
                f2 += 0.5f;
            }
        }
        \u260317 = Math.max((double)MathHelper.func_76128_c(\u26036 - \u26034), \u26033.func_177726_b());
        \u260318 = Math.min((double)MathHelper.func_76143_f(\u26036 + \u26034), \u26033.func_177728_d());
        if (\u26038 > \u26033.func_177733_e() - \u26034) {
            f2 = 0.0f;
            \u260319 = \u260317;
            while (\u260319 < \u260318) {
                d = Math.min(1.0, \u260318 - \u260319);
                \u260320 = (float)d * 0.5f;
                \u26032.func_181662_b(\u260319, 256.0, \u26033.func_177733_e()).func_187315_a(\u260313 + f2, \u260313 + 0.0f).func_181675_d();
                \u26032.func_181662_b(\u260319 + d, 256.0, \u26033.func_177733_e()).func_187315_a(\u260313 + \u260320 + f2, \u260313 + 0.0f).func_181675_d();
                \u26032.func_181662_b(\u260319 + d, 0.0, \u26033.func_177733_e()).func_187315_a(\u260313 + \u260320 + f2, \u260313 + 128.0f).func_181675_d();
                \u26032.func_181662_b(\u260319, 0.0, \u26033.func_177733_e()).func_187315_a(\u260313 + f2, \u260313 + 128.0f).func_181675_d();
                \u260319 += 1.0;
                f2 += 0.5f;
            }
        }
        if (\u26038 < \u26033.func_177736_c() + \u26034) {
            f2 = 0.0f;
            \u260319 = \u260317;
            while (\u260319 < \u260318) {
                d = Math.min(1.0, \u260318 - \u260319);
                \u260320 = (float)d * 0.5f;
                \u26032.func_181662_b(\u260319, 256.0, \u26033.func_177736_c()).func_187315_a(\u260313 + f2, \u260313 + 0.0f).func_181675_d();
                \u26032.func_181662_b(\u260319 + d, 256.0, \u26033.func_177736_c()).func_187315_a(\u260313 + \u260320 + f2, \u260313 + 0.0f).func_181675_d();
                \u26032.func_181662_b(\u260319 + d, 0.0, \u26033.func_177736_c()).func_187315_a(\u260313 + \u260320 + f2, \u260313 + 128.0f).func_181675_d();
                \u26032.func_181662_b(\u260319, 0.0, \u26033.func_177736_c()).func_187315_a(\u260313 + f2, \u260313 + 128.0f).func_181675_d();
                \u260319 += 1.0;
                f2 += 0.5f;
            }
        }
        tessellator.func_78381_a();
        \u26032.func_178969_c(0.0, 0.0, 0.0);
        GlStateManager.enableCull();
        GlStateManager.disableAlphaTest();
        GlStateManager.polygonOffset(0.0f, 0.0f);
        GlStateManager.disablePolygonOffset();
        GlStateManager.enableAlphaTest();
        GlStateManager.disableBlend();
        GlStateManager.popMatrix();
        GlStateManager.depthMask(true);
    }

    private void func_180443_s() {
        GlStateManager.blendFuncSeparate(GlStateManager.SourceFactor.DST_COLOR, GlStateManager.DestFactor.SRC_COLOR, GlStateManager.SourceFactor.ONE, GlStateManager.DestFactor.ZERO);
        GlStateManager.enableBlend();
        GlStateManager.color4f(1.0f, 1.0f, 1.0f, 0.5f);
        GlStateManager.polygonOffset(-1.0f, -10.0f);
        GlStateManager.enablePolygonOffset();
        GlStateManager.alphaFunc(516, 0.1f);
        GlStateManager.enableAlphaTest();
        GlStateManager.pushMatrix();
    }

    private void func_174969_t() {
        GlStateManager.disableAlphaTest();
        GlStateManager.polygonOffset(0.0f, 0.0f);
        GlStateManager.disablePolygonOffset();
        GlStateManager.enableAlphaTest();
        GlStateManager.depthMask(true);
        GlStateManager.popMatrix();
    }

    public void func_215318_a(Tessellator tessellator, BufferBuilder bufferBuilder, ActiveRenderInfo activeRenderInfo) {
        double d = activeRenderInfo.func_216785_c().field_72450_a;
        \u2603 = activeRenderInfo.func_216785_c().field_72448_b;
        \u2603 = activeRenderInfo.func_216785_c().field_72449_c;
        if (!this.field_72738_E.isEmpty()) {
            this.field_72770_i.func_110577_a(AtlasTexture.field_110575_b);
            this.func_180443_s();
            bufferBuilder.func_181668_a(7, DefaultVertexFormats.field_176600_a);
            bufferBuilder.func_178969_c(-d, -\u2603, -\u2603);
            bufferBuilder.func_78914_f();
            Iterator<DestroyBlockProgress> iterator = this.field_72738_E.values().iterator();
            while (iterator.hasNext()) {
                DestroyBlockProgress destroyBlockProgress = iterator.next();
                BlockPos \u26032 = destroyBlockProgress.func_180246_b();
                Block \u26033 = this.field_72769_h.func_180495_p(\u26032).func_177230_c();
                if (\u26033 instanceof ChestBlock || \u26033 instanceof EnderChestBlock || \u26033 instanceof AbstractSignBlock || \u26033 instanceof AbstractSkullBlock) continue;
                double \u26034 = (double)\u26032.func_177958_n() - d;
                if (\u26034 * \u26034 + (\u2603 = (double)\u26032.func_177956_o() - \u2603) * \u2603 + (\u2603 = (double)\u26032.func_177952_p() - \u2603) * \u2603 > 1024.0) {
                    iterator.remove();
                    continue;
                }
                BlockState \u26035 = this.field_72769_h.func_180495_p(\u26032);
                if (\u26035.func_196958_f()) continue;
                int \u26036 = destroyBlockProgress.func_73106_e();
                TextureAtlasSprite \u26037 = this.field_94141_F[\u26036];
                BlockRendererDispatcher \u26038 = this.field_72777_q.func_175602_ab();
                \u26038.func_215329_a(\u26035, \u26032, \u26037, this.field_72769_h);
            }
            tessellator.func_78381_a();
            bufferBuilder.func_178969_c(0.0, 0.0, 0.0);
            this.func_174969_t();
        }
    }

    public void func_215325_a(ActiveRenderInfo activeRenderInfo, RayTraceResult rayTraceResult, int n) {
        if (n == 0 && rayTraceResult.func_216346_c() == RayTraceResult.Type.BLOCK && !(\u2603 = this.field_72769_h.func_180495_p(\u2603 = ((BlockRayTraceResult)rayTraceResult).func_216350_a())).func_196958_f() && this.field_72769_h.func_175723_af().func_177746_a(\u2603)) {
            GlStateManager.enableBlend();
            GlStateManager.blendFuncSeparate(GlStateManager.SourceFactor.SRC_ALPHA, GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, GlStateManager.SourceFactor.ONE, GlStateManager.DestFactor.ZERO);
            GlStateManager.lineWidth(Math.max(2.5f, (float)this.field_72777_q.field_195558_d.func_198109_k() / 1920.0f * 2.5f));
            GlStateManager.disableTexture();
            GlStateManager.depthMask(false);
            GlStateManager.matrixMode(5889);
            GlStateManager.pushMatrix();
            GlStateManager.scalef(1.0f, 1.0f, 0.999f);
            double d = activeRenderInfo.func_216785_c().field_72450_a;
            \u2603 = activeRenderInfo.func_216785_c().field_72448_b;
            \u2603 = activeRenderInfo.func_216785_c().field_72449_c;
            WorldRenderer.func_195463_b(\u2603.func_215700_a(this.field_72769_h, \u2603, ISelectionContext.func_216374_a(activeRenderInfo.func_216773_g())), (double)\u2603.func_177958_n() - d, (double)\u2603.func_177956_o() - \u2603, (double)\u2603.func_177952_p() - \u2603, 0.0f, 0.0f, 0.0f, 0.4f);
            GlStateManager.popMatrix();
            GlStateManager.matrixMode(5888);
            GlStateManager.depthMask(true);
            GlStateManager.enableTexture();
            GlStateManager.disableBlend();
        }
    }

    public static void func_195470_a(VoxelShape voxelShape, double d, double d2, double d3, float f, float f2, float f3, float f4) {
        List<AxisAlignedBB> list = voxelShape.func_197756_d();
        int \u26032 = MathHelper.func_76143_f((double)list.size() / 3.0);
        for (int i = 0; i < list.size(); ++i) {
            AxisAlignedBB axisAlignedBB = list.get(i);
            float \u26033 = ((float)i % (float)\u26032 + 1.0f) / (float)\u26032;
            float \u26034 = i / \u26032;
            float \u26035 = \u26033 * (float)(\u26034 == 0.0f ? 1 : 0);
            float \u26036 = \u26033 * (float)(\u26034 == 1.0f ? 1 : 0);
            float \u26037 = \u26033 * (float)(\u26034 == 2.0f ? 1 : 0);
            WorldRenderer.func_195463_b(VoxelShapes.func_197881_a(axisAlignedBB.func_72317_d(0.0, 0.0, 0.0)), d, d2, d3, \u26035, \u26036, \u26037, 1.0f);
        }
    }

    public static void func_195463_b(VoxelShape voxelShape, double d, double d2, double d3, float f, float f2, float f3, float f4) {
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder \u26032 = tessellator.func_178180_c();
        \u26032.func_181668_a(1, DefaultVertexFormats.field_181706_f);
        voxelShape.func_197754_a((d4, d5, d6, d7, d8, d9) -> {
            \u26032.func_181662_b(d4 + d, d5 + d2, d6 + d3).func_181666_a(f, f2, f3, f4).func_181675_d();
            \u26032.func_181662_b(d7 + d, d8 + d2, d9 + d3).func_181666_a(f, f2, f3, f4).func_181675_d();
        });
        tessellator.func_78381_a();
    }

    public static void func_189697_a(AxisAlignedBB axisAlignedBB, float f, float f2, float f3, float f4) {
        WorldRenderer.func_189694_a(axisAlignedBB.field_72340_a, axisAlignedBB.field_72338_b, axisAlignedBB.field_72339_c, axisAlignedBB.field_72336_d, axisAlignedBB.field_72337_e, axisAlignedBB.field_72334_f, f, f2, f3, f4);
    }

    public static void func_189694_a(double d, double d2, double d3, double d4, double d5, double d6, float f, float f2, float f3, float f4) {
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder \u26032 = tessellator.func_178180_c();
        \u26032.func_181668_a(3, DefaultVertexFormats.field_181706_f);
        WorldRenderer.func_189698_a(\u26032, d, d2, d3, d4, d5, d6, f, f2, f3, f4);
        tessellator.func_78381_a();
    }

    public static void func_189698_a(BufferBuilder bufferBuilder, double d, double d2, double d3, double d4, double d5, double d6, float f, float f2, float f3, float f4) {
        bufferBuilder.func_181662_b(d, d2, d3).func_181666_a(f, f2, f3, 0.0f).func_181675_d();
        bufferBuilder.func_181662_b(d, d2, d3).func_181666_a(f, f2, f3, f4).func_181675_d();
        bufferBuilder.func_181662_b(d4, d2, d3).func_181666_a(f, f2, f3, f4).func_181675_d();
        bufferBuilder.func_181662_b(d4, d2, d6).func_181666_a(f, f2, f3, f4).func_181675_d();
        bufferBuilder.func_181662_b(d, d2, d6).func_181666_a(f, f2, f3, f4).func_181675_d();
        bufferBuilder.func_181662_b(d, d2, d3).func_181666_a(f, f2, f3, f4).func_181675_d();
        bufferBuilder.func_181662_b(d, d5, d3).func_181666_a(f, f2, f3, f4).func_181675_d();
        bufferBuilder.func_181662_b(d4, d5, d3).func_181666_a(f, f2, f3, f4).func_181675_d();
        bufferBuilder.func_181662_b(d4, d5, d6).func_181666_a(f, f2, f3, f4).func_181675_d();
        bufferBuilder.func_181662_b(d, d5, d6).func_181666_a(f, f2, f3, f4).func_181675_d();
        bufferBuilder.func_181662_b(d, d5, d3).func_181666_a(f, f2, f3, f4).func_181675_d();
        bufferBuilder.func_181662_b(d, d5, d6).func_181666_a(f, f2, f3, 0.0f).func_181675_d();
        bufferBuilder.func_181662_b(d, d2, d6).func_181666_a(f, f2, f3, f4).func_181675_d();
        bufferBuilder.func_181662_b(d4, d5, d6).func_181666_a(f, f2, f3, 0.0f).func_181675_d();
        bufferBuilder.func_181662_b(d4, d2, d6).func_181666_a(f, f2, f3, f4).func_181675_d();
        bufferBuilder.func_181662_b(d4, d5, d3).func_181666_a(f, f2, f3, 0.0f).func_181675_d();
        bufferBuilder.func_181662_b(d4, d2, d3).func_181666_a(f, f2, f3, f4).func_181675_d();
        bufferBuilder.func_181662_b(d4, d2, d3).func_181666_a(f, f2, f3, 0.0f).func_181675_d();
    }

    public static void func_189693_b(BufferBuilder bufferBuilder, double d, double d2, double d3, double d4, double d5, double d6, float f, float f2, float f3, float f4) {
        bufferBuilder.func_181662_b(d, d2, d3).func_181666_a(f, f2, f3, f4).func_181675_d();
        bufferBuilder.func_181662_b(d, d2, d3).func_181666_a(f, f2, f3, f4).func_181675_d();
        bufferBuilder.func_181662_b(d, d2, d3).func_181666_a(f, f2, f3, f4).func_181675_d();
        bufferBuilder.func_181662_b(d, d2, d6).func_181666_a(f, f2, f3, f4).func_181675_d();
        bufferBuilder.func_181662_b(d, d5, d3).func_181666_a(f, f2, f3, f4).func_181675_d();
        bufferBuilder.func_181662_b(d, d5, d6).func_181666_a(f, f2, f3, f4).func_181675_d();
        bufferBuilder.func_181662_b(d, d5, d6).func_181666_a(f, f2, f3, f4).func_181675_d();
        bufferBuilder.func_181662_b(d, d2, d6).func_181666_a(f, f2, f3, f4).func_181675_d();
        bufferBuilder.func_181662_b(d4, d5, d6).func_181666_a(f, f2, f3, f4).func_181675_d();
        bufferBuilder.func_181662_b(d4, d2, d6).func_181666_a(f, f2, f3, f4).func_181675_d();
        bufferBuilder.func_181662_b(d4, d2, d6).func_181666_a(f, f2, f3, f4).func_181675_d();
        bufferBuilder.func_181662_b(d4, d2, d3).func_181666_a(f, f2, f3, f4).func_181675_d();
        bufferBuilder.func_181662_b(d4, d5, d6).func_181666_a(f, f2, f3, f4).func_181675_d();
        bufferBuilder.func_181662_b(d4, d5, d3).func_181666_a(f, f2, f3, f4).func_181675_d();
        bufferBuilder.func_181662_b(d4, d5, d3).func_181666_a(f, f2, f3, f4).func_181675_d();
        bufferBuilder.func_181662_b(d4, d2, d3).func_181666_a(f, f2, f3, f4).func_181675_d();
        bufferBuilder.func_181662_b(d, d5, d3).func_181666_a(f, f2, f3, f4).func_181675_d();
        bufferBuilder.func_181662_b(d, d2, d3).func_181666_a(f, f2, f3, f4).func_181675_d();
        bufferBuilder.func_181662_b(d, d2, d3).func_181666_a(f, f2, f3, f4).func_181675_d();
        bufferBuilder.func_181662_b(d4, d2, d3).func_181666_a(f, f2, f3, f4).func_181675_d();
        bufferBuilder.func_181662_b(d, d2, d6).func_181666_a(f, f2, f3, f4).func_181675_d();
        bufferBuilder.func_181662_b(d4, d2, d6).func_181666_a(f, f2, f3, f4).func_181675_d();
        bufferBuilder.func_181662_b(d4, d2, d6).func_181666_a(f, f2, f3, f4).func_181675_d();
        bufferBuilder.func_181662_b(d, d5, d3).func_181666_a(f, f2, f3, f4).func_181675_d();
        bufferBuilder.func_181662_b(d, d5, d3).func_181666_a(f, f2, f3, f4).func_181675_d();
        bufferBuilder.func_181662_b(d, d5, d6).func_181666_a(f, f2, f3, f4).func_181675_d();
        bufferBuilder.func_181662_b(d4, d5, d3).func_181666_a(f, f2, f3, f4).func_181675_d();
        bufferBuilder.func_181662_b(d4, d5, d6).func_181666_a(f, f2, f3, f4).func_181675_d();
        bufferBuilder.func_181662_b(d4, d5, d6).func_181666_a(f, f2, f3, f4).func_181675_d();
        bufferBuilder.func_181662_b(d4, d5, d6).func_181666_a(f, f2, f3, f4).func_181675_d();
    }

    public void func_184376_a(IBlockReader iBlockReader, BlockPos blockPos, BlockState blockState, BlockState blockState2, int n) {
        this.func_215324_a(blockPos, (n & 8) != 0);
    }

    private void func_215324_a(BlockPos blockPos, boolean bl) {
        for (int i = blockPos.func_177952_p() - 1; i <= blockPos.func_177952_p() + 1; ++i) {
            for (\u2603 = blockPos.func_177958_n() - 1; \u2603 <= blockPos.func_177958_n() + 1; ++\u2603) {
                for (\u2603 = blockPos.func_177956_o() - 1; \u2603 <= blockPos.func_177956_o() + 1; ++\u2603) {
                    this.func_215319_a(\u2603 >> 4, \u2603 >> 4, i >> 4, bl);
                }
            }
        }
    }

    public void func_147585_a(int n, int n2, int n3, int n4, int n5, int n6) {
        for (\u2603 = n3 - 1; \u2603 <= n6 + 1; ++\u2603) {
            for (\u2603 = n - 1; \u2603 <= n4 + 1; ++\u2603) {
                for (\u2603 = n2 - 1; \u2603 <= n5 + 1; ++\u2603) {
                    this.func_215328_b(\u2603 >> 4, \u2603 >> 4, \u2603 >> 4);
                }
            }
        }
    }

    public void func_224746_a(BlockPos blockPos, BlockState blockState, BlockState blockState2) {
        if (this.field_72777_q.func_209506_al().func_224742_a(blockState, blockState2)) {
            this.func_147585_a(blockPos.func_177958_n(), blockPos.func_177956_o(), blockPos.func_177952_p(), blockPos.func_177958_n(), blockPos.func_177956_o(), blockPos.func_177952_p());
        }
    }

    public void func_215321_a(int n, int n2, int n3) {
        for (\u2603 = n3 - 1; \u2603 <= n3 + 1; ++\u2603) {
            for (\u2603 = n - 1; \u2603 <= n + 1; ++\u2603) {
                for (\u2603 = n2 - 1; \u2603 <= n2 + 1; ++\u2603) {
                    this.func_215328_b(\u2603, \u2603, \u2603);
                }
            }
        }
    }

    public void func_215328_b(int n, int n2, int n3) {
        this.func_215319_a(n, n2, n3, false);
    }

    private void func_215319_a(int n, int n2, int n3, boolean bl) {
        this.field_175008_n.func_217628_a(n, n2, n3, bl);
    }

    public void func_184377_a(@Nullable SoundEvent soundEvent, BlockPos blockPos) {
        ISound \u26032 = this.field_147593_P.get(blockPos);
        if (\u26032 != null) {
            this.field_72777_q.func_147118_V().func_147683_b(\u26032);
            this.field_147593_P.remove(blockPos);
        }
        if (soundEvent != null) {
            MusicDiscItem musicDiscItem = MusicDiscItem.func_185074_a(soundEvent);
            if (musicDiscItem != null) {
                this.field_72777_q.field_71456_v.func_73833_a(musicDiscItem.func_200299_h().func_150254_d());
            }
            \u26032 = SimpleSound.func_184372_a(soundEvent, blockPos.func_177958_n(), blockPos.func_177956_o(), blockPos.func_177952_p());
            this.field_147593_P.put(blockPos, \u26032);
            this.field_72777_q.func_147118_V().func_147682_a(\u26032);
        }
        this.func_193054_a(this.field_72769_h, blockPos, soundEvent != null);
    }

    private void func_193054_a(World world, BlockPos blockPos, boolean bl) {
        List<LivingEntity> list = world.func_217357_a(LivingEntity.class, new AxisAlignedBB(blockPos).func_186662_g(3.0));
        for (LivingEntity livingEntity : list) {
            livingEntity.func_191987_a(blockPos, bl);
        }
    }

    public void func_195461_a(IParticleData iParticleData, boolean bl, double d, double d2, double d3, double d4, double d5, double d6) {
        this.func_195462_a(iParticleData, bl, false, d, d2, d3, d4, d5, d6);
    }

    public void func_195462_a(IParticleData iParticleData, boolean bl, boolean bl2, double d, double d2, double d3, double d4, double d5, double d6) {
        try {
            this.func_195469_b(iParticleData, bl, bl2, d, d2, d3, d4, d5, d6);
        }
        catch (Throwable throwable) {
            CrashReport crashReport = CrashReport.func_85055_a(throwable, "Exception while adding particle");
            CrashReportCategory \u26032 = crashReport.func_85058_a("Particle being added");
            \u26032.func_71507_a("ID", Registry.field_212632_u.func_177774_c(iParticleData.func_197554_b()));
            \u26032.func_71507_a("Parameters", iParticleData.func_197555_a());
            \u26032.func_189529_a("Position", () -> CrashReportCategory.func_85074_a(d, d2, d3));
            throw new ReportedException(crashReport);
        }
    }

    private <T extends IParticleData> void func_195467_a(T t, double d, double d2, double d3, double d4, double d5, double d6) {
        this.func_195461_a(t, t.func_197554_b().func_197575_f(), d, d2, d3, d4, d5, d6);
    }

    @Nullable
    private Particle func_195471_b(IParticleData iParticleData, boolean bl, double d, double d2, double d3, double d4, double d5, double d6) {
        return this.func_195469_b(iParticleData, bl, false, d, d2, d3, d4, d5, d6);
    }

    @Nullable
    private Particle func_195469_b(IParticleData iParticleData, boolean bl, boolean bl2, double d, double d2, double d3, double d4, double d5, double d6) {
        ActiveRenderInfo activeRenderInfo = this.field_72777_q.field_71460_t.func_215316_n();
        if (this.field_72777_q == null || !activeRenderInfo.func_216786_h() || this.field_72777_q.field_71452_i == null) {
            return null;
        }
        ParticleStatus \u26032 = this.func_215327_a(bl2);
        if (bl) {
            return this.field_72777_q.field_71452_i.func_199280_a(iParticleData, d, d2, d3, d4, d5, d6);
        }
        if (activeRenderInfo.func_216785_c().func_186679_c(d, d2, d3) > 1024.0) {
            return null;
        }
        if (\u26032 == ParticleStatus.MINIMAL) {
            return null;
        }
        return this.field_72777_q.field_71452_i.func_199280_a(iParticleData, d, d2, d3, d4, d5, d6);
    }

    private ParticleStatus func_215327_a(boolean bl) {
        ParticleStatus particleStatus = this.field_72777_q.field_71474_y.field_74362_aa;
        if (bl && particleStatus == ParticleStatus.MINIMAL && this.field_72769_h.field_73012_v.nextInt(10) == 0) {
            particleStatus = ParticleStatus.DECREASED;
        }
        if (particleStatus == ParticleStatus.DECREASED && this.field_72769_h.field_73012_v.nextInt(3) == 0) {
            particleStatus = ParticleStatus.MINIMAL;
        }
        return particleStatus;
    }

    public void func_72728_f() {
    }

    public void func_180440_a(int n, BlockPos blockPos, int n2) {
        switch (n) {
            case 1023: 
            case 1028: 
            case 1038: {
                ActiveRenderInfo activeRenderInfo = this.field_72777_q.field_71460_t.func_215316_n();
                if (!activeRenderInfo.func_216786_h()) break;
                double \u26032 = (double)blockPos.func_177958_n() - activeRenderInfo.func_216785_c().field_72450_a;
                double \u26033 = (double)blockPos.func_177956_o() - activeRenderInfo.func_216785_c().field_72448_b;
                double \u26034 = (double)blockPos.func_177952_p() - activeRenderInfo.func_216785_c().field_72449_c;
                double \u26035 = Math.sqrt(\u26032 * \u26032 + \u26033 * \u26033 + \u26034 * \u26034);
                double \u26036 = activeRenderInfo.func_216785_c().field_72450_a;
                double \u26037 = activeRenderInfo.func_216785_c().field_72448_b;
                double \u26038 = activeRenderInfo.func_216785_c().field_72449_c;
                if (\u26035 > 0.0) {
                    \u26036 += \u26032 / \u26035 * 2.0;
                    \u26037 += \u26033 / \u26035 * 2.0;
                    \u26038 += \u26034 / \u26035 * 2.0;
                }
                if (n == 1023) {
                    this.field_72769_h.func_184134_a(\u26036, \u26037, \u26038, SoundEvents.field_187855_gD, SoundCategory.HOSTILE, 1.0f, 1.0f, false);
                    break;
                }
                if (n == 1038) {
                    this.field_72769_h.func_184134_a(\u26036, \u26037, \u26038, SoundEvents.field_193782_bq, SoundCategory.HOSTILE, 1.0f, 1.0f, false);
                    break;
                }
                this.field_72769_h.func_184134_a(\u26036, \u26037, \u26038, SoundEvents.field_187522_aL, SoundCategory.HOSTILE, 5.0f, 1.0f, false);
            }
        }
    }

    public void func_180439_a(PlayerEntity playerEntity, int n, BlockPos blockPos2, int n22) {
        Random random = this.field_72769_h.field_73012_v;
        switch (n) {
            case 1035: {
                this.field_72769_h.func_184156_a(blockPos2, SoundEvents.field_187621_J, SoundCategory.BLOCKS, 1.0f, 1.0f, false);
                break;
            }
            case 1033: {
                this.field_72769_h.func_184156_a(blockPos2, SoundEvents.field_187542_ac, SoundCategory.BLOCKS, 1.0f, 1.0f, false);
                break;
            }
            case 1034: {
                this.field_72769_h.func_184156_a(blockPos2, SoundEvents.field_187540_ab, SoundCategory.BLOCKS, 1.0f, 1.0f, false);
                break;
            }
            case 1032: {
                this.field_72777_q.func_147118_V().func_147682_a(SimpleSound.func_184371_a(SoundEvents.field_187812_eh, random.nextFloat() * 0.4f + 0.8f));
                break;
            }
            case 1001: {
                this.field_72769_h.func_184156_a(blockPos2, SoundEvents.field_187576_at, SoundCategory.BLOCKS, 1.0f, 1.2f, false);
                break;
            }
            case 1000: {
                this.field_72769_h.func_184156_a(blockPos2, SoundEvents.field_187574_as, SoundCategory.BLOCKS, 1.0f, 1.0f, false);
                break;
            }
            case 1003: {
                this.field_72769_h.func_184156_a(blockPos2, SoundEvents.field_187528_aR, SoundCategory.NEUTRAL, 1.0f, 1.2f, false);
                break;
            }
            case 1004: {
                this.field_72769_h.func_184156_a(blockPos2, SoundEvents.field_187634_bp, SoundCategory.NEUTRAL, 1.0f, 1.2f, false);
                break;
            }
            case 1002: {
                this.field_72769_h.func_184156_a(blockPos2, SoundEvents.field_187578_au, SoundCategory.BLOCKS, 1.0f, 1.2f, false);
                break;
            }
            case 2000: {
                Direction direction = Direction.func_82600_a(n22);
                int \u26032 = direction.func_82601_c();
                int \u26033 = direction.func_96559_d();
                int \u26034 = direction.func_82599_e();
                double \u26035 = (double)blockPos2.func_177958_n() + (double)\u26032 * 0.6 + 0.5;
                double \u26036 = (double)blockPos2.func_177956_o() + (double)\u26033 * 0.6 + 0.5;
                double \u26037 = (double)blockPos2.func_177952_p() + (double)\u26034 * 0.6 + 0.5;
                for (int i = 0; i < 10; ++i) {
                    double d = random.nextDouble() * 0.2 + 0.01;
                    \u2603 = \u26035 + (double)\u26032 * 0.01 + (random.nextDouble() - 0.5) * (double)\u26034 * 0.5;
                    \u2603 = \u26036 + (double)\u26033 * 0.01 + (random.nextDouble() - 0.5) * (double)\u26033 * 0.5;
                    \u2603 = \u26037 + (double)\u26034 * 0.01 + (random.nextDouble() - 0.5) * (double)\u26032 * 0.5;
                    \u2603 = (double)\u26032 * d + random.nextGaussian() * 0.01;
                    \u2603 = (double)\u26033 * d + random.nextGaussian() * 0.01;
                    \u2603 = (double)\u26034 * d + random.nextGaussian() * 0.01;
                    this.func_195467_a(ParticleTypes.field_197601_L, \u2603, \u2603, \u2603, \u2603, \u2603, \u2603);
                }
                break;
            }
            case 2003: {
                BlockPos blockPos2;
                double \u26038 = (double)blockPos2.func_177958_n() + 0.5;
                double \u26039 = blockPos2.func_177956_o();
                double \u260310 = (double)blockPos2.func_177952_p() + 0.5;
                for (int i = 0; i < 8; ++i) {
                    this.func_195467_a(new ItemParticleData(ParticleTypes.field_197591_B, new ItemStack(Items.field_151061_bv)), \u26038, \u26039, \u260310, random.nextGaussian() * 0.15, random.nextDouble() * 0.2, random.nextGaussian() * 0.15);
                }
                for (double d = 0.0; d < Math.PI * 2; d += 0.15707963267948966) {
                    this.func_195467_a(ParticleTypes.field_197599_J, \u26038 + Math.cos(d) * 5.0, \u26039 - 0.4, \u260310 + Math.sin(d) * 5.0, Math.cos(d) * -5.0, 0.0, Math.sin(d) * -5.0);
                    this.func_195467_a(ParticleTypes.field_197599_J, \u26038 + Math.cos(d) * 5.0, \u26039 - 0.4, \u260310 + Math.sin(d) * 5.0, Math.cos(d) * -7.0, 0.0, Math.sin(d) * -7.0);
                }
                break;
            }
            case 2002: 
            case 2007: {
                int n22;
                BlockPos blockPos2;
                double \u260311 = blockPos2.func_177958_n();
                double \u260312 = blockPos2.func_177956_o();
                double \u260313 = blockPos2.func_177952_p();
                for (int i = 0; i < 8; ++i) {
                    this.func_195467_a(new ItemParticleData(ParticleTypes.field_197591_B, new ItemStack(Items.field_185155_bH)), \u260311, \u260312, \u260313, random.nextGaussian() * 0.15, random.nextDouble() * 0.2, random.nextGaussian() * 0.15);
                }
                float \u260314 = (float)(n22 >> 16 & 0xFF) / 255.0f;
                float \u260315 = (float)(n22 >> 8 & 0xFF) / 255.0f;
                float \u260316 = (float)(n22 >> 0 & 0xFF) / 255.0f;
                BasicParticleType \u260317 = n == 2007 ? ParticleTypes.field_197590_A : ParticleTypes.field_197620_m;
                for (\u2603 = 0; \u2603 < 100; ++\u2603) {
                    double d = random.nextDouble() * 4.0;
                    \u2603 = random.nextDouble() * Math.PI * 2.0;
                    \u2603 = Math.cos(\u2603) * d;
                    \u2603 = 0.01 + random.nextDouble() * 0.5;
                    \u2603 = Math.sin(\u2603) * d;
                    Particle \u260318 = this.func_195471_b(\u260317, \u260317.func_197554_b().func_197575_f(), \u260311 + \u2603 * 0.1, \u260312 + 0.3, \u260313 + \u2603 * 0.1, \u2603, \u2603, \u2603);
                    if (\u260318 == null) continue;
                    float \u260319 = 0.75f + random.nextFloat() * 0.25f;
                    \u260318.func_70538_b(\u260314 * \u260319, \u260315 * \u260319, \u260316 * \u260319);
                    \u260318.func_70543_e((float)d);
                }
                this.field_72769_h.func_184156_a(blockPos2, SoundEvents.field_187825_fO, SoundCategory.NEUTRAL, 1.0f, this.field_72769_h.field_73012_v.nextFloat() * 0.1f + 0.9f, false);
                break;
            }
            case 2001: {
                BlockPos blockPos2;
                BlockState blockState = Block.func_196257_b(n22);
                if (!blockState.func_196958_f()) {
                    SoundType soundType = blockState.func_215695_r();
                    this.field_72769_h.func_184156_a(blockPos2, soundType.func_185845_c(), SoundCategory.BLOCKS, (soundType.func_185843_a() + 1.0f) / 2.0f, soundType.func_185847_b() * 0.8f, false);
                }
                this.field_72777_q.field_71452_i.func_180533_a(blockPos2, blockState);
                break;
            }
            case 2004: {
                for (int i = 0; i < 20; ++i) {
                    double d = (double)blockPos2.func_177958_n() + 0.5 + ((double)this.field_72769_h.field_73012_v.nextFloat() - 0.5) * 2.0;
                    \u2603 = (double)blockPos2.func_177956_o() + 0.5 + ((double)this.field_72769_h.field_73012_v.nextFloat() - 0.5) * 2.0;
                    \u2603 = (double)blockPos2.func_177952_p() + 0.5 + ((double)this.field_72769_h.field_73012_v.nextFloat() - 0.5) * 2.0;
                    this.field_72769_h.func_195594_a(ParticleTypes.field_197601_L, d, \u2603, \u2603, 0.0, 0.0, 0.0);
                    this.field_72769_h.func_195594_a(ParticleTypes.field_197631_x, d, \u2603, \u2603, 0.0, 0.0, 0.0);
                }
                break;
            }
            case 2005: {
                BlockPos blockPos2;
                BoneMealItem.func_195965_a(this.field_72769_h, blockPos2, n22);
                break;
            }
            case 2008: {
                BlockPos blockPos2;
                this.field_72769_h.func_195594_a(ParticleTypes.field_197627_t, (double)blockPos2.func_177958_n() + 0.5, (double)blockPos2.func_177956_o() + 0.5, (double)blockPos2.func_177952_p() + 0.5, 0.0, 0.0, 0.0);
                break;
            }
            case 1500: {
                BlockPos blockPos2;
                ComposterBlock.func_220292_a(this.field_72769_h, blockPos2, n22 > 0);
                break;
            }
            case 1501: {
                BlockPos blockPos2;
                this.field_72769_h.func_184156_a(blockPos2, SoundEvents.field_187659_cY, SoundCategory.BLOCKS, 0.5f, 2.6f + (this.field_72769_h.func_201674_k().nextFloat() - this.field_72769_h.func_201674_k().nextFloat()) * 0.8f, false);
                for (int i = 0; i < 8; ++i) {
                    this.field_72769_h.func_195594_a(ParticleTypes.field_197594_E, (double)blockPos2.func_177958_n() + Math.random(), (double)blockPos2.func_177956_o() + 1.2, (double)blockPos2.func_177952_p() + Math.random(), 0.0, 0.0, 0.0);
                }
                break;
            }
            case 1502: {
                BlockPos blockPos2;
                this.field_72769_h.func_184156_a(blockPos2, SoundEvents.field_187745_eA, SoundCategory.BLOCKS, 0.5f, 2.6f + (this.field_72769_h.field_73012_v.nextFloat() - this.field_72769_h.field_73012_v.nextFloat()) * 0.8f, false);
                for (int i = 0; i < 5; ++i) {
                    double d = (double)blockPos2.func_177958_n() + random.nextDouble() * 0.6 + 0.2;
                    \u2603 = (double)blockPos2.func_177956_o() + random.nextDouble() * 0.6 + 0.2;
                    \u2603 = (double)blockPos2.func_177952_p() + random.nextDouble() * 0.6 + 0.2;
                    this.field_72769_h.func_195594_a(ParticleTypes.field_197601_L, d, \u2603, \u2603, 0.0, 0.0, 0.0);
                }
                break;
            }
            case 1503: {
                BlockPos blockPos2;
                this.field_72769_h.func_184156_a(blockPos2, SoundEvents.field_193781_bp, SoundCategory.BLOCKS, 1.0f, 1.0f, false);
                for (int i = 0; i < 16; ++i) {
                    double d = (float)blockPos2.func_177958_n() + (5.0f + random.nextFloat() * 6.0f) / 16.0f;
                    \u2603 = (float)blockPos2.func_177956_o() + 0.8125f;
                    \u2603 = (float)blockPos2.func_177952_p() + (5.0f + random.nextFloat() * 6.0f) / 16.0f;
                    \u2603 = 0.0;
                    \u2603 = 0.0;
                    \u2603 = 0.0;
                    this.field_72769_h.func_195594_a(ParticleTypes.field_197601_L, d, \u2603, \u2603, 0.0, 0.0, 0.0);
                }
                break;
            }
            case 2006: {
                for (int i = 0; i < 200; ++i) {
                    float f = random.nextFloat() * 4.0f;
                    \u2603 = random.nextFloat() * ((float)Math.PI * 2);
                    double \u260320 = MathHelper.func_76134_b(\u2603) * f;
                    double \u260321 = 0.01 + random.nextDouble() * 0.5;
                    double \u260322 = MathHelper.func_76126_a(\u2603) * f;
                    Particle \u260323 = this.func_195471_b(ParticleTypes.field_197616_i, false, (double)blockPos2.func_177958_n() + \u260320 * 0.1, (double)blockPos2.func_177956_o() + 0.3, (double)blockPos2.func_177952_p() + \u260322 * 0.1, \u260320, \u260321, \u260322);
                    if (\u260323 == null) continue;
                    \u260323.func_70543_e(f);
                }
                this.field_72769_h.func_184156_a(blockPos2, SoundEvents.field_187523_aM, SoundCategory.HOSTILE, 1.0f, this.field_72769_h.field_73012_v.nextFloat() * 0.1f + 0.9f, false);
                break;
            }
            case 1012: {
                this.field_72769_h.func_184156_a(blockPos2, SoundEvents.field_187873_gM, SoundCategory.BLOCKS, 1.0f, this.field_72769_h.field_73012_v.nextFloat() * 0.1f + 0.9f, false);
                break;
            }
            case 1036: {
                this.field_72769_h.func_184156_a(blockPos2, SoundEvents.field_187614_cJ, SoundCategory.BLOCKS, 1.0f, this.field_72769_h.field_73012_v.nextFloat() * 0.1f + 0.9f, false);
                break;
            }
            case 1013: {
                this.field_72769_h.func_184156_a(blockPos2, SoundEvents.field_187877_gO, SoundCategory.BLOCKS, 1.0f, this.field_72769_h.field_73012_v.nextFloat() * 0.1f + 0.9f, false);
                break;
            }
            case 1014: {
                this.field_72769_h.func_184156_a(blockPos2, SoundEvents.field_187610_bh, SoundCategory.BLOCKS, 1.0f, this.field_72769_h.field_73012_v.nextFloat() * 0.1f + 0.9f, false);
                break;
            }
            case 1011: {
                this.field_72769_h.func_184156_a(blockPos2, SoundEvents.field_187608_cH, SoundCategory.BLOCKS, 1.0f, this.field_72769_h.field_73012_v.nextFloat() * 0.1f + 0.9f, false);
                break;
            }
            case 1006: {
                this.field_72769_h.func_184156_a(blockPos2, SoundEvents.field_187875_gN, SoundCategory.BLOCKS, 1.0f, this.field_72769_h.field_73012_v.nextFloat() * 0.1f + 0.9f, false);
                break;
            }
            case 1007: {
                this.field_72769_h.func_184156_a(blockPos2, SoundEvents.field_187879_gP, SoundCategory.BLOCKS, 1.0f, this.field_72769_h.field_73012_v.nextFloat() * 0.1f + 0.9f, false);
                break;
            }
            case 1037: {
                this.field_72769_h.func_184156_a(blockPos2, SoundEvents.field_187617_cK, SoundCategory.BLOCKS, 1.0f, this.field_72769_h.field_73012_v.nextFloat() * 0.1f + 0.9f, false);
                break;
            }
            case 1008: {
                this.field_72769_h.func_184156_a(blockPos2, SoundEvents.field_187613_bi, SoundCategory.BLOCKS, 1.0f, this.field_72769_h.field_73012_v.nextFloat() * 0.1f + 0.9f, false);
                break;
            }
            case 1005: {
                this.field_72769_h.func_184156_a(blockPos2, SoundEvents.field_187611_cI, SoundCategory.BLOCKS, 1.0f, this.field_72769_h.field_73012_v.nextFloat() * 0.1f + 0.9f, false);
                break;
            }
            case 1009: {
                this.field_72769_h.func_184156_a(blockPos2, SoundEvents.field_187646_bt, SoundCategory.BLOCKS, 0.5f, 2.6f + (random.nextFloat() - random.nextFloat()) * 0.8f, false);
                break;
            }
            case 1029: {
                this.field_72769_h.func_184156_a(blockPos2, SoundEvents.field_187680_c, SoundCategory.BLOCKS, 1.0f, this.field_72769_h.field_73012_v.nextFloat() * 0.1f + 0.9f, false);
                break;
            }
            case 1030: {
                this.field_72769_h.func_184156_a(blockPos2, SoundEvents.field_187698_i, SoundCategory.BLOCKS, 1.0f, this.field_72769_h.field_73012_v.nextFloat() * 0.1f + 0.9f, false);
                break;
            }
            case 1031: {
                this.field_72769_h.func_184156_a(blockPos2, SoundEvents.field_187689_f, SoundCategory.BLOCKS, 0.3f, this.field_72769_h.field_73012_v.nextFloat() * 0.1f + 0.9f, false);
                break;
            }
            case 1039: {
                this.field_72769_h.func_184156_a(blockPos2, SoundEvents.field_203257_fu, SoundCategory.HOSTILE, 0.3f, this.field_72769_h.field_73012_v.nextFloat() * 0.1f + 0.9f, false);
                break;
            }
            case 1010: {
                if (Item.func_150899_d(n22) instanceof MusicDiscItem) {
                    this.func_184377_a(((MusicDiscItem)Item.func_150899_d(n22)).func_185075_h(), blockPos2);
                    break;
                }
                this.func_184377_a(null, blockPos2);
                break;
            }
            case 1015: {
                this.field_72769_h.func_184156_a(blockPos2, SoundEvents.field_187559_bL, SoundCategory.HOSTILE, 10.0f, (random.nextFloat() - random.nextFloat()) * 0.2f + 1.0f, false);
                break;
            }
            case 1017: {
                this.field_72769_h.func_184156_a(blockPos2, SoundEvents.field_187527_aQ, SoundCategory.HOSTILE, 10.0f, (random.nextFloat() - random.nextFloat()) * 0.2f + 1.0f, false);
                break;
            }
            case 1016: {
                this.field_72769_h.func_184156_a(blockPos2, SoundEvents.field_187557_bK, SoundCategory.HOSTILE, 10.0f, (random.nextFloat() - random.nextFloat()) * 0.2f + 1.0f, false);
                break;
            }
            case 1019: {
                this.field_72769_h.func_184156_a(blockPos2, SoundEvents.field_187927_ha, SoundCategory.HOSTILE, 2.0f, (random.nextFloat() - random.nextFloat()) * 0.2f + 1.0f, false);
                break;
            }
            case 1022: {
                this.field_72769_h.func_184156_a(blockPos2, SoundEvents.field_187926_gz, SoundCategory.HOSTILE, 2.0f, (random.nextFloat() - random.nextFloat()) * 0.2f + 1.0f, false);
                break;
            }
            case 1021: {
                this.field_72769_h.func_184156_a(blockPos2, SoundEvents.field_187929_hc, SoundCategory.HOSTILE, 2.0f, (random.nextFloat() - random.nextFloat()) * 0.2f + 1.0f, false);
                break;
            }
            case 1020: {
                this.field_72769_h.func_184156_a(blockPos2, SoundEvents.field_187928_hb, SoundCategory.HOSTILE, 2.0f, (random.nextFloat() - random.nextFloat()) * 0.2f + 1.0f, false);
                break;
            }
            case 1018: {
                this.field_72769_h.func_184156_a(blockPos2, SoundEvents.field_187606_E, SoundCategory.HOSTILE, 2.0f, (random.nextFloat() - random.nextFloat()) * 0.2f + 1.0f, false);
                break;
            }
            case 1024: {
                this.field_72769_h.func_184156_a(blockPos2, SoundEvents.field_187853_gC, SoundCategory.HOSTILE, 2.0f, (random.nextFloat() - random.nextFloat()) * 0.2f + 1.0f, false);
                break;
            }
            case 1026: {
                this.field_72769_h.func_184156_a(blockPos2, SoundEvents.field_187945_hs, SoundCategory.HOSTILE, 2.0f, (random.nextFloat() - random.nextFloat()) * 0.2f + 1.0f, false);
                break;
            }
            case 1027: {
                this.field_72769_h.func_184156_a(blockPos2, SoundEvents.field_187941_ho, SoundCategory.NEUTRAL, 2.0f, (random.nextFloat() - random.nextFloat()) * 0.2f + 1.0f, false);
                break;
            }
            case 1040: {
                this.field_72769_h.func_184156_a(blockPos2, SoundEvents.field_204783_kG, SoundCategory.NEUTRAL, 2.0f, (random.nextFloat() - random.nextFloat()) * 0.2f + 1.0f, false);
                break;
            }
            case 1041: {
                this.field_72769_h.func_184156_a(blockPos2, SoundEvents.field_207378_dT, SoundCategory.NEUTRAL, 2.0f, (random.nextFloat() - random.nextFloat()) * 0.2f + 1.0f, false);
                break;
            }
            case 1025: {
                this.field_72769_h.func_184156_a(blockPos2, SoundEvents.field_187744_z, SoundCategory.NEUTRAL, 0.05f, (random.nextFloat() - random.nextFloat()) * 0.2f + 1.0f, false);
                break;
            }
            case 1042: {
                this.field_72769_h.func_184156_a(blockPos2, SoundEvents.field_219642_eu, SoundCategory.BLOCKS, 1.0f, this.field_72769_h.field_73012_v.nextFloat() * 0.1f + 0.9f, false);
                break;
            }
            case 1043: {
                this.field_72769_h.func_184156_a(blockPos2, SoundEvents.field_219617_ah, SoundCategory.BLOCKS, 1.0f, this.field_72769_h.field_73012_v.nextFloat() * 0.1f + 0.9f, false);
                break;
            }
            case 3000: {
                this.field_72769_h.func_195590_a(ParticleTypes.field_197626_s, true, (double)blockPos2.func_177958_n() + 0.5, (double)blockPos2.func_177956_o() + 0.5, (double)blockPos2.func_177952_p() + 0.5, 0.0, 0.0, 0.0);
                this.field_72769_h.func_184156_a(blockPos2, SoundEvents.field_187598_bd, SoundCategory.BLOCKS, 10.0f, (1.0f + (this.field_72769_h.field_73012_v.nextFloat() - this.field_72769_h.field_73012_v.nextFloat()) * 0.2f) * 0.7f, false);
                break;
            }
            case 3001: {
                this.field_72769_h.func_184156_a(blockPos2, SoundEvents.field_187525_aO, SoundCategory.HOSTILE, 64.0f, 0.8f + this.field_72769_h.field_73012_v.nextFloat() * 0.3f, false);
            }
        }
    }

    public void func_180441_b(int n, BlockPos blockPos, int n2) {
        if (n2 < 0 || n2 >= 10) {
            this.field_72738_E.remove(n);
        } else {
            DestroyBlockProgress destroyBlockProgress = this.field_72738_E.get(n);
            if (destroyBlockProgress == null || destroyBlockProgress.func_180246_b().func_177958_n() != blockPos.func_177958_n() || destroyBlockProgress.func_180246_b().func_177956_o() != blockPos.func_177956_o() || destroyBlockProgress.func_180246_b().func_177952_p() != blockPos.func_177952_p()) {
                destroyBlockProgress = new DestroyBlockProgress(n, blockPos);
                this.field_72738_E.put(n, destroyBlockProgress);
            }
            destroyBlockProgress.func_73107_a(n2);
            destroyBlockProgress.func_82744_b(this.field_72773_u);
        }
    }

    public boolean func_184384_n() {
        return this.field_175009_l.isEmpty() && this.field_174995_M.func_188247_f();
    }

    public void func_174979_m() {
        this.field_147595_R = true;
        this.field_204607_y = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void func_181023_a(Collection<TileEntity> collection, Collection<TileEntity> collection2) {
        Set<TileEntity> set = this.field_181024_n;
        synchronized (set) {
            this.field_181024_n.removeAll(collection);
            this.field_181024_n.addAll(collection2);
        }
    }

    class LocalRenderInformationContainer {
        private final ChunkRender field_178036_a;
        private final Direction field_178034_b;
        private byte field_178035_c;
        private final int field_178032_d;

        private LocalRenderInformationContainer(ChunkRender chunkRender, @Nullable Direction direction, int n) {
            this.field_178036_a = chunkRender;
            this.field_178034_b = direction;
            this.field_178032_d = n;
        }

        public void func_189561_a(byte by, Direction direction) {
            this.field_178035_c = (byte)(this.field_178035_c | (by | 1 << direction.ordinal()));
        }

        public boolean func_189560_a(Direction direction) {
            return (this.field_178035_c & 1 << direction.ordinal()) > 0;
        }
    }
}

