/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer;

import com.google.gson.JsonSyntaxException;
import com.mojang.blaze3d.platform.GLX;
import com.mojang.blaze3d.platform.GlStateManager;
import java.io.IOException;
import java.util.Locale;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.CampfireBlock;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.AbstractClientPlayerEntity;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.MapItemRenderer;
import net.minecraft.client.particle.ParticleManager;
import net.minecraft.client.renderer.ActiveRenderInfo;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.FirstPersonRenderer;
import net.minecraft.client.renderer.FogRenderer;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.Matrix4f;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.WorldRenderer;
import net.minecraft.client.renderer.culling.ClippingHelper;
import net.minecraft.client.renderer.culling.ClippingHelperImpl;
import net.minecraft.client.renderer.culling.Frustum;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.client.renderer.texture.AtlasTexture;
import net.minecraft.client.renderer.texture.NativeImage;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.settings.CloudOption;
import net.minecraft.client.settings.ParticleStatus;
import net.minecraft.client.shader.ShaderGroup;
import net.minecraft.client.shader.ShaderLinkHelper;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.crash.CrashReport;
import net.minecraft.crash.CrashReportCategory;
import net.minecraft.crash.ReportedException;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.item.ItemFrameEntity;
import net.minecraft.entity.monster.CreeperEntity;
import net.minecraft.entity.monster.EndermanEntity;
import net.minecraft.entity.monster.SpiderEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.projectile.ProjectileHelper;
import net.minecraft.fluid.IFluidState;
import net.minecraft.item.ItemStack;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.potion.Effects;
import net.minecraft.resources.IResourceManager;
import net.minecraft.resources.IResourceManagerReloadListener;
import net.minecraft.resources.SimpleResource;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.CachedBlockInfo;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.ScreenShotHelper;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.Util;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.GameType;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.Heightmap;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class GameRenderer
implements AutoCloseable,
IResourceManagerReloadListener {
    private static final Logger field_147710_q = LogManager.getLogger();
    private static final ResourceLocation field_110924_q = new ResourceLocation("textures/environment/rain.png");
    private static final ResourceLocation field_110923_r = new ResourceLocation("textures/environment/snow.png");
    private final Minecraft field_78531_r;
    private final IResourceManager field_147711_ac;
    private final Random field_78537_ab = new Random();
    private float field_78530_s;
    public final FirstPersonRenderer field_78516_c;
    private final MapItemRenderer field_147709_v;
    private int field_78529_t;
    private float field_78507_R;
    private float field_78506_S;
    private float field_82831_U;
    private float field_82832_V;
    private boolean field_175074_C = true;
    private boolean field_175073_D = true;
    private long field_184374_E;
    private long field_78508_Y = Util.func_211177_b();
    private final LightTexture field_78513_d;
    private int field_78534_ac;
    private final float[] field_175076_N = new float[1024];
    private final float[] field_175077_O = new float[1024];
    private final FogRenderer field_205003_A;
    private boolean field_175078_W;
    private double field_78503_V = 1.0;
    private double field_78502_W;
    private double field_78509_X;
    private ItemStack field_190566_ab;
    private int field_190567_ac;
    private float field_190568_ad;
    private float field_190569_ae;
    private ShaderGroup field_147707_d;
    private static final ResourceLocation[] field_147712_ad = new ResourceLocation[]{new ResourceLocation("shaders/post/notch.json"), new ResourceLocation("shaders/post/fxaa.json"), new ResourceLocation("shaders/post/art.json"), new ResourceLocation("shaders/post/bumpy.json"), new ResourceLocation("shaders/post/blobs2.json"), new ResourceLocation("shaders/post/pencil.json"), new ResourceLocation("shaders/post/color_convolve.json"), new ResourceLocation("shaders/post/deconverge.json"), new ResourceLocation("shaders/post/flip.json"), new ResourceLocation("shaders/post/invert.json"), new ResourceLocation("shaders/post/ntsc.json"), new ResourceLocation("shaders/post/outline.json"), new ResourceLocation("shaders/post/phosphor.json"), new ResourceLocation("shaders/post/scan_pincushion.json"), new ResourceLocation("shaders/post/sobel.json"), new ResourceLocation("shaders/post/bits.json"), new ResourceLocation("shaders/post/desaturate.json"), new ResourceLocation("shaders/post/green.json"), new ResourceLocation("shaders/post/blur.json"), new ResourceLocation("shaders/post/wobble.json"), new ResourceLocation("shaders/post/blobs.json"), new ResourceLocation("shaders/post/antialias.json"), new ResourceLocation("shaders/post/creeper.json"), new ResourceLocation("shaders/post/spider.json")};
    public static final int field_147708_e = field_147712_ad.length;
    private int field_147713_ae = field_147708_e;
    private boolean field_175083_ad;
    private int field_175084_ae;
    private final ActiveRenderInfo field_215317_L = new ActiveRenderInfo();

    public GameRenderer(Minecraft minecraft, IResourceManager iResourceManager) {
        this.field_78531_r = minecraft;
        this.field_147711_ac = iResourceManager;
        this.field_78516_c = minecraft.func_175597_ag();
        this.field_147709_v = new MapItemRenderer(minecraft.func_110434_K());
        this.field_78513_d = new LightTexture(this);
        this.field_205003_A = new FogRenderer(this);
        this.field_147707_d = null;
        for (int i = 0; i < 32; ++i) {
            for (\u2603 = 0; \u2603 < 32; ++\u2603) {
                float f = \u2603 - 16;
                \u2603 = i - 16;
                \u2603 = MathHelper.func_76129_c(f * f + \u2603 * \u2603);
                this.field_175076_N[i << 5 | \u2603] = -\u2603 / \u2603;
                this.field_175077_O[i << 5 | \u2603] = f / \u2603;
            }
        }
    }

    @Override
    public void close() {
        this.field_78513_d.close();
        this.field_147709_v.close();
        this.func_181022_b();
    }

    public boolean func_147702_a() {
        return GLX.usePostProcess && this.field_147707_d != null;
    }

    public void func_181022_b() {
        if (this.field_147707_d != null) {
            this.field_147707_d.close();
        }
        this.field_147707_d = null;
        this.field_147713_ae = field_147708_e;
    }

    public void func_175071_c() {
        this.field_175083_ad = !this.field_175083_ad;
    }

    public void func_175066_a(@Nullable Entity entity) {
        if (!GLX.usePostProcess) {
            return;
        }
        if (this.field_147707_d != null) {
            this.field_147707_d.close();
        }
        this.field_147707_d = null;
        if (entity instanceof CreeperEntity) {
            this.func_175069_a(new ResourceLocation("shaders/post/creeper.json"));
        } else if (entity instanceof SpiderEntity) {
            this.func_175069_a(new ResourceLocation("shaders/post/spider.json"));
        } else if (entity instanceof EndermanEntity) {
            this.func_175069_a(new ResourceLocation("shaders/post/invert.json"));
        }
    }

    private void func_175069_a(ResourceLocation resourceLocation) {
        if (this.field_147707_d != null) {
            this.field_147707_d.close();
        }
        try {
            this.field_147707_d = new ShaderGroup(this.field_78531_r.func_110434_K(), this.field_147711_ac, this.field_78531_r.func_147110_a(), resourceLocation);
            this.field_147707_d.func_148026_a(this.field_78531_r.field_195558_d.func_198109_k(), this.field_78531_r.field_195558_d.func_198091_l());
            this.field_175083_ad = true;
        }
        catch (IOException iOException) {
            field_147710_q.warn("Failed to load shader: {}", (Object)resourceLocation, (Object)iOException);
            this.field_147713_ae = field_147708_e;
            this.field_175083_ad = false;
        }
        catch (JsonSyntaxException jsonSyntaxException) {
            field_147710_q.warn("Failed to load shader: {}", (Object)resourceLocation, (Object)jsonSyntaxException);
            this.field_147713_ae = field_147708_e;
            this.field_175083_ad = false;
        }
    }

    @Override
    public void func_195410_a(IResourceManager iResourceManager) {
        if (this.field_147707_d != null) {
            this.field_147707_d.close();
        }
        this.field_147707_d = null;
        if (this.field_147713_ae == field_147708_e) {
            this.func_175066_a(this.field_78531_r.func_175606_aa());
        } else {
            this.func_175069_a(field_147712_ad[this.field_147713_ae]);
        }
    }

    public void func_78464_a() {
        if (GLX.usePostProcess && ShaderLinkHelper.func_148074_b() == null) {
            ShaderLinkHelper.func_148076_a();
        }
        this.func_78477_e();
        this.field_78513_d.func_205107_a();
        if (this.field_78531_r.func_175606_aa() == null) {
            this.field_78531_r.func_175607_a(this.field_78531_r.field_71439_g);
        }
        this.field_215317_L.func_216783_a();
        ++this.field_78529_t;
        this.field_78516_c.func_78441_a();
        this.func_78484_h();
        this.field_82832_V = this.field_82831_U;
        if (this.field_78531_r.field_71456_v.func_184046_j().func_184053_e()) {
            this.field_82831_U += 0.05f;
            if (this.field_82831_U > 1.0f) {
                this.field_82831_U = 1.0f;
            }
        } else if (this.field_82831_U > 0.0f) {
            this.field_82831_U -= 0.0125f;
        }
        if (this.field_190567_ac > 0) {
            --this.field_190567_ac;
            if (this.field_190567_ac == 0) {
                this.field_190566_ab = null;
            }
        }
    }

    public ShaderGroup func_147706_e() {
        return this.field_147707_d;
    }

    public void func_147704_a(int n, int n2) {
        if (!GLX.usePostProcess) {
            return;
        }
        if (this.field_147707_d != null) {
            this.field_147707_d.func_148026_a(n, n2);
        }
        this.field_78531_r.field_71438_f.func_72720_a(n, n2);
    }

    public void func_78473_a(float f) {
        Entity entity2 = this.field_78531_r.func_175606_aa();
        if (entity2 == null) {
            return;
        }
        if (this.field_78531_r.field_71441_e == null) {
            return;
        }
        this.field_78531_r.func_213239_aq().func_76320_a("pick");
        this.field_78531_r.field_147125_j = null;
        double \u26032 = this.field_78531_r.field_71442_b.func_78757_d();
        this.field_78531_r.field_71476_x = entity2.func_213324_a(\u26032, f, false);
        Vec3d \u26033 = entity2.func_174824_e(f);
        boolean \u26034 = false;
        int \u26035 = 3;
        double \u26036 = \u26032;
        if (this.field_78531_r.field_71442_b.func_78749_i()) {
            \u26032 = \u26036 = 6.0;
        } else {
            if (\u26036 > 3.0) {
                \u26034 = true;
            }
            \u26032 = \u26036;
        }
        \u26036 *= \u26036;
        if (this.field_78531_r.field_71476_x != null) {
            \u26036 = this.field_78531_r.field_71476_x.func_216347_e().func_72436_e(\u26033);
        }
        Vec3d \u26037 = entity2.func_70676_i(1.0f);
        Vec3d \u26038 = \u26033.func_72441_c(\u26037.field_72450_a * \u26032, \u26037.field_72448_b * \u26032, \u26037.field_72449_c * \u26032);
        float \u26039 = 1.0f;
        AxisAlignedBB \u260310 = entity2.func_174813_aQ().func_216361_a(\u26037.func_186678_a(\u26032)).func_72314_b(1.0, 1.0, 1.0);
        EntityRayTraceResult \u260311 = ProjectileHelper.func_221273_a(entity2, \u26033, \u26038, \u260310, entity -> !entity.func_175149_v() && entity.func_70067_L(), \u26036);
        if (\u260311 != null) {
            \u2603 = \u260311.func_216348_a();
            Vec3d vec3d = \u260311.func_216347_e();
            double \u260312 = \u26033.func_72436_e(vec3d);
            if (\u26034 && \u260312 > 9.0) {
                this.field_78531_r.field_71476_x = BlockRayTraceResult.func_216352_a(vec3d, Direction.func_210769_a(\u26037.field_72450_a, \u26037.field_72448_b, \u26037.field_72449_c), new BlockPos(vec3d));
            } else if (\u260312 < \u26036 || this.field_78531_r.field_71476_x == null) {
                this.field_78531_r.field_71476_x = \u260311;
                if (\u2603 instanceof LivingEntity || \u2603 instanceof ItemFrameEntity) {
                    this.field_78531_r.field_147125_j = \u2603;
                }
            }
        }
        this.field_78531_r.func_213239_aq().func_76319_b();
    }

    private void func_78477_e() {
        float \u26032 = 1.0f;
        if (this.field_78531_r.func_175606_aa() instanceof AbstractClientPlayerEntity) {
            AbstractClientPlayerEntity abstractClientPlayerEntity = (AbstractClientPlayerEntity)this.field_78531_r.func_175606_aa();
            \u26032 = abstractClientPlayerEntity.func_175156_o();
        }
        this.field_78506_S = this.field_78507_R;
        this.field_78507_R += (\u26032 - this.field_78507_R) * 0.5f;
        if (this.field_78507_R > 1.5f) {
            this.field_78507_R = 1.5f;
        }
        if (this.field_78507_R < 0.1f) {
            this.field_78507_R = 0.1f;
        }
    }

    private double func_215311_a(ActiveRenderInfo activeRenderInfo, float f, boolean bl) {
        IFluidState iFluidState;
        if (this.field_175078_W) {
            return 90.0;
        }
        double d = 70.0;
        if (bl) {
            d = this.field_78531_r.field_71474_y.field_74334_X;
            d *= (double)MathHelper.func_219799_g(f, this.field_78506_S, this.field_78507_R);
        }
        if (activeRenderInfo.func_216773_g() instanceof LivingEntity && ((LivingEntity)activeRenderInfo.func_216773_g()).func_110143_aJ() <= 0.0f) {
            float f2 = (float)((LivingEntity)activeRenderInfo.func_216773_g()).field_70725_aQ + f;
            d /= (double)((1.0f - 500.0f / (f2 + 500.0f)) * 2.0f + 1.0f);
        }
        if (!(iFluidState = activeRenderInfo.func_216771_k()).func_206888_e()) {
            d = d * 60.0 / 70.0;
        }
        return d;
    }

    private void func_78482_e(float f) {
        if (this.field_78531_r.func_175606_aa() instanceof LivingEntity) {
            float \u26033;
            LivingEntity livingEntity = (LivingEntity)this.field_78531_r.func_175606_aa();
            float \u26032 = (float)livingEntity.field_70737_aN - f;
            if (livingEntity.func_110143_aJ() <= 0.0f) {
                \u26033 = (float)livingEntity.field_70725_aQ + f;
                GlStateManager.rotatef(40.0f - 8000.0f / (\u26033 + 200.0f), 0.0f, 0.0f, 1.0f);
            }
            if (\u26032 < 0.0f) {
                return;
            }
            \u26032 /= (float)livingEntity.field_70738_aO;
            \u26032 = MathHelper.func_76126_a(\u26032 * \u26032 * \u26032 * \u26032 * (float)Math.PI);
            \u26033 = livingEntity.field_70739_aP;
            GlStateManager.rotatef(-\u26033, 0.0f, 1.0f, 0.0f);
            GlStateManager.rotatef(-\u26032 * 14.0f, 0.0f, 0.0f, 1.0f);
            GlStateManager.rotatef(\u26033, 0.0f, 1.0f, 0.0f);
        }
    }

    private void func_78475_f(float f) {
        if (!(this.field_78531_r.func_175606_aa() instanceof PlayerEntity)) {
            return;
        }
        PlayerEntity playerEntity = (PlayerEntity)this.field_78531_r.func_175606_aa();
        float \u26032 = playerEntity.field_70140_Q - playerEntity.field_70141_P;
        float \u26033 = -(playerEntity.field_70140_Q + \u26032 * f);
        float \u26034 = MathHelper.func_219799_g(f, playerEntity.field_71107_bF, playerEntity.field_71109_bG);
        GlStateManager.translatef(MathHelper.func_76126_a(\u26033 * (float)Math.PI) * \u26034 * 0.5f, -Math.abs(MathHelper.func_76134_b(\u26033 * (float)Math.PI) * \u26034), 0.0f);
        GlStateManager.rotatef(MathHelper.func_76126_a(\u26033 * (float)Math.PI) * \u26034 * 3.0f, 0.0f, 0.0f, 1.0f);
        GlStateManager.rotatef(Math.abs(MathHelper.func_76134_b(\u26033 * (float)Math.PI - 0.2f) * \u26034) * 5.0f, 1.0f, 0.0f, 0.0f);
    }

    private void func_195460_g(float f) {
        this.field_78530_s = this.field_78531_r.field_71474_y.field_151451_c * 16;
        GlStateManager.matrixMode(5889);
        GlStateManager.loadIdentity();
        if (this.field_78503_V != 1.0) {
            GlStateManager.translatef((float)this.field_78502_W, (float)(-this.field_78509_X), 0.0f);
            GlStateManager.scaled(this.field_78503_V, this.field_78503_V, 1.0);
        }
        GlStateManager.multMatrix(Matrix4f.func_195876_a(this.func_215311_a(this.field_215317_L, f, true), (float)this.field_78531_r.field_195558_d.func_198109_k() / (float)this.field_78531_r.field_195558_d.func_198091_l(), 0.05f, this.field_78530_s * MathHelper.field_180189_a));
        GlStateManager.matrixMode(5888);
        GlStateManager.loadIdentity();
        this.func_78482_e(f);
        if (this.field_78531_r.field_71474_y.field_74336_f) {
            this.func_78475_f(f);
        }
        if ((\u2603 = MathHelper.func_219799_g(f, this.field_78531_r.field_71439_g.field_71080_cy, this.field_78531_r.field_71439_g.field_71086_bY)) > 0.0f) {
            int n = 20;
            if (this.field_78531_r.field_71439_g.func_70644_a(Effects.field_76431_k)) {
                n = 7;
            }
            float \u26032 = 5.0f / (\u2603 * \u2603 + 5.0f) - \u2603 * 0.04f;
            \u26032 *= \u26032;
            GlStateManager.rotatef(((float)this.field_78529_t + f) * (float)n, 0.0f, 1.0f, 1.0f);
            GlStateManager.scalef(1.0f / \u26032, 1.0f, 1.0f);
            GlStateManager.rotatef(-((float)this.field_78529_t + f) * (float)n, 0.0f, 1.0f, 1.0f);
        }
    }

    private void func_215308_a(ActiveRenderInfo activeRenderInfo, float f) {
        if (this.field_175078_W) {
            return;
        }
        GlStateManager.matrixMode(5889);
        GlStateManager.loadIdentity();
        GlStateManager.multMatrix(Matrix4f.func_195876_a(this.func_215311_a(activeRenderInfo, f, false), (float)this.field_78531_r.field_195558_d.func_198109_k() / (float)this.field_78531_r.field_195558_d.func_198091_l(), 0.05f, this.field_78530_s * 2.0f));
        GlStateManager.matrixMode(5888);
        GlStateManager.loadIdentity();
        GlStateManager.pushMatrix();
        this.func_78482_e(f);
        if (this.field_78531_r.field_71474_y.field_74336_f) {
            this.func_78475_f(f);
        }
        boolean bl = \u2603 = this.field_78531_r.func_175606_aa() instanceof LivingEntity && ((LivingEntity)this.field_78531_r.func_175606_aa()).func_70608_bn();
        if (this.field_78531_r.field_71474_y.field_74320_O == 0 && !\u2603 && !this.field_78531_r.field_71474_y.field_74319_N && this.field_78531_r.field_71442_b.func_178889_l() != GameType.SPECTATOR) {
            this.func_180436_i();
            this.field_78516_c.func_78440_a(f);
            this.func_175072_h();
        }
        GlStateManager.popMatrix();
        if (this.field_78531_r.field_71474_y.field_74320_O == 0 && !\u2603) {
            this.field_78516_c.func_78447_b(f);
            this.func_78482_e(f);
        }
        if (this.field_78531_r.field_71474_y.field_74336_f) {
            this.func_78475_f(f);
        }
    }

    public void func_175072_h() {
        this.field_78513_d.func_205108_b();
    }

    public void func_180436_i() {
        this.field_78513_d.func_205109_c();
    }

    public float func_180438_a(LivingEntity livingEntity, float f) {
        int n = livingEntity.func_70660_b(Effects.field_76439_r).func_76459_b();
        if (n > 200) {
            return 1.0f;
        }
        return 0.7f + MathHelper.func_76126_a(((float)n - f) * (float)Math.PI * 0.2f) * 0.3f;
    }

    public void func_195458_a(float f, long l, boolean bl) {
        if (this.field_78531_r.func_195544_aj() || !this.field_78531_r.field_71474_y.field_82881_y || this.field_78531_r.field_71474_y.field_85185_A && this.field_78531_r.field_71417_B.func_198031_d()) {
            this.field_78508_Y = Util.func_211177_b();
        } else if (Util.func_211177_b() - this.field_78508_Y > 500L) {
            this.field_78531_r.func_71385_j(false);
        }
        if (this.field_78531_r.field_71454_w) {
            return;
        }
        int n = (int)(this.field_78531_r.field_71417_B.func_198024_e() * (double)this.field_78531_r.field_195558_d.func_198107_o() / (double)this.field_78531_r.field_195558_d.func_198105_m());
        \u2603 = (int)(this.field_78531_r.field_71417_B.func_198026_f() * (double)this.field_78531_r.field_195558_d.func_198087_p() / (double)this.field_78531_r.field_195558_d.func_198083_n());
        \u2603 = this.field_78531_r.field_71474_y.field_74350_i;
        if (bl && this.field_78531_r.field_71441_e != null) {
            this.field_78531_r.func_213239_aq().func_76320_a("level");
            \u2603 = Math.min(Minecraft.func_175610_ah(), \u2603);
            \u2603 = Math.max(\u2603, 60);
            long l2 = Util.func_211178_c() - l;
            \u2603 = Math.max((long)(1000000000 / \u2603 / 4) - l2, 0L);
            this.func_78471_a(f, Util.func_211178_c() + \u2603);
            if (this.field_78531_r.func_71356_B() && this.field_184374_E < Util.func_211177_b() - 1000L) {
                this.field_184374_E = Util.func_211177_b();
                if (!this.field_78531_r.func_71401_C().func_184106_y()) {
                    this.func_184373_n();
                }
            }
            if (GLX.usePostProcess) {
                this.field_78531_r.field_71438_f.func_174975_c();
                if (this.field_147707_d != null && this.field_175083_ad) {
                    GlStateManager.matrixMode(5890);
                    GlStateManager.pushMatrix();
                    GlStateManager.loadIdentity();
                    this.field_147707_d.func_148018_a(f);
                    GlStateManager.popMatrix();
                }
                this.field_78531_r.func_147110_a().func_147610_a(true);
            }
            this.field_78531_r.func_213239_aq().func_219895_b("gui");
            if (!this.field_78531_r.field_71474_y.field_74319_N || this.field_78531_r.field_71462_r != null) {
                GlStateManager.alphaFunc(516, 0.1f);
                this.field_78531_r.field_195558_d.func_216522_a(Minecraft.field_142025_a);
                this.func_190563_a(this.field_78531_r.field_195558_d.func_198107_o(), this.field_78531_r.field_195558_d.func_198087_p(), f);
                this.field_78531_r.field_71456_v.func_175180_a(f);
            }
            this.field_78531_r.func_213239_aq().func_76319_b();
        } else {
            GlStateManager.viewport(0, 0, this.field_78531_r.field_195558_d.func_198109_k(), this.field_78531_r.field_195558_d.func_198091_l());
            GlStateManager.matrixMode(5889);
            GlStateManager.loadIdentity();
            GlStateManager.matrixMode(5888);
            GlStateManager.loadIdentity();
            this.field_78531_r.field_195558_d.func_216522_a(Minecraft.field_142025_a);
        }
        if (this.field_78531_r.field_213279_p != null) {
            GlStateManager.clear(256, Minecraft.field_142025_a);
            try {
                this.field_78531_r.field_213279_p.render(n, \u2603, this.field_78531_r.func_193989_ak());
            }
            catch (Throwable throwable) {
                CrashReport crashReport = CrashReport.func_85055_a(throwable, "Rendering overlay");
                CrashReportCategory \u26032 = crashReport.func_85058_a("Overlay render details");
                \u26032.func_189529_a("Overlay name", () -> this.field_78531_r.field_213279_p.getClass().getCanonicalName());
                throw new ReportedException(crashReport);
            }
        }
        if (this.field_78531_r.field_71462_r != null) {
            GlStateManager.clear(256, Minecraft.field_142025_a);
            try {
                this.field_78531_r.field_71462_r.render(n, \u2603, this.field_78531_r.func_193989_ak());
            }
            catch (Throwable throwable) {
                CrashReport crashReport = CrashReport.func_85055_a(throwable, "Rendering screen");
                CrashReportCategory \u26033 = crashReport.func_85058_a("Screen render details");
                \u26033.func_189529_a("Screen name", () -> this.field_78531_r.field_71462_r.getClass().getCanonicalName());
                \u26033.func_189529_a("Mouse location", () -> String.format(Locale.ROOT, "Scaled: (%d, %d). Absolute: (%f, %f)", n, \u2603, this.field_78531_r.field_71417_B.func_198024_e(), this.field_78531_r.field_71417_B.func_198026_f()));
                \u26033.func_189529_a("Screen size", () -> String.format(Locale.ROOT, "Scaled: (%d, %d). Absolute: (%d, %d). Scale factor of %f", this.field_78531_r.field_195558_d.func_198107_o(), this.field_78531_r.field_195558_d.func_198087_p(), this.field_78531_r.field_195558_d.func_198109_k(), this.field_78531_r.field_195558_d.func_198091_l(), this.field_78531_r.field_195558_d.func_198100_s()));
                throw new ReportedException(crashReport);
            }
        }
    }

    private void func_184373_n() {
        if (this.field_78531_r.field_71438_f.func_184382_g() > 10 && this.field_78531_r.field_71438_f.func_184384_n() && !this.field_78531_r.func_71401_C().func_184106_y()) {
            NativeImage nativeImage = ScreenShotHelper.func_198052_a(this.field_78531_r.field_195558_d.func_198109_k(), this.field_78531_r.field_195558_d.func_198091_l(), this.field_78531_r.func_147110_a());
            SimpleResource.field_199031_a.execute(() -> {
                int n = nativeImage.func_195702_a();
                \u2603 = nativeImage.func_195714_b();
                \u2603 = 0;
                \u2603 = 0;
                if (n > \u2603) {
                    \u2603 = (n - \u2603) / 2;
                    n = \u2603;
                } else {
                    \u2603 = (\u2603 - n) / 2;
                    \u2603 = n;
                }
                try (NativeImage nativeImage2 = new NativeImage(64, 64, false);){
                    nativeImage.func_195708_a(\u2603, \u2603, n, \u2603, nativeImage2);
                    nativeImage2.func_209271_a(this.field_78531_r.func_71401_C().func_184109_z());
                }
                catch (IOException iOException) {
                    field_147710_q.warn("Couldn't save auto screenshot", (Throwable)iOException);
                }
                finally {
                    nativeImage.close();
                }
            });
        }
    }

    private boolean func_175070_n() {
        boolean \u26035;
        if (!this.field_175073_D) {
            return false;
        }
        Entity entity = this.field_78531_r.func_175606_aa();
        boolean bl = \u26035 = entity instanceof PlayerEntity && !this.field_78531_r.field_71474_y.field_74319_N;
        if (\u26035 && !((PlayerEntity)entity).field_71075_bZ.field_75099_e) {
            ItemStack itemStack = ((LivingEntity)entity).func_184614_ca();
            RayTraceResult \u26032 = this.field_78531_r.field_71476_x;
            if (\u26032 != null && \u26032.func_216346_c() == RayTraceResult.Type.BLOCK) {
                BlockPos blockPos = ((BlockRayTraceResult)\u26032).func_216350_a();
                BlockState \u26033 = this.field_78531_r.field_71441_e.func_180495_p(blockPos);
                if (this.field_78531_r.field_71442_b.func_178889_l() == GameType.SPECTATOR) {
                    \u26035 = \u26033.func_215699_b(this.field_78531_r.field_71441_e, blockPos) != null;
                } else {
                    CachedBlockInfo \u26034 = new CachedBlockInfo(this.field_78531_r.field_71441_e, blockPos, false);
                    \u26035 = !itemStack.func_190926_b() && (itemStack.func_206848_a(this.field_78531_r.field_71441_e.func_205772_D(), \u26034) || itemStack.func_206847_b(this.field_78531_r.field_71441_e.func_205772_D(), \u26034));
                }
            }
        }
        return \u26035;
    }

    public void func_78471_a(float f, long l) {
        this.field_78513_d.func_205106_a(f);
        if (this.field_78531_r.func_175606_aa() == null) {
            this.field_78531_r.func_175607_a(this.field_78531_r.field_71439_g);
        }
        this.func_78473_a(f);
        GlStateManager.enableDepthTest();
        GlStateManager.enableAlphaTest();
        GlStateManager.alphaFunc(516, 0.5f);
        this.field_78531_r.func_213239_aq().func_76320_a("center");
        this.func_181560_a(f, l);
        this.field_78531_r.func_213239_aq().func_76319_b();
    }

    private void func_181560_a(float f, long l) {
        WorldRenderer worldRenderer = this.field_78531_r.field_71438_f;
        ParticleManager \u26032 = this.field_78531_r.field_71452_i;
        boolean \u26033 = this.func_175070_n();
        GlStateManager.enableCull();
        this.field_78531_r.func_213239_aq().func_219895_b("camera");
        this.func_195460_g(f);
        ActiveRenderInfo \u26034 = this.field_215317_L;
        \u26034.func_216772_a(this.field_78531_r.field_71441_e, this.field_78531_r.func_175606_aa() == null ? this.field_78531_r.field_71439_g : this.field_78531_r.func_175606_aa(), this.field_78531_r.field_71474_y.field_74320_O > 0, this.field_78531_r.field_71474_y.field_74320_O == 2, f);
        ClippingHelper \u26035 = ClippingHelperImpl.func_78558_a();
        worldRenderer.func_224745_a(\u26034);
        this.field_78531_r.func_213239_aq().func_219895_b("clear");
        GlStateManager.viewport(0, 0, this.field_78531_r.field_195558_d.func_198109_k(), this.field_78531_r.field_195558_d.func_198091_l());
        this.field_205003_A.func_217619_a(\u26034, f);
        GlStateManager.clear(16640, Minecraft.field_142025_a);
        this.field_78531_r.func_213239_aq().func_219895_b("culling");
        Frustum \u26036 = new Frustum(\u26035);
        double \u26037 = \u26034.func_216785_c().field_72450_a;
        double \u26038 = \u26034.func_216785_c().field_72448_b;
        double \u26039 = \u26034.func_216785_c().field_72449_c;
        \u26036.func_78547_a(\u26037, \u26038, \u26039);
        if (this.field_78531_r.field_71474_y.field_151451_c >= 4) {
            this.field_205003_A.func_217618_a(\u26034, -1);
            this.field_78531_r.func_213239_aq().func_219895_b("sky");
            GlStateManager.matrixMode(5889);
            GlStateManager.loadIdentity();
            GlStateManager.multMatrix(Matrix4f.func_195876_a(this.func_215311_a(\u26034, f, true), (float)this.field_78531_r.field_195558_d.func_198109_k() / (float)this.field_78531_r.field_195558_d.func_198091_l(), 0.05f, this.field_78530_s * 2.0f));
            GlStateManager.matrixMode(5888);
            worldRenderer.func_195465_a(f);
            GlStateManager.matrixMode(5889);
            GlStateManager.loadIdentity();
            GlStateManager.multMatrix(Matrix4f.func_195876_a(this.func_215311_a(\u26034, f, true), (float)this.field_78531_r.field_195558_d.func_198109_k() / (float)this.field_78531_r.field_195558_d.func_198091_l(), 0.05f, this.field_78530_s * MathHelper.field_180189_a));
            GlStateManager.matrixMode(5888);
        }
        this.field_205003_A.func_217618_a(\u26034, 0);
        GlStateManager.shadeModel(7425);
        if (\u26034.func_216785_c().field_72448_b < 128.0) {
            this.func_215313_a(\u26034, worldRenderer, f, \u26037, \u26038, \u26039);
        }
        this.field_78531_r.func_213239_aq().func_219895_b("prepareterrain");
        this.field_205003_A.func_217618_a(\u26034, 0);
        this.field_78531_r.func_110434_K().func_110577_a(AtlasTexture.field_110575_b);
        RenderHelper.func_74518_a();
        this.field_78531_r.func_213239_aq().func_219895_b("terrain_setup");
        this.field_78531_r.field_71441_e.func_72863_F().func_212863_j_().func_215575_a(Integer.MAX_VALUE, true, true);
        worldRenderer.func_215320_a(\u26034, \u26036, this.field_175084_ae++, this.field_78531_r.field_71439_g.func_175149_v());
        this.field_78531_r.func_213239_aq().func_219895_b("updatechunks");
        this.field_78531_r.field_71438_f.func_174967_a(l);
        this.field_78531_r.func_213239_aq().func_219895_b("terrain");
        GlStateManager.matrixMode(5888);
        GlStateManager.pushMatrix();
        GlStateManager.disableAlphaTest();
        worldRenderer.func_215323_a(BlockRenderLayer.SOLID, \u26034);
        GlStateManager.enableAlphaTest();
        worldRenderer.func_215323_a(BlockRenderLayer.CUTOUT_MIPPED, \u26034);
        this.field_78531_r.func_110434_K().func_110581_b(AtlasTexture.field_110575_b).func_174936_b(false, false);
        worldRenderer.func_215323_a(BlockRenderLayer.CUTOUT, \u26034);
        this.field_78531_r.func_110434_K().func_110581_b(AtlasTexture.field_110575_b).func_174935_a();
        GlStateManager.shadeModel(7424);
        GlStateManager.alphaFunc(516, 0.1f);
        GlStateManager.matrixMode(5888);
        GlStateManager.popMatrix();
        GlStateManager.pushMatrix();
        RenderHelper.func_74519_b();
        this.field_78531_r.func_213239_aq().func_219895_b("entities");
        worldRenderer.func_215326_a(\u26034, \u26036, f);
        RenderHelper.func_74518_a();
        this.func_175072_h();
        GlStateManager.matrixMode(5888);
        GlStateManager.popMatrix();
        if (\u26033 && this.field_78531_r.field_71476_x != null) {
            GlStateManager.disableAlphaTest();
            this.field_78531_r.func_213239_aq().func_219895_b("outline");
            worldRenderer.func_215325_a(\u26034, this.field_78531_r.field_71476_x, 0);
            GlStateManager.enableAlphaTest();
        }
        if (this.field_78531_r.field_184132_p.func_190074_a()) {
            this.field_78531_r.field_184132_p.func_190073_a(l);
        }
        this.field_78531_r.func_213239_aq().func_219895_b("destroyProgress");
        GlStateManager.enableBlend();
        GlStateManager.blendFuncSeparate(GlStateManager.SourceFactor.SRC_ALPHA, GlStateManager.DestFactor.ONE, GlStateManager.SourceFactor.ONE, GlStateManager.DestFactor.ZERO);
        this.field_78531_r.func_110434_K().func_110581_b(AtlasTexture.field_110575_b).func_174936_b(false, false);
        worldRenderer.func_215318_a(Tessellator.func_178181_a(), Tessellator.func_178181_a().func_178180_c(), \u26034);
        this.field_78531_r.func_110434_K().func_110581_b(AtlasTexture.field_110575_b).func_174935_a();
        GlStateManager.disableBlend();
        this.func_180436_i();
        this.field_205003_A.func_217618_a(\u26034, 0);
        this.field_78531_r.func_213239_aq().func_219895_b("particles");
        \u26032.func_215233_a(\u26034, f);
        this.func_175072_h();
        GlStateManager.depthMask(false);
        GlStateManager.enableCull();
        this.field_78531_r.func_213239_aq().func_219895_b("weather");
        this.func_78474_d(f);
        GlStateManager.depthMask(true);
        worldRenderer.func_215322_a(\u26034, f);
        GlStateManager.disableBlend();
        GlStateManager.enableCull();
        GlStateManager.blendFuncSeparate(GlStateManager.SourceFactor.SRC_ALPHA, GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, GlStateManager.SourceFactor.ONE, GlStateManager.DestFactor.ZERO);
        GlStateManager.alphaFunc(516, 0.1f);
        this.field_205003_A.func_217618_a(\u26034, 0);
        GlStateManager.enableBlend();
        GlStateManager.depthMask(false);
        this.field_78531_r.func_110434_K().func_110577_a(AtlasTexture.field_110575_b);
        GlStateManager.shadeModel(7425);
        this.field_78531_r.func_213239_aq().func_219895_b("translucent");
        worldRenderer.func_215323_a(BlockRenderLayer.TRANSLUCENT, \u26034);
        GlStateManager.shadeModel(7424);
        GlStateManager.depthMask(true);
        GlStateManager.enableCull();
        GlStateManager.disableBlend();
        GlStateManager.disableFog();
        if (\u26034.func_216785_c().field_72448_b >= 128.0) {
            this.field_78531_r.func_213239_aq().func_219895_b("aboveClouds");
            this.func_215313_a(\u26034, worldRenderer, f, \u26037, \u26038, \u26039);
        }
        this.field_78531_r.func_213239_aq().func_219895_b("hand");
        if (this.field_175074_C) {
            GlStateManager.clear(256, Minecraft.field_142025_a);
            this.func_215308_a(\u26034, f);
        }
    }

    private void func_215313_a(ActiveRenderInfo activeRenderInfo, WorldRenderer worldRenderer, float f, double d, double d2, double d3) {
        if (this.field_78531_r.field_71474_y.func_216842_e() != CloudOption.OFF) {
            this.field_78531_r.func_213239_aq().func_219895_b("clouds");
            GlStateManager.matrixMode(5889);
            GlStateManager.loadIdentity();
            GlStateManager.multMatrix(Matrix4f.func_195876_a(this.func_215311_a(activeRenderInfo, f, true), (float)this.field_78531_r.field_195558_d.func_198109_k() / (float)this.field_78531_r.field_195558_d.func_198091_l(), 0.05f, this.field_78530_s * 4.0f));
            GlStateManager.matrixMode(5888);
            GlStateManager.pushMatrix();
            this.field_205003_A.func_217618_a(activeRenderInfo, 0);
            worldRenderer.func_195466_a(f, d, d2, d3);
            GlStateManager.disableFog();
            GlStateManager.popMatrix();
            GlStateManager.matrixMode(5889);
            GlStateManager.loadIdentity();
            GlStateManager.multMatrix(Matrix4f.func_195876_a(this.func_215311_a(activeRenderInfo, f, true), (float)this.field_78531_r.field_195558_d.func_198109_k() / (float)this.field_78531_r.field_195558_d.func_198091_l(), 0.05f, this.field_78530_s * MathHelper.field_180189_a));
            GlStateManager.matrixMode(5888);
        }
    }

    private void func_78484_h() {
        float f = this.field_78531_r.field_71441_e.func_72867_j(1.0f);
        if (!this.field_78531_r.field_71474_y.field_74347_j) {
            f /= 2.0f;
        }
        if (f == 0.0f) {
            return;
        }
        this.field_78537_ab.setSeed((long)this.field_78529_t * 312987231L);
        ClientWorld \u26032 = this.field_78531_r.field_71441_e;
        BlockPos \u26033 = new BlockPos(this.field_215317_L.func_216785_c());
        int \u26034 = 10;
        double \u26035 = 0.0;
        double \u26036 = 0.0;
        double \u26037 = 0.0;
        int \u26038 = 0;
        int \u26039 = (int)(100.0f * f * f);
        if (this.field_78531_r.field_71474_y.field_74362_aa == ParticleStatus.DECREASED) {
            \u26039 >>= 1;
        } else if (this.field_78531_r.field_71474_y.field_74362_aa == ParticleStatus.MINIMAL) {
            \u26039 = 0;
        }
        for (int i = 0; i < \u26039; ++i) {
            double d;
            BlockPos blockPos = \u26032.func_205770_a(Heightmap.Type.MOTION_BLOCKING, \u26033.func_177982_a(this.field_78537_ab.nextInt(10) - this.field_78537_ab.nextInt(10), 0, this.field_78537_ab.nextInt(10) - this.field_78537_ab.nextInt(10)));
            Biome \u260310 = \u26032.func_180494_b(blockPos);
            \u2603 = blockPos.func_177977_b();
            if (blockPos.func_177956_o() > \u26033.func_177956_o() + 10 || blockPos.func_177956_o() < \u26033.func_177956_o() - 10 || \u260310.func_201851_b() != Biome.RainType.RAIN || !(\u260310.func_225486_c(blockPos) >= 0.15f)) continue;
            double \u260311 = this.field_78537_ab.nextDouble();
            double \u260312 = this.field_78537_ab.nextDouble();
            BlockState \u260313 = \u26032.func_180495_p(\u2603);
            IFluidState \u260314 = \u26032.func_204610_c(blockPos);
            VoxelShape \u260315 = \u260313.func_196952_d(\u26032, \u2603);
            double \u260316 = \u260315.func_197760_b(Direction.Axis.Y, \u260311, \u260312);
            if (\u260316 >= (\u2603 = (double)\u260314.func_215679_a(\u26032, blockPos))) {
                d = \u260316;
                \u2603 = \u260315.func_197764_a(Direction.Axis.Y, \u260311, \u260312);
            } else {
                d = 0.0;
                \u2603 = 0.0;
            }
            if (!(d > -1.7976931348623157E308)) continue;
            if (\u260314.func_206884_a(FluidTags.field_206960_b) || \u260313.func_177230_c() == Blocks.field_196814_hQ || \u260313.func_177230_c() == Blocks.field_222433_lV && \u260313.func_177229_b(CampfireBlock.field_220101_b).booleanValue()) {
                this.field_78531_r.field_71441_e.func_195594_a(ParticleTypes.field_197601_L, (double)blockPos.func_177958_n() + \u260311, (double)((float)blockPos.func_177956_o() + 0.1f) - \u2603, (double)blockPos.func_177952_p() + \u260312, 0.0, 0.0, 0.0);
                continue;
            }
            if (this.field_78537_ab.nextInt(++\u26038) == 0) {
                \u26035 = (double)\u2603.func_177958_n() + \u260311;
                \u26036 = (double)((float)\u2603.func_177956_o() + 0.1f) + d - 1.0;
                \u26037 = (double)\u2603.func_177952_p() + \u260312;
            }
            this.field_78531_r.field_71441_e.func_195594_a(ParticleTypes.field_197600_K, (double)\u2603.func_177958_n() + \u260311, (double)((float)\u2603.func_177956_o() + 0.1f) + d, (double)\u2603.func_177952_p() + \u260312, 0.0, 0.0, 0.0);
        }
        if (\u26038 > 0 && this.field_78537_ab.nextInt(3) < this.field_78534_ac++) {
            this.field_78534_ac = 0;
            if (\u26036 > (double)(\u26033.func_177956_o() + 1) && \u26032.func_205770_a(Heightmap.Type.MOTION_BLOCKING, \u26033).func_177956_o() > MathHelper.func_76141_d(\u26033.func_177956_o())) {
                this.field_78531_r.field_71441_e.func_184134_a(\u26035, \u26036, \u26037, SoundEvents.field_187919_gs, SoundCategory.WEATHER, 0.1f, 0.5f, false);
            } else {
                this.field_78531_r.field_71441_e.func_184134_a(\u26035, \u26036, \u26037, SoundEvents.field_187918_gr, SoundCategory.WEATHER, 0.2f, 1.0f, false);
            }
        }
    }

    protected void func_78474_d(float f) {
        \u2603 = this.field_78531_r.field_71441_e.func_72867_j(f);
        if (\u2603 <= 0.0f) {
            return;
        }
        this.func_180436_i();
        ClientWorld clientWorld = this.field_78531_r.field_71441_e;
        int \u26032 = MathHelper.func_76128_c(this.field_215317_L.func_216785_c().field_72450_a);
        int \u26033 = MathHelper.func_76128_c(this.field_215317_L.func_216785_c().field_72448_b);
        int \u26034 = MathHelper.func_76128_c(this.field_215317_L.func_216785_c().field_72449_c);
        Tessellator \u26035 = Tessellator.func_178181_a();
        BufferBuilder \u26036 = \u26035.func_178180_c();
        GlStateManager.disableCull();
        GlStateManager.normal3f(0.0f, 1.0f, 0.0f);
        GlStateManager.enableBlend();
        GlStateManager.blendFuncSeparate(GlStateManager.SourceFactor.SRC_ALPHA, GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, GlStateManager.SourceFactor.ONE, GlStateManager.DestFactor.ZERO);
        GlStateManager.alphaFunc(516, 0.1f);
        double \u26037 = this.field_215317_L.func_216785_c().field_72450_a;
        double \u26038 = this.field_215317_L.func_216785_c().field_72448_b;
        double \u26039 = this.field_215317_L.func_216785_c().field_72449_c;
        int \u260310 = MathHelper.func_76128_c(\u26038);
        int \u260311 = 5;
        if (this.field_78531_r.field_71474_y.field_74347_j) {
            \u260311 = 10;
        }
        int \u260312 = -1;
        float \u260313 = (float)this.field_78529_t + f;
        \u26036.func_178969_c(-\u26037, -\u26038, -\u26039);
        GlStateManager.color4f(1.0f, 1.0f, 1.0f, 1.0f);
        BlockPos.MutableBlockPos \u260314 = new BlockPos.MutableBlockPos();
        for (int i = \u26034 - \u260311; i <= \u26034 + \u260311; ++i) {
            for (n = \u26032 - \u260311; n <= \u26032 + \u260311; ++n) {
                int n;
                \u2603 = (i - \u26034 + 16) * 32 + n - \u26032 + 16;
                double d = (double)this.field_175076_N[\u2603] * 0.5;
                \u2603 = (double)this.field_175077_O[\u2603] * 0.5;
                \u260314.func_181079_c(n, 0, i);
                Biome \u260315 = clientWorld.func_180494_b(\u260314);
                if (\u260315.func_201851_b() == Biome.RainType.NONE) continue;
                int \u260316 = clientWorld.func_205770_a(Heightmap.Type.MOTION_BLOCKING, \u260314).func_177956_o();
                int \u260317 = \u26033 - \u260311;
                int \u260318 = \u26033 + \u260311;
                if (\u260317 < \u260316) {
                    \u260317 = \u260316;
                }
                if (\u260318 < \u260316) {
                    \u260318 = \u260316;
                }
                if ((n2 = \u260316) < \u260310) {
                    int n2 = \u260310;
                }
                if (\u260317 == \u260318) continue;
                this.field_78537_ab.setSeed(n * n * 3121 + n * 45238971 ^ i * i * 418711 + i * 13761);
                \u260314.func_181079_c(n, \u260317, i);
                float \u260319 = \u260315.func_225486_c(\u260314);
                if (\u260319 >= 0.15f) {
                    if (\u260312 != 0) {
                        if (\u260312 >= 0) {
                            \u26035.func_78381_a();
                        }
                        \u260312 = 0;
                        this.field_78531_r.func_110434_K().func_110577_a(field_110924_q);
                        \u26036.func_181668_a(7, DefaultVertexFormats.field_181704_d);
                    }
                    double d2 = -((double)(this.field_78529_t + n * n * 3121 + n * 45238971 + i * i * 418711 + i * 13761 & 0x1F) + (double)f) / 32.0 * (3.0 + this.field_78537_ab.nextDouble());
                    \u2603 = (double)((float)n + 0.5f) - this.field_215317_L.func_216785_c().field_72450_a;
                    \u2603 = (double)((float)i + 0.5f) - this.field_215317_L.func_216785_c().field_72449_c;
                    float \u260320 = MathHelper.func_76133_a(\u2603 * \u2603 + \u2603 * \u2603) / (float)\u260311;
                    float \u260321 = ((1.0f - \u260320 * \u260320) * 0.5f + 0.5f) * \u2603;
                    \u260314.func_181079_c(n, n2, i);
                    int \u260322 = clientWorld.func_217338_b(\u260314, 0);
                    int \u260323 = \u260322 >> 16 & 0xFFFF;
                    int \u260324 = \u260322 & 0xFFFF;
                    \u26036.func_181662_b((double)n - d + 0.5, \u260318, (double)i - \u2603 + 0.5).func_187315_a(0.0, (double)\u260317 * 0.25 + d2).func_181666_a(1.0f, 1.0f, 1.0f, \u260321).func_187314_a(\u260323, \u260324).func_181675_d();
                    \u26036.func_181662_b((double)n + d + 0.5, \u260318, (double)i + \u2603 + 0.5).func_187315_a(1.0, (double)\u260317 * 0.25 + d2).func_181666_a(1.0f, 1.0f, 1.0f, \u260321).func_187314_a(\u260323, \u260324).func_181675_d();
                    \u26036.func_181662_b((double)n + d + 0.5, \u260317, (double)i + \u2603 + 0.5).func_187315_a(1.0, (double)\u260318 * 0.25 + d2).func_181666_a(1.0f, 1.0f, 1.0f, \u260321).func_187314_a(\u260323, \u260324).func_181675_d();
                    \u26036.func_181662_b((double)n - d + 0.5, \u260317, (double)i - \u2603 + 0.5).func_187315_a(0.0, (double)\u260318 * 0.25 + d2).func_181666_a(1.0f, 1.0f, 1.0f, \u260321).func_187314_a(\u260323, \u260324).func_181675_d();
                    continue;
                }
                if (\u260312 != 1) {
                    if (\u260312 >= 0) {
                        \u26035.func_78381_a();
                    }
                    \u260312 = 1;
                    this.field_78531_r.func_110434_K().func_110577_a(field_110923_r);
                    \u26036.func_181668_a(7, DefaultVertexFormats.field_181704_d);
                }
                d2 = -((float)(this.field_78529_t & 0x1FF) + f) / 512.0f;
                \u2603 = this.field_78537_ab.nextDouble() + (double)\u260313 * 0.01 * (double)((float)this.field_78537_ab.nextGaussian());
                \u2603 = this.field_78537_ab.nextDouble() + (double)(\u260313 * (float)this.field_78537_ab.nextGaussian()) * 0.001;
                \u2603 = (double)((float)n + 0.5f) - this.field_215317_L.func_216785_c().field_72450_a;
                \u2603 = (double)((float)i + 0.5f) - this.field_215317_L.func_216785_c().field_72449_c;
                float f2 = MathHelper.func_76133_a(\u2603 * \u2603 + \u2603 * \u2603) / (float)\u260311;
                \u2603 = ((1.0f - f2 * f2) * 0.3f + 0.5f) * \u2603;
                \u260314.func_181079_c(n, n2, i);
                int \u260325 = (clientWorld.func_217338_b(\u260314, 0) * 3 + 0xF000F0) / 4;
                int \u260326 = \u260325 >> 16 & 0xFFFF;
                int \u260327 = \u260325 & 0xFFFF;
                \u26036.func_181662_b((double)n - d + 0.5, \u260318, (double)i - \u2603 + 0.5).func_187315_a(0.0 + \u2603, (double)\u260317 * 0.25 + d2 + \u2603).func_181666_a(1.0f, 1.0f, 1.0f, \u2603).func_187314_a(\u260326, \u260327).func_181675_d();
                \u26036.func_181662_b((double)n + d + 0.5, \u260318, (double)i + \u2603 + 0.5).func_187315_a(1.0 + \u2603, (double)\u260317 * 0.25 + d2 + \u2603).func_181666_a(1.0f, 1.0f, 1.0f, \u2603).func_187314_a(\u260326, \u260327).func_181675_d();
                \u26036.func_181662_b((double)n + d + 0.5, \u260317, (double)i + \u2603 + 0.5).func_187315_a(1.0 + \u2603, (double)\u260318 * 0.25 + d2 + \u2603).func_181666_a(1.0f, 1.0f, 1.0f, \u2603).func_187314_a(\u260326, \u260327).func_181675_d();
                \u26036.func_181662_b((double)n - d + 0.5, \u260317, (double)i - \u2603 + 0.5).func_187315_a(0.0 + \u2603, (double)\u260318 * 0.25 + d2 + \u2603).func_181666_a(1.0f, 1.0f, 1.0f, \u2603).func_187314_a(\u260326, \u260327).func_181675_d();
            }
        }
        if (\u260312 >= 0) {
            \u26035.func_78381_a();
        }
        \u26036.func_178969_c(0.0, 0.0, 0.0);
        GlStateManager.enableCull();
        GlStateManager.disableBlend();
        GlStateManager.alphaFunc(516, 0.1f);
        this.func_175072_h();
    }

    public void func_191514_d(boolean bl) {
        this.field_205003_A.func_205090_a(bl);
    }

    public void func_190564_k() {
        this.field_190566_ab = null;
        this.field_147709_v.func_148249_a();
        this.field_215317_L.func_216781_o();
    }

    public MapItemRenderer func_147701_i() {
        return this.field_147709_v;
    }

    public static void func_215307_a(FontRenderer fontRenderer, String string, float f, float f2, float f3, int n, float f4, float f5, boolean bl) {
        GlStateManager.pushMatrix();
        GlStateManager.translatef(f, f2, f3);
        GlStateManager.normal3f(0.0f, 1.0f, 0.0f);
        GlStateManager.rotatef(-f4, 0.0f, 1.0f, 0.0f);
        GlStateManager.rotatef(f5, 1.0f, 0.0f, 0.0f);
        GlStateManager.scalef(-0.025f, -0.025f, 0.025f);
        GlStateManager.disableLighting();
        GlStateManager.depthMask(false);
        if (!bl) {
            GlStateManager.disableDepthTest();
        }
        GlStateManager.enableBlend();
        GlStateManager.blendFuncSeparate(GlStateManager.SourceFactor.SRC_ALPHA, GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, GlStateManager.SourceFactor.ONE, GlStateManager.DestFactor.ZERO);
        int n2 = fontRenderer.func_78256_a(string) / 2;
        GlStateManager.disableTexture();
        Tessellator \u26032 = Tessellator.func_178181_a();
        BufferBuilder \u26033 = \u26032.func_178180_c();
        \u26033.func_181668_a(7, DefaultVertexFormats.field_181706_f);
        float \u26034 = Minecraft.func_71410_x().field_71474_y.func_216840_a(0.25f);
        \u26033.func_181662_b(-n2 - 1, -1 + n, 0.0).func_181666_a(0.0f, 0.0f, 0.0f, \u26034).func_181675_d();
        \u26033.func_181662_b(-n2 - 1, 8 + n, 0.0).func_181666_a(0.0f, 0.0f, 0.0f, \u26034).func_181675_d();
        \u26033.func_181662_b(n2 + 1, 8 + n, 0.0).func_181666_a(0.0f, 0.0f, 0.0f, \u26034).func_181675_d();
        \u26033.func_181662_b(n2 + 1, -1 + n, 0.0).func_181666_a(0.0f, 0.0f, 0.0f, \u26034).func_181675_d();
        \u26032.func_78381_a();
        GlStateManager.enableTexture();
        if (!bl) {
            fontRenderer.func_211126_b(string, -fontRenderer.func_78256_a(string) / 2, n, 0x20FFFFFF);
            GlStateManager.enableDepthTest();
        }
        GlStateManager.depthMask(true);
        fontRenderer.func_211126_b(string, -fontRenderer.func_78256_a(string) / 2, n, bl ? 0x20FFFFFF : -1);
        GlStateManager.enableLighting();
        GlStateManager.disableBlend();
        GlStateManager.color4f(1.0f, 1.0f, 1.0f, 1.0f);
        GlStateManager.popMatrix();
    }

    public void func_190565_a(ItemStack itemStack) {
        this.field_190566_ab = itemStack;
        this.field_190567_ac = 40;
        this.field_190568_ad = this.field_78537_ab.nextFloat() * 2.0f - 1.0f;
        this.field_190569_ae = this.field_78537_ab.nextFloat() * 2.0f - 1.0f;
    }

    private void func_190563_a(int n, int n2, float f) {
        if (this.field_190566_ab == null || this.field_190567_ac <= 0) {
            return;
        }
        int n3 = 40 - this.field_190567_ac;
        float \u26032 = ((float)n3 + f) / 40.0f;
        float \u26033 = \u26032 * \u26032;
        float \u26034 = \u26032 * \u26033;
        float \u26035 = 10.25f * \u26034 * \u26033 - 24.95f * \u26033 * \u26033 + 25.5f * \u26034 - 13.8f * \u26033 + 4.0f * \u26032;
        float \u26036 = \u26035 * (float)Math.PI;
        float \u26037 = this.field_190568_ad * (float)(n / 4);
        float \u26038 = this.field_190569_ae * (float)(n2 / 4);
        GlStateManager.enableAlphaTest();
        GlStateManager.pushMatrix();
        GlStateManager.pushLightingAttributes();
        GlStateManager.enableDepthTest();
        GlStateManager.disableCull();
        RenderHelper.func_74519_b();
        GlStateManager.translatef((float)(n / 2) + \u26037 * MathHelper.func_76135_e(MathHelper.func_76126_a(\u26036 * 2.0f)), (float)(n2 / 2) + \u26038 * MathHelper.func_76135_e(MathHelper.func_76126_a(\u26036 * 2.0f)), -50.0f);
        float \u26039 = 50.0f + 175.0f * MathHelper.func_76126_a(\u26036);
        GlStateManager.scalef(\u26039, -\u26039, \u26039);
        GlStateManager.rotatef(900.0f * MathHelper.func_76135_e(MathHelper.func_76126_a(\u26036)), 0.0f, 1.0f, 0.0f);
        GlStateManager.rotatef(6.0f * MathHelper.func_76134_b(\u26032 * 8.0f), 1.0f, 0.0f, 0.0f);
        GlStateManager.rotatef(6.0f * MathHelper.func_76134_b(\u26032 * 8.0f), 0.0f, 0.0f, 1.0f);
        this.field_78531_r.func_175599_af().func_181564_a(this.field_190566_ab, ItemCameraTransforms.TransformType.FIXED);
        GlStateManager.popAttributes();
        GlStateManager.popMatrix();
        RenderHelper.func_74518_a();
        GlStateManager.enableCull();
        GlStateManager.disableDepthTest();
    }

    public Minecraft func_205000_l() {
        return this.field_78531_r;
    }

    public float func_205002_d(float f) {
        return MathHelper.func_219799_g(f, this.field_82832_V, this.field_82831_U);
    }

    public float func_205001_m() {
        return this.field_78530_s;
    }

    public ActiveRenderInfo func_215316_n() {
        return this.field_215317_L;
    }
}

