/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.particle;

import net.minecraft.client.particle.IAnimatedSprite;
import net.minecraft.client.particle.IParticleFactory;
import net.minecraft.client.particle.IParticleRenderType;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.SpriteTexturedParticle;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.Fluids;
import net.minecraft.fluid.IFluidState;
import net.minecraft.particles.BasicParticleType;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class DripParticle
extends SpriteTexturedParticle {
    private final Fluid field_204502_a;

    private DripParticle(World world, double d, double d2, double d3, Fluid fluid) {
        super(world, d, d2, d3);
        this.func_187115_a(0.01f, 0.01f);
        this.field_70545_g = 0.06f;
        this.field_204502_a = fluid;
    }

    @Override
    public IParticleRenderType func_217558_b() {
        return IParticleRenderType.field_217602_b;
    }

    @Override
    public int func_189214_a(float f) {
        if (this.field_204502_a.func_207185_a(FluidTags.field_206960_b)) {
            return 240;
        }
        return super.func_189214_a(f);
    }

    @Override
    public void func_189213_a() {
        this.field_187123_c = this.field_187126_f;
        this.field_187124_d = this.field_187127_g;
        this.field_187125_e = this.field_187128_h;
        this.func_217576_g();
        if (this.field_187133_m) {
            return;
        }
        this.field_187130_j -= (double)this.field_70545_g;
        this.func_187110_a(this.field_187129_i, this.field_187130_j, this.field_187131_k);
        this.func_217577_h();
        if (this.field_187133_m) {
            return;
        }
        this.field_187129_i *= (double)0.98f;
        this.field_187130_j *= (double)0.98f;
        this.field_187131_k *= (double)0.98f;
        BlockPos blockPos = new BlockPos(this.field_187126_f, this.field_187127_g, this.field_187128_h);
        IFluidState \u26032 = this.field_187122_b.func_204610_c(blockPos);
        if (\u26032.func_206886_c() == this.field_204502_a && this.field_187127_g < (double)((float)blockPos.func_177956_o() + \u26032.func_215679_a(this.field_187122_b, blockPos))) {
            this.func_187112_i();
        }
    }

    protected void func_217576_g() {
        if (this.field_70547_e-- <= 0) {
            this.func_187112_i();
        }
    }

    protected void func_217577_h() {
    }

    public static class LandingLavaFactory
    implements IParticleFactory<BasicParticleType> {
        protected final IAnimatedSprite field_217520_a;

        public LandingLavaFactory(IAnimatedSprite iAnimatedSprite) {
            this.field_217520_a = iAnimatedSprite;
        }

        @Override
        public Particle func_199234_a(BasicParticleType basicParticleType, World world, double d, double d2, double d3, double d4, double d5, double d6) {
            Landing landing = new Landing(world, d, d2, d3, Fluids.field_204547_b);
            landing.func_70538_b(1.0f, 0.2857143f, 0.083333336f);
            landing.func_217568_a(this.field_217520_a);
            return landing;
        }
    }

    public static class FallingLavaFactory
    implements IParticleFactory<BasicParticleType> {
        protected final IAnimatedSprite field_217518_a;

        public FallingLavaFactory(IAnimatedSprite iAnimatedSprite) {
            this.field_217518_a = iAnimatedSprite;
        }

        @Override
        public Particle func_199234_a(BasicParticleType basicParticleType, World world, double d, double d2, double d3, double d4, double d5, double d6) {
            Falling falling = new Falling(world, d, d2, d3, Fluids.field_204547_b, ParticleTypes.field_218424_l);
            falling.func_70538_b(1.0f, 0.2857143f, 0.083333336f);
            falling.func_217568_a(this.field_217518_a);
            return falling;
        }
    }

    public static class DrippingLavaFactory
    implements IParticleFactory<BasicParticleType> {
        protected final IAnimatedSprite field_217519_a;

        public DrippingLavaFactory(IAnimatedSprite iAnimatedSprite) {
            this.field_217519_a = iAnimatedSprite;
        }

        @Override
        public Particle func_199234_a(BasicParticleType basicParticleType, World world, double d, double d2, double d3, double d4, double d5, double d6) {
            DrippingLava drippingLava = new DrippingLava(world, d, d2, d3, Fluids.field_204547_b, ParticleTypes.field_218423_k);
            drippingLava.func_217568_a(this.field_217519_a);
            return drippingLava;
        }
    }

    public static class FallingWaterFactory
    implements IParticleFactory<BasicParticleType> {
        protected final IAnimatedSprite field_217521_a;

        public FallingWaterFactory(IAnimatedSprite iAnimatedSprite) {
            this.field_217521_a = iAnimatedSprite;
        }

        @Override
        public Particle func_199234_a(BasicParticleType basicParticleType, World world, double d, double d2, double d3, double d4, double d5, double d6) {
            Falling falling = new Falling(world, d, d2, d3, Fluids.field_204546_a, ParticleTypes.field_218422_X);
            falling.func_70538_b(0.2f, 0.3f, 1.0f);
            falling.func_217568_a(this.field_217521_a);
            return falling;
        }
    }

    public static class DrippingWaterFactory
    implements IParticleFactory<BasicParticleType> {
        protected final IAnimatedSprite field_217522_a;

        public DrippingWaterFactory(IAnimatedSprite iAnimatedSprite) {
            this.field_217522_a = iAnimatedSprite;
        }

        @Override
        public Particle func_199234_a(BasicParticleType basicParticleType, World world, double d, double d2, double d3, double d4, double d5, double d6) {
            Dripping dripping = new Dripping(world, d, d2, d3, Fluids.field_204546_a, ParticleTypes.field_218425_n);
            dripping.func_70538_b(0.2f, 0.3f, 1.0f);
            dripping.func_217568_a(this.field_217522_a);
            return dripping;
        }
    }

    static class Landing
    extends DripParticle {
        private Landing(World world, double d, double d2, double d3, Fluid fluid) {
            super(world, d, d2, d3, fluid);
            this.field_70547_e = (int)(16.0 / (Math.random() * 0.8 + 0.2));
        }
    }

    static class Falling
    extends DripParticle {
        private final IParticleData field_217578_C;

        private Falling(World world, double d, double d2, double d3, Fluid fluid, IParticleData iParticleData) {
            super(world, d, d2, d3, fluid);
            this.field_217578_C = iParticleData;
            this.field_70547_e = (int)(64.0 / (Math.random() * 0.8 + 0.2));
        }

        @Override
        protected void func_217577_h() {
            if (this.field_187132_l) {
                this.func_187112_i();
                this.field_187122_b.func_195594_a(this.field_217578_C, this.field_187126_f, this.field_187127_g, this.field_187128_h, 0.0, 0.0, 0.0);
            }
        }
    }

    static class DrippingLava
    extends Dripping {
        private DrippingLava(World world, double d, double d2, double d3, Fluid fluid, IParticleData iParticleData) {
            super(world, d, d2, d3, fluid, iParticleData);
        }

        @Override
        protected void func_217576_g() {
            this.field_70552_h = 1.0f;
            this.field_70553_i = 16.0f / (float)(40 - this.field_70547_e + 16);
            this.field_70551_j = 4.0f / (float)(40 - this.field_70547_e + 8);
            super.func_217576_g();
        }
    }

    static class Dripping
    extends DripParticle {
        private final IParticleData field_217579_C;

        private Dripping(World world, double d, double d2, double d3, Fluid fluid, IParticleData iParticleData) {
            super(world, d, d2, d3, fluid);
            this.field_217579_C = iParticleData;
            this.field_70545_g *= 0.02f;
            this.field_70547_e = 40;
        }

        @Override
        protected void func_217576_g() {
            if (this.field_70547_e-- <= 0) {
                this.func_187112_i();
                this.field_187122_b.func_195594_a(this.field_217579_C, this.field_187126_f, this.field_187127_g, this.field_187128_h, this.field_187129_i, this.field_187130_j, this.field_187131_k);
            }
        }

        @Override
        protected void func_217577_h() {
            this.field_187129_i *= 0.02;
            this.field_187130_j *= 0.02;
            this.field_187131_k *= 0.02;
        }
    }
}

