/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui.screen;

import com.google.common.hash.Hashing;
import com.mojang.blaze3d.platform.GlStateManager;
import java.io.File;
import java.io.FileInputStream;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.client.AnvilConverterException;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.SimpleSound;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.client.gui.chat.NarratorChatListener;
import net.minecraft.client.gui.screen.AlertScreen;
import net.minecraft.client.gui.screen.ConfirmBackupScreen;
import net.minecraft.client.gui.screen.ConfirmScreen;
import net.minecraft.client.gui.screen.CreateWorldScreen;
import net.minecraft.client.gui.screen.EditWorldScreen;
import net.minecraft.client.gui.screen.ErrorScreen;
import net.minecraft.client.gui.screen.WorkingScreen;
import net.minecraft.client.gui.screen.WorldSelectionScreen;
import net.minecraft.client.gui.widget.list.AbstractList;
import net.minecraft.client.gui.widget.list.ExtendedList;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.client.renderer.texture.NativeImage;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SharedConstants;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.Util;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.storage.SaveFormat;
import net.minecraft.world.storage.SaveHandler;
import net.minecraft.world.storage.WorldInfo;
import net.minecraft.world.storage.WorldSummary;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class WorldSelectionList
extends ExtendedList<Entry> {
    private static final Logger field_186797_u = LogManager.getLogger();
    private static final DateFormat field_214377_b = new SimpleDateFormat();
    private static final ResourceLocation field_214378_c = new ResourceLocation("textures/misc/unknown_server.png");
    private static final ResourceLocation field_214379_d = new ResourceLocation("textures/gui/world_selection.png");
    private final WorldSelectionScreen field_186798_v;
    @Nullable
    private List<WorldSummary> field_212331_y;

    public WorldSelectionList(WorldSelectionScreen worldSelectionScreen, Minecraft minecraft, int n, int n2, int n3, int n4, int n5, Supplier<String> supplier, @Nullable WorldSelectionList worldSelectionList) {
        super(minecraft, n, n2, n3, n4, n5);
        this.field_186798_v = worldSelectionScreen;
        if (worldSelectionList != null) {
            this.field_212331_y = worldSelectionList.field_212331_y;
        }
        this.func_212330_a(supplier, false);
    }

    public void func_212330_a(Supplier<String> supplier2, boolean bl) {
        Supplier<String> supplier2;
        this.clearEntries();
        SaveFormat saveFormat = this.minecraft.func_71359_d();
        if (this.field_212331_y == null || bl) {
            try {
                this.field_212331_y = saveFormat.func_75799_b();
            }
            catch (AnvilConverterException anvilConverterException) {
                field_186797_u.error("Couldn't load level list", (Throwable)anvilConverterException);
                this.minecraft.func_147108_a(new ErrorScreen(new TranslationTextComponent("selectWorld.unable_to_load", new Object[0]), anvilConverterException.getMessage()));
                return;
            }
            Collections.sort(this.field_212331_y);
        }
        String \u26032 = supplier2.get().toLowerCase(Locale.ROOT);
        for (WorldSummary worldSummary : this.field_212331_y) {
            if (!worldSummary.func_75788_b().toLowerCase(Locale.ROOT).contains(\u26032) && !worldSummary.func_75786_a().toLowerCase(Locale.ROOT).contains(\u26032)) continue;
            this.addEntry(new Entry(this, worldSummary, this.minecraft.func_71359_d()));
        }
    }

    @Override
    protected int getScrollbarPosition() {
        return super.getScrollbarPosition() + 20;
    }

    @Override
    public int getRowWidth() {
        return super.getRowWidth() + 50;
    }

    @Override
    protected boolean isFocused() {
        return this.field_186798_v.getFocused() == this;
    }

    @Override
    public void setSelected(@Nullable Entry entry) {
        super.setSelected(entry);
        if (entry != null) {
            WorldSummary worldSummary = entry.field_214451_d;
            NarratorChatListener.field_193643_a.func_216864_a(new TranslationTextComponent("narrator.select", new TranslationTextComponent("narrator.select.world", worldSummary.func_75788_b(), new Date(worldSummary.func_75784_e()), worldSummary.func_75789_g() ? I18n.func_135052_a("gameMode.hardcore", new Object[0]) : I18n.func_135052_a("gameMode." + worldSummary.func_75790_f().func_77149_b(), new Object[0]), worldSummary.func_75783_h() ? I18n.func_135052_a("selectWorld.cheats", new Object[0]) : "", worldSummary.func_200538_i())).getString());
        }
    }

    @Override
    protected void moveSelection(int n) {
        super.moveSelection(n);
        this.field_186798_v.func_214324_a(true);
    }

    public Optional<Entry> func_214376_a() {
        return Optional.ofNullable(this.getSelected());
    }

    public WorldSelectionScreen func_186796_g() {
        return this.field_186798_v;
    }

    @Override
    public /* synthetic */ void setSelected(@Nullable AbstractList.AbstractListEntry abstractListEntry) {
        this.setSelected((Entry)abstractListEntry);
    }

    public final class Entry
    extends ExtendedList.AbstractListEntry<Entry>
    implements AutoCloseable {
        private final Minecraft field_214449_b;
        private final WorldSelectionScreen field_214450_c;
        private final WorldSummary field_214451_d;
        private final ResourceLocation field_214452_e;
        private File field_214453_f;
        @Nullable
        private final DynamicTexture field_214454_g;
        private long field_214455_h;

        public Entry(WorldSelectionList worldSelectionList2, WorldSummary worldSummary, SaveFormat saveFormat) {
            this.field_214450_c = worldSelectionList2.func_186796_g();
            this.field_214451_d = worldSummary;
            this.field_214449_b = Minecraft.func_71410_x();
            this.field_214452_e = new ResourceLocation("worlds/" + Hashing.sha1().hashUnencodedChars((CharSequence)worldSummary.func_75786_a()) + "/icon");
            this.field_214453_f = saveFormat.func_186352_b(worldSummary.func_75786_a(), "icon.png");
            if (!this.field_214453_f.isFile()) {
                this.field_214453_f = null;
            }
            this.field_214454_g = this.func_214446_f();
        }

        @Override
        public void render(int n, int n2, int n32, int n4, int n5, int n6, int n7, boolean bl, float f) {
            String string = this.field_214451_d.func_75788_b();
            \u2603 = this.field_214451_d.func_75786_a() + " (" + field_214377_b.format(new Date(this.field_214451_d.func_75784_e())) + ")";
            if (StringUtils.isEmpty((CharSequence)string)) {
                string = I18n.func_135052_a("selectWorld.world", new Object[0]) + " " + (n + 1);
            }
            \u2603 = "";
            if (this.field_214451_d.func_75785_d()) {
                \u2603 = I18n.func_135052_a("selectWorld.conversion", new Object[0]) + " " + \u2603;
            } else {
                \u2603 = I18n.func_135052_a("gameMode." + this.field_214451_d.func_75790_f().func_77149_b(), new Object[0]);
                if (this.field_214451_d.func_75789_g()) {
                    \u2603 = (Object)((Object)TextFormatting.DARK_RED) + I18n.func_135052_a("gameMode.hardcore", new Object[0]) + (Object)((Object)TextFormatting.RESET);
                }
                if (this.field_214451_d.func_75783_h()) {
                    \u2603 = \u2603 + ", " + I18n.func_135052_a("selectWorld.cheats", new Object[0]);
                }
                \u2603 = this.field_214451_d.func_200538_i().func_150254_d();
                \u2603 = this.field_214451_d.func_186355_l() ? (this.field_214451_d.func_186356_m() ? \u2603 + ", " + I18n.func_135052_a("selectWorld.version", new Object[0]) + " " + (Object)((Object)TextFormatting.RED) + \u2603 + (Object)((Object)TextFormatting.RESET) : \u2603 + ", " + I18n.func_135052_a("selectWorld.version", new Object[0]) + " " + (Object)((Object)TextFormatting.ITALIC) + \u2603 + (Object)((Object)TextFormatting.RESET)) : \u2603 + ", " + I18n.func_135052_a("selectWorld.version", new Object[0]) + " " + \u2603;
            }
            this.field_214449_b.field_71466_p.func_211126_b(string, n32 + 32 + 3, n2 + 1, 0xFFFFFF);
            this.field_214449_b.field_71466_p.func_211126_b(\u2603, n32 + 32 + 3, n2 + this.field_214449_b.field_71466_p.field_78288_b + 3, 0x808080);
            this.field_214449_b.field_71466_p.func_211126_b(\u2603, n32 + 32 + 3, n2 + this.field_214449_b.field_71466_p.field_78288_b + this.field_214449_b.field_71466_p.field_78288_b + 3, 0x808080);
            GlStateManager.color4f(1.0f, 1.0f, 1.0f, 1.0f);
            this.field_214449_b.func_110434_K().func_110577_a(this.field_214454_g != null ? this.field_214452_e : field_214378_c);
            GlStateManager.enableBlend();
            AbstractGui.blit(n32, n2, 0.0f, 0.0f, 32, 32, 32, 32);
            GlStateManager.disableBlend();
            if (this.field_214449_b.field_71474_y.field_85185_A || bl) {
                int n32;
                this.field_214449_b.func_110434_K().func_110577_a(field_214379_d);
                AbstractGui.fill(n32, n2, n32 + 32, n2 + 32, -1601138544);
                GlStateManager.color4f(1.0f, 1.0f, 1.0f, 1.0f);
                int n8 = n6 - n32;
                int n9 = \u2603 = n8 < 32 ? 32 : 0;
                if (this.field_214451_d.func_186355_l()) {
                    AbstractGui.blit(n32, n2, 32.0f, \u2603, 32, 32, 256, 256);
                    if (this.field_214451_d.func_202842_n()) {
                        AbstractGui.blit(n32, n2, 96.0f, \u2603, 32, 32, 256, 256);
                        if (n8 < 32) {
                            ITextComponent iTextComponent = new TranslationTextComponent("selectWorld.tooltip.unsupported", this.field_214451_d.func_200538_i()).func_211708_a(TextFormatting.RED);
                            this.field_214450_c.func_184861_a(this.field_214449_b.field_71466_p.func_78280_d(iTextComponent.func_150254_d(), 175));
                        }
                    } else if (this.field_214451_d.func_186356_m()) {
                        AbstractGui.blit(n32, n2, 96.0f, \u2603, 32, 32, 256, 256);
                        if (n8 < 32) {
                            this.field_214450_c.func_184861_a((Object)((Object)TextFormatting.RED) + I18n.func_135052_a("selectWorld.tooltip.fromNewerVersion1", new Object[0]) + "\n" + (Object)((Object)TextFormatting.RED) + I18n.func_135052_a("selectWorld.tooltip.fromNewerVersion2", new Object[0]));
                        }
                    } else if (!SharedConstants.func_215069_a().isStable()) {
                        AbstractGui.blit(n32, n2, 64.0f, \u2603, 32, 32, 256, 256);
                        if (n8 < 32) {
                            this.field_214450_c.func_184861_a((Object)((Object)TextFormatting.GOLD) + I18n.func_135052_a("selectWorld.tooltip.snapshot1", new Object[0]) + "\n" + (Object)((Object)TextFormatting.GOLD) + I18n.func_135052_a("selectWorld.tooltip.snapshot2", new Object[0]));
                        }
                    }
                } else {
                    AbstractGui.blit(n32, n2, 0.0f, \u2603, 32, 32, 256, 256);
                }
            }
        }

        @Override
        public boolean mouseClicked(double d, double d2, int n) {
            WorldSelectionList.this.setSelected(this);
            this.field_214450_c.func_214324_a(WorldSelectionList.this.func_214376_a().isPresent());
            if (d - (double)WorldSelectionList.this.getRowLeft() <= 32.0) {
                this.func_214438_a();
                return true;
            }
            if (Util.func_211177_b() - this.field_214455_h < 250L) {
                this.func_214438_a();
                return true;
            }
            this.field_214455_h = Util.func_211177_b();
            return false;
        }

        public void func_214438_a() {
            if (this.field_214451_d.func_197731_n() || this.field_214451_d.func_202842_n()) {
                TranslationTextComponent translationTextComponent = new TranslationTextComponent("selectWorld.backupQuestion", new Object[0]);
                \u2603 = new TranslationTextComponent("selectWorld.backupWarning", this.field_214451_d.func_200538_i().func_150254_d(), SharedConstants.func_215069_a().getName());
                if (this.field_214451_d.func_202842_n()) {
                    translationTextComponent = new TranslationTextComponent("selectWorld.backupQuestion.customized", new Object[0]);
                    \u2603 = new TranslationTextComponent("selectWorld.backupWarning.customized", new Object[0]);
                }
                this.field_214449_b.func_147108_a(new ConfirmBackupScreen(this.field_214450_c, (bl, bl2) -> {
                    if (bl) {
                        String string = this.field_214451_d.func_75786_a();
                        EditWorldScreen.func_200212_a(this.field_214449_b.func_71359_d(), string);
                    }
                    this.func_214443_e();
                }, translationTextComponent, \u2603, false));
            } else if (this.field_214451_d.func_186356_m()) {
                this.field_214449_b.func_147108_a(new ConfirmScreen(bl -> {
                    if (bl) {
                        try {
                            this.func_214443_e();
                        }
                        catch (Exception exception) {
                            field_186797_u.error("Failure to open 'future world'", (Throwable)exception);
                            this.field_214449_b.func_147108_a(new AlertScreen(() -> this.field_214449_b.func_147108_a(this.field_214450_c), new TranslationTextComponent("selectWorld.futureworld.error.title", new Object[0]), new TranslationTextComponent("selectWorld.futureworld.error.text", new Object[0])));
                        }
                    } else {
                        this.field_214449_b.func_147108_a(this.field_214450_c);
                    }
                }, new TranslationTextComponent("selectWorld.versionQuestion", new Object[0]), new TranslationTextComponent("selectWorld.versionWarning", this.field_214451_d.func_200538_i().func_150254_d()), I18n.func_135052_a("selectWorld.versionJoinButton", new Object[0]), I18n.func_135052_a("gui.cancel", new Object[0])));
            } else {
                this.func_214443_e();
            }
        }

        public void func_214442_b() {
            this.field_214449_b.func_147108_a(new ConfirmScreen(bl -> {
                if (bl) {
                    this.field_214449_b.func_147108_a(new WorkingScreen());
                    SaveFormat saveFormat = this.field_214449_b.func_71359_d();
                    saveFormat.func_75802_e(this.field_214451_d.func_75786_a());
                    WorldSelectionList.this.func_212330_a(() -> this.field_214450_c.field_212352_g.func_146179_b(), true);
                }
                this.field_214449_b.func_147108_a(this.field_214450_c);
            }, new TranslationTextComponent("selectWorld.deleteQuestion", new Object[0]), new TranslationTextComponent("selectWorld.deleteWarning", this.field_214451_d.func_75788_b()), I18n.func_135052_a("selectWorld.deleteButton", new Object[0]), I18n.func_135052_a("gui.cancel", new Object[0])));
        }

        public void func_214444_c() {
            this.field_214449_b.func_147108_a(new EditWorldScreen(bl -> {
                if (bl) {
                    WorldSelectionList.this.func_212330_a(() -> this.field_214450_c.field_212352_g.func_146179_b(), true);
                }
                this.field_214449_b.func_147108_a(this.field_214450_c);
            }, this.field_214451_d.func_75786_a()));
        }

        public void func_214445_d() {
            try {
                this.field_214449_b.func_147108_a(new WorkingScreen());
                CreateWorldScreen createWorldScreen = new CreateWorldScreen(this.field_214450_c);
                SaveHandler \u26032 = this.field_214449_b.func_71359_d().func_197715_a(this.field_214451_d.func_75786_a(), null);
                WorldInfo \u26033 = \u26032.func_75757_d();
                if (\u26033 != null) {
                    createWorldScreen.func_146318_a(\u26033);
                    if (this.field_214451_d.func_202842_n()) {
                        this.field_214449_b.func_147108_a(new ConfirmScreen(bl -> this.field_214449_b.func_147108_a(bl ? createWorldScreen : this.field_214450_c), new TranslationTextComponent("selectWorld.recreate.customized.title", new Object[0]), new TranslationTextComponent("selectWorld.recreate.customized.text", new Object[0]), I18n.func_135052_a("gui.proceed", new Object[0]), I18n.func_135052_a("gui.cancel", new Object[0])));
                    } else {
                        this.field_214449_b.func_147108_a(createWorldScreen);
                    }
                }
            }
            catch (Exception exception) {
                field_186797_u.error("Unable to recreate world", (Throwable)exception);
                this.field_214449_b.func_147108_a(new AlertScreen(() -> this.field_214449_b.func_147108_a(this.field_214450_c), new TranslationTextComponent("selectWorld.recreate.error.title", new Object[0]), new TranslationTextComponent("selectWorld.recreate.error.text", new Object[0])));
            }
        }

        private void func_214443_e() {
            this.field_214449_b.func_147118_V().func_147682_a(SimpleSound.func_184371_a(SoundEvents.field_187909_gi, 1.0f));
            if (this.field_214449_b.func_71359_d().func_90033_f(this.field_214451_d.func_75786_a())) {
                this.field_214449_b.func_71371_a(this.field_214451_d.func_75786_a(), this.field_214451_d.func_75788_b(), null);
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Nullable
        private DynamicTexture func_214446_f() {
            boolean bl;
            boolean bl2 = bl = this.field_214453_f != null && this.field_214453_f.isFile();
            if (!bl) {
                this.field_214449_b.func_110434_K().func_147645_c(this.field_214452_e);
                return null;
            }
            try (FileInputStream \u26032 = new FileInputStream(this.field_214453_f);){
                NativeImage \u26033 = NativeImage.func_195713_a(\u26032);
                Validate.validState((\u26033.func_195702_a() == 64 ? 1 : 0) != 0, (String)"Must be 64 pixels wide", (Object[])new Object[0]);
                Validate.validState((\u26033.func_195714_b() == 64 ? 1 : 0) != 0, (String)"Must be 64 pixels high", (Object[])new Object[0]);
                DynamicTexture \u26034 = new DynamicTexture(\u26033);
                this.field_214449_b.func_110434_K().func_110579_a(this.field_214452_e, \u26034);
                DynamicTexture dynamicTexture = \u26034;
                return dynamicTexture;
            }
            catch (Throwable throwable6) {
                field_186797_u.error("Invalid icon for world {}", (Object)this.field_214451_d.func_75786_a(), (Object)throwable6);
                this.field_214453_f = null;
                return null;
            }
        }

        @Override
        public void close() {
            if (this.field_214454_g != null) {
                this.field_214454_g.close();
            }
        }
    }
}

