/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui.screen;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.mojang.blaze3d.platform.GlStateManager;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.SimpleSound;
import net.minecraft.client.gui.IProgressMeter;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.client.gui.widget.list.ExtendedList;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.EntityType;
import net.minecraft.item.BlockItem;
import net.minecraft.item.Item;
import net.minecraft.item.Items;
import net.minecraft.network.play.client.CClientStatusPacket;
import net.minecraft.stats.Stat;
import net.minecraft.stats.StatType;
import net.minecraft.stats.StatisticsManager;
import net.minecraft.stats.Stats;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.Util;
import net.minecraft.util.registry.Registry;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;

public class StatsScreen
extends Screen
implements IProgressMeter {
    protected final Screen field_146549_a;
    private CustomStatsList field_146550_h;
    private StatsList field_146551_i;
    private MobStatsList field_146547_s;
    private final StatisticsManager field_146546_t;
    @Nullable
    private ExtendedList<?> field_146545_u;
    private boolean field_146543_v = true;

    public StatsScreen(Screen screen, StatisticsManager statisticsManager) {
        super(new TranslationTextComponent("gui.stats", new Object[0]));
        this.field_146549_a = screen;
        this.field_146546_t = statisticsManager;
    }

    @Override
    protected void init() {
        this.field_146543_v = true;
        this.minecraft.func_147114_u().func_147297_a(new CClientStatusPacket(CClientStatusPacket.State.REQUEST_STATS));
    }

    public void func_193028_a() {
        this.field_146550_h = new CustomStatsList(this.minecraft);
        this.field_146551_i = new StatsList(this.minecraft);
        this.field_146547_s = new MobStatsList(this.minecraft);
    }

    public void func_193029_f() {
        this.addButton(new Button(this.width / 2 - 120, this.height - 52, 80, 20, I18n.func_135052_a("stat.generalButton", new Object[0]), button -> this.func_213110_a(this.field_146550_h)));
        Button button2 = this.addButton(new Button(this.width / 2 - 40, this.height - 52, 80, 20, I18n.func_135052_a("stat.itemsButton", new Object[0]), button -> this.func_213110_a(this.field_146551_i)));
        \u2603 = this.addButton(new Button(this.width / 2 + 40, this.height - 52, 80, 20, I18n.func_135052_a("stat.mobsButton", new Object[0]), button -> this.func_213110_a(this.field_146547_s)));
        this.addButton(new Button(this.width / 2 - 100, this.height - 28, 200, 20, I18n.func_135052_a("gui.done", new Object[0]), button -> this.minecraft.func_147108_a(this.field_146549_a)));
        if (this.field_146551_i.children().isEmpty()) {
            button2.active = false;
        }
        if (this.field_146547_s.children().isEmpty()) {
            \u2603.active = false;
        }
    }

    @Override
    public void render(int n, int n2, float f) {
        if (this.field_146543_v) {
            this.renderBackground();
            this.drawCenteredString(this.font, I18n.func_135052_a("multiplayer.downloadingStats", new Object[0]), this.width / 2, this.height / 2, 0xFFFFFF);
            this.drawCenteredString(this.font, field_146510_b_[(int)(Util.func_211177_b() / 150L % (long)field_146510_b_.length)], this.width / 2, this.height / 2 + this.font.field_78288_b * 2, 0xFFFFFF);
        } else {
            this.func_213116_d().render(n, n2, f);
            this.drawCenteredString(this.font, this.title.func_150254_d(), this.width / 2, 20, 0xFFFFFF);
            super.render(n, n2, f);
        }
    }

    @Override
    public void func_193026_g() {
        if (this.field_146543_v) {
            this.func_193028_a();
            this.func_193029_f();
            this.func_213110_a(this.field_146550_h);
            this.field_146543_v = false;
        }
    }

    @Override
    public boolean isPauseScreen() {
        return !this.field_146543_v;
    }

    @Nullable
    public ExtendedList<?> func_213116_d() {
        return this.field_146545_u;
    }

    public void func_213110_a(@Nullable ExtendedList<?> extendedList) {
        this.children.remove(this.field_146550_h);
        this.children.remove(this.field_146551_i);
        this.children.remove(this.field_146547_s);
        if (extendedList != null) {
            this.children.add(0, extendedList);
            this.field_146545_u = extendedList;
        }
    }

    private int func_195224_b(int n) {
        return 115 + 40 * n;
    }

    private void func_146521_a(int n, int n2, Item item) {
        this.func_146527_c(n + 1, n2 + 1, 0, 0);
        GlStateManager.enableRescaleNormal();
        RenderHelper.func_74520_c();
        this.itemRenderer.func_175042_a(item.func_190903_i(), n + 2, n2 + 2);
        RenderHelper.func_74518_a();
        GlStateManager.disableRescaleNormal();
    }

    private void func_146527_c(int n, int n2, int n3, int n4) {
        GlStateManager.color4f(1.0f, 1.0f, 1.0f, 1.0f);
        this.minecraft.func_110434_K().func_110577_a(STATS_ICON_LOCATION);
        StatsScreen.blit(n, n2, this.blitOffset, n3, n4, 18, 18, 128, 128);
    }

    class MobStatsList
    extends ExtendedList<Entry> {
        public MobStatsList(Minecraft minecraft) {
            super(minecraft, StatsScreen.this.width, StatsScreen.this.height, 32, StatsScreen.this.height - 64, ((StatsScreen)StatsScreen.this).font.field_78288_b * 4);
            for (EntityType entityType : Registry.field_212629_r) {
                if (StatsScreen.this.field_146546_t.func_77444_a(Stats.field_199090_h.func_199076_b(entityType)) <= 0 && StatsScreen.this.field_146546_t.func_77444_a(Stats.field_199091_i.func_199076_b(entityType)) <= 0) continue;
                this.addEntry(new Entry(entityType));
            }
        }

        @Override
        protected void renderBackground() {
            StatsScreen.this.renderBackground();
        }

        class Entry
        extends ExtendedList.AbstractListEntry<Entry> {
            private final EntityType<?> field_214411_b;

            public Entry(EntityType<?> entityType) {
                this.field_214411_b = entityType;
            }

            @Override
            public void render(int n, int n2, int n3, int n4, int n5, int n6, int n7, boolean bl, float f) {
                String string = I18n.func_135052_a(Util.func_200697_a("entity", EntityType.func_200718_a(this.field_214411_b)), new Object[0]);
                int \u26032 = StatsScreen.this.field_146546_t.func_77444_a(Stats.field_199090_h.func_199076_b(this.field_214411_b));
                int \u26033 = StatsScreen.this.field_146546_t.func_77444_a(Stats.field_199091_i.func_199076_b(this.field_214411_b));
                MobStatsList.this.drawString(StatsScreen.this.font, string, n3 + 2, n2 + 1, 0xFFFFFF);
                MobStatsList.this.drawString(StatsScreen.this.font, this.func_214409_a(string, \u26032), n3 + 2 + 10, n2 + 1 + ((StatsScreen)StatsScreen.this).font.field_78288_b, \u26032 == 0 ? 0x606060 : 0x909090);
                MobStatsList.this.drawString(StatsScreen.this.font, this.func_214408_b(string, \u26033), n3 + 2 + 10, n2 + 1 + ((StatsScreen)StatsScreen.this).font.field_78288_b * 2, \u26033 == 0 ? 0x606060 : 0x909090);
            }

            private String func_214409_a(String string, int n) {
                String string2 = Stats.field_199090_h.func_199078_c();
                if (n == 0) {
                    return I18n.func_135052_a(string2 + ".none", string);
                }
                return I18n.func_135052_a(string2, n, string);
            }

            private String func_214408_b(String string, int n) {
                String string2 = Stats.field_199091_i.func_199078_c();
                if (n == 0) {
                    return I18n.func_135052_a(string2 + ".none", string);
                }
                return I18n.func_135052_a(string2, string, n);
            }
        }
    }

    class StatsList
    extends ExtendedList<Entry> {
        protected final List<StatType<Block>> field_195113_v;
        protected final List<StatType<Item>> field_195114_w;
        private final int[] field_195112_D;
        protected int field_195115_x;
        protected final List<Item> field_195116_y;
        protected final java.util.Comparator<Item> field_195117_z;
        @Nullable
        protected StatType<?> field_195110_A;
        protected int field_195111_B;

        public StatsList(Minecraft minecraft) {
            super(minecraft, StatsScreen.this.width, StatsScreen.this.height, 32, StatsScreen.this.height - 64, 20);
            this.field_195112_D = new int[]{3, 4, 1, 2, 5, 6};
            this.field_195115_x = -1;
            this.field_195117_z = new Comparator();
            this.field_195113_v = Lists.newArrayList();
            this.field_195113_v.add(Stats.field_188065_ae);
            this.field_195114_w = Lists.newArrayList((Object[])new StatType[]{Stats.field_199088_e, Stats.field_188066_af, Stats.field_75929_E, Stats.field_199089_f, Stats.field_188068_aj});
            this.setRenderHeader(true, 20);
            Set set = Sets.newIdentityHashSet();
            for (Item item : Registry.field_212630_s) {
                boolean bl = false;
                for (StatType<Item> statType : this.field_195114_w) {
                    if (!statType.func_199079_a(item) || StatsScreen.this.field_146546_t.func_77444_a(statType.func_199076_b(item)) <= 0) continue;
                    bl = true;
                }
                if (!bl) continue;
                set.add(item);
            }
            for (Block block : Registry.field_212618_g) {
                boolean bl = false;
                for (StatType<IItemProvider> statType : this.field_195113_v) {
                    if (!statType.func_199079_a(block) || StatsScreen.this.field_146546_t.func_77444_a(statType.func_199076_b(block)) <= 0) continue;
                    bl = true;
                }
                if (!bl) continue;
                set.add(block.func_199767_j());
            }
            set.remove(Items.field_190931_a);
            this.field_195116_y = Lists.newArrayList((Iterable)set);
            for (int i = 0; i < this.field_195116_y.size(); ++i) {
                this.addEntry(new Entry());
            }
        }

        @Override
        protected void renderHeader(int n, int n2, Tessellator tessellator) {
            int n3;
            if (!this.minecraft.field_71417_B.func_198030_b()) {
                this.field_195115_x = -1;
            }
            for (n3 = 0; n3 < this.field_195112_D.length; ++n3) {
                StatsScreen.this.func_146527_c(n + StatsScreen.this.func_195224_b(n3) - 18, n2 + 1, 0, this.field_195115_x == n3 ? 0 : 18);
            }
            if (this.field_195110_A != null) {
                n3 = StatsScreen.this.func_195224_b(this.func_195105_b(this.field_195110_A)) - 36;
                \u2603 = this.field_195111_B == 1 ? 2 : 1;
                StatsScreen.this.func_146527_c(n + n3, n2 + 1, 18 * \u2603, 0);
            }
            for (n3 = 0; n3 < this.field_195112_D.length; ++n3) {
                \u2603 = this.field_195115_x == n3 ? 1 : 0;
                StatsScreen.this.func_146527_c(n + StatsScreen.this.func_195224_b(n3) - 18 + \u2603, n2 + 1 + \u2603, 18 * this.field_195112_D[n3], 18);
            }
        }

        @Override
        public int getRowWidth() {
            return 375;
        }

        @Override
        protected int getScrollbarPosition() {
            return this.width / 2 + 140;
        }

        @Override
        protected void renderBackground() {
            StatsScreen.this.renderBackground();
        }

        @Override
        protected void clickedHeader(int n, int n2) {
            this.field_195115_x = -1;
            for (\u2603 = 0; \u2603 < this.field_195112_D.length; ++\u2603) {
                \u2603 = n - StatsScreen.this.func_195224_b(\u2603);
                if (\u2603 < -36 || \u2603 > 0) continue;
                this.field_195115_x = \u2603;
                break;
            }
            if (this.field_195115_x >= 0) {
                this.func_195107_a(this.func_195108_d(this.field_195115_x));
                this.minecraft.func_147118_V().func_147682_a(SimpleSound.func_184371_a(SoundEvents.field_187909_gi, 1.0f));
            }
        }

        private StatType<?> func_195108_d(int n) {
            return n < this.field_195113_v.size() ? this.field_195113_v.get(n) : this.field_195114_w.get(n - this.field_195113_v.size());
        }

        private int func_195105_b(StatType<?> statType) {
            int n = this.field_195113_v.indexOf(statType);
            if (n >= 0) {
                return n;
            }
            \u2603 = this.field_195114_w.indexOf(statType);
            if (\u2603 >= 0) {
                return \u2603 + this.field_195113_v.size();
            }
            return -1;
        }

        @Override
        protected void renderDecorations(int n, int n2) {
            if (n2 < this.y0 || n2 > this.y1) {
                return;
            }
            Entry entry = (Entry)this.getEntryAtPosition(n, n2);
            int \u26032 = (this.width - this.getRowWidth()) / 2;
            if (entry != null) {
                if (n < \u26032 + 40 || n > \u26032 + 40 + 20) {
                    return;
                }
                Item item = this.field_195116_y.get(this.children().indexOf(entry));
                this.func_200207_a(this.func_200208_a(item), n, n2);
            } else {
                TranslationTextComponent translationTextComponent = null;
                int \u26033 = n - \u26032;
                for (int i = 0; i < this.field_195112_D.length; ++i) {
                    \u2603 = StatsScreen.this.func_195224_b(i);
                    if (\u26033 < \u2603 - 18 || \u26033 > \u2603) continue;
                    translationTextComponent = new TranslationTextComponent(this.func_195108_d(i).func_199078_c(), new Object[0]);
                    break;
                }
                this.func_200207_a(translationTextComponent, n, n2);
            }
        }

        protected void func_200207_a(@Nullable ITextComponent iTextComponent, int n, int n2) {
            if (iTextComponent == null) {
                return;
            }
            String string = iTextComponent.func_150254_d();
            int \u26032 = n + 12;
            int \u26033 = n2 - 12;
            int \u26034 = StatsScreen.this.font.func_78256_a(string);
            this.fillGradient(\u26032 - 3, \u26033 - 3, \u26032 + \u26034 + 3, \u26033 + 8 + 3, -1073741824, -1073741824);
            StatsScreen.this.font.func_175063_a(string, \u26032, \u26033, -1);
        }

        protected ITextComponent func_200208_a(Item item) {
            return item.func_200296_o();
        }

        protected void func_195107_a(StatType<?> statType) {
            if (statType != this.field_195110_A) {
                this.field_195110_A = statType;
                this.field_195111_B = -1;
            } else if (this.field_195111_B == -1) {
                this.field_195111_B = 1;
            } else {
                this.field_195110_A = null;
                this.field_195111_B = 0;
            }
            this.field_195116_y.sort(this.field_195117_z);
        }

        class Entry
        extends ExtendedList.AbstractListEntry<Entry> {
            private Entry() {
            }

            @Override
            public void render(int n, int n2, int n3, int n4, int n5, int n6, int n7, boolean bl, float f) {
                int n8;
                Item item = ((StatsScreen)StatsScreen.this).field_146551_i.field_195116_y.get(n);
                StatsScreen.this.func_146521_a(n3 + 40, n2, item);
                for (n8 = 0; n8 < ((StatsScreen)StatsScreen.this).field_146551_i.field_195113_v.size(); ++n8) {
                    Stat<Block> stat = item instanceof BlockItem ? ((StatsScreen)StatsScreen.this).field_146551_i.field_195113_v.get(n8).func_199076_b(((BlockItem)item).func_179223_d()) : null;
                    this.func_214406_a(stat, n3 + StatsScreen.this.func_195224_b(n8), n2, n % 2 == 0);
                }
                for (n8 = 0; n8 < ((StatsScreen)StatsScreen.this).field_146551_i.field_195114_w.size(); ++n8) {
                    this.func_214406_a(((StatsScreen)StatsScreen.this).field_146551_i.field_195114_w.get(n8).func_199076_b(item), n3 + StatsScreen.this.func_195224_b(n8 + ((StatsScreen)StatsScreen.this).field_146551_i.field_195113_v.size()), n2, n % 2 == 0);
                }
            }

            protected void func_214406_a(@Nullable Stat<?> stat, int n, int n2, boolean bl) {
                String string = stat == null ? "-" : stat.func_75968_a(StatsScreen.this.field_146546_t.func_77444_a(stat));
                StatsList.this.drawString(StatsScreen.this.font, string, n - StatsScreen.this.font.func_78256_a(string), n2 + 5, bl ? 0xFFFFFF : 0x909090);
            }
        }

        class Comparator
        implements java.util.Comparator<Item> {
            private Comparator() {
            }

            @Override
            public int compare(Item item, Item item2) {
                int \u26033;
                int \u26032;
                if (StatsList.this.field_195110_A == null) {
                    \u26032 = 0;
                    \u26033 = 0;
                } else if (StatsList.this.field_195113_v.contains(StatsList.this.field_195110_A)) {
                    StatType<?> statType = StatsList.this.field_195110_A;
                    \u26032 = item instanceof BlockItem ? StatsScreen.this.field_146546_t.func_199060_a(statType, ((BlockItem)item).func_179223_d()) : -1;
                    \u26033 = item2 instanceof BlockItem ? StatsScreen.this.field_146546_t.func_199060_a(statType, ((BlockItem)item2).func_179223_d()) : -1;
                } else {
                    \u2603 = StatsList.this.field_195110_A;
                    \u26032 = StatsScreen.this.field_146546_t.func_199060_a(\u2603, item);
                    \u26033 = StatsScreen.this.field_146546_t.func_199060_a(\u2603, item2);
                }
                if (\u26032 == \u26033) {
                    return StatsList.this.field_195111_B * Integer.compare(Item.func_150891_b(item), Item.func_150891_b(item2));
                }
                return StatsList.this.field_195111_B * Integer.compare(\u26032, \u26033);
            }

            @Override
            public /* synthetic */ int compare(Object object, Object object2) {
                return this.compare((Item)object, (Item)object2);
            }
        }
    }

    class CustomStatsList
    extends ExtendedList<Entry> {
        public CustomStatsList(Minecraft minecraft) {
            super(minecraft, StatsScreen.this.width, StatsScreen.this.height, 32, StatsScreen.this.height - 64, 10);
            for (Stat<ResourceLocation> stat : Stats.field_199092_j) {
                this.addEntry(new Entry(stat));
            }
        }

        @Override
        protected void renderBackground() {
            StatsScreen.this.renderBackground();
        }

        class Entry
        extends ExtendedList.AbstractListEntry<Entry> {
            private final Stat<ResourceLocation> field_214405_b;

            private Entry(Stat<ResourceLocation> stat) {
                this.field_214405_b = stat;
            }

            @Override
            public void render(int n, int n2, int n3, int n4, int n5, int n6, int n7, boolean bl, float f) {
                ITextComponent iTextComponent = new TranslationTextComponent("stat." + this.field_214405_b.func_197920_b().toString().replace(':', '.'), new Object[0]).func_211708_a(TextFormatting.GRAY);
                CustomStatsList.this.drawString(StatsScreen.this.font, iTextComponent.getString(), n3 + 2, n2 + 1, n % 2 == 0 ? 0xFFFFFF : 0x909090);
                String \u26032 = this.field_214405_b.func_75968_a(StatsScreen.this.field_146546_t.func_77444_a(this.field_214405_b));
                CustomStatsList.this.drawString(StatsScreen.this.font, \u26032, n3 + 2 + 213 - StatsScreen.this.font.func_78256_a(\u26032), n2 + 1, n % 2 == 0 ? 0xFFFFFF : 0x909090);
            }
        }
    }
}

