/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui.screen;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.gson.JsonSyntaxException;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FocusableGui;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.IGuiEventListener;
import net.minecraft.client.gui.IRenderable;
import net.minecraft.client.gui.screen.ConfirmOpenLinkScreen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.ItemRenderer;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.client.util.InputMappings;
import net.minecraft.crash.CrashReport;
import net.minecraft.crash.CrashReportCategory;
import net.minecraft.crash.ReportedException;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.JsonToNBT;
import net.minecraft.util.Util;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.event.ClickEvent;
import net.minecraft.util.text.event.HoverEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class Screen
extends FocusableGui
implements IRenderable {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final Set<String> ALLOWED_PROTOCOLS = Sets.newHashSet((Object[])new String[]{"http", "https"});
    protected final ITextComponent title;
    protected final List<IGuiEventListener> children = Lists.newArrayList();
    @Nullable
    protected Minecraft minecraft;
    protected ItemRenderer itemRenderer;
    public int width;
    public int height;
    protected final List<Widget> buttons = Lists.newArrayList();
    public boolean passEvents;
    protected FontRenderer font;
    private URI clickedLink;

    protected Screen(ITextComponent iTextComponent) {
        this.title = iTextComponent;
    }

    public ITextComponent getTitle() {
        return this.title;
    }

    public String getNarrationMessage() {
        return this.getTitle().getString();
    }

    @Override
    public void render(int n, int n2, float f) {
        for (int i = 0; i < this.buttons.size(); ++i) {
            this.buttons.get(i).render(n, n2, f);
        }
    }

    @Override
    public boolean keyPressed(int n, int n2, int n3) {
        if (n == 256 && this.shouldCloseOnEsc()) {
            this.onClose();
            return true;
        }
        if (n == 258) {
            boolean bl = \u2603 = !Screen.hasShiftDown();
            if (!this.changeFocus(\u2603)) {
                this.changeFocus(\u2603);
            }
            return true;
        }
        return super.keyPressed(n, n2, n3);
    }

    public boolean shouldCloseOnEsc() {
        return true;
    }

    public void onClose() {
        this.minecraft.func_147108_a(null);
    }

    protected <T extends Widget> T addButton(T t) {
        this.buttons.add(t);
        this.children.add(t);
        return t;
    }

    protected void renderTooltip(ItemStack itemStack, int n, int n2) {
        this.renderTooltip(this.getTooltipFromItem(itemStack), n, n2);
    }

    public List<String> getTooltipFromItem(ItemStack itemStack) {
        List<ITextComponent> list = itemStack.func_82840_a(this.minecraft.field_71439_g, this.minecraft.field_71474_y.field_82882_x ? ITooltipFlag.TooltipFlags.ADVANCED : ITooltipFlag.TooltipFlags.NORMAL);
        ArrayList \u26032 = Lists.newArrayList();
        for (ITextComponent iTextComponent : list) {
            \u26032.add(iTextComponent.func_150254_d());
        }
        return \u26032;
    }

    public void renderTooltip(String string, int n, int n2) {
        this.renderTooltip(Arrays.asList(string), n, n2);
    }

    public void renderTooltip(List<String> list, int n3, int n2) {
        int n3;
        if (list.isEmpty()) {
            return;
        }
        GlStateManager.disableRescaleNormal();
        RenderHelper.func_74518_a();
        GlStateManager.disableLighting();
        GlStateManager.disableDepthTest();
        \u2603 = 0;
        for (String string : list) {
            int n4 = this.font.func_78256_a(string);
            if (n4 <= \u2603) continue;
            \u2603 = n4;
        }
        \u2603 = n3 + 12;
        \u2603 = n2 - 12;
        n4 = \u2603;
        \u2603 = 8;
        if (list.size() > 1) {
            \u2603 += 2 + (list.size() - 1) * 10;
        }
        if (\u2603 + \u2603 > this.width) {
            \u2603 -= 28 + \u2603;
        }
        if (\u2603 + \u2603 + 6 > this.height) {
            \u2603 = this.height - \u2603 - 6;
        }
        this.blitOffset = 300;
        this.itemRenderer.field_77023_b = 300.0f;
        \u2603 = -267386864;
        this.fillGradient(\u2603 - 3, \u2603 - 4, \u2603 + n4 + 3, \u2603 - 3, -267386864, -267386864);
        this.fillGradient(\u2603 - 3, \u2603 + \u2603 + 3, \u2603 + n4 + 3, \u2603 + \u2603 + 4, -267386864, -267386864);
        this.fillGradient(\u2603 - 3, \u2603 - 3, \u2603 + n4 + 3, \u2603 + \u2603 + 3, -267386864, -267386864);
        this.fillGradient(\u2603 - 4, \u2603 - 3, \u2603 - 3, \u2603 + \u2603 + 3, -267386864, -267386864);
        this.fillGradient(\u2603 + n4 + 3, \u2603 - 3, \u2603 + n4 + 4, \u2603 + \u2603 + 3, -267386864, -267386864);
        \u2603 = 0x505000FF;
        \u2603 = 1344798847;
        this.fillGradient(\u2603 - 3, \u2603 - 3 + 1, \u2603 - 3 + 1, \u2603 + \u2603 + 3 - 1, 0x505000FF, 1344798847);
        this.fillGradient(\u2603 + n4 + 2, \u2603 - 3 + 1, \u2603 + n4 + 3, \u2603 + \u2603 + 3 - 1, 0x505000FF, 1344798847);
        this.fillGradient(\u2603 - 3, \u2603 - 3, \u2603 + n4 + 3, \u2603 - 3 + 1, 0x505000FF, 0x505000FF);
        this.fillGradient(\u2603 - 3, \u2603 + \u2603 + 2, \u2603 + n4 + 3, \u2603 + \u2603 + 3, 1344798847, 1344798847);
        for (\u2603 = 0; \u2603 < list.size(); ++\u2603) {
            String string = list.get(\u2603);
            this.font.func_175063_a(string, \u2603, \u2603, -1);
            if (\u2603 == 0) {
                \u2603 += 2;
            }
            \u2603 += 10;
        }
        this.blitOffset = 0;
        this.itemRenderer.field_77023_b = 0.0f;
        GlStateManager.enableLighting();
        GlStateManager.enableDepthTest();
        RenderHelper.func_74519_b();
        GlStateManager.enableRescaleNormal();
    }

    protected void renderComponentHoverEffect(ITextComponent iTextComponent, int n, int n2) {
        if (iTextComponent == null || iTextComponent.func_150256_b().func_150210_i() == null) {
            return;
        }
        HoverEvent hoverEvent = iTextComponent.func_150256_b().func_150210_i();
        if (hoverEvent.func_150701_a() == HoverEvent.Action.SHOW_ITEM) {
            ItemStack itemStack = ItemStack.field_190927_a;
            try {
                CompoundNBT compoundNBT = JsonToNBT.func_180713_a(hoverEvent.func_150702_b().getString());
                if (compoundNBT instanceof CompoundNBT) {
                    itemStack = ItemStack.func_199557_a(compoundNBT);
                }
            }
            catch (CommandSyntaxException compoundNBT) {
                // empty catch block
            }
            if (itemStack.func_190926_b()) {
                this.renderTooltip((Object)((Object)TextFormatting.RED) + "Invalid Item!", n, n2);
            } else {
                this.renderTooltip(itemStack, n, n2);
            }
        } else if (hoverEvent.func_150701_a() == HoverEvent.Action.SHOW_ENTITY) {
            if (this.minecraft.field_71474_y.field_82882_x) {
                try {
                    CompoundNBT compoundNBT = JsonToNBT.func_180713_a(hoverEvent.func_150702_b().getString());
                    ArrayList \u26032 = Lists.newArrayList();
                    ITextComponent \u26033 = ITextComponent.Serializer.func_150699_a(compoundNBT.func_74779_i("name"));
                    if (\u26033 != null) {
                        \u26032.add(\u26033.func_150254_d());
                    }
                    if (compoundNBT.func_150297_b("type", 8)) {
                        String string = compoundNBT.func_74779_i("type");
                        \u26032.add("Type: " + string);
                    }
                    \u26032.add(compoundNBT.func_74779_i("id"));
                    this.renderTooltip(\u26032, n, n2);
                }
                catch (JsonSyntaxException | CommandSyntaxException throwable) {
                    this.renderTooltip((Object)((Object)TextFormatting.RED) + "Invalid Entity!", n, n2);
                }
            }
        } else if (hoverEvent.func_150701_a() == HoverEvent.Action.SHOW_TEXT) {
            this.renderTooltip(this.minecraft.field_71466_p.func_78271_c(hoverEvent.func_150702_b().func_150254_d(), Math.max(this.width / 2, 200)), n, n2);
        }
        GlStateManager.disableLighting();
    }

    protected void insertText(String string, boolean bl) {
    }

    public boolean handleComponentClicked(ITextComponent iTextComponent) {
        if (iTextComponent == null) {
            return false;
        }
        ClickEvent clickEvent = iTextComponent.func_150256_b().func_150235_h();
        if (Screen.hasShiftDown()) {
            if (iTextComponent.func_150256_b().func_179986_j() != null) {
                this.insertText(iTextComponent.func_150256_b().func_179986_j(), false);
            }
        } else if (clickEvent != null) {
            block19: {
                if (clickEvent.func_150669_a() == ClickEvent.Action.OPEN_URL) {
                    if (!this.minecraft.field_71474_y.field_74359_p) {
                        return false;
                    }
                    try {
                        URI uRI = new URI(clickEvent.func_150668_b());
                        String \u26032 = uRI.getScheme();
                        if (\u26032 == null) {
                            throw new URISyntaxException(clickEvent.func_150668_b(), "Missing protocol");
                        }
                        if (!ALLOWED_PROTOCOLS.contains(\u26032.toLowerCase(Locale.ROOT))) {
                            throw new URISyntaxException(clickEvent.func_150668_b(), "Unsupported protocol: " + \u26032.toLowerCase(Locale.ROOT));
                        }
                        if (this.minecraft.field_71474_y.field_74358_q) {
                            this.clickedLink = uRI;
                            this.minecraft.func_147108_a(new ConfirmOpenLinkScreen(this::confirmLink, clickEvent.func_150668_b(), false));
                            break block19;
                        }
                        this.openLink(uRI);
                    }
                    catch (URISyntaxException uRISyntaxException) {
                        LOGGER.error("Can't open url for {}", (Object)clickEvent, (Object)uRISyntaxException);
                    }
                } else if (clickEvent.func_150669_a() == ClickEvent.Action.OPEN_FILE) {
                    URI uRI = new File(clickEvent.func_150668_b()).toURI();
                    this.openLink(uRI);
                } else if (clickEvent.func_150669_a() == ClickEvent.Action.SUGGEST_COMMAND) {
                    this.insertText(clickEvent.func_150668_b(), true);
                } else if (clickEvent.func_150669_a() == ClickEvent.Action.RUN_COMMAND) {
                    this.sendMessage(clickEvent.func_150668_b(), false);
                } else {
                    LOGGER.error("Don't know how to handle {}", (Object)clickEvent);
                }
            }
            return true;
        }
        return false;
    }

    public void sendMessage(String string) {
        this.sendMessage(string, true);
    }

    public void sendMessage(String string, boolean bl) {
        if (bl) {
            this.minecraft.field_71456_v.func_146158_b().func_146239_a(string);
        }
        this.minecraft.field_71439_g.func_71165_d(string);
    }

    public void init(Minecraft minecraft, int n, int n2) {
        this.minecraft = minecraft;
        this.itemRenderer = minecraft.func_175599_af();
        this.font = minecraft.field_71466_p;
        this.width = n;
        this.height = n2;
        this.buttons.clear();
        this.children.clear();
        this.setFocused(null);
        this.init();
    }

    public void setSize(int n, int n2) {
        this.width = n;
        this.height = n2;
    }

    @Override
    public List<? extends IGuiEventListener> children() {
        return this.children;
    }

    protected void init() {
    }

    public void tick() {
    }

    public void removed() {
    }

    public void renderBackground() {
        this.renderBackground(0);
    }

    public void renderBackground(int n) {
        if (this.minecraft.field_71441_e != null) {
            this.fillGradient(0, 0, this.width, this.height, -1072689136, -804253680);
        } else {
            this.renderDirtBackground(n);
        }
    }

    public void renderDirtBackground(int n) {
        GlStateManager.disableLighting();
        GlStateManager.disableFog();
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder \u26032 = tessellator.func_178180_c();
        this.minecraft.func_110434_K().func_110577_a(BACKGROUND_LOCATION);
        GlStateManager.color4f(1.0f, 1.0f, 1.0f, 1.0f);
        float \u26033 = 32.0f;
        \u26032.func_181668_a(7, DefaultVertexFormats.field_181709_i);
        \u26032.func_181662_b(0.0, this.height, 0.0).func_187315_a(0.0, (float)this.height / 32.0f + (float)n).func_181669_b(64, 64, 64, 255).func_181675_d();
        \u26032.func_181662_b(this.width, this.height, 0.0).func_187315_a((float)this.width / 32.0f, (float)this.height / 32.0f + (float)n).func_181669_b(64, 64, 64, 255).func_181675_d();
        \u26032.func_181662_b(this.width, 0.0, 0.0).func_187315_a((float)this.width / 32.0f, n).func_181669_b(64, 64, 64, 255).func_181675_d();
        \u26032.func_181662_b(0.0, 0.0, 0.0).func_187315_a(0.0, n).func_181669_b(64, 64, 64, 255).func_181675_d();
        tessellator.func_78381_a();
    }

    public boolean isPauseScreen() {
        return true;
    }

    private void confirmLink(boolean bl) {
        if (bl) {
            this.openLink(this.clickedLink);
        }
        this.clickedLink = null;
        this.minecraft.func_147108_a(this);
    }

    private void openLink(URI uRI) {
        Util.func_110647_a().func_195642_a(uRI);
    }

    public static boolean hasControlDown() {
        if (Minecraft.field_142025_a) {
            return InputMappings.func_216506_a(Minecraft.func_71410_x().field_195558_d.func_198092_i(), 343) || InputMappings.func_216506_a(Minecraft.func_71410_x().field_195558_d.func_198092_i(), 347);
        }
        return InputMappings.func_216506_a(Minecraft.func_71410_x().field_195558_d.func_198092_i(), 341) || InputMappings.func_216506_a(Minecraft.func_71410_x().field_195558_d.func_198092_i(), 345);
    }

    public static boolean hasShiftDown() {
        return InputMappings.func_216506_a(Minecraft.func_71410_x().field_195558_d.func_198092_i(), 340) || InputMappings.func_216506_a(Minecraft.func_71410_x().field_195558_d.func_198092_i(), 344);
    }

    public static boolean hasAltDown() {
        return InputMappings.func_216506_a(Minecraft.func_71410_x().field_195558_d.func_198092_i(), 342) || InputMappings.func_216506_a(Minecraft.func_71410_x().field_195558_d.func_198092_i(), 346);
    }

    public static boolean isCut(int n) {
        return n == 88 && Screen.hasControlDown() && !Screen.hasShiftDown() && !Screen.hasAltDown();
    }

    public static boolean isPaste(int n) {
        return n == 86 && Screen.hasControlDown() && !Screen.hasShiftDown() && !Screen.hasAltDown();
    }

    public static boolean isCopy(int n) {
        return n == 67 && Screen.hasControlDown() && !Screen.hasShiftDown() && !Screen.hasAltDown();
    }

    public static boolean isSelectAll(int n) {
        return n == 65 && Screen.hasControlDown() && !Screen.hasShiftDown() && !Screen.hasAltDown();
    }

    public void resize(Minecraft minecraft, int n, int n2) {
        this.init(minecraft, n, n2);
    }

    public static void wrapScreenError(Runnable runnable, String string, String string2) {
        try {
            runnable.run();
        }
        catch (Throwable throwable) {
            CrashReport crashReport = CrashReport.func_85055_a(throwable, string);
            CrashReportCategory \u26032 = crashReport.func_85058_a("Affected screen");
            \u26032.func_189529_a("Screen name", () -> string2);
            throw new ReportedException(crashReport);
        }
    }

    protected boolean isValidCharacterForName(String string, char c, int n) {
        \u2603 = string.indexOf(58);
        \u2603 = string.indexOf(47);
        if (c == ':') {
            return (\u2603 == -1 || n <= \u2603) && \u2603 == -1;
        }
        if (c == '/') {
            return n > \u2603;
        }
        return c == '_' || c == '-' || c >= 'a' && c <= 'z' || c >= '0' && c <= '9' || c == '.';
    }

    @Override
    public boolean isMouseOver(double d, double d2) {
        return true;
    }
}

