/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui.screen;

import it.unimi.dsi.fastutil.booleans.BooleanConsumer;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.ConfirmBackupScreen;
import net.minecraft.client.gui.screen.OptimizeWorldScreen;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.toasts.SystemToast;
import net.minecraft.client.gui.toasts.ToastGui;
import net.minecraft.client.gui.widget.TextFieldWidget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.Util;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.storage.SaveFormat;
import net.minecraft.world.storage.WorldInfo;
import org.apache.commons.io.FileUtils;

public class EditWorldScreen
extends Screen {
    private Button field_195327_a;
    private final BooleanConsumer field_214311_b;
    private TextFieldWidget field_184859_f;
    private final String field_184860_g;

    public EditWorldScreen(BooleanConsumer booleanConsumer, String string) {
        super(new TranslationTextComponent("selectWorld.edit.title", new Object[0]));
        this.field_214311_b = booleanConsumer;
        this.field_184860_g = string;
    }

    @Override
    public void tick() {
        this.field_184859_f.func_146178_a();
    }

    @Override
    protected void init() {
        this.minecraft.field_195559_v.func_197967_a(true);
        Button button2 = this.addButton(new Button(this.width / 2 - 100, this.height / 4 + 24 + 5, 200, 20, I18n.func_135052_a("selectWorld.edit.resetIcon", new Object[0]), button -> {
            SaveFormat saveFormat = this.minecraft.func_71359_d();
            FileUtils.deleteQuietly((File)saveFormat.func_186352_b(this.field_184860_g, "icon.png"));
            button.active = false;
        }));
        this.addButton(new Button(this.width / 2 - 100, this.height / 4 + 48 + 5, 200, 20, I18n.func_135052_a("selectWorld.edit.openFolder", new Object[0]), button -> {
            SaveFormat saveFormat = this.minecraft.func_71359_d();
            Util.func_110647_a().func_195641_a(saveFormat.func_186352_b(this.field_184860_g, "icon.png").getParentFile());
        }));
        this.addButton(new Button(this.width / 2 - 100, this.height / 4 + 72 + 5, 200, 20, I18n.func_135052_a("selectWorld.edit.backup", new Object[0]), button -> {
            SaveFormat saveFormat = this.minecraft.func_71359_d();
            EditWorldScreen.func_200212_a(saveFormat, this.field_184860_g);
            this.field_214311_b.accept(false);
        }));
        this.addButton(new Button(this.width / 2 - 100, this.height / 4 + 96 + 5, 200, 20, I18n.func_135052_a("selectWorld.edit.backupFolder", new Object[0]), button -> {
            SaveFormat saveFormat = this.minecraft.func_71359_d();
            Path \u26032 = saveFormat.func_197712_e();
            try {
                Files.createDirectories(Files.exists(\u26032, new LinkOption[0]) ? \u26032.toRealPath(new LinkOption[0]) : \u26032, new FileAttribute[0]);
            }
            catch (IOException \u26033) {
                throw new RuntimeException(\u26033);
            }
            Util.func_110647_a().func_195641_a(\u26032.toFile());
        }));
        this.addButton(new Button(this.width / 2 - 100, this.height / 4 + 120 + 5, 200, 20, I18n.func_135052_a("selectWorld.edit.optimize", new Object[0]), button -> this.minecraft.func_147108_a(new ConfirmBackupScreen(this, (bl, bl2) -> {
            if (bl) {
                EditWorldScreen.func_200212_a(this.minecraft.func_71359_d(), this.field_184860_g);
            }
            this.minecraft.func_147108_a(new OptimizeWorldScreen(this.field_214311_b, this.field_184860_g, this.minecraft.func_71359_d(), bl2));
        }, new TranslationTextComponent("optimizeWorld.confirm.title", new Object[0]), new TranslationTextComponent("optimizeWorld.confirm.description", new Object[0]), true))));
        this.field_195327_a = this.addButton(new Button(this.width / 2 - 100, this.height / 4 + 144 + 5, 98, 20, I18n.func_135052_a("selectWorld.edit.save", new Object[0]), button -> this.func_195317_h()));
        this.addButton(new Button(this.width / 2 + 2, this.height / 4 + 144 + 5, 98, 20, I18n.func_135052_a("gui.cancel", new Object[0]), button -> this.field_214311_b.accept(false)));
        button2.active = this.minecraft.func_71359_d().func_186352_b(this.field_184860_g, "icon.png").isFile();
        SaveFormat \u26032 = this.minecraft.func_71359_d();
        WorldInfo \u26033 = \u26032.func_75803_c(this.field_184860_g);
        String \u26034 = \u26033 == null ? "" : \u26033.func_76065_j();
        this.field_184859_f = new TextFieldWidget(this.font, this.width / 2 - 100, 53, 200, 20, I18n.func_135052_a("selectWorld.enterName", new Object[0]));
        this.field_184859_f.func_146180_a(\u26034);
        this.field_184859_f.func_212954_a(string -> {
            this.field_195327_a.active = !string.trim().isEmpty();
        });
        this.children.add(this.field_184859_f);
        this.func_212928_a(this.field_184859_f);
    }

    @Override
    public void resize(Minecraft minecraft, int n, int n2) {
        String string = this.field_184859_f.func_146179_b();
        this.init(minecraft, n, n2);
        this.field_184859_f.func_146180_a(string);
    }

    @Override
    public void removed() {
        this.minecraft.field_195559_v.func_197967_a(false);
    }

    private void func_195317_h() {
        SaveFormat saveFormat = this.minecraft.func_71359_d();
        saveFormat.func_75806_a(this.field_184860_g, this.field_184859_f.func_146179_b().trim());
        this.field_214311_b.accept(true);
    }

    public static void func_200212_a(SaveFormat saveFormat, String string) {
        TextComponent \u26035;
        ToastGui toastGui = Minecraft.func_71410_x().func_193033_an();
        long \u26032 = 0L;
        IOException \u26033 = null;
        try {
            \u26032 = saveFormat.func_197713_h(string);
        }
        catch (IOException \u26034) {
            \u26033 = \u26034;
        }
        if (\u26033 != null) {
            TranslationTextComponent translationTextComponent = new TranslationTextComponent("selectWorld.edit.backupFailed", new Object[0]);
            \u26035 = new StringTextComponent(\u26033.getMessage());
        } else {
            translationTextComponent = new TranslationTextComponent("selectWorld.edit.backupCreated", string);
            \u26035 = new TranslationTextComponent("selectWorld.edit.backupSize", MathHelper.func_76143_f((double)\u26032 / 1048576.0));
        }
        toastGui.func_192988_a(new SystemToast(SystemToast.Type.WORLD_BACKUP, translationTextComponent, \u26035));
    }

    @Override
    public void render(int n, int n2, float f) {
        this.renderBackground();
        this.drawCenteredString(this.font, this.title.func_150254_d(), this.width / 2, 20, 0xFFFFFF);
        this.drawString(this.font, I18n.func_135052_a("selectWorld.enterName", new Object[0]), this.width / 2 - 100, 40, 0xA0A0A0);
        this.field_184859_f.render(n, n2, f);
        super.render(n, n2, f);
    }
}

