/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui.overlay;

import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.mojang.blaze3d.platform.GLX;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.datafixers.DataFixUtils;
import it.unimi.dsi.fastutil.longs.LongSets;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.client.ClientBrandRetriever;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.entity.Entity;
import net.minecraft.fluid.IFluidState;
import net.minecraft.network.NetworkManager;
import net.minecraft.server.integrated.IntegratedServer;
import net.minecraft.state.IProperty;
import net.minecraft.util.Direction;
import net.minecraft.util.FrameTimer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SharedConstants;
import net.minecraft.util.Util;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3i;
import net.minecraft.util.registry.Registry;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.LightType;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.ChunkStatus;
import net.minecraft.world.dimension.DimensionType;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.lighting.WorldLightManager;
import net.minecraft.world.server.ServerWorld;

public class DebugOverlayGui
extends AbstractGui {
    private static final Map<Heightmap.Type, String> field_212923_a = Util.func_200696_a(new EnumMap(Heightmap.Type.class), enumMap -> {
        enumMap.put(Heightmap.Type.WORLD_SURFACE_WG, "SW");
        enumMap.put(Heightmap.Type.WORLD_SURFACE, "S");
        enumMap.put(Heightmap.Type.OCEAN_FLOOR_WG, "OW");
        enumMap.put(Heightmap.Type.OCEAN_FLOOR, "O");
        enumMap.put(Heightmap.Type.MOTION_BLOCKING, "M");
        enumMap.put(Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, "ML");
    });
    private final Minecraft field_175242_a;
    private final FontRenderer field_175241_f;
    private RayTraceResult field_211537_g;
    private RayTraceResult field_211538_h;
    @Nullable
    private ChunkPos field_212924_f;
    @Nullable
    private Chunk field_212925_g;
    @Nullable
    private CompletableFuture<Chunk> field_212926_h;

    public DebugOverlayGui(Minecraft minecraft) {
        this.field_175242_a = minecraft;
        this.field_175241_f = minecraft.field_71466_p;
    }

    public void func_212921_a() {
        this.field_212926_h = null;
        this.field_212925_g = null;
    }

    public void func_194818_a() {
        this.field_175242_a.func_213239_aq().func_76320_a("debug");
        GlStateManager.pushMatrix();
        Entity entity = this.field_175242_a.func_175606_aa();
        this.field_211537_g = entity.func_213324_a(20.0, 0.0f, false);
        this.field_211538_h = entity.func_213324_a(20.0, 0.0f, true);
        this.func_180798_a();
        this.func_194819_c();
        GlStateManager.popMatrix();
        if (this.field_175242_a.field_71474_y.field_181657_aC) {
            int n = this.field_175242_a.field_195558_d.func_198107_o();
            this.func_212920_a(this.field_175242_a.func_181539_aj(), 0, n / 2, true);
            IntegratedServer \u26032 = this.field_175242_a.func_71401_C();
            if (\u26032 != null) {
                this.func_212920_a(\u26032.func_213210_aR(), n - Math.min(n / 2, 240), n / 2, false);
            }
        }
        this.field_175242_a.func_213239_aq().func_76319_b();
    }

    protected void func_180798_a() {
        List<String> list = this.func_209011_c();
        list.add("");
        boolean \u26032 = this.field_175242_a.func_71401_C() != null;
        list.add("Debug: Pie [shift]: " + (this.field_175242_a.field_71474_y.field_74329_Q ? "visible" : "hidden") + (\u26032 ? " FPS + TPS" : " FPS") + " [alt]: " + (this.field_175242_a.field_71474_y.field_181657_aC ? "visible" : "hidden"));
        list.add("For help: press F3 + Q");
        for (int i = 0; i < list.size(); ++i) {
            String string = list.get(i);
            if (Strings.isNullOrEmpty((String)string)) continue;
            int \u26033 = this.field_175241_f.field_78288_b;
            int \u26034 = this.field_175241_f.func_78256_a(string);
            int \u26035 = 2;
            int \u26036 = 2 + \u26033 * i;
            DebugOverlayGui.fill(1, \u26036 - 1, 2 + \u26034 + 1, \u26036 + \u26033 - 1, -1873784752);
            this.field_175241_f.func_211126_b(string, 2.0f, \u26036, 0xE0E0E0);
        }
    }

    protected void func_194819_c() {
        List<String> list = this.func_175238_c();
        for (int i = 0; i < list.size(); ++i) {
            String string = list.get(i);
            if (Strings.isNullOrEmpty((String)string)) continue;
            int \u26032 = this.field_175241_f.field_78288_b;
            int \u26033 = this.field_175241_f.func_78256_a(string);
            int \u26034 = this.field_175242_a.field_195558_d.func_198107_o() - 2 - \u26033;
            int \u26035 = 2 + \u26032 * i;
            DebugOverlayGui.fill(\u26034 - 1, \u26035 - 1, \u26034 + \u26033 + 1, \u26035 + \u26032 - 1, -1873784752);
            this.field_175241_f.func_211126_b(string, \u26034, \u26035, 0xE0E0E0);
        }
    }

    protected List<String> func_209011_c() {
        Object object;
        IntegratedServer integratedServer = this.field_175242_a.func_71401_C();
        NetworkManager \u26032 = this.field_175242_a.func_147114_u().func_147298_b();
        float \u26033 = \u26032.func_211390_n();
        float \u26034 = \u26032.func_211393_m();
        String \u26035 = integratedServer != null ? String.format("Integrated server @ %.0f ms ticks, %.0f tx, %.0f rx", Float.valueOf(integratedServer.func_211149_aT()), Float.valueOf(\u26033), Float.valueOf(\u26034)) : String.format("\"%s\" server, %.0f tx, %.0f rx", this.field_175242_a.field_71439_g.func_142021_k(), Float.valueOf(\u26033), Float.valueOf(\u26034));
        BlockPos \u26036 = new BlockPos(this.field_175242_a.func_175606_aa().field_70165_t, this.field_175242_a.func_175606_aa().func_174813_aQ().field_72338_b, this.field_175242_a.func_175606_aa().field_70161_v);
        if (this.field_175242_a.func_189648_am()) {
            return Lists.newArrayList((Object[])new String[]{"Minecraft " + SharedConstants.func_215069_a().getName() + " (" + this.field_175242_a.func_175600_c() + "/" + ClientBrandRetriever.getClientModName() + ")", this.field_175242_a.field_71426_K, \u26035, this.field_175242_a.field_71438_f.func_72735_c(), this.field_175242_a.field_71438_f.func_72723_d(), "P: " + this.field_175242_a.field_71452_i.func_78869_b() + ". T: " + this.field_175242_a.field_71441_e.func_217425_f(), this.field_175242_a.field_71441_e.func_72827_u(), "", String.format("Chunk-relative: %d %d %d", \u26036.func_177958_n() & 0xF, \u26036.func_177956_o() & 0xF, \u26036.func_177952_p() & 0xF)});
        }
        Entity \u26037 = this.field_175242_a.func_175606_aa();
        Direction \u26038 = \u26037.func_174811_aO();
        switch (\u26038) {
            case NORTH: {
                String string = "Towards negative Z";
                break;
            }
            case SOUTH: {
                String string = "Towards positive Z";
                break;
            }
            case WEST: {
                String string = "Towards negative X";
                break;
            }
            case EAST: {
                String string = "Towards positive X";
                break;
            }
            default: {
                String string = "Invalid";
            }
        }
        ChunkPos chunkPos = new ChunkPos(\u26036);
        if (!Objects.equals(this.field_212924_f, chunkPos)) {
            this.field_212924_f = chunkPos;
            this.func_212921_a();
        }
        LongSets.EmptySet \u26039 = (\u2603 = this.func_212922_g()) instanceof ServerWorld ? ((ServerWorld)\u2603).func_217469_z() : LongSets.EMPTY_SET;
        ArrayList \u260310 = Lists.newArrayList((Object[])new String[]{"Minecraft " + SharedConstants.func_215069_a().getName() + " (" + this.field_175242_a.func_175600_c() + "/" + ClientBrandRetriever.getClientModName() + ("release".equalsIgnoreCase(this.field_175242_a.func_184123_d()) ? "" : "/" + this.field_175242_a.func_184123_d()) + ")", this.field_175242_a.field_71426_K, \u26035, this.field_175242_a.field_71438_f.func_72735_c(), this.field_175242_a.field_71438_f.func_72723_d(), "P: " + this.field_175242_a.field_71452_i.func_78869_b() + ". T: " + this.field_175242_a.field_71441_e.func_217425_f(), this.field_175242_a.field_71441_e.func_72827_u()});
        String \u260311 = this.func_223101_g();
        if (\u260311 != null) {
            \u260310.add(\u260311);
        }
        \u260310.add(DimensionType.func_212678_a(this.field_175242_a.field_71441_e.field_73011_w.func_186058_p()).toString() + " FC: " + Integer.toString(\u26039.size()));
        \u260310.add("");
        \u260310.add(String.format(Locale.ROOT, "XYZ: %.3f / %.5f / %.3f", this.field_175242_a.func_175606_aa().field_70165_t, this.field_175242_a.func_175606_aa().func_174813_aQ().field_72338_b, this.field_175242_a.func_175606_aa().field_70161_v));
        \u260310.add(String.format("Block: %d %d %d", \u26036.func_177958_n(), \u26036.func_177956_o(), \u26036.func_177952_p()));
        \u260310.add(String.format("Chunk: %d %d %d in %d %d %d", \u26036.func_177958_n() & 0xF, \u26036.func_177956_o() & 0xF, \u26036.func_177952_p() & 0xF, \u26036.func_177958_n() >> 4, \u26036.func_177956_o() >> 4, \u26036.func_177952_p() >> 4));
        \u260310.add(String.format(Locale.ROOT, "Facing: %s (%s) (%.1f / %.1f)", \u26038, string, Float.valueOf(MathHelper.func_76142_g(\u26037.field_70177_z)), Float.valueOf(MathHelper.func_76142_g(\u26037.field_70125_A))));
        if (this.field_175242_a.field_71441_e != null) {
            if (this.field_175242_a.field_71441_e.func_175667_e(\u26036)) {
                object = this.func_212916_i();
                if (((Chunk)object).func_76621_g()) {
                    \u260310.add("Waiting for chunk...");
                } else {
                    Object object2;
                    \u260310.add("Client Light: " + ((Chunk)object).func_177443_a(\u26036, 0) + " (" + this.field_175242_a.field_71441_e.func_175642_b(LightType.SKY, \u26036) + " sky, " + this.field_175242_a.field_71441_e.func_175642_b(LightType.BLOCK, \u26036) + " block)");
                    Chunk chunk = this.func_212919_h();
                    if (chunk != null) {
                        object2 = \u2603.func_72863_F().func_212863_j_();
                        \u260310.add("Server Light: (" + ((WorldLightManager)object2).func_215569_a(LightType.SKY).func_215611_b(\u26036) + " sky, " + ((WorldLightManager)object2).func_215569_a(LightType.BLOCK).func_215611_b(\u26036) + " block)");
                    }
                    object2 = new StringBuilder("CH");
                    for (Object \u260313 : Heightmap.Type.values()) {
                        if (!\u260313.func_222681_b()) continue;
                        ((StringBuilder)object2).append(" ").append(field_212923_a.get(\u260313)).append(": ").append(((Chunk)object).func_201576_a((Heightmap.Type)((Object)\u260313), \u26036.func_177958_n(), \u26036.func_177952_p()));
                    }
                    \u260310.add(((StringBuilder)object2).toString());
                    if (chunk != null) {
                        ((StringBuilder)object2).setLength(0);
                        ((StringBuilder)object2).append("SH");
                        for (Object \u260313 : Heightmap.Type.values()) {
                            if (!\u260313.func_222683_c()) continue;
                            ((StringBuilder)object2).append(" ").append(field_212923_a.get(\u260313)).append(": ").append(chunk.func_201576_a((Heightmap.Type)((Object)\u260313), \u26036.func_177958_n(), \u26036.func_177952_p()));
                        }
                        \u260310.add(((StringBuilder)object2).toString());
                    }
                    if (\u26036.func_177956_o() >= 0 && \u26036.func_177956_o() < 256) {
                        \u260310.add("Biome: " + Registry.field_212624_m.func_177774_c(object.func_217309_c(\u26036)));
                        long l = 0L;
                        float \u260312 = 0.0f;
                        if (chunk != null) {
                            \u260312 = \u2603.func_130001_d();
                            l = chunk.func_177416_w();
                        }
                        Object \u260313 = new DifficultyInstance(\u2603.func_175659_aa(), \u2603.func_72820_D(), l, \u260312);
                        \u260310.add(String.format(Locale.ROOT, "Local Difficulty: %.2f // %.2f (Day %d)", Float.valueOf(((DifficultyInstance)\u260313).func_180168_b()), Float.valueOf(((DifficultyInstance)\u260313).func_180170_c()), this.field_175242_a.field_71441_e.func_72820_D() / 24000L));
                    }
                }
            } else {
                \u260310.add("Outside of world...");
            }
        } else {
            \u260310.add("Outside of world...");
        }
        if (this.field_175242_a.field_71460_t != null && this.field_175242_a.field_71460_t.func_147702_a()) {
            \u260310.add("Shader: " + this.field_175242_a.field_71460_t.func_147706_e().func_148022_b());
        }
        if (this.field_211537_g.func_216346_c() == RayTraceResult.Type.BLOCK) {
            object = ((BlockRayTraceResult)this.field_211537_g).func_216350_a();
            \u260310.add(String.format("Looking at block: %d %d %d", ((Vec3i)object).func_177958_n(), ((Vec3i)object).func_177956_o(), ((Vec3i)object).func_177952_p()));
        }
        if (this.field_211538_h.func_216346_c() == RayTraceResult.Type.BLOCK) {
            object = ((BlockRayTraceResult)this.field_211538_h).func_216350_a();
            \u260310.add(String.format("Looking at liquid: %d %d %d", ((Vec3i)object).func_177958_n(), ((Vec3i)object).func_177956_o(), ((Vec3i)object).func_177952_p()));
        }
        \u260310.add(this.field_175242_a.func_147118_V().func_215293_f());
        return \u260310;
    }

    @Nullable
    private String func_223101_g() {
        IntegratedServer integratedServer = this.field_175242_a.func_71401_C();
        if (integratedServer != null && (\u2603 = integratedServer.func_71218_a(this.field_175242_a.field_71441_e.func_201675_m().func_186058_p())) != null) {
            return \u2603.func_72827_u();
        }
        return null;
    }

    private World func_212922_g() {
        return (World)DataFixUtils.orElse(Optional.ofNullable(this.field_175242_a.func_71401_C()).map(integratedServer -> integratedServer.func_71218_a(this.field_175242_a.field_71441_e.field_73011_w.func_186058_p())), (Object)this.field_175242_a.field_71441_e);
    }

    @Nullable
    private Chunk func_212919_h() {
        if (this.field_212926_h == null) {
            IntegratedServer integratedServer = this.field_175242_a.func_71401_C();
            if (integratedServer != null && (\u2603 = integratedServer.func_71218_a(this.field_175242_a.field_71441_e.field_73011_w.func_186058_p())) != null) {
                this.field_212926_h = \u2603.func_72863_F().func_217232_b(this.field_212924_f.field_77276_a, this.field_212924_f.field_77275_b, ChunkStatus.field_222617_m, false).thenApply(either -> (Chunk)either.map(iChunk -> (Chunk)iChunk, iChunkLoadingError -> null));
            }
            if (this.field_212926_h == null) {
                this.field_212926_h = CompletableFuture.completedFuture(this.func_212916_i());
            }
        }
        return this.field_212926_h.getNow(null);
    }

    private Chunk func_212916_i() {
        if (this.field_212925_g == null) {
            this.field_212925_g = this.field_175242_a.field_71441_e.func_212866_a_(this.field_212924_f.field_77276_a, this.field_212924_f.field_77275_b);
        }
        return this.field_212925_g;
    }

    protected List<String> func_175238_c() {
        long l = Runtime.getRuntime().maxMemory();
        long l2 = Runtime.getRuntime().totalMemory();
        \u2603 = Runtime.getRuntime().freeMemory();
        \u2603 = l2 - \u2603;
        ArrayList \u26032 = Lists.newArrayList((Object[])new String[]{String.format("Java: %s %dbit", System.getProperty("java.version"), this.field_175242_a.func_147111_S() ? 64 : 32), String.format("Mem: % 2d%% %03d/%03dMB", \u2603 * 100L / l, DebugOverlayGui.func_175240_a(\u2603), DebugOverlayGui.func_175240_a(l)), String.format("Allocated: % 2d%% %03dMB", l2 * 100L / l, DebugOverlayGui.func_175240_a(l2)), "", String.format("CPU: %s", GLX.getCpuInfo()), "", String.format("Display: %dx%d (%s)", Minecraft.func_71410_x().field_195558_d.func_198109_k(), Minecraft.func_71410_x().field_195558_d.func_198091_l(), GLX.getVendor()), GLX.getRenderer(), GLX.getOpenGLVersion()});
        if (this.field_175242_a.func_189648_am()) {
            return \u26032;
        }
        if (this.field_211537_g.func_216346_c() == RayTraceResult.Type.BLOCK) {
            BlockPos object = ((BlockRayTraceResult)this.field_211537_g).func_216350_a();
            BlockState \u26033 = this.field_175242_a.field_71441_e.func_180495_p(object);
            \u26032.add("");
            \u26032.add((Object)((Object)TextFormatting.UNDERLINE) + "Targeted Block");
            \u26032.add(String.valueOf(Registry.field_212618_g.func_177774_c(\u26033.func_177230_c())));
            for (Map.Entry entry : \u26033.func_206871_b().entrySet()) {
                \u26032.add(this.func_211534_a(entry));
            }
            for (ResourceLocation resourceLocation : this.field_175242_a.func_147114_u().func_199724_l().func_199717_a().func_199913_a(\u26033.func_177230_c())) {
                \u26032.add("#" + resourceLocation);
            }
        }
        if (this.field_211538_h.func_216346_c() == RayTraceResult.Type.BLOCK) {
            Object object = ((BlockRayTraceResult)this.field_211538_h).func_216350_a();
            IFluidState \u26034 = this.field_175242_a.field_71441_e.func_204610_c((BlockPos)object);
            \u26032.add("");
            \u26032.add((Object)((Object)TextFormatting.UNDERLINE) + "Targeted Fluid");
            \u26032.add(String.valueOf(Registry.field_212619_h.func_177774_c(\u26034.func_206886_c())));
            for (Map.Entry entry : \u26034.func_206871_b().entrySet()) {
                \u26032.add(this.func_211534_a(entry));
            }
            for (ResourceLocation resourceLocation : this.field_175242_a.func_147114_u().func_199724_l().func_205704_c().func_199913_a(\u26034.func_206886_c())) {
                \u26032.add("#" + resourceLocation);
            }
        }
        if ((object = this.field_175242_a.field_147125_j) != null) {
            \u26032.add("");
            \u26032.add((Object)((Object)TextFormatting.UNDERLINE) + "Targeted Entity");
            \u26032.add(String.valueOf(Registry.field_212629_r.func_177774_c(((Entity)object).func_200600_R())));
        }
        return \u26032;
    }

    private String func_211534_a(Map.Entry<IProperty<?>, Comparable<?>> entry) {
        IProperty<?> iProperty = entry.getKey();
        Comparable<?> \u26032 = entry.getValue();
        String \u26033 = Util.func_200269_a(iProperty, \u26032);
        if (Boolean.TRUE.equals(\u26032)) {
            \u26033 = (Object)((Object)TextFormatting.GREEN) + \u26033;
        } else if (Boolean.FALSE.equals(\u26032)) {
            \u26033 = (Object)((Object)TextFormatting.RED) + \u26033;
        }
        return iProperty.func_177701_a() + ": " + \u26033;
    }

    private void func_212920_a(FrameTimer frameTimer, int n, int n2, boolean bl) {
        GlStateManager.disableDepthTest();
        int n3 = frameTimer.func_181749_a();
        \u2603 = frameTimer.func_181750_b();
        long[] \u26032 = frameTimer.func_181746_c();
        \u2603 = n3;
        \u2603 = n;
        \u2603 = Math.max(0, \u26032.length - n2);
        \u2603 = \u26032.length - \u2603;
        \u2603 = frameTimer.func_181751_b(\u2603 + \u2603);
        long \u26033 = 0L;
        \u2603 = Integer.MAX_VALUE;
        \u2603 = Integer.MIN_VALUE;
        for (\u2603 = 0; \u2603 < \u2603; ++\u2603) {
            \u2603 = (int)(\u26032[frameTimer.func_181751_b(\u2603 + \u2603)] / 1000000L);
            \u2603 = Math.min(\u2603, \u2603);
            \u2603 = Math.max(\u2603, \u2603);
            \u26033 += (long)\u2603;
        }
        \u2603 = this.field_175242_a.field_195558_d.func_198087_p();
        DebugOverlayGui.fill(n, \u2603 - 60, n + \u2603, \u2603, -1873784752);
        while (\u2603 != \u2603) {
            \u2603 = frameTimer.func_219792_a(\u26032[\u2603], bl ? 30 : 60, bl ? 60 : 20);
            \u2603 = bl ? 100 : 60;
            \u2603 = this.func_181552_c(MathHelper.func_76125_a(\u2603, 0, \u2603), 0, \u2603 / 2, \u2603);
            this.vLine(\u2603, \u2603, \u2603 - \u2603, \u2603);
            ++\u2603;
            \u2603 = frameTimer.func_181751_b(\u2603 + 1);
        }
        if (bl) {
            DebugOverlayGui.fill(n + 1, \u2603 - 30 + 1, n + 14, \u2603 - 30 + 10, -1873784752);
            this.field_175241_f.func_211126_b("60 FPS", n + 2, \u2603 - 30 + 2, 0xE0E0E0);
            this.hLine(n, n + \u2603 - 1, \u2603 - 30, -1);
            DebugOverlayGui.fill(n + 1, \u2603 - 60 + 1, n + 14, \u2603 - 60 + 10, -1873784752);
            this.field_175241_f.func_211126_b("30 FPS", n + 2, \u2603 - 60 + 2, 0xE0E0E0);
            this.hLine(n, n + \u2603 - 1, \u2603 - 60, -1);
        } else {
            DebugOverlayGui.fill(n + 1, \u2603 - 60 + 1, n + 14, \u2603 - 60 + 10, -1873784752);
            this.field_175241_f.func_211126_b("20 TPS", n + 2, \u2603 - 60 + 2, 0xE0E0E0);
            this.hLine(n, n + \u2603 - 1, \u2603 - 60, -1);
        }
        this.hLine(n, n + \u2603 - 1, \u2603 - 1, -1);
        this.vLine(n, \u2603 - 60, \u2603, -1);
        this.vLine(n + \u2603 - 1, \u2603 - 60, \u2603, -1);
        if (bl && this.field_175242_a.field_71474_y.field_74350_i > 0 && this.field_175242_a.field_71474_y.field_74350_i <= 250) {
            this.hLine(n, n + \u2603 - 1, \u2603 - 1 - (int)(1800.0 / (double)this.field_175242_a.field_71474_y.field_74350_i), -16711681);
        }
        String \u26034 = \u2603 + " ms min";
        String \u26035 = \u26033 / (long)\u2603 + " ms avg";
        String \u26036 = \u2603 + " ms max";
        this.field_175241_f.func_175063_a(\u26034, n + 2, \u2603 - 60 - this.field_175241_f.field_78288_b, 0xE0E0E0);
        this.field_175241_f.func_175063_a(\u26035, n + \u2603 / 2 - this.field_175241_f.func_78256_a(\u26035) / 2, \u2603 - 60 - this.field_175241_f.field_78288_b, 0xE0E0E0);
        this.field_175241_f.func_175063_a(\u26036, n + \u2603 - this.field_175241_f.func_78256_a(\u26036), \u2603 - 60 - this.field_175241_f.field_78288_b, 0xE0E0E0);
        GlStateManager.enableDepthTest();
    }

    private int func_181552_c(int n, int n2, int n3, int n4) {
        if (n < n3) {
            return this.func_181553_a(-16711936, -256, (float)n / (float)n3);
        }
        return this.func_181553_a(-256, -65536, (float)(n - n3) / (float)(n4 - n3));
    }

    private int func_181553_a(int n, int n2, float f) {
        int n3 = n >> 24 & 0xFF;
        \u2603 = n >> 16 & 0xFF;
        \u2603 = n >> 8 & 0xFF;
        \u2603 = n & 0xFF;
        \u2603 = n2 >> 24 & 0xFF;
        \u2603 = n2 >> 16 & 0xFF;
        \u2603 = n2 >> 8 & 0xFF;
        \u2603 = n2 & 0xFF;
        \u2603 = MathHelper.func_76125_a((int)MathHelper.func_219799_g(f, n3, \u2603), 0, 255);
        \u2603 = MathHelper.func_76125_a((int)MathHelper.func_219799_g(f, \u2603, \u2603), 0, 255);
        \u2603 = MathHelper.func_76125_a((int)MathHelper.func_219799_g(f, \u2603, \u2603), 0, 255);
        \u2603 = MathHelper.func_76125_a((int)MathHelper.func_219799_g(f, \u2603, \u2603), 0, 255);
        return \u2603 << 24 | \u2603 << 16 | \u2603 << 8 | \u2603;
    }

    private static long func_175240_a(long l) {
        return l / 1024L / 1024L;
    }
}

