/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui.fonts.providers;

import com.google.common.collect.Maps;
import com.google.gson.JsonObject;
import java.io.IOException;
import java.util.Arrays;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.fonts.IGlyphInfo;
import net.minecraft.client.gui.fonts.providers.IGlyphProvider;
import net.minecraft.client.gui.fonts.providers.IGlyphProviderFactory;
import net.minecraft.client.renderer.texture.NativeImage;
import net.minecraft.resources.IResource;
import net.minecraft.resources.IResourceManager;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class UnicodeTextureGlyphProvider
implements IGlyphProvider {
    private static final Logger field_211256_a = LogManager.getLogger();
    private final IResourceManager field_211257_b;
    private final byte[] field_211258_c;
    private final String field_211259_d;
    private final Map<ResourceLocation, NativeImage> field_211845_e = Maps.newHashMap();

    public UnicodeTextureGlyphProvider(IResourceManager iResourceManager, byte[] byArray2, String string) {
        this.field_211257_b = iResourceManager;
        this.field_211258_c = byArray2;
        this.field_211259_d = string;
        for (int i = 0; i < 256; ++i) {
            byte[] byArray2;
            char c = (char)(i * 256);
            ResourceLocation \u26032 = this.func_211623_c(c);
            try (IResource iResource = this.field_211257_b.func_199002_a(\u26032);
                 NativeImage nativeImage = NativeImage.func_211679_a(NativeImage.PixelFormat.RGBA, iResource.func_199027_b());){
                if (nativeImage.func_195702_a() == 256 && nativeImage.func_195714_b() == 256) {
                    for (int j = 0; j < 256; ++j) {
                        byte by = byArray2[c + j];
                        if (by == 0 || UnicodeTextureGlyphProvider.func_212453_a(by) <= UnicodeTextureGlyphProvider.func_212454_b(by)) continue;
                        byArray2[c + j] = 0;
                    }
                    continue;
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            Arrays.fill(byArray2, (int)c, c + 256, (byte)0);
        }
    }

    @Override
    public void close() {
        this.field_211845_e.values().forEach(NativeImage::close);
    }

    private ResourceLocation func_211623_c(char c) {
        ResourceLocation resourceLocation = new ResourceLocation(String.format(this.field_211259_d, String.format("%02x", c / 256)));
        return new ResourceLocation(resourceLocation.func_110624_b(), "textures/" + resourceLocation.func_110623_a());
    }

    @Override
    @Nullable
    public IGlyphInfo func_212248_a(char c) {
        byte by = this.field_211258_c[c];
        if (by != 0 && (\u2603 = this.field_211845_e.computeIfAbsent(this.func_211623_c(c), this::func_211255_a)) != null) {
            int n = UnicodeTextureGlyphProvider.func_212453_a(by);
            return new GlpyhInfo(c % 16 * 16 + n, (c & 0xFF) / 16 * 16, UnicodeTextureGlyphProvider.func_212454_b(by) - n, 16, \u2603);
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    private NativeImage func_211255_a(ResourceLocation resourceLocation) {
        try (IResource iResource = this.field_211257_b.func_199002_a(resourceLocation);){
            NativeImage nativeImage = NativeImage.func_211679_a(NativeImage.PixelFormat.RGBA, iResource.func_199027_b());
            return nativeImage;
        }
        catch (IOException iOException) {
            field_211256_a.error("Couldn't load texture {}", (Object)resourceLocation, (Object)iOException);
            return null;
        }
    }

    private static int func_212453_a(byte by) {
        return by >> 4 & 0xF;
    }

    private static int func_212454_b(byte by) {
        return (by & 0xF) + 1;
    }

    static class GlpyhInfo
    implements IGlyphInfo {
        private final int field_211210_a;
        private final int field_211211_b;
        private final int field_211212_c;
        private final int field_211213_d;
        private final NativeImage field_211214_e;

        private GlpyhInfo(int n, int n2, int n3, int n4, NativeImage nativeImage) {
            this.field_211210_a = n3;
            this.field_211211_b = n4;
            this.field_211212_c = n;
            this.field_211213_d = n2;
            this.field_211214_e = nativeImage;
        }

        @Override
        public float func_211578_g() {
            return 2.0f;
        }

        @Override
        public int func_211202_a() {
            return this.field_211210_a;
        }

        @Override
        public int func_211203_b() {
            return this.field_211211_b;
        }

        @Override
        public float getAdvance() {
            return this.field_211210_a / 2 + 1;
        }

        @Override
        public void func_211573_a(int n, int n2) {
            this.field_211214_e.func_195706_a(0, n, n2, this.field_211212_c, this.field_211213_d, this.field_211210_a, this.field_211211_b, false);
        }

        @Override
        public boolean func_211579_f() {
            return this.field_211214_e.func_211678_c().func_211651_a() > 1;
        }

        @Override
        public float func_223276_c_() {
            return 0.5f;
        }

        @Override
        public float func_223275_b_() {
            return 0.5f;
        }
    }

    public static class Factory
    implements IGlyphProviderFactory {
        private final ResourceLocation field_211247_a;
        private final String field_211248_b;

        public Factory(ResourceLocation resourceLocation, String string) {
            this.field_211247_a = resourceLocation;
            this.field_211248_b = string;
        }

        public static IGlyphProviderFactory func_211629_a(JsonObject jsonObject) {
            return new Factory(new ResourceLocation(JSONUtils.func_151200_h(jsonObject, "sizes")), JSONUtils.func_151200_h(jsonObject, "template"));
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        @Nullable
        public IGlyphProvider func_211246_a(IResourceManager iResourceManager) {
            try (IResource iResource = Minecraft.func_71410_x().func_195551_G().func_199002_a(this.field_211247_a);){
                byte[] \u26032 = new byte[65536];
                iResource.func_199027_b().read(\u26032);
                UnicodeTextureGlyphProvider unicodeTextureGlyphProvider = new UnicodeTextureGlyphProvider(iResourceManager, \u26032, this.field_211248_b);
                return unicodeTextureGlyphProvider;
            }
            catch (IOException iOException) {
                field_211256_a.error("Cannot load {}, unicode glyphs will not render correctly", (Object)this.field_211247_a);
                return null;
            }
        }
    }
}

