/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui;

import com.google.common.collect.Maps;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.IHasContainer;
import net.minecraft.client.gui.screen.EnchantmentScreen;
import net.minecraft.client.gui.screen.GrindstoneScreen;
import net.minecraft.client.gui.screen.HopperScreen;
import net.minecraft.client.gui.screen.LecternScreen;
import net.minecraft.client.gui.screen.LoomScreen;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.screen.inventory.AnvilScreen;
import net.minecraft.client.gui.screen.inventory.BeaconScreen;
import net.minecraft.client.gui.screen.inventory.BlastFurnaceScreen;
import net.minecraft.client.gui.screen.inventory.BrewingStandScreen;
import net.minecraft.client.gui.screen.inventory.CartographyTableScreen;
import net.minecraft.client.gui.screen.inventory.ChestScreen;
import net.minecraft.client.gui.screen.inventory.CraftingScreen;
import net.minecraft.client.gui.screen.inventory.DispenserScreen;
import net.minecraft.client.gui.screen.inventory.FurnaceScreen;
import net.minecraft.client.gui.screen.inventory.MerchantScreen;
import net.minecraft.client.gui.screen.inventory.ShulkerBoxScreen;
import net.minecraft.client.gui.screen.inventory.SmokerScreen;
import net.minecraft.client.gui.screen.inventory.StonecutterScreen;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.util.registry.Registry;
import net.minecraft.util.text.ITextComponent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ScreenManager {
    private static final Logger field_216913_a = LogManager.getLogger();
    private static final Map<ContainerType<?>, IScreenFactory<?, ?>> field_216914_b = Maps.newHashMap();

    public static <T extends Container> void func_216909_a(@Nullable ContainerType<T> containerType, Minecraft minecraft, int n, ITextComponent iTextComponent) {
        if (containerType == null) {
            field_216913_a.warn("Trying to open invalid screen with name: {}", (Object)iTextComponent.getString());
            return;
        }
        IScreenFactory<T, ?> iScreenFactory = ScreenManager.func_216912_a(containerType);
        if (iScreenFactory == null) {
            field_216913_a.warn("Failed to create screen for menu type: {}", (Object)Registry.field_218366_G.func_177774_c(containerType));
            return;
        }
        iScreenFactory.func_216908_a(iTextComponent, containerType, minecraft, n);
    }

    @Nullable
    private static <T extends Container> IScreenFactory<T, ?> func_216912_a(ContainerType<T> containerType) {
        return field_216914_b.get(containerType);
    }

    private static <M extends Container, U extends Screen> void func_216911_a(ContainerType<? extends M> containerType, IScreenFactory<M, U> iScreenFactory) {
        \u2603 = field_216914_b.put(containerType, iScreenFactory);
        if (\u2603 != null) {
            throw new IllegalStateException("Duplicate registration for " + Registry.field_218366_G.func_177774_c(containerType));
        }
    }

    public static boolean func_216910_a() {
        boolean bl = false;
        for (ContainerType containerType : Registry.field_218366_G) {
            if (field_216914_b.containsKey(containerType)) continue;
            field_216913_a.debug("Menu {} has no matching screen", (Object)Registry.field_218366_G.func_177774_c(containerType));
            bl = true;
        }
        return bl;
    }

    static {
        ScreenManager.func_216911_a(ContainerType.field_221507_a, ChestScreen::new);
        ScreenManager.func_216911_a(ContainerType.field_221508_b, ChestScreen::new);
        ScreenManager.func_216911_a(ContainerType.field_221509_c, ChestScreen::new);
        ScreenManager.func_216911_a(ContainerType.field_221510_d, ChestScreen::new);
        ScreenManager.func_216911_a(ContainerType.field_221511_e, ChestScreen::new);
        ScreenManager.func_216911_a(ContainerType.field_221512_f, ChestScreen::new);
        ScreenManager.func_216911_a(ContainerType.field_221513_g, DispenserScreen::new);
        ScreenManager.func_216911_a(ContainerType.field_221514_h, AnvilScreen::new);
        ScreenManager.func_216911_a(ContainerType.field_221515_i, BeaconScreen::new);
        ScreenManager.func_216911_a(ContainerType.field_221516_j, BlastFurnaceScreen::new);
        ScreenManager.func_216911_a(ContainerType.field_221517_k, BrewingStandScreen::new);
        ScreenManager.func_216911_a(ContainerType.field_221518_l, CraftingScreen::new);
        ScreenManager.func_216911_a(ContainerType.field_221519_m, EnchantmentScreen::new);
        ScreenManager.func_216911_a(ContainerType.field_221520_n, FurnaceScreen::new);
        ScreenManager.func_216911_a(ContainerType.field_221521_o, GrindstoneScreen::new);
        ScreenManager.func_216911_a(ContainerType.field_221522_p, HopperScreen::new);
        ScreenManager.func_216911_a(ContainerType.field_221523_q, LecternScreen::new);
        ScreenManager.func_216911_a(ContainerType.field_221524_r, LoomScreen::new);
        ScreenManager.func_216911_a(ContainerType.field_221525_s, MerchantScreen::new);
        ScreenManager.func_216911_a(ContainerType.field_221526_t, ShulkerBoxScreen::new);
        ScreenManager.func_216911_a(ContainerType.field_221527_u, SmokerScreen::new);
        ScreenManager.func_216911_a(ContainerType.field_221528_v, CartographyTableScreen::new);
        ScreenManager.func_216911_a(ContainerType.field_221529_w, StonecutterScreen::new);
    }

    static interface IScreenFactory<T extends Container, U extends Screen> {
        default public void func_216908_a(ITextComponent iTextComponent, ContainerType<T> containerType, Minecraft minecraft, int n) {
            U u = this.create(containerType.func_221506_a(n, minecraft.field_71439_g.field_71071_by), minecraft.field_71439_g.field_71071_by, iTextComponent);
            minecraft.field_71439_g.field_71070_bA = ((IHasContainer)u).func_212873_a_();
            minecraft.func_147108_a((Screen)u);
        }

        public U create(T var1, PlayerInventory var2, ITextComponent var3);
    }
}

