/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui;

import com.google.common.collect.Maps;
import com.mojang.blaze3d.platform.GlStateManager;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.block.material.MaterialColor;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.storage.MapData;
import net.minecraft.world.storage.MapDecoration;

public class MapItemRenderer
implements AutoCloseable {
    private static final ResourceLocation field_148253_a = new ResourceLocation("textures/map/map_icons.png");
    private final TextureManager field_148251_b;
    private final Map<String, Instance> field_148252_c = Maps.newHashMap();

    public MapItemRenderer(TextureManager textureManager) {
        this.field_148251_b = textureManager;
    }

    public void func_148246_a(MapData mapData) {
        this.func_148248_b(mapData).func_148236_a();
    }

    public void func_148250_a(MapData mapData, boolean bl) {
        this.func_148248_b(mapData).func_148237_a(bl);
    }

    private Instance func_148248_b(MapData mapData) {
        Instance instance = this.field_148252_c.get(mapData.func_195925_e());
        if (instance == null) {
            instance = new Instance(mapData);
            this.field_148252_c.put(mapData.func_195925_e(), instance);
        }
        return instance;
    }

    @Nullable
    public Instance func_191205_a(String string) {
        return this.field_148252_c.get(string);
    }

    public void func_148249_a() {
        for (Instance instance : this.field_148252_c.values()) {
            instance.close();
        }
        this.field_148252_c.clear();
    }

    @Nullable
    public MapData func_191207_a(@Nullable Instance instance) {
        if (instance != null) {
            return instance.field_148242_b;
        }
        return null;
    }

    @Override
    public void close() {
        this.func_148249_a();
    }

    class Instance
    implements AutoCloseable {
        private final MapData field_148242_b;
        private final DynamicTexture field_148243_c;
        private final ResourceLocation field_148240_d;

        private Instance(MapData mapData) {
            this.field_148242_b = mapData;
            this.field_148243_c = new DynamicTexture(128, 128, true);
            this.field_148240_d = MapItemRenderer.this.field_148251_b.func_110578_a("map/" + mapData.func_195925_e(), this.field_148243_c);
        }

        private void func_148236_a() {
            for (int i = 0; i < 128; ++i) {
                for (\u2603 = 0; \u2603 < 128; ++\u2603) {
                    \u2603 = \u2603 + i * 128;
                    \u2603 = this.field_148242_b.field_76198_e[\u2603] & 0xFF;
                    if (\u2603 / 4 == 0) {
                        this.field_148243_c.func_195414_e().func_195700_a(\u2603, i, (\u2603 + \u2603 / 128 & 1) * 8 + 16 << 24);
                        continue;
                    }
                    this.field_148243_c.func_195414_e().func_195700_a(\u2603, i, MaterialColor.field_76281_a[\u2603 / 4].func_151643_b(\u2603 & 3));
                }
            }
            this.field_148243_c.func_110564_a();
        }

        private void func_148237_a(boolean bl) {
            \u2603 = false;
            \u2603 = false;
            Tessellator tessellator = Tessellator.func_178181_a();
            BufferBuilder \u26032 = tessellator.func_178180_c();
            float \u26033 = 0.0f;
            MapItemRenderer.this.field_148251_b.func_110577_a(this.field_148240_d);
            GlStateManager.enableBlend();
            GlStateManager.blendFuncSeparate(GlStateManager.SourceFactor.ONE, GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, GlStateManager.SourceFactor.ZERO, GlStateManager.DestFactor.ONE);
            GlStateManager.disableAlphaTest();
            \u26032.func_181668_a(7, DefaultVertexFormats.field_181707_g);
            \u26032.func_181662_b(0.0, 128.0, -0.01f).func_187315_a(0.0, 1.0).func_181675_d();
            \u26032.func_181662_b(128.0, 128.0, -0.01f).func_187315_a(1.0, 1.0).func_181675_d();
            \u26032.func_181662_b(128.0, 0.0, -0.01f).func_187315_a(1.0, 0.0).func_181675_d();
            \u26032.func_181662_b(0.0, 0.0, -0.01f).func_187315_a(0.0, 0.0).func_181675_d();
            tessellator.func_78381_a();
            GlStateManager.enableAlphaTest();
            GlStateManager.disableBlend();
            int \u26034 = 0;
            for (MapDecoration mapDecoration : this.field_148242_b.field_76203_h.values()) {
                if (bl && !mapDecoration.func_191180_f()) continue;
                MapItemRenderer.this.field_148251_b.func_110577_a(field_148253_a);
                GlStateManager.pushMatrix();
                GlStateManager.translatef(0.0f + (float)mapDecoration.func_176112_b() / 2.0f + 64.0f, 0.0f + (float)mapDecoration.func_176113_c() / 2.0f + 64.0f, -0.02f);
                GlStateManager.rotatef((float)(mapDecoration.func_176111_d() * 360) / 16.0f, 0.0f, 0.0f, 1.0f);
                GlStateManager.scalef(4.0f, 4.0f, 3.0f);
                GlStateManager.translatef(-0.125f, 0.125f, 0.0f);
                byte by = mapDecoration.func_176110_a();
                float \u26035 = (float)(by % 16 + 0) / 16.0f;
                float \u26036 = (float)(by / 16 + 0) / 16.0f;
                float \u26037 = (float)(by % 16 + 1) / 16.0f;
                float \u26038 = (float)(by / 16 + 1) / 16.0f;
                \u26032.func_181668_a(7, DefaultVertexFormats.field_181707_g);
                GlStateManager.color4f(1.0f, 1.0f, 1.0f, 1.0f);
                float \u26039 = -0.001f;
                \u26032.func_181662_b(-1.0, 1.0, (float)\u26034 * -0.001f).func_187315_a(\u26035, \u26036).func_181675_d();
                \u26032.func_181662_b(1.0, 1.0, (float)\u26034 * -0.001f).func_187315_a(\u26037, \u26036).func_181675_d();
                \u26032.func_181662_b(1.0, -1.0, (float)\u26034 * -0.001f).func_187315_a(\u26037, \u26038).func_181675_d();
                \u26032.func_181662_b(-1.0, -1.0, (float)\u26034 * -0.001f).func_187315_a(\u26035, \u26038).func_181675_d();
                tessellator.func_78381_a();
                GlStateManager.popMatrix();
                if (mapDecoration.func_204309_g() != null) {
                    FontRenderer fontRenderer = Minecraft.func_71410_x().field_71466_p;
                    String \u260310 = mapDecoration.func_204309_g().func_150254_d();
                    float \u260311 = fontRenderer.func_78256_a(\u260310);
                    float f = 25.0f / \u260311;
                    fontRenderer.getClass();
                    float \u260312 = MathHelper.func_76131_a(f, 0.0f, 6.0f / 9.0f);
                    GlStateManager.pushMatrix();
                    GlStateManager.translatef(0.0f + (float)mapDecoration.func_176112_b() / 2.0f + 64.0f - \u260311 * \u260312 / 2.0f, 0.0f + (float)mapDecoration.func_176113_c() / 2.0f + 64.0f + 4.0f, -0.025f);
                    GlStateManager.scalef(\u260312, \u260312, 1.0f);
                    AbstractGui.fill(-1, -1, (int)\u260311, fontRenderer.field_78288_b - 1, Integer.MIN_VALUE);
                    GlStateManager.translatef(0.0f, 0.0f, -0.1f);
                    fontRenderer.func_211126_b(\u260310, 0.0f, 0.0f, -1);
                    GlStateManager.popMatrix();
                }
                ++\u26034;
            }
            GlStateManager.pushMatrix();
            GlStateManager.translatef(0.0f, 0.0f, -0.04f);
            GlStateManager.scalef(1.0f, 1.0f, 1.0f);
            GlStateManager.popMatrix();
        }

        @Override
        public void close() {
            this.field_148243_c.close();
        }
    }
}

