/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui;

import java.util.List;
import java.util.ListIterator;
import java.util.Optional;
import java.util.function.BooleanSupplier;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.client.gui.IGuiEventListener;

public interface INestedGuiEventHandler
extends IGuiEventListener {
    public List<? extends IGuiEventListener> children();

    default public Optional<IGuiEventListener> func_212930_a(double d, double d2) {
        for (IGuiEventListener iGuiEventListener : this.children()) {
            if (!iGuiEventListener.isMouseOver(d, d2)) continue;
            return Optional.of(iGuiEventListener);
        }
        return Optional.empty();
    }

    @Override
    default public boolean mouseClicked(double d, double d2, int n) {
        for (IGuiEventListener iGuiEventListener : this.children()) {
            if (!iGuiEventListener.mouseClicked(d, d2, n)) continue;
            this.setFocused(iGuiEventListener);
            if (n == 0) {
                this.setDragging(true);
            }
            return true;
        }
        return false;
    }

    @Override
    default public boolean mouseReleased(double d, double d2, int n) {
        this.setDragging(false);
        return this.func_212930_a(d, d2).filter(iGuiEventListener -> iGuiEventListener.mouseReleased(d, d2, n)).isPresent();
    }

    @Override
    default public boolean mouseDragged(double d, double d2, int n, double d3, double d4) {
        if (this.getFocused() != null && this.isDragging() && n == 0) {
            return this.getFocused().mouseDragged(d, d2, n, d3, d4);
        }
        return false;
    }

    public boolean isDragging();

    public void setDragging(boolean var1);

    @Override
    default public boolean mouseScrolled(double d, double d2, double d3) {
        return this.func_212930_a(d, d2).filter(iGuiEventListener -> iGuiEventListener.mouseScrolled(d, d2, d3)).isPresent();
    }

    @Override
    default public boolean keyPressed(int n, int n2, int n3) {
        return this.getFocused() != null && this.getFocused().keyPressed(n, n2, n3);
    }

    @Override
    default public boolean func_223281_a_(int n, int n2, int n3) {
        return this.getFocused() != null && this.getFocused().func_223281_a_(n, n2, n3);
    }

    @Override
    default public boolean charTyped(char c, int n) {
        return this.getFocused() != null && this.getFocused().charTyped(c, n);
    }

    @Nullable
    public IGuiEventListener getFocused();

    public void setFocused(@Nullable IGuiEventListener var1);

    default public void func_212928_a(@Nullable IGuiEventListener iGuiEventListener) {
        this.setFocused(iGuiEventListener);
    }

    default public void func_212932_b(@Nullable IGuiEventListener iGuiEventListener) {
        this.setFocused(iGuiEventListener);
    }

    @Override
    default public boolean changeFocus(boolean bl) {
        IGuiEventListener iGuiEventListener = this.getFocused();
        boolean bl2 = \u2603 = iGuiEventListener != null;
        if (\u2603 && iGuiEventListener.changeFocus(bl)) {
            return true;
        }
        List<? extends IGuiEventListener> \u26032 = this.children();
        int \u26033 = \u26032.indexOf(iGuiEventListener);
        int \u26034 = \u2603 && \u26033 >= 0 ? \u26033 + (bl ? 1 : 0) : (bl ? 0 : \u26032.size());
        ListIterator<? extends IGuiEventListener> \u26035 = \u26032.listIterator(\u26034);
        BooleanSupplier booleanSupplier = bl ? \u26035::hasNext : (\u2603 = \u26035::hasPrevious);
        Supplier<IGuiEventListener> supplier = bl ? \u26035::next : (\u2603 = \u26035::previous);
        while (\u2603.getAsBoolean()) {
            \u2603 = \u2603.get();
            if (!\u2603.changeFocus(bl)) continue;
            this.setFocused(\u2603);
            return true;
        }
        this.setFocused(null);
        return false;
    }
}

