/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.audio;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.Nullable;
import javax.sound.sampled.AudioFormat;
import net.minecraft.client.audio.ALUtils;
import net.minecraft.client.audio.AudioStreamBuffer;
import net.minecraft.client.audio.IAudioStream;
import net.minecraft.util.math.Vec3d;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.lwjgl.openal.AL10;

public class SoundSource {
    private static final Logger field_216440_a = LogManager.getLogger();
    private final int field_216441_b;
    private AtomicBoolean field_216442_c = new AtomicBoolean(true);
    private int field_216443_d = 16384;
    @Nullable
    private IAudioStream field_216444_e;

    @Nullable
    static SoundSource func_216426_a() {
        int[] nArray = new int[1];
        AL10.alGenSources((int[])nArray);
        if (ALUtils.func_216483_a("Allocate new source")) {
            return null;
        }
        return new SoundSource(nArray[0]);
    }

    private SoundSource(int n) {
        this.field_216441_b = n;
    }

    public void func_216436_b() {
        if (this.field_216442_c.compareAndSet(true, false)) {
            AL10.alSourceStop((int)this.field_216441_b);
            ALUtils.func_216483_a("Stop");
            if (this.field_216444_e != null) {
                try {
                    this.field_216444_e.close();
                }
                catch (IOException iOException) {
                    field_216440_a.error("Failed to close audio stream", (Throwable)iOException);
                }
                this.func_216427_k();
                this.field_216444_e = null;
            }
            AL10.alDeleteSources((int[])new int[]{this.field_216441_b});
            ALUtils.func_216483_a("Cleanup");
        }
    }

    public void func_216438_c() {
        AL10.alSourcePlay((int)this.field_216441_b);
    }

    private int func_216428_j() {
        if (!this.field_216442_c.get()) {
            return 4116;
        }
        return AL10.alGetSourcei((int)this.field_216441_b, (int)4112);
    }

    public void func_216439_d() {
        if (this.func_216428_j() == 4114) {
            AL10.alSourcePause((int)this.field_216441_b);
        }
    }

    public void func_216437_e() {
        if (this.func_216428_j() == 4115) {
            AL10.alSourcePlay((int)this.field_216441_b);
        }
    }

    public void func_216418_f() {
        if (this.field_216442_c.get()) {
            AL10.alSourceStop((int)this.field_216441_b);
            ALUtils.func_216483_a("Stop");
        }
    }

    public boolean func_216435_g() {
        return this.func_216428_j() == 4116;
    }

    public void func_216420_a(Vec3d vec3d) {
        AL10.alSourcefv((int)this.field_216441_b, (int)4100, (float[])new float[]{(float)vec3d.field_72450_a, (float)vec3d.field_72448_b, (float)vec3d.field_72449_c});
    }

    public void func_216422_a(float f) {
        AL10.alSourcef((int)this.field_216441_b, (int)4099, (float)f);
    }

    public void func_216425_a(boolean bl) {
        AL10.alSourcei((int)this.field_216441_b, (int)4103, (int)(bl ? 1 : 0));
    }

    public void func_216430_b(float f) {
        AL10.alSourcef((int)this.field_216441_b, (int)4106, (float)f);
    }

    public void func_216419_h() {
        AL10.alSourcei((int)this.field_216441_b, (int)53248, (int)0);
    }

    public void func_216423_c(float f) {
        AL10.alSourcei((int)this.field_216441_b, (int)53248, (int)53251);
        AL10.alSourcef((int)this.field_216441_b, (int)4131, (float)f);
        AL10.alSourcef((int)this.field_216441_b, (int)4129, (float)1.0f);
        AL10.alSourcef((int)this.field_216441_b, (int)4128, (float)0.0f);
    }

    public void func_216432_b(boolean bl) {
        AL10.alSourcei((int)this.field_216441_b, (int)514, (int)(bl ? 1 : 0));
    }

    public void func_216429_a(AudioStreamBuffer audioStreamBuffer) {
        audioStreamBuffer.func_216473_a().ifPresent(n -> AL10.alSourcei((int)this.field_216441_b, (int)4105, (int)n));
    }

    public void func_216433_a(IAudioStream iAudioStream) {
        this.field_216444_e = iAudioStream;
        AudioFormat audioFormat = iAudioStream.func_216454_a();
        this.field_216443_d = SoundSource.func_216417_a(audioFormat, 1);
        this.func_216421_a(4);
    }

    private static int func_216417_a(AudioFormat audioFormat, int n) {
        return (int)((float)(n * audioFormat.getSampleSizeInBits()) / 8.0f * (float)audioFormat.getChannels() * audioFormat.getSampleRate());
    }

    private void func_216421_a(int n2) {
        if (this.field_216444_e != null) {
            try {
                for (\u2603 = 0; \u2603 < n2; ++\u2603) {
                    ByteBuffer byteBuffer = this.field_216444_e.func_216455_a(this.field_216443_d);
                    if (byteBuffer == null) continue;
                    new AudioStreamBuffer(byteBuffer, this.field_216444_e.func_216454_a()).func_216472_c().ifPresent(n -> AL10.alSourceQueueBuffers((int)this.field_216441_b, (int[])new int[]{n}));
                }
            }
            catch (IOException iOException) {
                field_216440_a.error("Failed to read from audio stream", (Throwable)iOException);
            }
        }
    }

    public void func_216434_i() {
        if (this.field_216444_e != null) {
            int n = this.func_216427_k();
            this.func_216421_a(n);
        }
    }

    private int func_216427_k() {
        int n = AL10.alGetSourcei((int)this.field_216441_b, (int)4118);
        if (n > 0) {
            int[] nArray = new int[n];
            AL10.alSourceUnqueueBuffers((int)this.field_216441_b, (int[])nArray);
            ALUtils.func_216483_a("Unqueue buffers");
            AL10.alDeleteBuffers((int[])nArray);
            ALUtils.func_216483_a("Remove processed buffers");
        }
        return n;
    }
}

