/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.audio;

import com.google.common.collect.Maps;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.client.GameSettings;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.ISoundEventAccessor;
import net.minecraft.client.audio.ISoundEventListener;
import net.minecraft.client.audio.Sound;
import net.minecraft.client.audio.SoundEngine;
import net.minecraft.client.audio.SoundEventAccessor;
import net.minecraft.client.audio.SoundList;
import net.minecraft.client.audio.SoundListSerializer;
import net.minecraft.client.renderer.ActiveRenderInfo;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.resources.ReloadListener;
import net.minecraft.profiler.IProfiler;
import net.minecraft.resources.IResource;
import net.minecraft.resources.IResourceManager;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.registry.Registry;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import org.apache.commons.io.IOUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SoundHandler
extends ReloadListener<Loader> {
    public static final Sound field_147700_a = new Sound("meta:missing_sound", 1.0f, 1.0f, 1, Sound.Type.FILE, false, false, 16);
    private static final Logger field_147698_b = LogManager.getLogger();
    private static final Gson field_147699_c = new GsonBuilder().registerTypeHierarchyAdapter(ITextComponent.class, (Object)new ITextComponent.Serializer()).registerTypeAdapter(SoundList.class, (Object)new SoundListSerializer()).create();
    private static final ParameterizedType field_147696_d = new ParameterizedType(){

        @Override
        public Type[] getActualTypeArguments() {
            return new Type[]{String.class, SoundList.class};
        }

        @Override
        public Type getRawType() {
            return Map.class;
        }

        @Override
        public Type getOwnerType() {
            return null;
        }
    };
    private final Map<ResourceLocation, SoundEventAccessor> field_147697_e = Maps.newHashMap();
    private final SoundEngine field_147694_f;

    public SoundHandler(IResourceManager iResourceManager, GameSettings gameSettings) {
        this.field_147694_f = new SoundEngine(this, gameSettings, iResourceManager);
    }

    @Override
    protected Loader func_212854_a_(IResourceManager iResourceManager, IProfiler iProfiler2) {
        IProfiler iProfiler2;
        Loader loader = new Loader();
        iProfiler2.func_219894_a();
        for (String string : iResourceManager.func_199001_a()) {
            iProfiler2.func_76320_a(string);
            try {
                List<IResource> list = iResourceManager.func_199004_b(new ResourceLocation(string, "sounds.json"));
                for (IResource iResource : list) {
                    iProfiler2.func_76320_a(iResource.func_199026_d());
                    try {
                        iProfiler2.func_76320_a("parse");
                        Map<String, SoundList> map = SoundHandler.func_175085_a(iResource.func_199027_b());
                        iProfiler2.func_219895_b("register");
                        for (Map.Entry<String, SoundList> entry : map.entrySet()) {
                            loader.func_217944_a(new ResourceLocation(string, entry.getKey()), entry.getValue(), iResourceManager);
                        }
                        iProfiler2.func_76319_b();
                    }
                    catch (RuntimeException runtimeException) {
                        field_147698_b.warn("Invalid sounds.json in resourcepack: '{}'", (Object)iResource.func_199026_d(), (Object)runtimeException);
                    }
                    iProfiler2.func_76319_b();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            iProfiler2.func_76319_b();
        }
        iProfiler2.func_219897_b();
        return loader;
    }

    @Override
    protected void func_212853_a_(Loader loader, IResourceManager iResourceManager, IProfiler iProfiler) {
        loader.func_217946_a(this.field_147697_e, this.field_147694_f);
        for (ResourceLocation resourceLocation : this.field_147697_e.keySet()) {
            SoundEventAccessor soundEventAccessor = this.field_147697_e.get(resourceLocation);
            if (!(soundEventAccessor.func_188712_c() instanceof TranslationTextComponent) || I18n.func_188566_a(\u2603 = ((TranslationTextComponent)soundEventAccessor.func_188712_c()).func_150268_i())) continue;
            field_147698_b.debug("Missing subtitle {} for event: {}", (Object)\u2603, (Object)resourceLocation);
        }
        if (field_147698_b.isDebugEnabled()) {
            for (ResourceLocation resourceLocation : this.field_147697_e.keySet()) {
                if (Registry.field_212633_v.func_212607_c(resourceLocation)) continue;
                field_147698_b.debug("Not having sound event for: {}", (Object)resourceLocation);
            }
        }
        this.field_147694_f.func_148596_a();
    }

    @Nullable
    protected static Map<String, SoundList> func_175085_a(InputStream inputStream) {
        try {
            Map map = (Map)JSONUtils.func_193841_a(field_147699_c, new InputStreamReader(inputStream, StandardCharsets.UTF_8), field_147696_d);
            return map;
        }
        finally {
            IOUtils.closeQuietly((InputStream)inputStream);
        }
    }

    private static boolean func_215292_b(Sound sound, ResourceLocation resourceLocation, IResourceManager iResourceManager) {
        ResourceLocation resourceLocation2 = sound.func_188721_b();
        if (!iResourceManager.func_219533_b(resourceLocation2)) {
            field_147698_b.warn("File {} does not exist, cannot add it to event {}", (Object)resourceLocation2, (Object)resourceLocation);
            return false;
        }
        return true;
    }

    @Nullable
    public SoundEventAccessor func_184398_a(ResourceLocation resourceLocation) {
        return this.field_147697_e.get(resourceLocation);
    }

    public Collection<ResourceLocation> func_195477_a() {
        return this.field_147697_e.keySet();
    }

    public void func_147682_a(ISound iSound) {
        this.field_147694_f.func_148611_c(iSound);
    }

    public void func_147681_a(ISound iSound, int n) {
        this.field_147694_f.func_148599_a(iSound, n);
    }

    public void func_215289_a(ActiveRenderInfo activeRenderInfo) {
        this.field_147694_f.func_217920_a(activeRenderInfo);
    }

    public void func_147689_b() {
        this.field_147694_f.func_148610_e();
    }

    public void func_147690_c() {
        this.field_147694_f.func_148614_c();
    }

    public void func_147685_d() {
        this.field_147694_f.func_148613_b();
    }

    public void func_215290_a(boolean bl) {
        this.field_147694_f.func_217921_a(bl);
    }

    public void func_147687_e() {
        this.field_147694_f.func_148604_f();
    }

    public void func_184399_a(SoundCategory soundCategory, float f) {
        if (soundCategory == SoundCategory.MASTER && f <= 0.0f) {
            this.func_147690_c();
        }
        this.field_147694_f.func_188771_a(soundCategory, f);
    }

    public void func_147683_b(ISound iSound) {
        this.field_147694_f.func_148602_b(iSound);
    }

    public boolean func_215294_c(ISound iSound) {
        return this.field_147694_f.func_217933_b(iSound);
    }

    public void func_184402_a(ISoundEventListener iSoundEventListener) {
        this.field_147694_f.func_188774_a(iSoundEventListener);
    }

    public void func_184400_b(ISoundEventListener iSoundEventListener) {
        this.field_147694_f.func_188773_b(iSoundEventListener);
    }

    public void func_195478_a(@Nullable ResourceLocation resourceLocation, @Nullable SoundCategory soundCategory) {
        this.field_147694_f.func_195855_a(resourceLocation, soundCategory);
    }

    public String func_215293_f() {
        return this.field_147694_f.func_217932_f();
    }

    @Override
    protected /* synthetic */ Object func_212854_a_(IResourceManager iResourceManager, IProfiler iProfiler) {
        return this.func_212854_a_(iResourceManager, iProfiler);
    }

    public static class Loader {
        private final Map<ResourceLocation, SoundEventAccessor> field_217948_a = Maps.newHashMap();

        protected Loader() {
        }

        private void func_217944_a(ResourceLocation resourceLocation, SoundList soundList, IResourceManager iResourceManager) {
            SoundEventAccessor soundEventAccessor = this.field_217948_a.get(resourceLocation);
            boolean bl = \u2603 = soundEventAccessor == null;
            if (\u2603 || soundList.func_148574_b()) {
                if (!\u2603) {
                    field_147698_b.debug("Replaced sound event location {}", (Object)resourceLocation);
                }
                soundEventAccessor = new SoundEventAccessor(resourceLocation, soundList.func_188701_c());
                this.field_217948_a.put(resourceLocation, soundEventAccessor);
            }
            block4: for (final Sound sound : soundList.func_188700_a()) {
                ISoundEventAccessor<Sound> \u26032;
                final ResourceLocation resourceLocation2 = sound.func_188719_a();
                switch (sound.func_188722_g()) {
                    case FILE: {
                        if (!SoundHandler.func_215292_b(sound, resourceLocation, iResourceManager)) continue block4;
                        \u26032 = sound;
                        break;
                    }
                    case SOUND_EVENT: {
                        \u26032 = new ISoundEventAccessor<Sound>(){

                            @Override
                            public int func_148721_a() {
                                SoundEventAccessor soundEventAccessor = (SoundEventAccessor)field_217948_a.get(resourceLocation2);
                                return soundEventAccessor == null ? 0 : soundEventAccessor.func_148721_a();
                            }

                            @Override
                            public Sound func_148720_g() {
                                SoundEventAccessor soundEventAccessor = (SoundEventAccessor)field_217948_a.get(resourceLocation2);
                                if (soundEventAccessor == null) {
                                    return field_147700_a;
                                }
                                Sound \u26032 = soundEventAccessor.func_148720_g();
                                return new Sound(\u26032.func_188719_a().toString(), \u26032.func_188724_c() * sound.func_188724_c(), \u26032.func_188725_d() * sound.func_188725_d(), sound.func_148721_a(), Sound.Type.FILE, \u26032.func_188723_h() || sound.func_188723_h(), \u26032.func_204257_i(), \u26032.func_206255_j());
                            }

                            @Override
                            public void func_217867_a(SoundEngine soundEngine) {
                                SoundEventAccessor soundEventAccessor = (SoundEventAccessor)field_217948_a.get(resourceLocation2);
                                if (soundEventAccessor == null) {
                                    return;
                                }
                                soundEventAccessor.func_217867_a(soundEngine);
                            }

                            @Override
                            public /* synthetic */ Object func_148720_g() {
                                return this.func_148720_g();
                            }
                        };
                        break;
                    }
                    default: {
                        throw new IllegalStateException("Unknown SoundEventRegistration type: " + (Object)((Object)sound.func_188722_g()));
                    }
                }
                soundEventAccessor.func_188715_a(\u26032);
            }
        }

        public void func_217946_a(Map<ResourceLocation, SoundEventAccessor> map, SoundEngine soundEngine) {
            map.clear();
            for (Map.Entry<ResourceLocation, SoundEventAccessor> entry : this.field_217948_a.entrySet()) {
                map.put(entry.getKey(), entry.getValue());
                entry.getValue().func_217867_a(soundEngine);
            }
        }
    }
}

