/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client;

import com.google.common.collect.Multimap;
import com.google.common.collect.Queues;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.GameProfileRepository;
import com.mojang.authlib.minecraft.MinecraftSessionService;
import com.mojang.authlib.properties.PropertyMap;
import com.mojang.authlib.yggdrasil.YggdrasilAuthenticationService;
import com.mojang.blaze3d.platform.GLX;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.datafixers.DataFixer;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.Proxy;
import java.net.SocketAddress;
import java.nio.ByteOrder;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Queue;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRenderType;
import net.minecraft.block.BlockState;
import net.minecraft.client.ClientBrandRetriever;
import net.minecraft.client.GameConfiguration;
import net.minecraft.client.GameSettings;
import net.minecraft.client.KeyboardListener;
import net.minecraft.client.MainWindow;
import net.minecraft.client.MinecraftGame;
import net.minecraft.client.MouseHelper;
import net.minecraft.client.audio.MusicTicker;
import net.minecraft.client.audio.SoundHandler;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.IngameGui;
import net.minecraft.client.gui.LoadingGui;
import net.minecraft.client.gui.ResourceLoadProgressGui;
import net.minecraft.client.gui.ScreenManager;
import net.minecraft.client.gui.advancements.AdvancementsScreen;
import net.minecraft.client.gui.chat.NarratorChatListener;
import net.minecraft.client.gui.fonts.FontResourceManager;
import net.minecraft.client.gui.recipebook.RecipeList;
import net.minecraft.client.gui.screen.ChatScreen;
import net.minecraft.client.gui.screen.ConnectingScreen;
import net.minecraft.client.gui.screen.DeathScreen;
import net.minecraft.client.gui.screen.DirtMessageScreen;
import net.minecraft.client.gui.screen.IngameMenuScreen;
import net.minecraft.client.gui.screen.MainMenuScreen;
import net.minecraft.client.gui.screen.MemoryErrorScreen;
import net.minecraft.client.gui.screen.MultiplayerScreen;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.screen.SleepInMultiplayerScreen;
import net.minecraft.client.gui.screen.WinGameScreen;
import net.minecraft.client.gui.screen.WorkingScreen;
import net.minecraft.client.gui.screen.WorldLoadProgressScreen;
import net.minecraft.client.gui.screen.inventory.CreativeScreen;
import net.minecraft.client.gui.screen.inventory.InventoryScreen;
import net.minecraft.client.gui.toasts.ToastGui;
import net.minecraft.client.multiplayer.PlayerController;
import net.minecraft.client.multiplayer.ServerData;
import net.minecraft.client.network.login.ClientLoginNetHandler;
import net.minecraft.client.network.play.ClientPlayNetHandler;
import net.minecraft.client.particle.ParticleManager;
import net.minecraft.client.renderer.BlockModelShapes;
import net.minecraft.client.renderer.BlockRendererDispatcher;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.FirstPersonRenderer;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.GlDebugTextUtils;
import net.minecraft.client.renderer.IWindowEventListener;
import net.minecraft.client.renderer.ItemRenderer;
import net.minecraft.client.renderer.ScreenSize;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.VirtualScreen;
import net.minecraft.client.renderer.WorldRenderer;
import net.minecraft.client.renderer.chunk.ChunkRender;
import net.minecraft.client.renderer.color.BlockColors;
import net.minecraft.client.renderer.color.ItemColors;
import net.minecraft.client.renderer.debug.DebugRenderer;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.model.ModelManager;
import net.minecraft.client.renderer.texture.AtlasTexture;
import net.minecraft.client.renderer.texture.PaintingSpriteUploader;
import net.minecraft.client.renderer.texture.PotionSpriteUploader;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.resources.ClientResourcePackInfo;
import net.minecraft.client.resources.DownloadingPackFinder;
import net.minecraft.client.resources.FoliageColorReloadListener;
import net.minecraft.client.resources.GrassColorReloadListener;
import net.minecraft.client.resources.LanguageManager;
import net.minecraft.client.resources.LegacyResourcePackWrapper;
import net.minecraft.client.resources.SkinManager;
import net.minecraft.client.settings.AbstractOption;
import net.minecraft.client.settings.AmbientOcclusionStatus;
import net.minecraft.client.settings.CloudOption;
import net.minecraft.client.settings.CreativeSettings;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.client.shader.Framebuffer;
import net.minecraft.client.tutorial.Tutorial;
import net.minecraft.client.util.IMutableSearchTree;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.client.util.SearchTree;
import net.minecraft.client.util.SearchTreeManager;
import net.minecraft.client.util.SearchTreeReloadable;
import net.minecraft.client.util.Splashes;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.crash.CrashReport;
import net.minecraft.crash.CrashReportCategory;
import net.minecraft.crash.ReportedException;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.ArmorStandEntity;
import net.minecraft.entity.item.BoatEntity;
import net.minecraft.entity.item.EnderCrystalEntity;
import net.minecraft.entity.item.ItemFrameEntity;
import net.minecraft.entity.item.LeashKnotEntity;
import net.minecraft.entity.item.PaintingEntity;
import net.minecraft.entity.item.minecart.AbstractMinecartEntity;
import net.minecraft.entity.player.ChatVisibility;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.SkullItem;
import net.minecraft.item.SpawnEggItem;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.nbt.StringNBT;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.ProtocolType;
import net.minecraft.network.handshake.client.CHandshakePacket;
import net.minecraft.network.login.client.CLoginStartPacket;
import net.minecraft.network.play.client.CPlayerDiggingPacket;
import net.minecraft.profiler.DataPoint;
import net.minecraft.profiler.DebugProfiler;
import net.minecraft.profiler.IProfileResult;
import net.minecraft.profiler.IProfiler;
import net.minecraft.profiler.ISnooperInfo;
import net.minecraft.profiler.Snooper;
import net.minecraft.resources.FolderPackFinder;
import net.minecraft.resources.IReloadableResourceManager;
import net.minecraft.resources.IResourceManager;
import net.minecraft.resources.IResourcePack;
import net.minecraft.resources.ResourcePackInfo;
import net.minecraft.resources.ResourcePackList;
import net.minecraft.resources.ResourcePackType;
import net.minecraft.resources.SimpleReloadableResourceManager;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.integrated.IntegratedServer;
import net.minecraft.server.management.PlayerProfileCache;
import net.minecraft.tags.ItemTags;
import net.minecraft.tileentity.SkullTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.DefaultUncaughtExceptionHandler;
import net.minecraft.util.Direction;
import net.minecraft.util.FrameTimer;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Session;
import net.minecraft.util.SharedConstants;
import net.minecraft.util.Timer;
import net.minecraft.util.Unit;
import net.minecraft.util.Util;
import net.minecraft.util.concurrent.RecursiveEventLoop;
import net.minecraft.util.datafix.DataFixesManager;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.registry.Bootstrap;
import net.minecraft.util.registry.Registry;
import net.minecraft.util.text.KeybindTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.Difficulty;
import net.minecraft.world.WorldSettings;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.listener.ChainedChunkStatusListener;
import net.minecraft.world.chunk.listener.TrackingChunkStatusListener;
import net.minecraft.world.dimension.EndDimension;
import net.minecraft.world.dimension.NetherDimension;
import net.minecraft.world.storage.SaveFormat;
import net.minecraft.world.storage.SaveHandler;
import net.minecraft.world.storage.WorldInfo;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Minecraft
extends RecursiveEventLoop<Runnable>
implements ISnooperInfo,
IWindowEventListener,
AutoCloseable {
    private static final Logger field_147123_G = LogManager.getLogger();
    public static final boolean field_142025_a = Util.func_110647_a() == Util.OS.OSX;
    public static final ResourceLocation field_211502_b = new ResourceLocation("default");
    public static final ResourceLocation field_71464_q = new ResourceLocation("alt");
    private static final CompletableFuture<Unit> field_223714_G = CompletableFuture.completedFuture(Unit.INSTANCE);
    public static byte[] field_71444_a = new byte[0xA00000];
    private static int field_211120_F = -1;
    private final File field_130070_K;
    private final PropertyMap field_181038_N;
    private final ScreenSize field_195556_O;
    private ServerData field_71422_O;
    private TextureManager field_71446_o;
    private static Minecraft field_71432_P;
    private final DataFixer field_184131_U;
    public PlayerController field_71442_b;
    private VirtualScreen field_195557_T;
    public MainWindow field_195558_d;
    private boolean field_71434_R;
    private CrashReport field_71433_S;
    private boolean field_181541_X;
    private final Timer field_71428_T = new Timer(20.0f, 0L);
    private final Snooper field_71427_U = new Snooper("client", this, Util.func_211177_b());
    public ClientWorld field_71441_e;
    public WorldRenderer field_71438_f;
    private EntityRendererManager field_175616_W;
    private ItemRenderer field_175621_X;
    private FirstPersonRenderer field_175620_Y;
    public ClientPlayerEntity field_71439_g;
    @Nullable
    public Entity field_175622_Z;
    @Nullable
    public Entity field_147125_j;
    public ParticleManager field_71452_i;
    private final SearchTreeManager field_193995_ae = new SearchTreeManager();
    private final Session field_71449_j;
    private boolean field_71445_n;
    private float field_193996_ah;
    public FontRenderer field_71466_p;
    @Nullable
    public Screen field_71462_r;
    @Nullable
    public LoadingGui field_213279_p;
    public GameRenderer field_71460_t;
    public DebugRenderer field_184132_p;
    protected int field_71429_W;
    @Nullable
    private IntegratedServer field_71437_Z;
    private final AtomicReference<TrackingChunkStatusListener> field_213277_ad = new AtomicReference();
    public IngameGui field_71456_v;
    public boolean field_71454_w;
    public RayTraceResult field_71476_x;
    public GameSettings field_71474_y;
    private CreativeSettings field_191950_u;
    public MouseHelper field_71417_B;
    public KeyboardListener field_195559_v;
    public final File field_71412_D;
    private final File field_110446_Y;
    private final String field_110447_Z;
    private final String field_184130_ao;
    private final Proxy field_110453_aa;
    private SaveFormat field_71469_aa;
    private static int field_71470_ab;
    private int field_71467_ac;
    private String field_71475_ae;
    private int field_71477_af;
    public final FrameTimer field_181542_y = new FrameTimer();
    private long field_181543_z = Util.func_211178_c();
    private final boolean field_147129_ai;
    private final boolean field_71459_aj;
    @Nullable
    private NetworkManager field_71453_ak;
    private boolean field_71455_al;
    private final DebugProfiler field_71424_I = new DebugProfiler(() -> this.field_71428_T.field_74280_b);
    private IReloadableResourceManager field_110451_am;
    private final DownloadingPackFinder field_195554_ax;
    private final ResourcePackList<ClientResourcePackInfo> field_110448_aq;
    private LanguageManager field_135017_as;
    private BlockColors field_184127_aH;
    private ItemColors field_184128_aI;
    private Framebuffer field_147124_at;
    private AtlasTexture field_147128_au;
    private SoundHandler field_147127_av;
    private MusicTicker field_147126_aw;
    private FontResourceManager field_211501_aD;
    private Splashes field_213271_aF;
    private final MinecraftSessionService field_152355_az;
    private SkinManager field_152350_aA;
    private final Thread field_152352_aC = Thread.currentThread();
    private ModelManager field_175617_aL;
    private BlockRendererDispatcher field_175618_aM;
    private PaintingSpriteUploader field_213272_aL;
    private PotionSpriteUploader field_213273_aM;
    private final ToastGui field_193034_aS;
    private final MinecraftGame field_213274_aO = new MinecraftGame(this);
    private volatile boolean field_71425_J = true;
    public String field_71426_K = "";
    public boolean field_175612_E = true;
    private long field_71419_L;
    private int field_71420_M;
    private final Tutorial field_193035_aW;
    private boolean field_195555_I;
    private final Queue<Runnable> field_213275_aU = Queues.newConcurrentLinkedQueue();
    private CompletableFuture<Void> field_213276_aV;
    private String field_71465_an = "root";

    public Minecraft(GameConfiguration gameConfiguration) {
        super("Client");
        this.field_195556_O = gameConfiguration.field_178743_b;
        field_71432_P = this;
        this.field_71412_D = gameConfiguration.field_178744_c.field_178760_a;
        this.field_110446_Y = gameConfiguration.field_178744_c.field_178759_c;
        this.field_130070_K = gameConfiguration.field_178744_c.field_178758_b;
        this.field_110447_Z = gameConfiguration.field_178741_d.field_178755_b;
        this.field_184130_ao = gameConfiguration.field_178741_d.field_187053_c;
        this.field_181038_N = gameConfiguration.field_178745_a.field_181172_c;
        this.field_195554_ax = new DownloadingPackFinder(new File(this.field_71412_D, "server-resource-packs"), gameConfiguration.field_178744_c.func_187052_a());
        this.field_110448_aq = new ResourcePackList<ClientResourcePackInfo>((string, bl, supplier, iResourcePack, packMetadataSection, priority) -> {
            Supplier<IResourcePack> supplier2 = packMetadataSection.func_198962_b() < SharedConstants.func_215069_a().getPackVersion() ? () -> Minecraft.func_213270_b((Supplier)supplier) : supplier;
            return new ClientResourcePackInfo(string, bl, supplier2, iResourcePack, packMetadataSection, priority);
        });
        this.field_110448_aq.func_198982_a(this.field_195554_ax);
        this.field_110448_aq.func_198982_a(new FolderPackFinder(this.field_130070_K));
        this.field_110453_aa = gameConfiguration.field_178745_a.field_178751_c == null ? Proxy.NO_PROXY : gameConfiguration.field_178745_a.field_178751_c;
        this.field_152355_az = new YggdrasilAuthenticationService(this.field_110453_aa, UUID.randomUUID().toString()).createMinecraftSessionService();
        this.field_71449_j = gameConfiguration.field_178745_a.field_178752_a;
        field_147123_G.info("Setting user: {}", (Object)this.field_71449_j.func_111285_a());
        field_147123_G.debug("(Session ID is {})", (Object)this.field_71449_j.func_111286_b());
        this.field_71459_aj = gameConfiguration.field_178741_d.field_178756_a;
        this.field_147129_ai = Minecraft.func_147122_X();
        this.field_71437_Z = null;
        if (gameConfiguration.field_178742_e.field_178754_a != null) {
            this.field_71475_ae = gameConfiguration.field_178742_e.field_178754_a;
            this.field_71477_af = gameConfiguration.field_178742_e.field_178753_b;
        }
        Bootstrap.func_151354_b();
        Bootstrap.func_218821_c();
        KeybindTextComponent.field_193637_b = KeyBinding::func_193626_b;
        this.field_184131_U = DataFixesManager.func_210901_a();
        this.field_193034_aS = new ToastGui(this);
        this.field_193035_aW = new Tutorial(this);
    }

    public void func_99999_d() {
        this.field_71425_J = true;
        try {
            this.func_71384_a();
        }
        catch (Throwable throwable) {
            CrashReport crashReport = CrashReport.func_85055_a(throwable, "Initializing game");
            crashReport.func_85058_a("Initialization");
            this.func_71377_b(this.func_71396_d(crashReport));
            return;
        }
        try {
            boolean bl = false;
            while (this.field_71425_J) {
                if (this.field_71434_R && this.field_71433_S != null) {
                    this.func_71377_b(this.field_71433_S);
                    return;
                }
                try {
                    this.func_195542_b(!bl);
                }
                catch (OutOfMemoryError outOfMemoryError) {
                    if (bl) {
                        throw outOfMemoryError;
                    }
                    this.func_71398_f();
                    this.func_147108_a(new MemoryErrorScreen());
                    System.gc();
                    field_147123_G.fatal("Out of memory", (Throwable)outOfMemoryError);
                    bl = true;
                }
            }
        }
        catch (ReportedException reportedException) {
            this.func_71396_d(reportedException.func_71575_a());
            this.func_71398_f();
            field_147123_G.fatal("Reported exception thrown!", (Throwable)reportedException);
            this.func_71377_b(reportedException.func_71575_a());
        }
        catch (Throwable throwable) {
            CrashReport crashReport = this.func_71396_d(new CrashReport("Unexpected error", throwable));
            field_147123_G.fatal("Unreported exception thrown!", throwable);
            this.func_71398_f();
            this.func_71377_b(crashReport);
        }
        finally {
            this.func_71405_e();
        }
    }

    private void func_71384_a() {
        Object object;
        this.field_71474_y = new GameSettings(this, this.field_71412_D);
        this.field_191950_u = new CreativeSettings(this.field_71412_D, this.field_184131_U);
        this.func_71389_H();
        field_147123_G.info("LWJGL Version: {}", (Object)GLX.getLWJGLVersion());
        ScreenSize screenSize = this.field_195556_O;
        if (this.field_71474_y.field_92119_C > 0 && this.field_71474_y.field_92118_B > 0) {
            screenSize = new ScreenSize(this.field_71474_y.field_92118_B, this.field_71474_y.field_92119_C, screenSize.field_216496_c, screenSize.field_216497_d, screenSize.field_216498_e);
        }
        if ((\u2603 = GLX.initGlfw()) != null) {
            Util.field_211180_a = \u2603;
        }
        this.field_195557_T = new VirtualScreen(this);
        this.field_195558_d = this.field_195557_T.func_217626_a(screenSize, this.field_71474_y.field_198019_u, "Minecraft " + SharedConstants.func_215069_a().getName());
        this.func_213228_a(true);
        try {
            object = this.func_195541_I().func_195746_a().func_195761_a(ResourcePackType.CLIENT_RESOURCES, new ResourceLocation("icons/icon_16x16.png"));
            InputStream \u26032 = this.func_195541_I().func_195746_a().func_195761_a(ResourcePackType.CLIENT_RESOURCES, new ResourceLocation("icons/icon_32x32.png"));
            this.field_195558_d.func_216529_a((InputStream)object, \u26032);
        }
        catch (IOException iOException) {
            field_147123_G.error("Couldn't set icon", (Throwable)iOException);
        }
        this.field_195558_d.func_216526_a(this.field_71474_y.field_74350_i);
        this.field_71417_B = new MouseHelper(this);
        this.field_71417_B.func_198029_a(this.field_195558_d.func_198092_i());
        this.field_195559_v = new KeyboardListener(this);
        this.field_195559_v.func_197968_a(this.field_195558_d.func_198092_i());
        GLX.init();
        GlDebugTextUtils.func_209247_b(this.field_71474_y.field_209231_W, false);
        this.field_147124_at = new Framebuffer(this.field_195558_d.func_198109_k(), this.field_195558_d.func_198091_l(), true, field_142025_a);
        this.field_147124_at.func_147604_a(0.0f, 0.0f, 0.0f, 0.0f);
        this.field_110451_am = new SimpleReloadableResourceManager(ResourcePackType.CLIENT_RESOURCES, this.field_152352_aC);
        this.field_71474_y.func_198017_a(this.field_110448_aq);
        this.field_110448_aq.func_198983_a();
        object = this.field_110448_aq.func_198980_d().stream().map(ResourcePackInfo::func_195796_e).collect(Collectors.toList());
        Iterator iterator = object.iterator();
        while (iterator.hasNext()) {
            IResourcePack iResourcePack = (IResourcePack)iterator.next();
            this.field_110451_am.func_199021_a(iResourcePack);
        }
        this.field_135017_as = new LanguageManager(this.field_71474_y.field_74363_ab);
        this.field_110451_am.func_219534_a(this.field_135017_as);
        this.field_135017_as.func_135043_a((List<IResourcePack>)object);
        this.field_71446_o = new TextureManager(this.field_110451_am);
        this.field_110451_am.func_219534_a(this.field_71446_o);
        this.func_213226_a();
        this.field_152350_aA = new SkinManager(this.field_71446_o, new File(this.field_110446_Y, "skins"), this.field_152355_az);
        this.field_71469_aa = new SaveFormat(this.field_71412_D.toPath().resolve("saves"), this.field_71412_D.toPath().resolve("backups"), this.field_184131_U);
        this.field_147127_av = new SoundHandler(this.field_110451_am, this.field_71474_y);
        this.field_110451_am.func_219534_a(this.field_147127_av);
        this.field_213271_aF = new Splashes(this.field_71449_j);
        this.field_110451_am.func_219534_a(this.field_213271_aF);
        this.field_147126_aw = new MusicTicker(this);
        this.field_211501_aD = new FontResourceManager(this.field_71446_o, this.func_211821_e());
        this.field_110451_am.func_219534_a(this.field_211501_aD.func_216884_a());
        this.field_71466_p = this.field_211501_aD.func_211504_a(field_211502_b);
        if (this.field_71474_y.field_74363_ab != null) {
            this.field_71466_p.func_78275_b(this.field_135017_as.func_135044_b());
        }
        this.field_110451_am.func_219534_a(new GrassColorReloadListener());
        this.field_110451_am.func_219534_a(new FoliageColorReloadListener());
        this.field_195558_d.func_198076_a("Startup");
        GlStateManager.enableTexture();
        GlStateManager.shadeModel(7425);
        GlStateManager.clearDepth(1.0);
        GlStateManager.enableDepthTest();
        GlStateManager.depthFunc(515);
        GlStateManager.enableAlphaTest();
        GlStateManager.alphaFunc(516, 0.1f);
        GlStateManager.cullFace(GlStateManager.CullFace.BACK);
        GlStateManager.matrixMode(5889);
        GlStateManager.loadIdentity();
        GlStateManager.matrixMode(5888);
        this.field_195558_d.func_198076_a("Post startup");
        this.field_147128_au = new AtlasTexture("textures");
        this.field_147128_au.func_147633_a(this.field_71474_y.field_151442_I);
        this.field_71446_o.func_110580_a(AtlasTexture.field_110575_b, this.field_147128_au);
        this.field_71446_o.func_110577_a(AtlasTexture.field_110575_b);
        this.field_147128_au.func_174937_a(false, this.field_71474_y.field_151442_I > 0);
        this.field_184127_aH = BlockColors.func_186723_a();
        this.field_184128_aI = ItemColors.func_186729_a(this.field_184127_aH);
        this.field_175617_aL = new ModelManager(this.field_147128_au, this.field_184127_aH);
        this.field_110451_am.func_219534_a(this.field_175617_aL);
        this.field_175621_X = new ItemRenderer(this.field_71446_o, this.field_175617_aL, this.field_184128_aI);
        this.field_175616_W = new EntityRendererManager(this.field_71446_o, this.field_175621_X, this.field_110451_am);
        this.field_175620_Y = new FirstPersonRenderer(this);
        this.field_110451_am.func_219534_a(this.field_175621_X);
        this.field_71460_t = new GameRenderer(this, this.field_110451_am);
        this.field_110451_am.func_219534_a(this.field_71460_t);
        this.field_175618_aM = new BlockRendererDispatcher(this.field_175617_aL.func_174954_c(), this.field_184127_aH);
        this.field_110451_am.func_219534_a(this.field_175618_aM);
        this.field_71438_f = new WorldRenderer(this);
        this.field_110451_am.func_219534_a(this.field_71438_f);
        this.func_193986_ar();
        this.field_110451_am.func_219534_a(this.field_193995_ae);
        GlStateManager.viewport(0, 0, this.field_195558_d.func_198109_k(), this.field_195558_d.func_198091_l());
        this.field_71452_i = new ParticleManager(this.field_71441_e, this.field_71446_o);
        this.field_110451_am.func_219534_a(this.field_71452_i);
        this.field_213272_aL = new PaintingSpriteUploader(this.field_71446_o);
        this.field_110451_am.func_219534_a(this.field_213272_aL);
        this.field_213273_aM = new PotionSpriteUploader(this.field_71446_o);
        this.field_110451_am.func_219534_a(this.field_213273_aM);
        this.field_71456_v = new IngameGui(this);
        this.field_184132_p = new DebugRenderer(this);
        GLX.setGlfwErrorCallback(this::func_195545_a);
        if (this.field_71474_y.field_74353_u && !this.field_195558_d.func_198113_j()) {
            this.field_195558_d.func_198077_g();
            this.field_71474_y.field_74353_u = this.field_195558_d.func_198113_j();
        }
        this.field_195558_d.func_216523_b(this.field_71474_y.field_74352_v);
        this.field_195558_d.func_224798_d(this.field_71474_y.field_225307_E);
        this.field_195558_d.func_198112_b();
        if (this.field_71475_ae != null) {
            this.func_147108_a(new ConnectingScreen(new MainMenuScreen(), this, this.field_71475_ae, this.field_71477_af));
        } else {
            this.func_147108_a(new MainMenuScreen(true));
        }
        ResourceLoadProgressGui.func_212970_a(this);
        this.func_213268_a(new ResourceLoadProgressGui(this, this.field_110451_am.func_219535_a(Util.func_215072_e(), this, field_223714_G), () -> {
            if (SharedConstants.field_206244_b) {
                this.func_213256_aB();
            }
        }, false));
    }

    private void func_193986_ar() {
        SearchTree<ItemStack> searchTree = new SearchTree<ItemStack>(itemStack -> itemStack.func_82840_a(null, ITooltipFlag.TooltipFlags.NORMAL).stream().map(iTextComponent -> TextFormatting.func_110646_a(iTextComponent.getString()).trim()).filter(string -> !string.isEmpty()), itemStack -> Stream.of(Registry.field_212630_s.func_177774_c(itemStack.func_77973_b())));
        SearchTreeReloadable<ItemStack> \u26032 = new SearchTreeReloadable<ItemStack>(itemStack -> ItemTags.func_199903_a().func_199913_a(itemStack.func_77973_b()).stream());
        NonNullList<ItemStack> \u26033 = NonNullList.func_191196_a();
        for (Item item : Registry.field_212630_s) {
            item.func_150895_a(ItemGroup.field_78027_g, \u26033);
        }
        \u26033.forEach(itemStack -> {
            searchTree.func_217872_a((ItemStack)itemStack);
            \u26032.func_217872_a((ItemStack)itemStack);
        });
        SearchTree<RecipeList> \u26034 = new SearchTree<RecipeList>(recipeList -> recipeList.func_192711_b().stream().flatMap(iRecipe -> iRecipe.func_77571_b().func_82840_a(null, ITooltipFlag.TooltipFlags.NORMAL).stream()).map(iTextComponent -> TextFormatting.func_110646_a(iTextComponent.getString()).trim()).filter(string -> !string.isEmpty()), recipeList -> recipeList.func_192711_b().stream().map(iRecipe -> Registry.field_212630_s.func_177774_c(iRecipe.func_77571_b().func_77973_b())));
        this.field_193995_ae.func_215357_a(SearchTreeManager.field_215359_a, searchTree);
        this.field_193995_ae.func_215357_a(SearchTreeManager.field_215360_b, \u26032);
        this.field_193995_ae.func_215357_a(SearchTreeManager.field_194012_b, \u26034);
    }

    private void func_195545_a(int n, long l) {
        this.field_71474_y.field_74352_v = false;
        this.field_71474_y.func_74303_b();
    }

    private static boolean func_147122_X() {
        String[] stringArray;
        for (String \u26032 : stringArray = new String[]{"sun.arch.data.model", "com.ibm.vm.bitmode", "os.arch"}) {
            String string = System.getProperty(\u26032);
            if (string == null || !string.contains("64")) continue;
            return true;
        }
        return false;
    }

    public Framebuffer func_147110_a() {
        return this.field_147124_at;
    }

    public String func_175600_c() {
        return this.field_110447_Z;
    }

    public String func_184123_d() {
        return this.field_184130_ao;
    }

    private void func_71389_H() {
        Thread thread = new Thread("Timer hack thread"){

            @Override
            public void run() {
                while (Minecraft.this.field_71425_J) {
                    try {
                        Thread.sleep(Integer.MAX_VALUE);
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
        };
        thread.setDaemon(true);
        thread.setUncaughtExceptionHandler(new DefaultUncaughtExceptionHandler(field_147123_G));
        thread.start();
    }

    public void func_71404_a(CrashReport crashReport) {
        this.field_71434_R = true;
        this.field_71433_S = crashReport;
    }

    public void func_71377_b(CrashReport crashReport) {
        File file = new File(Minecraft.func_71410_x().field_71412_D, "crash-reports");
        \u2603 = new File(file, "crash-" + new SimpleDateFormat("yyyy-MM-dd_HH.mm.ss").format(new Date()) + "-client.txt");
        Bootstrap.func_179870_a(crashReport.func_71502_e());
        if (crashReport.func_71497_f() != null) {
            Bootstrap.func_179870_a("#@!@# Game crashed! Crash report saved to: #@!@# " + crashReport.func_71497_f());
            System.exit(-1);
        } else if (crashReport.func_147149_a(\u2603)) {
            Bootstrap.func_179870_a("#@!@# Game crashed! Crash report saved to: #@!@# " + \u2603.getAbsolutePath());
            System.exit(-1);
        } else {
            Bootstrap.func_179870_a("#@?@# Game crashed! Crash report could not be saved. #@?@#");
            System.exit(-2);
        }
    }

    public boolean func_211821_e() {
        return this.field_71474_y.field_211842_aO;
    }

    public CompletableFuture<Void> func_213237_g() {
        if (this.field_213276_aV != null) {
            return this.field_213276_aV;
        }
        CompletableFuture<Void> completableFuture = new CompletableFuture<Void>();
        if (this.field_213279_p instanceof ResourceLoadProgressGui) {
            this.field_213276_aV = completableFuture;
            return completableFuture;
        }
        this.field_110448_aq.func_198983_a();
        List<IResourcePack> \u26032 = this.field_110448_aq.func_198980_d().stream().map(ResourcePackInfo::func_195796_e).collect(Collectors.toList());
        this.func_213268_a(new ResourceLoadProgressGui(this, this.field_110451_am.func_219537_a(Util.func_215072_e(), this, field_223714_G, \u26032), () -> {
            this.field_135017_as.func_135043_a(\u26032);
            if (this.field_71438_f != null) {
                this.field_71438_f.func_72712_a();
            }
            completableFuture.complete(null);
        }, true));
        return completableFuture;
    }

    private void func_213256_aB() {
        boolean bl = false;
        BlockModelShapes \u26032 = this.func_175602_ab().func_175023_a();
        IBakedModel \u26033 = \u26032.func_178126_b().func_174951_a();
        for (Block block : Registry.field_212618_g) {
            for (Object object : block.func_176194_O().func_177619_a()) {
                if (((BlockState)object).func_185901_i() != BlockRenderType.MODEL || (object = \u26032.func_178125_b((BlockState)object)) != \u26033) continue;
                field_147123_G.debug("Missing model for: {}", object);
                bl = true;
            }
        }
        TextureAtlasSprite textureAtlasSprite = \u26033.func_177554_e();
        for (Block block : Registry.field_212618_g) {
            for (Object object : block.func_176194_O().func_177619_a()) {
                object2 = \u26032.func_178122_a((BlockState)object);
                if (((BlockState)object).func_196958_f() || object2 != textureAtlasSprite) continue;
                field_147123_G.debug("Missing particle icon for: {}", object);
                bl = true;
            }
        }
        NonNullList<ItemStack> nonNullList = NonNullList.func_191196_a();
        for (Object object : Registry.field_212630_s) {
            nonNullList.clear();
            ((Item)object).func_150895_a(ItemGroup.field_78027_g, nonNullList);
            for (Object object2 : nonNullList) {
                String string = ((ItemStack)object2).func_77977_a();
                \u2603 = new TranslationTextComponent(string, new Object[0]).getString();
                if (!\u2603.toLowerCase(Locale.ROOT).equals(((Item)object).func_77658_a())) continue;
                field_147123_G.debug("Missing translation for: {} {} {}", object2, (Object)string, (Object)((ItemStack)object2).func_77973_b());
            }
        }
        if (bl |= ScreenManager.func_216910_a()) {
            throw new IllegalStateException("Your game data is foobar, fix the errors above!");
        }
    }

    public SaveFormat func_71359_d() {
        return this.field_71469_aa;
    }

    public void func_147108_a(@Nullable Screen screen) {
        if (this.field_71462_r != null) {
            this.field_71462_r.removed();
        }
        if (screen == null && this.field_71441_e == null) {
            screen = new MainMenuScreen();
        } else if (screen == null && this.field_71439_g.func_110143_aJ() <= 0.0f) {
            screen = new DeathScreen(null, this.field_71441_e.func_72912_H().func_76093_s());
        }
        if (screen instanceof MainMenuScreen || screen instanceof MultiplayerScreen) {
            this.field_71474_y.field_74330_P = false;
            this.field_71456_v.func_146158_b().func_146231_a(true);
        }
        this.field_71462_r = screen;
        if (screen != null) {
            this.field_71417_B.func_198032_j();
            KeyBinding.func_74506_a();
            screen.init(this, this.field_195558_d.func_198107_o(), this.field_195558_d.func_198087_p());
            this.field_71454_w = false;
            NarratorChatListener.field_193643_a.func_216864_a(screen.getNarrationMessage());
        } else {
            this.field_147127_av.func_147687_e();
            this.field_71417_B.func_198034_i();
        }
    }

    public void func_213268_a(@Nullable LoadingGui loadingGui) {
        this.field_213279_p = loadingGui;
    }

    public void func_71405_e() {
        try {
            field_147123_G.info("Stopping!");
            NarratorChatListener.field_193643_a.func_216867_c();
            try {
                if (this.field_71441_e != null) {
                    this.field_71441_e.func_72882_A();
                }
                this.func_213254_o();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            if (this.field_71462_r != null) {
                this.field_71462_r.removed();
            }
            this.close();
        }
        finally {
            Util.field_211180_a = System::nanoTime;
            if (!this.field_71434_R) {
                System.exit(0);
            }
        }
    }

    @Override
    public void close() {
        try {
            this.field_147128_au.func_195419_g();
            this.field_71466_p.close();
            this.field_211501_aD.close();
            this.field_71460_t.close();
            this.field_71438_f.close();
            this.field_147127_av.func_147685_d();
            this.field_110448_aq.close();
            this.field_71452_i.func_215232_a();
            this.field_213273_aM.close();
            this.field_213272_aL.close();
            Util.func_215082_f();
        }
        finally {
            this.field_195557_T.close();
            this.field_195558_d.close();
        }
    }

    private void func_195542_b(boolean bl) {
        Object object;
        this.field_195558_d.func_198076_a("Pre render");
        long l = Util.func_211178_c();
        this.field_71424_I.func_219894_a();
        if (GLX.shouldClose(this.field_195558_d)) {
            this.func_71400_g();
        }
        if (this.field_213276_aV != null && !(this.field_213279_p instanceof ResourceLoadProgressGui)) {
            object = this.field_213276_aV;
            this.field_213276_aV = null;
            this.func_213237_g().thenRun(() -> Minecraft.func_213265_b((CompletableFuture)object));
        }
        while ((object = this.field_213275_aU.poll()) != null) {
            object.run();
        }
        if (bl) {
            this.field_71428_T.func_74275_a(Util.func_211177_b());
            this.field_71424_I.func_76320_a("scheduledExecutables");
            this.func_213160_bf();
            this.field_71424_I.func_76319_b();
        }
        long \u26032 = Util.func_211178_c();
        this.field_71424_I.func_76320_a("tick");
        if (bl) {
            for (int i = 0; i < Math.min(10, this.field_71428_T.field_74280_b); ++i) {
                this.func_71407_l();
            }
        }
        this.field_71417_B.func_198028_a();
        this.field_195558_d.func_198076_a("Render");
        GLX.pollEvents();
        long l2 = Util.func_211178_c() - \u26032;
        this.field_71424_I.func_219895_b("sound");
        this.field_147127_av.func_215289_a(this.field_71460_t.func_215316_n());
        this.field_71424_I.func_76319_b();
        this.field_71424_I.func_76320_a("render");
        GlStateManager.pushMatrix();
        GlStateManager.clear(16640, field_142025_a);
        this.field_147124_at.func_147610_a(true);
        this.field_71424_I.func_76320_a("display");
        GlStateManager.enableTexture();
        this.field_71424_I.func_76319_b();
        if (!this.field_71454_w) {
            this.field_71424_I.func_219895_b("gameRenderer");
            this.field_71460_t.func_195458_a(this.field_71445_n ? this.field_193996_ah : this.field_71428_T.field_194147_b, l, bl);
            this.field_71424_I.func_219895_b("toasts");
            this.field_193034_aS.func_195625_a();
            this.field_71424_I.func_76319_b();
        }
        this.field_71424_I.func_219897_b();
        if (this.field_71474_y.field_74330_P && this.field_71474_y.field_74329_Q && !this.field_71474_y.field_74319_N) {
            this.field_71424_I.func_219899_d().func_219939_d();
            this.func_203410_as();
        } else {
            this.field_71424_I.func_219899_d().func_219938_b();
        }
        this.field_147124_at.func_147609_e();
        GlStateManager.popMatrix();
        GlStateManager.pushMatrix();
        this.field_147124_at.func_147615_c(this.field_195558_d.func_198109_k(), this.field_195558_d.func_198091_l());
        GlStateManager.popMatrix();
        this.field_71424_I.func_219894_a();
        this.func_213227_b(true);
        Thread.yield();
        this.field_195558_d.func_198076_a("Post render");
        ++this.field_71420_M;
        boolean bl2 = \u2603 = this.func_71356_B() && (this.field_71462_r != null && this.field_71462_r.isPauseScreen() || this.field_213279_p != null && this.field_213279_p.func_212969_a()) && !this.field_71437_Z.func_71344_c();
        if (this.field_71445_n != \u2603) {
            if (this.field_71445_n) {
                this.field_193996_ah = this.field_71428_T.field_194147_b;
            } else {
                this.field_71428_T.field_194147_b = this.field_193996_ah;
            }
            this.field_71445_n = \u2603;
        }
        \u2603 = Util.func_211178_c();
        this.field_181542_y.func_181747_a(\u2603 - this.field_181543_z);
        this.field_181543_z = \u2603;
        while (Util.func_211177_b() >= this.field_71419_L + 1000L) {
            field_71470_ab = this.field_71420_M;
            Object[] objectArray = new Object[8];
            objectArray[0] = field_71470_ab;
            objectArray[1] = ChunkRender.field_178592_a;
            objectArray[2] = ChunkRender.field_178592_a == 1 ? "" : "s";
            objectArray[3] = (double)this.field_71474_y.field_74350_i == AbstractOption.field_216701_h.func_216733_c() ? "inf" : Integer.valueOf(this.field_71474_y.field_74350_i);
            objectArray[4] = this.field_71474_y.field_74352_v ? " vsync" : "";
            Object object2 = objectArray[5] = this.field_71474_y.field_74347_j ? "" : " fast";
            objectArray[6] = this.field_71474_y.field_74345_l == CloudOption.OFF ? "" : (this.field_71474_y.field_74345_l == CloudOption.FAST ? " fast-clouds" : " fancy-clouds");
            objectArray[7] = GLX.useVbo() ? " vbo" : "";
            this.field_71426_K = String.format("%d fps (%d chunk update%s) T: %s%s%s%s%s", objectArray);
            ChunkRender.field_178592_a = 0;
            this.field_71419_L += 1000L;
            this.field_71420_M = 0;
            this.field_71427_U.func_76471_b();
            if (this.field_71427_U.func_76468_d()) continue;
            this.field_71427_U.func_76463_a();
        }
        this.field_71424_I.func_219897_b();
    }

    @Override
    public void func_213227_b(boolean bl) {
        this.field_71424_I.func_76320_a("display_update");
        this.field_195558_d.func_198086_a(this.field_71474_y.field_74353_u);
        this.field_71424_I.func_76319_b();
        if (bl && this.func_213266_aD()) {
            this.field_71424_I.func_76320_a("fpslimit_wait");
            this.field_195558_d.func_216524_c();
            this.field_71424_I.func_76319_b();
        }
    }

    @Override
    public void func_213226_a() {
        int n = this.field_195558_d.func_216521_a(this.field_71474_y.field_74335_Z, this.func_211821_e());
        this.field_195558_d.func_216525_a(n);
        if (this.field_71462_r != null) {
            this.field_71462_r.resize(this, this.field_195558_d.func_198107_o(), this.field_195558_d.func_198087_p());
        }
        if ((\u2603 = this.func_147110_a()) != null) {
            \u2603.func_216491_a(this.field_195558_d.func_198109_k(), this.field_195558_d.func_198091_l(), field_142025_a);
        }
        if (this.field_71460_t != null) {
            this.field_71460_t.func_147704_a(this.field_195558_d.func_198109_k(), this.field_195558_d.func_198091_l());
        }
        if (this.field_71417_B != null) {
            this.field_71417_B.func_198021_g();
        }
    }

    private int func_213243_aC() {
        if (this.field_71441_e == null && (this.field_71462_r != null || this.field_213279_p != null)) {
            return 60;
        }
        return this.field_195558_d.func_198082_x();
    }

    private boolean func_213266_aD() {
        return (double)this.func_213243_aC() < AbstractOption.field_216701_h.func_216733_c();
    }

    public void func_71398_f() {
        try {
            field_71444_a = new byte[0];
            this.field_71438_f.func_72728_f();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            System.gc();
            if (this.func_71356_B()) {
                this.field_71437_Z.func_71263_m(true);
            }
            this.func_213231_b(new DirtMessageScreen(new TranslationTextComponent("menu.savingLevel", new Object[0])));
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        System.gc();
    }

    void func_71383_b(int n) {
        IProfileResult iProfileResult = this.field_71424_I.func_219899_d().func_219937_c();
        List<DataPoint> \u26032 = iProfileResult.func_219917_a(this.field_71465_an);
        if (\u26032.isEmpty()) {
            return;
        }
        DataPoint \u26033 = \u26032.remove(0);
        if (n == 0) {
            if (!\u26033.field_219945_c.isEmpty() && (\u2603 = this.field_71465_an.lastIndexOf(46)) >= 0) {
                this.field_71465_an = this.field_71465_an.substring(0, \u2603);
            }
        } else if (--n < \u26032.size() && !"unspecified".equals(\u26032.get((int)n).field_219945_c)) {
            if (!this.field_71465_an.isEmpty()) {
                this.field_71465_an = this.field_71465_an + ".";
            }
            this.field_71465_an = this.field_71465_an + \u26032.get((int)n).field_219945_c;
        }
    }

    private void func_203410_as() {
        int \u260310;
        Object \u260315;
        if (!this.field_71424_I.func_219899_d().func_219936_a()) {
            return;
        }
        IProfileResult iProfileResult = this.field_71424_I.func_219899_d().func_219937_c();
        List<DataPoint> \u26032 = iProfileResult.func_219917_a(this.field_71465_an);
        DataPoint \u26033 = \u26032.remove(0);
        GlStateManager.clear(256, field_142025_a);
        GlStateManager.matrixMode(5889);
        GlStateManager.enableColorMaterial();
        GlStateManager.loadIdentity();
        GlStateManager.ortho(0.0, this.field_195558_d.func_198109_k(), this.field_195558_d.func_198091_l(), 0.0, 1000.0, 3000.0);
        GlStateManager.matrixMode(5888);
        GlStateManager.loadIdentity();
        GlStateManager.translatef(0.0f, 0.0f, -2000.0f);
        GlStateManager.lineWidth(1.0f);
        GlStateManager.disableTexture();
        Tessellator \u26034 = Tessellator.func_178181_a();
        BufferBuilder \u26035 = \u26034.func_178180_c();
        int \u26036 = 160;
        int \u26037 = this.field_195558_d.func_198109_k() - 160 - 10;
        int \u26038 = this.field_195558_d.func_198091_l() - 320;
        GlStateManager.enableBlend();
        \u26035.func_181668_a(7, DefaultVertexFormats.field_181706_f);
        \u26035.func_181662_b((float)\u26037 - 176.0f, (float)\u26038 - 96.0f - 16.0f, 0.0).func_181669_b(200, 0, 0, 0).func_181675_d();
        \u26035.func_181662_b((float)\u26037 - 176.0f, \u26038 + 320, 0.0).func_181669_b(200, 0, 0, 0).func_181675_d();
        \u26035.func_181662_b((float)\u26037 + 176.0f, \u26038 + 320, 0.0).func_181669_b(200, 0, 0, 0).func_181675_d();
        \u26035.func_181662_b((float)\u26037 + 176.0f, (float)\u26038 - 96.0f - 16.0f, 0.0).func_181669_b(200, 0, 0, 0).func_181675_d();
        \u26034.func_78381_a();
        GlStateManager.disableBlend();
        double \u26039 = 0.0;
        for (int i = 0; i < \u26032.size(); ++i) {
            float f;
            int n;
            \u260315 = \u26032.get(i);
            \u260310 = MathHelper.func_76128_c(((DataPoint)\u260315).field_219943_a / 4.0) + 1;
            \u26035.func_181668_a(6, DefaultVertexFormats.field_181706_f);
            int \u260311 = ((DataPoint)\u260315).func_219942_a();
            int \u260312 = \u260311 >> 16 & 0xFF;
            int \u260313 = \u260311 >> 8 & 0xFF;
            int \u260314 = \u260311 & 0xFF;
            \u26035.func_181662_b(\u26037, \u26038, 0.0).func_181669_b(\u260312, \u260313, \u260314, 255).func_181675_d();
            for (n = \u260310; n >= 0; --n) {
                f = (float)((\u26039 + ((DataPoint)\u260315).field_219943_a * (double)n / (double)\u260310) * 6.2831854820251465 / 100.0);
                \u2603 = MathHelper.func_76126_a(f) * 160.0f;
                \u2603 = MathHelper.func_76134_b(f) * 160.0f * 0.5f;
                \u26035.func_181662_b((float)\u26037 + \u2603, (float)\u26038 - \u2603, 0.0).func_181669_b(\u260312, \u260313, \u260314, 255).func_181675_d();
            }
            \u26034.func_78381_a();
            \u26035.func_181668_a(5, DefaultVertexFormats.field_181706_f);
            for (n = \u260310; n >= 0; --n) {
                f = (float)((\u26039 + ((DataPoint)\u260315).field_219943_a * (double)n / (double)\u260310) * 6.2831854820251465 / 100.0);
                \u2603 = MathHelper.func_76126_a(f) * 160.0f;
                \u2603 = MathHelper.func_76134_b(f) * 160.0f * 0.5f;
                \u26035.func_181662_b((float)\u26037 + \u2603, (float)\u26038 - \u2603, 0.0).func_181669_b(\u260312 >> 1, \u260313 >> 1, \u260314 >> 1, 255).func_181675_d();
                \u26035.func_181662_b((float)\u26037 + \u2603, (float)\u26038 - \u2603 + 10.0f, 0.0).func_181669_b(\u260312 >> 1, \u260313 >> 1, \u260314 >> 1, 255).func_181675_d();
            }
            \u26034.func_78381_a();
            \u26039 += ((DataPoint)\u260315).field_219943_a;
        }
        DecimalFormat decimalFormat = new DecimalFormat("##0.00");
        decimalFormat.setDecimalFormatSymbols(DecimalFormatSymbols.getInstance(Locale.ROOT));
        GlStateManager.enableTexture();
        \u260315 = "";
        if (!"unspecified".equals(\u26033.field_219945_c)) {
            \u260315 = (String)\u260315 + "[0] ";
        }
        \u260315 = \u26033.field_219945_c.isEmpty() ? (String)\u260315 + "ROOT " : (String)\u260315 + \u26033.field_219945_c + ' ';
        \u260310 = 0xFFFFFF;
        this.field_71466_p.func_175063_a((String)\u260315, \u26037 - 160, \u26038 - 80 - 16, 0xFFFFFF);
        \u260315 = decimalFormat.format(\u26033.field_219944_b) + "%";
        this.field_71466_p.func_175063_a((String)\u260315, \u26037 + 160 - this.field_71466_p.func_78256_a((String)\u260315), \u26038 - 80 - 16, 0xFFFFFF);
        for (int i = 0; i < \u26032.size(); ++i) {
            DataPoint dataPoint = \u26032.get(i);
            StringBuilder \u260316 = new StringBuilder();
            if ("unspecified".equals(dataPoint.field_219945_c)) {
                \u260316.append("[?] ");
            } else {
                \u260316.append("[").append(i + 1).append("] ");
            }
            String \u260317 = \u260316.append(dataPoint.field_219945_c).toString();
            this.field_71466_p.func_175063_a(\u260317, \u26037 - 160, \u26038 + 80 + i * 8 + 20, dataPoint.func_219942_a());
            \u260317 = decimalFormat.format(dataPoint.field_219943_a) + "%";
            this.field_71466_p.func_175063_a(\u260317, \u26037 + 160 - 50 - this.field_71466_p.func_78256_a(\u260317), \u26038 + 80 + i * 8 + 20, dataPoint.func_219942_a());
            \u260317 = decimalFormat.format(dataPoint.field_219944_b) + "%";
            this.field_71466_p.func_175063_a(\u260317, \u26037 + 160 - this.field_71466_p.func_78256_a(\u260317), \u26038 + 80 + i * 8 + 20, dataPoint.func_219942_a());
        }
    }

    public void func_71400_g() {
        this.field_71425_J = false;
    }

    public void func_71385_j(boolean bl) {
        if (this.field_71462_r != null) {
            return;
        }
        boolean bl2 = \u2603 = this.func_71356_B() && !this.field_71437_Z.func_71344_c();
        if (\u2603) {
            this.func_147108_a(new IngameMenuScreen(!bl));
            this.field_147127_av.func_147689_b();
        } else {
            this.func_147108_a(new IngameMenuScreen(true));
        }
    }

    private void func_147115_a(boolean bl) {
        if (!bl) {
            this.field_71429_W = 0;
        }
        if (this.field_71429_W > 0 || this.field_71439_g.func_184587_cr()) {
            return;
        }
        if (bl && this.field_71476_x != null && this.field_71476_x.func_216346_c() == RayTraceResult.Type.BLOCK) {
            BlockRayTraceResult blockRayTraceResult = (BlockRayTraceResult)this.field_71476_x;
            BlockPos \u26032 = blockRayTraceResult.func_216350_a();
            if (!this.field_71441_e.func_180495_p(\u26032).func_196958_f() && this.field_71442_b.func_180512_c(\u26032, \u2603 = blockRayTraceResult.func_216354_b())) {
                this.field_71452_i.func_180532_a(\u26032, \u2603);
                this.field_71439_g.func_184609_a(Hand.MAIN_HAND);
            }
            return;
        }
        this.field_71442_b.func_78767_c();
    }

    private void func_147116_af() {
        if (this.field_71429_W > 0) {
            return;
        }
        if (this.field_71476_x == null) {
            field_147123_G.error("Null returned as 'hitResult', this shouldn't happen!");
            if (this.field_71442_b.func_78762_g()) {
                this.field_71429_W = 10;
            }
            return;
        }
        if (this.field_71439_g.func_184838_M()) {
            return;
        }
        switch (this.field_71476_x.func_216346_c()) {
            case ENTITY: {
                this.field_71442_b.func_78764_a(this.field_71439_g, ((EntityRayTraceResult)this.field_71476_x).func_216348_a());
                break;
            }
            case BLOCK: {
                BlockRayTraceResult blockRayTraceResult = (BlockRayTraceResult)this.field_71476_x;
                BlockPos \u26032 = blockRayTraceResult.func_216350_a();
                if (!this.field_71441_e.func_180495_p(\u26032).func_196958_f()) {
                    this.field_71442_b.func_180511_b(\u26032, blockRayTraceResult.func_216354_b());
                    break;
                }
            }
            case MISS: {
                if (this.field_71442_b.func_78762_g()) {
                    this.field_71429_W = 10;
                }
                this.field_71439_g.func_184821_cY();
            }
        }
        this.field_71439_g.func_184609_a(Hand.MAIN_HAND);
    }

    private void func_147121_ag() {
        if (this.field_71442_b.func_181040_m()) {
            return;
        }
        this.field_71467_ac = 4;
        if (this.field_71439_g.func_184838_M()) {
            return;
        }
        if (this.field_71476_x == null) {
            field_147123_G.warn("Null returned as 'hitResult', this shouldn't happen!");
        }
        for (Hand hand : Hand.values()) {
            ItemStack itemStack = this.field_71439_g.func_184586_b(hand);
            if (this.field_71476_x != null) {
                switch (this.field_71476_x.func_216346_c()) {
                    case ENTITY: {
                        EntityRayTraceResult entityRayTraceResult = (EntityRayTraceResult)this.field_71476_x;
                        Entity \u26032 = entityRayTraceResult.func_216348_a();
                        if (this.field_71442_b.func_187102_a(this.field_71439_g, \u26032, entityRayTraceResult, hand) == ActionResultType.SUCCESS) {
                            return;
                        }
                        if (this.field_71442_b.func_187097_a(this.field_71439_g, \u26032, hand) != ActionResultType.SUCCESS) break;
                        return;
                    }
                    case BLOCK: {
                        BlockRayTraceResult \u26033 = (BlockRayTraceResult)this.field_71476_x;
                        int \u26034 = itemStack.func_190916_E();
                        ActionResultType \u26035 = this.field_71442_b.func_217292_a(this.field_71439_g, this.field_71441_e, hand, \u26033);
                        if (\u26035 == ActionResultType.SUCCESS) {
                            this.field_71439_g.func_184609_a(hand);
                            if (!itemStack.func_190926_b() && (itemStack.func_190916_E() != \u26034 || this.field_71442_b.func_78758_h())) {
                                this.field_71460_t.field_78516_c.func_187460_a(hand);
                            }
                            return;
                        }
                        if (\u26035 != ActionResultType.FAIL) break;
                        return;
                    }
                }
            }
            if (itemStack.func_190926_b() || this.field_71442_b.func_187101_a(this.field_71439_g, this.field_71441_e, hand) != ActionResultType.SUCCESS) continue;
            this.field_71460_t.field_78516_c.func_187460_a(hand);
            return;
        }
    }

    public MusicTicker func_181535_r() {
        return this.field_147126_aw;
    }

    public void func_71407_l() {
        if (this.field_71467_ac > 0) {
            --this.field_71467_ac;
        }
        this.field_71424_I.func_76320_a("gui");
        if (!this.field_71445_n) {
            this.field_71456_v.func_73831_a();
        }
        this.field_71424_I.func_76319_b();
        this.field_71460_t.func_78473_a(1.0f);
        this.field_193035_aW.func_193297_a(this.field_71441_e, this.field_71476_x);
        this.field_71424_I.func_76320_a("gameMode");
        if (!this.field_71445_n && this.field_71441_e != null) {
            this.field_71442_b.func_78765_e();
        }
        this.field_71424_I.func_219895_b("textures");
        if (this.field_71441_e != null) {
            this.field_71446_o.func_110550_d();
        }
        if (this.field_71462_r == null && this.field_71439_g != null) {
            if (this.field_71439_g.func_110143_aJ() <= 0.0f && !(this.field_71462_r instanceof DeathScreen)) {
                this.func_147108_a(null);
            } else if (this.field_71439_g.func_70608_bn() && this.field_71441_e != null) {
                this.func_147108_a(new SleepInMultiplayerScreen());
            }
        } else if (this.field_71462_r != null && this.field_71462_r instanceof SleepInMultiplayerScreen && !this.field_71439_g.func_70608_bn()) {
            this.func_147108_a(null);
        }
        if (this.field_71462_r != null) {
            this.field_71429_W = 10000;
        }
        if (this.field_71462_r != null) {
            Screen.wrapScreenError(() -> this.field_71462_r.tick(), "Ticking screen", this.field_71462_r.getClass().getCanonicalName());
        }
        if (!this.field_71474_y.field_74330_P) {
            this.field_71456_v.func_212910_m();
        }
        if (this.field_213279_p == null && (this.field_71462_r == null || this.field_71462_r.passEvents)) {
            this.field_71424_I.func_219895_b("GLFW events");
            GLX.pollEvents();
            this.func_184117_aA();
            if (this.field_71429_W > 0) {
                --this.field_71429_W;
            }
        }
        if (this.field_71441_e != null) {
            this.field_71424_I.func_219895_b("gameRenderer");
            if (!this.field_71445_n) {
                this.field_71460_t.func_78464_a();
            }
            this.field_71424_I.func_219895_b("levelRenderer");
            if (!this.field_71445_n) {
                this.field_71438_f.func_72734_e();
            }
            this.field_71424_I.func_219895_b("level");
            if (!this.field_71445_n) {
                if (this.field_71441_e.func_175658_ac() > 0) {
                    this.field_71441_e.func_175702_c(this.field_71441_e.func_175658_ac() - 1);
                }
                this.field_71441_e.func_217419_d();
            }
        } else if (this.field_71460_t.func_147702_a()) {
            this.field_71460_t.func_181022_b();
        }
        if (!this.field_71445_n) {
            this.field_147126_aw.func_73660_a();
        }
        this.field_147127_av.func_215290_a(this.field_71445_n);
        if (this.field_71441_e != null) {
            if (!this.field_71445_n) {
                this.field_71441_e.func_72891_a(this.field_71441_e.func_175659_aa() != Difficulty.PEACEFUL, true);
                this.field_193035_aW.func_193303_d();
                try {
                    this.field_71441_e.func_72835_b(() -> true);
                }
                catch (Throwable throwable) {
                    CrashReport crashReport = CrashReport.func_85055_a(throwable, "Exception in world tick");
                    if (this.field_71441_e == null) {
                        CrashReportCategory crashReportCategory = crashReport.func_85058_a("Affected level");
                        crashReportCategory.func_71507_a("Problem", "Level is null!");
                    } else {
                        this.field_71441_e.func_72914_a(crashReport);
                    }
                    throw new ReportedException(crashReport);
                }
            }
            this.field_71424_I.func_219895_b("animateTick");
            if (!this.field_71445_n && this.field_71441_e != null) {
                this.field_71441_e.func_73029_E(MathHelper.func_76128_c(this.field_71439_g.field_70165_t), MathHelper.func_76128_c(this.field_71439_g.field_70163_u), MathHelper.func_76128_c(this.field_71439_g.field_70161_v));
            }
            this.field_71424_I.func_219895_b("particles");
            if (!this.field_71445_n) {
                this.field_71452_i.func_78868_a();
            }
        } else if (this.field_71453_ak != null) {
            this.field_71424_I.func_219895_b("pendingConnection");
            this.field_71453_ak.func_74428_b();
        }
        this.field_71424_I.func_219895_b("keyboard");
        this.field_195559_v.func_204870_b();
        this.field_71424_I.func_76319_b();
    }

    private void func_184117_aA() {
        int n;
        while (this.field_71474_y.field_151457_aa.func_151468_f()) {
            ++this.field_71474_y.field_74320_O;
            if (this.field_71474_y.field_74320_O > 2) {
                this.field_71474_y.field_74320_O = 0;
            }
            if (this.field_71474_y.field_74320_O == 0) {
                this.field_71460_t.func_175066_a(this.func_175606_aa());
            } else if (this.field_71474_y.field_74320_O == 1) {
                this.field_71460_t.func_175066_a(null);
            }
            this.field_71438_f.func_174979_m();
        }
        while (this.field_71474_y.field_151458_ab.func_151468_f()) {
            this.field_71474_y.field_74326_T = !this.field_71474_y.field_74326_T;
        }
        for (n = 0; n < 9; ++n) {
            boolean bl = this.field_71474_y.field_193629_ap.func_151470_d();
            \u2603 = this.field_71474_y.field_193630_aq.func_151470_d();
            if (!this.field_71474_y.field_151456_ac[n].func_151468_f()) continue;
            if (this.field_71439_g.func_175149_v()) {
                this.field_71456_v.func_175187_g().func_175260_a(n);
                continue;
            }
            if (this.field_71439_g.func_184812_l_() && this.field_71462_r == null && (\u2603 || bl)) {
                CreativeScreen.func_192044_a(this, n, \u2603, bl);
                continue;
            }
            this.field_71439_g.field_71071_by.field_70461_c = n;
        }
        while (this.field_71474_y.field_151445_Q.func_151468_f()) {
            if (this.field_71442_b.func_110738_j()) {
                this.field_71439_g.func_175163_u();
                continue;
            }
            this.field_193035_aW.func_193296_a();
            this.func_147108_a(new InventoryScreen(this.field_71439_g));
        }
        while (this.field_71474_y.field_194146_ao.func_151468_f()) {
            this.func_147108_a(new AdvancementsScreen(this.field_71439_g.field_71174_a.func_191982_f()));
        }
        while (this.field_71474_y.field_186718_X.func_151468_f()) {
            if (this.field_71439_g.func_175149_v()) continue;
            this.func_147114_u().func_147297_a(new CPlayerDiggingPacket(CPlayerDiggingPacket.Action.SWAP_HELD_ITEMS, BlockPos.field_177992_a, Direction.DOWN));
        }
        while (this.field_71474_y.field_74316_C.func_151468_f()) {
            if (this.field_71439_g.func_175149_v()) continue;
            this.field_71439_g.func_71040_bB(Screen.hasControlDown());
        }
        int n2 = n = this.field_71474_y.field_74343_n != ChatVisibility.HIDDEN ? 1 : 0;
        if (n != 0) {
            while (this.field_71474_y.field_74310_D.func_151468_f()) {
                this.func_147108_a(new ChatScreen(""));
            }
            if (this.field_71462_r == null && this.field_213279_p == null && this.field_71474_y.field_74323_J.func_151468_f()) {
                this.func_147108_a(new ChatScreen("/"));
            }
        }
        if (this.field_71439_g.func_184587_cr()) {
            if (!this.field_71474_y.field_74313_G.func_151470_d()) {
                this.field_71442_b.func_78766_c(this.field_71439_g);
            }
            while (this.field_71474_y.field_74312_F.func_151468_f()) {
            }
            while (this.field_71474_y.field_74313_G.func_151468_f()) {
            }
            while (this.field_71474_y.field_74322_I.func_151468_f()) {
            }
        } else {
            while (this.field_71474_y.field_74312_F.func_151468_f()) {
                this.func_147116_af();
            }
            while (this.field_71474_y.field_74313_G.func_151468_f()) {
                this.func_147121_ag();
            }
            while (this.field_71474_y.field_74322_I.func_151468_f()) {
                this.func_147112_ai();
            }
        }
        if (this.field_71474_y.field_74313_G.func_151470_d() && this.field_71467_ac == 0 && !this.field_71439_g.func_184587_cr()) {
            this.func_147121_ag();
        }
        this.func_147115_a(this.field_71462_r == null && this.field_71474_y.field_74312_F.func_151470_d() && this.field_71417_B.func_198035_h());
    }

    public void func_71371_a(String string, String string2, @Nullable WorldSettings worldSettings2) {
        Object object;
        this.func_213254_o();
        SaveHandler saveHandler = this.field_71469_aa.func_197715_a(string, null);
        WorldInfo \u26032 = saveHandler.func_75757_d();
        if (\u26032 == null && worldSettings2 != null) {
            \u26032 = new WorldInfo(worldSettings2, string);
            saveHandler.func_75761_a(\u26032);
        }
        if (worldSettings2 == null) {
            WorldSettings worldSettings2 = new WorldSettings(\u26032);
        }
        this.field_213277_ad.set(null);
        try {
            object = new YggdrasilAuthenticationService(this.field_110453_aa, UUID.randomUUID().toString());
            object2 = object.createMinecraftSessionService();
            \u2603 = object.createProfileRepository();
            PlayerProfileCache \u26033 = new PlayerProfileCache((GameProfileRepository)\u2603, new File(this.field_71412_D, MinecraftServer.field_152367_a.getName()));
            SkullTileEntity.func_184293_a(\u26033);
            SkullTileEntity.func_184294_a((MinecraftSessionService)object2);
            PlayerProfileCache.func_187320_a(false);
            this.field_71437_Z = new IntegratedServer(this, string, string2, worldSettings2, (YggdrasilAuthenticationService)object, (MinecraftSessionService)object2, (GameProfileRepository)\u2603, \u26033, n -> {
                TrackingChunkStatusListener trackingChunkStatusListener = new TrackingChunkStatusListener(n + 0);
                trackingChunkStatusListener.func_219521_a();
                this.field_213277_ad.set(trackingChunkStatusListener);
                return new ChainedChunkStatusListener(trackingChunkStatusListener, this.field_213275_aU::add);
            });
            this.field_71437_Z.func_71256_s();
            this.field_71455_al = true;
        }
        catch (Throwable throwable) {
            CrashReport crashReport = CrashReport.func_85055_a(throwable, "Starting integrated server");
            CrashReportCategory \u26034 = crashReport.func_85058_a("Starting integrated server");
            \u26034.func_71507_a("Level ID", string);
            \u26034.func_71507_a("Level Name", string2);
            throw new ReportedException(crashReport);
        }
        while (this.field_213277_ad.get() == null) {
            Thread.yield();
        }
        object = new WorldLoadProgressScreen(this.field_213277_ad.get());
        this.func_147108_a((Screen)object);
        while (!this.field_71437_Z.func_71200_ad()) {
            ((Screen)object).tick();
            this.func_195542_b(false);
            try {
                Thread.sleep(16L);
            }
            catch (InterruptedException crashReport) {
                // empty catch block
            }
            if (!this.field_71434_R || this.field_71433_S == null) continue;
            this.func_71377_b(this.field_71433_S);
            return;
        }
        Object object2 = this.field_71437_Z.func_147137_ag().func_151270_a();
        \u2603 = NetworkManager.func_150722_a((SocketAddress)object2);
        ((NetworkManager)((Object)\u2603)).func_150719_a(new ClientLoginNetHandler((NetworkManager)((Object)\u2603), this, null, iTextComponent -> {}));
        ((NetworkManager)((Object)\u2603)).func_179290_a(new CHandshakePacket(object2.toString(), 0, ProtocolType.LOGIN));
        ((NetworkManager)((Object)\u2603)).func_179290_a(new CLoginStartPacket(this.func_110432_I().func_148256_e()));
        this.field_71453_ak = \u2603;
    }

    public void func_71403_a(ClientWorld clientWorld) {
        WorkingScreen workingScreen = new WorkingScreen();
        workingScreen.func_200210_a(new TranslationTextComponent("connect.joining", new Object[0]));
        this.func_213241_c(workingScreen);
        this.field_71441_e = clientWorld;
        this.func_213257_b(clientWorld);
        if (!this.field_71455_al) {
            YggdrasilAuthenticationService yggdrasilAuthenticationService = new YggdrasilAuthenticationService(this.field_110453_aa, UUID.randomUUID().toString());
            MinecraftSessionService \u26032 = yggdrasilAuthenticationService.createMinecraftSessionService();
            GameProfileRepository \u26033 = yggdrasilAuthenticationService.createProfileRepository();
            PlayerProfileCache \u26034 = new PlayerProfileCache(\u26033, new File(this.field_71412_D, MinecraftServer.field_152367_a.getName()));
            SkullTileEntity.func_184293_a(\u26034);
            SkullTileEntity.func_184294_a(\u26032);
            PlayerProfileCache.func_187320_a(false);
        }
    }

    public void func_213254_o() {
        this.func_213231_b(new WorkingScreen());
    }

    public void func_213231_b(Screen screen) {
        ClientPlayNetHandler clientPlayNetHandler = this.func_147114_u();
        if (clientPlayNetHandler != null) {
            this.func_213159_be();
            clientPlayNetHandler.func_147296_c();
        }
        IntegratedServer \u26032 = this.field_71437_Z;
        this.field_71437_Z = null;
        this.field_71460_t.func_190564_k();
        this.field_71442_b = null;
        NarratorChatListener.field_193643_a.func_193642_b();
        this.func_213241_c(screen);
        if (this.field_71441_e != null) {
            if (\u26032 != null) {
                while (!\u26032.func_213201_w()) {
                    this.func_195542_b(false);
                }
            }
            this.field_195554_ax.func_195749_c();
            this.field_71456_v.func_181029_i();
            this.func_71351_a(null);
            this.field_71455_al = false;
            this.field_213274_aO.func_216815_b();
        }
        this.field_71441_e = null;
        this.func_213257_b(null);
        this.field_71439_g = null;
    }

    private void func_213241_c(Screen screen) {
        this.field_147126_aw.func_209200_a();
        this.field_147127_av.func_147690_c();
        this.field_175622_Z = null;
        this.field_71453_ak = null;
        this.func_147108_a(screen);
        this.func_195542_b(false);
    }

    private void func_213257_b(@Nullable ClientWorld clientWorld) {
        if (this.field_71438_f != null) {
            this.field_71438_f.func_72732_a(clientWorld);
        }
        if (this.field_71452_i != null) {
            this.field_71452_i.func_78870_a(clientWorld);
        }
        TileEntityRendererDispatcher.field_147556_a.func_147543_a(clientWorld);
    }

    public final boolean func_71355_q() {
        return this.field_71459_aj;
    }

    @Nullable
    public ClientPlayNetHandler func_147114_u() {
        return this.field_71439_g == null ? null : this.field_71439_g.field_71174_a;
    }

    public static boolean func_71382_s() {
        return field_71432_P == null || !Minecraft.field_71432_P.field_71474_y.field_74319_N;
    }

    public static boolean func_71375_t() {
        return field_71432_P != null && Minecraft.field_71432_P.field_71474_y.field_74347_j;
    }

    public static boolean func_71379_u() {
        return field_71432_P != null && Minecraft.field_71432_P.field_71474_y.field_74348_k != AmbientOcclusionStatus.OFF;
    }

    private void func_147112_ai() {
        ItemStack \u26035;
        Object object;
        if (this.field_71476_x == null || this.field_71476_x.func_216346_c() == RayTraceResult.Type.MISS) {
            return;
        }
        boolean bl = this.field_71439_g.field_71075_bZ.field_75098_d;
        TileEntity \u26032 = null;
        RayTraceResult.Type \u26033 = this.field_71476_x.func_216346_c();
        if (\u26033 == RayTraceResult.Type.BLOCK) {
            object = ((BlockRayTraceResult)this.field_71476_x).func_216350_a();
            \u2603 = this.field_71441_e.func_180495_p((BlockPos)object);
            Block \u26034 = ((BlockState)\u2603).func_177230_c();
            if (((BlockState)\u2603).func_196958_f()) {
                return;
            }
            \u26035 = \u26034.func_185473_a(this.field_71441_e, (BlockPos)object, (BlockState)\u2603);
            if (\u26035.func_190926_b()) {
                return;
            }
            if (bl && Screen.hasControlDown() && \u26034.func_149716_u()) {
                \u26032 = this.field_71441_e.func_175625_s((BlockPos)object);
            }
        } else if (\u26033 == RayTraceResult.Type.ENTITY && bl) {
            object = ((EntityRayTraceResult)this.field_71476_x).func_216348_a();
            if (object instanceof PaintingEntity) {
                \u26035 = new ItemStack(Items.field_151159_an);
            } else if (object instanceof LeashKnotEntity) {
                \u26035 = new ItemStack(Items.field_151058_ca);
            } else if (object instanceof ItemFrameEntity) {
                \u2603 = (ItemFrameEntity)object;
                ItemStack itemStack = ((ItemFrameEntity)\u2603).func_82335_i();
                \u26035 = itemStack.func_190926_b() ? new ItemStack(Items.field_151160_bD) : itemStack.func_77946_l();
            } else if (object instanceof AbstractMinecartEntity) {
                Item item;
                \u2603 = (AbstractMinecartEntity)object;
                switch (((AbstractMinecartEntity)\u2603).func_184264_v()) {
                    case FURNACE: {
                        item = Items.field_151109_aJ;
                        break;
                    }
                    case CHEST: {
                        item = Items.field_151108_aI;
                        break;
                    }
                    case TNT: {
                        item = Items.field_151142_bV;
                        break;
                    }
                    case HOPPER: {
                        item = Items.field_151140_bW;
                        break;
                    }
                    case COMMAND_BLOCK: {
                        item = Items.field_151095_cc;
                        break;
                    }
                    default: {
                        item = Items.field_151143_au;
                    }
                }
                \u26035 = new ItemStack(item);
            } else if (object instanceof BoatEntity) {
                \u26035 = new ItemStack(((BoatEntity)object).func_184455_j());
            } else if (object instanceof ArmorStandEntity) {
                \u26035 = new ItemStack(Items.field_179565_cj);
            } else if (object instanceof EnderCrystalEntity) {
                \u26035 = new ItemStack(Items.field_185158_cP);
            } else {
                \u2603 = SpawnEggItem.func_200889_b(((Entity)object).func_200600_R());
                if (\u2603 == null) {
                    return;
                }
                \u26035 = new ItemStack((IItemProvider)\u2603);
            }
        } else {
            return;
        }
        if (\u26035.func_190926_b()) {
            object = "";
            if (\u26033 == RayTraceResult.Type.BLOCK) {
                object = Registry.field_212618_g.func_177774_c(this.field_71441_e.func_180495_p(((BlockRayTraceResult)this.field_71476_x).func_216350_a()).func_177230_c()).toString();
            } else if (\u26033 == RayTraceResult.Type.ENTITY) {
                object = Registry.field_212629_r.func_177774_c(((EntityRayTraceResult)this.field_71476_x).func_216348_a().func_200600_R()).toString();
            }
            field_147123_G.warn("Picking on: [{}] {} gave null item", (Object)\u26033, object);
            return;
        }
        object = this.field_71439_g.field_71071_by;
        if (\u26032 != null) {
            this.func_184119_a(\u26035, \u26032);
        }
        int \u26036 = ((PlayerInventory)object).func_184429_b(\u26035);
        if (bl) {
            ((PlayerInventory)object).func_184434_a(\u26035);
            this.field_71442_b.func_78761_a(this.field_71439_g.func_184586_b(Hand.MAIN_HAND), 36 + ((PlayerInventory)object).field_70461_c);
        } else if (\u26036 != -1) {
            if (PlayerInventory.func_184435_e(\u26036)) {
                ((PlayerInventory)object).field_70461_c = \u26036;
            } else {
                this.field_71442_b.func_187100_a(\u26036);
            }
        }
    }

    private ItemStack func_184119_a(ItemStack itemStack, TileEntity tileEntity) {
        CompoundNBT compoundNBT = tileEntity.func_189515_b(new CompoundNBT());
        if (itemStack.func_77973_b() instanceof SkullItem && compoundNBT.func_74764_b("Owner")) {
            \u2603 = compoundNBT.func_74775_l("Owner");
            itemStack.func_196082_o().func_218657_a("SkullOwner", \u2603);
            return itemStack;
        }
        itemStack.func_77983_a("BlockEntityTag", compoundNBT);
        \u2603 = new CompoundNBT();
        ListNBT \u26032 = new ListNBT();
        \u26032.add(new StringNBT("\"(+NBT)\""));
        \u2603.func_218657_a("Lore", \u26032);
        itemStack.func_77983_a("display", \u2603);
        return itemStack;
    }

    public CrashReport func_71396_d(CrashReport crashReport) {
        CrashReportCategory crashReportCategory = crashReport.func_85056_g();
        crashReportCategory.func_189529_a("Launched Version", () -> this.field_110447_Z);
        crashReportCategory.func_189529_a("LWJGL", GLX::getLWJGLVersion);
        crashReportCategory.func_189529_a("OpenGL", GLX::getOpenGLVersionString);
        crashReportCategory.func_189529_a("GL Caps", GLX::getCapsString);
        crashReportCategory.func_189529_a("Using VBOs", () -> "Yes");
        crashReportCategory.func_189529_a("Is Modded", () -> {
            String string = ClientBrandRetriever.getClientModName();
            if (!"vanilla".equals(string)) {
                return "Definitely; Client brand changed to '" + string + "'";
            }
            if (Minecraft.class.getSigners() == null) {
                return "Very likely; Jar signature invalidated";
            }
            return "Probably not. Jar signature remains and client brand is untouched.";
        });
        crashReportCategory.func_71507_a("Type", "Client (map_client.txt)");
        crashReportCategory.func_189529_a("Resource Packs", () -> {
            StringBuilder stringBuilder = new StringBuilder();
            for (String string : this.field_71474_y.field_151453_l) {
                if (stringBuilder.length() > 0) {
                    stringBuilder.append(", ");
                }
                stringBuilder.append(string);
                if (!this.field_71474_y.field_183018_l.contains(string)) continue;
                stringBuilder.append(" (incompatible)");
            }
            return stringBuilder.toString();
        });
        crashReportCategory.func_189529_a("Current Language", () -> this.field_135017_as.func_135041_c().toString());
        crashReportCategory.func_189529_a("CPU", GLX::getCpuInfo);
        if (this.field_71441_e != null) {
            this.field_71441_e.func_72914_a(crashReport);
        }
        return crashReport;
    }

    public static Minecraft func_71410_x() {
        return field_71432_P;
    }

    public CompletableFuture<Void> func_213245_w() {
        return this.func_213169_a(this::func_213237_g).thenCompose(completableFuture -> completableFuture);
    }

    @Override
    public void func_70000_a(Snooper snooper2) {
        Snooper snooper2;
        snooper2.func_152768_a("fps", field_71470_ab);
        snooper2.func_152768_a("vsync_enabled", this.field_71474_y.field_74352_v);
        int n = GLX.getRefreshRate(this.field_195558_d);
        snooper2.func_152768_a("display_frequency", n);
        snooper2.func_152768_a("display_type", this.field_195558_d.func_198113_j() ? "fullscreen" : "windowed");
        snooper2.func_152768_a("run_time", (Util.func_211177_b() - snooper2.func_130105_g()) / 60L * 1000L);
        snooper2.func_152768_a("current_action", this.func_181538_aA());
        snooper2.func_152768_a("language", this.field_71474_y.field_74363_ab == null ? "en_us" : this.field_71474_y.field_74363_ab);
        String \u26032 = ByteOrder.nativeOrder() == ByteOrder.LITTLE_ENDIAN ? "little" : "big";
        snooper2.func_152768_a("endianness", \u26032);
        snooper2.func_152768_a("subtitles", this.field_71474_y.field_186717_N);
        snooper2.func_152768_a("touch", this.field_71474_y.field_85185_A ? "touch" : "mouse");
        \u2603 = 0;
        for (ClientResourcePackInfo clientResourcePackInfo : this.field_110448_aq.func_198980_d()) {
            if (clientResourcePackInfo.func_195797_g() || clientResourcePackInfo.func_195798_h()) continue;
            snooper2.func_152768_a("resource_pack[" + \u2603++ + "]", clientResourcePackInfo.func_195790_f());
        }
        snooper2.func_152768_a("resource_packs", \u2603);
        if (this.field_71437_Z != null && this.field_71437_Z.func_80003_ah() != null) {
            snooper2.func_152768_a("snooper_partner", this.field_71437_Z.func_80003_ah().func_80006_f());
        }
    }

    private String func_181538_aA() {
        if (this.field_71437_Z != null) {
            if (this.field_71437_Z.func_71344_c()) {
                return "hosting_lan";
            }
            return "singleplayer";
        }
        if (this.field_71422_O != null) {
            if (this.field_71422_O.func_181041_d()) {
                return "playing_lan";
            }
            return "multiplayer";
        }
        return "out_of_game";
    }

    public static int func_71369_N() {
        if (field_211120_F == -1) {
            for (int i = 16384; i > 0; i >>= 1) {
                GlStateManager.texImage2D(32868, 0, 6408, i, i, 0, 6408, 5121, null);
                \u2603 = GlStateManager.getTexLevelParameter(32868, 0, 4096);
                if (\u2603 == 0) continue;
                field_211120_F = i;
                return i;
            }
            field_211120_F = MathHelper.func_76125_a(GlStateManager.getInteger(3379), 1024, 16384);
            field_147123_G.info("Failed to determine maximum texture size by probing, trying GL_MAX_TEXTURE_SIZE = {}", (Object)field_211120_F);
        }
        return field_211120_F;
    }

    public void func_71351_a(ServerData serverData) {
        this.field_71422_O = serverData;
    }

    @Nullable
    public ServerData func_147104_D() {
        return this.field_71422_O;
    }

    public boolean func_71387_A() {
        return this.field_71455_al;
    }

    public boolean func_71356_B() {
        return this.field_71455_al && this.field_71437_Z != null;
    }

    @Nullable
    public IntegratedServer func_71401_C() {
        return this.field_71437_Z;
    }

    public Snooper func_71378_E() {
        return this.field_71427_U;
    }

    public Session func_110432_I() {
        return this.field_71449_j;
    }

    public PropertyMap func_181037_M() {
        if (this.field_181038_N.isEmpty()) {
            GameProfile gameProfile = this.func_152347_ac().fillProfileProperties(this.field_71449_j.func_148256_e(), false);
            this.field_181038_N.putAll((Multimap)gameProfile.getProperties());
        }
        return this.field_181038_N;
    }

    public Proxy func_110437_J() {
        return this.field_110453_aa;
    }

    public TextureManager func_110434_K() {
        return this.field_71446_o;
    }

    public IResourceManager func_195551_G() {
        return this.field_110451_am;
    }

    public ResourcePackList<ClientResourcePackInfo> func_195548_H() {
        return this.field_110448_aq;
    }

    public DownloadingPackFinder func_195541_I() {
        return this.field_195554_ax;
    }

    public File func_195549_J() {
        return this.field_130070_K;
    }

    public LanguageManager func_135016_M() {
        return this.field_135017_as;
    }

    public AtlasTexture func_147117_R() {
        return this.field_147128_au;
    }

    public boolean func_147111_S() {
        return this.field_147129_ai;
    }

    public boolean func_147113_T() {
        return this.field_71445_n;
    }

    public SoundHandler func_147118_V() {
        return this.field_147127_av;
    }

    public MusicTicker.MusicType func_147109_W() {
        if (this.field_71462_r instanceof WinGameScreen) {
            return MusicTicker.MusicType.CREDITS;
        }
        if (this.field_71439_g != null) {
            if (this.field_71439_g.field_70170_p.field_73011_w instanceof NetherDimension) {
                return MusicTicker.MusicType.NETHER;
            }
            if (this.field_71439_g.field_70170_p.field_73011_w instanceof EndDimension) {
                if (this.field_71456_v.func_184046_j().func_184054_d()) {
                    return MusicTicker.MusicType.END_BOSS;
                }
                return MusicTicker.MusicType.END;
            }
            Biome.Category category = this.field_71439_g.field_70170_p.func_180494_b(new BlockPos(this.field_71439_g)).func_201856_r();
            if (this.field_147126_aw.func_209100_b(MusicTicker.MusicType.UNDER_WATER) || this.field_71439_g.func_204231_K() && !this.field_147126_aw.func_209100_b(MusicTicker.MusicType.GAME) && (category == Biome.Category.OCEAN || category == Biome.Category.RIVER)) {
                return MusicTicker.MusicType.UNDER_WATER;
            }
            if (this.field_71439_g.field_71075_bZ.field_75098_d && this.field_71439_g.field_71075_bZ.field_75101_c) {
                return MusicTicker.MusicType.CREATIVE;
            }
            return MusicTicker.MusicType.GAME;
        }
        return MusicTicker.MusicType.MENU;
    }

    public MinecraftSessionService func_152347_ac() {
        return this.field_152355_az;
    }

    public SkinManager func_152342_ad() {
        return this.field_152350_aA;
    }

    @Nullable
    public Entity func_175606_aa() {
        return this.field_175622_Z;
    }

    public void func_175607_a(Entity entity) {
        this.field_175622_Z = entity;
        this.field_71460_t.func_175066_a(entity);
    }

    @Override
    protected Thread func_213170_ax() {
        return this.field_152352_aC;
    }

    @Override
    protected Runnable func_212875_d_(Runnable runnable) {
        return runnable;
    }

    @Override
    protected boolean func_212874_c_(Runnable runnable) {
        return true;
    }

    public BlockRendererDispatcher func_175602_ab() {
        return this.field_175618_aM;
    }

    public EntityRendererManager func_175598_ae() {
        return this.field_175616_W;
    }

    public ItemRenderer func_175599_af() {
        return this.field_175621_X;
    }

    public FirstPersonRenderer func_175597_ag() {
        return this.field_175620_Y;
    }

    public <T> IMutableSearchTree<T> func_213253_a(SearchTreeManager.Key<T> key) {
        return this.field_193995_ae.func_215358_a(key);
    }

    public static int func_175610_ah() {
        return field_71470_ab;
    }

    public FrameTimer func_181539_aj() {
        return this.field_181542_y;
    }

    public boolean func_181540_al() {
        return this.field_181541_X;
    }

    public void func_181537_a(boolean bl) {
        this.field_181541_X = bl;
    }

    public DataFixer func_184126_aj() {
        return this.field_184131_U;
    }

    public float func_184121_ak() {
        return this.field_71428_T.field_194147_b;
    }

    public float func_193989_ak() {
        return this.field_71428_T.field_194148_c;
    }

    public BlockColors func_184125_al() {
        return this.field_184127_aH;
    }

    public boolean func_189648_am() {
        return this.field_71439_g != null && this.field_71439_g.func_175140_cp() || this.field_71474_y.field_178879_v;
    }

    public ToastGui func_193033_an() {
        return this.field_193034_aS;
    }

    public Tutorial func_193032_ao() {
        return this.field_193035_aW;
    }

    public boolean func_195544_aj() {
        return this.field_195555_I;
    }

    public CreativeSettings func_199403_al() {
        return this.field_191950_u;
    }

    public ModelManager func_209506_al() {
        return this.field_175617_aL;
    }

    public FontResourceManager func_211500_ak() {
        return this.field_211501_aD;
    }

    public PaintingSpriteUploader func_213263_ao() {
        return this.field_213272_aL;
    }

    public PotionSpriteUploader func_213248_ap() {
        return this.field_213273_aM;
    }

    @Override
    public void func_213228_a(boolean bl) {
        this.field_195555_I = bl;
    }

    public IProfiler func_213239_aq() {
        return this.field_71424_I;
    }

    public MinecraftGame func_213229_ar() {
        return this.field_213274_aO;
    }

    public Splashes func_213269_at() {
        return this.field_213271_aF;
    }

    @Nullable
    public LoadingGui func_213250_au() {
        return this.field_213279_p;
    }

    private static /* synthetic */ void func_213265_b(CompletableFuture completableFuture) {
        completableFuture.complete(null);
    }

    private static /* synthetic */ IResourcePack func_213270_b(Supplier supplier) {
        return new LegacyResourcePackWrapper((IResourcePack)supplier.get(), LegacyResourcePackWrapper.field_211853_a);
    }
}

