/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.block;

import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.pathfinding.PathType;
import net.minecraft.state.IntegerProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.LightType;
import net.minecraft.world.World;

public class SnowBlock
extends Block {
    public static final IntegerProperty field_176315_a = BlockStateProperties.field_208129_ad;
    protected static final VoxelShape[] field_196508_b = new VoxelShape[]{VoxelShapes.func_197880_a(), Block.func_208617_a(0.0, 0.0, 0.0, 16.0, 2.0, 16.0), Block.func_208617_a(0.0, 0.0, 0.0, 16.0, 4.0, 16.0), Block.func_208617_a(0.0, 0.0, 0.0, 16.0, 6.0, 16.0), Block.func_208617_a(0.0, 0.0, 0.0, 16.0, 8.0, 16.0), Block.func_208617_a(0.0, 0.0, 0.0, 16.0, 10.0, 16.0), Block.func_208617_a(0.0, 0.0, 0.0, 16.0, 12.0, 16.0), Block.func_208617_a(0.0, 0.0, 0.0, 16.0, 14.0, 16.0), Block.func_208617_a(0.0, 0.0, 0.0, 16.0, 16.0, 16.0)};

    protected SnowBlock(Block.Properties properties) {
        super(properties);
        this.func_180632_j((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a(field_176315_a, 1));
    }

    @Override
    public boolean func_196266_a(BlockState blockState, IBlockReader iBlockReader, BlockPos blockPos, PathType pathType) {
        switch (pathType) {
            case LAND: {
                return blockState.func_177229_b(field_176315_a) < 5;
            }
            case WATER: {
                return false;
            }
            case AIR: {
                return false;
            }
        }
        return false;
    }

    @Override
    public VoxelShape func_220053_a(BlockState blockState, IBlockReader iBlockReader, BlockPos blockPos, ISelectionContext iSelectionContext) {
        return field_196508_b[blockState.func_177229_b(field_176315_a)];
    }

    @Override
    public VoxelShape func_220071_b(BlockState blockState, IBlockReader iBlockReader, BlockPos blockPos, ISelectionContext iSelectionContext) {
        return field_196508_b[blockState.func_177229_b(field_176315_a) - 1];
    }

    @Override
    public boolean func_220074_n(BlockState blockState) {
        return true;
    }

    @Override
    public boolean func_196260_a(BlockState blockState, IWorldReader iWorldReader, BlockPos blockPos) {
        BlockState blockState2 = iWorldReader.func_180495_p(blockPos.func_177977_b());
        Block \u26032 = blockState2.func_177230_c();
        if (\u26032 == Blocks.field_150432_aD || \u26032 == Blocks.field_150403_cj || \u26032 == Blocks.field_180401_cv) {
            return false;
        }
        return Block.func_208061_a(blockState2.func_196952_d(iWorldReader, blockPos.func_177977_b()), Direction.UP) || \u26032 == this && blockState2.func_177229_b(field_176315_a) == 8;
    }

    @Override
    public BlockState func_196271_a(BlockState blockState, Direction direction, BlockState blockState2, IWorld iWorld, BlockPos blockPos, BlockPos blockPos2) {
        if (!blockState.func_196955_c(iWorld, blockPos)) {
            return Blocks.field_150350_a.func_176223_P();
        }
        return super.func_196271_a(blockState, direction, blockState2, iWorld, blockPos, blockPos2);
    }

    @Override
    public void func_196267_b(BlockState blockState, World world, BlockPos blockPos, Random random) {
        if (world.func_175642_b(LightType.BLOCK, blockPos) > 11) {
            SnowBlock.func_220075_c(blockState, world, blockPos);
            world.func_217377_a(blockPos, false);
        }
    }

    @Override
    public boolean func_196253_a(BlockState blockState, BlockItemUseContext blockItemUseContext) {
        int n = blockState.func_177229_b(field_176315_a);
        if (blockItemUseContext.func_195996_i().func_77973_b() == this.func_199767_j() && n < 8) {
            if (blockItemUseContext.func_196012_c()) {
                return blockItemUseContext.func_196000_l() == Direction.UP;
            }
            return true;
        }
        return n == 1;
    }

    @Override
    @Nullable
    public BlockState func_196258_a(BlockItemUseContext blockItemUseContext2) {
        BlockItemUseContext blockItemUseContext2;
        BlockState blockState = blockItemUseContext2.func_195991_k().func_180495_p(blockItemUseContext2.func_195995_a());
        if (blockState.func_177230_c() == this) {
            int n = blockState.func_177229_b(field_176315_a);
            return (BlockState)blockState.func_206870_a(field_176315_a, Math.min(8, n + 1));
        }
        return super.func_196258_a(blockItemUseContext2);
    }

    @Override
    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(field_176315_a);
    }
}

