/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.block;

import com.google.common.collect.Lists;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.WeakHashMap;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.TorchBlock;
import net.minecraft.particles.RedstoneParticleData;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;

public class RedstoneTorchBlock
extends TorchBlock {
    public static final BooleanProperty field_196528_a = BlockStateProperties.field_208190_q;
    private static final Map<IBlockReader, List<Toggle>> field_196529_b = new WeakHashMap<IBlockReader, List<Toggle>>();

    protected RedstoneTorchBlock(Block.Properties properties) {
        super(properties);
        this.func_180632_j((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a(field_196528_a, true));
    }

    @Override
    public int func_149738_a(IWorldReader iWorldReader) {
        return 2;
    }

    @Override
    public void func_220082_b(BlockState blockState, World world, BlockPos blockPos, BlockState blockState2, boolean bl) {
        for (Direction direction : Direction.values()) {
            world.func_195593_d(blockPos.func_177972_a(direction), this);
        }
    }

    @Override
    public void func_196243_a(BlockState blockState, World world, BlockPos blockPos, BlockState blockState2, boolean bl) {
        if (bl) {
            return;
        }
        for (Direction direction : Direction.values()) {
            world.func_195593_d(blockPos.func_177972_a(direction), this);
        }
    }

    @Override
    public int func_180656_a(BlockState blockState, IBlockReader iBlockReader, BlockPos blockPos, Direction direction) {
        if (blockState.func_177229_b(field_196528_a).booleanValue() && Direction.UP != direction) {
            return 15;
        }
        return 0;
    }

    protected boolean func_176597_g(World world, BlockPos blockPos, BlockState blockState) {
        return world.func_175709_b(blockPos.func_177977_b(), Direction.DOWN);
    }

    @Override
    public void func_196267_b(BlockState blockState, World world, BlockPos blockPos, Random random) {
        RedstoneTorchBlock.func_196527_a(blockState, world, blockPos, random, this.func_176597_g(world, blockPos, blockState));
    }

    public static void func_196527_a(BlockState blockState, World world, BlockPos blockPos, Random random, boolean bl) {
        List<Toggle> list = field_196529_b.get(world);
        while (list != null && !list.isEmpty() && world.func_82737_E() - list.get(0).field_150844_d > 60L) {
            list.remove(0);
        }
        if (blockState.func_177229_b(field_196528_a).booleanValue()) {
            if (bl) {
                world.func_180501_a(blockPos, (BlockState)blockState.func_206870_a(field_196528_a, false), 3);
                if (RedstoneTorchBlock.func_176598_a(world, blockPos, true)) {
                    world.func_217379_c(1502, blockPos, 0);
                    world.func_205220_G_().func_205360_a(blockPos, world.func_180495_p(blockPos).func_177230_c(), 160);
                }
            }
        } else if (!bl && !RedstoneTorchBlock.func_176598_a(world, blockPos, false)) {
            world.func_180501_a(blockPos, (BlockState)blockState.func_206870_a(field_196528_a, true), 3);
        }
    }

    @Override
    public void func_220069_a(BlockState blockState, World world, BlockPos blockPos, Block block, BlockPos blockPos2, boolean bl) {
        if (blockState.func_177229_b(field_196528_a).booleanValue() == this.func_176597_g(world, blockPos, blockState) && !world.func_205220_G_().func_205361_b(blockPos, this)) {
            world.func_205220_G_().func_205360_a(blockPos, this, this.func_149738_a(world));
        }
    }

    @Override
    public int func_176211_b(BlockState blockState, IBlockReader iBlockReader, BlockPos blockPos, Direction direction) {
        if (direction == Direction.DOWN) {
            return blockState.func_185911_a(iBlockReader, blockPos, direction);
        }
        return 0;
    }

    @Override
    public boolean func_149744_f(BlockState blockState) {
        return true;
    }

    @Override
    public void func_180655_c(BlockState blockState, World world, BlockPos blockPos, Random random) {
        if (!blockState.func_177229_b(field_196528_a).booleanValue()) {
            return;
        }
        double d = (double)blockPos.func_177958_n() + 0.5 + (random.nextDouble() - 0.5) * 0.2;
        \u2603 = (double)blockPos.func_177956_o() + 0.7 + (random.nextDouble() - 0.5) * 0.2;
        \u2603 = (double)blockPos.func_177952_p() + 0.5 + (random.nextDouble() - 0.5) * 0.2;
        world.func_195594_a(RedstoneParticleData.field_197564_a, d, \u2603, \u2603, 0.0, 0.0, 0.0);
    }

    @Override
    public int func_149750_m(BlockState blockState) {
        return blockState.func_177229_b(field_196528_a) != false ? super.func_149750_m(blockState) : 0;
    }

    @Override
    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(field_196528_a);
    }

    private static boolean func_176598_a(World world, BlockPos blockPos, boolean bl) {
        List list = field_196529_b.computeIfAbsent(world, iBlockReader -> Lists.newArrayList());
        if (bl) {
            list.add(new Toggle(blockPos.func_185334_h(), world.func_82737_E()));
        }
        int \u26032 = 0;
        for (int i = 0; i < list.size(); ++i) {
            Toggle toggle = (Toggle)list.get(i);
            if (!toggle.field_180111_a.equals(blockPos) || ++\u26032 < 8) continue;
            return true;
        }
        return false;
    }

    public static class Toggle {
        private final BlockPos field_180111_a;
        private final long field_150844_d;

        public Toggle(BlockPos blockPos, long l) {
            this.field_180111_a = blockPos;
            this.field_150844_d = l;
        }
    }
}

