/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.block;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.HorizontalFaceBlock;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.particles.RedstoneParticleData;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.AttachFace;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;

public class LeverBlock
extends HorizontalFaceBlock {
    public static final BooleanProperty field_176359_b = BlockStateProperties.field_208194_u;
    protected static final VoxelShape field_185692_c = Block.func_208617_a(5.0, 4.0, 10.0, 11.0, 12.0, 16.0);
    protected static final VoxelShape field_185693_d = Block.func_208617_a(5.0, 4.0, 0.0, 11.0, 12.0, 6.0);
    protected static final VoxelShape field_185694_e = Block.func_208617_a(10.0, 4.0, 5.0, 16.0, 12.0, 11.0);
    protected static final VoxelShape field_185695_f = Block.func_208617_a(0.0, 4.0, 5.0, 6.0, 12.0, 11.0);
    protected static final VoxelShape field_209348_r = Block.func_208617_a(5.0, 0.0, 4.0, 11.0, 6.0, 12.0);
    protected static final VoxelShape field_209349_s = Block.func_208617_a(4.0, 0.0, 5.0, 12.0, 6.0, 11.0);
    protected static final VoxelShape field_209350_t = Block.func_208617_a(5.0, 10.0, 4.0, 11.0, 16.0, 12.0);
    protected static final VoxelShape field_209351_u = Block.func_208617_a(4.0, 10.0, 5.0, 12.0, 16.0, 11.0);

    protected LeverBlock(Block.Properties properties) {
        super(properties);
        this.func_180632_j((BlockState)((BlockState)((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a(field_185512_D, Direction.NORTH)).func_206870_a(field_176359_b, false)).func_206870_a(field_196366_M, AttachFace.WALL));
    }

    @Override
    public VoxelShape func_220053_a(BlockState blockState, IBlockReader iBlockReader, BlockPos blockPos, ISelectionContext iSelectionContext) {
        switch ((AttachFace)blockState.func_177229_b(field_196366_M)) {
            case FLOOR: {
                switch (blockState.func_177229_b(field_185512_D).func_176740_k()) {
                    case X: {
                        return field_209349_s;
                    }
                }
                return field_209348_r;
            }
            case WALL: {
                switch (blockState.func_177229_b(field_185512_D)) {
                    case EAST: {
                        return field_185695_f;
                    }
                    case WEST: {
                        return field_185694_e;
                    }
                    case SOUTH: {
                        return field_185693_d;
                    }
                }
                return field_185692_c;
            }
        }
        switch (blockState.func_177229_b(field_185512_D).func_176740_k()) {
            case X: {
                return field_209351_u;
            }
        }
        return field_209350_t;
    }

    @Override
    public boolean func_220051_a(BlockState blockState2, World world, BlockPos blockPos, PlayerEntity playerEntity, Hand hand, BlockRayTraceResult blockRayTraceResult) {
        BlockState blockState2 = (BlockState)blockState2.func_177231_a(field_176359_b);
        boolean \u26032 = blockState2.func_177229_b(field_176359_b);
        if (world.field_72995_K) {
            if (\u26032) {
                LeverBlock.func_196379_a(blockState2, world, blockPos, 1.0f);
            }
            return true;
        }
        world.func_180501_a(blockPos, blockState2, 3);
        float \u26033 = \u26032 ? 0.6f : 0.5f;
        world.func_184133_a(null, blockPos, SoundEvents.field_187750_dc, SoundCategory.BLOCKS, 0.3f, \u26033);
        this.func_196378_d(blockState2, world, blockPos);
        return true;
    }

    private static void func_196379_a(BlockState blockState, IWorld iWorld, BlockPos blockPos, float f) {
        Direction direction = blockState.func_177229_b(field_185512_D).func_176734_d();
        \u2603 = LeverBlock.func_196365_i(blockState).func_176734_d();
        double \u26032 = (double)blockPos.func_177958_n() + 0.5 + 0.1 * (double)direction.func_82601_c() + 0.2 * (double)\u2603.func_82601_c();
        double \u26033 = (double)blockPos.func_177956_o() + 0.5 + 0.1 * (double)direction.func_96559_d() + 0.2 * (double)\u2603.func_96559_d();
        double \u26034 = (double)blockPos.func_177952_p() + 0.5 + 0.1 * (double)direction.func_82599_e() + 0.2 * (double)\u2603.func_82599_e();
        iWorld.func_195594_a(new RedstoneParticleData(1.0f, 0.0f, 0.0f, f), \u26032, \u26033, \u26034, 0.0, 0.0, 0.0);
    }

    @Override
    public void func_180655_c(BlockState blockState, World world, BlockPos blockPos, Random random) {
        if (blockState.func_177229_b(field_176359_b).booleanValue() && random.nextFloat() < 0.25f) {
            LeverBlock.func_196379_a(blockState, world, blockPos, 0.5f);
        }
    }

    @Override
    public void func_196243_a(BlockState blockState, World world, BlockPos blockPos, BlockState blockState2, boolean bl) {
        if (bl || blockState.func_177230_c() == blockState2.func_177230_c()) {
            return;
        }
        if (blockState.func_177229_b(field_176359_b).booleanValue()) {
            this.func_196378_d(blockState, world, blockPos);
        }
        super.func_196243_a(blockState, world, blockPos, blockState2, bl);
    }

    @Override
    public int func_180656_a(BlockState blockState, IBlockReader iBlockReader, BlockPos blockPos, Direction direction) {
        return blockState.func_177229_b(field_176359_b) != false ? 15 : 0;
    }

    @Override
    public int func_176211_b(BlockState blockState, IBlockReader iBlockReader, BlockPos blockPos, Direction direction) {
        if (blockState.func_177229_b(field_176359_b).booleanValue() && LeverBlock.func_196365_i(blockState) == direction) {
            return 15;
        }
        return 0;
    }

    @Override
    public boolean func_149744_f(BlockState blockState) {
        return true;
    }

    private void func_196378_d(BlockState blockState, World world, BlockPos blockPos) {
        world.func_195593_d(blockPos, this);
        world.func_195593_d(blockPos.func_177972_a(LeverBlock.func_196365_i(blockState).func_176734_d()), this);
    }

    @Override
    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(field_196366_M, field_185512_D, field_176359_b);
    }
}

